// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class AppLocalizationsBn extends AppLocalizations {
  AppLocalizationsBn([String locale = 'bn']) : super(locale);

  @override
  String get appTitle => 'রানিং সার্ভিসেস মনিটর';

  @override
  String get enjoyingApp =>
      'অ্যাপটি ভালো লাগছে? আমাকে এক কাপ কফি কিনে দিতে পারেন!';

  @override
  String get donate => 'দান করুন';

  @override
  String get searchApps => 'অ্যাপ খুঁজুন...';

  @override
  String get all => 'সব';

  @override
  String get user => 'ইউজার';

  @override
  String get system => 'সিস্টেম';

  @override
  String get closeSearch => 'অনুসন্ধান বন্ধ করুন';

  @override
  String get search => 'অনুসন্ধান';

  @override
  String get autoUpdate => 'অটো-আপডেট (৩ সেকেন্ড)';

  @override
  String get refresh => 'রিফ্রেশ';

  @override
  String get toggleTheme => 'থিম পরিবর্তন করুন';

  @override
  String get about => 'সম্পর্কে';

  @override
  String get loading => 'লোড হচ্ছে...';

  @override
  String get developer => 'ডেভেলপার';

  @override
  String get email => 'ইমেল';

  @override
  String get sourceCode => 'সোর্স কোড';

  @override
  String get blogs => 'ব্লগ';

  @override
  String get buyMeCoffee => 'বাই মি আ কফি';

  @override
  String get madeInBangladesh => 'বাংলাদেশে তৈরি';

  @override
  String get runningApp => 'চলমান অ্যাপ';

  @override
  String get stopWarning =>
      'এই অ্যাপটি নিরাপদে বন্ধ করা যাবে না। আপনি এটি বন্ধ করলে আপনার বর্তমান কাজের কিছু অংশ হারাতে পারেন।';

  @override
  String get activeServices => 'সক্রিয় সার্ভিসসমূহ';

  @override
  String get shizukuRequired => 'শিজুকু প্রয়োজন';

  @override
  String get shizukuRequiredMessage =>
      'রানিং সার্ভিসেস তথ্য অ্যাক্সেস করতে এই অ্যাপটির শিজুকু প্রয়োজন।';

  @override
  String get setupSteps => 'সেটআপ ধাপসমূহ:';

  @override
  String get step1 => 'প্লে স্টোর বা গিটহাব থেকে শিজুকু অ্যাপ ইনস্টল করুন';

  @override
  String get step2 => 'শিজুকু খুলুন এবং সার্ভিস চালু করুন';

  @override
  String get step3 => 'অ্যান্ড্রয়েড ১১+: ওয়্যারলেস ডিবাগিং ব্যবহার করুন';

  @override
  String get step4 =>
      'অ্যান্ড্রয়েড ১০ এবং তার নিচে: এডিবি এর মাধ্যমে পিসিতে সংযুক্ত করুন';

  @override
  String get step5 => 'এই অ্যাপে ফিরে আসুন এবং পুনরায় চেষ্টা করুন';

  @override
  String get quickStart => 'দ্রুত শুরু (অ্যান্ড্রয়েড ১১+)';

  @override
  String get quickStartSteps =>
      '১. ডেভেলপার অপশন চালু করুন\n২. ওয়্যারলেস ডিবাগিং চালু করুন\n৩. শিজুকু খুলুন এবং \"পেয়ার\" এ ট্যাপ করুন\n৪. স্ক্রিনে দেখানো নির্দেশাবলী অনুসরণ করুন';

  @override
  String get exitApp => 'অ্যাপ থেকে বের হন';

  @override
  String get retry => 'পুনরায় চেষ্টা করুন';

  @override
  String get loadingServices => 'সার্ভিস লোড হচ্ছে...';

  @override
  String get deviceMemory => 'ডিভাইস মেমোরি';

  @override
  String get noMatchingApps => 'কোনো অ্যাপ পাওয়া যায়নি';

  @override
  String get noAppsFound => 'কোনো অ্যাপ পাওয়া যায়নি';

  @override
  String get ofRam => 'র‍্যাম এর';

  @override
  String get processAnd => 'প্রসেস এবং';

  @override
  String get services => 'সার্ভিস';

  @override
  String get apps => 'অ্যাপস';

  @override
  String get used => 'ব্যবহৃত';

  @override
  String get free => 'ফাঁকা';

  @override
  String get stopService => 'সার্ভিস বন্ধ করুন';

  @override
  String get stopAllServices => 'সব সার্ভিস বন্ধ করুন';

  @override
  String get stopServiceConfirm => 'এই সার্ভিস বন্ধ করবেন?';

  @override
  String get stopAllServicesConfirm => 'এই অ্যাপের সব সার্ভিস বন্ধ করবেন?';

  @override
  String get stopServiceWarning =>
      'এটি অ্যাপটি জোরপূর্বক বন্ধ করবে। আপনি সংরক্ষণ না করা ডেটা হারাতে পারেন।';

  @override
  String get serviceStopped => 'সার্ভিস বন্ধ হয়েছে';

  @override
  String get allServicesStopped => 'সব সার্ভিস বন্ধ হয়েছে';

  @override
  String get stopServiceError => 'সার্ভিস বন্ধ করতে ব্যর্থ';

  @override
  String get cancel => 'বাতিল';

  @override
  String get stop => 'বন্ধ করুন';

  @override
  String get permissionRequired => 'অনুমতি প্রয়োজন';

  @override
  String get permissionRequiredMessage =>
      'রানিং সার্ভিসেস তথ্য অ্যাক্সেস করতে শিজুকু অনুমতি প্রয়োজন।';

  @override
  String get permissionSteps => 'কিভাবে অনুমতি দিবেন:';

  @override
  String get permissionStep1 => 'শিজুকু অ্যাপ খুলুন';

  @override
  String get permissionStep2 => '\'অনুমোদিত অ্যাপস\' বা \'অনুমতি\' এ যান';

  @override
  String get permissionStep3 =>
      '\'রানিং সার্ভিসেস মনিটর\' খুঁজুন এবং অনুমতি দিন';

  @override
  String get permissionNote =>
      'অনুমতি দেওয়ার আগে নিশ্চিত করুন যে শিজুকু সার্ভিস চলছে।';

  @override
  String get openShizuku => 'শিজুকু খুলুন';

  @override
  String get systemAppWarning =>
      '⚠️ সতর্কতা: এটি একটি সিস্টেম অ্যাপ। এটি বন্ধ করলে আপনার ডিভাইস ত্রুটিপূর্ণ বা অস্থিতিশীল হতে পারে। শুধুমাত্র তখনই এগিয়ে যান যদি আপনি জানেন আপনি কী করছেন!';

  @override
  String get runningServicesTitle => 'রানিং সার্ভিসেস';

  @override
  String get openRunningServicesTooltip =>
      'অ্যান্ড্রয়েড সেটিংসে রানিং সার্ভিসেস খুলুন';

  @override
  String get error => 'ত্রুটি';

  @override
  String get appInfoNotFound => 'অ্যাপের তথ্য পাওয়া যায়নি';

  @override
  String pageNotFound(String location) {
    return 'পৃষ্ঠা পাওয়া যায়নি: $location';
  }

  @override
  String get package => 'প্যাকেজ';

  @override
  String get service => 'সার্ভিস';

  @override
  String get process => 'প্রসেস';

  @override
  String get pid => 'পিআইডি';

  @override
  String get uid => 'ইউআইডি';

  @override
  String get ramUsage => 'র‍্যাম ব্যবহার';

  @override
  String get intent => 'ইনটেন্ট';

  @override
  String get foreground => 'ফোরগ্রাউন্ড';

  @override
  String get foregroundId => 'ফোরগ্রাউন্ড আইডি';

  @override
  String get startRequested => 'স্টার্ট রিকোয়েস্টেড';

  @override
  String get createdFromFg => 'ফোরগ্রাউন্ড থেকে তৈরি';

  @override
  String get createTime => 'তৈরির সময়';

  @override
  String get lastActivity => 'সর্বশেষ অ্যাক্টিভিটি';

  @override
  String get baseDir => 'বেস ডিরেক্টরি';

  @override
  String get dataDir => 'ডেটা ডিরেক্টরি';

  @override
  String get type => 'ধরন';

  @override
  String get systemApp => 'সিস্টেম অ্যাপ';

  @override
  String get userApp => 'ব্যবহারকারী অ্যাপ';

  @override
  String get rawOutput => 'র আউটপুট';

  @override
  String get close => 'বন্ধ করুন';

  @override
  String get yes => 'হ্যাঁ';

  @override
  String get no => 'না';

  @override
  String get connections => 'কানেকশনসমূহ';

  @override
  String get flags => 'ফ্ল্যাগস';

  @override
  String get bound => 'বাঁধা';

  @override
  String get processRecord => 'প্রক্রিয়া রেকর্ড';

  @override
  String get visible => 'দৃশ্যমান';

  @override
  String get capabilities => 'ক্যাপাবিলিটিস';

  @override
  String get active => 'সক্রিয়';

  @override
  String get cached => 'ক্যাশড';

  @override
  String get noServicesFound => 'কোনো সার্ভিস পাওয়া যায়নি';

  @override
  String get ramCalculation => 'র‍্যাম হিসাব';

  @override
  String get totalRam => 'মোট র‍্যাম';

  @override
  String get ramSources => 'সোর্সসমূহ';

  @override
  String get noRamDataAvailable =>
      'এই অ্যাপের জন্য সিস্টেম মেমোরি রিপোর্টে কোনো র‍্যাম ডেটা নেই।';

  @override
  String get ramCalculationExplanation =>
      'র‍্যাম সিস্টেম মেমোরি তথ্য থেকে গণনা করা হয়। PID = প্রসেস আইডি লুকআপ, Process = প্রসেস নাম লুকআপ, LRU = সাম্প্রতিক প্রসেস তালিকা।';

  @override
  String get playCommand => 'কমান্ড চালান';

  @override
  String get copiedToClipboard => 'ক্লিপবোর্ডে কপি হয়েছে';

  @override
  String get copy => 'কপি';

  @override
  String get and => 'এবং';

  @override
  String service_string(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count সার্ভিসগুলো',
      one: '1 সার্ভিস',
    );
    return '$_temp0';
  }

  @override
  String process_string(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count প্রক্রিয়াগুলো',
      one: '1 প্রক্রিয়া',
    );
    return '$_temp0';
  }

  @override
  String service_process_string(int serviceCount, int processCount) {
    String _temp0 = intl.Intl.pluralLogic(
      processCount,
      locale: localeName,
      other: '$processCount প্রক্রিয়াগুলো',
      one: '1 প্রক্রিয়া',
    );
    String _temp1 = intl.Intl.pluralLogic(
      serviceCount,
      locale: localeName,
      other: '$serviceCount সার্ভিসগুলো',
      one: '1 সার্ভিস',
    );
    return '$_temp0 এবং $_temp1';
  }

  @override
  String get info => 'তথ্য';

  @override
  String get followSystem => 'সিস্টেম';

  @override
  String get contributors => 'অবদানকারী';

  @override
  String contributionsCount(Object count) {
    return '$count অবদান';
  }

  @override
  String get checkingPermissions => 'অনুমতি যাচাই করা হচ্ছে...';

  @override
  String get shizukuNotRunning =>
      'শিজুকু চলছে না। অনুগ্রহ করে শিজুকু অ্যাপ চালু করুন।';

  @override
  String get permissionDeniedShizuku =>
      'অনুমতি অস্বীকার করা হয়েছে। অনুগ্রহ করে শিজুকু অনুমতি দিন।';

  @override
  String get failedToInitialize =>
      'ইনিশিয়ালাইজ করতে ব্যর্থ। অনুগ্রহ করে অনুমতি দিন।';

  @override
  String get errorInitializingShizuku => 'শিজুকু ইনিশিয়ালাইজ করতে ত্রুটি';

  @override
  String get loadingApps => 'অ্যাপস লোড হচ্ছে...';

  @override
  String get refreshedSuccessfully => 'সফলভাবে রিফ্রেশ হয়েছে';

  @override
  String get errorLoadingData => 'ডেটা লোড করতে ত্রুটি';

  @override
  String get failedToStopAllServices => 'সব সার্ভিস বন্ধ করতে ব্যর্থ';

  @override
  String failedToStopServiceName(String serviceName) {
    return '$serviceName সার্ভিস বন্ধ করতে ব্যর্থ';
  }

  @override
  String errorPrefix(String error) {
    return 'ত্রুটি: $error';
  }

  @override
  String get language => 'ভাষা';

  @override
  String get openGithubProfile => 'গিটহাব প্রোফাইল খুলুন';

  @override
  String get appInfoTooltip => 'অ্যাপ তথ্য';

  @override
  String get ok => 'ঠিক আছে';

  @override
  String get recentCallingUid => 'সাম্প্রতিক কলিং UID';

  @override
  String get appDetails => 'অ্যাপ বিস্তারিত';

  @override
  String uidLabel(int uid) {
    return 'UID: $uid';
  }

  @override
  String get processStateTitle => 'প্রসেস স্টেট';

  @override
  String get processStateFg =>
      'ফোরগ্রাউন্ড - অ্যাপটি বর্তমানে ফোরগ্রাউন্ডে আছে';

  @override
  String get processStateVis =>
      'ভিজিবল - অ্যাপের একটি দৃশ্যমান অ্যাক্টিভিটি আছে কিন্তু ফোরগ্রাউন্ডে নয়';

  @override
  String get processStatePrev =>
      'পূর্ববর্তী - পূর্বে ব্যবহৃত ফোরগ্রাউন্ড অ্যাপ';

  @override
  String get processStatePrcp =>
      'পার্সেপটিবল - অ্যাপ এমন কিছু করছে যা ব্যবহারকারী জানে';

  @override
  String get processStateSvcb => 'সার্ভিস B - অ্যাপের একটি বাউন্ড সার্ভিস আছে';

  @override
  String get processStateHome => 'হোম - হোম/লঞ্চার অ্যাপ';

  @override
  String get processStateHvy => 'হেভি ওয়েট - ভারী ওজনের অ্যাপ প্রসেস';

  @override
  String get processStatePsvc =>
      'পার্সিস্ট্যান্ট সার্ভিস - অ্যাপের একটি স্থায়ী সার্ভিস আছে';

  @override
  String get processStatePers => 'পার্সিস্ট্যান্ট - সিস্টেম স্থায়ী প্রসেস';

  @override
  String get processStateCchEmpty =>
      'ক্যাশড এম্পটি - কোনো অ্যাক্টিভিটি ছাড়া ক্যাশড প্রসেস';

  @override
  String get processStateCchAct =>
      'ক্যাশড অ্যাক্টিভিটি - অ্যাক্টিভিটি সহ ক্যাশড প্রসেস';

  @override
  String get processStateCchClient =>
      'ক্যাশড ক্লায়েন্ট - সার্ভিস ক্লায়েন্ট হিসেবে ক্যাশড প্রসেস';

  @override
  String get processStateCch => 'ক্যাশড - প্রসেস মেমোরিতে ক্যাশড';

  @override
  String get processStateBfgs =>
      'বাউন্ড ফোরগ্রাউন্ড সার্ভিস - একটি ফোরগ্রাউন্ড সার্ভিসে বাউন্ড';

  @override
  String get processStateRcvr =>
      'রিসিভার - অ্যাপ একটি ব্রডকাস্ট রিসিভার চালাচ্ছে';

  @override
  String get processStateTop => 'টপ - অ্যাপ অ্যাক্টিভিটি স্ট্যাকের শীর্ষে আছে';

  @override
  String get processStateBtop => 'বাউন্ড টপ - একটি টপ অ্যাপে বাউন্ড';

  @override
  String get processStateImpf =>
      'ইম্পর্ট্যান্ট ফোরগ্রাউন্ড - গুরুত্বপূর্ণ ফোরগ্রাউন্ড প্রসেস';

  @override
  String get processStateImpb =>
      'ইম্পর্ট্যান্ট ব্যাকগ্রাউন্ড - গুরুত্বপূর্ণ ব্যাকগ্রাউন্ড প্রসেস';

  @override
  String processStateUnknown(String state) {
    return 'প্রসেস স্টেট: $state';
  }

  @override
  String get workingMode => 'ওয়ার্কিং মোড';

  @override
  String get rootMode => 'রুট';

  @override
  String get shizukuMode => 'শিজুকু';

  @override
  String get selectWorkingMode => 'ওয়ার্কিং মোড নির্বাচন করুন';

  @override
  String get available => 'উপলব্ধ';

  @override
  String get notAvailable => 'অনুপলব্ধ';

  @override
  String get modeNotAvailable => 'এই মোড অনুপলব্ধ';

  @override
  String get noModeAvailable => 'কোনো পারমিশন মোড উপলব্ধ নেই';

  @override
  String get commandLogs => 'কমান্ড লগস';

  @override
  String get commandOutput => 'কমান্ড আউটপুট';

  @override
  String get noCommandLogs => 'এখনো কোনো কমান্ড কার্যকর হয়নি';

  @override
  String get clearLogs => 'লগ পরিষ্কার করুন';

  @override
  String get clearLogsConfirm => 'আপনি কি সব কমান্ড লগ পরিষ্কার করতে চান?';

  @override
  String get executedAt => 'কার্যকর হয়েছে';

  @override
  String get command => 'কমান্ড';

  @override
  String get noOutput => 'কোনো আউটপুট নেই';

  @override
  String get executeCommand => 'কার্যকর করুন';

  @override
  String get processes => 'প্রসেসগুলো';

  @override
  String get processesDescription =>
      'এই অ্যাপের জন্য মেমোরি তথ্য থেকে সব চলমান প্রসেস।';

  @override
  String get noProcessesFound => 'কোনো প্রসেস পাওয়া যায়নি';

  @override
  String get usedBreakdown => 'ব্যবহৃত ভাঙ্গন';

  @override
  String get freeBreakdown => 'ফাঁকা ভাঙ্গন';

  @override
  String get other => 'অন্যান্য';

  @override
  String get usedPss => 'ব্যবহৃত PSS';

  @override
  String get kernel => 'কার্নেল';

  @override
  String get cachedPss => 'ক্যাশড PSS';

  @override
  String get cachedKernel => 'ক্যাশড কার্নেল';

  @override
  String get actualFree => 'প্রকৃত ফাঁকা';

  @override
  String get gpu => 'GPU';

  @override
  String get lostRam => 'হারানো র‍্যাম';

  @override
  String get zramPhysical => 'ZRAM ফিজিক্যাল';

  @override
  String get zramSwapUsed => 'ZRAM সোয়াপ ব্যবহৃত';

  @override
  String get zramTotalSwap => 'ZRAM মোট সোয়াপ';

  @override
  String get oomThreshold => 'OOM থ্রেশহোল্ড';

  @override
  String get restoreLimit => 'পুনরুদ্ধার সীমা';

  @override
  String get zramSection => 'ZRAM';

  @override
  String get memoryThresholds => 'মেমোরি থ্রেশহোল্ড';

  @override
  String get boundServiceCannotStop =>
      'এই সার্ভিসটি অন্য একটি প্রসেসের সাথে বাউন্ড এবং সরাসরি বন্ধ করা যায় না। আপনি পুরো অ্যাপটি বন্ধ করতে পারেন।';

  @override
  String get memoryInfo => 'মেমরি ইনফো';

  @override
  String get viewRawOutput => 'র আউটপুট দেখুন';

  @override
  String get hideRawOutput => 'র আউটপুট লুকান';

  @override
  String get compareWithOther => 'তুলনা করুন';

  @override
  String get memoryCategories => 'মেমরি ক্যাটাগরি';

  @override
  String get appSummary => 'অ্যাপ সামারি';

  @override
  String get objects => 'অবজেক্টস';

  @override
  String get memoryComparison => 'মেমরি তুলনা';

  @override
  String get selectAppToCompare => 'তুলনা করার জন্য একটি অ্যাপ নির্বাচন করুন';

  @override
  String get selectApp => 'অ্যাপ নির্বাচন করুন...';

  @override
  String get totalPss => 'মোট PSS';

  @override
  String get totalRss => 'মোট RSS';

  @override
  String get javaHeap => 'জাভা হিপ';

  @override
  String get nativeHeap => 'নেটিভ হিপ';

  @override
  String get code => 'কোড';

  @override
  String get graphics => 'গ্রাফিক্স';

  @override
  String get current => 'বর্তমান';

  @override
  String get allApps => 'সব';

  @override
  String get userApps => 'ব্যবহারকারী';

  @override
  String get systemApps => 'সিস্টেম';

  @override
  String get compareWith => 'এর সাথে তুলনা করুন';

  @override
  String get stats => 'পরিসংখ্যান';

  @override
  String get statsLiveRamArea => 'লাইভ সিস্টেম র‍্যাম';

  @override
  String get statsLiveRamAreaSubtitle => 'সময়ের সাথে ব্যবহৃত র‍্যাম';

  @override
  String get statsRamDistribution => 'সিস্টেম র‍্যাম বিতরণ';

  @override
  String statsRamDistributionTotal(String size) {
    return 'মোট: $size';
  }

  @override
  String get statsRamLabel => 'র‍্যাম';

  @override
  String get statsZram => 'ZRAM';

  @override
  String get statsUserVsSystemRam => 'ইউজার বনাম সিস্টেম অ্যাপস র‍্যাম';

  @override
  String get statsAppStateDistribution => 'অ্যাপ স্টেট বিতরণ';

  @override
  String get statsActive => 'সক্রিয়';

  @override
  String get statsBackground => 'ব্যাকগ্রাউন্ড';

  @override
  String get statsCached => 'ক্যাশড';

  @override
  String statsAppsCount(int count) {
    return '$count অ্যাপস';
  }

  @override
  String get statsSystemVsUserAnalysis => 'সিস্টেম বনাম ইউজার বিশ্লেষণ';

  @override
  String get statsAppCount => 'অ্যাপ সংখ্যা';

  @override
  String get statsTotalRam => 'মোট র‍্যাম';

  @override
  String get statsPerformance => 'পারফরম্যান্স';

  @override
  String get statsRamDistributionScatter => 'র‍্যাম বিতরণ স্ক্যাটার';

  @override
  String get statsRamDistributionScatterSubtitle =>
      'Y: র‍্যাম, X: অ্যাপ ইনডেক্স';

  @override
  String get statsTopRamConsumers => 'শীর্ষ র‍্যাম ব্যবহারকারী';

  @override
  String get statsServicesVsRamCorrelation => 'সার্ভিস বনাম র‍্যাম সম্পর্ক';

  @override
  String get statsServicesVsRamSubtitle =>
      'Y: র‍্যাম, X: সার্ভিস সংখ্যা, বাবল: প্রসেস সংখ্যা';

  @override
  String get statsRamHistogram => 'র‍্যাম ফ্রিকোয়েন্সি হিস্টোগ্রাম';

  @override
  String get statsRamHistogramSubtitle => 'মেমোরি সাইজ অনুযায়ী অ্যাপ সংখ্যা';

  @override
  String get statsMemoryHeatmap => 'মেমোরি হিটম্যাপ';

  @override
  String get statsMemoryHeatmapSubtitle =>
      'র‍্যাম তীব্রতা অনুযায়ী সাজানো সব অ্যাপ';

  @override
  String get statsTopAppsRelativeImpact => 'শীর্ষ অ্যাপস আপেক্ষিক প্রভাব';

  @override
  String get statsGanttSubtitle =>
      'র‍্যাম শেয়ারের গ্যান্ট-স্টাইল ভিজ্যুয়ালাইজেশন';

  @override
  String get statsStackedAreaChart => 'সময়ের সাথে র‍্যাম ভাঙ্গন';

  @override
  String get statsStackedAreaSubtitle => 'ইউজার, সিস্টেম, এবং কার্নেল র‍্যাম';

  @override
  String get statsPolarChart => 'প্রসেস স্টেট বিতরণ';

  @override
  String get statsPolarSubtitle => 'অ্যাপ স্টেটের পোলার ভিউ';

  @override
  String get statsTreemap => 'র‍্যাম বিতরণ ট্রিম্যাপ';

  @override
  String get statsTreemapSubtitle => 'অ্যাপ অনুযায়ী আনুপাতিক র‍্যাম ব্যবহার';

  @override
  String get statsFunnelChart => 'র‍্যাম ব্যবহার স্তর';

  @override
  String get statsFunnelSubtitle => 'মেমোরি সাইজ অনুযায়ী গ্রুপ করা অ্যাপস';

  @override
  String get statsWaterfallChart => 'র‍্যাম বরাদ্দ ওয়াটারফল';

  @override
  String get statsWaterfallSubtitle => 'মোট থেকে কম্পোনেন্টে ভাঙ্গন';

  @override
  String get statsGaugeChart => 'র‍্যাম ব্যবহার গেজ';

  @override
  String get statsGaugeSubtitle => 'সামগ্রিক সিস্টেম মেমোরি ব্যবহার';

  @override
  String get statsTiny => 'ক্ষুদ্র';

  @override
  String get statsSmall => 'ছোট';

  @override
  String get statsMedium => 'মাঝারি';

  @override
  String get statsLarge => 'বড়';

  @override
  String get statsHuge => 'বিশাল';

  @override
  String get statsNoData => 'কোনো ডেটা উপলব্ধ নেই';

  @override
  String get statsWaitingForData => 'ডেটার জন্য অপেক্ষা করা হচ্ছে...';

  @override
  String get statsRamDistributionPie => 'সিস্টেম র‍্যাম বিতরণ';

  @override
  String get statsRamDistributionSubtitle => 'ব্যবহৃত, ফাঁকা, এবং ZRAM';

  @override
  String get statsUsed => 'ব্যবহৃত';

  @override
  String get statsFree => 'ফাঁকা';

  @override
  String get statsUserVsSystemPie => 'ইউজার বনাম সিস্টেম অ্যাপস র‍্যাম';

  @override
  String get statsUserVsSystemSubtitle =>
      'ইউজার এবং সিস্টেম অ্যাপ মেমোরি তুলনা';

  @override
  String get statsProcessStateBar => 'অ্যাপ স্টেট বিতরণ';

  @override
  String get statsProcessStateSubtitle =>
      'সক্রিয়, ব্যাকগ্রাউন্ড, এবং ক্যাশড অ্যাপস';

  @override
  String get statsScatterChart => 'র‍্যাম বিতরণ স্ক্যাটার';

  @override
  String get statsScatterSubtitle => 'Y: র‍্যাম (MB), X: অ্যাপ ইনডেক্স';

  @override
  String get core => 'কোর';

  @override
  String get coreAppInfoLimited =>
      'সিস্টেম প্রসেসের জন্য সীমিত তথ্য পাওয়া যাচ্ছে';

  @override
  String get showCoreApps => 'কোর প্রসেস দেখান';

  @override
  String get usefulCommands => 'দরকারী কমান্ড';

  @override
  String get commands => 'কমান্ড';

  @override
  String get addCommand => 'কমান্ড যোগ করুন';

  @override
  String get placeholders => 'প্লেসহোল্ডার';

  @override
  String get commandTitle => 'শিরোনাম';

  @override
  String get commandDescription => 'বিবরণ';

  @override
  String get reExecute => 'পুনরায় চালান';

  @override
  String get statsProcessVsRamLine => 'প্রসেস বনাম র‍্যাম সম্পর্ক';

  @override
  String get statsProcessVsRamLineSubtitle =>
      'নীল: র‍্যাম, ড্যাশড: প্রসেস সংখ্যা';

  @override
  String get statsUserVsSystemBar => 'ইউজার বনাম সিস্টেম বার';

  @override
  String get statsUserVsSystemBarSubtitle =>
      'অ্যাপ সংখ্যা, মোট র‍্যাম, গড় র‍্যাম';

  @override
  String get statsRamTrendScatter => 'র‍্যাম ট্রেন্ড স্ক্যাটার';

  @override
  String get statsRamTrendScatterSubtitle =>
      'সার্ভিস বনাম র‍্যাম ট্রেন্ড লাইন সহ';

  @override
  String get statsServicesVsProcesses => 'সার্ভিস বনাম প্রসেস';

  @override
  String get statsServicesVsProcessesSubtitle =>
      'X: প্রসেস সংখ্যা, Y: সার্ভিস সংখ্যা';

  @override
  String get statsProcessStateRam => 'প্রসেস স্টেট বনাম র‍্যাম';

  @override
  String get statsProcessStateRamSubtitle =>
      'স্টেট অনুযায়ী গড় র‍্যাম ব্যবহার';

  @override
  String get myCommands => 'আমার কমান্ড';

  @override
  String get defaultCommands => 'ডিফল্ট কমান্ড';

  @override
  String get resetDefaults => 'ডিফল্ট রিসেট করুন';
}
