// Autogenerated from Pigeon (v26.1.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package me.biplobsd.rsm

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object ShizukuApiPigeonUtils {

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).contains(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

/** Generated class from Pigeon that represents data sent in messages. */
data class CommandRequest (
  val command: String,
  val mode: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): CommandRequest {
      val command = pigeonVar_list[0] as String
      val mode = pigeonVar_list[1] as String?
      return CommandRequest(command, mode)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      command,
      mode,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is CommandRequest) {
      return false
    }
    if (this === other) {
      return true
    }
    return ShizukuApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class CommandResult (
  val exitCode: Long? = null,
  val output: String? = null,
  val error: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): CommandResult {
      val exitCode = pigeonVar_list[0] as Long?
      val output = pigeonVar_list[1] as String?
      val error = pigeonVar_list[2] as String?
      return CommandResult(exitCode, output, error)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      exitCode,
      output,
      error,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is CommandResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return ShizukuApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class ShizukuApiPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          CommandRequest.fromList(it)
        }
      }
      130.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          CommandResult.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is CommandRequest -> {
        stream.write(129)
        writeValue(stream, value.toList())
      }
      is CommandResult -> {
        stream.write(130)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

val ShizukuApiPigeonMethodCodec = StandardMethodCodec(ShizukuApiPigeonCodec())


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface ShizukuHostApi {
  fun runCommand(request: CommandRequest, callback: (Result<CommandResult>) -> Unit)
  fun pingBinder(): Boolean
  fun checkRootPermission(callback: (Result<Boolean>) -> Unit)
  fun requestRootPermission(callback: (Result<Boolean>) -> Unit)
  fun checkPermission(): Boolean
  fun requestPermission(callback: (Result<Boolean>) -> Unit)
  fun setStreamCommand(command: String, mode: String?)

  companion object {
    /** The codec used by ShizukuHostApi. */
    val codec: MessageCodec<Any?> by lazy {
      ShizukuApiPigeonCodec()
    }
    /** Sets up an instance of `ShizukuHostApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: ShizukuHostApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.runCommand$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestArg = args[0] as CommandRequest
            api.runCommand(requestArg) { result: Result<CommandResult> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ShizukuApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ShizukuApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.pingBinder$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.pingBinder())
            } catch (exception: Throwable) {
              ShizukuApiPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.checkRootPermission$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.checkRootPermission{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ShizukuApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ShizukuApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.requestRootPermission$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.requestRootPermission{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ShizukuApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ShizukuApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.checkPermission$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> = try {
              listOf(api.checkPermission())
            } catch (exception: Throwable) {
              ShizukuApiPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.requestPermission$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.requestPermission{ result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(ShizukuApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(ShizukuApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.running_services_monitor.ShizukuHostApi.setStreamCommand$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val commandArg = args[0] as String
            val modeArg = args[1] as String?
            val wrapped: List<Any?> = try {
              api.setStreamCommand(commandArg, modeArg)
              listOf(null)
            } catch (exception: Throwable) {
              ShizukuApiPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}

private class ShizukuApiPigeonStreamHandler<T>(
    val wrapper: ShizukuApiPigeonEventChannelWrapper<T>
) : EventChannel.StreamHandler {
  var pigeonSink: PigeonEventSink<T>? = null

  override fun onListen(p0: Any?, sink: EventChannel.EventSink) {
    pigeonSink = PigeonEventSink<T>(sink)
    wrapper.onListen(p0, pigeonSink!!)
  }

  override fun onCancel(p0: Any?) {
    pigeonSink = null
    wrapper.onCancel(p0)
  }
}

interface ShizukuApiPigeonEventChannelWrapper<T> {
  open fun onListen(p0: Any?, sink: PigeonEventSink<T>) {}

  open fun onCancel(p0: Any?) {}
}

class PigeonEventSink<T>(private val sink: EventChannel.EventSink) {
  fun success(value: T) {
    sink.success(value)
  }

  fun error(errorCode: String, errorMessage: String?, errorDetails: Any?) {
    sink.error(errorCode, errorMessage, errorDetails)
  }

  fun endOfStream() {
    sink.endOfStream()
  }
}
      
abstract class StreamOutputStreamHandler : ShizukuApiPigeonEventChannelWrapper<String> {
  companion object {
    fun register(messenger: BinaryMessenger, streamHandler: StreamOutputStreamHandler, instanceName: String = "") {
      var channelName: String = "dev.flutter.pigeon.running_services_monitor.ShizukuStreamApi.streamOutput"
      if (instanceName.isNotEmpty()) {
        channelName += ".$instanceName"
      }
      val internalStreamHandler = ShizukuApiPigeonStreamHandler<String>(streamHandler)
      EventChannel(messenger, channelName, ShizukuApiPigeonMethodCodec).setStreamHandler(internalStreamHandler)
    }
  }
}
      
