// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bengali Bangla (`bn`).
class AppLocalizationsBn extends AppLocalizations {
  AppLocalizationsBn([String locale = 'bn']) : super(locale);

  @override
  String get appTitle => 'রানিং সার্ভিসেস মনিটর';

  @override
  String get enjoyingApp =>
      'অ্যাপটি ভালো লাগছে? আমাকে এক কাপ কফি কিনে দিতে পারেন!';

  @override
  String get donate => 'দান করুন';

  @override
  String get searchApps => 'অ্যাপ খুঁজুন...';

  @override
  String get all => 'সব';

  @override
  String get user => 'ইউজার';

  @override
  String get system => 'সিস্টেম';

  @override
  String get closeSearch => 'অনুসন্ধান বন্ধ করুন';

  @override
  String get search => 'অনুসন্ধান';

  @override
  String get autoUpdate => 'অটো-আপডেট (৩ সেকেন্ড)';

  @override
  String get refresh => 'রিফ্রেশ';

  @override
  String get toggleTheme => 'থিম পরিবর্তন করুন';

  @override
  String get about => 'সম্পর্কে';

  @override
  String get loading => 'লোড হচ্ছে...';

  @override
  String get developer => 'ডেভেলপার';

  @override
  String get email => 'ইমেল';

  @override
  String get sourceCode => 'সোর্স কোড';

  @override
  String get blogs => 'ব্লগ';

  @override
  String get buyMeCoffee => 'বাই মি আ কফি';

  @override
  String get madeInBangladesh => 'বাংলাদেশে তৈরি';

  @override
  String get runningApp => 'চলমান অ্যাপ';

  @override
  String get stopWarning =>
      'এই অ্যাপটি নিরাপদে বন্ধ করা যাবে না। আপনি এটি বন্ধ করলে আপনার বর্তমান কাজের কিছু অংশ হারাতে পারেন।';

  @override
  String get activeServices => 'সক্রিয় সার্ভিসসমূহ';

  @override
  String get shizukuRequired => 'শিজুকু প্রয়োজন';

  @override
  String get shizukuRequiredMessage =>
      'রানিং সার্ভিসেস তথ্য অ্যাক্সেস করতে এই অ্যাপটির শিজুকু প্রয়োজন।';

  @override
  String get setupSteps => 'সেটআপ ধাপসমূহ:';

  @override
  String get step1 => 'প্লে স্টোর বা গিটহাব থেকে শিজুকু অ্যাপ ইনস্টল করুন';

  @override
  String get step2 => 'শিজুকু খুলুন এবং সার্ভিস চালু করুন';

  @override
  String get step3 => 'অ্যান্ড্রয়েড ১১+: ওয়্যারলেস ডিবাগিং ব্যবহার করুন';

  @override
  String get step4 =>
      'অ্যান্ড্রয়েড ১০ এবং তার নিচে: এডিবি এর মাধ্যমে পিসিতে সংযুক্ত করুন';

  @override
  String get step5 => 'এই অ্যাপে ফিরে আসুন এবং পুনরায় চেষ্টা করুন';

  @override
  String get quickStart => 'দ্রুত শুরু (অ্যান্ড্রয়েড ১১+)';

  @override
  String get quickStartSteps =>
      '১. ডেভেলপার অপশন চালু করুন\n২. ওয়্যারলেস ডিবাগিং চালু করুন\n৩. শিজুকু খুলুন এবং \"পেয়ার\" এ ট্যাপ করুন\n৪. স্ক্রিনে দেখানো নির্দেশাবলী অনুসরণ করুন';

  @override
  String get exitApp => 'অ্যাপ থেকে বের হন';

  @override
  String get retry => 'পুনরায় চেষ্টা করুন';

  @override
  String get loadingServices => 'সার্ভিস লোড হচ্ছে...';

  @override
  String get deviceMemory => 'ডিভাইস মেমোরি';

  @override
  String get noMatchingApps => 'কোনো অ্যাপ পাওয়া যায়নি';

  @override
  String get noAppsFound => 'কোনো অ্যাপ পাওয়া যায়নি';

  @override
  String get ofRam => 'র‍্যাম এর';

  @override
  String get processAnd => 'প্রসেস এবং';

  @override
  String get services => 'সার্ভিস';

  @override
  String get apps => 'অ্যাপস';

  @override
  String get used => 'ব্যবহৃত';

  @override
  String get free => 'ফাঁকা';

  @override
  String get stopService => 'সার্ভিস বন্ধ করুন';

  @override
  String get stopAllServices => 'সব সার্ভিস বন্ধ করুন';

  @override
  String get stopServiceConfirm => 'এই সার্ভিস বন্ধ করবেন?';

  @override
  String get stopAllServicesConfirm => 'এই অ্যাপের সব সার্ভিস বন্ধ করবেন?';

  @override
  String get stopServiceWarning =>
      'এটি অ্যাপটি জোরপূর্বক বন্ধ করবে। আপনি সংরক্ষণ না করা ডেটা হারাতে পারেন।';

  @override
  String get serviceStopped => 'সার্ভিস বন্ধ হয়েছে';

  @override
  String get allServicesStopped => 'সব সার্ভিস বন্ধ হয়েছে';

  @override
  String get stopServiceError => 'সার্ভিস বন্ধ করতে ব্যর্থ';

  @override
  String get cancel => 'বাতিল';

  @override
  String get stop => 'বন্ধ করুন';

  @override
  String get permissionRequired => 'অনুমতি প্রয়োজন';

  @override
  String get permissionRequiredMessage =>
      'রানিং সার্ভিসেস তথ্য অ্যাক্সেস করতে শিজুকু অনুমতি প্রয়োজন।';

  @override
  String get permissionSteps => 'কিভাবে অনুমতি দিবেন:';

  @override
  String get permissionStep1 => 'শিজুকু অ্যাপ খুলুন';

  @override
  String get permissionStep2 => '\'অনুমোদিত অ্যাপস\' বা \'অনুমতি\' এ যান';

  @override
  String get permissionStep3 =>
      '\'রানিং সার্ভিসেস মনিটর\' খুঁজুন এবং অনুমতি দিন';

  @override
  String get permissionNote =>
      'অনুমতি দেওয়ার আগে নিশ্চিত করুন যে শিজুকু সার্ভিস চলছে।';

  @override
  String get openShizuku => 'শিজুকু খুলুন';

  @override
  String get systemAppWarning =>
      '⚠️ সতর্কতা: এটি একটি সিস্টেম অ্যাপ। এটি বন্ধ করলে আপনার ডিভাইস ত্রুটিপূর্ণ বা অস্থিতিশীল হতে পারে। শুধুমাত্র তখনই এগিয়ে যান যদি আপনি জানেন আপনি কী করছেন!';

  @override
  String get runningServicesTitle => 'রানিং সার্ভিসেস';

  @override
  String get openRunningServicesTooltip =>
      'অ্যান্ড্রয়েড সেটিংসে রানিং সার্ভিসেস খুলুন';

  @override
  String get error => 'ত্রুটি';

  @override
  String get appInfoNotFound => 'অ্যাপের তথ্য পাওয়া যায়নি';

  @override
  String pageNotFound(String location) {
    return 'পৃষ্ঠা পাওয়া যায়নি: $location';
  }

  @override
  String get package => 'প্যাকেজ';

  @override
  String get service => 'সার্ভিস';

  @override
  String get process => 'প্রসেস';

  @override
  String get pid => 'পিআইডি';

  @override
  String get uid => 'ইউআইডি';

  @override
  String get ramUsage => 'র‍্যাম ব্যবহার';

  @override
  String get intent => 'ইনটেন্ট';

  @override
  String get foreground => 'ফোরগ্রাউন্ড';

  @override
  String get foregroundId => 'ফোরগ্রাউন্ড আইডি';

  @override
  String get startRequested => 'স্টার্ট রিকোয়েস্টেড';

  @override
  String get createdFromFg => 'ফোরগ্রাউন্ড থেকে তৈরি';

  @override
  String get createTime => 'তৈরির সময়';

  @override
  String get lastActivity => 'সর্বশেষ অ্যাক্টিভিটি';

  @override
  String get baseDir => 'বেস ডিরেক্টরি';

  @override
  String get dataDir => 'ডেটা ডিরেক্টরি';

  @override
  String get type => 'ধরন';

  @override
  String get systemApp => 'সিস্টেম অ্যাপ';

  @override
  String get userApp => 'ব্যবহারকারী অ্যাপ';

  @override
  String get rawOutput => 'র আউটপুট';

  @override
  String get close => 'বন্ধ করুন';

  @override
  String get yes => 'হ্যাঁ';

  @override
  String get no => 'না';

  @override
  String get connections => 'কানেকশনসমূহ';

  @override
  String get flags => 'ফ্ল্যাগস';

  @override
  String get visible => 'দৃশ্যমান';

  @override
  String get capabilities => 'ক্যাপাবিলিটিস';

  @override
  String get active => 'সক্রিয়';

  @override
  String get cached => 'ক্যাশড';

  @override
  String get noServicesFound => 'কোনো সার্ভিস পাওয়া যায়নি';

  @override
  String get ramCalculation => 'র‍্যাম হিসাব';

  @override
  String get totalRam => 'মোট র‍্যাম';

  @override
  String get ramSources => 'সোর্সসমূহ';

  @override
  String get noRamDataAvailable =>
      'এই অ্যাপের জন্য সিস্টেম মেমোরি রিপোর্টে কোনো র‍্যাম ডেটা নেই।';

  @override
  String get ramCalculationExplanation =>
      'র‍্যাম সিস্টেম মেমোরি তথ্য থেকে গণনা করা হয়। PID = প্রসেস আইডি লুকআপ, Process = প্রসেস নাম লুকআপ, LRU = সাম্প্রতিক প্রসেস তালিকা।';

  @override
  String get verifyCommand => 'যাচাই কমান্ড';

  @override
  String get copiedToClipboard => 'ক্লিপবোর্ডে কপি হয়েছে';

  @override
  String get copy => 'কপি';

  @override
  String get and => 'এবং';

  @override
  String service_string(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count সার্ভিসগুলো',
      one: '1 সার্ভিস',
    );
    return '$_temp0';
  }

  @override
  String process_string(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count প্রক্রিয়াগুলো',
      one: '1 প্রক্রিয়া',
    );
    return '$_temp0';
  }

  @override
  String service_process_string(int serviceCount, int processCount) {
    String _temp0 = intl.Intl.pluralLogic(
      processCount,
      locale: localeName,
      other: '$processCount প্রক্রিয়াগুলো',
      one: '1 প্রক্রিয়া',
    );
    String _temp1 = intl.Intl.pluralLogic(
      serviceCount,
      locale: localeName,
      other: '$serviceCount সার্ভিসগুলো',
      one: '1 সার্ভিস',
    );
    return '$_temp0 এবং $_temp1';
  }

  @override
  String get info => 'তথ্য';

  @override
  String get followSystem => 'সিস্টেম';

  @override
  String get contributors => 'অবদানকারী';

  @override
  String contributionsCount(Object count) {
    return '$count অবদান';
  }

  @override
  String get checkingPermissions => 'অনুমতি যাচাই করা হচ্ছে...';

  @override
  String get shizukuNotRunning =>
      'শিজুকু চলছে না। অনুগ্রহ করে শিজুকু অ্যাপ চালু করুন।';

  @override
  String get permissionDeniedShizuku =>
      'অনুমতি অস্বীকার করা হয়েছে। অনুগ্রহ করে শিজুকু অনুমতি দিন।';

  @override
  String get failedToInitialize =>
      'ইনিশিয়ালাইজ করতে ব্যর্থ। অনুগ্রহ করে অনুমতি দিন।';

  @override
  String get errorInitializingShizuku => 'শিজুকু ইনিশিয়ালাইজ করতে ত্রুটি';

  @override
  String get loadingApps => 'অ্যাপস লোড হচ্ছে...';

  @override
  String get refreshedSuccessfully => 'সফলভাবে রিফ্রেশ হয়েছে';

  @override
  String get errorLoadingData => 'ডেটা লোড করতে ত্রুটি';

  @override
  String get failedToStopAllServices => 'সব সার্ভিস বন্ধ করতে ব্যর্থ';

  @override
  String failedToStopServiceName(String serviceName) {
    return '$serviceName সার্ভিস বন্ধ করতে ব্যর্থ';
  }

  @override
  String errorPrefix(String error) {
    return 'ত্রুটি: $error';
  }

  @override
  String get language => 'ভাষা';

  @override
  String get openGithubProfile => 'গিটহাব প্রোফাইল খুলুন';

  @override
  String get appInfoTooltip => 'অ্যাপ তথ্য';

  @override
  String get ok => 'ঠিক আছে';

  @override
  String get recentCallingUid => 'সাম্প্রতিক কলিং UID';

  @override
  String get appDetails => 'অ্যাপ বিস্তারিত';

  @override
  String uidLabel(int uid) {
    return 'UID: $uid';
  }

  @override
  String get processStateTitle => 'প্রসেস স্টেট';

  @override
  String get processStateFg =>
      'ফোরগ্রাউন্ড - অ্যাপটি বর্তমানে ফোরগ্রাউন্ডে আছে';

  @override
  String get processStateVis =>
      'ভিজিবল - অ্যাপের একটি দৃশ্যমান অ্যাক্টিভিটি আছে কিন্তু ফোরগ্রাউন্ডে নয়';

  @override
  String get processStatePrev =>
      'পূর্ববর্তী - পূর্বে ব্যবহৃত ফোরগ্রাউন্ড অ্যাপ';

  @override
  String get processStatePrcp =>
      'পার্সেপটিবল - অ্যাপ এমন কিছু করছে যা ব্যবহারকারী জানে';

  @override
  String get processStateSvcb => 'সার্ভিস B - অ্যাপের একটি বাউন্ড সার্ভিস আছে';

  @override
  String get processStateHome => 'হোম - হোম/লঞ্চার অ্যাপ';

  @override
  String get processStateHvy => 'হেভি ওয়েট - ভারী ওজনের অ্যাপ প্রসেস';

  @override
  String get processStatePsvc =>
      'পার্সিস্ট্যান্ট সার্ভিস - অ্যাপের একটি স্থায়ী সার্ভিস আছে';

  @override
  String get processStatePers => 'পার্সিস্ট্যান্ট - সিস্টেম স্থায়ী প্রসেস';

  @override
  String get processStateCchEmpty =>
      'ক্যাশড এম্পটি - কোনো অ্যাক্টিভিটি ছাড়া ক্যাশড প্রসেস';

  @override
  String get processStateCchAct =>
      'ক্যাশড অ্যাক্টিভিটি - অ্যাক্টিভিটি সহ ক্যাশড প্রসেস';

  @override
  String get processStateCchClient =>
      'ক্যাশড ক্লায়েন্ট - সার্ভিস ক্লায়েন্ট হিসেবে ক্যাশড প্রসেস';

  @override
  String get processStateCch => 'ক্যাশড - প্রসেস মেমোরিতে ক্যাশড';

  @override
  String get processStateBfgs =>
      'বাউন্ড ফোরগ্রাউন্ড সার্ভিস - একটি ফোরগ্রাউন্ড সার্ভিসে বাউন্ড';

  @override
  String get processStateRcvr =>
      'রিসিভার - অ্যাপ একটি ব্রডকাস্ট রিসিভার চালাচ্ছে';

  @override
  String get processStateTop => 'টপ - অ্যাপ অ্যাক্টিভিটি স্ট্যাকের শীর্ষে আছে';

  @override
  String get processStateBtop => 'বাউন্ড টপ - একটি টপ অ্যাপে বাউন্ড';

  @override
  String get processStateImpf =>
      'ইম্পর্ট্যান্ট ফোরগ্রাউন্ড - গুরুত্বপূর্ণ ফোরগ্রাউন্ড প্রসেস';

  @override
  String get processStateImpb =>
      'ইম্পর্ট্যান্ট ব্যাকগ্রাউন্ড - গুরুত্বপূর্ণ ব্যাকগ্রাউন্ড প্রসেস';

  @override
  String processStateUnknown(String state) {
    return 'প্রসেস স্টেট: $state';
  }
}
