# Running Services Monitor

| Play Store | IzzyOnDroid | F-Droid | Release |
|:-:|:-:|:-:|:-:|
| [<img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" height="75">](https://play.google.com/store/apps/details?id=me.biplobsd.rsm) | [<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroidButtonGreyBorder_nofont.png" height="47" alt="Get it at IzzyOnDroid">](https://apt.izzysoft.de/packages/me.biplobsd.rsm) | [<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" height="75" alt="Get it on F-Droid">](https://f-droid.org/packages/me.biplobsd.rsm) | [![Download APK](https://img.shields.io/github/v/release/biplobsd/running_services_monitor?style=for-the-badge&label=Download%20APK&color=blue)](https://github.com/biplobsd/running_services_monitor/releases/latest) |

Running Services Monitor is help you Monitor running services on your Android device. With a clean and intuitive interface, you can easily view system and user apps, check their status efficiently.

## Features

- **Monitor Running Services**: View a comprehensive list of all running services on your device.
- **Categorized View**: Easily switch between All, User, and System apps.
- **Search Functionality**: Quickly find specific apps with the built-in search bar.
- **App Details**: Get detailed information about each app, including package name, version, and more.
- **Root & Shizuku Integration**: First checks for root permission, then falls back to Shizuku for advanced system interactions (where supported).
- **Material Design 3**: A modern and beautiful UI that adapts to your device's theme.
- **Dark/Light Mode**: Toggle between dark and light themes for comfortable viewing.
- **Localization**: Support for English and Bangla languages.

## 📱 Screenshots

| Home                                       | Dark Home                                       |
|--------------------------------------------|-------------------------------------------------|
| ![Home](/screenshots/home.jpg)             | ![Dark Home](/screenshots/dark_home.jpg)        |

| Details                                    | Service Details                                 |
|--------------------------------------------|-------------------------------------------------|
| ![Details](/screenshots/details.jpg)       | ![Service Details](/screenshots/service_details.jpg) |

| Search                                     |
|--------------------------------------------|
| ![Search](/screenshots/search.jpg)         |


## Requirements

### Essential
- **Android 7.0 (API 24) or higher**
- **Root access** (preferred) OR **Shizuku app** installed and running

### Permissions
- `QUERY_ALL_PACKAGES` - To list all installed apps
- Root permission OR Shizuku permission - The app first checks for root access, then falls back to Shizuku if root is unavailable

## Installation

### Option A: Rooted Device (Recommended)

1. Install the app from any of the sources above
2. When prompted, grant root permission
3. The app will use root access for all operations

### Option B: Non-Rooted Device (Using Shizuku)

#### 1. Install Shizuku

Download and install Shizuku from:
- [Google Play Store](https://play.google.com/store/apps/details?id=moe.shizuku.privileged.api)
- [GitHub Releases](https://github.com/RikkaApps/Shizuku/releases)

#### 2. Start Shizuku Service

##### Wireless Debugging:
1. Enable **Developer Options** on your device
2. Enable **Wireless Debugging** in Developer Options
3. Open Shizuku app
4. Tap **"Pair"** or **"Start"**
5. Follow the on-screen pairing instructions

## How It Works

This app uses root access or Shizuku to execute privileged ADB commands:

1. **Permission Check**: The app first checks for root permission. If root is not available, it falls back to Shizuku
2. **Root Integration**: If rooted, executes commands directly with superuser privileges
3. **Shizuku Integration**: If not rooted, connects to the Shizuku service running on your device
4. **Dumpsys Commands**: Executes `dumpsys activity services` to get running service information
5. **Parsing**: Parses the dumpsys output to extract service details (package name, PID, process name, etc.)
6. **Categorization**: Separates services into System and User categories

## Why Root or Shizuku?

Starting from Android 8.0 (API 26), the `ActivityManager.getRunningServices()` API was deprecated and restricted. Third-party apps can no longer query all running services on the device for privacy and security reasons.

**Root access** provides the most seamless experience:
- Direct access to system commands
- No additional setup required
- Works on all rooted devices

**Shizuku** provides an alternative for non-rooted devices:
- Running a privileged service that can access system APIs
- Allowing apps to execute ADB commands without root
- Working on non-rooted devices via Wireless Debugging (Android 11+) or USB ADB

## Building from Source

```bash
# Clone the repository
git clone https://github.com/biplobsd/running_services_monitor.git
cd running_services_monitor

# Get dependencies
flutter pub get

# Generate code (Freezed models and localization)
dart run build_runner build --delete-conflicting-outputs
flutter gen-l10n

# Run on connected device
flutter run

# Build release APK (universal)
flutter build apk --release

# Build release APK (split per ABI for smaller file sizes)
flutter build apk --release --split-per-abi

# Build App Bundle for Play Store
flutter build appbundle --release
```

## License

This project is licensed under the [MIT License](LICENSE). Copyright (c) 2025 Biplob Kumar Sutradhar.

## Support

If you find this app useful, consider buying me a coffee:

[![Buy Me A Coffee](https://img.shields.io/badge/Buy%20Me%20A%20Coffee-FFDD00?style=for-the-badge&logo=buy-me-a-coffee&logoColor=black)](https://buymeacoffee.com/biplobsd)

## Credits

- **Shizuku** by RikkaApps - https://github.com/RikkaApps/Shizuku
- **Flutter** - https://flutter.dev

## Contributors

Thanks to all the amazing people who have contributed to this project!

<a href="https://github.com/biplobsd/running_services_monitor/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=biplobsd/running_services_monitor" />
</a>

## Disclaimer

This app is for informational purposes only. It displays running services but does not modify system behavior. Use responsibly and respect user privacy.

---

**Note**: This app is designed for users who want to monitor running services on their device, similar to the "Running Services" feature that was available in Android Developer Options in older Android versions (before it was hidden in newer versions like HyperOS).
