import 'package:test/test.dart';
import 'package:yaml/yaml.dart';

import 'test_utils.dart';

void main() {
  test('toJson', () {
    final pubspecLockYaml = '''
      # Generated by pub
      # See https://dart.dev/tools/pub/glossary#lockfile
      packages:
        hostedPackage:
          dependency: transitive
          description:
            name: hostedPackage
            url: "https://pub.dartlang.org"
          source: hosted
          version: "1.2.3"
        gitPackage:
          dependency: direct overridden
          description:
            path: "../path"
            ref: "some-branch-name"
            resolved-ref: "abcdefg"
            url: "git@github.com:SomeOrg/SomeRepo.git"
          source: git
          version: "1.2.3"
        pathPackage:
          dependency: direct
          description:
            path: ../path
            relative: true
          source: path
          version: "1.2.3"
        sdkPackage:
          dependency: direct
          description: flutter
          source: sdk
          version: "0.0.0"
      sdks:
        dart: ">=2.7.0 <3.0.0"
    ''';

    final jsonYaml = loadYaml(pubspecLockYaml);
    final value = parse(pubspecLockYaml);

    expect(jsonYaml, value.toJson());
  });
}