package lying.fengfeng.foodrecords.ui.theme

import android.app.Activity
import android.os.Build
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.dynamicDarkColorScheme
import androidx.compose.material3.dynamicLightColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.SideEffect
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.platform.LocalView
import androidx.core.view.WindowCompat
import com.materialkolor.PaletteStyle
import com.materialkolor.rememberDynamicColorScheme

private val DarkColorScheme = darkColorScheme(
    primary = Purple80,
    secondary = PurpleGrey80,
    tertiary = Pink80
)

private val LightColorScheme = lightColorScheme(
    primary = Purple40,
    secondary = PurpleGrey40,
    tertiary = Pink40

    /* Other default colors to override
    background = Color(0xFFFFFBFE),
    surface = Color(0xFFFFFBFE),
    onPrimary = Color.White,
    onSecondary = Color.White,
    onTertiary = Color.White,
    onBackground = Color(0xFF1C1B1F),
    onSurface = Color(0xFF1C1B1F),
    */
)

@Composable
fun FoodRecordsTheme(
    darkTheme: Boolean = isSystemInDarkTheme(),
    dynamicColor: Boolean = true,
    themeOption: ThemeOptions = ThemeOptions.DYNAMIC,
    content: @Composable () -> Unit
) {
    val colorScheme = when (themeOption) {
        ThemeOptions.RED -> rememberDynamicColorScheme(Color.Red, darkTheme)
        ThemeOptions.YELLOW -> rememberDynamicColorScheme(Color.Yellow, darkTheme)
        ThemeOptions.GREEN -> rememberDynamicColorScheme(Color.Green, darkTheme)
        ThemeOptions.BLUE -> rememberDynamicColorScheme(Color.Blue, darkTheme)
        ThemeOptions.MAGENTA -> rememberDynamicColorScheme(Color.Magenta, darkTheme)
        ThemeOptions.WHITE -> rememberDynamicColorScheme(Color.White, darkTheme, style = PaletteStyle.Fidelity)
        else -> when {
            dynamicColor && Build.VERSION.SDK_INT >= Build.VERSION_CODES.S -> {
                val context = LocalContext.current
                if (darkTheme) dynamicDarkColorScheme(context) else dynamicLightColorScheme(context)
            }

            darkTheme -> DarkColorScheme
            else -> LightColorScheme
        }
    }

    val view = LocalView.current
    if (!view.isInEditMode) {
        SideEffect {
            val window = (view.context as Activity).window
            window.statusBarColor = colorScheme.primaryContainer.toArgb()
            WindowCompat.getInsetsController(window, view).isAppearanceLightStatusBars = darkTheme
        }
    }

    MaterialTheme(
        colorScheme = colorScheme,
        typography = Typography,
        content = content
    )
}

enum class ThemeOptions(val int: Int) {
    DYNAMIC(0),
    RED(1),
    YELLOW(2),
    GREEN(3),
    BLUE(4),
    MAGENTA(5),
    WHITE(6);

    companion object {
        fun fromInt(value: Int): ThemeOptions {
            return entries.find { it.int == value } ?: DYNAMIC
        }
    }
}