/**
 * Copyright (C) 2025  Antonio Tari
 *
 * This file is a part of Power Ampache 2
 * Ampache Android client application
 * @author Antonio Tari
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package luci.sixsixsix.powerampache2.data.plugins

const val KEY_REQUEST_JSON = "json"
const val KEY_ACTION = "action"
const val ACTION_SONG = "song"
const val ACTION_ALBUM = "album"
const val ACTION_ARTIST = "artist"
const val KEY_MBID = "mbid"
const val KEY_ID = "id"
const val KEY_REQUEST_SONG_TITLE = "songTitle"
const val KEY_REQUEST_ALBUM_TITLE = "albumTitle"
const val KEY_REQUEST_ARTIST_NAME = "artistName"
const val KEY_RESPONSE_SUCCESS = "success"

// Avoid android.os.TransactionTooLargeException: data parcel size xxx bytes by
// reducing the size of the queue to MAX_CAST_QUEUE.
const val MAX_CAST_QUEUE = 100
