/**
 * Copyright (C) 2024  Antonio Tari
 *
 * This file is a part of Power Ampache 2
 * Ampache Android client application
 * @author Antonio Tari
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package luci.sixsixsix.powerampache2.presentation.common

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.dimensionResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import luci.sixsixsix.powerampache2.R
import luci.sixsixsix.powerampache2.domain.models.MusicAttribute

@Composable
fun MusicAttributeChips(
    modifier: Modifier = Modifier,
    attributes: List<MusicAttribute>,
    containerColor: Color = Color(red = 0, blue = 0, green = 0, alpha = 180),
    onMusicAttributeClick: (MusicAttribute) -> Unit
) {
    LazyRow(modifier = modifier
        .padding(
            horizontal = dimensionResource(R.dimen.albumDetailScreen_infoSection_chipsRow_padding)
        )) {
        items(attributes) {
            if (it.name.isNotBlank()) {
                Row {
                    Card(
                        modifier = Modifier.clickable {
                            onMusicAttributeClick(it)
                        },
                        colors = CardDefaults.cardColors(
                            containerColor = containerColor
                        ),
                        shape = RoundedCornerShape(dimensionResource(R.dimen.albumDetail_chip_radius)),
                        elevation = CardDefaults.cardElevation(dimensionResource(R.dimen.albumDetail_chip_elevation))
                    ) {
                        Text(
                            modifier = Modifier
                                .padding(8.dp)
                                .align(Alignment.CenterHorizontally),
                            text = it.name,
                            fontSize = 14.sp,
                            fontWeight = FontWeight.SemiBold
                        )
                    }
                    Spacer(modifier = Modifier.width(12.dp))
                }
            }
        }
    }
}

@Composable
fun MusicChips(
    modifier: Modifier = Modifier,
    attributes: List<String>,
    containerColor: Color = Color(red = 0, blue = 0, green = 0, alpha = 180),
    onMusicAttributeClick: (String) -> Unit
) {
    LazyRow(modifier = modifier
        .padding(
            horizontal = dimensionResource(R.dimen.albumDetailScreen_infoSection_chipsRow_padding)
        )) {
        items(attributes) {
            if (it.isNotBlank()) {
                Row {
                    Card(
                        modifier = Modifier.clickable {
                            onMusicAttributeClick(it)
                        },
                        colors = CardDefaults.cardColors(
                            containerColor = containerColor
                        ),
                        shape = RoundedCornerShape(dimensionResource(R.dimen.albumDetail_chip_radius)),
                        elevation = CardDefaults.cardElevation(dimensionResource(R.dimen.albumDetail_chip_elevation))
                    ) {
                        Text(
                            modifier = Modifier
                                .padding(8.dp)
                                .align(Alignment.CenterHorizontally),
                            text = it,
                            fontSize = 14.sp,
                            fontWeight = FontWeight.SemiBold
                        )
                    }
                    Spacer(modifier = Modifier.width(12.dp))
                }
            }
        }
    }
}