#!/bin/bash

commands=${@}
buildall="$1"

echo "NDK_PLATFORM_LEVEL : $NDK_PLATFORM_LEVEL"
if [ "${#NDK_PLATFORM_LEVEL}" -lt 2 ]
then
echo -ne "Please set the NDK_PLATFORM_LEVEL : export NDK_PLATFORM_LEVEL=21\n"
export NDK_PLATFORM_LEVEL=21
fi


if [ "$NDK_PLATFORM_LEVEL" -ge 24 ]
then
sed -i -e 's/videohwaamodecount = 7;/videohwaamodecount = 13;/' app/src/main/java/la/daube/photochiotte/Gallery.java
else
sed -i -e 's/videohwaamodecount = 13;/videohwaamodecount = 7;/' app/src/main/java/la/daube/photochiotte/Gallery.java
fi
sed -i -e 's/minSdkVersion [0-9]*/minSdkVersion '"${NDK_PLATFORM_LEVEL}"'/' app/build.gradle


if [ "$buildall" = "all" ]
then
  rm -fr app/src/main/cpp/libs
  rm -fr app/src/main/cpp/include
fi

bash dlbuildmpv.sh ${commands}
if [ $? -ne 0 ]
then 
  echo " --- mpv build error"
  exit 1
else
  echo " +++ mpv build success"
fi

if [ "$buildall" = "all" ]
then
  rm -fr dlbuildmpv/
  echo "removed dlbuildmpv $?"
  pwd
  sync
fi

bash dlbuildtor.sh ${commands}
if [ $? -ne 0 ]
then 
  echo " --- tor build error"
  exit 1
else
  echo " +++ tor build success"
fi

if [ "$buildall" = "all" ]
then
  rm -fr dlbuildtor/
  echo "removed dlbuildtor $?"
  pwd
  sync
fi

#bash dlbuildopenvpn.sh ${commands}
#if [ $? -ne 0 ]
#then
#  echo " --- openvpn build error"
#else
#  echo " +++ openvpn build success"
#fi
#
#rm -fr dlbuildopenvpn/
#sync












