package la.daube.photochiotte;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.text.format.DateFormat;
import android.view.Surface;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class ThreadDrawing implements Runnable {
    private static final String TAG = "YYYtdrw";

    private long[] tempsinit = new long[30];
    private long[] tempsdiff = new long[30];
    private int[] tempscompte = new int[30];

    private Surf mysurf;
    private int currid = -1;

    private boolean clickquicknav = false;
    private boolean clickquicknavmenu = false;
    private boolean clicktohandle = false;
    private float clicktohandlex = 0.0f;
    private float clicktohandley = 0.0f;

    private Gallery model;

    private float bpx = 0;
    private float bpy = 0;
    private float bscale = 0;
    private int rotation = 0;

    private Bitmap bg = null;
    private Bitmap pickcolor = null;
    private Bitmap menusize = null;
    private Bitmap bezier = null;
    private Bitmap select = null;
    private Bitmap recycle = null;
    private Bitmap save = null;
    private Bitmap addcanvas = null;
    private Bitmap addpic = null;
    private Bitmap change = null;
    private Bitmap contour = null;
    private Bitmap graph = null;
    private Bitmap contrast = null;
    private Bitmap draw = null;
    private Bitmap duplicate = null;
    private Bitmap erase = null;
    private Bitmap fill = null;
    private Bitmap hand = null;
    private Bitmap layers = null;
    private Bitmap quit = null;
    private Bitmap stylus = null;
    private Bitmap undo = null;
    private Bitmap zoom = null;
    private Bitmap drawbgspot = null;
    private Bitmap drawchangethickness = null;
    private Bitmap drawduplicate = null;
    private Bitmap drawline = null;
    private Bitmap drawmove = null;
    private Bitmap drawmovepoint = null;
    private Bitmap drawmoveto = null;
    private Bitmap drawradialfill = null;
    private Bitmap drawselectmultiple = null;
    private Bitmap drawselectone = null;
    private Bitmap drawtraceremove = null;
    private Bitmap drawchangecolor = null;
    private Bitmap drawchangedown = null;
    private Bitmap drawchangeup = null;
    private Bitmap drawchangeresize = null;
    private Bitmap drawchangetype = null;

    private boolean selectiona = false;
    private boolean selectionz = false;
    private int selectionadoss = -1;
    private int selectionafich = -1;
    private int selectionzdoss = -1;
    private int selectionzfich = -1;
    private boolean selectionplus = false;
    private boolean selectionmoins = false;
    private boolean alloxdeletefile = false;

    private volatile long POLL_TIMEOUT = Gallery.polltimeoutdefault / 5;
    private String[] neworder = null;

    protected ThreadDrawing(Gallery mmodel) {
        model = mmodel;
    }

    boolean checkready() {
        for (int i = 0; i < 1000; i++) {
            if (model.dossierminiature != null
                    && model.surf.size() > 0)
                return true;
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (i % 50 == 0) {
                llog.d(TAG, "error checkready() " + i);
            }
        }
        return false;
    }

    @Override
    public void run() {
        model.threaddrawingrunning = true;
        llog.d(TAG, "++++++++++++++++++++ ThreadDrawing");
        if (!checkready()) {
            llog.d(TAG, "error checkready bail out");
            model.threaddrawingrunning = false;
            return;
        }

        //boolean nextpictureposition0 = false;
        boolean updateonefinaltime = false;

        while (model.surf.size() <= 0) {
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        currid = 0;
        int surfl = model.surf.size();
        for (int i = 0 ; i < surfl ; i++) {
            if (model.surf.get(i).fragmenttype == Surf.FRAGMENT_TYPE_DRAWING) {
                currid = i;
                break;
            }
        }
        mysurf = model.surf.get(currid);

        mysurf.drawtracecurrcolorh = model.preferences.getFloat("drawtracecurrcolorh", mysurf.drawtracecurrcolorh);
        mysurf.drawtracecurrcolors = model.preferences.getFloat("drawtracecurrcolors", mysurf.drawtracecurrcolors);
        mysurf.drawtracecurrcolorv = model.preferences.getFloat("drawtracecurrcolorv", mysurf.drawtracecurrcolorv);
        mysurf.drawtracecurrcolora = model.preferences.getFloat("drawtracecurrcolora", mysurf.drawtracecurrcolora);
        mysurf.drawtracecurrsizemin = model.preferences.getFloat("drawtracecurrsizemin", mysurf.drawtracecurrsizemin);
        mysurf.drawtracecurrsizemax = model.preferences.getFloat("drawtracecurrsizemax", mysurf.drawtracecurrsizemax);

        drawmenuimageload();


        boolean toptemp = false;
        while (true) {
            boolean encore = true;
            while (encore) {
                toptemp = false;

                // on vide la liste
                if (model.commandethreaddrawing.isEmpty() && updateonefinaltime) {
                    /**
                     *   on rafraîchit l'écran une dernière fois
                     *   tout à la fin si jamais on est disponible
                     *   car les options sont modifiées en même temps que l'on dessine
                     *   et on risque donc de ne pas avoir la version finale de l'écran
                     */
                    updateonefinaltime = false;
                    neworder = new String[]{"-1", "update"};
                    // on ne modifie pas myid on reste sur le précédent
                } else {
                    try {
                        neworder = model.commandethreaddrawing.poll(POLL_TIMEOUT, TimeUnit.MILLISECONDS);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    updateonefinaltime = false;
                }

                if (neworder == null) {
                    neworder = new String[]{"-1", "poll"};
                    surfl = model.surf.size();
                    for (int i = 0; i < surfl; i++) {
                        currid = (currid + 1) % surfl;
                        mysurf = model.surf.get(currid);
                        if (mysurf.fragmenttype == Surf.FRAGMENT_TYPE_DRAWING)
                            break;
                    }
                }
                int targetid = Integer.parseInt(neworder[0]);
                if (targetid != -1 && targetid < model.surf.size()) {
                    if (targetid != currid)
                        encore = false;
                    currid = targetid;
                    mysurf = model.surf.get(currid);
                }

                if (neworder[1].equals("quit")) {
                    /*if (neworder.length > 2)
                        if (neworder[2].equals("threaddrawingoff"))
                            model.threaddrawingon = false;*/
                    if (model.threaddrawingon) {
                        llog.d(TAG, "////////////////////// thread drawing keep running");
                    } else {
                        llog.d(TAG, "---------------------- thread drawing");
                        drawmenuimageloadrecycle();
                        model.threaddrawingrunning = false;
                        return;
                    }

                } else if (!model.threaddrawingrunning) {
                    llog.d(TAG, "++++++++++++++++++++++!model.threaddrawingrunning");
                    // si on pause on efface toutes les commandes moins importantes suivantes dans la queue

                } else if (neworder[1].equals("closedrawing")) { // called by closing fragment
                    llog.d(TAG, "++++++++++++++++++++++closedrawing");
                    if (mysurf.drawingcurrfichier != null) {
                        File file = new File(mysurf.drawingcurrfichier + "." + Gallery.vectordrawingpatterns);
                        if (file.exists()) {
                            file.delete();
                            llog.d(TAG, "--------------------closedrawing deleted " + mysurf.drawingcurrfichier + "." + Gallery.vectordrawingpatterns);
                        }
                        file = new File(mysurf.drawingcurrfichier + "." + Gallery.oldvectordrawingpatterns);
                        if (file.exists()) {
                            file.delete();
                            llog.d(TAG, "--------------------closedrawing deleted " + mysurf.drawingcurrfichier + "." + Gallery.oldvectordrawingpatterns);
                        }
                        file = new File(mysurf.drawingcurrfichier + ".png");
                        if (file.exists()) {
                            file.delete();
                            llog.d(TAG, "--------------------closedrawing deleted " + mysurf.drawingcurrfichier + ".png");
                        }
                    }
                    if (neworder[2].equals("save")) {
                        llog.d(TAG, "--------------------closedrawing writelastdrawing because " + mysurf.drawingcurrfichier + " != " + mysurf.mediaIndexAddress + " " + neworder[2] + " " + alloxdeletefile);
                        writelastdrawing();
                    } else {
                        llog.d(TAG, "--------------------closedrawing donotwritelast because " + mysurf.drawingcurrfichier + " != " + mysurf.mediaIndexAddress + " " + neworder[2] + " " + alloxdeletefile);
                        model.message("removed " + mysurf.drawingcurrfichier + ".png");
                    }

                    int listecouchel = mysurf.listecouche.size();
                    for (int i = 0; i < listecouchel; i++) {
                        if (mysurf.listecouche.get(i).currentbitmap != null) {
                            if (!mysurf.listecouche.get(i).currentbitmap.isRecycled()) {
                                mysurf.listecouche.get(i).currentbitmap.recycle();
                            }
                        }
                    }
                    int listedessinl = mysurf.listedessin.size();
                    for (int i = 0; i < listedessinl; i++) {
                        if (mysurf.listedessin.get(i).originalpicture != null) {
                            if (!mysurf.listedessin.get(i).originalpicture.isRecycled()) {
                                mysurf.listedessin.get(i).originalpicture.recycle();
                            }
                        }
                    }
                    mysurf.listecouche.clear();
                    mysurf.listedessin.clear();
                    llog.d(TAG, "--------------------closedrawing clear couches");

                    if (mysurf.drawpilebitmap != null) {
                        if (!mysurf.drawpilebitmap.isRecycled()) {
                            mysurf.drawpilebitmap.recycle();
                        }
                        mysurf.drawpilebitmap = null;
                    }
                    if (mysurf.drawtoptempbitmap != null) {
                        if (!mysurf.drawtoptempbitmap.isRecycled()) {
                            mysurf.drawtoptempbitmap.recycle();
                        }
                        mysurf.drawtoptempbitmap = null;
                    }
                    llog.d(TAG, "--------------------closedrawing recycle bitmaps");

                } else if (neworder[1].equals("surfacechanged")) {
                    llog.d(TAG, "++++++++++++++++++++++surfacechanged");
                    if (mysurf.drawpilebitmap != null) {
                        if (!mysurf.drawpilebitmap.isRecycled()) {
                            mysurf.drawpilebitmap.recycle();
                        }
                        mysurf.drawpilebitmap = null;
                    }
                    if (mysurf.drawtoptempbitmap != null) {
                        if (!mysurf.drawtoptempbitmap.isRecycled()) {
                            mysurf.drawtoptempbitmap.recycle();
                        }
                        mysurf.drawtoptempbitmap = null;
                    }
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "initialize", mysurf.mediaIndexAddress});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    updateonefinaltime = true;
                    encore = false;

                } else if (neworder[1].equals("initialize")) {
                    llog.d(TAG, "++++++++++++++++++++++initialize");

                    // avoid messing with zoom position on next loading
                    mysurf.drawcurrlayer = -1;

                    if (mysurf.drawtoptempbitmap == null) {
                        mysurf.drawtoptempbitmap = Bitmap.createBitmap(mysurf.ScreenWidth, mysurf.ScreenHeight, Bitmap.Config.ARGB_8888);
                        mysurf.drawtoptempcanvas = new Canvas(mysurf.drawtoptempbitmap);
                    }
                    if (mysurf.drawpilebitmap == null) {
                        mysurf.drawpilebitmap = Bitmap.createBitmap(mysurf.ScreenWidth, mysurf.ScreenHeight, Bitmap.Config.ARGB_8888);
                        mysurf.drawpilecanvas = new Canvas(mysurf.drawpilebitmap);
                        llog.d(TAG, "++++++++++++++++++++++initialize create bitmaps");
                    }

                    int couchel = mysurf.listecouche.size();
                    if (couchel == 0) {
                        if (!neworder[2].equals("startblank")) {
                            llog.d(TAG, "++++++++++++++++++++++initialize read " + mysurf.mediaIndexAddress);
                            readlastdrawing(mysurf.mediaIndexAddress);
                        }
                    }

                    couchel = mysurf.listecouche.size();
                    if (couchel == 0) {
                        llog.d(TAG, "++++++++++++++++++++++initialize start blank");
                        startblankdrawing();
                    }

                    alloxdeletefile = false;
                    if (mysurf.drawingcurrfichier != null && mysurf.mediaIndexAddress != null) {
                        if (mysurf.mediaIndexAddress.equals(mysurf.drawingcurrfichier + ".png")) {
                            alloxdeletefile = true;
                        }
                    }

                    couchel = mysurf.listecouche.size();
                    for (int i = 0; i < couchel; i++)
                        recreecanvasenzero(i, mysurf.ScreenWidth, mysurf.ScreenHeight);
                    encore = false;

                } else if (neworder[1].equals("poll")) {

                    // ne pas dépendre de currid ici ça peut venir sans currid
                    if (mysurf.fragmenttype != Surf.FRAGMENT_TYPE_DRAWING)
                        continue;

                    if (mysurf.selectedtrace == Gallery.selectedtracemoveto || selectmultiple) {
                        encore = false;
                    } else {
                        continue;
                    }

                } else if (neworder[1].equals("updatefilter")) {
                    applyfilter(neworder[2]);
                    encore = false;

                } else if (neworder[1].equals("recreategrid")) {
                    if (mysurf.gridalign)
                        recreategrid();
                    encore = false;

                } else if (neworder[1].equals("trace")) {

                    /**
                     *  on sauvegarde toutes les traces
                     *  mais il faut corriger avec
                     *  - décalage
                     *  / zoom
                     *  float[] pss = model.drawpossizescale.get(0);
                     */
                    int cettelayer = 0;
                    if (mysurf.drawcurrlayer >= 0)
                        cettelayer = mysurf.drawcurrlayer;
                    Couche couche = mysurf.listecouche.get(cettelayer);

                    float onscreentracepx = Float.parseFloat(neworder[3]);
                    float onscreentracepy = Float.parseFloat(neworder[4]);
                    float tracepx = (onscreentracepx - couche.x) / couche.scale;
                    float tracepy = (onscreentracepy - couche.y) / couche.scale;
                    if (mysurf.onlymouseup) {
                        if (!neworder[2].equals("f"))
                            continue;
                        if (mysurf.onlymouseupstatus == 0) {
                            neworder[2] = "i";
                            mysurf.onlymouseupstatus = 1;
                        } else if (mysurf.onlymouseupstatus == 1) {
                            neworder[2] = "n";
                        } else {
                            neworder[2] = "f";
                            mysurf.onlymouseupstatus = 1;
                        }
                        if (mysurf.chaindraw) {
                            if (mysurf.onlymouseupstatus == 1 && neworder[2].equals("n")) {
                                // même qu'avant ?
                                int drawtracecurrl = mysurf.drawtracecurr.size();
                                if (drawtracecurrl > 1) {
                                    float[] last = mysurf.drawtracecurr.get(drawtracecurrl - 1);
                                    float dist = (last[0] - tracepx) * (last[0] - tracepx) + (last[1] - tracepy) * (last[1] - tracepy);
                                    if (dist < model.DessinCaseH * model.DessinCaseH * 0.20f * 0.20f) {
                                        //llog.d(TAG, "même qu'avant");
                                        //mysurf.onlymouseup = false;
                                        mysurf.onlymouseupstatus = -1;
                                        try {
                                            model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "tracecompleteredraw", "andthenmouseupagain"});
                                        } catch (InterruptedException e) {
                                        }
                                        encore = true;
                                        continue;
                                    }// else {
                                    //    llog.d(TAG, "pas le même qu'avant");
                                    //}
                                }
                            }
                        }
                    }
                    if (mysurf.gridalign) {
                        float gridaligndx = ((mysurf.gridalignd + couche.gridx) % mysurf.gridalignd);
                        float gridaligndy = ((mysurf.gridalignd + couche.gridy) % mysurf.gridalignd);
                        float nx = (float) Math.round((tracepx - gridaligndx) / mysurf.gridalignd);
                        tracepx = nx * mysurf.gridalignd + gridaligndx;
                        float ny = (float) Math.round((tracepy - gridaligndy) / mysurf.gridalignd);
                        tracepy = ny * mysurf.gridalignd + gridaligndy;
                        int drawtracecurrl = mysurf.drawtracecurr.size();
                        if (drawtracecurrl > 0) {
                            float[] last = mysurf.drawtracecurr.get(drawtracecurrl - 1);
                            if (tracepx == last[0] && tracepy == last[1]) {
                                if (!neworder[2].equals("f")) {
                                    encore = true;
                                    continue;
                                } else {
                                    // mysurf.drawtracecurr.remove(drawtracecurrl - 1);
                                }
                            }
                        }
                    }
                    //llog.d(TAG, "nouveau point en xy "+neworder[2]+" "+tracepx+" "+tracepy+" ; "+neworder[3]+" "+neworder[4]);
                    float tracepp = Float.parseFloat(neworder[5]);
                    float tracept = Float.parseFloat(neworder[6]);
                    float tracepd = Float.parseFloat(neworder[7]);
                    mysurf.drawtracecurr.add(new float[]{tracepx, tracepy, tracepp, tracept, tracepd});
                    int tracecurrlast = mysurf.drawtracecurr.size() - 1;
                    if (neworder[2].equals("i")) {
                        // on ne fait rien on attend de voir la suite
                        model.TracePaint.setColor(Color.HSVToColor((int) mysurf.drawtracecurrcolora, new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv}));
                    } else if (neworder[2].equals("f") && tracecurrlast == 1) {
                        // c'est un point : on ignore le premier qui devrait être identique de toute façon car on n'a pas bougé
                        //llog.d(TAG, "f tracecurrlast == 1");
                        float epaisseur = mysurf.drawtracecurrsizemin;
                        if (mysurf.drawtracecurrsizemin != mysurf.drawtracecurrsizemax && model.drawtracepressuremax > 0.3f + model.drawtracepressuremin) {
                            float cettepression = mysurf.drawtracecurr.get(tracecurrlast)[2];
                            if (cettepression > model.drawtracepressuremax) {
                                cettepression = model.drawtracepressuremax;
                            }
                            if (cettepression < model.drawtracepressuremin) {
                                cettepression = model.drawtracepressuremin;
                            }
                            float sizepente = (mysurf.drawtracecurrsizemax - mysurf.drawtracecurrsizemin) / (model.drawtracepressuremax - model.drawtracepressuremin);
                            float sizeordonnee = mysurf.drawtracecurrsizemin - sizepente * model.drawtracepressuremin;
                            epaisseur = sizeordonnee + sizepente * cettepression;
                        }
                        model.TracePaint.setStrokeWidth(epaisseur);
                        // model.drawcanvas.get(0).drawPoint(tracepx, tracepy, model.TracePaint);
                        // on va de toute façon redessiner puisque c'est un f
                    } else {
                        // ligne
                        if (tracecurrlast - 1 < 0 || mysurf.drawtracecurr.size() == 0) {
                            llog.d(TAG, "error trace");
                            mysurf.drawtracecurr.clear();
                            continue;
                        }
                        float[] tracepreced = mysurf.drawtracecurr.get(tracecurrlast - 1);
                        float epaisseur = mysurf.drawtracecurrsizemin;
                        if (mysurf.drawtracecurrsizemin != mysurf.drawtracecurrsizemax && model.drawtracepressuremax > 0.3f + model.drawtracepressuremin) {
                            float cettepression = (tracepreced[2] + tracepp) / 2.0f;
                            if (cettepression > model.drawtracepressuremax) {
                                cettepression = model.drawtracepressuremax;
                            }
                            if (cettepression < model.drawtracepressuremin) {
                                cettepression = model.drawtracepressuremin;
                            }
                            float sizepente = (mysurf.drawtracecurrsizemax - mysurf.drawtracecurrsizemin) / (model.drawtracepressuremax - model.drawtracepressuremin);
                            float sizeordonnee = mysurf.drawtracecurrsizemin - sizepente * model.drawtracepressuremin;
                            epaisseur = sizeordonnee + sizepente * cettepression;
                        }
                        model.TracePaint.setStrokeWidth(epaisseur);
                        // model.drawcanvas.get(0).drawLine(tracepreced[0], tracepreced[1], tracepx, tracepy, model.TracePaint);
                        if (!neworder[2].equals("f")) {
                            float ox = tracepreced[0] * couche.scale + couche.x;
                            float oy = tracepreced[1] * couche.scale + couche.y;
                            float x = tracepx * couche.scale + couche.x;
                            float y = tracepy * couche.scale + couche.y;
                            if (mysurf.drawgeometrictype == Dessin.drawgeometrictypeline) {
                                mysurf.drawtoptempcanvas.drawLine(ox, oy, x, y, model.TracePaint);
                            } else if (mysurf.drawgeometrictype == Dessin.drawgeometrictypecircle) {
                                float r = ((float) Math.sqrt((x - ox) * (x - ox) + (y - oy) * (y - oy)));
                                mysurf.drawtoptempcanvas.drawCircle(ox, oy, r, model.TracePaint);
                            } else if (mysurf.drawgeometrictype == Dessin.drawgeometrictyperect) {
                                mysurf.drawtoptempcanvas.drawRect(ox, oy, x, y, model.TracePaint);
                            }

                            if (model.commandethreaddrawing.isEmpty()) {
                                // si il n'y a pas encore d'autres points qui attendent d'être dessinés
                                toptemp = true;
                                //drawall(true);
                                encore = false;
                            }
                        }
                    }

                    if (!neworder[2].equals("f")) {
                        /**
                         *   si ce n'est pas la trace finale
                         *   on acquiert vite les prochains points
                         */
                        //updateonefinaltime = false;
                        //continue;
                    } else {
                        //llog.d(TAG, "completeredraw");
                        int drawtracecurrl = mysurf.drawtracecurr.size();
                        if (drawtracecurrl > 0) {
                            // si le dernier point est identique à l'avant dernier
                            // ce qui devrait toujours être le cas
                            // on ignore le dernier point
                            // pour éviter point transparent * 2x ce qu'on voulait
                            if (drawtracecurrl > 1) {
                                drawtracecurrl -= 1;
                            }
                            int drawtracexl = mysurf.listedessin.size();
                            Dessin cedessin = new Dessin();
                            cedessin.x = new float[drawtracecurrl];
                            cedessin.y = new float[drawtracecurrl];
                            cedessin.p = new float[drawtracecurrl];
                            cedessin.t = new float[drawtracecurrl];
                            cedessin.d = new float[drawtracecurrl];
                            for (int i = 0; i < drawtracecurrl; i++) {
                                float[] drawtracecurr = mysurf.drawtracecurr.get(i);
                                cedessin.x[i] = drawtracecurr[0];
                                cedessin.y[i] = drawtracecurr[1];
                                cedessin.p[i] = drawtracecurr[2];
                                cedessin.t[i] = drawtracecurr[3];
                                cedessin.d[i] = drawtracecurr[4];
                            }
                            mysurf.drawtracecurr.clear();
                            cedessin.couleura = mysurf.drawtracecurrcolora;
                            cedessin.couleurh = mysurf.drawtracecurrcolorh;
                            cedessin.couleurs = mysurf.drawtracecurrcolors;
                            cedessin.couleurv = mysurf.drawtracecurrcolorv;
                            cedessin.generecouleur();
                            cedessin.sizemax = mysurf.drawtracecurrsizemax;
                            cedessin.sizemin = mysurf.drawtracecurrsizemin;
                            cedessin.pressuremax = model.drawtracepressuremax;
                            cedessin.pressuremin = model.drawtracepressuremin;
                           /*
                           float sizepente = 0.0f;
                           float sizeordonnee = mysurf.drawtracecurrsizemin;
                           if(mysurf.drawtracecurrsizemin != mysurf.drawtracecurrsizemax && model.drawtracepressuremax > 0.3f + model.drawtracepressuremin){
                             sizepente = (mysurf.drawtracecurrsizemax - mysurf.drawtracecurrsizemin) / (model.drawtracepressuremax - model.drawtracepressuremin);
                             sizeordonnee = mysurf.drawtracecurrsizemin - sizepente * model.drawtracepressuremin;
                           }
                           */
                            cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                            cedessin.bezierlength = mysurf.drawtracecurrbezier;
                            cedessin.geometrictype = mysurf.drawgeometrictype;
                            cedessin.porterduff = mysurf.drawporterduff;
                            cedessin.couche = cettelayer;
                            mysurf.listedessin.add(cedessin);
                            // on dessine la nouvelle dernière trace sur sa layer
                            Canvas surfacecanvas = couche.canvas;
                            dessinelatrace(drawtracexl, surfacecanvas);
                            mysurf.drawtoptempcanvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR);
                        }

                        // c'est la trace finale on doit faire encore un update
                        // sinon il faut attendre de toucher de nouveau l'écran pour voir la fin de la trace précédente
                        encore = false;
                    }


                } else if (neworder[1].equals("tracecompleteredraw")) {
                    //llog.d(TAG, "tracecompleteredraw");

                    int cettelayer = 0;
                    if (mysurf.drawcurrlayer >= 0)
                        cettelayer = mysurf.drawcurrlayer;

                    int drawtracecurrl = mysurf.drawtracecurr.size();
                    if (drawtracecurrl > 0) {
                        // si le dernier point est identique à l'avant dernier
                        // ce qui devrait toujours être le cas
                        // on ignore le dernier point
                        // pour éviter point transparent * 2x ce qu'on voulait

                        int drawtracexl = mysurf.listedessin.size();
                        Dessin cedessin = new Dessin();
                        cedessin.x = new float[drawtracecurrl];
                        cedessin.y = new float[drawtracecurrl];
                        cedessin.p = new float[drawtracecurrl];
                        cedessin.t = new float[drawtracecurrl];
                        cedessin.d = new float[drawtracecurrl];
                        for (int i = 0; i < drawtracecurrl; i++) {
                            float[] drawtracecurr = mysurf.drawtracecurr.get(i);
                            cedessin.x[i] = drawtracecurr[0];
                            cedessin.y[i] = drawtracecurr[1];
                            cedessin.p[i] = drawtracecurr[2];
                            cedessin.t[i] = drawtracecurr[3];
                            cedessin.d[i] = drawtracecurr[4];
                        }
                        mysurf.drawtracecurr.clear();
                        cedessin.couleura = mysurf.drawtracecurrcolora;
                        cedessin.couleurh = mysurf.drawtracecurrcolorh;
                        cedessin.couleurs = mysurf.drawtracecurrcolors;
                        cedessin.couleurv = mysurf.drawtracecurrcolorv;
                        cedessin.generecouleur();
                        cedessin.sizemax = mysurf.drawtracecurrsizemax;
                        cedessin.sizemin = mysurf.drawtracecurrsizemin;
                        cedessin.pressuremax = model.drawtracepressuremax;
                        cedessin.pressuremin = model.drawtracepressuremin;
                        cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                        cedessin.bezierlength = mysurf.drawtracecurrbezier;
                        cedessin.geometrictype = mysurf.drawgeometrictype;
                        cedessin.porterduff = mysurf.drawporterduff;
                        cedessin.couche = cettelayer;
                        mysurf.listedessin.add(cedessin);

                        // on dessine la nouvelle dernière trace sur sa layer
                        Canvas surfacecanvas = mysurf.listecouche.get(cettelayer).canvas;
                        dessinelatrace(drawtracexl, surfacecanvas);
                        mysurf.drawtoptempcanvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR);
                          /*
                          float sizepente = 0.0f;
                          float sizeordonnee = mysurf.drawtracecurrsizemin;
                          if(mysurf.drawtracecurrsizemin != mysurf.drawtracecurrsizemax && model.drawtracepressuremax > 0.3f + model.drawtracepressuremin){
                            sizepente = (mysurf.drawtracecurrsizemax - mysurf.drawtracecurrsizemin) / (model.drawtracepressuremax - model.drawtracepressuremin);
                            sizeordonnee = mysurf.drawtracecurrsizemin - sizepente * model.drawtracepressuremin;
                          }
                          */
                    }

                    if (neworder.length > 2) {
                        if (neworder[2].equals("andthenmouseupagain")) {
                            mysurf.onlymouseupstatus = 0;
                            //mysurf.onlymouseup = true;
                        }
                    }

                    // c'est la trace finale on doit faire encore un update
                    // sinon il faut attendre de toucher de nouveau l'écran pour voir la fin de la trace précédente
                    encore = false;


                } else if (neworder[1].equals("menudessiner")) {
                    /**
                     *    on attrape tous les menudessiner init on n'en rate jamais un seul
                     *    move on en rate pour ne pas traîner
                     */
                    updateonefinaltime = true;
                    encore = false;
                } else if (neworder[1].equals("option")) {
                    /**
                     *    on attrape tous les option on n'en rate jamais un seul
                     */
                    updateonefinaltime = true;
                    encore = false;
                } else if (neworder[1].equals("next")) {
                    /**
                     *    on attrape tous les next on n'en rate jamais un seul
                     */
                    encore = false;
                } else if (neworder[1].equals("next tv")) {
                    /**
                     *    on attrape tous les next on n'en rate jamais un seul
                     */
                    encore = false;
                } else if (neworder[1].equals("dontmissupdate")) {
                    /**
                     *    on attrape tous les initupdate on n'en rate jamais un seul
                     */
                    encore = false;
                } else if (model.commandethreaddrawing.isEmpty() == true) {
                    /**
                     toutes les autres commandes :
                     on attend que la queue soit vide
                     et on ne prend que la dernière
                     */
                    encore = false;
                }
            }

            if (mysurf.fragmenttype != Surf.FRAGMENT_TYPE_DRAWING) {
                llog.d(TAG, currid + " fragmenttype " + mysurf.fragmenttype);
                continue;
            }

            if (mysurf.ScreenWidth < 10 || mysurf.ScreenHeight < 10 || mysurf.drawingSurfaceHolder == null) {
                llog.d(TAG, currid + " Screen too small " + mysurf.ScreenWidth + " " + mysurf.ScreenHeight + " or mysurf.drawingSurfaceHolder == null ");
                continue;
            }

            if (mysurf.drawtoptempbitmap == null || mysurf.drawpilebitmap == null) {
                llog.d(TAG, currid + " drawtoptempbitmap drawpilebitmap null");
                continue;
            }

            needanotherupdate = false;
            clickquicknavmenu = false;
            clicktohandle = false;
            clickquicknav = false;

            if (neworder[1].equals("next tv")) {
                if (neworder[2].equals("droite")) {
                    if (mysurf.OptionMenuShown) {
                        if (mysurf.cursorx < mysurf.SettingsXmin)
                            mysurf.cursorx = mysurf.SettingsXmin + mysurf.SettingsWidth * 0.20f;
                        else
                            mysurf.cursorx = mysurf.SettingsXmin + mysurf.SettingsWidth * 0.80f;
                        mysurf.cursory = model.settingsYmin + model.GenericCaseH * 0.5f;
                    }
                } else if (neworder[2].equals("gauche")) {
                    if (mysurf.OptionMenuShown) {
                        if (mysurf.cursorx > mysurf.SettingsXmin + mysurf.SettingsWidth * 0.50f) {
                            mysurf.cursorx = mysurf.SettingsXmin + mysurf.SettingsWidth * 0.20f;
                            mysurf.cursory = model.settingsYmin + model.GenericCaseH * 0.5f;
                        } else {
                            mysurf.cursorx = mysurf.mywidth * 0.5f;
                            mysurf.cursory = mysurf.myheight * 0.5f;
                        }
                    }
                } else if (neworder[2].equals("haut")) {
                    model.weLastClickedDPadUp = -1;
                    if (mysurf.OptionMenuShown && mysurf.cursorx > mysurf.SettingsXmin) {
                        mysurf.SettingsYmin += model.GenericCaseH + model.GenericInterSpace;
                    }
                } else if (neworder[2].equals("bas")) {
                    model.weLastClickedDPadUp = 1;
                    if (mysurf.OptionMenuShown && mysurf.cursorx > mysurf.SettingsXmin) {
                        mysurf.SettingsYmin -= model.GenericCaseH + model.GenericInterSpace;
                    }
                } else if (neworder[2].equals("ok")) {
                    if (mysurf.OptionMenuShown) {
                        neworder = new String[]{""+currid, "next", String.valueOf(mysurf.cursorx), String.valueOf(mysurf.cursory)};
                    }
                } else if (neworder[2].equals("menu")) {
                    mysurf.OptionMenuShown = !mysurf.OptionMenuShown;
                    if (mysurf.OptionMenuShown) {
                        mysurf.cursorx = mysurf.SettingsXmin + mysurf.SettingsWidth * 0.20f;
                        mysurf.cursory = model.settingsYmin + model.GenericCaseH * 0.5f;
                    } else {
                        mysurf.cursorx = mysurf.mywidth * 0.5f;
                        mysurf.cursory = mysurf.myheight * 0.5f;
                    }
                }
            }

            // pour ceux-là on attend que la liste soit vide et on ne prend que le dernier
            // on se permet donc d'en rater plein
            if (neworder[1].equals("update")) {

            } else if (neworder[1].equals("updateredrawicons")) {
                drawmenuimageloadrecycle();
                drawmenuimageload();

            } else if (neworder[1].equals("move")) {

            } else if (neworder[1].equals("rescale")) {

            } else if (neworder[1].equals("rotate")) {

            } else if (neworder[1].equals("next")) {
                float posfx = Float.parseFloat(neworder[2]);
                float posfy = Float.parseFloat(neworder[3]);

                clickquicknavmenu = true;
                clicktohandlex = posfx;
                clicktohandley = posfy;
            }

            if (!toptemp) {
                int drawbitmapl = mysurf.listecouche.size();
                int drawbitmaplast = drawbitmapl - 1;
                mysurf.drawpilecanvas.drawColor(Color.BLACK);
                for (int k = drawbitmaplast; k >= 0; k--) {
                    Couche couche = mysurf.listecouche.get(k);
                    if (Color.alpha(couche.backgroundcolor) > 0)
                        mysurf.drawpilecanvas.drawColor(couche.backgroundcolor);
                    if (couche.currentbitmap != null) {
                        boolean scaled = scalebitmaponcanvas(couche.x, couche.y, couche.originalw, couche.originalh, couche.scale, mysurf.ScreenWidth, mysurf.ScreenHeight);
                        if (scaled) {
                            mysurf.drawpilecanvas.drawBitmap(couche.currentbitmap, mysurf.srcrect, mysurf.dstrect, null);
                        }
                    }
                }
                boolean success = dessinehandleoptiondraw(mysurf.drawpilecanvas);

                if (success)
                    drawall(toptemp);
            } else {
                drawall(toptemp);
            }

        }
    }

    private void drawall(boolean toptemp) {

        mysurf.surfaceIsCurrentlyDrawing = true;
        if (mysurf.mysurfacestopdrawing) {
            mysurf.surfaceIsCurrentlyDrawing = false;
            return;
        }
        if (mysurf.drawingSurfaceHolder == null) {
            mysurf.surfaceIsCurrentlyDrawing = false;
            return;
        }
        Surface surface = mysurf.drawingSurfaceHolder.getSurface();
        if (surface == null) {
            mysurf.surfaceIsCurrentlyDrawing = false;
            return;
        }
        if (!surface.isValid()) {
            mysurf.surfaceIsCurrentlyDrawing = false;
            return;
        }
        Canvas canv = null;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                canv = mysurf.drawingSurfaceHolder.lockHardwareCanvas();
            } else {
                canv = mysurf.drawingSurfaceHolder.lockCanvas();
            }
        } catch (Exception e) {
            llog.d(TAG, "IllegalStateException " + e);
            e.printStackTrace();
            canv = null;
            return;
        }
        if (canv == null) {
            mysurf.surfaceIsCurrentlyDrawing = false;
            return;
        }

        canv.drawBitmap(mysurf.drawpilebitmap, 0, 0, null);
        if (toptemp)
            canv.drawBitmap(mysurf.drawtoptempbitmap, 0, 0, null);

        if (mysurf.gridalign)
            if (gridalignpoints != null)
                canv.drawPoints(gridalignpoints, gridalignpaint);

        try {
            mysurf.drawingSurfaceHolder.unlockCanvasAndPost(canv);
        } catch (Exception e) {
            llog.d(TAG, " drawall unlockCanvasAndPost " + e);
        }
        mysurf.surfaceIsCurrentlyDrawing = false;
    }


    private boolean scalebitmaponcanvas(float ix0, float iy0, float iw, float ih, float scale, int screenwidth, int screenheight) {
        float ix1 = ix0 + iw * scale;
        float iy1 = iy0 + ih * scale;
        float fwidth = screenwidth;
        float fheight = screenheight;
        if (ix0 < fwidth && iy0 < fheight && ix1 >= 0 && iy1 >= 0) {
            float srcx0, srcy0, srcx1, srcy1;
            float dstx0, dsty0, dstx1, dsty1;
            if (ix0 >= 0.0f) {
                srcx0 = 0.0f;                           // dès le début
                if (ix1 <= fwidth) {
                    srcx1 = iw;                                // jusqu'à la fin
                    dstx1 = ix1;
                } else {
                    srcx1 = (fwidth - ix0) / scale;            // pas jusqu'à la fin
                    dstx1 = fwidth;
                }
                dstx0 = ix0;                                      // on placera en ix0
            } else {
                srcx0 = -ix0 / scale;                  // pas depuis le début
                if (ix1 <= fwidth) {
                    srcx1 = iw;                                // jusqu'à la fin
                    dstx1 = ix1;
                } else {
                    srcx1 = srcx0 + fwidth / scale;            // pas juqu'à la fin
                    dstx1 = fwidth;
                }
                dstx0 = 0.0f;                                      // on placera en 0
            }
            if (iy0 >= 0.0f) {
                srcy0 = 0.0f;                           // dès le début
                if (iy1 <= fheight) {
                    srcy1 = ih;                                // jusqu'à la fin
                    dsty1 = iy1;
                } else {
                    srcy1 = (fheight - iy0) / scale;            // pas jusqu'à la fin
                    dsty1 = fheight;
                }
                dsty0 = iy0;                                      // on placera en iy0
            } else {
                srcy0 = -iy0 / scale;                  // pas depuis le début
                if (iy1 <= fheight) {
                    srcy1 = ih;                                // jusqu'à la fin
                    dsty1 = iy1;
                } else {
                    srcy1 = srcy0 + fheight / scale;            // pas juqu'à la fin
                    dsty1 = fheight;
                }
                dsty0 = 0.0f;                                      // on placera en 0
            }

            mysurf.srcrect = new Rect((int) Math.floor(srcx0),
                    (int) Math.floor(srcy0),
                    (int) Math.floor(srcx1),
                    (int) Math.floor(srcy1));
            mysurf.dstrect = new RectF(dstx0, dsty0, dstx1, dsty1);
            return true;
        }
        return false;
    }

    private void dessinelatrace(int i, Canvas surfacecanvas) {
        float x, y, ox, oy;
        if (i >= mysurf.listedessin.size())
            return;
        Dessin dessin = mysurf.listedessin.get(i);
        int nbdepoint = dessin.x.length;
        if (nbdepoint > 0) {
            int drawerasefillcontour = dessin.drawerasefillcontour;
            model.TracePaint.setColor(dessin.couleur);
            float epaisseur;
            if (dessin.porterduff >= 0)
                model.TracePaint.setXfermode(new PorterDuffXfermode(Dessin.porterduffmodem[dessin.porterduff]));
            if (dessin.geometrictype == Dessin.drawgeometrictypepicture) {
                ox = dessin.x[0];
                oy = dessin.y[0];
                x = dessin.x[1];
                y = dessin.y[1];
                float dx = x - ox;
                float dy = y - oy;
                if (dessin.originalw - 1 < dx && dx < dessin.originalw + 1 && dessin.originalh - 1 < dy && dy < dessin.originalh + 1) {
                    Paint paint = new Paint();
                    paint.setAntiAlias(true);
                    if (dessin.originalpicture != null) {
                        if (!dessin.originalpicture.isRecycled()) {
                            surfacecanvas.drawBitmap(dessin.originalpicture, ox, oy, paint);
                        }
                    }
                } else {
                    Paint paint = new Paint();
                    paint.setAntiAlias(true);
                    if (dessin.originalpicture != null) {
                        if (!dessin.originalpicture.isRecycled()) {
                            Bitmap bmp = Bitmap.createScaledBitmap(dessin.originalpicture, (int) dx, (int) dy, false);
                            surfacecanvas.drawBitmap(bmp, ox, oy, paint);
                            bmp.recycle();
                            bmp = null;
                        }
                    }
                }
            } else if (nbdepoint == 1) {
                if (drawerasefillcontour == Dessin.drawerasefillcontourerase) {
                    // erase ce qu'on a dessiné avec un contour fermé juste ce qu'on a sauvé
                    model.TracePaint.setStyle(Paint.Style.FILL);
                    model.TracePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
                    model.TracePaint.setStrokeWidth(dessin.sizemin);
                    x = dessin.x[0];
                    y = dessin.y[0];
                    surfacecanvas.drawPoint(x, y, model.TracePaint);
                    model.TracePaint.setStyle(Paint.Style.STROKE);
                    model.TracePaint.setXfermode(null);
                } else {
                    model.TracePaint.setStrokeWidth(dessin.sizemin);
                    x = dessin.x[0];
                    y = dessin.y[0];
                    surfacecanvas.drawPoint(x, y, model.TracePaint);
                }
            } else {
                if (drawerasefillcontour == Dessin.drawerasefillcontourdraw) {
                    // draw juste ce qu'on a sauvé
                    ox = dessin.x[0];
                    oy = dessin.y[0];
                    for (int j = 1; j < nbdepoint; j++) {
                        model.TracePaint.setStrokeWidth(dessin.sizemin);
                        x = dessin.x[j];
                        y = dessin.y[j];
                        if (dessin.geometrictype == Dessin.drawgeometrictypeline) {
                            surfacecanvas.drawLine(ox, oy, x, y, model.TracePaint);
                        } else if (dessin.geometrictype == Dessin.drawgeometrictypecircle) {
                            float r = ((float) Math.sqrt((x - ox) * (x - ox) + (y - oy) * (y - oy)));
                            surfacecanvas.drawCircle(ox, oy, r, model.TracePaint);
                        } else if (dessin.geometrictype == Dessin.drawgeometrictyperect) {
                            surfacecanvas.drawRect(ox, oy, x, y, model.TracePaint);
                        }
                        ox = x;
                        oy = y;
                    }
                } else if (drawerasefillcontour == Dessin.drawerasefillcontourerase) {
                    // erase ce qu'on a dessiné avec un contour fermé juste ce qu'on a sauvé
                    model.TracePaint.setStyle(Paint.Style.FILL);
                    model.TracePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
                    ox = dessin.x[0];
                    oy = dessin.y[0];
                    if (dessin.geometrictype == Dessin.drawgeometrictypeline) {
                        Path path = new Path();
                        path.moveTo(ox, oy);
                        for (int j = 1; j < nbdepoint; j++) {
                            model.TracePaint.setStrokeWidth(dessin.sizemin);
                            x = dessin.x[j];
                            y = dessin.y[j];
                            path.lineTo(x, y);
                            ox = x;
                            oy = y;
                        }
                        path.close();
                        surfacecanvas.drawPath(path, model.TracePaint);
                    } else {
                        for (int j = 1; j < nbdepoint; j++) {
                            model.TracePaint.setStrokeWidth(dessin.sizemin);
                            x = dessin.x[j];
                            y = dessin.y[j];
                            if (dessin.geometrictype == Dessin.drawgeometrictypecircle) {
                                float r = ((float) Math.sqrt((x - ox) * (x - ox) + (y - oy) * (y - oy)));
                                surfacecanvas.drawCircle(ox, oy, r, model.TracePaint);
                            } else if (dessin.geometrictype == Dessin.drawgeometrictyperect) {
                                surfacecanvas.drawRect(ox, oy, x, y, model.TracePaint);
                            }
                            ox = x;
                            oy = y;
                        }
                    }
                    model.TracePaint.setStyle(Paint.Style.STROKE);
                    model.TracePaint.setXfermode(null);
                } else if (drawerasefillcontour == Dessin.drawerasefillcontourdrawfill) {
                    // fill juste ce qu'on a sauvé
                    model.TracePaint.setStyle(Paint.Style.FILL);
                    ox = dessin.x[0];
                    oy = dessin.y[0];
                    if (dessin.geometrictype == Dessin.drawgeometrictypeline) {
                        Path path = new Path();
                        path.moveTo(ox, oy);
                        for (int j = 1; j < nbdepoint; j++) {
                            model.TracePaint.setStrokeWidth(dessin.sizemin);
                            x = dessin.x[j];
                            y = dessin.y[j];
                            path.lineTo(x, y);
                            ox = x;
                            oy = y;
                        }
                        path.close();
                        surfacecanvas.drawPath(path, model.TracePaint);
                    } else {
                        for (int j = 1; j < nbdepoint; j++) {
                            model.TracePaint.setStrokeWidth(dessin.sizemin);
                            x = dessin.x[j];
                            y = dessin.y[j];
                            if (dessin.geometrictype == Dessin.drawgeometrictypecircle) {
                                float r = ((float) Math.sqrt((x - ox) * (x - ox) + (y - oy) * (y - oy)));
                                surfacecanvas.drawCircle(ox, oy, r, model.TracePaint);
                            } else if (dessin.geometrictype == Dessin.drawgeometrictyperect) {
                                surfacecanvas.drawRect(ox, oy, x, y, model.TracePaint);
                            }
                            ox = x;
                            oy = y;
                        }
                    }
                    model.TracePaint.setStyle(Paint.Style.STROKE);
                } else if (drawerasefillcontour == Dessin.drawerasefillcontourddrawfillradial) {
                    // fill radial gradient juste ce qu'on a sauvé
                    model.TracePaint.setStyle(Paint.Style.FILL);
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float dx = 0.0f;
                    float sum = 0.0f;
                    ox = dessin.x[0];
                    oy = dessin.y[0];
                    cx += ox;
                    cy += oy;
                    sum += 1.0f;
                    Path path = new Path();
                    path.moveTo(ox, oy);
                    for (int j = 1; j < nbdepoint; j++) {
                        model.TracePaint.setStrokeWidth(dessin.sizemin);
                        x = dessin.x[j];
                        y = dessin.y[j];
                        cx += x;
                        cy += y;
                        sum += 1.0f;
                        path.lineTo(x, y);
                        ox = x;
                        oy = y;
                    }
                    path.close();
                    path.close();
                    cx /= sum;
                    cy /= sum;
                    for (int j = 0; j < nbdepoint; j++) {
                        x = dessin.x[j];
                        y = dessin.y[j];
                        if (dx < Math.abs(x - cx)) {
                            dx = Math.abs(x - cx);
                        }
                        if (dx < Math.abs(y - cy)) {
                            dx = Math.abs(y - cy);
                        }
                    }
                    int couleurcentre = dessin.couleur;
                    int couleurbord = Color.argb(0x00, Color.red(couleurcentre), Color.green(couleurcentre), Color.blue(couleurcentre));
                    model.TracePaint.setShader(new RadialGradient(cx, cy, dx, couleurcentre, couleurbord, Shader.TileMode.CLAMP));
                    surfacecanvas.drawPath(path, model.TracePaint);
                    model.TracePaint.setShader(null);
                    model.TracePaint.setStyle(Paint.Style.STROKE);
                } else if (drawerasefillcontour == Dessin.drawerasefillcontourdrawclose) {
                    // contour fermé juste ce qu'on a sauvé
                    ox = dessin.x[0];
                    oy = dessin.y[0];
                    Path path = new Path();
                    path.moveTo(ox, oy);
                    for (int j = 1; j < nbdepoint; j++) {
                        model.TracePaint.setStrokeWidth(dessin.sizemin);
                        x = dessin.x[j];
                        y = dessin.y[j];
                        path.lineTo(x, y);
                        ox = x;
                        oy = y;
                    }
                    path.close();
                    surfacecanvas.drawPath(path, model.TracePaint);
                }
        /*
        dessin.x[0] += originx / mynewfinalscale;
        dessin.y[0] += originy / mynewfinalscale;
        Path path = new Path();
        path.moveTo(dessin.x[0], dessin.y[0]);
        nbdepoint -= 1;
        for (int j = 1; j < nbdepoint; j++) {
          epaisseur = model.drawtracesizeordonnee.get(i) + model.drawtracesizepente.get(i) * (model.drawtracep.get(i)[j - 1] + model.drawtracep.get(i)[j]) / 2.0f;
          model.TracePaint.setStrokeWidth(epaisseur);
          dessin.x[j] += originx / mynewfinalscale;
          dessin.y[j] += originy / mynewfinalscale;
          path.quadTo(dessin.x[j], dessin.y[j], dessin.x[j + 1], dessin.y[j + 1]);
          surfacecanvas.drawPath(path, model.TracePaint);
          path.reset();
          path.moveTo(dessin.x[j], dessin.y[j]);
        }
        path.reset();
        */
            }
            if (dessin.porterduff >= 0)
                model.TracePaint.setXfermode(null);
        }
    }

    private void recreecanvasenzero(int cettelayer, int screenwidth, int screenheight) {
        // on change la taille du canvas en fonction du zoom pour cette couche
        Couche couche = mysurf.listecouche.get(cettelayer);
        //llog.d(TAG, String.format("  rc0      %2d :    %4.0f,%4.0f   %4.0fx%4.0f   x%.2f", cettelayer, couche.x, couche.y, couche.originalw, couche.originalh, couche.scale));

        float resize = 0.0f;
        if (couche.backupscale != 0) {
            resize = couche.scale / couche.backupscale;
            couche.scale = couche.backupscale;
            couche.backupscale = 0;
        }

        if (screenwidth > 0 && screenheight > 0) {
            couche.originalw = ((float) screenwidth) / couche.scale;
            couche.originalh = ((float) screenheight) / couche.scale;
            if (couche.currentbitmap != null)
                if (!couche.currentbitmap.isRecycled())
                    couche.currentbitmap.recycle();
            couche.currentbitmap = Bitmap.createBitmap((int) couche.originalw, (int) couche.originalh, Bitmap.Config.ARGB_8888);
            couche.canvas = new Canvas(couche.currentbitmap);
        }

        // tous les points sont à une échelle 1 on les décale si la couche a bougé
        if (resize != 0) {
            //llog.d(TAG, "resize " + resize + " scale " + couche.scale + " xy " + couche.x + ", " + couche.y);
            Canvas surfacecanvas = couche.canvas;
            int nbdetrace = mysurf.listedessin.size();
            Dessin dessin;
            float cx = couche.x / couche.scale;
            float cy = couche.y / couche.scale;
            for (int i = 0; i < nbdetrace; i++) {
                dessin = mysurf.listedessin.get(i);
                if (cettelayer == dessin.couche) {
                    int nbdepoint = dessin.x.length;
                    for (int j = 0; j < nbdepoint; j++) {
                        dessin.x[j] = dessin.x[j] * resize + cx;
                        dessin.y[j] = dessin.y[j] * resize + cy;
                    }
                    if (screenwidth > 0 && screenheight > 0)
                        dessinelatrace(i, surfacecanvas);
                }
            }
            couche.gridx += cx;
            couche.gridy += cy;
            couche.x = 0;
            couche.y = 0;
        } else if (couche.x != 0 || couche.y != 0) {
            Canvas surfacecanvas = couche.canvas;
            int nbdetrace = mysurf.listedessin.size();
            Dessin dessin;
            float originx = couche.x / couche.scale;
            float originy = couche.y / couche.scale;
            for (int i = 0; i < nbdetrace; i++) {
                dessin = mysurf.listedessin.get(i);
                if (cettelayer == dessin.couche) {
                    int nbdepoint = dessin.x.length;
                    for (int j = 0; j < nbdepoint; j++) {
                        dessin.x[j] += originx;
                        dessin.y[j] += originy;
                    }
                    if (screenwidth > 0 && screenheight > 0)
                        dessinelatrace(i, surfacecanvas);
                }
            }
            couche.gridx += originx;
            couche.gridy += originy;
            couche.x = 0;
            couche.y = 0;
        } else { // on redessine tout dessus
            if (screenwidth > 0 && screenheight > 0) {
                Canvas surfacecanvas = couche.canvas;
                int nbdetrace = mysurf.listedessin.size();
                Dessin dessin;
                for (int i = 0; i < nbdetrace; i++) {
                    dessin = mysurf.listedessin.get(i);
                    if (cettelayer == dessin.couche)
                        dessinelatrace(i, surfacecanvas);
                }
            }
        }

        if (mysurf.gridalign)
            recreategrid();

        if (screenwidth > 0 && screenheight > 0 && couche.filter != null) {
            if (couche.filter.length() > 0) {
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    couche.currentbitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
                    byte []pngtofilter = stream.toByteArray();
                    //int size = couche.originalbitmap.getRowBytes() * couche.originalbitmap.getHeight();
                    //ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                    //couche.originalbitmap.copyPixelsToBuffer(byteBuffer);
                    //byte[] buffer = byteBuffer.array();
                    int bufferl = pngtofilter.length;
                    if (couche.currentbitmap != null) {
                        couche.canvas = null;
                        if (!couche.currentbitmap.isRecycled()) {
                            couche.currentbitmap.recycle();
                        }
                        couche.currentbitmap = null;
                    }
                    //llog.d(TAG, "draw filterrgb " + couche.filter + " " + bufferl);
                    Bitmap cachedbitmap = Gallery.lib.filterrgb(null, pngtofilter, bufferl, couche.filter);
                    pngtofilter = null;
                    if (cachedbitmap != null) {
                        if (!cachedbitmap.isRecycled()) {
                            couche.currentbitmap = cachedbitmap.copy(Bitmap.Config.ARGB_8888,true);
                            if (!cachedbitmap.isRecycled())
                                cachedbitmap.recycle();
                            couche.canvas = new Canvas(couche.currentbitmap);
                            //llog.d(TAG, "draw filterrgb " + couche.originalw + " x " + couche.originalh + " " + couche.currentbitmap.getWidth() + " x " + couche.currentbitmap.getHeight());
                        }
                        cachedbitmap = null;
                    }
                } catch (Exception e) {
                    llog.d(TAG, "   bigpictureready n'a pas pu être décodé Exception libextractor drawingthread");
                    e.printStackTrace();
                } catch (java.lang.OutOfMemoryError e) {
                    llog.d(TAG, "   bigpictureready n'a pas pu être décodé OutOfMemoryError libextractor drawingthread");
                    e.printStackTrace();
                }
            }
        }

        //llog.d(TAG, String.format("  rc 1     %2d :    %4.0f,%4.0f   %4.0fx%4.0f   x%.2f", cettelayer, couche.x, couche.y, couche.originalw, couche.originalh, couche.scale));
    }

    private void recreecanvaspoursauvegarde(String cefichier) {
        int couchel = mysurf.listecouche.size();
        float scale = 0.0f;

        for (int i = 0; i < couchel; i++) {
            recreecanvasenzero(i, -1, -1);
            Couche couche = mysurf.listecouche.get(i);
            if (couche.scale > scale)
                scale = couche.scale;
        }

        for (int i = 0; i < couchel; i++) {
            Couche couche = mysurf.listecouche.get(i);
            couche.scale = couche.scale / scale;
            recreecanvasenzero(i, -1, -1);
        }

        int dessinl = mysurf.listedessin.size();
        float xmin = 999999.f;
        float ymin = 999999.f;
        float xmax = -999999.f;
        float ymax = -999999.f;
        for (int i = 0; i < dessinl; i++) {
            Dessin dessin = mysurf.listedessin.get(i);
            Couche couche = mysurf.listecouche.get(dessin.couche);
            int nbdepoint = dessin.x.length;
            for (int j = 0; j < nbdepoint; j++) {
                float dessinx = dessin.x[j] * couche.scale + couche.x;
                float dessiny = dessin.y[j] * couche.scale + couche.y;
                if (dessinx < xmin) {
                    xmin = dessinx;
                } else if (dessinx > xmax) {
                    xmax = dessinx;
                }
                if (dessiny < ymin) {
                    ymin = dessiny;
                } else if (dessiny > ymax) {
                    ymax = dessiny;
                }
            }
        }

        float dx = xmax - xmin;
        float dy = ymax - ymin;
        float marge = 0.20f;
        int originalw = (int) Math.round(dx + 2.0f * dx * marge);
        int originalh = (int) Math.round(dy + 2.0f * dy * marge);
        xmin -= dx * marge;
        ymin -= dy * marge;
        llog.d(TAG, String.format(" ctr         %4.0f,%4.0f   %4.0fx%4.0f", xmin, ymin, (float) originalw, (float) originalh));
        // les traces sont déjà rapportées à 1.0f sur originalbitmap size
        if (originalw > 0 && originalh > 0) {
            for (int i = 0; i < couchel; i++) {
                Couche couche = mysurf.listecouche.get(i);
                couche.x -= xmin;
                couche.y -= ymin;
                recreecanvasenzero(i, originalw, originalh);
            }
        }

        if (originalw > 0 && originalh > 0) {
            if (cefichier != null) {
                float scaledown = 0.25f;
                int nw = (int) (originalw * scaledown);
                int nh = (int) (originalh * scaledown);
                Bitmap sauvegardececi = Bitmap.createBitmap(nw, nh, Bitmap.Config.ARGB_8888);
                Canvas sauvegardecanvas = new Canvas(sauvegardececi);
                int drawbitmaplast = couchel - 1;
                int cr = 0x00000000;
                for (int k = drawbitmaplast; k >= 0; k--) {
                    Couche couche = mysurf.listecouche.get(k);
                    if (couche.currentbitmap != null) {
                        if (Color.alpha(couche.backgroundcolor) > 0) {
                            sauvegardecanvas.drawColor(couche.backgroundcolor);
                            if (cr == 0x00000000)
                                cr = (couche.backgroundcolor & 0xfffffff);
                        }
                        boolean scaled = scalebitmaponcanvas(couche.x, couche.y, couche.originalw, couche.originalh, couche.scale, originalw, originalh);
                        if (scaled) {
                            llog.d(TAG, String.format("     png   %2d :    %4.0f,%4.0f -> %4.0f,%4.0f   x%.2f", k, mysurf.dstrect.top, mysurf.dstrect.left, mysurf.dstrect.right, mysurf.dstrect.bottom, scaledown));
                            mysurf.dstrect.top *= scaledown;
                            mysurf.dstrect.left *= scaledown;
                            mysurf.dstrect.right *= scaledown;
                            mysurf.dstrect.bottom *= scaledown;
                            llog.d(TAG, String.format("     png   %2d :    %4.0f,%4.0f -> %4.0f,%4.0f   x%.2f", k, mysurf.dstrect.top, mysurf.dstrect.left, mysurf.dstrect.right, mysurf.dstrect.bottom, scaledown));
                            sauvegardecanvas.drawBitmap(couche.currentbitmap, mysurf.srcrect, mysurf.dstrect, null);
                        }
                    }
                }

                boolean encore = true;
                float top = 0;
                for (int j = 0 ; j < nh && encore ; j++) {
                    for (int i = 0 ; i < nw ; i++) {
                        int c = (sauvegardececi.getPixel(i, j) & 0xfffffff);
                        if (c != cr) {
                            //llog.d(TAG, i + "," + j + " : bg " + cr + " c " + c);
                            top = j - 1;
                            encore = false;
                            break;
                        }
                    }
                }
                encore = true;
                float bottom = 0;
                for (int j = nh - 1 ; j >= 0 && encore ; j--) {
                    for (int i = 0 ; i < nw ; i++) {
                        int c = (sauvegardececi.getPixel(i, j) & 0xfffffff);
                        if (c != cr) {
                            //llog.d(TAG, i + "," + j + " : bg " + cr + " c " + c);
                            bottom = j + 1;
                            encore = false;
                            break;
                        }
                    }
                }
                encore = true;
                float left = 0;
                for (int i = 0 ; i < nw && encore ; i++) {
                    for (int j = 0 ; j < nh ; j++) {
                        int c = (sauvegardececi.getPixel(i, j) & 0xfffffff);
                        if (c != cr) {
                            //llog.d(TAG, i + "," + j + " : bg " + cr + " c " + c);
                            left = i - 1;
                            encore = false;
                            break;
                        }
                    }
                }
                encore = true;
                float right = 0;
                for (int i = nw - 1 ; i >= 0 && encore ; i--) {
                    for (int j = 0 ; j < nh ; j++) {
                        int c = (sauvegardececi.getPixel(i, j) & 0xfffffff);
                        if (c != cr) {
                            //llog.d(TAG, i + "," + j + " : bg " + cr + " c " + c);
                            right = i + 1;
                            encore = false;
                            break;
                        }
                    }
                }
                llog.d(TAG, " x (" + 0 + ") " + left + " -> " + right + " (" + nw + ") y (" + 0 + ") " + top + " -> " + bottom + " -> (" + nh + ")");

                //savebitmaptofile(sauvegardececi, cefichier);
                sauvegardececi.recycle();

                xmin = left / scaledown;
                xmax = right / scaledown;
                ymin = top / scaledown;
                ymax = bottom / scaledown;
                dx = xmax - xmin;
                dy = ymax - ymin;
                originalw = (int) dx;
                originalh = (int) dy;
                for (int i = 0; i < couchel; i++) {
                    Couche couche = mysurf.listecouche.get(i);
                    couche.x -= xmin;
                    couche.y -= ymin;
                    recreecanvasenzero(i, originalw, originalh);
                }

            }
        }

        if (originalw > 0 && originalh > 0) {
            if (cefichier != null) {
                Bitmap sauvegardececi = Bitmap.createBitmap(originalw, originalh, Bitmap.Config.ARGB_8888);
                Canvas sauvegardecanvas = new Canvas(sauvegardececi);
                int drawbitmaplast = couchel - 1;
                for (int k = drawbitmaplast; k >= 0; k--) {
                    Couche couche = mysurf.listecouche.get(k);
                    if (couche.currentbitmap != null) {
                        if (Color.alpha(couche.backgroundcolor) > 0)
                            sauvegardecanvas.drawColor(couche.backgroundcolor);
                        boolean scaled = scalebitmaponcanvas(couche.x, couche.y, couche.originalw, couche.originalh, couche.scale, originalw, originalh);
                        llog.d(TAG, String.format("     png   %2d :    %4.0f,%4.0f   %4.0fx%4.0f   x%.2f", k, couche.x, couche.y, couche.originalw, couche.originalh, couche.scale));
                        if (scaled) {
                            sauvegardecanvas.drawBitmap(couche.currentbitmap, mysurf.srcrect, mysurf.dstrect, null);
                        }
                    }
                }
                savebitmaptofile(sauvegardececi, cefichier);
                sauvegardececi.recycle();
            }
        }
    }

    float posxi, posyi, taillex, ecritx, ecrity, posxf, posyf, posxmax, posymax;
    String ecritoption;
    RectF recti;
    Paint rectangle = new Paint();
    Paint rectangle2 = new Paint();
    float posyibase = 0.0f;
    float quartdelargeurrestante = 5.0f;
    boolean wearemoving = false;

    private boolean dessinehandleoptiondraw(Canvas surfacecanvas) {
        rectangle.setStrokeWidth(0.0f);
        rectangle.setAntiAlias(false);
        rectangle.setStyle(Paint.Style.FILL);
        rectangle2.setColor(Color.BLACK);
        rectangle2.setAntiAlias(true);
        rectangle2.setStrokeWidth(0.0f);
        rectangle2.setStyle(Paint.Style.FILL);
        posxmax = 0.0f;
        posymax = 0.0f;
        wearemoving = false;
        if (neworder[1].equals("menudessiner")) {
            clicktohandlex = Float.parseFloat(neworder[3]);
            clicktohandley = Float.parseFloat(neworder[4]);
            clickquicknavmenu = true;
            if (neworder[2].equals("move")) {
                wearemoving = true;
            }
            //llog.d(TAG, neworder[1] + " " + neworder[2] + " " + clickquicknavmenu);
        }

        posyf = mysurf.drawmovemenusizeyi;

        posxf = 0.0f;
        posyi = posyf + model.DessinInterSpace;
        menusize(surfacecanvas);
        menushowadvancedmenu(surfacecanvas);
        menuquit(surfacecanvas);
        //if (!menuquit(surfacecanvas))
        //    return false;
        //menusave(surfacecanvas);
        //menuclear(surfacecanvas);
        //menurecycle(surfacecanvas);
        menustylus(surfacecanvas);
        posxf += model.DessinInterSpace * 4.0f;
        menuaddpic(surfacecanvas);
        menufx(surfacecanvas);
        menugrid(surfacecanvas);
        menulayer(surfacecanvas);
        menucolor(surfacecanvas);
        //menucontrast(surfacecanvas);
        menudrawsize(surfacecanvas);
        posxf += model.DessinInterSpace * 4.0f;
        menudrawtype(surfacecanvas);
        float drawtypexr = posxf;
        menudrawgeometric(surfacecanvas);
        menuselection(surfacecanvas);
        float drawselxr = posxf;
        menuzoom(surfacecanvas);
        menuresize(surfacecanvas);
        menuundo(surfacecanvas);
        //menuselectlast(surfacecanvas);
        //menuduplicate(surfacecanvas);
        //menuchange(surfacecanvas);
        float drawxrmax = posxf;

        if (mysurf.drawmenucolor || mysurf.drawdevelopmenutype || mysurf.drawdevelopmenuselection || mysurf.drawmenugeometric)
            posyi = posyf + model.DessinInterSpace;
        posxf = 0.0f;

        int countcolomns = 0;
        if (mysurf.drawmenucolor) {
            menubgcolor(surfacecanvas);
            menupickcolor(surfacecanvas);
            menupickcolorclosest(surfacecanvas);
            menupickthicknessclosest(surfacecanvas);
            menucolorexpand(surfacecanvas);
        }
        countcolomns += 5;

        if (mysurf.drawdevelopmenutype) {
            posxf = (model.DessinCaseH + model.DessinInterSpace * 2.0f) * countcolomns;
            menudrawtypedevelop(surfacecanvas, 0);
            menudrawtypedevelop(surfacecanvas, 1);
            menudrawtypedevelop(surfacecanvas, 2);
            menudrawtypedevelop(surfacecanvas, 3);
            menudrawtypedevelop(surfacecanvas, 4);
        }
        countcolomns += 5;

        if (mysurf.drawmenugeometric) {
            posxf = (model.DessinCaseH + model.DessinInterSpace * 2.0f) * countcolomns;
            menudrawgeometriclines(surfacecanvas);
            menudrawgeometriccircle(surfacecanvas);
        }
        countcolomns += 2;

        if (mysurf.drawdevelopmenuselection) {
            posxf = (model.DessinCaseH + model.DessinInterSpace * 2.0f) * countcolomns;
            menuselectiondevelop(surfacecanvas, Gallery.selectedtraceselectmultiple);
            countcolomns += 1;
            if (selectmultiple) {
                menuselectiondevelop(surfacecanvas, Gallery.selectedtraceselectmultipleremove);
                menuselectiondevelop(surfacecanvas, Gallery.selectedtraceselectmultipleadd);
                countcolomns += 2;
            }
            if (!selectmultiple) {
                menuselectiondevelop(surfacecanvas, Gallery.selectedtraceerase);
                countcolomns += 1;
            }
            menuselectiondevelop(surfacecanvas, Gallery.selectedtracecolor);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtracethickness);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtraceduplicate);
            countcolomns += 3;
            if (!selectmultiple) {
                menuselectiondevelop(surfacecanvas, Gallery.selectedtracemovetrace);
                menuselectiondevelop(surfacecanvas, Gallery.selectedtracemovepoint);
                countcolomns += 2;
            }
            menuselectiondevelop(surfacecanvas, Gallery.selectedtracemoveto);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtracechangetype);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtraceunder);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtraceover);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtraceresize);
            menuselectiondevelop(surfacecanvas, Gallery.selectedtracechangeporterduff);
            countcolomns += 6;
        }

        if (mysurf.drawmenucolor) {
            posxf = 0.0f;
            posyi = posyf + model.DessinInterSpace;
            if (colormenuexpand) {
                quartdelargeurrestante = mysurf.ScreenWidth - 2.0f * model.DessinInterSpace;
                posxf = 0.0f;
            } else {
                quartdelargeurrestante = (mysurf.ScreenWidth - posxf - 8.0f * model.DessinInterSpace) / 4.0f;
            }
            menucolorh(surfacecanvas);
            if (colormenuexpand) {
                posxf = 0.0f;
                posyi = posyf + model.DessinInterSpace;
            }
            menucolors(surfacecanvas);
            if (colormenuexpand) {
                posxf = 0.0f;
                posyi = posyf + model.DessinInterSpace;
            }
            menucolorv(surfacecanvas);
            if (colormenuexpand) {
                posxf = 0.0f;
                posyi = posyf + model.DessinInterSpace;
            }
            menucolora(surfacecanvas);
        }

        /*if (mysurf.drawmenusize){
          posxf = 0.0f;
          posyi = posyf + model.DessinInterSpace;
          menupressurecst(surfacecanvas);
          menupointsize(surfacecanvas);
          if (mysurf.pressuresize) {
            posxf = 0.0f;
            posyi = posyf + model.DessinInterSpace;
            menupressure(surfacecanvas);
            menupressure2(surfacecanvas);
          }
        }*/

        if (mysurf.drawmenupath) {
            posxf = 0.0f;
            posyi = posyf + model.DessinInterSpace;
            menudrawpath(surfacecanvas);
        }

        if (mysurf.OptionMenuShown) {

            mabase = mysurf.SettingsYmin;
            roundedRectRatio = model.GenericCaseH * 0.2f;
            quatredixiememillimetre = model.GenericCaseH * 0.12f;
            mysurf.SettingsXmin = mysurf.ScreenWidth - mysurf.SettingsWidth;

            menuquit8(surfacecanvas);
            menuzoom8(surfacecanvas);
            menusize8(surfacecanvas);
            menulayer8(surfacecanvas);
            menugridsize(surfacecanvas);
            menumodify(surfacecanvas, 1);
            menucompositing8(surfacecanvas);

            if (mysurf.SettingsYmin > mysurf.myheight - model.GenericCaseH)
                mysurf.SettingsYmin = model.settingsYmin;
            mysurf.SettingsYmax = mabase;
            if (mysurf.SettingsYmax < model.GenericCaseH)
                mysurf.SettingsYmin = model.settingsYmin;

        }

        posxmax = mysurf.ScreenWidth;
        if (posyf > posymax)
            posymax = posyf;

        int cettelayer = -1;

        if (clickquicknavmenu && mysurf.selectedtrace > 0) {
            int cl = selclosestpath.size();
            if (mysurf.selectedtrace == Gallery.selectedtraceselectmultipleadd && !wearemoving) {
                cl = findclosestpath(clicktohandlex, clicktohandley);
            } else if (mysurf.selectedtrace == Gallery.selectedtraceselectmultipleremove && !wearemoving) {
            } else if (mysurf.selectedtrace == Gallery.selectedtraceerase && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    Dessin dessin = mysurf.listedessin.get(selclosestpath.get(0));
                    cettelayer = dessin.couche;
                    if (dessin.geometrictype == Dessin.drawgeometrictypepicture) {
                        if (dessin.originalpicture != null) {
                            if (!dessin.originalpicture.isRecycled()) {
                                dessin.originalpicture.recycle();
                                dessin.originalw = 0;
                                dessin.originalh = 0;
                            }
                            dessin.originalpicture = null;
                        }
                    }
                    mysurf.listedessin.remove((int) selclosestpath.get(0));
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracecolor && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        Dessin cedessin = mysurf.listedessin.get(selclosestpath.get(i));
                        cedessin.couleura = mysurf.drawtracecurrcolora;
                        cedessin.couleurh = mysurf.drawtracecurrcolorh;
                        cedessin.couleurs = mysurf.drawtracecurrcolors;
                        cedessin.couleurv = mysurf.drawtracecurrcolorv;
                        cedessin.generecouleur();
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracethickness && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        Dessin cedessin = mysurf.listedessin.get(selclosestpath.get(i));
                        cedessin.pressuremax = model.drawtracepressuremax;
                        cedessin.pressuremin = model.drawtracepressuremin;
                        cedessin.sizemin = mysurf.drawtracecurrsizemin;
                        cedessin.sizemax = mysurf.drawtracecurrsizemax;
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracechangetype && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        Dessin cedessin = mysurf.listedessin.get(selclosestpath.get(i));
                        cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracechangeporterduff && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        Dessin cedessin = mysurf.listedessin.get(selclosestpath.get(i));
                        cedessin.porterduff = mysurf.drawporterduff;
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtraceunder && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        int oldpos = selclosestpath.get(i);
                        if (oldpos > 0) {
                            Dessin cedessin = mysurf.listedessin.get(oldpos);
                            mysurf.listedessin.add(oldpos - 1, cedessin);
                            mysurf.listedessin.remove(oldpos + 1);
                        }
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtraceover && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    int dl = mysurf.listedessin.size() - 1;
                    for (int i = 0; i < cl; i++) {
                        int oldpos = selclosestpath.get(i);
                        if (oldpos < dl) {
                            Dessin cedessin = mysurf.listedessin.get(oldpos);
                            mysurf.listedessin.add(oldpos + 2, cedessin);
                            mysurf.listedessin.remove(oldpos);
                        }
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtraceresize && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    float ratio = mysurf.selectedtraceresizeratio;
                    boolean init = true;
                    float xi = 0;
                    float yi = 0;
                    float xf = 0;
                    float yf = 0;
                    for (int i = 0; i < cl; i++) {
                        int oldpos = selclosestpath.get(i);
                        Dessin cedessin = mysurf.listedessin.get(oldpos);
                        int nbpointrace = cedessin.x.length;
                        for (int k = 0; k < nbpointrace; k++) {
                            if (init || cedessin.x[k] < xi)
                                xi = cedessin.x[k];
                            if (init || cedessin.y[k] < yi)
                                yi = cedessin.y[k];
                            if (init || cedessin.x[k] > xf)
                                xf = cedessin.x[k];
                            if (init || cedessin.y[k] > yf)
                                yf = cedessin.y[k];
                            if (init)
                                init = false;
                        }
                    }
                    float cx = (xi + xf) * 0.5f;
                    float cy = (yi + yf) * 0.5f;
                    for (int i = 0; i < cl; i++) {
                        int oldpos = selclosestpath.get(i);
                        Dessin cedessin = mysurf.listedessin.get(oldpos);
                        int nbpointrace = cedessin.x.length;
                        for (int k = 0; k < nbpointrace; k++) {
                            cedessin.x[k] = (cedessin.x[k] - cx) * ratio + cx;
                            cedessin.y[k] = (cedessin.y[k] - cy) * ratio + cy;
                        }
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracemovetrace && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0 && !selectmultiple)
                    mysurf.selectedtrace = Gallery.selectedtracemoveto;
            } else if (mysurf.selectedtrace == Gallery.selectedtracemovepoint && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0 && !selectmultiple)
                    mysurf.selectedtrace = Gallery.selectedtracemoveto;
            } else if (mysurf.selectedtrace == Gallery.selectedtraceduplicate && !wearemoving) {
                if (!selectmultiple)
                    cl = findclosestpath(clicktohandlex, clicktohandley);
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    for (int i = 0; i < cl; i++) {
                        Dessin olddessin = mysurf.listedessin.get(selclosestpath.get(i));
                        Dessin cedessin = new Dessin();
                        int nbpointrace = olddessin.x.length;
                        cedessin.x = new float[nbpointrace];
                        cedessin.y = new float[nbpointrace];
                        cedessin.p = new float[nbpointrace];
                        cedessin.d = new float[nbpointrace];
                        cedessin.t = new float[nbpointrace];
                        for (int k = 0; k < nbpointrace; k++) {
                            cedessin.x[k] = olddessin.x[k];
                            cedessin.y[k] = olddessin.y[k];
                            cedessin.p[k] = olddessin.p[k];
                            cedessin.d[k] = olddessin.d[k];
                            cedessin.t[k] = olddessin.t[k];
                        }
                        cedessin.couleura = olddessin.couleura;
                        cedessin.couleurh = olddessin.couleurh;
                        cedessin.couleurs = olddessin.couleurs;
                        cedessin.couleurv = olddessin.couleurv;
                        cedessin.generecouleur();
                        cedessin.pressuremax = olddessin.pressuremax;
                        cedessin.pressuremin = olddessin.pressuremin;
                        cedessin.sizemin = olddessin.sizemin;
                        cedessin.sizemax = olddessin.sizemax;
                        cedessin.drawerasefillcontour = olddessin.drawerasefillcontour;
                        cedessin.bezierlength = olddessin.bezierlength;
                        cedessin.geometrictype = olddessin.geometrictype;
                        cedessin.porterduff = olddessin.porterduff;
                        if (olddessin.geometrictype == Dessin.drawgeometrictypepicture && olddessin.originalpicture != null && olddessin.originalw > 0 && olddessin.originalh > 0) {
                            if (!olddessin.originalpicture.isRecycled()) {
                                cedessin.originalw = olddessin.originalw;
                                cedessin.originalh = olddessin.originalh;
                                cedessin.originalpicture = Bitmap.createBitmap((int) cedessin.originalw, (int) cedessin.originalh, Bitmap.Config.ARGB_8888);
                                Canvas canvas = new Canvas(cedessin.originalpicture);
                                Paint paint = new Paint();
                                paint.setAntiAlias(true);
                                canvas.drawBitmap(olddessin.originalpicture, 0, 0, paint);
                            } else
                                cedessin.geometrictype = Dessin.drawgeometrictypeline;
                        } else
                            cedessin.geometrictype = Dessin.drawgeometrictypeline;
                        int cettelayer2 = mysurf.drawcurrlayer;
                        if (cettelayer2 < 0)
                            cettelayer2 = 0;
                        cedessin.couche = cettelayer2;
                        mysurf.listedessin.add(cedessin);
                        //Canvas thissurfacecanvas = mysurf.listecouche.get(cettelayer2).canvas;
                        //dessinelatrace(closestpath + 1, thissurfacecanvas);
                    }
                }
            } else if (mysurf.selectedtrace == Gallery.selectedtracemoveto) {
                if (cl > 0) {
                    cettelayer = mysurf.listedessin.get(selclosestpath.get(0)).couche;
                    Couche couche = mysurf.listecouche.get(cettelayer);
                    float dx = 0;
                    float dy = 0;
                    if (mysurf.gridalign) {
                        float gridaligndx = ((mysurf.gridalignd + couche.gridx) % mysurf.gridalignd);
                        float gridaligndy = ((mysurf.gridalignd + couche.gridy) % mysurf.gridalignd);
                        float nx = (float) Math.round((clicktohandlex - gridaligndx) / mysurf.gridalignd);
                        clicktohandlex = nx * mysurf.gridalignd + gridaligndx;
                        float ny = (float) Math.round((clicktohandley - gridaligndy) / mysurf.gridalignd);
                        clicktohandley = ny * mysurf.gridalignd + gridaligndy;
                    }
                    for (int i = 0; i < cl; i++) {
                        Dessin cedessin = mysurf.listedessin.get(selclosestpath.get(i));
                        if (cedessin.x != null) {
                            if (selectedtracemovepointortrace == Gallery.selectedtracemovetrace || selectmultiple) {
                                if (selclosestpathpoint.get(i) < cedessin.x.length && selclosestpathpoint.get(i) < cedessin.y.length) {
                                    float scale = couche.scale;
                                    if (scale == 0)
                                        scale = 1;
                                    if (i == 0) {
                                        dx = clicktohandlex / scale - cedessin.x[selclosestpathpoint.get(i)];
                                        dy = clicktohandley / scale - cedessin.y[selclosestpathpoint.get(i)];
                                    }
                                    int xl = cedessin.x.length;
                                    for (int ii = 0; ii < xl; ii++) {
                                        cedessin.x[ii] += dx;
                                        cedessin.y[ii] += dy;
                                    }
                                    if (selectedtraceclicked != Gallery.selectedtracemoveto && !selectmultiple
                                            && !wearemoving) { // if wearemoving keep moving around the picked point
                                        mysurf.selectedtrace = Gallery.selectedtracemovetrace;
                                    }
                                }
                            } else if (selectedtracemovepointortrace == Gallery.selectedtracemovepoint) {
                                if (selclosestpathpoint.get(i) < cedessin.x.length && selclosestpathpoint.get(i) < cedessin.y.length) {
                                    float scale = couche.scale;
                                    if (scale == 0)
                                        scale = 1;
                                    cedessin.x[selclosestpathpoint.get(i)] = clicktohandlex / scale;
                                    cedessin.y[selclosestpathpoint.get(i)] = clicktohandley / scale;
                                    if (selectedtraceclicked != Gallery.selectedtracemoveto
                                            && !wearemoving) { // if wearemoving keep moving around the picked point
                                        mysurf.selectedtrace = Gallery.selectedtracemovepoint;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if (
                ((mysurf.selectedtrace == Gallery.selectedtraceselectmultipleadd || mysurf.selectedtrace == Gallery.selectedtraceselectmultipleremove) && selectmultiple)
                || (mysurf.selectedtrace == Gallery.selectedtracemoveto || mysurf.selectedtrace == Gallery.selectedtracemovepoint)
        ) {
            animateselection = 1;
        } else if (animateselection == 1) {
            animateselection = 2;
        }

        if (mysurf.selectedtrace != Gallery.selectedtracecolor
                && (mysurf.selectedtrace == Gallery.selectedtracemoveto || selectmultiple)) {
            int cl = selclosestpath.size();
            float scale = 1;

            if (cettelayer == -1) {
                cettelayer = mysurf.drawcurrlayer;
                if (mysurf.drawcurrlayer == -1)
                    cettelayer = 0;
                if (cettelayer < mysurf.listecouche.size())
                    scale = mysurf.listecouche.get(cettelayer).scale;
                if (scale == 0)
                    scale = 1;
            }

            float radius = 20;
            alphad = (alphad + 50.0f) % 255.0f;
            for (int i = 0; i < cl; i++) {
                if (animateselection == 1) {
                    int currsel = selclosestpath.get(i);
                    int listedessinl = mysurf.listedessin.size();
                    if (currsel < listedessinl) {
                        Dessin dessin = mysurf.listedessin.get(currsel);
                        dessin.couleura = alphad;
                        dessin.generecouleur();
                    }
                }
                if (mysurf.selectedtrace == Gallery.selectedtracemoveto || mysurf.selectedtrace == Gallery.selectedtracemovepoint) {
                    int currsel = selclosestpath.get(i);
                    int listedessinl = mysurf.listedessin.size();
                    if (currsel < listedessinl) {
                        Dessin dessin = mysurf.listedessin.get(currsel);
                        if (dessin.x != null) {
                            int xl = dessin.x.length;
                            if (xl > 0) {
                                for (int j = 0 ; j < xl ; j++) {
                                    if (j < 2 || j >= xl - 2)
                                        surfacecanvas.drawCircle(dessin.x[j] * scale, dessin.y[j] * scale, radius, model.DessinSelectedPaint);
                                }
                            }
                        }
                        surfacecanvas.drawCircle(selclosestpathpointx.get(i) * scale, selclosestpathpointy.get(i) * scale, radius, model.DessinSelectedPaint);
                        surfacecanvas.drawCircle(selclosestpathpointx.get(i) * scale, selclosestpathpointy.get(i) * scale, radius * 1.5f, model.DessinSelectedPaint);
                    } else {
                        if (i == 0) {
                            surfacecanvas.drawCircle(selclosestpathpointx.get(i) * scale, selclosestpathpointy.get(i) * scale, radius, model.DessinSelectedPaint);
                        }
                    }
                }
            }
        }

        if (animateselection == 2) {
            resetselclosestpathalpha();
            if (cettelayer == -1) {
                cettelayer = mysurf.drawcurrlayer;
                if (mysurf.drawcurrlayer == -1)
                    cettelayer = 0;
            }
            animateselection = 0;
        }

        if (cettelayer >= 0) {
            if (cettelayer < mysurf.listecouche.size()) {
                recreecanvasenzero(cettelayer, mysurf.ScreenWidth, mysurf.ScreenHeight);
            }
        }

        if (posxmax != mysurf.drawmenutotalw)
            mysurf.drawmenutotalw = posxmax;
        if (posymax != mysurf.drawmenutotalh)
            mysurf.drawmenutotalh = posymax;

        if (needanotherupdate) {
            try {
                model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "update"});
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        return true;
    }

    private int animateselection = 0;

    private void resetselclosestpathalpha() {
        int cl = selclosestpath.size();
        for (int i = 0; i < cl; i++) {
            int currsel = selclosestpath.get(i);
            int listedessinl = mysurf.listedessin.size();
            if (currsel < listedessinl) {
                Dessin dessin = mysurf.listedessin.get(currsel);
                dessin.couleura = selclosestpathalpha.get(i);
                dessin.generecouleur();
            }
        }
    }

    private float alphad = 0.0f;
    private ArrayList<Integer> selclosestpath = new ArrayList<>();
    private ArrayList<Integer> selclosestpathpoint = new ArrayList<>();
    private ArrayList<Float> selclosestpathpointx = new ArrayList<>();
    private ArrayList<Float> selclosestpathpointy = new ArrayList<>();
    private ArrayList<Float> selclosestpathalpha = new ArrayList<>();
    private int selectedtracemovepointortrace = 0;

    public int findclosestpath(float x, float y) {
        if (!selectmultiple) {
            if (animateselection == 1) {
                resetselclosestpathalpha();
                animateselection = 2;
            }
            selclosestpath.clear();
            selclosestpathpoint.clear();
            selclosestpathpointx.clear();
            selclosestpathpointy.clear();
            selclosestpathalpha.clear();
        }
        int selclosestpathu = -1;
        int selclosestpathpointu = -1;
        float selclosestpathpointxu = -1;
        float selclosestpathpointyu = -1;
        float selclosestpathalphau = -1;
        float scale = 1;
        int cettelayer = mysurf.drawcurrlayer;
        if (cettelayer == -1) {
            mysurf.drawcurrlayer = 0;
            cettelayer = 0;
        }
        if (cettelayer < mysurf.listecouche.size()) {
            Couche cettecouche = mysurf.listecouche.get(cettelayer);
            scale = cettecouche.scale;
            if (scale == 0)
                scale = 1;
            x = (x - cettecouche.x) / scale;
            y = (y - cettecouche.y) / scale;
        }
        int listedessinl = mysurf.listedessin.size();
        float meilleurv = -1.0f;
        Dessin cedessin;
        int selclosestpathl = selclosestpath.size();
        boolean adeja;
        for (int i = 0; i < listedessinl; i++) {
            adeja = false;
            for (int k = 0; k < selclosestpathl; k++) {
                if (selclosestpath.get(k) == i) {
                    adeja = true;
                    break;
                }
            }
            if (adeja)
                continue;
            cedessin = mysurf.listedessin.get(i);
            if (cedessin.couche == cettelayer) {
                if (cedessin.x != null) {
                    if (cedessin.x.length > 0) {
                        for (int j = 0; j < cedessin.x.length; j++) {
                            float d2 = (cedessin.x[j] - x) * (cedessin.x[j] - x)
                                    + (cedessin.y[j] - y) * (cedessin.y[j] - y);
                            if (d2 < meilleurv || meilleurv < 0) {
                                meilleurv = d2;
                                selclosestpathu = i;
                                selclosestpathpointu = j;
                                selclosestpathpointxu = cedessin.x[j];
                                selclosestpathpointyu = cedessin.y[j];
                                selclosestpathalphau = cedessin.couleura;
                            }
                        }
                    }
                }
            }
        }
        if (selclosestpathu >= 0) {
            selclosestpath.add(selclosestpathu);
            selclosestpathpoint.add(selclosestpathpointu);
            selclosestpathpointx.add(selclosestpathpointxu);
            selclosestpathpointy.add(selclosestpathpointyu);
            selclosestpathalpha.add(selclosestpathalphau);
        }
        return selclosestpath.size();
    }

    public boolean menushowadvancedmenu(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.OptionMenuShown = !mysurf.OptionMenuShown;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.OptionMenuShown)
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        //surfacecanvas.drawBitmap(menusize, posxi, posyi, null);
        surfacecanvas.drawText("menu", posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menusize(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawmovemenusize = !mysurf.drawmovemenusize;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.drawmovemenusize)
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        surfacecanvas.drawBitmap(menusize, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }
    public void menusize8(Canvas surfacecanvas) {
        ecritoption = "resize menu";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.drawmovemenusize = !mysurf.drawmovemenusize;
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if (mysurf.drawmovemenusize) {
            RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
          }
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;
    }

    public boolean menuquit(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.OptionMenuShown = !mysurf.OptionMenuShown;
                mysurf.drawmenuquit = mysurf.OptionMenuShown;
                return false;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(quit, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    private void menuzoom8(Canvas surfacecanvas) {
        ecritoption = "zoom reset";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                int couchel = mysurf.listecouche.size();
                float scale = 0.0f;
                for (int i = 0; i < couchel; i++) {
                    recreecanvasenzero(i, -1, -1);
                    Couche couche = mysurf.listecouche.get(i);
                    if (couche.scale > scale)
                        scale = couche.scale;
                }
                for (int i = 0; i < couchel; i++) {
                    Couche couche = mysurf.listecouche.get(i);
                    couche.scale = couche.scale / scale;
                    recreecanvasenzero(i, mysurf.myscreenwidth, mysurf.myscreenheight);
                }
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;
    }

    private void menuquit8(Canvas surfacecanvas) {
        ecritoption = "quit";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.drawmenuquit = !mysurf.drawmenuquit;
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;

        if (mysurf.drawmenuquit) {
            ecritoption = "save and quit";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    Intent intent = new Intent();
                    intent.setAction(Gallery.broadcastname);
                    intent.putExtra("goal", "startbrowser");
                    intent.putExtra("id", currid);
                    LocalBroadcastManager.getInstance(model.activitycontext).sendBroadcast(intent);
                    llog.d(TAG, "quit");
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            ecritoption = "save";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    writelastdrawing();
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            ecritoption = "save start anew";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "closedrawing", "save"});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "initialize", "startblank"});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            ecritoption = "delete start anew";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "closedrawing", "donotsave"});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "initialize", "startblank"});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            ecritoption = "delete and quit";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    try {
                        model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "closedrawing", "donotsave"});
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Intent intent = new Intent();
                    intent.setAction(Gallery.broadcastname);
                    intent.putExtra("goal", "startbrowser");
                    intent.putExtra("id", currid);
                    LocalBroadcastManager.getInstance(model.activitycontext).sendBroadcast(intent);
                    llog.d(TAG, "quit");
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;
        }
    }

    public boolean menusave(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                writelastdrawing();
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(save, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuclear(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                try {
                    model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "closedrawing", "save"});
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "initialize", "startblank"});
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(erase, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menurecycle(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                try {
                    model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "closedrawing", "donotsave"});
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "initialize", "startblank"});
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(recycle, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }


    public boolean menustylus(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.styluspalmrejection = !mysurf.styluspalmrejection;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.styluspalmrejection) {
            surfacecanvas.drawBitmap(stylus, posxi, posyi, null);
        } else {
            surfacecanvas.drawBitmap(hand, posxi, posyi, null);
        }
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuaddpic(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                llog.d(TAG, "on charge le fichier " + mysurf.mediaIndexAddress);
                if (mysurf.isincache(mysurf.mediaIndexAddress)) {
                    llog.d(TAG, "on charge le fichier en cache");
                    float[] cachedbitmapnfo = mysurf.getcachedbitmapnfo(mysurf.mediaIndexAddress);
                    int bitmapwidth = (int) cachedbitmapnfo[0];
                    int bitmapheight = (int) cachedbitmapnfo[1];

                    int cettelayer = 0;
                    if (mysurf.drawcurrlayer >= 0)
                        cettelayer = mysurf.drawcurrlayer;

                    int drawtracexl = mysurf.listedessin.size();
                    Dessin cedessin = new Dessin();
                    cedessin.nbdepoints = 2;
                    int drawtracecurrl = cedessin.nbdepoints;
                    cedessin.x = new float[drawtracecurrl];
                    cedessin.y = new float[drawtracecurrl];
                    cedessin.p = new float[drawtracecurrl];
                    cedessin.t = new float[drawtracecurrl];
                    cedessin.d = new float[drawtracecurrl];
                    cedessin.x[0] = 0.0f;
                    cedessin.y[0] = 0.0f;
                    cedessin.p[0] = 0.0f;
                    cedessin.t[0] = 0.0f;
                    cedessin.d[0] = 0.0f;
                    cedessin.x[1] = cachedbitmapnfo[0];
                    cedessin.y[1] = cachedbitmapnfo[1];
                    cedessin.p[1] = 0.0f;
                    cedessin.t[1] = 0.0f;
                    cedessin.d[1] = 0.0f;
                    mysurf.drawtracecurr.clear();
                    cedessin.couleura = mysurf.drawtracecurrcolora;
                    cedessin.couleurh = mysurf.drawtracecurrcolorh;
                    cedessin.couleurs = mysurf.drawtracecurrcolors;
                    cedessin.couleurv = mysurf.drawtracecurrcolorv;
                    cedessin.generecouleur();
                    cedessin.sizemax = mysurf.drawtracecurrsizemax;
                    cedessin.sizemin = mysurf.drawtracecurrsizemin;
                    cedessin.pressuremax = model.drawtracepressuremax;
                    cedessin.pressuremin = model.drawtracepressuremin;
                    cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                    cedessin.bezierlength = mysurf.drawtracecurrbezier;
                    cedessin.geometrictype = Dessin.drawgeometrictypepicture;
                    cedessin.porterduff = mysurf.drawporterduff;
                    cedessin.couche = cettelayer;
                    cedessin.originalw = cachedbitmapnfo[0];
                    cedessin.originalh = cachedbitmapnfo[1];
                    cedessin.originalpicture = Bitmap.createBitmap(bitmapwidth, bitmapheight, Bitmap.Config.ARGB_8888);

                    Canvas canvas = new Canvas(cedessin.originalpicture);
                    canvas.drawBitmap(mysurf.getcachedbitmap(mysurf.mediaIndexAddress), 0, 0, null);
                    mysurf.listedessin.add(cedessin);

                    // on dessine la nouvelle dernière trace sur sa layer
                    Couche cettecouche = mysurf.listecouche.get(cettelayer);
                    dessinelatrace(drawtracexl, cettecouche.canvas);
                    //mysurf.drawtoptempcanvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR);

                    /*
                    Couche macouche = new Couche();
                    macouche.originalbitmap = Bitmap.createBitmap(bitmapwidth, bitmapheight, Bitmap.Config.ARGB_8888);
                    macouche.canvas = new Canvas(macouche.originalbitmap);
                    macouche.canvas.drawBitmap(mysurf.getcachedbitmap(mysurf.mediaIndexAddress), 0, 0, null);
                    macouche.currentbitmap = Bitmap.createBitmap(bitmapwidth, bitmapheight, Bitmap.Config.ARGB_8888);
                    macouche.canvas = new Canvas(macouche.currentbitmap);
                    macouche.canvas.drawBitmap(mysurf.getcachedbitmap(mysurf.mediaIndexAddress), 0, 0, null);
                    macouche.isaphoto = true;
                    macouche.x = 0.0f;
                    macouche.y = 0.0f;
                    macouche.originalw = bitmapwidth;
                    macouche.originalh = bitmapheight;
                    macouche.scale = 1.0f;
                    mysurf.listecouche.add(macouche);
                    */
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(addpic, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menufx(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.OptionMenuShown = !mysurf.OptionMenuShown;
                mysurf.optionshowmodifypic = mysurf.OptionMenuShown;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.optionshowmodifypic)
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        surfacecanvas.drawBitmap(contrast, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    private float[] gridalignpoints = null;
    private Paint gridalignpaint = null;
    public void recreategrid(){
        int cettelayer = 0;
        if (mysurf.drawcurrlayer >= 0)
            cettelayer = mysurf.drawcurrlayer;
        Couche couche = mysurf.listecouche.get(cettelayer);
        float gridalignd = mysurf.gridalignd * couche.scale;
        float gridaligndx = ((mysurf.gridalignd + couche.gridx) % mysurf.gridalignd) * couche.scale + couche.x;
        float gridaligndy = ((mysurf.gridalignd + couche.gridy) % mysurf.gridalignd) * couche.scale + couche.y;
        int count = (int) (Math.ceil(mysurf.myscreenwidth / gridalignd)) * ((int) Math.ceil(mysurf.myscreenheight / gridalignd)) * 2;
        gridalignpoints = new float[count];
        int i = 0;
        for (float y = gridaligndy ; y < mysurf.myscreenheight ; y += gridalignd) {
            for (float x = gridaligndx; x < mysurf.myscreenwidth; x += gridalignd) {
                if (i < count - 1) {
                    gridalignpoints[i] = x;
                    gridalignpoints[i + 1] = y;
                }
                i += 2;
            }
        }
        gridalignpaint = new Paint();
        gridalignpaint.setStrokeWidth(2);
        gridalignpaint.setColor(Color.rgb(128, 128, 128));
    }
    public boolean menugrid(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.gridalign = !mysurf.gridalign;
                if (mysurf.gridalign)
                    recreategrid();
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.gridalign)
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        //surfacecanvas.drawBitmap(contrast, posxi, posyi, null);
        surfacecanvas.drawText("grid", posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    float x1, y1, x2, y2, mabase, roundedRectRatio, quatredixiememillimetre;
    boolean needanotherupdate = false;


    private void menugridsize(Canvas surfacecanvas) {
        ecritoption = "grid size";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.gridalign = !mysurf.gridalign;
                if (mysurf.gridalign)
                    recreategrid();
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;

        if (mysurf.gridalign) {
            ecritoption = String.format("unit size %.3fpx", mysurf.gridalignd);
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    Intent intent = new Intent();
                    intent.setAction(Gallery.broadcastname);
                    intent.putExtra("goal", "genericinput");
                    intent.putExtra("id", currid);
                    intent.putExtra("type", "gridalignd");
                    intent.putExtra("defaultvalue", String.valueOf(mysurf.gridalignd));
                    LocalBroadcastManager.getInstance(model.activitycontext).sendBroadcast(intent);
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;
        }
    }

    public void applyfilter(String filter) {
        int couchel = mysurf.listecouche.size();
        if (mysurf.drawcurrlayer == -1 || mysurf.drawcurrlayer >= couchel) {
            for (int i = 0; i < couchel ; i++) {
                mysurf.listecouche.get(i).filter = filter;
                recreecanvasenzero(i, mysurf.ScreenWidth, mysurf.ScreenHeight);
            }
        } else {
            mysurf.listecouche.get(mysurf.drawcurrlayer).filter = filter;
            recreecanvasenzero(mysurf.drawcurrlayer, mysurf.ScreenWidth, mysurf.ScreenHeight);
        }
    }

    private void menumodify(Canvas surfacecanvas, int foldercount) {
        ecritoption = "modify";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.optionshowmodifypic = !mysurf.optionshowmodifypic;
                //mysurf.cropw = false;
                //mysurf.croph = false;
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;

        if (mysurf.optionshowmodifypic) {

            if (mysurf.filterlist.length == 0) {
                int fl = (int) (Gallery.filterlist.length / 3);
                mysurf.filterprint = new String[fl];
                mysurf.filterlist = new String[fl];
                mysurf.filteractive = new boolean[fl];
                mysurf.filterinfo = new String[fl];
                for (int f = 0; f < fl; f++) {
                    mysurf.filterprint[f] = Gallery.filterlist[f * 3 + 0];
                    mysurf.filterlist[f] = Gallery.filterlist[f * 3 + 1];
                    mysurf.filterinfo[f] = Gallery.filterlist[f * 3 + 2];
                    mysurf.filteractive[f] = false;
                }
            }

            boolean effects = false;
            boolean advanced = false;

            int fl = mysurf.filterlist.length;
            for (int f = 0; f < fl; f++) {

                if (f == Gallery.filterrotate) {
                    ecritoption = "rotate";
                    y1 = mabase;
                    y2 = mabase + model.GenericCaseH;
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                    x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                    if (x1 > mysurf.SettingsXmin) {
                        x1 = mysurf.SettingsXmin;
                    }
                    ecritx = x2 - model.GenericInterSpace;
                    ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            mysurf.filteractive[f] = !mysurf.filteractive[f];
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    mabase += model.GenericCaseH + model.GenericInterSpace;
                    if (mabase > mysurf.myheight)
                        return;

                } else if (f == Gallery.filterhflipvflip) {
                    // 1 hflip 2 vflip

                    y1 = mabase;
                    y2 = mabase + model.GenericCaseH;
                    ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;

                    ecritoption = "v ";
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x1 = (mysurf.ScreenWidth - model.GenericInterSpace + mysurf.SettingsXmin) * 0.5f + model.GenericInterSpace * 0.5f;
                    x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                    ecritx = x2;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            mysurf.filteractive[f + 1] = !mysurf.filteractive[f + 1];
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    //surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    //recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f + 1]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    ecritoption = "flip h";
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x2 = x1 - model.GenericInterSpace;
                    x1 = x2 - model.GenericInterSpace * 2.0f - taillex;
                    if (x1 > mysurf.SettingsXmin)
                        x1 = mysurf.SettingsXmin;
                    ecritx = x2 - model.GenericInterSpace;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            mysurf.filteractive[f] = !mysurf.filteractive[f];
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    mabase += model.GenericCaseH + model.GenericInterSpace;
                    if (mabase > mysurf.myheight)
                        return;

                } else if (f == Gallery.filtervflip) { // vflip

                } else if (!mysurf.optionshowsubeffect && Gallery.filterbcsgwi <= f && f <= Gallery.filterbcsgwf) {

                    if (!effects) {
                        effects = true;
                        ecritoption = "effects";
                        y1 = mabase;
                        y2 = mabase + model.GenericCaseH;
                        taillex = model.Menu1TextePaint.measureText(ecritoption);
                        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                        if (x1 > mysurf.SettingsXmin) {
                            x1 = mysurf.SettingsXmin;
                        }
                        ecritx = x2 - model.GenericInterSpace;
                        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                        if (clickquicknavmenu && !wearemoving) {
                            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                                mysurf.optionshowsubeffect = !mysurf.optionshowsubeffect;
                                needanotherupdate = true;
                                clickquicknavmenu = false;
                            }
                        }
                        recti = new RectF(x1, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                        }
                        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                        mabase += model.GenericCaseH + model.GenericInterSpace;
                        if (mabase > mysurf.myheight)
                            return;
                    }

                } else if (mysurf.optionshowsubeffect && Gallery.filterbcsgwi <= f && f <= Gallery.filterbcsgwf) {

                    if (!effects) {
                        effects = true;
                        ecritoption = "-";
                        y1 = mabase;
                        y2 = mabase + model.GenericCaseH;
                        taillex = model.Menu1TextePaint.measureText(ecritoption);
                        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                        if (x1 > mysurf.SettingsXmin) {
                            x1 = mysurf.SettingsXmin;
                        }
                        ecritx = x2 - model.GenericInterSpace;
                        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                        if (clickquicknavmenu && !wearemoving) {
                            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                                mysurf.optionshowsubeffect = !mysurf.optionshowsubeffect;
                                needanotherupdate = true;
                                clickquicknavmenu = false;
                            }
                        }
                        recti = new RectF(x1, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                        }
                        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                        mabase += model.GenericCaseH + model.GenericInterSpace;
                        if (mabase > mysurf.myheight)
                            return;
                    }

                    y1 = mabase;
                    y2 = mabase + model.GenericCaseH;
                    ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;

                    ecritoption = "+ ";
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x1 = (mysurf.ScreenWidth - model.GenericInterSpace + mysurf.SettingsXmin) * 0.5f + model.GenericInterSpace * 0.5f;
                    x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                    ecritx = x2;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            if (f == Gallery.filterb) {
                                mysurf.brightness += mysurf.deltabright[mysurf.deltabrighti];
                                if (-0.001 < mysurf.brightness && mysurf.brightness < 0.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=brightness=%.3f", mysurf.brightness);
                                }
                            } else if (f == Gallery.filterc) {
                                mysurf.contrast += mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.contrast && mysurf.contrast < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=contrast=%.3f", mysurf.contrast);
                                }
                            } else if (f == Gallery.filters) {
                                mysurf.saturation += mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.saturation && mysurf.saturation < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=saturation=%.3f", mysurf.saturation);
                                }
                            } else if (f == Gallery.filterg) {
                                mysurf.gamma += mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.gamma && mysurf.gamma < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=gamma=%.3f", mysurf.gamma);
                                }
                            } else if (f == Gallery.filterw) {
                                mysurf.gamma_weight += mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.gamma_weight && mysurf.gamma_weight < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=gamma_weight=%.3f", mysurf.gamma_weight);
                                }
                            }
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    //surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    //recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);


                    if (f == Gallery.filterb) {
                        if (mysurf.filteractive[f])
                            ecritoption = String.format("brightness %.3f -", mysurf.brightness);
                        else
                            ecritoption = "brightness -";
                    } else if (f == Gallery.filterc) {
                        if (mysurf.filteractive[f])
                            ecritoption = String.format("contrast %.3f -", mysurf.contrast);
                        else
                            ecritoption = "contrast -";
                    } else if (f == Gallery.filters) {
                        if (mysurf.filteractive[f])
                            ecritoption = String.format("saturation %.3f -", mysurf.saturation);
                        else
                            ecritoption = "saturation -";
                    } else if (f == Gallery.filterg) {
                        if (mysurf.filteractive[f])
                            ecritoption = String.format("gamma %.3f -", mysurf.gamma);
                        else
                            ecritoption = "gamma -";
                    } else if (f == Gallery.filterw) {
                        if (mysurf.filteractive[f])
                            ecritoption = String.format("gammaweight %.3f -", mysurf.gamma_weight);
                        else
                            ecritoption = "gammaweight -";
                    }
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x2 = x1 - model.GenericInterSpace;
                    x1 = x2 - model.GenericInterSpace * 2.0f - taillex;
                    if (x1 > mysurf.SettingsXmin)
                        x1 = mysurf.SettingsXmin;
                    ecritx = x2 - model.GenericInterSpace;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            if (f == Gallery.filterb) {
                                mysurf.brightness -= mysurf.deltabright[mysurf.deltabrighti];
                                if (-0.001 < mysurf.brightness && mysurf.brightness < 0.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=brightness=%.3f", mysurf.brightness);
                                }
                            } else if (f == Gallery.filterc) {
                                mysurf.contrast -= mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.contrast && mysurf.contrast < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=contrast=%.3f", mysurf.contrast);
                                }
                            } else if (f == Gallery.filters) {
                                mysurf.saturation -= mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.saturation && mysurf.saturation < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=saturation=%.3f", mysurf.saturation);
                                }
                            } else if (f == Gallery.filterg) {
                                mysurf.gamma -= mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.gamma && mysurf.gamma < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=gamma=%.3f", mysurf.gamma);
                                }
                            } else if (f == Gallery.filterw) {
                                mysurf.gamma_weight -= mysurf.deltabright[mysurf.deltabrighti];
                                if (0.999 < mysurf.gamma_weight && mysurf.gamma_weight < 1.001) {
                                    mysurf.filteractive[f] = false;
                                } else {
                                    mysurf.filteractive[f] = true;
                                    mysurf.filterlist[f] = String.format("eq=gamma_weight=%.3f", mysurf.gamma_weight);
                                }
                            }
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    mabase += model.GenericCaseH + model.GenericInterSpace;
                    if (mabase > mysurf.myheight)
                        return;

                } else if (!mysurf.optionshowsubeffect && f == Gallery.filterreset) {

                } else if (mysurf.optionshowsubeffect && f == Gallery.filterreset) {

                    y1 = mabase;
                    y2 = mabase + model.GenericCaseH;
                    ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;

                    ecritoption = "reset";
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x1 = (mysurf.ScreenWidth - model.GenericInterSpace + mysurf.SettingsXmin) * 0.5f + model.GenericInterSpace * 0.5f;
                    x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                    ecritx = x2;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            for (int ff = model.filterb; ff <= model.filterw; ff++) {
                                mysurf.filteractive[ff] = false;
                            }
                            mysurf.brightness = 0.0f;
                            mysurf.contrast = 1.0f;
                            mysurf.saturation = 1.0f;
                            mysurf.gamma = 1.0f;
                            mysurf.gamma_weight = 1.0f;
                            String filter = null;
                            for (int g = 0; g < fl; g++) {
                                if (mysurf.filteractive[g]) {
                                    if (filter == null)
                                        filter = mysurf.filterlist[g];
                                    else
                                        filter += "," + mysurf.filterlist[g];
                                }
                            }
                            applyfilter(filter);
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    //surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    //recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);


                    ecritoption = String.format("+/- %.3f", mysurf.deltabright[mysurf.deltabrighti]);
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x2 = x1 - model.GenericInterSpace;
                    x1 = x2 - model.GenericInterSpace * 2.0f - taillex;
                    if (x1 > mysurf.SettingsXmin)
                        x1 = mysurf.SettingsXmin;
                    ecritx = x2 - model.GenericInterSpace;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            mysurf.deltabrighti = (mysurf.deltabrighti + 1) % Surf.deltabright.length;
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    mabase += model.GenericCaseH + model.GenericInterSpace;
                    if (mabase > mysurf.myheight)
                        return;


                } else if (!mysurf.optionshowsubeffectadvanced && f >= Gallery.filteradvanced) {

                    if (!advanced) {
                        advanced = true;
                        ecritoption = "advanced effects";
                        y1 = mabase;
                        y2 = mabase + model.GenericCaseH;
                        taillex = model.Menu1TextePaint.measureText(ecritoption);
                        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                        if (x1 > mysurf.SettingsXmin) {
                            x1 = mysurf.SettingsXmin;
                        }
                        ecritx = x2 - model.GenericInterSpace;
                        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                        if (clickquicknavmenu && !wearemoving) {
                            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                                mysurf.optionshowsubeffectadvanced = !mysurf.optionshowsubeffectadvanced;
                                needanotherupdate = true;
                                clickquicknavmenu = false;
                            }
                        }
                        recti = new RectF(x1, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                        }
                        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                        mabase += model.GenericCaseH + model.GenericInterSpace;
                        if (mabase > mysurf.myheight)
                            return;
                    }

                } else {

                    if (mysurf.optionshowsubeffectadvanced && f >= Gallery.filteradvanced) {
                        if (!advanced) {
                            advanced = true;
                            ecritoption = "-";
                            y1 = mabase;
                            y2 = mabase + model.GenericCaseH;
                            taillex = model.Menu1TextePaint.measureText(ecritoption);
                            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                            if (x1 > mysurf.SettingsXmin) {
                                x1 = mysurf.SettingsXmin;
                            }
                            ecritx = x2 - model.GenericInterSpace;
                            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                            if (clickquicknavmenu && !wearemoving) {
                                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                                    mysurf.optionshowsubeffectadvanced = !mysurf.optionshowsubeffectadvanced;
                                    needanotherupdate = true;
                                    clickquicknavmenu = false;
                                }
                            }
                            recti = new RectF(x1, y1, x2, y2);
                            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                            }
                            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                            mabase += model.GenericCaseH + model.GenericInterSpace;
                            if (mabase > mysurf.myheight)
                                return;
                        }
                    }

                    y1 = mabase;
                    y2 = mabase + model.GenericCaseH;
                    ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;

                    ecritoption = "... ";
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x1 = (mysurf.ScreenWidth - model.GenericInterSpace + mysurf.SettingsXmin) * 0.5f + model.GenericInterSpace * 0.5f;
                    x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                    ecritx = x2;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            model.message(
                                    mysurf.filterprint[f] + "\n" +
                                            mysurf.filterlist[f] + "\n" +
                                            mysurf.filterinfo[f]
                            );
                            if (mysurf.filterprint[f].equals("crop width")) {
                /*mysurf.cropw = true;
                mysurf.croph = false;*/
                                if (mysurf.srcrect.left < mysurf.srcrect.right) {
                                    mysurf.filterlist[f] = "crop=w=" + (mysurf.srcrect.right - mysurf.srcrect.left) + ":x=" + mysurf.srcrect.left;
                                }
                            } else if (mysurf.filterprint[f].equals("crop height")) {
                /*mysurf.cropw = false;
                mysurf.croph = true;*/
                                if (mysurf.srcrect.top < mysurf.srcrect.bottom) {
                                    mysurf.filterlist[f] = "crop=h=" + (mysurf.srcrect.bottom - mysurf.srcrect.top) + ":y=" + mysurf.srcrect.top;
                                }
                            }/* else {
                mysurf.cropw = false;
                mysurf.croph = false;
              }*/
                            if (mysurf.filterlastselected == f) {
                                mysurf.filterlastselected = f;
                                Intent intent = new Intent();
                                intent.setAction(Gallery.broadcastname);
                                intent.putExtra("goal", "filter");
                                intent.putExtra("drawing", true);
                                intent.putExtra("id", currid);
                                LocalBroadcastManager.getInstance(model.activitycontext).sendBroadcast(intent);
                            }
                            mysurf.filterlastselected = f;
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    //surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    //recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);


                    if (mysurf.filterprint[f].equals(""))
                        ecritoption = mysurf.filterlist[f];
                    else
                        ecritoption = mysurf.filterprint[f];
                    taillex = model.Menu1TextePaint.measureText(ecritoption);
                    x2 = x1 - model.GenericInterSpace;
                    x1 = x2 - model.GenericInterSpace * 2.0f - taillex;
                    if (x1 > mysurf.SettingsXmin)
                        x1 = mysurf.SettingsXmin;
                    ecritx = x2 - model.GenericInterSpace;
                    if (clickquicknavmenu && !wearemoving) {
                        if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                            if (mysurf.filterlist[f].equals("")) {
                                mysurf.filteractive[f] = false;
                            } else {
                                mysurf.filteractive[f] = !mysurf.filteractive[f];
                                if (mysurf.filteractive[f]) {
                                    if (mysurf.filterprint[f].equals("crop width")) {
                                        if (mysurf.srcrect.left < mysurf.srcrect.right) {
                                            mysurf.filterlist[f] = "crop=w=" + (mysurf.srcrect.right - mysurf.srcrect.left) + ":x=" + mysurf.srcrect.left;
                                            mysurf.fichierprecedent = "dummy";
                                            mysurf.bpx = 0;
                                            mysurf.bpy = 0;
                                            mysurf.bscale = 1;
                                            mysurf.centeronscreen = true;
                                        }
                                    } else if (mysurf.filterprint[f].equals("crop height")) {
                                        if (mysurf.srcrect.top < mysurf.srcrect.bottom) {
                                            mysurf.filterlist[f] = "crop=h=" + (mysurf.srcrect.bottom - mysurf.srcrect.top) + ":y=" + mysurf.srcrect.top;
                                            mysurf.fichierprecedent = "dummy";
                                            mysurf.bpx = 0;
                                            mysurf.bpy = 0;
                                            mysurf.bscale = 1;
                                            mysurf.centeronscreen = true;
                                        }
                                    }
                                }
                                String filter = null;
                                for (int g = 0; g < fl; g++) {
                                    if (mysurf.filteractive[g]) {
                                        if (filter == null)
                                            filter = mysurf.filterlist[g];
                                        else
                                            filter += "," + mysurf.filterlist[g];
                                    }
                                }
                                applyfilter(filter);
                            }
                            needanotherupdate = true;
                            clickquicknavmenu = false;
                        }
                    }
                    recti = new RectF(x1, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                    recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                    surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                    if (mysurf.filteractive[f]) {
                        RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                    }
                    if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                        RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                        surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                    }
                    surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                    mabase += model.GenericCaseH + model.GenericInterSpace;
                    if (mabase > mysurf.myheight)
                        return;
                }

            }

        }
    }

    public boolean menulayer(Canvas surfacecanvas) {
        if (mysurf.drawcurrlayer == -1)
            ecritoption = "=";
        else
            ecritoption = "" + mysurf.drawcurrlayer;
        posxi = posxf + model.DessinInterSpace;
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (mysurf.drawmovezoom) { // si on est en zoom il faut sauver le décalage dû à notre zoom sinon ça va merder
                    int couchel = mysurf.listecouche.size();
                    for (int k = 0; k < couchel; k++)
                        if (mysurf.listecouche.get(k).active)
                            recreecanvasenzero(k, mysurf.ScreenWidth, mysurf.ScreenHeight);
                }
                int drawcurrlayer = mysurf.drawcurrlayer + 1;
                if (drawcurrlayer >= mysurf.listecouche.size()) {
                    mysurf.drawcurrlayer = -1;
                } else {
                    mysurf.drawcurrlayer = drawcurrlayer;
                }
                if (mysurf.drawmovezoom) {
                    // si on est en zoom on change de layer à zoomer
                    if (mysurf.drawcurrlayer == -1) {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            mysurf.listecouche.get(k).active = true;
                        }
                    } else {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            mysurf.listecouche.get(k).active = false;
                        }
                        mysurf.listecouche.get(mysurf.drawcurrlayer).active = true;
                    }
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(layers, posxi, posyi, null);
        surfacecanvas.drawText(ecritoption, posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    private void menucompositing8(Canvas surfacecanvas) {
        ecritoption = "compose";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.drawmenucompose = !mysurf.drawmenucompose;
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;

        if (mysurf.drawmenucompose) {

            for (int i = 0 ; i < Dessin.porterduffmodes.length ; i++) {
                ecritoption = Dessin.porterduffmodes[i].toLowerCase();
                y1 = mabase;
                y2 = mabase + model.GenericCaseH;
                taillex = model.Menu1TextePaint.measureText(ecritoption);
                x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
                x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                if (x1 > mysurf.SettingsXmin) {
                    x1 = mysurf.SettingsXmin;
                }
                ecritx = x2 - model.GenericInterSpace;
                ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
                if (clickquicknavmenu && !wearemoving) {
                    if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                        if (mysurf.drawporterduff == i)
                            mysurf.drawporterduff = -1;
                        else
                            mysurf.drawporterduff = i;
                        needanotherupdate = true;
                        clickquicknavmenu = false;
                    }
                }
                recti = new RectF(x1, y1, x2, y2);
                surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                if (mysurf.drawporterduff == i) {
                    RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                    surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                }
                if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                    RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                    surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                }
                surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                mabase += model.GenericCaseH + model.GenericInterSpace;
                if (mabase > mysurf.myheight)
                    return;
            }

        }
    }

    private void menulayer8(Canvas surfacecanvas) {
        ecritoption = "layer";
        y1 = mabase;
        y2 = mabase + model.GenericCaseH;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
        x2 = mysurf.ScreenWidth - model.GenericInterSpace;
        if (x1 > mysurf.SettingsXmin) {
            x1 = mysurf.SettingsXmin;
        }
        ecritx = x2 - model.GenericInterSpace;
        ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
        if (clickquicknavmenu && !wearemoving) {
            if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                mysurf.drawmenulayer = !mysurf.drawmenulayer;
                needanotherupdate = true;
                clickquicknavmenu = false;
            }
        }
        recti = new RectF(x1, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainta);
        recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
        surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu1BgPainto);
        if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
            RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
            surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
        }
        surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

        mabase += model.GenericCaseH + model.GenericInterSpace;
        if (mabase > mysurf.myheight)
            return;

        if (mysurf.drawmenulayer) {

            ecritoption = "all layers";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    if (mysurf.drawmovezoom) { // si on est en zoom il faut sauver le décalage dû à notre zoom sinon ça va merder
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++)
                            if (mysurf.listecouche.get(k).active)
                                recreecanvasenzero(k, mysurf.ScreenWidth, mysurf.ScreenHeight);
                    }
                    mysurf.drawcurrlayer = -1;
                    if (mysurf.drawmovezoom) {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            mysurf.listecouche.get(k).active = true;
                        }
                    }
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if (mysurf.drawcurrlayer == -1) {
                RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
            }
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            int couchel = mysurf.listecouche.size();
            for (int i = 0 ; i < couchel ; i++) {
                y1 = mabase;
                y2 = mabase + model.GenericCaseH;
                ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;

                if (layeraction == layeractionremove)
                    ecritoption = "rm";
                else if (layeraction == layeractionmoveup)
                    ecritoption = "up";
                else if (layeraction == layeractionmovedown)
                    ecritoption = "dwn";
                taillex = model.Menu1TextePaint.measureText(ecritoption);
                x1 = (mysurf.ScreenWidth - model.GenericInterSpace + mysurf.SettingsXmin) * 0.5f + model.GenericInterSpace * 0.5f;
                x2 = mysurf.ScreenWidth - model.GenericInterSpace;
                ecritx = x2;
                if (clickquicknavmenu && !wearemoving) {
                    if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                        if (mysurf.drawmovezoom) { // si on est en zoom il faut sauver le décalage dû à notre zoom sinon ça va merder
                            for (int k = 0; k < couchel; k++)
                                if (mysurf.listecouche.get(k).active)
                                    recreecanvasenzero(k, mysurf.ScreenWidth, mysurf.ScreenHeight);
                        }
                        if (i < mysurf.listecouche.size()) {
                            mysurf.drawcurrlayer = -1;
                            for (int k = 0; k < couchel; k++)
                                mysurf.listecouche.get(k).active = false;
                            if (layeraction == layeractionremove) {
                                Couche couche = mysurf.listecouche.get(i);
                                couche.active = false;
                                if (couche.canvas != null)
                                    couche.canvas = null;
                                if (couche.currentbitmap != null) {
                                    if (!couche.currentbitmap.isRecycled()) {
                                        couche.currentbitmap.recycle();
                                    }
                                    couche.currentbitmap = null;
                                }
                                mysurf.listecouche.remove(i);
                                int listedessinl = mysurf.listedessin.size();
                                for (int k = listedessinl - 1; k >= 0; k--) {
                                    int c = mysurf.listedessin.get(k).couche;
                                    if (c == i) {
                                        Dessin dessin = mysurf.listedessin.get(k);
                                        if (dessin.originalpicture != null) {
                                            if (!dessin.originalpicture.isRecycled()) {
                                                dessin.originalpicture.recycle();
                                            }
                                            dessin.originalpicture = null;
                                        }
                                        mysurf.listedessin.remove(k);
                                    } else if (c > i) {
                                        mysurf.listedessin.get(k).couche -= 1;
                                    }
                                }
                            } else if (layeraction == layeractionmoveup && i - 1 >= 0) {
                                Collections.swap(mysurf.listecouche, i, i - 1);
                                int listedessinl = mysurf.listedessin.size();
                                for (int k = listedessinl - 1; k >= 0; k--) {
                                    int c = mysurf.listedessin.get(k).couche;
                                    if (c == i) {
                                        mysurf.listedessin.get(k).couche = i - 1;
                                    } else if (c == i - 1) {
                                        mysurf.listedessin.get(k).couche = i;
                                    }
                                }
                            } else if (layeraction == layeractionmovedown && i + 1 < couchel) {
                                Collections.swap(mysurf.listecouche, i, i + 1);
                                int listedessinl = mysurf.listedessin.size();
                                for (int k = listedessinl - 1; k >= 0; k--) {
                                    int c = mysurf.listedessin.get(k).couche;
                                    if (c == i) {
                                        mysurf.listedessin.get(k).couche = i + 1;
                                    } else if (c == i + 1) {
                                        mysurf.listedessin.get(k).couche = i;
                                    }
                                }
                            }
                        }
                        needanotherupdate = true;
                        clickquicknavmenu = false;
                    }
                }
                recti = new RectF(x1, y1, x2, y2);
                //surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                //recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                    RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                    surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                }
                surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                ecritoption = String.format("%d", i);
                taillex = model.Menu1TextePaint.measureText(ecritoption);
                x2 = x1 - model.GenericInterSpace;
                x1 = x2 - model.GenericInterSpace * 2.0f - taillex;
                if (x1 > mysurf.SettingsXmin)
                    x1 = mysurf.SettingsXmin;
                ecritx = x2 - model.GenericInterSpace;
                if (clickquicknavmenu && !wearemoving) {
                    if (mysurf.SettingsXmin < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                        if (!mysurf.drawmovezoom) {
                            if (i < mysurf.listecouche.size())
                                mysurf.drawcurrlayer = i;
                        }
                        needanotherupdate = true;
                        clickquicknavmenu = false;
                    }
                }
                recti = new RectF(x1, y1, x2, y2);
                surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
                recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
                surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
                if (mysurf.drawcurrlayer == i) {
                    RectF rectisel = new RectF(x1 + quatredixiememillimetre, y1 + quatredixiememillimetre, x2 - quatredixiememillimetre, y2 - quatredixiememillimetre);
                    surfacecanvas.drawRoundRect(rectisel, roundedRectRatio, roundedRectRatio, model.SettingsSelPaint);
                }
                if ((model.isandroidtv || model.keypadnavactive) && mysurf.SettingsXmin < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                    RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                    surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
                }
                surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

                mabase += model.GenericCaseH + model.GenericInterSpace;
                if (mabase > mysurf.myheight)
                    return;
            }

            if (layeraction == layeractionremove)
                ecritoption = "button remove";
            else if (layeraction == layeractionmoveup)
                ecritoption = "button up";
            else if (layeraction == layeractionmovedown)
                ecritoption = "button down";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    if (!mysurf.drawmovezoom) {
                        layeraction = (layeraction + 1) % 3;
                        if (layeraction == layeractionremove)
                            model.message("remove layer");
                        else if (layeraction == layeractionmoveup)
                            model.message("move layer up once");
                        else if (layeraction == layeractionmovedown)
                            model.message("move layer down once");
                    }
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

            ecritoption = "add layer";
            y1 = mabase;
            y2 = mabase + model.GenericCaseH;
            taillex = model.Menu1TextePaint.measureText(ecritoption);
            x1 = mysurf.ScreenWidth - model.GenericInterSpace * 3.0f - taillex;
            x2 = mysurf.ScreenWidth - model.GenericInterSpace;
            if (x1 > mysurf.SettingsXmin) {
                x1 = mysurf.SettingsXmin;
            }
            ecritx = x2 - model.GenericInterSpace;
            ecrity = mabase + (model.GenericCaseH + model.GenericTextH) * 0.5f;
            if (clickquicknavmenu && !wearemoving) {
                if (x1 < clicktohandlex && clicktohandlex < x2 && y1 < clicktohandley && clicktohandley < y2) {
                    if (!mysurf.drawmovezoom) {
                        Couche macouche = new Couche();
                        macouche.currentbitmap = Bitmap.createBitmap(mysurf.ScreenWidth, mysurf.ScreenHeight, Bitmap.Config.ARGB_8888);
                        macouche.canvas = new Canvas(macouche.currentbitmap);
                        macouche.x = 0.0f;
                        macouche.y = 0.0f;
                        macouche.originalw = mysurf.ScreenWidth;
                        macouche.originalh = mysurf.ScreenHeight;
                        macouche.scale = 1.0f;
                        int listecouchel = mysurf.listecouche.size();
                        mysurf.listecouche.add(macouche);
                        mysurf.drawcurrlayer = listecouchel;
                    }
                    needanotherupdate = true;
                    clickquicknavmenu = false;
                }
            }
            recti = new RectF(x1, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainta);
            recti = new RectF(mysurf.SettingsXmin, y1, x2, y2);
            surfacecanvas.drawRoundRect(recti, roundedRectRatio, roundedRectRatio, model.Menu2BgPainto);
            if ((model.isandroidtv || model.keypadnavactive) && x1 < mysurf.cursorx && mysurf.cursorx < x2 && y1 < mysurf.cursory && mysurf.cursory < y2) {
                RectF rectisel = new RectF(ecritx, ecrity + 1.0f * quatredixiememillimetre, ecritx - taillex, ecrity + 2.0f * quatredixiememillimetre);
                surfacecanvas.drawRoundRect(rectisel, quatredixiememillimetre, quatredixiememillimetre, model.KeyboardFocus);
            }
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.Menu1TextePaint);

            mabase += model.GenericCaseH + model.GenericInterSpace;
            if (mabase > mysurf.myheight)
                return;

        }
    }
    final static int layeractionremove = 0;
    final static int layeractionmoveup = 1;
    final static int layeractionmovedown = 2;
    int layeraction = layeractionremove;

    public boolean menucolor(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace * 5.0f;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawmenucolor = !mysurf.drawmenucolor;
            }
        }
        rectangle.setColor(Color.HSVToColor((int) mysurf.drawtracecurrcolora, new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv}));
        rectangle.setStrokeWidth(0.0f);
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, rectangle);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }


    public boolean menucontrast(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawmenumod = !mysurf.drawmenumod;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(contrast, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawsize(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawmenusize = !mysurf.drawmenusize;
            }
        }
        float milieuy = (posyf + posyi) / 2.0f;
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        if (mysurf.drawmenusize) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        rectangle.setColor(Color.BLACK);
        rectangle.setStrokeWidth(mysurf.drawtracecurrsizemin);
        surfacecanvas.drawLine(posxi, milieuy, posxf, milieuy, rectangle);
        surfacecanvas.drawText(String.format("%.02f", mysurf.drawtracecurrsizemax), posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawtype(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawdevelopmenutype = !mysurf.drawdevelopmenutype;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdraw) {
            //surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(draw, posxi, posyi, null);
        } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourerase) {
            //surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(erase, posxi, posyi, null);
        } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawfill) {
            //surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(fill, posxi, posyi, null);
        } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawclose) {
            //surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(contour, posxi, posyi, null);
        } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourddrawfillradial) {
            //surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(fill, posxi, posyi, null);
        }
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawtypedevelop(Canvas surfacecanvas, int type) {
        //ecritoption = "Draw";
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawerasefillecontour = type;
                if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdraw) {
                    model.message("draw");
                } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourerase) {
                    model.message("erase zones");
                } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawfill) {
                    model.message("draw and then fill");
                } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawclose) {
                    model.message("draw and then close contour");
                } else if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourddrawfillradial) {
                    model.message("draw and then fill radial");
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (type == 0) {
            if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdraw)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(draw, posxi, posyi, null);
        } else if (type == 1) {
            if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourerase)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(drawbgspot, posxi, posyi, null);
        } else if (type == 2) {
            if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawfill)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(fill, posxi, posyi, null);
        } else if (type == 3) {
            if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourdrawclose)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(contour, posxi, posyi, null);
        } else if (type == 4) {
            if (mysurf.drawerasefillecontour == Dessin.drawerasefillcontourddrawfillradial)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawBitmap(drawradialfill, posxi, posyi, null);
        }
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawgeometric(Canvas surfacecanvas) {
        // draw lines
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawmenugeometric = !mysurf.drawmenugeometric;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(drawline, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawgeometriclines(Canvas surfacecanvas) {
        // draw lines
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                int currsize = mysurf.drawtracecurr.size();
                if (!mysurf.onlymouseup) {
                    mysurf.onlymouseup = true;
                    mysurf.chaindraw = false;
                    mysurf.onlymouseupstatus = 0;
                    model.message("click again\nto finish the path");
                } else if (mysurf.onlymouseup && !mysurf.chaindraw && currsize == 0) {
                    mysurf.onlymouseup = true;
                    mysurf.chaindraw = true;
                    mysurf.onlymouseupstatus = 0;
                    model.message("click twice\nto finish thepath");
                } else {
                    mysurf.onlymouseup = false;
                    mysurf.chaindraw = false;
                    mysurf.onlymouseupstatus = -1;
                    if (currsize > 0) {
                        try {
                            model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "tracecompleteredraw"});
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        llog.d(TAG, "trace already drawn");
                    }
                    model.message();
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.onlymouseup) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(drawline, posxi, posyi, null);
        if (mysurf.chaindraw) {
            surfacecanvas.drawText("chain", posxi, posyf, model.DessinTextPaint);
        }
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawgeometriccircle(Canvas surfacecanvas) {
        // draw lines
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawgeometrictype = (mysurf.drawgeometrictype + 1) % 3;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(drawline, posxi, posyi, null);
        if (mysurf.drawgeometrictype == Dessin.drawgeometrictypeline)
            surfacecanvas.drawText("line", posxi, posyf, model.DessinTextPaint);
        else if (mysurf.drawgeometrictype == Dessin.drawgeometrictypecircle)
            surfacecanvas.drawText("crcl", posxi, posyf, model.DessinTextPaint);
        else if (mysurf.drawgeometrictype == Dessin.drawgeometrictyperect)
            surfacecanvas.drawText("rect", posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuselection(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.drawdevelopmenuselection = !mysurf.drawdevelopmenuselection;
                if (!mysurf.drawdevelopmenuselection) {
                    mysurf.selectedtrace = Gallery.selectedtracecancel;
                    selectmultiple = false;
                    if (animateselection == 1) {
                        resetselclosestpathalpha();
                        animateselection = 2;
                    }
                    selclosestpath.clear();
                    selclosestpathpoint.clear();
                    selclosestpathpointx.clear();
                    selclosestpathpointy.clear();
                    selclosestpathalpha.clear();
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        if (mysurf.selectedtrace != Gallery.selectedtracecancel)
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(change, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    private int selectedtraceclicked = 0;
    private boolean selectmultiple = false;

    public boolean menuselectiondevelop(Canvas surfacecanvas, int sel) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (sel == selectedtraceclicked && sel != Gallery.selectedtraceselectmultiple) {
                    mysurf.selectedtrace = Gallery.selectedtracecancel;
                    selectedtraceclicked = Gallery.selectedtracecancel;
                } else {
                    mysurf.selectedtrace = sel;
                    if (sel == Gallery.selectedtraceerase) {
                        model.message("remove closest");
                        selectedtraceclicked = Gallery.selectedtraceerase;
                    } else if (sel == Gallery.selectedtraceselectmultiple) {
                        selectmultiple = !selectmultiple;
                        if (!selectmultiple) {
                            model.message("modify closest trace");
                            selectedtraceclicked = Gallery.selectedtracecancel;
                            mysurf.selectedtrace = Gallery.selectedtracecancel;
                        } else {
                            model.message("select multiple traces");
                            selectedtraceclicked = Gallery.selectedtraceselectmultipleadd;
                            mysurf.selectedtrace = Gallery.selectedtraceselectmultipleadd;
                        }
                        if (animateselection == 1) {
                            resetselclosestpathalpha();
                            animateselection = 2;
                        }
                        selclosestpath.clear();
                        selclosestpathpoint.clear();
                        selclosestpathpointx.clear();
                        selclosestpathpointy.clear();
                        selclosestpathalpha.clear();
                        try {
                            model.commandethreaddrawing.put(new String[]{String.valueOf(currid), "update"});
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else if (sel == Gallery.selectedtraceselectmultipleremove) {
                        selectedtraceclicked = Gallery.selectedtraceselectmultipleadd;
                        mysurf.selectedtrace = Gallery.selectedtraceselectmultipleadd;
                        int cl = selclosestpath.size();
                        if (cl > 0) {
                            cl -= 1;
                            int currsel = selclosestpath.get(cl);
                            int listedessinl = mysurf.listedessin.size();
                            if (currsel < listedessinl) {
                                Dessin dessin = mysurf.listedessin.get(currsel);
                                dessin.couleura = selclosestpathalpha.get(cl);
                                dessin.generecouleur();
                            }
                            selclosestpath.remove(cl);
                            selclosestpathpoint.remove(cl);
                            selclosestpathpointx.remove(cl);
                            selclosestpathpointy.remove(cl);
                            selclosestpathalpha.remove(cl);
                        }
                    } else if (sel == Gallery.selectedtraceselectmultipleadd) {
                        selectedtraceclicked = Gallery.selectedtraceselectmultipleadd;
                    } else if (sel == Gallery.selectedtracecolor) {
                        model.message("change color");
                        selectedtraceclicked = Gallery.selectedtracecolor;
                    } else if (sel == Gallery.selectedtracethickness) {
                        model.message("change thickness");
                        selectedtraceclicked = Gallery.selectedtracethickness;
                    } else if (sel == Gallery.selectedtracemovetrace) {
                        model.message("move trace");
                        selectedtraceclicked = Gallery.selectedtracemovetrace;
                        selectedtracemovepointortrace = Gallery.selectedtracemovetrace;
                    } else if (sel == Gallery.selectedtracemovepoint) {
                        model.message("move one point");
                        selectedtraceclicked = Gallery.selectedtracemovepoint;
                        selectedtracemovepointortrace = Gallery.selectedtracemovepoint;
                    } else if (sel == Gallery.selectedtracemoveto) {
                        model.message("move here");
                        selectedtraceclicked = Gallery.selectedtracemoveto;
                    } else if (sel == Gallery.selectedtraceduplicate) {
                        model.message("duplicate");
                        selectedtraceclicked = Gallery.selectedtraceduplicate;
                    } else if (sel == Gallery.selectedtracechangetype) {
                        model.message("change type");
                        selectedtraceclicked = Gallery.selectedtracechangetype;
                    } else if (sel == Gallery.selectedtracechangeporterduff) {
                        model.message("change compose");
                        selectedtraceclicked = Gallery.selectedtracechangeporterduff;
                    } else if (sel == Gallery.selectedtraceunder) {
                        selectedtraceclicked = Gallery.selectedtraceunder;
                    } else if (sel == Gallery.selectedtraceover) {
                        selectedtraceclicked = Gallery.selectedtraceover;
                    } else if (sel == Gallery.selectedtraceresize) {
                        model.message("resize");
                        selectedtraceclicked = Gallery.selectedtraceresize;
                    } else if (sel == Gallery.selectedtracecancel) {
                        mysurf.drawdevelopmenuselection = false;
                        model.message();
                        selectedtraceclicked = Gallery.selectedtracecancel;
                    } else {
                        model.message();
                        mysurf.selectedtrace = Gallery.selectedtracecancel;
                        selectedtraceclicked = Gallery.selectedtracecancel;
                    }
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (sel == Gallery.selectedtraceerase) {
            surfacecanvas.drawBitmap(drawtraceremove, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceerase)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("rm", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceselectmultiple) {
            if (selectmultiple) {
                surfacecanvas.drawBitmap(drawselectmultiple, posxi, posyi, null);
                int cl = selclosestpath.size();
                if (cl == 0)
                    surfacecanvas.drawText("mul", posxi, posyf, model.DessinTextPaint);
                else
                    surfacecanvas.drawText("" + cl, posxi, posyf, model.DessinTextPaint);
            } else {
                surfacecanvas.drawBitmap(drawselectone, posxi, posyi, null);
                surfacecanvas.drawText("one", posxi, posyf, model.DessinTextPaint);
            }
        } else if (sel == Gallery.selectedtraceselectmultipleremove) {
            surfacecanvas.drawBitmap(drawselectone, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceselectmultipleremove)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("-", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceselectmultipleadd) {
            surfacecanvas.drawBitmap(drawselectone, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceselectmultipleadd)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("+", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracecolor) {
            surfacecanvas.drawBitmap(drawchangecolor, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracecolor)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("col", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracethickness) {
            surfacecanvas.drawBitmap(drawchangethickness, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracethickness)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("thck", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceduplicate) {
            surfacecanvas.drawBitmap(drawduplicate, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceduplicate)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("dupl", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracemovetrace) {
            surfacecanvas.drawBitmap(drawmove, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracemovetrace)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("mv", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracemovepoint) {
            surfacecanvas.drawBitmap(drawmovepoint, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracemovepoint)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("mv pt", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracemoveto) {
            surfacecanvas.drawBitmap(drawmoveto, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracemoveto)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("mv to", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracechangetype) {
            surfacecanvas.drawBitmap(drawchangetype, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracechangetype)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("type", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtracechangeporterduff) {
            surfacecanvas.drawBitmap(drawchangetype, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtracechangeporterduff)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("cmps", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceunder) {
            surfacecanvas.drawBitmap(drawchangedown, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceunder)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("dwn", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceover) {
            surfacecanvas.drawBitmap(drawchangeup, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceover)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText("up", posxi, posyf, model.DessinTextPaint);
        } else if (sel == Gallery.selectedtraceresize) {
            surfacecanvas.drawBitmap(drawchangeresize, posxi, posyi, null);
            if (mysurf.selectedtrace == Gallery.selectedtraceresize)
                surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
            surfacecanvas.drawText(String.format("%.2f", mysurf.selectedtraceresizeratio), posxi, posyf, model.DessinTextPaint);
        } else {
            surfacecanvas.drawBitmap(change, posxi, posyi, null);
            surfacecanvas.drawText("-", posxi, posyf, model.DessinTextPaint);
        }
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuzoom(Canvas surfacecanvas) {
        if (!mysurf.drawmovezoom) {
            ecritoption = "";
        } else {
            int cettelayer = mysurf.drawcurrlayer;
            if (mysurf.drawcurrlayer == -1)
                cettelayer = 0;
            if (cettelayer < mysurf.listecouche.size()) {
                float zzoom = mysurf.listecouche.get(cettelayer).scale;
                if (zzoom == 1.0f)
                    ecritoption = "1";
                else
                    ecritoption = String.format("%.2f", zzoom);
            }
        }
        posxi = posxf + model.DessinInterSpace * 5.0f;
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                /*if (clicktohandley < (posyi + posyf) / 3.0f) {
                  int dl = mysurf.listecouche.size();
                  for (int i = 0 ; i < dl ; i++) {
                    if (mysurf.listecouche.get(i).active) {
                      mysurf.listecouche.get(i).scale = 1.0f;
                    }
                  }
                  mysurf.drawmovezoom = false;
                } else {*/
                if (mysurf.drawmovezoom) { // on a fini notre zoom
                    int couchel = mysurf.listecouche.size();
                    for (int k = 0; k < couchel; k++)
                        if (mysurf.listecouche.get(k).active)
                            recreecanvasenzero(k, mysurf.ScreenWidth, mysurf.ScreenHeight);
                } else { // on va commencer le zoom on ne peut plus dessiner
                    //if (mysurf.drawcurrlayer == -1) {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++)
                            mysurf.listecouche.get(k).active = true;
                    /*} else {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            if (k == mysurf.drawcurrlayer)
                                mysurf.listecouche.get(k).active = true;
                            else
                                mysurf.listecouche.get(k).active = false;
                        }
                    }*/
                }
                mysurf.drawmovezoom = !mysurf.drawmovezoom;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.drawmovezoom) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(zoom, posxi, posyi, null);
        surfacecanvas.drawText(ecritoption, posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuresize(Canvas surfacecanvas) {
        if (!mysurf.drawmoveresize) {
            ecritoption = "";
        } else {
            int cettelayer = mysurf.drawcurrlayer;
            if (mysurf.drawcurrlayer == -1)
                cettelayer = 0;
            if (cettelayer < mysurf.listecouche.size()) {
                float zzoom = mysurf.listecouche.get(cettelayer).scale;
                if (zzoom == 1.0f)
                    ecritoption = "1";
                else
                    ecritoption = String.format("%.2f", zzoom);
            }
        }
        posxi = posxf + model.DessinInterSpace * 5.0f;
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                /*if (clicktohandley < (posyi + posyf) / 3.0f) {
                  int dl = mysurf.listecouche.size();
                  for (int i = 0 ; i < dl ; i++) {
                    if (mysurf.listecouche.get(i).active) {
                      mysurf.listecouche.get(i).scale = 1.0f;
                    }
                  }
                  mysurf.drawmoveresize = false;
                } else {*/
                if (mysurf.drawmoveresize) { // on a fini notre zoom
                    int couchel = mysurf.listecouche.size();
                    for (int k = 0; k < couchel; k++)
                        if (mysurf.listecouche.get(k).active)
                            recreecanvasenzero(k, mysurf.ScreenWidth, mysurf.ScreenHeight);
                } else { // on va commencer le zoom on ne peut plus dessiner
                    if (mysurf.drawcurrlayer == -1) {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            mysurf.listecouche.get(k).backupscale = mysurf.listecouche.get(k).scale;
                            mysurf.listecouche.get(k).active = true;
                        }
                    } else {
                        int couchel = mysurf.listecouche.size();
                        for (int k = 0; k < couchel; k++) {
                            mysurf.listecouche.get(k).backupscale = mysurf.listecouche.get(k).scale;
                            if (k == mysurf.drawcurrlayer)
                                mysurf.listecouche.get(k).active = true;
                            else
                                mysurf.listecouche.get(k).active = false;
                        }
                    }
                }
                mysurf.drawmoveresize = !mysurf.drawmoveresize;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.drawmoveresize) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(drawchangeresize, posxi, posyi, null);
        surfacecanvas.drawText(ecritoption, posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuundo(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                int dernierelement = mysurf.listedessin.size() - 1;
                if (dernierelement >= 0) {
                    Dessin dessin = mysurf.listedessin.get(dernierelement);
                    int cettelayer = dessin.couche;
                    if (dessin.geometrictype == Dessin.drawgeometrictypepicture) {
                        if (dessin.originalpicture != null) {
                            if (!dessin.originalpicture.isRecycled()) {
                                dessin.originalpicture.recycle();
                                dessin.originalw = 0;
                                dessin.originalh = 0;
                            }
                            dessin.originalpicture = null;
                        }
                    }
                    mysurf.listedessin.remove(dernierelement);
                    recreecanvasenzero(cettelayer, mysurf.ScreenWidth, mysurf.ScreenHeight);
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(undo, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuselectlast(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                int dernierelement = mysurf.listedessin.size() - 1;
                if (dernierelement >= 0) {
                    int cettelayer = mysurf.listedessin.get(dernierelement).couche;
                    mysurf.listedessin.remove(dernierelement);
                    recreecanvasenzero(cettelayer, mysurf.ScreenWidth, mysurf.ScreenHeight);
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(select, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuduplicate(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace * 5.0f;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                int dernierelement = mysurf.listedessin.size() - 1;
                if (dernierelement >= 0) {
                    Dessin olddessin = mysurf.listedessin.get(dernierelement);
                    Dessin cedessin = new Dessin();
                    int nbpointrace = olddessin.x.length;
                    cedessin.x = new float[nbpointrace];
                    cedessin.y = new float[nbpointrace];
                    cedessin.p = new float[nbpointrace];
                    cedessin.d = new float[nbpointrace];
                    cedessin.t = new float[nbpointrace];
                    for (int k = 0; k < nbpointrace; k++) {
                        cedessin.x[k] = olddessin.x[k];
                        cedessin.y[k] = olddessin.y[k];
                        cedessin.p[k] = olddessin.p[k];
                        cedessin.d[k] = olddessin.d[k];
                        cedessin.t[k] = olddessin.t[k];

                    }
                    cedessin.couleura = mysurf.drawtracecurrcolora;
                    cedessin.couleurh = mysurf.drawtracecurrcolorh;
                    cedessin.couleurs = mysurf.drawtracecurrcolors;
                    cedessin.couleurv = mysurf.drawtracecurrcolorv;
                    cedessin.generecouleur();
                    cedessin.pressuremax = model.drawtracepressuremax;
                    cedessin.pressuremin = model.drawtracepressuremin;
                    cedessin.sizemin = mysurf.drawtracecurrsizemin;
                    cedessin.sizemax = mysurf.drawtracecurrsizemax;
                    cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                    cedessin.bezierlength = mysurf.drawtracecurrbezier;
                    cedessin.geometrictype = mysurf.drawgeometrictype;
                    cedessin.porterduff = mysurf.drawporterduff;
                    int cettelayer = mysurf.drawcurrlayer;
                    if (cettelayer < 0) {
                        cettelayer = 0;
                    }
                    cedessin.couche = cettelayer;
                    mysurf.listedessin.add(cedessin);
                    Canvas thissurfacecanvas = mysurf.listecouche.get(cettelayer).canvas;
                    dessinelatrace(dernierelement + 1, thissurfacecanvas);
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(duplicate, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menuchange(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                int dernierelement = mysurf.listedessin.size() - 1;
                if (dernierelement >= 0) {
                    Dessin olddessin = mysurf.listedessin.get(dernierelement);
                    Dessin cedessin = new Dessin();
                    int nbpointrace = olddessin.x.length;
                    cedessin.x = new float[nbpointrace];
                    cedessin.y = new float[nbpointrace];
                    cedessin.p = new float[nbpointrace];
                    cedessin.d = new float[nbpointrace];
                    cedessin.t = new float[nbpointrace];
                    for (int k = 0; k < nbpointrace; k++) {
                        cedessin.x[k] = olddessin.x[k];
                        cedessin.y[k] = olddessin.y[k];
                        cedessin.p[k] = olddessin.p[k];
                        cedessin.d[k] = olddessin.d[k];
                        cedessin.t[k] = olddessin.t[k];
                    }
                    cedessin.couleura = mysurf.drawtracecurrcolora;
                    cedessin.couleurh = mysurf.drawtracecurrcolorh;
                    cedessin.couleurs = mysurf.drawtracecurrcolors;
                    cedessin.couleurv = mysurf.drawtracecurrcolorv;
                    cedessin.generecouleur();
                    cedessin.pressuremax = model.drawtracepressuremax;
                    cedessin.pressuremin = model.drawtracepressuremin;
                    cedessin.sizemin = mysurf.drawtracecurrsizemin;
                    cedessin.sizemax = mysurf.drawtracecurrsizemax;
                    cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                    cedessin.bezierlength = mysurf.drawtracecurrbezier;
                    cedessin.geometrictype = mysurf.drawgeometrictype;
                    cedessin.porterduff = mysurf.drawporterduff;
                    int cettelayer = mysurf.drawcurrlayer;
                    if (cettelayer < 0) {
                        cettelayer = 0;
                    }
                    cedessin.couche = cettelayer;
                    mysurf.listedessin.set(dernierelement, cedessin);
                    recreecanvasenzero(cettelayer, mysurf.ScreenWidth, mysurf.ScreenHeight);
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(change, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menubgcolor(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                llog.d(TAG, posxi + " " + clicktohandlex + " " + posxf + " ; " + posyi + " " + clicktohandley + " " + posyf);
                if (mysurf.listecouche.size() > 0) {
                    Couche cettecouche;
                    if (mysurf.drawcurrlayer >= 0)
                        cettecouche = mysurf.listecouche.get(mysurf.drawcurrlayer);
                    else
                        cettecouche = mysurf.listecouche.get(0);
                    cettecouche.backgroundcolor = Color.HSVToColor((int) mysurf.drawtracecurrcolora, new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv});
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(bg, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupickcolor(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                // attention il faut un clickquicknavmenu uniquement sinon chain click ! switches !
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (mysurf.pickacolor == mysurf.pickacoloralllayers)
                    mysurf.pickacolor = 0;
                else
                    mysurf.pickacolor = mysurf.pickacoloralllayers;
            } else if (mysurf.pickacolor == mysurf.pickacoloralllayers && !(clicktohandlex < mysurf.drawmenutotalw && clicktohandley < mysurf.drawmenutotalh)) {
                // attention on ne prend pas dans le menudessiner
                clickquicknavmenu = false;
                needanotherupdate = true;
                int celayer = -1;
                if (mysurf.drawcurrlayer >= 0) {
                    celayer = mysurf.drawcurrlayer;
                    Couche cettecouche = mysurf.listecouche.get(celayer);
                    float coulenx = (clicktohandlex - cettecouche.x) / cettecouche.scale;
                    float couleny = (clicktohandley - cettecouche.y) / cettecouche.scale;
                    if (0 <= coulenx && coulenx < cettecouche.originalw && 0 <= couleny && couleny < cettecouche.originalh) {
                        int couleur = cettecouche.currentbitmap.getPixel((int) coulenx, (int) couleny);
                        if ((couleur & 0xffffff) != (cettecouche.backgroundcolor & 0xffffff)) {
                            // on regarde s'il n'y a rien sur les autres couches
                            celayer = -1;
                        } else {
                            float[] couleurhsv = new float[3];
                            Color.colorToHSV(couleur, couleurhsv);
                            mysurf.drawtracecurrcolorh = couleurhsv[0];
                            mysurf.drawtracecurrcolors = couleurhsv[1];
                            mysurf.drawtracecurrcolorv = couleurhsv[2];
                        }
                    } else {
                        celayer = -1;
                    }
                }
                if (celayer == -1) {
                    int drawbitmapl = mysurf.listecouche.size();
                    for (int i = 0; i < drawbitmapl; i++) {
                        celayer = i;
                        Couche cettecouche = mysurf.listecouche.get(celayer);
                        float coulenx = (clicktohandlex - cettecouche.x) / cettecouche.scale;
                        float couleny = (clicktohandley - cettecouche.y) / cettecouche.scale;
                        if (0 <= coulenx && coulenx < cettecouche.originalw && 0 <= couleny && couleny < cettecouche.originalh) {
                            int couleur = cettecouche.currentbitmap.getPixel((int) coulenx, (int) couleny);
                            float[] couleurhsv = new float[3];
                            Color.colorToHSV(couleur, couleurhsv);
                            mysurf.drawtracecurrcolorh = couleurhsv[0];
                            mysurf.drawtracecurrcolors = couleurhsv[1];
                            mysurf.drawtracecurrcolorv = couleurhsv[2];
                            if ((couleur & 0xffffff) != (cettecouche.backgroundcolor & 0xffffff)) {
                                // sinon on attend de voir
                                // s'il y a plus intéressant derrière
                                // on écrira par-dessus et on quittera
                                break;
                            }
                        }
                    }
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.pickacolor == mysurf.pickacoloralllayers) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(pickcolor, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupickcolorclosest(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                // attention il faut un clickquicknavmenu uniquement sinon chain click ! switches !
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (mysurf.pickacolor == mysurf.pickacolorclosest)
                    mysurf.pickacolor = 0;
                else
                    mysurf.pickacolor = mysurf.pickacolorclosest;
            } else if (mysurf.pickacolor == mysurf.pickacolorclosest && !(clicktohandlex < mysurf.drawmenutotalw && clicktohandley < mysurf.drawmenutotalh)) {
                // attention on ne prend pas dans le menudessiner
                clickquicknavmenu = false;
                needanotherupdate = true;
                int celayer = mysurf.drawcurrlayer;
                if (celayer == -1)
                    celayer = 0;
                int selclosestpathu = -1;
                Couche cettecouche = mysurf.listecouche.get(celayer);
                float x = (clicktohandlex - cettecouche.x) / cettecouche.scale;
                float y = (clicktohandley - cettecouche.y) / cettecouche.scale;
                int listedessinl = mysurf.listedessin.size();
                float meilleurv = -1.0f;
                Dessin cedessin;
                for (int i = 0; i < listedessinl; i++) {
                    cedessin = mysurf.listedessin.get(i);
                    if (cedessin.couche == celayer) {
                        if (cedessin.x != null) {
                            if (cedessin.x.length > 0) {
                                for (int j = 0; j < cedessin.x.length; j++) {
                                    float d2 = (cedessin.x[j] - x) * (cedessin.x[j] - x)
                                            + (cedessin.y[j] - y) * (cedessin.y[j] - y);
                                    if (d2 < meilleurv || meilleurv < 0) {
                                        meilleurv = d2;
                                        selclosestpathu = i;
                                    }
                                }
                            }
                        }
                    }
                }
                if (selclosestpathu >= 0) {
                    cedessin = mysurf.listedessin.get(selclosestpathu);
                    mysurf.drawtracecurrcolora = cedessin.couleura;
                    mysurf.drawtracecurrcolorh = cedessin.couleurh;
                    mysurf.drawtracecurrcolors = cedessin.couleurs;
                    mysurf.drawtracecurrcolorv = cedessin.couleurv;
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.pickacolor == mysurf.pickacolorclosest) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(drawselectone, posxi, posyi, null);
        surfacecanvas.drawText("col", posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupickthicknessclosest(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                // attention il faut un clickquicknavmenu uniquement sinon chain click ! switches !
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (mysurf.pickacolor == mysurf.pickacolorthickness)
                    mysurf.pickacolor = 0;
                else
                    mysurf.pickacolor = mysurf.pickacolorthickness;
            } else if (mysurf.pickacolor == mysurf.pickacolorthickness && !(clicktohandlex < mysurf.drawmenutotalw && clicktohandley < mysurf.drawmenutotalh)) {
                // attention on ne prend pas dans le menudessiner
                clickquicknavmenu = false;
                needanotherupdate = true;
                int celayer = mysurf.drawcurrlayer;
                if (celayer == -1)
                    celayer = 0;
                int selclosestpathu = -1;
                Couche cettecouche = mysurf.listecouche.get(celayer);
                float x = (clicktohandlex - cettecouche.x) / cettecouche.scale;
                float y = (clicktohandley - cettecouche.y) / cettecouche.scale;
                int listedessinl = mysurf.listedessin.size();
                float meilleurv = -1.0f;
                Dessin cedessin;
                for (int i = 0; i < listedessinl; i++) {
                    cedessin = mysurf.listedessin.get(i);
                    if (cedessin.couche == celayer) {
                        if (cedessin.x != null) {
                            if (cedessin.x.length > 0) {
                                for (int j = 0; j < cedessin.x.length; j++) {
                                    float d2 = (cedessin.x[j] - x) * (cedessin.x[j] - x)
                                            + (cedessin.y[j] - y) * (cedessin.y[j] - y);
                                    if (d2 < meilleurv || meilleurv < 0) {
                                        meilleurv = d2;
                                        selclosestpathu = i;
                                    }
                                }
                            }
                        }
                    }
                }
                if (selclosestpathu >= 0) {
                    cedessin = mysurf.listedessin.get(selclosestpathu);
                    mysurf.drawtracecurrsizemin = cedessin.sizemin;
                    mysurf.drawtracecurrsizemax = cedessin.sizemax;
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        if (mysurf.pickacolor == mysurf.pickacolorthickness) {
            surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinSelectedPaint);
        }
        surfacecanvas.drawBitmap(drawselectone, posxi, posyi, null);
        surfacecanvas.drawText("thck", posxi, posyf, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    private boolean colormenuexpand = false;

    public boolean menucolorexpand(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + model.DessinCaseH + model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                colormenuexpand = !colormenuexpand;
                clickquicknavmenu = false;
                needanotherupdate = true;
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.DessinBgPaint);
        surfacecanvas.drawBitmap(menusize, posxi, posyi, null);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menucolorh(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + quartdelargeurrestante;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu) {
            if (posxi - model.DessinInterSpace < clicktohandlex && clicktohandlex < posxf + model.DessinInterSpace && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float coulpente = 360.0f / (posxf - posxi);
                float coulord = -coulpente * posxi;
                if (clicktohandlex < posxi)
                    clicktohandlex = posxi;
                if (clicktohandlex > posxf)
                    clicktohandlex = posxf;
                float coul = coulpente * clicktohandlex + coulord;
                mysurf.drawtracecurrcolorh = coul;
                model.preferences.edit().putFloat("drawtracecurrcolorh", mysurf.drawtracecurrcolorh).commit();
            }
        }
        float coulpenteinv = (posxf - posxi) / 360.0f;
        float coulordinv = posxi;
        float maposxi = posxi;
        int increment = 6;
        for (int i = 0; i < 360; i += increment) {
            int macouleur = Color.HSVToColor(new float[]{((float) i + increment / 2.0f), mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv});
            rectangle.setColor(macouleur);
            float maposxf = coulpenteinv * ((float) i + increment) + coulordinv;
            recti = new RectF(maposxi, posyi, maposxf, posyf);
            surfacecanvas.drawRect(recti, rectangle);
            maposxi = maposxf;
        }
        float curseurpos = coulpenteinv * mysurf.drawtracecurrcolorh + coulordinv;
        rectangle2.setColor(Color.BLACK);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre, posyf - model.unmillimetre, curseurpos + model.unmillimetre, posyf, rectangle2);
        rectangle2.setColor(Color.WHITE);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre * 0.5f, posyf - model.unmillimetre * 0.5f, curseurpos + model.unmillimetre * 0.5f, posyf, rectangle2);
        int rgb = Color.HSVToColor(new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv});
        if (!colormenuexpand)
            surfacecanvas.drawText(String.format("h %.1f            r %d g %d b %d", mysurf.drawtracecurrcolorh, Color.red(rgb), Color.green(rgb), Color.blue(rgb)), posxi, posyf + model.DessinCaseTextH, model.DessinTextPaint);
        posxf += model.DessinInterSpace;
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menucolors(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + quartdelargeurrestante;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu) {
            if (posxi - model.DessinInterSpace < clicktohandlex && clicktohandlex < posxf + model.DessinInterSpace && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float coulpente = 1.0f / (posxf - posxi);
                float coulord = -coulpente * posxi;
                if (clicktohandlex < posxi)
                    clicktohandlex = posxi;
                if (clicktohandlex > posxf)
                    clicktohandlex = posxf;
                float coul = coulpente * clicktohandlex + coulord;
                mysurf.drawtracecurrcolors = coul;
                model.preferences.edit().putFloat("drawtracecurrcolors", mysurf.drawtracecurrcolors).commit();
            }
        }
        float coulpenteinv = (posxf - posxi) / 1.0f;
        float coulordinv = posxi;
        float maposxi = posxi;
        float incrementf = 0.20f;
        for (float i = 0.0f; i < 1.0f; i += incrementf) {
            int macouleur = Color.HSVToColor(new float[]{mysurf.drawtracecurrcolorh, ((float) i + incrementf / 2.0f), mysurf.drawtracecurrcolorv});
            rectangle.setColor(macouleur);
            float maposxf = coulpenteinv * ((float) i + incrementf) + coulordinv;
            recti = new RectF(maposxi, posyi, maposxf, posyf);
            surfacecanvas.drawRect(recti, rectangle);
            maposxi = maposxf;
        }
        float curseurpos = coulpenteinv * mysurf.drawtracecurrcolors + coulordinv;
        rectangle2.setColor(Color.BLACK);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre, posyf - model.unmillimetre, curseurpos + model.unmillimetre, posyf, rectangle2);
        rectangle2.setColor(Color.WHITE);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre * 0.5f, posyf - model.unmillimetre * 0.5f, curseurpos + model.unmillimetre * 0.5f, posyf, rectangle2);
        if (!colormenuexpand)
            surfacecanvas.drawText(String.format("s %.3f", mysurf.drawtracecurrcolors), posxi, posyf + model.DessinCaseTextH, model.DessinTextPaint);
        posxf += model.DessinInterSpace;
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menucolorv(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + quartdelargeurrestante;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu) {
            if (posxi - model.DessinInterSpace < clicktohandlex && clicktohandlex < posxf + model.DessinInterSpace && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float coulpente = 1.0f / (posxf - posxi);
                float coulord = -coulpente * posxi;
                if (clicktohandlex < posxi)
                    clicktohandlex = posxi;
                if (clicktohandlex > posxf)
                    clicktohandlex = posxf;
                float coul = coulpente * clicktohandlex + coulord;
                mysurf.drawtracecurrcolorv = coul;
                model.preferences.edit().putFloat("drawtracecurrcolorv", mysurf.drawtracecurrcolorv).commit();
            }
        }
        float coulpenteinv = (posxf - posxi) / 1.0f;
        float coulordinv = posxi;
        float maposxi = posxi;
        float incrementf = 0.10f;
        for (float i = 0.0f; i < 1.0f; i += incrementf) {
            int macouleur = Color.HSVToColor(new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, ((float) i + incrementf / 2.0f)});
            rectangle.setColor(macouleur);
            float maposxf = coulpenteinv * ((float) i + incrementf) + coulordinv;
            recti = new RectF(maposxi, posyi, maposxf, posyf);
            surfacecanvas.drawRect(recti, rectangle);
            maposxi = maposxf;
        }
        float curseurpos = coulpenteinv * mysurf.drawtracecurrcolorv + coulordinv;
        rectangle2.setColor(Color.BLACK);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre, posyf - model.unmillimetre, curseurpos + model.unmillimetre, posyf, rectangle2);
        rectangle2.setColor(Color.WHITE);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre * 0.5f, posyf - model.unmillimetre * 0.5f, curseurpos + model.unmillimetre * 0.5f, posyf, rectangle2);
        if (!colormenuexpand)
            surfacecanvas.drawText(String.format("v %.3f", mysurf.drawtracecurrcolorv), posxi, posyf + model.DessinCaseTextH, model.DessinTextPaint);
        posxf += model.DessinInterSpace;
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menucolora(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = posxi + quartdelargeurrestante;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu) {
            if (posxi - model.DessinInterSpace < clicktohandlex && clicktohandlex < posxf + model.DessinInterSpace && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float coulpente = 255.0f / (posxf - posxi);
                float coulord = -coulpente * posxi;
                if (clicktohandlex < posxi)
                    clicktohandlex = posxi;
                if (clicktohandlex > posxf)
                    clicktohandlex = posxf;
                float coul = coulpente * clicktohandlex + coulord;
                mysurf.drawtracecurrcolora = coul;
                model.preferences.edit().putFloat("drawtracecurrcolora", mysurf.drawtracecurrcolora).commit();
            }
        }
        float coulpenteinv = (posxf - posxi) / 255.0f;
        float coulordinv = posxi;
        float maposxi = posxi;
        float increment = 15;
        for (int i = 0; i < 255; i += increment) {
            int macouleur = Color.HSVToColor((int) ((float) i + increment / 2.0f), new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv});
            rectangle.setColor(macouleur);
            float maposxf = coulpenteinv * ((float) i + increment) + coulordinv;
            recti = new RectF(maposxi, posyi, maposxf, posyf);
            surfacecanvas.drawRect(recti, rectangle);
            maposxi = maposxf;
        }
        float curseurpos = coulpenteinv * mysurf.drawtracecurrcolora + coulordinv;
        rectangle2.setColor(Color.BLACK);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre, posyf - model.unmillimetre, curseurpos + model.unmillimetre, posyf, rectangle2);
        rectangle2.setColor(Color.WHITE);
        surfacecanvas.drawRect(curseurpos - model.unmillimetre * 0.5f, posyf - model.unmillimetre * 0.5f, curseurpos + model.unmillimetre * 0.5f, posyf, rectangle2);
        if (!colormenuexpand)
            surfacecanvas.drawText(String.format("a %.1f", mysurf.drawtracecurrcolora), posxi, posyf + model.DessinCaseTextH, model.DessinTextPaint);
        else {
            int rgb = Color.HSVToColor(new float[]{mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv});
            surfacecanvas.drawText(String.format("h %.1f s %.3f v %.3f a %.0f           r %d g %d b %d", mysurf.drawtracecurrcolorh, mysurf.drawtracecurrcolors, mysurf.drawtracecurrcolorv, mysurf.drawtracecurrcolora, Color.red(rgb), Color.green(rgb), Color.blue(rgb)), posxi, posyf + model.DessinCaseTextH, model.DessinTextPaint);
        }
        posxf += model.DessinInterSpace;
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupressurecst(Canvas surfacecanvas) {
        if (mysurf.pressuresize) {
            ecritoption = "Pressure sensitive size";
        } else {
            ecritoption = "Keep constant size";
        }
        posxi = 0.0f + model.DessinInterSpace;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        posxf = posxi + taillex + model.DessinInterSpace * 2.0f;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                mysurf.pressuresize = !mysurf.pressuresize;
                if (!mysurf.pressuresize) {
                    mysurf.drawtracecurrsizemax = mysurf.drawtracecurrsizemin;
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        surfacecanvas.drawText(ecritoption, posxf, ecrity, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupointsize(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = mysurf.ScreenWidth - model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float rapport = (clicktohandlex - posxi) / (posxf - posxi);
                if (rapport > 0.5f) {
                    mysurf.drawtracecurrsizemin += mysurf.drawtracemaximumadd * 2.0f * (rapport - 0.5f);
                } else if (rapport < 0.5f) {
                    mysurf.drawtracecurrsizemin -= mysurf.drawtracemaximumadd * 2.0f * (0.5f - rapport);
                }
                if (mysurf.drawtracecurrsizemin < model.unmillimetre / 100.0f) {
                    mysurf.drawtracecurrsizemin = model.unmillimetre / 100.0f;
                }
                if (mysurf.drawtracecurrsizemin > model.unmillimetre * 50.0f) {
                    mysurf.drawtracecurrsizemin = model.unmillimetre * 50.0f;
                }
                if (mysurf.drawtracecurrsizemin > mysurf.drawtracecurrsizemax) {
                    mysurf.drawtracecurrsizemax = mysurf.drawtracecurrsizemin;
                }
                model.preferences.edit().putFloat("drawtracecurrsizemin", mysurf.drawtracecurrsizemin).commit();
                model.preferences.edit().putFloat("drawtracecurrsizemax", mysurf.drawtracecurrsizemax).commit();
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        rectangle.setStrokeWidth(mysurf.drawtracecurrsizemin);
        rectangle.setStyle(Paint.Style.STROKE);
        float midx = (posxi + posxf) / 2.0f;
        float midy = (posyi + posyf) / 2.0f;
        surfacecanvas.drawPoint(midx, midy, rectangle);
        rectangle.setStyle(Paint.Style.FILL);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupressure(Canvas surfacecanvas) {
        if (model.drawtracepressuremax >= 0) {
            ecritoption = String.format("Pressure [%.1f:%.1f]", model.drawtracepressuremin, model.drawtracepressuremax);
        } else {
            ecritoption = String.format("Calibrate pressure here");
        }
        posxi = posxf + model.DessinInterSpace;
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        posxf = posxi + taillex + model.DessinInterSpace * 2.0f;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                if (neworder.length > 5) {
                    float macurrentclicpressure = Float.parseFloat(neworder[5]);
                    if (macurrentclicpressure < model.drawtracepressuremin || model.drawtracepressuremin == -99.99f) {
                        model.drawtracepressuremin = macurrentclicpressure;
                    }
                    if (macurrentclicpressure > model.drawtracepressuremax || model.drawtracepressuremax == -99.99f) {
                        model.drawtracepressuremax = macurrentclicpressure;
                    }
                    llog.d(TAG, model.drawtracepressuremin + " < pressure < " + model.drawtracepressuremax);
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        surfacecanvas.drawText(ecritoption, posxf, ecrity, model.DessinTextPaint);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menupressure2(Canvas surfacecanvas) {
        posxi = posxf + model.DessinInterSpace;
        posxf = mysurf.ScreenWidth - model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float rapport = (clicktohandlex - posxi) / (posxf - posxi);
                if (rapport > 0.5f) {
                    mysurf.drawtracecurrsizemax += mysurf.drawtracemaximumadd * 2.0f * (rapport - 0.5f);
                } else if (rapport < 0.5f) {
                    mysurf.drawtracecurrsizemax -= mysurf.drawtracemaximumadd * 2.0f * (0.5f - rapport);
                }
                if (mysurf.drawtracecurrsizemax < model.unmillimetre / 100.0f) {
                    mysurf.drawtracecurrsizemax = model.unmillimetre / 100.0f;
                }
                if (mysurf.drawtracecurrsizemax > model.unmillimetre * 50.0f) {
                    mysurf.drawtracecurrsizemax = model.unmillimetre * 50.0f;
                }
                if (mysurf.drawtracecurrsizemax < mysurf.drawtracecurrsizemin) {
                    mysurf.drawtracecurrsizemin = mysurf.drawtracecurrsizemax;
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        rectangle.setStrokeWidth(mysurf.drawtracecurrsizemax);
        rectangle.setStyle(Paint.Style.STROKE);
        float midx = (posxi + posxf) / 2.0f;
        float midy = (posyi + posyf) / 2.0f;
        surfacecanvas.drawPoint(midx, midy, rectangle);
        rectangle.setStyle(Paint.Style.FILL);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }

    public boolean menudrawpath(Canvas surfacecanvas) {
        rectangle.setStyle(Paint.Style.STROKE);
        rectangle.setColor(Color.BLACK);
        posxi = posxf + model.DessinInterSpace;
        posxf = mysurf.ScreenWidth - model.DessinInterSpace;
        posyf = posyi + model.DessinCaseH;
        ecritoption = "no Bézier rounding";
        taillex = model.Menu1TextePaint.measureText(ecritoption);
        ecritx = posxi + model.DessinInterSpace;
        ecrity = posyi + model.DessinCaseH * 0.5f + 0.33f * model.DessinCaseTextH;
        if (clickquicknavmenu && !wearemoving) {
            if (posxi < clicktohandlex && clicktohandlex < posxf && posyi < clicktohandley && clicktohandley < posyf) {
                clickquicknavmenu = false;
                needanotherupdate = true;
                float rapport = (clicktohandlex - posxi) / (posxf - posxi);
                if (rapport > 0.5f) {
                    mysurf.drawtracecurrbezier += model.unmillimetre * 2.0f * (rapport - 0.5f);
                } else if (rapport < 0.5f) {
                    mysurf.drawtracecurrbezier -= model.unmillimetre * 2.0f * (0.5f - rapport);
                }
                if (mysurf.drawtracecurrbezier < 0.0f) {
                    mysurf.drawtracecurrbezier = 0.0f;
                }
                if (mysurf.drawtracecurrbezier > model.unmillimetre * 50.0f) {
                    mysurf.drawtracecurrbezier = model.unmillimetre * 50.0f;
                }
            }
        }
        recti = new RectF(posxi, posyi, posxf, posyf);
        surfacecanvas.drawRoundRect(recti, model.DessinCaseH * 0.2f, model.DessinCaseH * 0.2f, model.Menu1BgPainto);
        if (mysurf.drawtracecurrbezier > 0.0f) {
            rectangle.setStrokeWidth(model.unmillimetre * 0.4f);
            float midy = (posyi + posyf) / 2.0f;
            surfacecanvas.drawLine(posxi, midy, mysurf.drawtracecurrbezier, midy, rectangle);
        } else {
            surfacecanvas.drawText(ecritoption, ecritx, ecrity, model.DessinTextPaint);
        }
        rectangle.setStyle(Paint.Style.FILL);
        if (posxf > posxmax)
            posxmax = posxf;
        return true;
    }
/*
  public boolean menu(Canvas surfacecanvas) {
    if (posxf > posxmax)
      posxmax = posxf;
    return true;
  }
*/

    private void drawmenuimageloadrecycle() {
        if (pickcolor != null)
            if (!pickcolor.isRecycled())
                pickcolor.recycle();
        pickcolor = null;
        if (menusize != null)
            if (!menusize.isRecycled())
                menusize.recycle();
        menusize = null;
        if (bezier != null)
            if (!bezier.isRecycled())
                bezier.recycle();
        bezier = null;
        if (select != null)
            if (!select.isRecycled())
                select.recycle();
        select = null;
        if (recycle != null)
            if (!recycle.isRecycled())
                recycle.recycle();
        recycle = null;
        if (save != null)
            if (!save.isRecycled())
                save.recycle();
        save = null;
        if (addcanvas != null)
            if (!addcanvas.isRecycled())
                addcanvas.recycle();
        addcanvas = null;
        if (addpic != null)
            if (!addpic.isRecycled())
                addpic.recycle();
        addpic = null;
        if (change != null)
            if (!change.isRecycled())
                change.recycle();
        change = null;
        if (contour != null)
            if (!contour.isRecycled())
                contour.recycle();
        contour = null;
        if (graph != null)
            if (!graph.isRecycled())
                graph.recycle();
        graph = null;
        if (contrast != null)
            if (!contrast.isRecycled())
                contrast.recycle();
        contrast = null;
        if (draw != null)
            if (!draw.isRecycled())
                draw.recycle();
        draw = null;
        if (duplicate != null)
            if (!duplicate.isRecycled())
                duplicate.recycle();
        duplicate = null;
        if (erase != null)
            if (!erase.isRecycled())
                erase.recycle();
        erase = null;
        if (fill != null)
            if (!fill.isRecycled())
                fill.recycle();
        fill = null;
        if (hand != null)
            if (!hand.isRecycled())
                hand.recycle();
        hand = null;
        if (layers != null)
            if (!layers.isRecycled())
                layers.recycle();
        layers = null;
        if (quit != null)
            if (!quit.isRecycled())
                quit.recycle();
        quit = null;
        if (stylus != null)
            if (!stylus.isRecycled())
                stylus.recycle();
        stylus = null;
        if (undo != null)
            if (!undo.isRecycled())
                undo.recycle();
        undo = null;
        if (zoom != null)
            if (!zoom.isRecycled())
                zoom.recycle();
        zoom = null;
        if (drawbgspot != null)
            if (!drawbgspot.isRecycled())
                drawbgspot.recycle();
        drawbgspot = null;
        if (drawchangethickness != null)
            if (!drawchangethickness.isRecycled())
                drawchangethickness.recycle();
        drawchangethickness = null;
        if (drawduplicate != null)
            if (!drawduplicate.isRecycled())
                drawduplicate.recycle();
        drawduplicate = null;
        if (drawline != null)
            if (!drawline.isRecycled())
                drawline.recycle();
        drawline = null;
        if (drawmove != null)
            if (!drawmove.isRecycled())
                drawmove.recycle();
        drawmove = null;
        if (drawmovepoint != null)
            if (!drawmovepoint.isRecycled())
                drawmovepoint.recycle();
        drawmovepoint = null;
        if (drawmoveto != null)
            if (!drawmoveto.isRecycled())
                drawmoveto.recycle();
        drawmoveto = null;
        if (drawradialfill != null)
            if (!drawradialfill.isRecycled())
                drawradialfill.recycle();
        drawradialfill = null;
        if (drawselectmultiple != null)
            if (!drawselectmultiple.isRecycled())
                drawselectmultiple.recycle();
        drawselectmultiple = null;
        if (drawselectone != null)
            if (!drawselectone.isRecycled())
                drawselectone.recycle();
        drawselectone = null;
        if (drawtraceremove != null)
            if (!drawtraceremove.isRecycled())
                drawtraceremove.recycle();
        drawtraceremove = null;
        if (drawchangecolor != null)
            if (!drawchangecolor.isRecycled())
                drawchangecolor.recycle();
        drawchangecolor = null;
        if (drawchangedown != null)
            if (!drawchangedown.isRecycled())
                drawchangedown.recycle();
        drawchangedown = null;
        if (drawchangeup != null)
            if (!drawchangeup.isRecycled())
                drawchangeup.recycle();
        drawchangeup = null;
        if (drawchangeresize != null)
            if (!drawchangeresize.isRecycled())
                drawchangeresize.recycle();
        drawchangeresize = null;
        if (drawchangetype != null)
            if (!drawchangetype.isRecycled())
                drawchangetype.recycle();
        drawchangetype = null;
    }

    private void drawmenuimageload() {
        addcanvas = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.addcanvas);
        addcanvas = Bitmap.createScaledBitmap(addcanvas, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        addpic = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.addpic);
        addpic = Bitmap.createScaledBitmap(addpic, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        bezier = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.bezier);
        bezier = Bitmap.createScaledBitmap(bezier, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        bg = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.bg);
        bg = Bitmap.createScaledBitmap(bg, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        change = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.change);
        change = Bitmap.createScaledBitmap(change, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        contour = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.contour);
        contour = Bitmap.createScaledBitmap(contour, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        contrast = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.contrast);
        contrast = Bitmap.createScaledBitmap(contrast, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        draw = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.draw);
        draw = Bitmap.createScaledBitmap(draw, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        duplicate = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.duplicate);
        duplicate = Bitmap.createScaledBitmap(duplicate, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        erase = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.erase);
        erase = Bitmap.createScaledBitmap(erase, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        fill = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.fill);
        fill = Bitmap.createScaledBitmap(fill, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        graph = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.graph);
        graph = Bitmap.createScaledBitmap(graph, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        hand = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.hand);
        hand = Bitmap.createScaledBitmap(hand, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        layers = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.layers);
        layers = Bitmap.createScaledBitmap(layers, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        menusize = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.menusize);
        menusize = Bitmap.createScaledBitmap(menusize, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        pickcolor = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.pickcolor);
        pickcolor = Bitmap.createScaledBitmap(pickcolor, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        quit = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.quit);
        quit = Bitmap.createScaledBitmap(quit, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        recycle = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.recycle);
        recycle = Bitmap.createScaledBitmap(recycle, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        save = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.save);
        save = Bitmap.createScaledBitmap(save, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        select = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.select);
        select = Bitmap.createScaledBitmap(select, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        stylus = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.stylus);
        stylus = Bitmap.createScaledBitmap(stylus, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        undo = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.undo);
        undo = Bitmap.createScaledBitmap(undo, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        zoom = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.zoom);
        zoom = Bitmap.createScaledBitmap(zoom, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawbgspot = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawbgspot);
        drawbgspot = Bitmap.createScaledBitmap(drawbgspot, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangethickness = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangethickness);
        drawchangethickness = Bitmap.createScaledBitmap(drawchangethickness, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawduplicate = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawduplicate);
        drawduplicate = Bitmap.createScaledBitmap(drawduplicate, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawline = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawline);
        drawline = Bitmap.createScaledBitmap(drawline, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawmove = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawmove);
        drawmove = Bitmap.createScaledBitmap(drawmove, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawmovepoint = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawmovepoint);
        drawmovepoint = Bitmap.createScaledBitmap(drawmovepoint, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawmoveto = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawmoveto);
        drawmoveto = Bitmap.createScaledBitmap(drawmoveto, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawradialfill = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawradialfill);
        drawradialfill = Bitmap.createScaledBitmap(drawradialfill, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawselectmultiple = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawselectmultiple);
        drawselectmultiple = Bitmap.createScaledBitmap(drawselectmultiple, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawselectone = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawselectone);
        drawselectone = Bitmap.createScaledBitmap(drawselectone, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawtraceremove = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawtraceremove);
        drawtraceremove = Bitmap.createScaledBitmap(drawtraceremove, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangecolor = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangecolor);
        drawchangecolor = Bitmap.createScaledBitmap(drawchangecolor, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangeresize = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangeresize);
        drawchangeresize = Bitmap.createScaledBitmap(drawchangeresize, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangeup = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangeup);
        drawchangeup = Bitmap.createScaledBitmap(drawchangeup, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangedown = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangedown);
        drawchangedown = Bitmap.createScaledBitmap(drawchangedown, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
        drawchangetype = BitmapFactory.decodeResource(model.activitycontext.getResources(), R.drawable.drawchangetype);
        drawchangetype = Bitmap.createScaledBitmap(drawchangetype, (int) model.DessinCaseH, (int) model.DessinCaseH, false);
    }

    private void savebitmaptofile(Bitmap bitmap, String name) {
        llog.d(TAG, "++++++++++++++++++++++++savebitmaptofile() " + name);
        OutputStream outStream = null;
        File file = new File(name);
        try {
            outStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, outStream);
            outStream.flush();
            outStream.close();
            llog.d(TAG, "bitmap saved to " + name);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

  /*
  public static byte[] generatebytes(){
    ByteBuffer buffer = ByteBuffer.allocate(4 * values.length);
    for (float value : values){
      buffer.putFloat(value);
    }
    return buffer.array();
  }*/

    public void startblankdrawing() {
        String onchargefichier = model.dossierdessin + DateFormat.format("yyyyMMddHHmmss", new java.util.Date()).toString();
        if (mysurf.drawingcurrfichier != null)
            if (onchargefichier.equals(mysurf.drawingcurrfichier))
                onchargefichier += "n";
        mysurf.drawingcurrfichier = onchargefichier;
        model.preferences.edit().putString("lastdrawing", onchargefichier).commit();
        llog.d(TAG, "+++++++++++++++++++++++++++startblankdrawing() create " + onchargefichier);
        Couche macouche = new Couche();
        macouche.currentbitmap = Bitmap.createBitmap(mysurf.ScreenWidth, mysurf.ScreenHeight, Bitmap.Config.ARGB_8888);
        macouche.canvas = new Canvas(macouche.currentbitmap);
        macouche.x = 0.0f;
        macouche.y = 0.0f;
        macouche.originalw = mysurf.ScreenWidth;
        macouche.originalh = mysurf.ScreenHeight;
        macouche.scale = 1.0f;
        mysurf.listecouche.add(macouche);
        mysurf.drawcurrlayer = -1;
    }

    public String writelastdrawing() {
        int couchel = mysurf.listecouche.size();
        int dessinl = mysurf.listedessin.size();
        if (couchel > 1 || dessinl > 0) {

            String onchargefichier = model.dossierdessin + DateFormat.format("yyyyMMddHHmmss", new java.util.Date()).toString();
            mysurf.drawingcurrfichier = onchargefichier;
            model.preferences.edit().putString("lastdrawing", onchargefichier).commit();
            llog.d(TAG, "+++++++++++++++++++++++++++writelastdrawing() create " + onchargefichier);

            model.message("saving " + onchargefichier + ".png");

            llog.d(TAG, "Drawing data stored to " + onchargefichier + "." + Gallery.vectordrawingpatterns);
            String pngoutfullpath = onchargefichier + ".png";
            recreecanvaspoursauvegarde(pngoutfullpath);
            llog.d(TAG, "recreecanvaspoursauvegarde() " + pngoutfullpath);

            FileOutputStream fos;
            ObjectOutputStream oos;
            try {
                fos = new FileOutputStream(onchargefichier + "." + Gallery.vectordrawingpatterns);
                oos = new ObjectOutputStream(fos);

                oos.writeInt(Couche.keycount);
                oos.writeInt(couchel);
                for (int i = 0; i < couchel; i++) {
                    Couche cettecouche = mysurf.listecouche.get(i);

                    oos.writeInt(Couche.istypek);
                    oos.writeInt(Couche.istype);

                    oos.writeInt(Couche.xywhsk);
                    oos.writeFloat(cettecouche.x);
                    oos.writeFloat(cettecouche.y);
                    oos.writeFloat(0); // useless
                    oos.writeFloat(0);
                    oos.writeFloat(cettecouche.scale);
                    //llog.d(TAG, String.format("    fin    %2d :    %4.0f,%4.0f   %4.0fx%4.0f   x%.2f", i, cettecouche.x, cettecouche.y, cettecouche.originalw, cettecouche.originalh, cettecouche.scale));

                    if (cettecouche.filter != null) {
                        if (cettecouche.filter.length() > 0) {
                            oos.writeInt(Couche.filterk);
                            oos.writeUTF(cettecouche.filter);
                        }
                    }

                    oos.writeInt(Couche.gridk);
                    oos.writeFloat(cettecouche.gridx);
                    oos.writeFloat(cettecouche.gridy);

                    oos.writeInt(Couche.backgroundcolork);
                    oos.writeInt(cettecouche.backgroundcolor);

                    oos.writeInt(Couche.istypeendk);
                    oos.writeInt(Couche.istypeend);
                }
                oos.writeInt(Dessin.keycount);
                oos.writeInt(dessinl);
                for (int i = 0; i < dessinl; i++) {
                    Dessin cedessin = mysurf.listedessin.get(i);

                    oos.writeInt(Dessin.istypek);
                    oos.writeInt(Dessin.istype);

                    oos.writeInt(Dessin.couchek);
                    oos.writeInt(cedessin.couche);

                    oos.writeInt(Dessin.drawerasefillcontourk);
                    oos.writeInt(cedessin.drawerasefillcontour);

                    oos.writeInt(Dessin.nbdepointsk);
                    oos.writeInt(cedessin.nbdepoints);
                    oos.writeObject(cedessin.x);
                    oos.writeObject(cedessin.y);
                    oos.writeObject(cedessin.p);
                    oos.writeObject(cedessin.d);
                    oos.writeObject(cedessin.t);

                    oos.writeInt(Dessin.couleurk);
                    oos.writeInt(cedessin.couleur);
                    oos.writeFloat(cedessin.couleura);
                    oos.writeFloat(cedessin.couleurh);
                    oos.writeFloat(cedessin.couleurs);
                    oos.writeFloat(cedessin.couleurv);

                    oos.writeInt(Dessin.pressuremink);
                    oos.writeFloat(cedessin.pressuremin);
                    oos.writeFloat(cedessin.pressuremax);

                    oos.writeInt(Dessin.sizemink);
                    oos.writeFloat(cedessin.sizemin);
                    oos.writeFloat(cedessin.sizemax);

                    oos.writeInt(Dessin.bezierlengthk);
                    oos.writeFloat(cedessin.bezierlength);

                    oos.writeInt(Dessin.colormatrixk);
                    oos.writeObject(cedessin.colormatrix);

                    oos.writeInt(Dessin.geometrictypek);
                    oos.writeInt(cedessin.geometrictype);

                    oos.writeInt(Dessin.originalpicturek);
                    if (cedessin.originalpicture != null && cedessin.originalw > 0 && cedessin.originalh > 0) {
                        int width = cedessin.originalpicture.getWidth();
                        int height = cedessin.originalpicture.getHeight();
                        int size = width * height;
                        oos.writeInt(width);
                        oos.writeInt(height);
                        int[] mespixels = new int[size];
                        cedessin.originalpicture.getPixels(mespixels, 0, width, 0, 0, width, height);
                        oos.writeObject(mespixels);
                    } else {
                        oos.writeInt(0);
                        oos.writeInt(0);
                    }

                    oos.writeInt(Dessin.porterduffk);
                    oos.writeInt(cedessin.porterduff);

                    oos.writeInt(Dessin.istypeendk);
                    oos.writeInt(Dessin.istypeend);
                }
                oos.flush();
                oos.close();
                fos.close();
                try {
                    model.commandethreaddatabase.put(new String[]{"chercheFichierDansDatabaseSinonRescanSonDossier", model.dossierdessin, pngoutfullpath, "-1"});
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } catch (IOException e) {
                e.printStackTrace();
                llog.d(TAG, "Error saving to " + onchargefichier + "." + Gallery.vectordrawingpatterns);
                model.message("error did not save " + onchargefichier + ".png");
                return onchargefichier + ".png";
            }
            model.message("saved " + onchargefichier + ".png");
            return onchargefichier + ".png";
        } else {
            llog.d(TAG, "empty picture cannot save " + mysurf.drawingcurrfichier);
        }
        return "";
    }

    public void readlastdrawing(String currentfileinfocus) {
        /**
         *   si on avait chargé un fichier avant on le recharge
         */
        String onchargefichier = model.preferences.getString("lastdrawing", null);
        llog.d(TAG, "si on avait chargé un fichier avant on le recharge " + onchargefichier);
        /**
         *   si on cible un fichier ldpc on charge plutôt celui-là
         */
        boolean n = true;
        String extens = Gallery.vectordrawingpatterns;
        if (currentfileinfocus != null) {
            if (currentfileinfocus.endsWith(".png")) {
                int extension = currentfileinfocus.lastIndexOf(".png");
                if (extension != -1) {
                    String sansextension = currentfileinfocus.substring(0, extension);
                    File fichier = new File(sansextension + "." + Gallery.oldvectordrawingpatterns);
                    if (fichier.exists()) {
                        onchargefichier = sansextension;
                        extens = Gallery.oldvectordrawingpatterns;
                        n = false;
                    }
                    fichier = new File(sansextension + "." + Gallery.vectordrawingpatterns);
                    if (fichier.exists()) {
                        onchargefichier = sansextension;
                        extens = Gallery.vectordrawingpatterns;
                        n = true;
                    }
                }
            }
        }
        llog.d(TAG, "si on cible un fichier ldpc on charge plutôt celui-là " + model.showthisfile + " onchargefichier " + onchargefichier);
        /**
         *   sinon on commence un nouveau fichier
         */
        if (onchargefichier == null) {
            llog.d(TAG, "----------------------readlastdrawing() null");
            return;
        } else {
            mysurf.drawingcurrfichier = onchargefichier;
            model.preferences.edit().putString("lastdrawing", onchargefichier).commit();
        }
        llog.d(TAG, "++++++++++++++++++++++readlastdrawing() " + onchargefichier);
        model.message("reading " + onchargefichier + ".png");
        FileInputStream fis;
        ObjectInputStream oos;
        try {
            fis = new FileInputStream(onchargefichier + "." + extens);
            oos = new ObjectInputStream(fis);
            //mysurf.listecouche = (ArrayList<Couche>) ois.readObject();
            int couchel = 0;
            int dessinl = 0;
            if (n) {
                int k;
                int couchekeycount = oos.readInt();
                couchel = oos.readInt();
                for (int i = 0; i < couchel ; i++) {
                    Couche cettecouche = new Couche();
                    boolean encorecouchekey = true;
                    boolean isaphoto = false;
                    for (int j = 0 ; j < couchekeycount && encorecouchekey ; j++) {
                        k = oos.readInt();
                        switch (k) {
                            case Couche.istypek: {
                                int istype = oos.readInt();
                                break;
                            }
                            case Couche.istypeendk: {
                                int istypeend = oos.readInt();
                                encorecouchekey = false;
                                break;
                            }
                            case Couche.isaphotok: {
                                isaphoto = oos.readBoolean();
                                break;
                            }
                            case Couche.xywhsk: {
                                cettecouche.x = oos.readFloat();
                                cettecouche.y = oos.readFloat();
                                cettecouche.originalw = oos.readFloat();
                                cettecouche.originalh = oos.readFloat();
                                cettecouche.scale = oos.readFloat();
                                //llog.d(TAG, String.format("    ini    %2d :    %4.0f,%4.0f   %4.0fx%4.0f   x%.2f", i, cettecouche.x, cettecouche.y, cettecouche.originalw, cettecouche.originalh, cettecouche.scale));
                                break;
                            }
                            case Couche.whk: {
                                int wwidth = oos.readInt();
                                int hheight = oos.readInt();
                                if (isaphoto) {
                                    int[] mespixels = (int[]) oos.readObject();

                                    Dessin cedessin = new Dessin();
                                    cedessin.nbdepoints = 2;
                                    int drawtracecurrl = cedessin.nbdepoints;
                                    cedessin.x = new float[drawtracecurrl];
                                    cedessin.y = new float[drawtracecurrl];
                                    cedessin.p = new float[drawtracecurrl];
                                    cedessin.t = new float[drawtracecurrl];
                                    cedessin.d = new float[drawtracecurrl];
                                    cedessin.x[0] = 0.0f;
                                    cedessin.y[0] = 0.0f;
                                    cedessin.p[0] = 0.0f;
                                    cedessin.t[0] = 0.0f;
                                    cedessin.d[0] = 0.0f;
                                    cedessin.x[1] = wwidth;
                                    cedessin.y[1] = hheight;
                                    cedessin.p[1] = 0.0f;
                                    cedessin.t[1] = 0.0f;
                                    cedessin.d[1] = 0.0f;
                                    cedessin.couleura = mysurf.drawtracecurrcolora;
                                    cedessin.couleurh = mysurf.drawtracecurrcolorh;
                                    cedessin.couleurs = mysurf.drawtracecurrcolors;
                                    cedessin.couleurv = mysurf.drawtracecurrcolorv;
                                    cedessin.generecouleur();
                                    cedessin.sizemax = mysurf.drawtracecurrsizemax;
                                    cedessin.sizemin = mysurf.drawtracecurrsizemin;
                                    cedessin.pressuremax = model.drawtracepressuremax;
                                    cedessin.pressuremin = model.drawtracepressuremin;
                                    cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                                    cedessin.bezierlength = mysurf.drawtracecurrbezier;
                                    cedessin.geometrictype = Dessin.drawgeometrictypepicture;
                                    cedessin.couche = i;
                                    cedessin.originalw = wwidth;
                                    cedessin.originalh = hheight;
                                    cedessin.originalpicture = Bitmap.createBitmap(wwidth, hheight, Bitmap.Config.ARGB_8888);
                                    cedessin.originalpicture.setPixels(mespixels, 0, wwidth, 0, 0, wwidth, hheight);

                                    mysurf.listedessin.add(cedessin);
                                }
                                break;
                            }
                            case Couche.filterk: {
                                cettecouche.filter = oos.readUTF();
                                break;
                            }
                            case Couche.gridk: {
                                cettecouche.gridx = oos.readFloat();
                                cettecouche.gridy = oos.readFloat();
                                break;
                            }
                            case Couche.backgroundcolork: {
                                cettecouche.backgroundcolor = oos.readInt();
                                break;
                            }
                        }
                    }
                    mysurf.listecouche.add(cettecouche);
                }
                int dessinkeycount = oos.readInt();
                dessinl = oos.readInt();
                for (int i = 0; i < dessinl; i++) {
                    Dessin cedessin = new Dessin();
                    boolean encorecouchekey = true;
                    for (int j = 0 ; j < dessinkeycount && encorecouchekey ; j++) {
                        k = oos.readInt();
                        switch (k) {
                            case Dessin.istypek: {
                                int istype = oos.readInt();
                                break;
                            }
                            case Dessin.istypeendk: {
                                int istypeend = oos.readInt();
                                encorecouchekey = false;
                                break;
                            }
                            case Dessin.couchek: {
                                cedessin.couche = oos.readInt();
                                break;
                            }
                            case Dessin.drawerasefillcontourk: {
                                cedessin.drawerasefillcontour = oos.readInt();
                                break;
                            }
                            case Dessin.nbdepointsk: {
                                cedessin.nbdepoints = oos.readInt();
                                cedessin.x = (float[]) oos.readObject();
                                cedessin.y = (float[]) oos.readObject();
                                cedessin.p = (float[]) oos.readObject();
                                cedessin.d = (float[]) oos.readObject();
                                cedessin.t = (float[]) oos.readObject();
                                break;
                            }
                            case Dessin.couleurk: {
                                cedessin.couleur = oos.readInt();
                                cedessin.couleura = oos.readFloat();
                                cedessin.couleurh = oos.readFloat();
                                cedessin.couleurs = oos.readFloat();
                                cedessin.couleurv = oos.readFloat();
                                break;
                            }
                            case Dessin.pressuremink: {
                                cedessin.pressuremin = oos.readFloat();
                                cedessin.pressuremax = oos.readFloat();
                                break;
                            }
                            case Dessin.sizemink: {
                                cedessin.sizemin = oos.readFloat();
                                cedessin.sizemax = oos.readFloat();
                                break;
                            }
                            case Dessin.bezierlengthk: {
                                cedessin.bezierlength = oos.readFloat();
                                break;
                            }
                            case Dessin.colormatrixk: {
                                cedessin.colormatrix = (ArrayList<float[]>) oos.readObject();
                                break;
                            }
                            case Dessin.geometrictypek: {
                                cedessin.geometrictype = oos.readInt();
                                break;
                            }
                            case Dessin.originalpicturek: {
                                int width = oos.readInt();
                                int height = oos.readInt();
                                if (width > 0 && height > 0) {
                                    cedessin.originalw = width;
                                    cedessin.originalh = height;
                                    int[] mespixels = (int[]) oos.readObject();
                                    cedessin.originalpicture = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                                    cedessin.originalpicture.setPixels(mespixels, 0, width, 0, 0, width, height);
                                }
                                break;
                            }
                            case Dessin.porterduffk: {
                                cedessin.porterduff = oos.readInt();
                                break;
                            }
                        }
                    }
                    mysurf.listedessin.add(cedessin);
                }
            } else {
                couchel = oos.readInt();
                for (int i = 0; i < couchel; i++) {
                    Couche cettecouche = new Couche();
                    cettecouche.active = false;
                    boolean isaphoto = oos.readBoolean();
                    if (isaphoto) {

                        int width = oos.readInt();
                        int height = oos.readInt();
                        int size = width * height;

                        int[] mespixels = (int[]) oos.readObject();

                        Dessin cedessin = new Dessin();
                        cedessin.nbdepoints = 2;
                        int drawtracecurrl = cedessin.nbdepoints;
                        cedessin.x = new float[drawtracecurrl];
                        cedessin.y = new float[drawtracecurrl];
                        cedessin.p = new float[drawtracecurrl];
                        cedessin.t = new float[drawtracecurrl];
                        cedessin.d = new float[drawtracecurrl];
                        cedessin.x[0] = 0.0f;
                        cedessin.y[0] = 0.0f;
                        cedessin.p[0] = 0.0f;
                        cedessin.t[0] = 0.0f;
                        cedessin.d[0] = 0.0f;
                        cedessin.x[1] = width;
                        cedessin.y[1] = height;
                        cedessin.p[1] = 0.0f;
                        cedessin.t[1] = 0.0f;
                        cedessin.d[1] = 0.0f;
                        cedessin.couleura = mysurf.drawtracecurrcolora;
                        cedessin.couleurh = mysurf.drawtracecurrcolorh;
                        cedessin.couleurs = mysurf.drawtracecurrcolors;
                        cedessin.couleurv = mysurf.drawtracecurrcolorv;
                        cedessin.generecouleur();
                        cedessin.sizemax = mysurf.drawtracecurrsizemax;
                        cedessin.sizemin = mysurf.drawtracecurrsizemin;
                        cedessin.pressuremax = model.drawtracepressuremax;
                        cedessin.pressuremin = model.drawtracepressuremin;
                        cedessin.drawerasefillcontour = mysurf.drawerasefillecontour;
                        cedessin.bezierlength = mysurf.drawtracecurrbezier;
                        cedessin.geometrictype = Dessin.drawgeometrictypepicture;
                        cedessin.couche = i;
                        cedessin.originalw = width;
                        cedessin.originalh = height;
                        cedessin.originalpicture = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                        cedessin.originalpicture.setPixels(mespixels, 0, width, 0, 0, width, height);

                        mysurf.listedessin.add(cedessin);

                    } else {
                        int width = oos.readInt();
                        int height = oos.readInt();
                    }
                    cettecouche.x = oos.readFloat();
                    cettecouche.y = oos.readFloat();
                    cettecouche.originalw = oos.readFloat();
                    cettecouche.originalh = oos.readFloat();
                    cettecouche.scale = oos.readFloat();
                    mysurf.listecouche.add(cettecouche);
                }
                dessinl = oos.readInt();
                for (int i = 0; i < dessinl; i++) {
                    Dessin cedessin = new Dessin();
                    cedessin.couche = oos.readInt();
                    cedessin.drawerasefillcontour = oos.readInt();
                    cedessin.nbdepoints = oos.readInt();
                    cedessin.x = (float[]) oos.readObject();
                    cedessin.y = (float[]) oos.readObject();
                    cedessin.p = (float[]) oos.readObject();
                    cedessin.d = (float[]) oos.readObject();
                    cedessin.t = (float[]) oos.readObject();
                    cedessin.couleur = oos.readInt();
                    cedessin.couleura = oos.readFloat();
                    cedessin.couleurh = oos.readFloat();
                    cedessin.couleurs = oos.readFloat();
                    cedessin.couleurv = oos.readFloat();
                    cedessin.pressuremin = oos.readFloat();
                    cedessin.pressuremax = oos.readFloat();
                    cedessin.sizemin = oos.readFloat();
                    cedessin.sizemax = oos.readFloat();
                    cedessin.bezierlength = oos.readFloat();
                    cedessin.colormatrix = (ArrayList<float[]>) oos.readObject();
                    mysurf.listedessin.add(cedessin);
                }
            }
            int avail = oos.available();
            llog.d(TAG, "available : " + avail);
            int avai = avail;
            while (avai > 8) {
                int ava = oos.readInt();
                llog.d(TAG, avai + " - - " + ava);
                avai -= 8;
            }
            oos.close();
            fis.close();

            if (avail == 0) {
                //for (int i = 0; i < couchel; i++)
                //    recreecanvasenzero(i, mysurf.ScreenWidth, mysurf.ScreenHeight);
                llog.d(TAG, "Last drawing loaded " + onchargefichier + "." + extens);
                model.message();
                return;
            } else {
                mysurf.listecouche.clear();
                int listedessinl = mysurf.listedessin.size();
                for (int i = 0; i < listedessinl; i++) {
                    if (mysurf.listedessin.get(i).originalpicture != null) {
                        if (!mysurf.listedessin.get(i).originalpicture.isRecycled()) {
                            mysurf.listedessin.get(i).originalpicture.recycle();
                        }
                    }
                }
                mysurf.listedessin.clear();
                llog.d(TAG, avail + " avail reading " + onchargefichier + "." + extens);
                model.message("Error " + avail + " reading " + onchargefichier + ".png");
            }
        } catch (IOException e) {
            mysurf.listecouche.clear();
            int listedessinl = mysurf.listedessin.size();
            for (int i = 0; i < listedessinl; i++) {
                if (mysurf.listedessin.get(i).originalpicture != null) {
                    if (!mysurf.listedessin.get(i).originalpicture.isRecycled()) {
                        mysurf.listedessin.get(i).originalpicture.recycle();
                    }
                }
            }
            mysurf.listedessin.clear();
            e.printStackTrace();
            llog.d(TAG, "IOException reading " + onchargefichier + "." + extens);
            model.message("IOException reading " + onchargefichier + ".png");
        } catch (ClassNotFoundException e) {
            mysurf.listecouche.clear();
            int listedessinl = mysurf.listedessin.size();
            for (int i = 0; i < listedessinl; i++) {
                if (mysurf.listedessin.get(i).originalpicture != null) {
                    if (!mysurf.listedessin.get(i).originalpicture.isRecycled()) {
                        mysurf.listedessin.get(i).originalpicture.recycle();
                    }
                }
            }
            mysurf.listedessin.clear();
            e.printStackTrace();
            llog.d(TAG, "ClassNotFoundException reading " + onchargefichier + "." + extens);
            model.message("ClassNotFoundException reading " + onchargefichier + ".png");
        } catch (Exception e) {
            mysurf.listecouche.clear();
            int listedessinl = mysurf.listedessin.size();
            for (int i = 0; i < listedessinl; i++) {
                if (mysurf.listedessin.get(i).originalpicture != null) {
                    if (!mysurf.listedessin.get(i).originalpicture.isRecycled()) {
                        mysurf.listedessin.get(i).originalpicture.recycle();
                    }
                }
            }
            mysurf.listedessin.clear();
            e.printStackTrace();
            llog.d(TAG, "Exception reading " + onchargefichier + "." + extens);
            model.message("Exception reading " + onchargefichier + ".png");
        }
        model.message();
    }

    void deleteRecursive(File fileOrDirectory) {
    /*if (fileOrDirectory.isDirectory()) {
      for (File child : fileOrDirectory.listFiles()) {
        deleteRecursive(child);
      }
    }
    fileOrDirectory.delete();*/
    }
}






























