package la.daube.photochiotte;

import android.graphics.Bitmap;
import android.view.Surface;

import java.util.concurrent.locks.ReentrantLock;

public class Libextractor {
    private final static String TAG = "YYYlex";
    static {
        System.loadLibrary("render");
    }

    public Libextractor(){
    }

    private final ReentrantLock lock = new ReentrantLock();
    public Bitmap decodergb(String address, byte[] buffer, int bufferl){
      Bitmap bitmap = null;
      lock.lock();
      int rc = getRgb(address, buffer, bufferl);
      if (rc < 0) {
          llog.d(TAG, "error decodergb " + address);
      } else {
        int width = Libextractor.getwidth();
        int height = Libextractor.getheight();
        int stride = Libextractor.getstride();
        int size = height * stride;
        if (size > 0) {
          int intstride = stride / 4;
          int[] arr = Libextractor.getintarray();
          /*llog.d(TAG, "Libextractor.getrgb " + address + " " + width + " " + height + " "
                  + stride + " buffer alloc bytes " + size + " " + intstride + " "
                  + String.format("%08x %08x", arr[0], arr[1])
          );*/
          bitmap = Bitmap.createBitmap(arr, 0, intstride, width, height, Bitmap.Config.ARGB_8888);
        }
      }
      lock.unlock();
      return bitmap;
    }
    public Bitmap filterrgb(String address, byte[] buffer, int bufferl, String filter){
      Bitmap bitmap = null;
      lock.lock();
      int rc = filterRgb(address, buffer, bufferl, filter);
      if (rc < 0) {
          llog.d(TAG, "error filterrgb " + address + " " + filter);
      } else {
        int width = Libextractor.getwidth();
        int height = Libextractor.getheight();
        int stride = Libextractor.getstride();
        int size = height * stride;
        if (size > 0) {
          int intstride = stride / 4;
          int[] arr = Libextractor.getintarray();
          bitmap = Bitmap.createBitmap(arr, 0, intstride, width, height, Bitmap.Config.ARGB_8888);
        }
      }
      lock.unlock();
      return bitmap;
    }
    public Bitmap blurrgb(String address, int newwidth, int newheight) {
      Bitmap bitmap = null;
      lock.lock();
      int rc = blurRgb(address, newwidth, newheight);
      if (rc < 0) {
          llog.d(TAG, "error blurrgb " + address + " " + newwidth + "x" + newheight);
      } else {
        int width = Libextractor.getwidth();
        int height = Libextractor.getheight();
        int stride = Libextractor.getstride();
        int size = height * stride;
        if (size > 0) {
          int intstride = stride / 4;
          int[] arr = Libextractor.getintarray();
          bitmap = Bitmap.createBitmap(arr, 0, intstride, width, height, Bitmap.Config.ARGB_8888);
        }
      }
      lock.unlock();
      return bitmap;
    }
    public int renderrgb(String address, String filter, int w, int h, float x, float y, float scale,
                          boolean OptionMenuShown, boolean clickquicknav, float clicktohandlex, float clicktohandley
    ){
        lock.lock();
        int rc;
        long ti = System.currentTimeMillis();
        rc = renderRgb(address, w, h, x, y, scale,
                          OptionMenuShown, clickquicknav, clicktohandlex, clicktohandley);
        long tf = System.currentTimeMillis();
        if (rc != 0)
            llog.d(TAG, rc + "=rc : renderNDK " + (tf - ti));
        lock.unlock();
        return rc;
    }

    public static int extract(String video, String destname, int mwidth, int mheight, boolean isapicture, String additionalmetadata) {
      return run(video, destname, mwidth, mheight, isapicture, Gallery.maxpicturecount, additionalmetadata);
    }
  private static int getwidth() {
        return getWidth();
    }
  private static int getheight() {
        return getHeight();
    }
  private static int getstride() {
        return getStride();
    }
  private static int[] getintarray() {
        return getIntarray();
    }
  private static int getRgb(String fname, byte[] buffer, int bufferl) {
        return getRGB(fname, buffer, bufferl);
    }
  private static int renderRgb(String address, int w, int h, float x, float y, float scale,
                               boolean OptionMenuShown, boolean clickquicknav, float clicktohandlex, float clicktohandley) {
        return renderRGB(address, w, h, x, y, scale,
            OptionMenuShown, clickquicknav, clicktohandlex, clicktohandley);
    }
  private static int filterRgb(String fname, byte[] buffer, int bufferl, String filter) {
        return filterRGB(fname, buffer, bufferl, filter);
    }
  private static int blurRgb(String fname, int newwidth, int newheight) {
        return blurRGB(fname, newwidth, newheight);
    }

  private static native int run(String fname, String destname, int width, int height, boolean isapicture, long maxpicturecount, String additionalmetadata);

  private static native int getWidth();
  private static native int getHeight();
  private static native int getStride();
  private static native int[] getIntarray();
  private static native int getRGB(String fname, byte[] buffer, int bufferl);
  private static native int filterRGB(String fname, byte[] buffer, int bufferl, String filter);
  private static native int blurRGB(String fname, int newwidth, int newheight);
  public static native int attachSurface(Surface surface);
  public static native int detachSurface();
  public static native int resizeSurface();
  private static native int renderRGB(String address, int w, int h, float x, float y, float scale,
                                      boolean OptionMenuShown, boolean clickquicknav, float clicktohandlex, float clicktohandley);

}
