package la.daube.photochiotte;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.InputType;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class IntentSearch {
  private final static String TAG = "YYYis";

  public IntentSearch(Context context, Intent intent, Gallery model,
                      RelativeLayout mainlayout, EditText input, Button inputvalidate
  ){
    model.deactivateactivitykeydown = true;
    final int id = intent.getIntExtra("id", -1);
    final int ordnerIndex = intent.getIntExtra("ordnerIndex", 0);
    final int mediaIndex = intent.getIntExtra("mediaIndex", 0);
    final int searchstore = intent.getIntExtra("searchstore", -1);
    final int type = intent.getIntExtra("type", 0);

    final String store;
    if (type == 0)
      store = "searchstore";
    else
      store = "searchstoremusic"; // 1

    input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_WEB_EDIT_TEXT);
    input.setX(0);
    input.setY(100);
    input.setBackgroundColor(Gallery.CouleurTresSombre);
    if (searchstore >= 0)
      input.setText(model.preferences.getString(store + searchstore, ""));
    else
      input.setHint("regular expressions, case insensitive (e.g. this.*named == ThisFolderIsNamed)");
    input.setHintTextColor(Gallery.CouleurClaire);
    input.setTextColor(Gallery.CouleurTresClaire);
    input.setFocusableInTouchMode(true);
    input.setImeOptions(EditorInfo.IME_ACTION_DONE);

    //int buttonwidth = (int) (model.bigScreenWidth * 0.075f);

    mainlayout.addView(input);
    ViewGroup.LayoutParams parms = input.getLayoutParams();
    parms.width = model.bigScreenWidth;
    input.setLayoutParams(parms);

    //inputvalidate.setX(model.bigScreenWidth - buttonwidth);
    //inputvalidate.setY(0);
    /*ViewGroup.LayoutParams parms2 = inputvalidate.getLayoutParams();
    parms2.width = buttonwidth;
    inputvalidate.setLayoutParams(parms2);*/

    mainlayout.requestLayout();

    model.message(  "regular expressions, case insensitive"
            + "\n.    any character"
            + "\n.*   any character as long as possible"
            + "\n.*?  any character as short as possible"
            + "\nfold.*name == _This_ Folder Is Named,..ordner..."
        , 0, 100, "left"
    );
  
    input.setOnFocusChangeListener(new View.OnFocusChangeListener() {
      @Override
      public void onFocusChange(View view, boolean focused) {
        InputMethodManager keyboard = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
        if (focused)
          keyboard.showSoftInput(input, 0);
        else
          keyboard.hideSoftInputFromWindow(input.getWindowToken(), 0);
      }
    });

    //final SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(context);

    input.setOnEditorActionListener(new EditText.OnEditorActionListener() {
      @Override
      public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        if (actionId == EditorInfo.IME_ACTION_DONE || actionId == EditorInfo.IME_ACTION_UNSPECIFIED) {
          llog.d(TAG, "actionId " + actionId);
          String searchthis = input.getText().toString();
          if (searchthis.length() > 0) {
            if (searchstore < 0) {
              int l = model.preferences.getInt(store + "l", 0);
              SharedPreferences.Editor editor = model.preferences.edit();
              if (l > 0) {
                for (int i = l; i > 0; i--) {
                  if (i < Gallery.searchstoremax)
                    editor.putString(store + i, model.preferences.getString(store + (i - 1), "null"));
                }
                for (int i = Gallery.searchstoremax; i < l; i++)
                  editor.remove(store + i);
              }
              editor.putString(store + "0", searchthis);
              if (l < Gallery.searchstoremax)
                editor.putInt(store + "l", l + 1);
              editor.apply();
            } else {
              model.preferences.edit().putString(store + searchstore, searchthis).apply();
            }
            if (type == 0) {
              if (model.surf.size() > id && id >= 0) {
                model.searchthis = searchthis;
              }
              try {
                model.commandethreaddatabase.put(new String[]{"search", searchthis, String.valueOf(id), String.valueOf(ordnerIndex), String.valueOf(mediaIndex)});
              } catch (InterruptedException e) {
                e.printStackTrace();
              }
            } else {
              if (model.surf.size() > id && id >= 0) {
                if (Gallery.backgroundService != null) {
                  //model.musiclastsearch = searchthis;
                  //model.preferences.edit().putString("musiclastsearch", searchthis).apply();
                  if (    (model.searchMusicAskedFromWidget && !model.musicenqueue) // else wait for the click if picked
                          || !model.searchMusicAskedFromWidget                      // cannot click to play anyways
                  )
                    Gallery.backgroundService.musicsearch(searchthis);
                  if (model.searchMusicAskedFromWidget) { // if the music collection is shown jump to the same next music
                    model.searchthis = searchthis;
                    try {
                      model.commandethreaddatabase.put(new String[]{"search", searchthis, String.valueOf(0), String.valueOf(ordnerIndex), String.valueOf(mediaIndex)});
                    } catch (InterruptedException e) {
                      e.printStackTrace();
                    }
                  }

                }
              }
            }
          } else if (searchstore >= 0) {
            int l = model.preferences.getInt(store + "l", 0);
            SharedPreferences.Editor editor = model.preferences.edit();
            for (int i = 0; i < l - 1; i++) {
              if (i >= searchstore)
                editor.putString(store + i, model.preferences.getString(store + (i + 1), "null"));
            }
            editor.putInt(store + "l", l - 1);
            editor.remove(store + (l - 1));
            editor.apply();
          }
          input.clearFocus();
          mainlayout.removeView(input);
          mainlayout.requestLayout();
          model.deactivateactivitykeydown = false;
          return true;
        } else {
          llog.d(TAG, "unused actionId " + actionId);
        }
        return false;
      }
    });
    
    input.requestFocus();
  }
}


















