
enum cachestatus {
  cache_empty,
  cache_ready_to_load,
  cache_is_loading,
  cache_is_in_cache
};
struct BigCache {
  int status;
  char *filename;
  AVFrame *input_frame;
  AVFrame *output_frame;
  int fw, srcx, srcw, fh, srcy, srch;
};
struct BigCache bigcache[2];
int rescaleAlgorithm = SWS_FAST_BILINEAR;

int myMenuSettings = 100;


static int freebigcache() {
  if (bigcache[0].status != cache_empty)
    bigcache[0].status = cache_empty;
  if (bigcache[0].filename != NULL) {
    free((char *) bigcache[0].filename);
    bigcache[0].filename = NULL;
  }
  if (bigcache[0].input_frame != NULL) {
    av_frame_unref(bigcache[0].input_frame);
    av_frame_free(&bigcache[0].input_frame);
    bigcache[0].input_frame = NULL;
  }
  if (bigcache[0].output_frame != NULL) {
    av_frame_unref(bigcache[0].output_frame);
    av_frame_free(&bigcache[0].output_frame);
    bigcache[0].output_frame = NULL;
  }
  bigcache[0].fw = 0;
  bigcache[0].srcx = 0;
  bigcache[0].srcw = 0;
  bigcache[0].fh = 0;
  bigcache[0].srcy = 0;
  bigcache[0].srch = 0;
  return 0;
}

static int render_rgb2(int fw, int srcx, int srcw, int fh, int srcy, int srch) {
  bigcache[0].status = cache_is_loading;
  bigcache[0].fw = fw;
  bigcache[0].srcx = srcx;
  bigcache[0].srcw = srcw;
  bigcache[0].fh = fh;
  bigcache[0].srcy = srcy;
  bigcache[0].srch = srch;
  struct SwsContext *sws_c;
  int ret = -1;

  if (bigcache[0].input_frame == NULL) { ALOGV("Error av_frame_alloc input_frame %d\n", ret);
    bigcache[0].status = cache_empty;
    return ret;
  }
  if (bigcache[0].output_frame != NULL) {
    av_frame_unref(bigcache[0].output_frame);
    av_frame_free(&bigcache[0].output_frame);
    bigcache[0].output_frame = NULL;
  }
  bigcache[0].output_frame = av_frame_alloc();
  if (bigcache[0].output_frame == NULL) { ALOGV("Error av_frame_alloc %d\n", ret);
    bigcache[0].status = cache_empty;
    return ret;
  }
  // downscaling SWS_AREA
  // upscaline SWS_BICUBIC>SWS_BILINEAR
  // AV_PIX_FMT_RGB24
  sws_c = sws_getContext(srcw, srch,
                         AV_PIX_FMT_RGBA,
                         fw, fh,
                         AV_PIX_FMT_RGBA, rescaleAlgorithm, NULL, NULL, NULL);
  if (sws_c == NULL) { ALOGV("Error sws_getContext %d\n", ret);
    bigcache[0].status = cache_empty;
    av_frame_unref(bigcache[0].output_frame);
    av_frame_free(&bigcache[0].output_frame);
    return ret;
  }
  sws_c->src_x = srcx * 4;
  sws_c->threads = 3;
  sws_c->dither = SWS_DITHER_AUTO;

  ret = av_image_alloc(bigcache[0].output_frame->data, bigcache[0].output_frame->linesize,
                       fw, fh, AV_PIX_FMT_RGBA, 1);
  if (ret < 0) { ALOGV("Error av_image_alloc %d\n", ret);
    bigcache[0].status = cache_empty;
    sws_freeContext(sws_c);
    av_frame_unref(bigcache[0].output_frame);
    av_frame_free(&bigcache[0].output_frame);
    return ret;
  }

  bigcache[0].output_frame->width = fw;
  bigcache[0].output_frame->height = fh;
  bigcache[0].output_frame->format = AV_PIX_FMT_RGBA;
  uint8_t *srcdata[1] = { (uint8_t *) bigcache[0].input_frame->data[0] + bigcache[0].input_frame->linesize[0] * srcy };
  ret = sws_scale(sws_c, srcdata, bigcache[0].input_frame->linesize,
                  0, srch,
                  bigcache[0].output_frame->data, bigcache[0].output_frame->linesize);
  if (ret < 0) { ALOGV("Error sws_scale %d\n", ret);
    bigcache[0].status = cache_empty;
    sws_freeContext(sws_c);
    av_frame_unref(bigcache[0].output_frame);
    av_frame_free(&bigcache[0].output_frame);
    return ret;
  }

  /*ALOGV("in w %d %d h %d   src y %d h %d   out w %d %d h %d    %d",
        bigcache[0].input_frame->width, bigcache[0].input_frame->linesize[0], bigcache[0].input_frame->height,
        srcy, srch,
        bigcache[0].output_frame->width, bigcache[0].output_frame->linesize[0], bigcache[0].output_frame->height,
        rescalingalgorithm
  );*/

  sws_freeContext(sws_c);
  bigcache[0].status = cache_is_in_cache;
  return ret;
}

static int render_rgb(AVCodecContext  *full_size_cover_codec_context, AVFrame *input_frame,
                      int thumb_width, int thumb_height) {
    bigcache[0].status = cache_is_loading;
    bigcache[0].fw = 0;
    bigcache[0].srcx = 0;
    bigcache[0].srcw = 0;
    bigcache[0].fh = 0;
    bigcache[0].srcy = 0;
    bigcache[0].srch = 0;
    struct SwsContext *sws_c;
    int ret = -1;

    bigcache[0].input_frame = av_frame_alloc();
    if (bigcache[0].input_frame == NULL) { ALOGV("Error av_frame_alloc %d\n", ret);
        bigcache[0].status = cache_empty;
        return ret;
    }
    if (!thumb_width)  thumb_width  = input_frame->width;
    if (!thumb_height) thumb_height = input_frame->height;
    sws_c = sws_getContext(input_frame->width, input_frame->height, full_size_cover_codec_context->pix_fmt,
                           thumb_width, thumb_height, AV_PIX_FMT_RGBA, SWS_BICUBIC | SWS_FULL_CHR_H_INT | SWS_ACCURATE_RND, NULL, NULL, NULL);
    if (sws_c == NULL) { ALOGV("Error sws_getContext %d\n", ret);
        bigcache[0].status = cache_empty;
        av_frame_unref(bigcache[0].input_frame);
        av_frame_free(&bigcache[0].input_frame);
        return ret;
    }

    ret = av_image_alloc(bigcache[0].input_frame->data, bigcache[0].input_frame->linesize,
                         thumb_width, thumb_height, AV_PIX_FMT_RGBA, 32);
    if (ret < 0) { ALOGV("Error av_image_alloc %d\n", ret);
        bigcache[0].status = cache_empty;
        sws_freeContext(sws_c);
        av_frame_unref(bigcache[0].input_frame);
        av_frame_free(&bigcache[0].input_frame);
        return ret;
    }

    bigcache[0].input_frame->width = thumb_width;
    bigcache[0].input_frame->height = thumb_height;
    bigcache[0].input_frame->format = AV_PIX_FMT_RGBA;
    ret = sws_scale(sws_c, (const uint8_t * const *)&input_frame->data,
                    input_frame->linesize, 0, input_frame->height,
                    bigcache[0].input_frame->data, bigcache[0].input_frame->linesize);
    if (ret < 0) { ALOGV("Error sws_scale %d\n", ret);
        bigcache[0].status = cache_empty;
        sws_freeContext(sws_c);
        av_frame_unref(bigcache[0].input_frame);
        av_frame_free(&bigcache[0].input_frame);
        return ret;
    }

    sws_freeContext(sws_c);
    bigcache[0].status = cache_is_in_cache;
    return ret;
}


static int putbigincacheifneeded(char *mediaddress, int xi, int yi, int w, int h, float s,
                                 bool *drawbigpic, int *iw, int *ih, int *fxi, int *fxf, int *fyi) {
  int rc = 0;
  int mediaddressl = strlen(mediaddress) + 1;
  if (bigcache[0].filename == NULL) {
    bigcache[0].status = cache_empty;
    bigcache[0].filename = (char *) malloc(sizeof(char) * mediaddressl);
    memcpy(bigcache[0].filename, mediaddress, sizeof(char) * mediaddressl);
    ALOGV("new filename NULL %s", bigcache[0].filename);
  } else if (strcmp(bigcache[0].filename, mediaddress) != 0) {
    if (bigcache[0].status == cache_is_in_cache) {
      bigcache[0].status = cache_empty;
      free( (char *) bigcache[0].filename);
      bigcache[0].filename = (char *) malloc(sizeof(char) * mediaddressl);
      memcpy(bigcache[0].filename, mediaddress, sizeof(char) * mediaddressl);
      if (bigcache[0].input_frame != NULL) {
        av_frame_unref(bigcache[0].input_frame);
        av_frame_free(&bigcache[0].input_frame);
        bigcache[0].input_frame = NULL;
      }
      if (bigcache[0].output_frame != NULL) {
        ALOGV("new filename != null %s", bigcache[0].filename);
        av_frame_unref(bigcache[0].output_frame);
        av_frame_free(&bigcache[0].output_frame);
        bigcache[0].output_frame = NULL;
      } else {
        ALOGV("new filename == null %s", bigcache[0].filename);
      }
    }
  }
  if (bigcache[0].status == cache_empty) {
    ALOGV("extract_video %s", bigcache[0].filename);
    bigcache[0].status = cache_ready_to_load;
    int returncode = extract_video(mediaddress, NULL, 0, NULL, -1, -1, 1, 1, 100, 2, NULL, false, NULL);
  }
  if (bigcache[0].status != cache_is_in_cache) {
    ALOGV("bigcache[0].status != cache_is_in_cache %s", bigcache[0].filename);
    return -1;
  } else if (bigcache[0].input_frame == NULL) {
    ALOGV("bigcache[0].input_frame == NULL %s", bigcache[0].filename);
    return -1;
  }
  *iw = bigcache[0].input_frame->width;
  *ih = bigcache[0].input_frame->height;
  int siw = (int) round((float) *iw * s); // bigcache[0].output_frame->width;
  int sih = (int) round((float) *ih * s); // bigcache[0].output_frame->height;
  *fxi = 0;
  *fxf = 0;
  int ixi = 0;
  int ixf = 0;
  int oxi = 0;
  int oxf = 0;
  *fyi = 0;
  int fyf = 0;
  int iyi = 0;
  int iyf = 0;
  int oyi = 0;
  int oyf = 0;
  *drawbigpic = true;
  if (xi > w || xi + siw < 0 || yi > h || yi + sih < 0) {
    *drawbigpic = false;
  } else {
    if (xi < 0) {
      *fxi = 0;
      ixi = -xi;
      oxi = (int) round((float) ixi / s);
    } else {
      *fxi = xi;
      ixi = 0;
      oxi = 0;
    }
    if (xi + siw <= w) {
      *fxf = xi + siw;
      ixf = siw;
      oxf = *iw;
    } else {
      *fxf = w;
      ixf = w - xi;
      oxf = (int) round((float) ixf / s);
    }
    if (yi < 0) {
      *fyi = 0;
      iyi = -yi;
      oyi = (int) round((float) iyi / s);
    } else {
      *fyi = yi;
      iyi = 0;
      oyi = 0;
    }
    if (yi + sih <= h) {
      fyf = yi + sih;
      iyf = sih;
      oyf = *ih;
    } else {
      fyf = h;
      iyf = h - yi;
      oyf = (int) round((float) iyf / s);
    }
  }
  int fw = *fxf - *fxi;
  int srcx = oxi;
  int srcw = oxf - oxi;
  int fh = fyf - *fyi;
  int srcy = oyi;
  int srch = oyf - oyi;
  if (drawbigpic //&& s != 1.0f
      && (   bigcache[0].fw != fw
             || bigcache[0].srcx != srcx
             || bigcache[0].srcw != srcw
             || bigcache[0].fh != fh
             || bigcache[0].srcy != srcy
             || bigcache[0].srch != srch
             || rc == forcerescale
      )) {
    //if (bigcache[0].output_frame == NULL || s != bigcache[0].scale) {
    std::chrono::steady_clock::time_point begin, end;
    begin = std::chrono::steady_clock::now();
    render_rgb2(fw, srcx, srcw, fh, srcy, srch);
    end = std::chrono::steady_clock::now();
    ALOGV("render_rgb2 src x w %5d %5d src y h  %5d %5d       frame x w %5d %5d y h %5d %5d     alg %d zoom %fx %fms ",
          srcx, srcw, srcy, srch, *fxi, fw, *fyi, fh, rescaleAlgorithm, s,
          (double) (std::chrono::duration_cast<std::chrono::microseconds>(end - begin).count()) / 1000.0);
    //begin = std::chrono::steady_clock::now();
    //resizebicubic(bigcache[0].input_frame->data[0], bigcache[0].input_frame->width, bigcache[0].input_frame->height, 0, bigcache[0].output_frame->width, bigcache[0].output_frame->height, bigcache[0].output_frame->data[0]);
    //end = std::chrono::steady_clock::now();
    //ALOGV("            %f %f %f ms", s, bigcache[0].scale, (double) (std::chrono::duration_cast<std::chrono::microseconds>(end - begin).count()) / 1000.0);
    //}
    if (bigcache[0].output_frame == NULL) {
      ALOGV("bigcache[0].output_frame == NULL %s", bigcache[0].filename);
      return -1;
    }
  }
  return rc;
}
