#include "render.h"
#include "Thumb/decode.h"
#include "resize.h"
#include "renderDraw.h"

#ifdef __clang__


#elif __GNUC__

GtkWidget* mainWindow;
uint32_t* framebuffer = NULL;
GdkPixbuf* pixbuf = NULL;

char *mediaddress = NULL;

int xi = 0;
int yi = 0;
float s = 0.5f;

int w = 700;
int h = 500;

int clickx = 0;
int clicky = 0;
bool clickquicknav = false;

int frametick = 0;
uint32_t bgcolor = 0xff220000; // 0xffff0000 alpha blue green red

static bool getfile(char *directory) {
  int l = 0;
  DIR *d;
  struct dirent *dir;
  d = opendir(directory);
  while ((dir = readdir(d)) != NULL) {
    l = strlen(dir->d_name);
    if (l > 4) {
      if (dir->d_name[l-4] == (char) '.' && dir->d_name[l-3] == (char) 'j' && dir->d_name[l-2] == (char) 'p' && dir->d_name[l-1] == (char) 'g') {
        mediaddress = (char *) malloc(l + strlen(directory));
        sprintf(mediaddress, "%s%s", directory, dir->d_name);
        ALOGV("file : %s %s", dir->d_name, mediaddress);
        closedir(d);
        return true;
      }
    }
  }
  closedir(d);
  return false;
}

static gboolean on_draw_event(GtkWidget *widget, cairo_t *cr, gpointer user_data) {
  int rc = 0;
  bool OptionMenuShown = true;

  bool drawbigpic;
  int iw, ih, fxi, fxf, fyi;
  int rc2 = putbigincacheifneeded(mediaddress, xi, yi, w, h, s, &drawbigpic, &iw, &ih, &fxi, &fxf, &fyi);
  if (rc2 != 0) {
    ALOGV("error putbigincacheifneeded");
    return false;
  }

  if (bigcache[0].status == cache_is_in_cache) {

    int windowstride = w; // nativewindowbuffer.stride
    int bitmapstride = bigcache[0].output_frame->linesize[0] / 4;
    if (drawbigpic && iw > 0 && ih > 0) {
      int xlen = fxf - fxi;
      if (xlen + fxi > windowstride) {
        ALOGV("ERROR too many bytes %d %d %d %d", xlen, windowstride, fxi, fxf);
        xlen = windowstride - fxi;
      }
      //ALOGV("fx %d %d fy %d %d     ix %d %d iy %d %d    ox %d %d oy %d %d        loop y 0 -> %d     fxi %d fyi %d bufferstride %d     outf ixi %d iyi0 %d %d     len siw %d",  fxi, fxf, fyi, fyf, ixi, ixf, iyi, iyf, oxi, oxf, oyi, oyf,  bigcache[0].output_frame->height, fxi, fyi, nativewindowbuffer.stride, ixi, 0, bitmapstride, xlen);
      for (int j = 0 ; j < bigcache[0].output_frame->height ; j++) {
        memcpy((uint32_t *) framebuffer + (j + fyi) * windowstride + fxi,
               (uint32_t *) bigcache[0].output_frame->data[0] + (j + 0) * bitmapstride + 0,
               sizeof(uint32_t) * xlen);
      }
    }

    //int buffersize = (w * h) / 2;
    //for (int i = 0 ; i < buffersize ; i++)
    //  memcpy((uint32_t *) framebuffer + i, &bgcolor, sizeof(uint32_t));

    gdk_cairo_set_source_pixbuf(cr, pixbuf, 0, 0);
    cairo_paint(cr);
  }

  rc = drawmenu(OptionMenuShown, cr, clickquicknav, w, h, clickx, clicky);
  if (rc == closemenu)
    OptionMenuShown = false;

  clickquicknav = false;
  return FALSE;
}

static gboolean touched(GtkWidget *widget, GdkEvent *event, gpointer user_data) {
  double xx, yy;
  int x, y;
  GdkModifierType state;
  GdkWindow *window = gdk_event_get_window(event);
  GdkDevice *device = gdk_event_get_source_device(event);

  /*GdkInputSource is = gdk_device_get_source(device);
  if (is == GDK_SOURCE_MOUSE) {
  } else if (is == GDK_SOURCE_KEYBOARD) {
  } else {
    ALOGV("GdkInputSource unknown %d", is);
  }*/

  gdk_window_get_pointer(window, &x, &y, &state);

  GdkEventType et = gdk_event_get_event_type(event);
  if (et == GDK_KEY_PRESS) { // keyboard down repeated
  } else if (et == GDK_KEY_RELEASE) { // keyboard up
    ALOGV("key %d", ((GdkEventKey*)event)->keyval);

  } else if (et == GDK_BUTTON_PRESS) { // mouse down
    gdk_window_get_device_position_double(window, device, &xx, &yy, &state);
    ALOGV("down %f %f button %d", xx, yy, ((GdkEventButton*)event)->button);
  } else if (et == GDK_BUTTON_RELEASE) { // mouse up
    gdk_window_get_device_position_double(window, device, &xx, &yy, &state);
    ALOGV("up %f %f button %d", xx, yy, ((GdkEventButton*)event)->button);
    clickx = (int) xx;
    clicky = (int) yy;
    clickquicknav = true;
  } else if (et == GDK_MOTION_NOTIFY) { // mouse down move
    gdk_window_get_device_position_double(window, device, &xx, &yy, &state);
    if (state & GDK_BUTTON1_MASK) {
      ALOGV("move %f %f button %d", xx, yy, ((GdkEventButton*)event)->button);
    } else
      return false;

  } else {
    ALOGV("GdkEventType unknown %d", et);
  }

  gtk_widget_queue_draw(widget);
  return true;
}

/*static gboolean clicked(GtkWidget *widget, GdkEventButton *event, gpointer user_data) {
  if (event->button == 1) {
    gtk_widget_get_pointer(widget, &clickx, &clicky);
    ALOGV("clicked1 x %d y %d", clickx, clicky);
  } else if (event->button == 3) {
    gtk_widget_get_pointer(widget, &clickx, &clicky);
    ALOGV("clicked3 x %d y %d", clickx, clicky);
  } else {
    ALOGV("other click frame %d", frametick);
  }
  clickquicknav = true;
  gtk_widget_queue_draw(widget);
  return true;
}*/

/*gboolean onTimerTick(gpointer user_data) {
  frametick = (frametick+1) % 2;
  if (frametick == 0)
    bgcolor = 0xff22001f;
  else
    bgcolor = 0xff221f00;
  gtk_widget_queue_draw(mainWindow);
  return 1;
}*/

void onWindowDestroy(GtkWidget* object, gpointer user_data) {
  free(framebuffer);
  freebigcache();
  free(mediaddress);
  gtk_main_quit();
}

void configure_callback(GtkWindow *window, GdkEvent *event, gpointer data) {
  int x, y;
  x = event->configure.width;
  y = event->configure.height;
  w = x;
  h = y;
  gtk_window_set_default_size(GTK_WINDOW(mainWindow), w, h);
  ALOGV("%d %d", x, y);
}

int main(int argc, char *argv[]) {

  if (argc != 2) {
    ALOGV("render <dirname>");
    return 1;
  }
  getfile(argv[1]);



  unsigned char *buf = NULL;
  int mediaddressl = strlen(mediaddress) + 1;
  if (bigcache[0].filename == NULL) {
    bigcache[0].status = cache_empty;
    bigcache[0].filename = (char *) malloc(sizeof(char) * mediaddressl);
    memcpy(bigcache[0].filename, mediaddress, sizeof(char) * mediaddressl);
    ALOGV("new filename NULL %s", bigcache[0].filename);
  } else if (strcmp(bigcache[0].filename, mediaddress) != 0) {
    if (bigcache[0].status == cache_is_in_cache) {
      bigcache[0].status = cache_empty;
      free( (char *) bigcache[0].filename);
      bigcache[0].filename = (char *) malloc(sizeof(char) * mediaddressl);
      memcpy(bigcache[0].filename, mediaddress, sizeof(char) * mediaddressl);
      if (bigcache[0].input_frame != NULL) {
        av_frame_unref(bigcache[0].input_frame);
        av_frame_free(&bigcache[0].input_frame);
        bigcache[0].input_frame = NULL;
      }
      if (bigcache[0].output_frame != NULL) {
        ALOGV("new filename != null %s", bigcache[0].filename);
        av_frame_unref(bigcache[0].output_frame);
        av_frame_free(&bigcache[0].output_frame);
        bigcache[0].output_frame = NULL;
      } else {
        ALOGV("new filename == null %s", bigcache[0].filename);
      }
    }
  }
  if (bigcache[0].status == cache_empty) {
    ALOGV("extract_video %s", bigcache[0].filename);
    bigcache[0].status = cache_ready_to_load;
    int returncode = extract_video(mediaddress, buf, 0, NULL, -1, -1, 1, 1, 100, 2, NULL, false, NULL);
  }
  if (bigcache[0].status != cache_is_in_cache) {
    ALOGV("bigcache[0].status != cache_is_in_cache %s", bigcache[0].filename);
  } else if (bigcache[0].input_frame == NULL) {
    ALOGV("bigcache[0].input_frame == NULL %s", bigcache[0].filename);
  }




  gtk_init(&argc, &argv);
  mainWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  framebuffer = (uint32_t *) malloc(sizeof(uint32_t) * w * h);

  gtk_window_set_default_size(GTK_WINDOW(mainWindow), w, h);
  gtk_window_set_title(GTK_WINDOW(mainWindow), "Framebuffer test");

  //pixBuff = gdk_pixbuf_new(GDK_COLORSPACE_RGB, TRUE, 8, w, h);
  //pwidget = gtk_image_new_from_pixbuf(pixBuff);
  //gtk_container_add(GTK_CONTAINER(window), pwidget);
  GtkWidget *drawingArea = gtk_drawing_area_new();
  gtk_container_add(GTK_CONTAINER(mainWindow), drawingArea);

  gtk_widget_add_events(GTK_WIDGET(mainWindow), GDK_CONFIGURE);
  gtk_widget_add_events(mainWindow, GDK_BUTTON_PRESS_MASK);

  gtk_window_set_position(GTK_WINDOW(mainWindow), GTK_WIN_POS_CENTER);
  gtk_window_set_keep_above(GTK_WINDOW(mainWindow), true);
  gtk_window_set_title(GTK_WINDOW(mainWindow), "Lines");
  //gtk_window_fullscreen(GTK_WINDOW(mainWindow));

  g_signal_connect(G_OBJECT(drawingArea), "draw", G_CALLBACK(on_draw_event), NULL);

  g_signal_connect(mainWindow, "destroy", G_CALLBACK(onWindowDestroy), NULL);
  g_signal_connect(mainWindow, "configure-event", G_CALLBACK(configure_callback), NULL);

  g_signal_connect(mainWindow, "touch-event", G_CALLBACK(touched), NULL);
  g_signal_connect(mainWindow, "button-press-event", G_CALLBACK(touched), NULL);
  g_signal_connect(mainWindow, "button-release-event", G_CALLBACK(touched), NULL);
  g_signal_connect(mainWindow, "key-press-event", G_CALLBACK(touched), NULL);
  g_signal_connect(mainWindow, "key-release-event", G_CALLBACK(touched), NULL);
  g_signal_connect(mainWindow, "motion-notify-event", G_CALLBACK(touched), NULL);

  //g_timeout_add(2500, onTimerTick, NULL);

  gtk_widget_set_events (mainWindow, gtk_widget_get_events (mainWindow)
                              | GDK_BUTTON_PRESS_MASK
                              | GDK_POINTER_MOTION_MASK);

  gtk_widget_show_all(mainWindow);
  pixbuf = gdk_pixbuf_new_from_data((guchar *) framebuffer, GDK_COLORSPACE_RGB, true, 8, w, h, w*4, NULL, NULL);
  gtk_main();
  return 0;
}

#endif































































