
static int drawmenu(bool OptionMenuShown, cairo_t *cr, bool clickquicknav, int w, int h, float clicktohandlex, float clicktohandley) {
  int rc = 0;
  if (OptionMenuShown) {
    // bgra                        B         G        R        A
    cairo_text_extents_t te;
    cairo_select_font_face(cr, "Georgia", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
    cairo_set_font_size(cr, 45);
    int mx = w;
    int my = 0;
    int mw = 0;
    int mh = 100;
    char txt[256];

    if (clickquicknav && w - 100 <= clicktohandlex && clicktohandlex < w && 0 <= clicktohandley && clicktohandley < 100) {
      myMenuSettings -= mh;
      clickquicknav = false;
    }
    if (clickquicknav && w - 100 <= clicktohandlex && clicktohandlex < w && h - 100 <= clicktohandley && clicktohandley < h) {
      myMenuSettings += mh;
      clickquicknav = false;
    }
    my = myMenuSettings;

    if (my >= 0 && my < h) {
      sprintf(txt, "remove split");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx &&
          my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rc = closesplit;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "close menu");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx &&
          my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rc = closemenu;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "fast bilinear filtering");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx &&
          my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_FAST_BILINEAR;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "bilinear filtering");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_BILINEAR;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "2-tap cubic B-spline");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_BICUBIC;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "experimental");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_X;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "nearest neighbor");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_POINT;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "area averaging");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_AREA;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "bicubic luma, bilinear chroma");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_BICUBLIN;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "gaussian approximation");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_GAUSS;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "unwindowed sinc");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_SINC;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "3-tap sinc/sinc");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_LANCZOS;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    if (my >= 0 && my < h) {
      sprintf(txt, "cubic Keys spline");
      cairo_text_extents(cr, txt, &te);
      cairo_set_source_rgba(cr, 255, 0, 0, 255);
      mw = te.width;
      if (clickquicknav && mx - mw <= clicktohandlex && clicktohandlex < mx && my <= clicktohandley && clicktohandley < my + mh) {
        ALOGV("clicked %s", txt);
        rescaleAlgorithm = SWS_SPLINE;
        rc = forcerescale;
        clickquicknav = false;
      }
      cairo_rectangle(cr, mx - mw, my, mw, mh);
      cairo_fill(cr);
      cairo_move_to(cr, mx - mw - te.x_bearing, my + mh / 2 - te.height / 2 - te.y_bearing);
      cairo_set_source_rgba(cr, 0, 255, 0, 255);
      cairo_show_text(cr, txt);
      my += mh;
    }

    cairo_set_source_rgba(cr, 255, 128, 0, 255);
    cairo_rectangle(cr, w - 100, 0, 100, 100);
    cairo_stroke(cr);
    cairo_set_source_rgba(cr, 255, 128, 0, 255);
    cairo_rectangle(cr, w - 100, h - 100, 100, 100);
    cairo_stroke(cr);

  }
  return rc;
}
