#include "render.h"
#include "Thumb/decode.h"
#include "resize.h"
#include "renderDraw.h"


#ifdef __clang__

ANativeWindow* nativewindow = NULL;
ANativeWindow_Buffer nativewindowbuffer;


extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_attachSurface(JNIEnv *env, jclass thisClass, jobject javaSurface) {
  nativewindow = ANativeWindow_fromSurface(env, javaSurface);
  if (nativewindow != NULL) {
    ANativeWindow_setBuffersGeometry(nativewindow, 0, 0, WINDOW_FORMAT_RGBA_8888);
    ALOGV(" - attach surface success");
    return 0;
  }
  ALOGV(" - attach surface error");
  return -1;
}

extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_resizeSurface(JNIEnv *env, jclass thisClass) {
  if (nativewindow != NULL) {
    ANativeWindow_setBuffersGeometry(nativewindow, 0, 0, WINDOW_FORMAT_RGBA_8888);
    ALOGV(" - resize surface success");
    return 0;
  }
  ALOGV(" - resize surface error");
  return -1;
}

extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_detachSurface(JNIEnv *env, jclass thisClass) {
  if (nativewindow != NULL) {
    ANativeWindow_release(nativewindow);
    nativewindow = NULL;
    freebigcache();
    ALOGV(" - detach surface success");
    return 0;
  }
  ALOGV(" - detach surface error");
  return -1;
}

extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_renderRGB(JNIEnv *env, jclass thisClass,
             jstring jmediaaddress, jint jscreenw, jint jscreenh, jfloat jx, jfloat jy, jfloat jscale,
             jboolean jOptionMenuShown, jboolean jclickquicknav, jfloat jclicktohandlex, jfloat jclicktohandley
             ) {
  int rc = 0;
  char *mediaddress;
  unsigned char* buf = NULL;
  jboolean bo;
  bo = JNI_FALSE;
  int w = (int) jscreenw;
  int h = (int) jscreenh;
  int xi = (int) jx;
  int yi = (int) jy;
  float s = (float) jscale;
  bool OptionMenuShown = (bool) jOptionMenuShown;
  bool clickquicknav = (bool) jclickquicknav;
  float clicktohandlex = (float) jclicktohandlex;
  float clicktohandley = (float) jclicktohandley;
  cairo_t *cr;
  cairo_surface_t *cs;
  cairo_font_face_t *ct;
  mediaddress = (char *) env->GetStringUTFChars(jmediaaddress, &bo);
  cs = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, w, h);
  // cairo_image_surface_create_for_data
  cr = cairo_create(cs);
  rc = drawmenu(OptionMenuShown, cr, clickquicknav, w, h, clicktohandlex, clicktohandley);
  // flush to ensure all writing to the image was done
  cairo_surface_flush(cs);
  // modify the image
  unsigned char *data = cairo_image_surface_get_data(cs);
  int width, height, stride;
  width = cairo_image_surface_get_width(cs);
  height = cairo_image_surface_get_height(cs);
  stride = cairo_image_surface_get_stride(cs);
  //ALOGV("cairo %d %d %d", width, height, stride); 200 200 800
  //modify_image_data (data, width, height, stride);
  // mark the image dirty so Cairo clears its caches.
  //cairo_surface_mark_dirty (surface);
  if (data == NULL)
    ALOGV("null");
  ARect rect;
  rect.top = 0;
  rect.left = 0;
  rect.bottom = h;
  rect.right = w;
  bool drawbigpic;
  int iw, ih, fxi, fxf, fyi;
  int rc2 = putbigincacheifneeded(mediaddress, xi, yi, w, h, s, &drawbigpic, &iw, &ih, &fxi, &fxf, &fyi);
  if (rc2 != 0) {
    ALOGV("error putbigincacheifneeded");
    if (mediaddress != NULL)
      env->ReleaseStringUTFChars(jmediaaddress, mediaddress);
    return 0;
  }
  if (nativewindow != NULL) {
    if (ANativeWindow_lock(nativewindow, &nativewindowbuffer, &rect) == 0) {
      uint32_t buffersize = nativewindowbuffer.stride * nativewindowbuffer.height;
      //ALOGV("rect %d %d %d %d bitmap %d %d %d buffer %d %d %d : x  %d %d  y  %d %d", rect.top, rect.left, rect.bottom, rect.right, bitmapstride4, bitmapwidth, bitmapheight,  buffer.stride, buffer.width, buffer.height, ixi, ixf, iyi, iyf);
      uint32_t bgcolor = 0xff220000; // 0xffff0000 alpha blue green red
      for (int i = 0 ; i < buffersize ; i++)
         memcpy((uint32_t *) nativewindowbuffer.bits + i, &bgcolor, sizeof(uint32_t));
      //for (int i = 0 ; i < size ; i++)
      //    memcpy((uint32_t *) buffer.bits + i * buffer.stride, (uint32_t *) data + i * size, sizeof(uint32_t) * size);
      int bitmapstride = bigcache[0].output_frame->linesize[0] / 4;
      if (drawbigpic && iw > 0 && ih > 0) {
        int xlen = fxf - fxi;
        if (xlen + fxi > nativewindowbuffer.stride) {
          ALOGV("ERROR too many bytes %d %d %d %d", xlen, nativewindowbuffer.stride, fxi, fxf);
          xlen = nativewindowbuffer.stride - fxi;
        }
        //ALOGV("fx %d %d fy %d %d     ix %d %d iy %d %d    ox %d %d oy %d %d        loop y 0 -> %d     fxi %d fyi %d bufferstride %d     outf ixi %d iyi0 %d %d     len siw %d",  fxi, fxf, fyi, fyf, ixi, ixf, iyi, iyf, oxi, oxf, oyi, oyf,  bigcache[0].output_frame->height, fxi, fyi, nativewindowbuffer.stride, ixi, 0, bitmapstride, xlen);
        for (int j = 0 ; j < bigcache[0].output_frame->height ; j++) {
          memcpy((uint32_t *) nativewindowbuffer.bits + (j + fyi) * nativewindowbuffer.stride + fxi,
                  (uint32_t *) bigcache[0].output_frame->data[0] + (j + 0) * bitmapstride + 0,
                  sizeof(uint32_t) * xlen);
        }
      }
      uint32_t *c0, *c1;
      for (int y = 0 ; y < h ; y++) {
          for (int x = 0 ; x < w ; x++) {
              c0 = (uint32_t *) data + y * w + x;
              if (*c0 != 0) {
                  // r0over1 = a0 * r0 + (1 - a0) * r1;
                  memcpy((uint32_t *) nativewindowbuffer.bits + y * nativewindowbuffer.stride + x,
                         c0,
                         sizeof(uint32_t));
              }
          }
      }
      ANativeWindow_unlockAndPost(nativewindow);
    } else {
      ALOGV("no lock");
    }
  } else {
    ALOGV("no window");
  }
  // mark as dirty to refresh surface
  cairo_surface_mark_dirty(cs);
  cairo_surface_finish(cs);
  cairo_surface_destroy(cs);
  if (mediaddress != NULL)
    env->ReleaseStringUTFChars(jmediaaddress, mediaddress);
  return rc;
}

extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_getWidth(JNIEnv *env, jclass thisClass) {
  return bitmapwidth;
}
extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_getHeight(JNIEnv *env, jclass thisClass) {
  return bitmapheight;
}
extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_getStride(JNIEnv *env, jclass thisClass) {
  return bitmapstride4;
}
extern "C" JNIEXPORT jintArray JNICALL Java_la_daube_photochiotte_Libextractor_getIntarray(JNIEnv *env, jclass thisClass) {
  int size = (bitmapstride4 * bitmapheight) / 4;
  jintArray intJavaArray = NULL;
  if (size > 0) {
    intJavaArray = env->NewIntArray(size);
    if (intJavaArray != NULL)
      env->SetIntArrayRegion(intJavaArray, 0, size, bitmapint);
    bitmapwidth = 0;
    bitmapheight = 0;
    bitmapstride4 = 0;
    free((int *) bitmapint);
  }
  bitmapint = NULL;
  return intJavaArray;
}

extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_filterRGB(JNIEnv *env, jclass thisClass, jstring jpictureaddress, jbyteArray jbuffer, jint bufferl, jstring jfilterstring) {
  char *pictureaddress = NULL;
  char *filterstring = NULL;
  jboolean bo;
  bo = JNI_FALSE;
  unsigned char* buf = NULL;
  if (bufferl > 0) {
    buf = new unsigned char[bufferl];
    env->GetByteArrayRegion(jbuffer, 0, bufferl, reinterpret_cast<jbyte *>(buf));
  } else if (jpictureaddress != NULL) {
    pictureaddress = (char *) env->GetStringUTFChars(jpictureaddress, &bo);
  }
  if (jfilterstring != NULL)
    filterstring = (char *) env->GetStringUTFChars(jfilterstring, &bo);

  int returncode = extract_video(pictureaddress, buf, bufferl, NULL, -1, -1, 1, 1, 100, 0, filterstring, false, NULL);

  if (bufferl > 0) {
    env->ReleaseByteArrayElements(jbuffer, reinterpret_cast<jbyte *>(buf), JNI_ABORT);
  } else if (jpictureaddress != NULL) {
    env->ReleaseStringUTFChars(jpictureaddress, pictureaddress);
  }
  if (filterstring != NULL)
    env->ReleaseStringUTFChars(jfilterstring, filterstring);

  return returncode;
}
extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_blurRGB(JNIEnv *env, jclass thisClass, jstring jpictureaddress, jint w, jint h) {
  char *pictureaddress = NULL;
  jboolean bo;
  bo = JNI_FALSE;

  if (jpictureaddress != NULL)
    pictureaddress = (char *) env->GetStringUTFChars(jpictureaddress, &bo);

  int returncode = extract_video(pictureaddress, NULL, 0, NULL, w, h, 1, 1, 100, 0, NULL, true, NULL);

  if (pictureaddress != NULL)
    env->ReleaseStringUTFChars(jpictureaddress, pictureaddress);

  return returncode;
}
extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_run(JNIEnv *env, jclass thisClass, jstring jmediaaddress, jstring jdestinationaddress, jint w, jint h, jboolean jisapicture, jlong maxpicturecount, jstring jadditionalmetadata) {
  const char *mediaddress;
  const char *destinationaddress;
  const char *additionalmetadata = NULL;
  jboolean bo;
  bo = JNI_FALSE;

  mediaddress = (const char *) env->GetStringUTFChars(jmediaaddress, &bo);
  destinationaddress = (const char *) env->GetStringUTFChars(jdestinationaddress, &bo);
  if (jadditionalmetadata != NULL)
    additionalmetadata = (char *) env->GetStringUTFChars(jadditionalmetadata, &bo);

  int isapicture = -1;
  if (jisapicture)
    isapicture = 1;
  else
    isapicture = 0;

  int returncode = extract_video(mediaddress, NULL, 0, destinationaddress, w, h, isapicture, maxpicturecount, 100, 0, NULL, false, additionalmetadata);

  if (additionalmetadata != NULL)
    env->ReleaseStringUTFChars(jadditionalmetadata, additionalmetadata);
  if (mediaddress != NULL)
    env->ReleaseStringUTFChars(jmediaaddress, mediaddress);
  if (destinationaddress != NULL)
    env->ReleaseStringUTFChars(jdestinationaddress, destinationaddress);

  return returncode;
}
extern "C" JNIEXPORT jint JNICALL Java_la_daube_photochiotte_Libextractor_getRGB(JNIEnv *env, jclass thisClass, jstring jpictureaddress, jbyteArray jbuffer, jint bufferl) {
  char *pictureaddress = NULL;
  jboolean bo;
  bo = JNI_FALSE;
  unsigned char* buf = NULL;
  if (bufferl > 0) {
    buf = new unsigned char[bufferl];
    env->GetByteArrayRegion(jbuffer, 0, bufferl, reinterpret_cast<jbyte *>(buf));
  } else if (jpictureaddress != NULL) {
    pictureaddress = (char *) env->GetStringUTFChars(jpictureaddress, &bo);
  }

  int returncode = extract_video(pictureaddress, buf, bufferl, NULL, -1, -1, 1, 1, 100, 1, NULL, false, NULL);

  if (bufferl > 0) {
    env->ReleaseByteArrayElements(jbuffer, reinterpret_cast<jbyte *>(buf), JNI_ABORT);
  } else if (jpictureaddress != NULL) {
    env->ReleaseStringUTFChars(jpictureaddress, pictureaddress);
  }

  return returncode;
}

#elif __GNUC__


#endif






















