# thumbnail and filmstrip generator for Linux

This is the thumbnail and video filmstrip generator used by PhotoChiotte.
It also works as a standalone program on Linux, using ffmpeg's shared libraries.

Optional but recommended : it's a good idea to generate thumbnails on the server side since PhotoChiotte won't store anything on your device.
The "apache online" method tries to grab the `folder/subfolder/file.ext.thmb_0` thumbnail that is expected to correspond to the `folder/subfolder/file.ext` file.
If this fails it will generate a thumbnail from the big files, which makes it optional but heavier for both the device and the server.

- build the thumbnail creator (based on GNU libextractor)
```
sudo apt-get install libavdevice-dev libavfilter-dev libswscale-dev libavformat-dev libavcodec-dev libavutil-dev libswresample-dev
git clone https://codeberg.org/LaDaube/PhotoChiotte/Thumb.git
cd Thumb
cmake --fresh .
make clean && make
```
- create thumbnails

`./thumb`   `source file`   `destination thumbnails`   `width`   `height`   
`maximum number of filmstrip pictures (for videos)`   
`maximum percentage of the video`
```
while read f
do
  if [ ! -f "${f}.thmb_0" ]
  then
    nice -n 19 ./thumb "${f}" "${f}.thmb" 256 256 15 100
  fi
done < <(find /mnt/usb/ -type f -size +40k | grep -vP '\.thmb[._]\d+$')
```

Notes :

`printName=`, `printDetails=`, `printFooter=`, `playInSequence=true`, `playStartAtPosition=`, `subtitleAddress=`, `subtitleAddressEncode=` can be appended
in the `.thmb_0` file to add comments or more information to medias. For instance `echo "printName=Mont Blanc versant sud" >> DSC01234.JPG.thmb_0`
will show _Mont Blanc versant sud_ for the filename when the picture `DSC01234.JPG` is viewed in PhotoChiotte.

Updates :

- v1.45 02/11/2023 : full decode if fast seeking methods fail

- v1.46 09/11/2023 : metadata : handle rotation, grab creation_time

- v1.50 14/02/2024 : pictures can have comments and more information, just like other media types.
  The old `*.thmb$` format is deprecated. Please re-create the thumbnails on your server
  to automatically move on to the new format :
```
while read f
do
  nice -n 19 ./thumb "${f}" "${f}.thmb" 256 256 15 100
done < <(find /mnt/usb/ -type f -size +40k | grep -vP '\.thmb([._]\d+)?$')
```












