/*!
 Stencil Compiler v2.18.0 | MIT Licensed | https://stenciljs.com
 */
(function(exports) {
'use strict';

if (typeof globalThis === 'undefined') {
  if (typeof self !== 'undefined') {
  self.globalThis = self;
  } else if (typeof window !== 'undefined') {
  window.globalThis = window;
  } else if (typeof global !== 'undefined') {
  global.globalThis = global;
  }
}

const Buffer = globalThis.Buffer || {};
const process = globalThis.process || {};
if (!process.argv) {
  process.argv = [''];
}
let __cwd = '/';
if (!process.cwd) {
  process.cwd = () => __cwd;
}
if (!process.chdir) {
  process.chdir = (v) => __cwd = v;
}
if (!process.nextTick) {
  const resolved = Promise.resolve();
  process.nextTick = (cb) => resolved.then(cb);
}
if (!process.platform) {
  process.platform = 'stencil';
}
if (!process.version) {
  process.version = 'v12.0.0';
}
process.browser = !!globalThis.location;


// 'path' module extracted from Node.js v8.11.1 (only the posix part)

function assertPath(path) {
  if (typeof path !== 'string') {
  throw new TypeError('Path must be a string. Received ' + JSON.stringify(path));
  }
}

// Resolves . and .. elements in a path with directory names
function normalizeStringPosix(path, allowAboveRoot) {
  var res = '';
  var lastSegmentLength = 0;
  var lastSlash = -1;
  var dots = 0;
  var code;
  for (var i = 0; i <= path.length; ++i) {
  if (i < path.length)
    code = path.charCodeAt(i);
  else if (code === 47 /*/*/)
    break;
  else
    code = 47 /*/*/;
  if (code === 47 /*/*/) {
    if (lastSlash === i - 1 || dots === 1) ; else if (lastSlash !== i - 1 && dots === 2) {
    if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 /*.*/ || res.charCodeAt(res.length - 2) !== 46 /*.*/) {
      if (res.length > 2) {
      var lastSlashIndex = res.lastIndexOf('/');
      if (lastSlashIndex !== res.length - 1) {
        if (lastSlashIndex === -1) {
        res = '';
        lastSegmentLength = 0;
        } else {
        res = res.slice(0, lastSlashIndex);
        lastSegmentLength = res.length - 1 - res.lastIndexOf('/');
        }
        lastSlash = i;
        dots = 0;
        continue;
      }
      } else if (res.length === 2 || res.length === 1) {
      res = '';
      lastSegmentLength = 0;
      lastSlash = i;
      dots = 0;
      continue;
      }
    }
    if (allowAboveRoot) {
      if (res.length > 0)
      res += '/..';
      else
      res = '..';
      lastSegmentLength = 2;
    }
    } else {
    if (res.length > 0)
      res += '/' + path.slice(lastSlash + 1, i);
    else
      res = path.slice(lastSlash + 1, i);
    lastSegmentLength = i - lastSlash - 1;
    }
    lastSlash = i;
    dots = 0;
  } else if (code === 46 /*.*/ && dots !== -1) {
    ++dots;
  } else {
    dots = -1;
  }
  }
  return res;
}

function _format(sep, pathObject) {
  var dir = pathObject.dir || pathObject.root;
  var base = pathObject.base || (pathObject.name || '') + (pathObject.ext || '');
  if (!dir) {
  return base;
  }
  if (dir === pathObject.root) {
  return dir + base;
  }
  return dir + sep + base;
}

var posix$2 = {
  // path.resolve([from ...], to)
  resolve: function resolve() {
  var resolvedPath = '';
  var resolvedAbsolute = false;
  var cwd;

  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    var path;
    if (i >= 0)
    path = arguments[i];
    else {
    if (cwd === undefined)
      cwd = process.cwd();
    path = cwd;
    }

    assertPath(path);

    // Skip empty entries
    if (path.length === 0) {
    continue;
    }

    resolvedPath = path + '/' + resolvedPath;
    resolvedAbsolute = path.charCodeAt(0) === 47 /*/*/;
  }

  // At this point the path should be resolved to a full absolute path, but
  // handle relative paths to be safe (might happen when process.cwd() fails)

  // Normalize the path
  resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);

  if (resolvedAbsolute) {
    if (resolvedPath.length > 0)
    return '/' + resolvedPath;
    else
    return '/';
  } else if (resolvedPath.length > 0) {
    return resolvedPath;
  } else {
    return '.';
  }
  },

  normalize: function normalize(path) {
  assertPath(path);

  if (path.length === 0) return '.';

  var isAbsolute = path.charCodeAt(0) === 47 /*/*/;
  var trailingSeparator = path.charCodeAt(path.length - 1) === 47 /*/*/;

  // Normalize the path
  path = normalizeStringPosix(path, !isAbsolute);

  if (path.length === 0 && !isAbsolute) path = '.';
  if (path.length > 0 && trailingSeparator) path += '/';

  if (isAbsolute) return '/' + path;
  return path;
  },

  isAbsolute: function isAbsolute(path) {
  assertPath(path);
  return path.length > 0 && path.charCodeAt(0) === 47 /*/*/;
  },

  join: function join() {
  if (arguments.length === 0)
    return '.';
  var joined;
  for (var i = 0; i < arguments.length; ++i) {
    var arg = arguments[i];
    assertPath(arg);
    if (arg.length > 0) {
    if (joined === undefined)
      joined = arg;
    else
      joined += '/' + arg;
    }
  }
  if (joined === undefined)
    return '.';
  return posix$2.normalize(joined);
  },

  relative: function relative(from, to) {
  assertPath(from);
  assertPath(to);

  if (from === to) return '';

  from = posix$2.resolve(from);
  to = posix$2.resolve(to);

  if (from === to) return '';

  // Trim any leading backslashes
  var fromStart = 1;
  for (; fromStart < from.length; ++fromStart) {
    if (from.charCodeAt(fromStart) !== 47 /*/*/)
    break;
  }
  var fromEnd = from.length;
  var fromLen = fromEnd - fromStart;

  // Trim any leading backslashes
  var toStart = 1;
  for (; toStart < to.length; ++toStart) {
    if (to.charCodeAt(toStart) !== 47 /*/*/)
    break;
  }
  var toEnd = to.length;
  var toLen = toEnd - toStart;

  // Compare paths to find the longest common path from root
  var length = fromLen < toLen ? fromLen : toLen;
  var lastCommonSep = -1;
  var i = 0;
  for (; i <= length; ++i) {
    if (i === length) {
    if (toLen > length) {
      if (to.charCodeAt(toStart + i) === 47 /*/*/) {
      // We get here if `from` is the exact base path for `to`.
      // For example: from='/foo/bar'; to='/foo/bar/baz'
      return to.slice(toStart + i + 1);
      } else if (i === 0) {
      // We get here if `from` is the root
      // For example: from='/'; to='/foo'
      return to.slice(toStart + i);
      }
    } else if (fromLen > length) {
      if (from.charCodeAt(fromStart + i) === 47 /*/*/) {
      // We get here if `to` is the exact base path for `from`.
      // For example: from='/foo/bar/baz'; to='/foo/bar'
      lastCommonSep = i;
      } else if (i === 0) {
      // We get here if `to` is the root.
      // For example: from='/foo'; to='/'
      lastCommonSep = 0;
      }
    }
    break;
    }
    var fromCode = from.charCodeAt(fromStart + i);
    var toCode = to.charCodeAt(toStart + i);
    if (fromCode !== toCode)
    break;
    else if (fromCode === 47 /*/*/)
    lastCommonSep = i;
  }

  var out = '';
  // Generate the relative path based on the path difference between `to`
  // and `from`
  for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
    if (i === fromEnd || from.charCodeAt(i) === 47 /*/*/) {
    if (out.length === 0)
      out += '..';
    else
      out += '/..';
    }
  }

  // Lastly, append the rest of the destination (`to`) path that comes after
  // the common path parts
  if (out.length > 0)
    return out + to.slice(toStart + lastCommonSep);
  else {
    toStart += lastCommonSep;
    if (to.charCodeAt(toStart) === 47 /*/*/)
    ++toStart;
    return to.slice(toStart);
  }
  },

  _makeLong: function _makeLong(path) {
  return path;
  },

  dirname: function dirname(path) {
  assertPath(path);
  if (path.length === 0) return '.';
  var code = path.charCodeAt(0);
  var hasRoot = code === 47 /*/*/;
  var end = -1;
  var matchedSlash = true;
  for (var i = path.length - 1; i >= 1; --i) {
    code = path.charCodeAt(i);
    if (code === 47 /*/*/) {
      if (!matchedSlash) {
      end = i;
      break;
      }
    } else {
    // We saw the first non-path separator
    matchedSlash = false;
    }
  }

  if (end === -1) return hasRoot ? '/' : '.';
  if (hasRoot && end === 1) return '//';
  return path.slice(0, end);
  },

  basename: function basename(path, ext) {
  if (ext !== undefined && typeof ext !== 'string') throw new TypeError('"ext" argument must be a string');
  assertPath(path);

  var start = 0;
  var end = -1;
  var matchedSlash = true;
  var i;

  if (ext !== undefined && ext.length > 0 && ext.length <= path.length) {
    if (ext.length === path.length && ext === path) return '';
    var extIdx = ext.length - 1;
    var firstNonSlashEnd = -1;
    for (i = path.length - 1; i >= 0; --i) {
    var code = path.charCodeAt(i);
    if (code === 47 /*/*/) {
      // If we reached a path separator that was not part of a set of path
      // separators at the end of the string, stop now
      if (!matchedSlash) {
        start = i + 1;
        break;
      }
      } else {
      if (firstNonSlashEnd === -1) {
      // We saw the first non-path separator, remember this index in case
      // we need it if the extension ends up not matching
      matchedSlash = false;
      firstNonSlashEnd = i + 1;
      }
      if (extIdx >= 0) {
      // Try to match the explicit extension
      if (code === ext.charCodeAt(extIdx)) {
        if (--extIdx === -1) {
        // We matched the extension, so mark this as the end of our path
        // component
        end = i;
        }
      } else {
        // Extension does not match, so our result is the entire path
        // component
        extIdx = -1;
        end = firstNonSlashEnd;
      }
      }
    }
    }

    if (start === end) end = firstNonSlashEnd;else if (end === -1) end = path.length;
    return path.slice(start, end);
  } else {
    for (i = path.length - 1; i >= 0; --i) {
    if (path.charCodeAt(i) === 47 /*/*/) {
      // If we reached a path separator that was not part of a set of path
      // separators at the end of the string, stop now
      if (!matchedSlash) {
        start = i + 1;
        break;
      }
      } else if (end === -1) {
      // We saw the first non-path separator, mark this as the end of our
      // path component
      matchedSlash = false;
      end = i + 1;
    }
    }

    if (end === -1) return '';
    return path.slice(start, end);
  }
  },

  extname: function extname(path) {
  assertPath(path);
  var startDot = -1;
  var startPart = 0;
  var end = -1;
  var matchedSlash = true;
  // Track the state of characters (if any) we see before our first dot and
  // after any path separator we find
  var preDotState = 0;
  for (var i = path.length - 1; i >= 0; --i) {
    var code = path.charCodeAt(i);
    if (code === 47 /*/*/) {
      // If we reached a path separator that was not part of a set of path
      // separators at the end of the string, stop now
      if (!matchedSlash) {
      startPart = i + 1;
      break;
      }
      continue;
    }
    if (end === -1) {
    // We saw the first non-path separator, mark this as the end of our
    // extension
    matchedSlash = false;
    end = i + 1;
    }
    if (code === 46 /*.*/) {
      // If this is our first dot, mark it as the start of our extension
      if (startDot === -1)
      startDot = i;
      else if (preDotState !== 1)
      preDotState = 1;
    } else if (startDot !== -1) {
    // We saw a non-dot and non-path separator before our dot, so we should
    // have a good chance at having a non-empty extension
    preDotState = -1;
    }
  }

  if (startDot === -1 || end === -1 ||
    // We saw a non-dot character immediately before the dot
    preDotState === 0 ||
    // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
    return '';
  }
  return path.slice(startDot, end);
  },

  format: function format(pathObject) {
  if (pathObject === null || typeof pathObject !== 'object') {
    throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
  }
  return _format('/', pathObject);
  },

  parse: function parse(path) {
  assertPath(path);

  var ret = { root: '', dir: '', base: '', ext: '', name: '' };
  if (path.length === 0) return ret;
  var code = path.charCodeAt(0);
  var isAbsolute = code === 47 /*/*/;
  var start;
  if (isAbsolute) {
    ret.root = '/';
    start = 1;
  } else {
    start = 0;
  }
  var startDot = -1;
  var startPart = 0;
  var end = -1;
  var matchedSlash = true;
  var i = path.length - 1;

  // Track the state of characters (if any) we see before our first dot and
  // after any path separator we find
  var preDotState = 0;

  // Get non-dir info
  for (; i >= start; --i) {
    code = path.charCodeAt(i);
    if (code === 47 /*/*/) {
      // If we reached a path separator that was not part of a set of path
      // separators at the end of the string, stop now
      if (!matchedSlash) {
      startPart = i + 1;
      break;
      }
      continue;
    }
    if (end === -1) {
    // We saw the first non-path separator, mark this as the end of our
    // extension
    matchedSlash = false;
    end = i + 1;
    }
    if (code === 46 /*.*/) {
      // If this is our first dot, mark it as the start of our extension
      if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
    } else if (startDot !== -1) {
    // We saw a non-dot and non-path separator before our dot, so we should
    // have a good chance at having a non-empty extension
    preDotState = -1;
    }
  }

  if (startDot === -1 || end === -1 ||
  // We saw a non-dot character immediately before the dot
  preDotState === 0 ||
  // The (right-most) trimmed path component is exactly '..'
  preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
    if (end !== -1) {
    if (startPart === 0 && isAbsolute) ret.base = ret.name = path.slice(1, end);else ret.base = ret.name = path.slice(startPart, end);
    }
  } else {
    if (startPart === 0 && isAbsolute) {
    ret.name = path.slice(1, startDot);
    ret.base = path.slice(1, end);
    } else {
    ret.name = path.slice(startPart, startDot);
    ret.base = path.slice(startPart, end);
    }
    ret.ext = path.slice(startDot, end);
  }

  if (startPart > 0) ret.dir = path.slice(0, startPart - 1);else if (isAbsolute) ret.dir = '/';

  return ret;
  },

  sep: '/',
  delimiter: ':',
  win32: null,
  posix: null
};

posix$2.posix = posix$2;

var pathBrowserify = posix$2;

const IS_NODE_ENV = typeof global !== 'undefined' &&
  typeof require === 'function' &&
  !!global.process &&
  typeof __filename === 'string' &&
  (!global.origin || typeof global.origin !== 'string');
const OS_PLATFORM = IS_NODE_ENV ? process.platform : '';
const IS_WINDOWS_ENV = OS_PLATFORM === 'win32';
const IS_CASE_SENSITIVE_FILE_NAMES = !IS_WINDOWS_ENV;
const IS_BROWSER_ENV = typeof location !== 'undefined' && typeof navigator !== 'undefined' && typeof XMLHttpRequest !== 'undefined';
const IS_WEB_WORKER_ENV = IS_BROWSER_ENV && typeof self !== 'undefined' && typeof self.importScripts === 'function';
const HAS_WEB_WORKER = IS_BROWSER_ENV && typeof Worker === 'function';
const IS_FETCH_ENV = typeof fetch === 'function';
const requireFunc = IS_NODE_ENV ? require : () => { };
const getCurrentDirectory = IS_NODE_ENV ? process.cwd : () => '/';

/**
 * Default style mode id
 */
const DEFAULT_STYLE_MODE = '$';
/**
 * File names and value
 */
const COLLECTION_MANIFEST_FILE_NAME = 'collection-manifest.json';

const formatComponentRuntimeMeta = (compilerMeta, includeMethods) => {
  let flags = 0;
  if (compilerMeta.encapsulation === 'shadow') {
    flags |= 1 /* CMP_FLAGS.shadowDomEncapsulation */;
    if (compilerMeta.shadowDelegatesFocus) {
      flags |= 16 /* CMP_FLAGS.shadowDelegatesFocus */;
    }
  }
  else if (compilerMeta.encapsulation === 'scoped') {
    flags |= 2 /* CMP_FLAGS.scopedCssEncapsulation */;
  }
  if (compilerMeta.encapsulation !== 'shadow' && compilerMeta.htmlTagNames.includes('slot')) {
    flags |= 4 /* CMP_FLAGS.hasSlotRelocation */;
  }
  if (compilerMeta.hasMode) {
    flags |= 32 /* CMP_FLAGS.hasMode */;
  }
  const members = formatComponentRuntimeMembers(compilerMeta, includeMethods);
  const hostListeners = formatHostListeners(compilerMeta);
  return trimFalsy([
    flags,
    compilerMeta.tagName,
    Object.keys(members).length > 0 ? members : undefined,
    hostListeners.length > 0 ? hostListeners : undefined,
  ]);
};
const stringifyRuntimeData = (data) => {
  const json = JSON.stringify(data);
  if (json.length > 10000) {
    // JSON metadata is big, JSON.parse() is faster
    // https://twitter.com/mathias/status/1143551692732030979
    return `JSON.parse(${JSON.stringify(json)})`;
  }
  return json;
};
const formatComponentRuntimeMembers = (compilerMeta, includeMethods = true) => {
  return {
    ...formatPropertiesRuntimeMember(compilerMeta.properties),
    ...formatStatesRuntimeMember(compilerMeta.states),
    ...(includeMethods ? formatMethodsRuntimeMember(compilerMeta.methods) : {}),
  };
};
const formatPropertiesRuntimeMember = (properties) => {
  const runtimeMembers = {};
  properties.forEach((member) => {
    runtimeMembers[member.name] = trimFalsy([
      /**
       * [0] member type
       */
      formatFlags(member),
      formatAttrName(member),
    ]);
  });
  return runtimeMembers;
};
const formatFlags = (compilerProperty) => {
  let type = formatPropType(compilerProperty.type);
  if (compilerProperty.mutable) {
    type |= 1024 /* MEMBER_FLAGS.Mutable */;
  }
  if (compilerProperty.reflect) {
    type |= 512 /* MEMBER_FLAGS.ReflectAttr */;
  }
  return type;
};
const formatAttrName = (compilerProperty) => {
  if (typeof compilerProperty.attribute === 'string') {
    // string attr name means we should observe this attribute
    if (compilerProperty.name === compilerProperty.attribute) {
      // property name and attribute name are the exact same
      // true value means to use the property name for the attribute name
      return undefined;
    }
    // property name and attribute name are not the same
    // so we need to return the actual string value
    // example: "multiWord" !== "multi-word"
    return compilerProperty.attribute;
  }
  // we shouldn't even observe an attribute for this property
  return undefined;
};
const formatPropType = (type) => {
  if (type === 'string') {
    return 1 /* MEMBER_FLAGS.String */;
  }
  if (type === 'number') {
    return 2 /* MEMBER_FLAGS.Number */;
  }
  if (type === 'boolean') {
    return 4 /* MEMBER_FLAGS.Boolean */;
  }
  if (type === 'any') {
    return 8 /* MEMBER_FLAGS.Any */;
  }
  return 16 /* MEMBER_FLAGS.Unknown */;
};
const formatStatesRuntimeMember = (states) => {
  const runtimeMembers = {};
  states.forEach((member) => {
    runtimeMembers[member.name] = [
      32 /* MEMBER_FLAGS.State */,
    ];
  });
  return runtimeMembers;
};
const formatMethodsRuntimeMember = (methods) => {
  const runtimeMembers = {};
  methods.forEach((member) => {
    runtimeMembers[member.name] = [
      64 /* MEMBER_FLAGS.Method */,
    ];
  });
  return runtimeMembers;
};
const formatHostListeners = (compilerMeta) => {
  return compilerMeta.listeners.map((compilerListener) => {
    const hostListener = [
      computeListenerFlags(compilerListener),
      compilerListener.name,
      compilerListener.method,
    ];
    return hostListener;
  });
};
const computeListenerFlags = (listener) => {
  let flags = 0;
  if (listener.capture) {
    flags |= 2 /* LISTENER_FLAGS.Capture */;
  }
  if (listener.passive) {
    flags |= 1 /* LISTENER_FLAGS.Passive */;
  }
  switch (listener.target) {
    case 'document':
      flags |= 4 /* LISTENER_FLAGS.TargetDocument */;
      break;
    case 'window':
      flags |= 8 /* LISTENER_FLAGS.TargetWindow */;
      break;
    case 'body':
      flags |= 16 /* LISTENER_FLAGS.TargetBody */;
      break;
    case 'parent':
      flags |= 32 /* LISTENER_FLAGS.TargetParent */;
      break;
  }
  return flags;
};
const trimFalsy = (data) => {
  const arr = data;
  for (let i = arr.length - 1; i >= 0; i--) {
    if (arr[i]) {
      break;
    }
    // if falsy, safe to pop()
    arr.pop();
  }
  return arr;
};

/**
 * Convert a string from PascalCase to dash-case
 *
 * @param str the string to convert
 * @returns a converted string
 */
const toDashCase = (str) => str
  .replace(/([A-Z0-9])/g, (match) => ` ${match[0]}`)
  .trim()
  .split(' ')
  .join('-')
  .toLowerCase();
/**
 * Convert a string from dash-case / kebab-case to PascalCase (or CamelCase,
 * or whatever you call it!)
 *
 * @param str a string to convert
 * @returns a converted string
 */
const dashToPascalCase$1 = (str) => str
  .toLowerCase()
  .split('-')
  .map((segment) => segment.charAt(0).toUpperCase() + segment.slice(1))
  .join('');
const toTitleCase = (str) => str.charAt(0).toUpperCase() + str.slice(1);
const noop$1 = () => {
  /* noop*/
};
const sortBy = (array, prop) => {
  return array.slice().sort((a, b) => {
    const nameA = prop(a);
    const nameB = prop(b);
    if (nameA < nameB)
      return -1;
    if (nameA > nameB)
      return 1;
    return 0;
  });
};
const flatOne = (array) => {
  if (array.flat) {
    return array.flat(1);
  }
  return array.reduce((result, item) => {
    result.push(...item);
    return result;
  }, []);
};
const unique = (array, predicate = (i) => i) => {
  const set = new Set();
  return array.filter((item) => {
    const key = predicate(item);
    if (key == null) {
      return true;
    }
    if (set.has(key)) {
      return false;
    }
    set.add(key);
    return true;
  });
};
const fromEntries = (entries) => {
  const object = {};
  for (const [key, value] of entries) {
    object[key] = value;
  }
  return object;
};
const pluck = (obj, keys) => {
  return keys.reduce((final, key) => {
    if (obj[key]) {
      final[key] = obj[key];
    }
    return final;
  }, {});
};
const isDefined = (v) => v !== null && v !== undefined;
const isBoolean$1 = (v) => typeof v === 'boolean';
const isFunction = (v) => typeof v === 'function';
const isNumber$1 = (v) => typeof v === 'number';
const isObject$4 = (val) => val != null && typeof val === 'object' && Array.isArray(val) === false;
const isString$1 = (v) => typeof v === 'string';
const isIterable = (v) => isDefined(v) && isFunction(v[Symbol.iterator]);
const isPromise = (v) => !!v && (typeof v === 'object' || typeof v === 'function') && typeof v.then === 'function';

const isGlob = (str) => {
  const chars = { '{': '}', '(': ')', '[': ']' };
  /* eslint-disable-next-line max-len */
  const regex = /\\(.)|(^!|\*|[\].+)]\?|\[[^\\\]]+\]|\{[^\\}]+\}|\(\?[:!=][^\\)]+\)|\([^|]+\|[^\\)]+\))/;
  if (str === '') {
    return false;
  }
  let match;
  while ((match = regex.exec(str))) {
    if (match[2])
      return true;
    let idx = match.index + match[0].length;
    // if an open bracket/brace/paren is escaped,
    // set the index to the next closing character
    const open = match[1];
    const close = open ? chars[open] : null;
    if (open && close) {
      const n = str.indexOf(close, idx);
      if (n !== -1) {
        idx = n + 1;
      }
    }
    str = str.slice(idx);
  }
  return false;
};

/**
 * Checks if the path is the Operating System (OS) root path, such as "/" or "C:\". This function does not take the OS
 * the code is running on into account when performing this evaluation.
 * @param p the path to check
 * @returns `true` if the path is an OS root path, `false` otherwise
 */
const isRootPath = (p) => p === '/' || windowsPathRegex.test(p);
// https://github.com/nodejs/node/blob/5883a59b21a97e8b7339f435c977155a2c29ba8d/lib/path.js#L43
const windowsPathRegex = /^(?:[a-zA-Z]:|[\\/]{2}[^\\/]+[\\/]+[^\\/]+)?[\\/]$/;

/**
 * Builds a template `Diagnostic` entity for a build error. The created `Diagnostic` is returned, and have little
 * detail attached to it regarding the specifics of the error - it is the responsibility of the caller of this method
 * to attach the specifics of the error message.
 *
 * The created `Diagnostic` is pushed to the `diagnostics` argument as a side effect of calling this method.
 *
 * @param diagnostics the existing diagnostics that the created template `Diagnostic` should be added to
 * @returns the created `Diagnostic`
 */
const buildError = (diagnostics) => {
  const diagnostic = {
    level: 'error',
    type: 'build',
    header: 'Build Error',
    messageText: 'build error',
    relFilePath: null,
    absFilePath: null,
    lines: [],
  };
  if (diagnostics) {
    diagnostics.push(diagnostic);
  }
  return diagnostic;
};
/**
 * Builds a template `Diagnostic` entity for a build warning. The created `Diagnostic` is returned, and have little
 * detail attached to it regarding the specifics of the warning - it is the responsibility of the caller of this method
 * to attach the specifics of the warning message.
 *
 * The created `Diagnostic` is pushed to the `diagnostics` argument as a side effect of calling this method.
 *
 * @param diagnostics the existing diagnostics that the created template `Diagnostic` should be added to
 * @returns the created `Diagnostic`
 */
const buildWarn = (diagnostics) => {
  const diagnostic = {
    level: 'warn',
    type: 'build',
    header: 'Build Warn',
    messageText: 'build warn',
    relFilePath: null,
    absFilePath: null,
    lines: [],
  };
  diagnostics.push(diagnostic);
  return diagnostic;
};
/**
 * Create a diagnostic message suited for representing an error in a JSON
 * file. This includes information about the exact lines in the JSON file which
 * caused the error and the path to the file.
 *
 * @param compilerCtx the current compiler context
 * @param diagnostics a list of diagnostics used as a return param
 * @param jsonFilePath the path to the JSON file where the error occurred
 * @param msg the error message
 * @param jsonField the key for the field which caused the error, used for finding
 * the error line in the original JSON file
 * @returns a reference to the newly-created diagnostic
 */
const buildJsonFileError = (compilerCtx, diagnostics, jsonFilePath, msg, jsonField) => {
  const err = buildError(diagnostics);
  err.messageText = msg;
  err.absFilePath = jsonFilePath;
  if (typeof jsonField === 'string') {
    try {
      const jsonStr = compilerCtx.fs.readFileSync(jsonFilePath);
      const lines = jsonStr.replace(/\r/g, '\n').split('\n');
      for (let i = 0; i < lines.length; i++) {
        const txtLine = lines[i];
        const txtIndex = txtLine.indexOf(jsonField);
        if (txtIndex > -1) {
          const warnLine = {
            lineIndex: i,
            lineNumber: i + 1,
            text: txtLine,
            errorCharStart: txtIndex,
            errorLength: jsonField.length,
          };
          err.lineNumber = warnLine.lineNumber;
          err.columnNumber = txtIndex + 1;
          err.lines.push(warnLine);
          if (i >= 0) {
            const beforeWarnLine = {
              lineIndex: warnLine.lineIndex - 1,
              lineNumber: warnLine.lineNumber - 1,
              text: lines[i - 1],
              errorCharStart: -1,
              errorLength: -1,
            };
            err.lines.unshift(beforeWarnLine);
          }
          if (i < lines.length) {
            const afterWarnLine = {
              lineIndex: warnLine.lineIndex + 1,
              lineNumber: warnLine.lineNumber + 1,
              text: lines[i + 1],
              errorCharStart: -1,
              errorLength: -1,
            };
            err.lines.push(afterWarnLine);
          }
          break;
        }
      }
    }
    catch (e) { }
  }
  return err;
};
/**
 * Builds a diagnostic from an `Error`, appends it to the `diagnostics` parameter, and returns the created diagnostic
 * @param diagnostics the series of diagnostics the newly created diagnostics should be added to
 * @param err the error to derive information from in generating the diagnostic
 * @param msg an optional message to use in place of `err` to generate the diagnostic
 * @returns the generated diagnostic
 */
const catchError = (diagnostics, err, msg) => {
  const diagnostic = {
    level: 'error',
    type: 'build',
    header: 'Build Error',
    messageText: 'build error',
    relFilePath: null,
    absFilePath: null,
    lines: [],
  };
  if (isString$1(msg)) {
    diagnostic.messageText = msg.length ? msg : 'UNKNOWN ERROR';
  }
  else if (err != null) {
    if (err.stack != null) {
      diagnostic.messageText = err.stack.toString();
    }
    else {
      if (err.message != null) {
        diagnostic.messageText = err.message.length ? err.message : 'UNKNOWN ERROR';
      }
      else {
        diagnostic.messageText = err.toString();
      }
    }
  }
  if (diagnostics != null && !shouldIgnoreError(diagnostic.messageText)) {
    diagnostics.push(diagnostic);
  }
  return diagnostic;
};
/**
 * Determine if the provided diagnostics have any build errors
 * @param diagnostics the diagnostics to inspect
 * @returns true if any of the diagnostics in the list provided are errors that did not occur at runtime. false
 * otherwise.
 */
const hasError = (diagnostics) => {
  if (diagnostics == null || diagnostics.length === 0) {
    return false;
  }
  return diagnostics.some((d) => d.level === 'error' && d.type !== 'runtime');
};
/**
 * Determine if the provided diagnostics have any warnings
 * @param diagnostics the diagnostics to inspect
 * @returns true if any of the diagnostics in the list provided are warnings. false otherwise.
 */
const hasWarning = (diagnostics) => {
  if (diagnostics == null || diagnostics.length === 0) {
    return false;
  }
  return diagnostics.some((d) => d.level === 'warn');
};
const shouldIgnoreError = (msg) => {
  return msg === TASK_CANCELED_MSG;
};
const TASK_CANCELED_MSG = `task canceled`;

/**
 * Iterate through a series of diagnostics to provide minor fix-ups for various edge cases, deduplicate messages, etc.
 * @param compilerCtx the current compiler context
 * @param diagnostics the diagnostics to normalize
 * @returns the normalize documents
 */
const normalizeDiagnostics = (compilerCtx, diagnostics) => {
  const maxErrorsToNormalize = 25;
  const normalizedErrors = [];
  const normalizedOthers = [];
  const dups = new Set();
  for (let i = 0; i < diagnostics.length; i++) {
    const d = normalizeDiagnostic(compilerCtx, diagnostics[i]);
    const key = d.absFilePath + d.code + d.messageText + d.type;
    if (dups.has(key)) {
      continue;
    }
    dups.add(key);
    const total = normalizedErrors.length + normalizedOthers.length;
    if (d.level === 'error') {
      normalizedErrors.push(d);
    }
    else if (total < maxErrorsToNormalize) {
      normalizedOthers.push(d);
    }
  }
  return [...normalizedErrors, ...normalizedOthers];
};
/**
 * Perform post-processing on a `Diagnostic` to handle a few message edge cases, massaging error message text and
 * updating build failure contexts
 * @param compilerCtx the current compiler
 * @param diagnostic the diagnostic to normalize
 * @returns the altered diagnostic
 */
const normalizeDiagnostic = (compilerCtx, diagnostic) => {
  if (diagnostic.messageText) {
    if (typeof diagnostic.messageText.message === 'string') {
      diagnostic.messageText = diagnostic.messageText.message;
    }
    else if (typeof diagnostic.messageText === 'string' && diagnostic.messageText.indexOf('Error: ') === 0) {
      diagnostic.messageText = diagnostic.messageText.slice(7);
    }
  }
  if (diagnostic.messageText) {
    if (diagnostic.messageText.includes(`Cannot find name 'h'`)) {
      diagnostic.header = `Missing "h" import for JSX types`;
      diagnostic.messageText = `In order to load accurate JSX types for components, the "h" function must be imported from "@stencil/core" by each component using JSX. For example: import { Component, h } from '@stencil/core';`;
      try {
        const sourceText = compilerCtx.fs.readFileSync(diagnostic.absFilePath);
        const srcLines = splitLineBreaks(sourceText);
        for (let i = 0; i < srcLines.length; i++) {
          const srcLine = srcLines[i];
          if (srcLine.includes('@stencil/core')) {
            const msgLines = [];
            const beforeLineIndex = i - 1;
            if (beforeLineIndex > -1) {
              const beforeLine = {
                lineIndex: beforeLineIndex,
                lineNumber: beforeLineIndex + 1,
                text: srcLines[beforeLineIndex],
                errorCharStart: -1,
                errorLength: -1,
              };
              msgLines.push(beforeLine);
            }
            const errorLine = {
              lineIndex: i,
              lineNumber: i + 1,
              text: srcLine,
              errorCharStart: 0,
              errorLength: -1,
            };
            msgLines.push(errorLine);
            diagnostic.lineNumber = errorLine.lineNumber;
            diagnostic.columnNumber = srcLine.indexOf('}');
            const afterLineIndex = i + 1;
            if (afterLineIndex < srcLines.length) {
              const afterLine = {
                lineIndex: afterLineIndex,
                lineNumber: afterLineIndex + 1,
                text: srcLines[afterLineIndex],
                errorCharStart: -1,
                errorLength: -1,
              };
              msgLines.push(afterLine);
            }
            diagnostic.lines = msgLines;
            break;
          }
        }
      }
      catch (e) { }
    }
  }
  return diagnostic;
};
/**
 * Split a corpus by newlines. Carriage returns are treated a newlines.
 * @param sourceText the corpus to split
 * @returns the split text
 */
const splitLineBreaks = (sourceText) => {
  if (typeof sourceText !== 'string')
    return [];
  sourceText = sourceText.replace(/\\r/g, '\n');
  return sourceText.split('\n');
};
const escapeHtml = (unsafe) => {
  if (unsafe === undefined)
    return 'undefined';
  if (unsafe === null)
    return 'null';
  if (typeof unsafe !== 'string') {
    unsafe = unsafe.toString();
  }
  return unsafe
    .replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#039;');
};

const loadRollupDiagnostics = (config, compilerCtx, buildCtx, rollupError) => {
  const formattedCode = formatErrorCode(rollupError.code);
  const diagnostic = {
    level: 'error',
    type: 'bundling',
    language: 'javascript',
    code: rollupError.code,
    header: `Rollup${formattedCode.length > 0 ? ': ' + formattedCode : ''}`,
    messageText: formattedCode,
    relFilePath: null,
    absFilePath: null,
    lines: [],
  };
  if (config.logLevel === 'debug' && rollupError.stack) {
    diagnostic.messageText = rollupError.stack;
  }
  else if (rollupError.message) {
    diagnostic.messageText = rollupError.message;
  }
  if (rollupError.plugin) {
    diagnostic.messageText += ` (plugin: ${rollupError.plugin}${rollupError.hook ? `, ${rollupError.hook}` : ''})`;
  }
  const loc = rollupError.loc;
  if (loc != null) {
    const srcFile = loc.file || rollupError.id;
    if (isString$1(srcFile)) {
      try {
        const sourceText = compilerCtx.fs.readFileSync(srcFile);
        if (sourceText) {
          diagnostic.absFilePath = srcFile;
          try {
            const srcLines = splitLineBreaks(sourceText);
            const errorLine = {
              lineIndex: loc.line - 1,
              lineNumber: loc.line,
              text: srcLines[loc.line - 1],
              errorCharStart: loc.column,
              errorLength: 0,
            };
            diagnostic.lineNumber = errorLine.lineNumber;
            diagnostic.columnNumber = errorLine.errorCharStart;
            const highlightLine = errorLine.text.slice(loc.column);
            for (let i = 0; i < highlightLine.length; i++) {
              if (charBreak.has(highlightLine.charAt(i))) {
                break;
              }
              errorLine.errorLength++;
            }
            diagnostic.lines.push(errorLine);
            if (errorLine.errorLength === 0 && errorLine.errorCharStart > 0) {
              errorLine.errorLength = 1;
              errorLine.errorCharStart--;
            }
            if (errorLine.lineIndex > 0) {
              const previousLine = {
                lineIndex: errorLine.lineIndex - 1,
                lineNumber: errorLine.lineNumber - 1,
                text: srcLines[errorLine.lineIndex - 1],
                errorCharStart: -1,
                errorLength: -1,
              };
              diagnostic.lines.unshift(previousLine);
            }
            if (errorLine.lineIndex + 1 < srcLines.length) {
              const nextLine = {
                lineIndex: errorLine.lineIndex + 1,
                lineNumber: errorLine.lineNumber + 1,
                text: srcLines[errorLine.lineIndex + 1],
                errorCharStart: -1,
                errorLength: -1,
              };
              diagnostic.lines.push(nextLine);
            }
          }
          catch (e) {
            diagnostic.messageText += `\nError parsing: ${diagnostic.absFilePath}, line: ${loc.line}, column: ${loc.column}`;
            diagnostic.debugText = sourceText;
          }
        }
        else if (typeof rollupError.frame === 'string') {
          diagnostic.messageText += '\n' + rollupError.frame;
        }
      }
      catch (e) { }
    }
  }
  buildCtx.diagnostics.push(diagnostic);
};
const createOnWarnFn = (diagnostics, bundleModulesFiles) => {
  const previousWarns = new Set();
  return function onWarningMessage(warning) {
    if (warning == null || ignoreWarnCodes.has(warning.code) || previousWarns.has(warning.message)) {
      return;
    }
    previousWarns.add(warning.message);
    let label = '';
    if (bundleModulesFiles) {
      label = bundleModulesFiles
        .reduce((cmps, m) => {
        cmps.push(...m.cmps);
        return cmps;
      }, [])
        .join(', ')
        .trim();
      if (label.length) {
        label += ': ';
      }
    }
    const diagnostic = buildWarn(diagnostics);
    diagnostic.header = `Bundling Warning ${warning.code}`;
    diagnostic.messageText = label + (warning.message || warning);
  };
};
const ignoreWarnCodes = new Set([
  'THIS_IS_UNDEFINED',
  'NON_EXISTENT_EXPORT',
  'CIRCULAR_DEPENDENCY',
  'EMPTY_BUNDLE',
  'UNUSED_EXTERNAL_IMPORT',
]);
const charBreak = new Set([' ', '=', '.', ',', '?', ':', ';', '(', ')', '{', '}', '[', ']', '|', `'`, `"`, '`']);
const formatErrorCode = (errorCode) => {
  if (typeof errorCode === 'string') {
    return errorCode
      .split('_')
      .map((c) => {
      return toTitleCase(c.toLowerCase());
    })
      .join(' ');
  }
  return (errorCode || '').trim();
};

/**
 * Convert Windows backslash paths to slash paths: foo\\bar ➔ foo/bar
 * Forward-slash paths can be used in Windows as long as they're not
 * extended-length paths and don't contain any non-ascii characters.
 * This was created since the path methods in Node.js outputs \\ paths on Windows.
 * @param path the Windows-based path to convert
 * @returns the converted path
 */
const normalizePath$1 = (path) => {
  if (typeof path !== 'string') {
    throw new Error(`invalid path to normalize`);
  }
  path = normalizeSlashes(path.trim());
  const components = pathComponents(path, getRootLength(path));
  const reducedComponents = reducePathComponents(components);
  const rootPart = reducedComponents[0];
  const secondPart = reducedComponents[1];
  const normalized = rootPart + reducedComponents.slice(1).join('/');
  if (normalized === '') {
    return '.';
  }
  if (rootPart === '' &&
    secondPart &&
    path.includes('/') &&
    !secondPart.startsWith('.') &&
    !secondPart.startsWith('@')) {
    return './' + normalized;
  }
  return normalized;
};
const normalizeSlashes = (path) => path.replace(backslashRegExp, '/');
const altDirectorySeparator = '\\';
const urlSchemeSeparator = '://';
const backslashRegExp = /\\/g;
const reducePathComponents = (components) => {
  if (!Array.isArray(components) || components.length === 0) {
    return [];
  }
  const reduced = [components[0]];
  for (let i = 1; i < components.length; i++) {
    const component = components[i];
    if (!component)
      continue;
    if (component === '.')
      continue;
    if (component === '..') {
      if (reduced.length > 1) {
        if (reduced[reduced.length - 1] !== '..') {
          reduced.pop();
          continue;
        }
      }
      else if (reduced[0])
        continue;
    }
    reduced.push(component);
  }
  return reduced;
};
const getRootLength = (path) => {
  const rootLength = getEncodedRootLength(path);
  return rootLength < 0 ? ~rootLength : rootLength;
};
const getEncodedRootLength = (path) => {
  if (!path)
    return 0;
  const ch0 = path.charCodeAt(0);
  // POSIX or UNC
  if (ch0 === 47 /* CharacterCodes.slash */ || ch0 === 92 /* CharacterCodes.backslash */) {
    if (path.charCodeAt(1) !== ch0)
      return 1; // POSIX: "/" (or non-normalized "\")
    const p1 = path.indexOf(ch0 === 47 /* CharacterCodes.slash */ ? '/' : altDirectorySeparator, 2);
    if (p1 < 0)
      return path.length; // UNC: "//server" or "\\server"
    return p1 + 1; // UNC: "//server/" or "\\server\"
  }
  // DOS
  if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58 /* CharacterCodes.colon */) {
    const ch2 = path.charCodeAt(2);
    if (ch2 === 47 /* CharacterCodes.slash */ || ch2 === 92 /* CharacterCodes.backslash */)
      return 3; // DOS: "c:/" or "c:\"
    if (path.length === 2)
      return 2; // DOS: "c:" (but not "c:d")
  }
  // URL
  const schemeEnd = path.indexOf(urlSchemeSeparator);
  if (schemeEnd !== -1) {
    const authorityStart = schemeEnd + urlSchemeSeparator.length;
    const authorityEnd = path.indexOf('/', authorityStart);
    if (authorityEnd !== -1) {
      // URL: "file:///", "file://server/", "file://server/path"
      // For local "file" URLs, include the leading DOS volume (if present).
      // Per https://www.ietf.org/rfc/rfc1738.txt, a host of "" or "localhost" is a
      // special case interpreted as "the machine from which the URL is being interpreted".
      const scheme = path.slice(0, schemeEnd);
      const authority = path.slice(authorityStart, authorityEnd);
      if (scheme === 'file' &&
        (authority === '' || authority === 'localhost') &&
        isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
        const volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
        if (volumeSeparatorEnd !== -1) {
          if (path.charCodeAt(volumeSeparatorEnd) === 47 /* CharacterCodes.slash */) {
            // URL: "file:///c:/", "file://localhost/c:/", "file:///c%3a/", "file://localhost/c%3a/"
            return ~(volumeSeparatorEnd + 1);
          }
          if (volumeSeparatorEnd === path.length) {
            // URL: "file:///c:", "file://localhost/c:", "file:///c$3a", "file://localhost/c%3a"
            // but not "file:///c:d" or "file:///c%3ad"
            return ~volumeSeparatorEnd;
          }
        }
      }
      return ~(authorityEnd + 1); // URL: "file://server/", "http://server/"
    }
    return ~path.length; // URL: "file://server", "http://server"
  }
  // relative
  return 0;
};
const isVolumeCharacter = (charCode) => (charCode >= 97 /* CharacterCodes.a */ && charCode <= 122 /* CharacterCodes.z */) ||
  (charCode >= 65 /* CharacterCodes.A */ && charCode <= 90 /* CharacterCodes.Z */);
const getFileUrlVolumeSeparatorEnd = (url, start) => {
  const ch0 = url.charCodeAt(start);
  if (ch0 === 58 /* CharacterCodes.colon */)
    return start + 1;
  if (ch0 === 37 /* CharacterCodes.percent */ && url.charCodeAt(start + 1) === 51 /* CharacterCodes._3 */) {
    const ch2 = url.charCodeAt(start + 2);
    if (ch2 === 97 /* CharacterCodes.a */ || ch2 === 65 /* CharacterCodes.A */)
      return start + 3;
  }
  return -1;
};
const pathComponents = (path, rootLength) => {
  const root = path.substring(0, rootLength);
  const rest = path.substring(rootLength).split('/');
  const restLen = rest.length;
  if (restLen > 0 && !rest[restLen - 1]) {
    rest.pop();
  }
  return [root, ...rest];
};
/**
 * Same as normalizePath(), expect it'll also strip any query strings
 * from the path name. So /dir/file.css?tag=cmp-a becomes /dir/file.css
 * @param p the path to normalize
 * @returns the normalized path, sans any query strings
 */
const normalizeFsPath = (p) => normalizePath$1(p.split('?')[0].replace(/\0/g, ''));
const normalizeFsPathQuery = (importPath) => {
  const pathParts = importPath.split('?');
  const filePath = normalizePath$1(pathParts[0]);
  const ext = filePath.split('.').pop().toLowerCase();
  const params = pathParts.length > 1 ? new URLSearchParams(pathParts[1]) : null;
  const format = params ? params.get('format') : null;
  return {
    filePath,
    ext,
    params,
    format,
  };
};

/**
 * Augment a `Diagnostic` with information from a `Node` in the AST to provide richer error information
 * @param d the diagnostic to augment
 * @param node the node to augment with additional information
 * @returns the augmented diagnostic
 */
const augmentDiagnosticWithNode = (d, node) => {
  if (!node) {
    return d;
  }
  const sourceFile = node.getSourceFile();
  if (!sourceFile) {
    return d;
  }
  d.absFilePath = normalizePath$1(sourceFile.fileName);
  const sourceText = sourceFile.text;
  const srcLines = splitLineBreaks(sourceText);
  const start = node.getStart();
  const end = node.getEnd();
  const posStart = sourceFile.getLineAndCharacterOfPosition(start);
  const errorLine = {
    lineIndex: posStart.line,
    lineNumber: posStart.line + 1,
    text: srcLines[posStart.line],
    errorCharStart: posStart.character,
    errorLength: Math.max(end - start, 1),
  };
  // store metadata for line number and character index where the error occurred
  d.lineNumber = errorLine.lineNumber;
  d.columnNumber = errorLine.errorCharStart + 1;
  d.lines.push(errorLine);
  if (errorLine.errorLength === 0 && errorLine.errorCharStart > 0) {
    errorLine.errorLength = 1;
    errorLine.errorCharStart--;
  }
  // if the error did not occur on the first line of the file, add metadata for the line of code preceding the line
  // where the error was detected to provide the user with additional context
  if (errorLine.lineIndex > 0) {
    const previousLine = {
      lineIndex: errorLine.lineIndex - 1,
      lineNumber: errorLine.lineNumber - 1,
      text: srcLines[errorLine.lineIndex - 1],
      errorCharStart: -1,
      errorLength: -1,
    };
    d.lines.unshift(previousLine);
  }
  // if the error did not occur on the last line of the file, add metadata for the line of code following the line
  // where the error was detected to provide the user with additional context
  if (errorLine.lineIndex + 1 < srcLines.length) {
    const nextLine = {
      lineIndex: errorLine.lineIndex + 1,
      lineNumber: errorLine.lineNumber + 1,
      text: srcLines[errorLine.lineIndex + 1],
      errorCharStart: -1,
      errorLength: -1,
    };
    d.lines.push(nextLine);
  }
  return d;
};
/**
 * Ok, so formatting overkill, we know. But whatever, it makes for great
 * error reporting within a terminal. So, yeah, let's code it up, shall we?
 */
const loadTypeScriptDiagnostics = (tsDiagnostics) => {
  const diagnostics = [];
  const maxErrors = Math.min(tsDiagnostics.length, 50);
  for (let i = 0; i < maxErrors; i++) {
    diagnostics.push(loadTypeScriptDiagnostic(tsDiagnostics[i]));
  }
  return diagnostics;
};
const loadTypeScriptDiagnostic = (tsDiagnostic) => {
  const d = {
    level: 'warn',
    type: 'typescript',
    language: 'typescript',
    header: 'TypeScript',
    code: tsDiagnostic.code.toString(),
    messageText: flattenDiagnosticMessageText(tsDiagnostic, tsDiagnostic.messageText),
    relFilePath: null,
    absFilePath: null,
    lines: [],
  };
  if (tsDiagnostic.category === 1) {
    d.level = 'error';
  }
  if (tsDiagnostic.file) {
    d.absFilePath = tsDiagnostic.file.fileName;
    const sourceText = tsDiagnostic.file.text;
    const srcLines = splitLineBreaks(sourceText);
    const posData = tsDiagnostic.file.getLineAndCharacterOfPosition(tsDiagnostic.start);
    const errorLine = {
      lineIndex: posData.line,
      lineNumber: posData.line + 1,
      text: srcLines[posData.line],
      errorCharStart: posData.character,
      errorLength: Math.max(tsDiagnostic.length, 1),
    };
    d.lineNumber = errorLine.lineNumber;
    d.columnNumber = errorLine.errorCharStart + 1;
    d.lines.push(errorLine);
    if (errorLine.errorLength === 0 && errorLine.errorCharStart > 0) {
      errorLine.errorLength = 1;
      errorLine.errorCharStart--;
    }
    if (errorLine.lineIndex > 0) {
      const previousLine = {
        lineIndex: errorLine.lineIndex - 1,
        lineNumber: errorLine.lineNumber - 1,
        text: srcLines[errorLine.lineIndex - 1],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.unshift(previousLine);
    }
    if (errorLine.lineIndex + 1 < srcLines.length) {
      const nextLine = {
        lineIndex: errorLine.lineIndex + 1,
        lineNumber: errorLine.lineNumber + 1,
        text: srcLines[errorLine.lineIndex + 1],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.push(nextLine);
    }
  }
  return d;
};
const flattenDiagnosticMessageText = (tsDiagnostic, diag) => {
  if (typeof diag === 'string') {
    return diag;
  }
  else if (diag === undefined) {
    return '';
  }
  const ignoreCodes = [];
  const isStencilConfig = tsDiagnostic.file.fileName.includes('stencil.config');
  if (isStencilConfig) {
    ignoreCodes.push(2322);
  }
  let result = '';
  if (!ignoreCodes.includes(diag.code)) {
    result = diag.messageText;
    if (isIterable(diag.next)) {
      for (const kid of diag.next) {
        result += flattenDiagnosticMessageText(tsDiagnostic, kid);
      }
    }
  }
  if (isStencilConfig) {
    result = result.replace(`type 'StencilConfig'`, `Stencil Config`);
    result = result.replace(`Object literal may only specify known properties, but `, ``);
    result = result.replace(`Object literal may only specify known properties, and `, ``);
  }
  return result.trim();
};

/**
 * Determines whether a string should be considered a remote url or not.
 *
 * This helper only checks the provided string to evaluate is one of a few pre-defined schemes, and should not be
 * considered all-encompassing
 *
 * @param p the string to evaluate
 * @returns `true` if the provided string is a remote url, `false` otherwise
 */
const isRemoteUrl = (p) => {
  if (isString$1(p)) {
    p = p.toLowerCase();
    return p.startsWith('https://') || p.startsWith('http://');
  }
  return false;
};

const createJsVarName = (fileName) => {
  if (isString$1(fileName)) {
    fileName = fileName.split('?')[0];
    fileName = fileName.split('#')[0];
    fileName = fileName.split('&')[0];
    fileName = fileName.split('=')[0];
    fileName = toDashCase(fileName);
    fileName = fileName.replace(/[|;$%@"<>()+,.{}_\!\/\\]/g, '-');
    fileName = dashToPascalCase$1(fileName);
    if (fileName.length > 1) {
      fileName = fileName[0].toLowerCase() + fileName.slice(1);
    }
    else {
      fileName = fileName.toLowerCase();
    }
    if (fileName.length > 0 && !isNaN(fileName[0])) {
      fileName = '_' + fileName;
    }
  }
  return fileName;
};
/**
 * Determines if a given file path points to a type declaration file (ending in .d.ts) or not. This function is
 * case-insensitive in its heuristics.
 * @param filePath the path to check
 * @returns `true` if the given `filePath` points to a type declaration file, `false` otherwise
 */
const isDtsFile$1 = (filePath) => {
  const parts = filePath.toLowerCase().split('.');
  if (parts.length > 2) {
    return parts[parts.length - 2] === 'd' && parts[parts.length - 1] === 'ts';
  }
  return false;
};
/**
 * Generate the preamble to be placed atop the main file of the build
 * @param config the Stencil configuration file
 * @returns the generated preamble
 */
const generatePreamble = (config) => {
  const { preamble } = config;
  if (!preamble) {
    return '';
  }
  // generate the body of the JSDoc-style comment
  const preambleComment = preamble.split('\n').map((l) => ` * ${l}`);
  preambleComment.unshift(`/*!`);
  preambleComment.push(` */`);
  return preambleComment.join('\n');
};
const lineBreakRegex = /\r?\n|\r/g;
function getTextDocs(docs) {
  if (docs == null) {
    return '';
  }
  return `${docs.text.replace(lineBreakRegex, ' ')}
${docs.tags
    .filter((tag) => tag.name !== 'internal')
    .map((tag) => `@${tag.name} ${(tag.text || '').replace(lineBreakRegex, ' ')}`)
    .join('\n')}`.trim();
}
/**
 * Retrieve a project's dependencies from the current build context
 * @param buildCtx the current build context to query for a specific package
 * @returns a list of package names the project is dependent on
 */
const getDependencies = (buildCtx) => {
  if (buildCtx.packageJson != null && buildCtx.packageJson.dependencies != null) {
    return Object.keys(buildCtx.packageJson.dependencies).filter((pkgName) => !SKIP_DEPS.includes(pkgName));
  }
  return [];
};
/**
 * Utility to determine whether a project has a dependency on a package
 * @param buildCtx the current build context to query for a specific package
 * @param depName the name of the dependency/package
 * @returns `true` if the project has a dependency a packaged with the provided name, `false` otherwise
 */
const hasDependency = (buildCtx, depName) => {
  return getDependencies(buildCtx).includes(depName);
};
const getDynamicImportFunction$1 = (namespace) => `__sc_import_${namespace.replace(/\s|-/g, '_')}`;
const readPackageJson = async (config, compilerCtx, buildCtx) => {
  try {
    const pkgJson = await compilerCtx.fs.readFile(config.packageJsonFilePath);
    if (pkgJson) {
      const parseResults = parsePackageJson(pkgJson, config.packageJsonFilePath);
      if (parseResults.diagnostic) {
        buildCtx.diagnostics.push(parseResults.diagnostic);
      }
      else {
        buildCtx.packageJson = parseResults.data;
      }
    }
  }
  catch (e) {
    if (!config.outputTargets.some((o) => o.type.includes('dist'))) {
      const diagnostic = buildError(buildCtx.diagnostics);
      diagnostic.header = `Missing "package.json"`;
      diagnostic.messageText = `Valid "package.json" file is required for distribution: ${config.packageJsonFilePath}`;
    }
  }
};
/**
 * Parse a string read from a `package.json` file
 * @param pkgJsonStr the string read from a `package.json` file
 * @param pkgJsonFilePath the path to the already read `package.json` file
 * @returns the results of parsing the provided contents of the `package.json` file
 */
const parsePackageJson = (pkgJsonStr, pkgJsonFilePath) => {
  const parseResult = {
    diagnostic: null,
    data: null,
    filePath: pkgJsonFilePath,
  };
  try {
    parseResult.data = JSON.parse(pkgJsonStr);
  }
  catch (e) {
    parseResult.diagnostic = buildError();
    parseResult.diagnostic.absFilePath = isString$1(pkgJsonFilePath) ? pkgJsonFilePath : undefined;
    parseResult.diagnostic.header = `Error Parsing JSON`;
    if (e instanceof Error) {
      parseResult.diagnostic.messageText = e.message;
    }
  }
  return parseResult;
};
const SKIP_DEPS = ['@stencil/core'];

/**
 * Validates that a component tag meets required naming conventions to be used for a web component
 * @param tag the tag to validate
 * @returns an error message if the tag has an invalid name, undefined if the tag name passes all checks
 */
const validateComponentTag = (tag) => {
  // we want to check this first since we call some String.prototype methods below
  if (typeof tag !== 'string') {
    return `Tag "${tag}" must be a string type`;
  }
  if (tag !== tag.trim()) {
    return `Tag can not contain white spaces`;
  }
  if (tag !== tag.toLowerCase()) {
    return `Tag can not contain upper case characters`;
  }
  if (tag.length === 0) {
    return `Received empty tag value`;
  }
  if (tag.indexOf(' ') > -1) {
    return `"${tag}" tag cannot contain a space`;
  }
  if (tag.indexOf(',') > -1) {
    return `"${tag}" tag cannot be used for multiple tags`;
  }
  const invalidChars = tag.replace(/\w|-/g, '');
  if (invalidChars !== '') {
    return `"${tag}" tag contains invalid characters: ${invalidChars}`;
  }
  if (tag.indexOf('-') === -1) {
    return `"${tag}" tag must contain a dash (-) to work as a valid web component`;
  }
  if (tag.indexOf('--') > -1) {
    return `"${tag}" tag cannot contain multiple dashes (--) next to each other`;
  }
  if (tag.indexOf('-') === 0) {
    return `"${tag}" tag cannot start with a dash (-)`;
  }
  if (tag.lastIndexOf('-') === tag.length - 1) {
    return `"${tag}" tag cannot end with a dash (-)`;
  }
  return undefined;
};

/**
 * Used to learn the size of a string in bytes.
 *
 * @param str The string to measure
 * @returns number
 */
const byteSize = (str) => Buffer.byteLength(str, 'utf8');

/**
 * Converts a rollup provided source map to one that Stencil can easily understand
 * @param rollupSourceMap the sourcemap to transform
 * @returns the transformed sourcemap
 */
const rollupToStencilSourceMap = (rollupSourceMap) => {
  if (!rollupSourceMap) {
    return null;
  }
  return {
    file: rollupSourceMap.file,
    mappings: rollupSourceMap.mappings,
    names: rollupSourceMap.names,
    sources: rollupSourceMap.sources,
    sourcesContent: rollupSourceMap.sourcesContent,
    version: rollupSourceMap.version,
  };
};
/**
 * A JavaScript formatted string used to link generated code back to the original. This string follows the guidelines
 * found in the [Linking generated code to source maps](https://sourcemaps.info/spec.html#h.lmz475t4mvbx) section of
 * the Sourcemaps V3 specification proposal.
 */
const JS_SOURCE_MAPPING_URL_LINKER = '//# sourceMappingURL=';
/**
 * Generates an RFC-3986 compliant string for the given input.
 * More information about RFC-3986 can be found [here](https://datatracker.ietf.org/doc/html/rfc3986)
 * This function's original source is derived from
 * [MDN's encodeURIComponent documentation](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent#description)
 * @param filename the filename to encode
 * @returns the encoded URI
 */
const encodeToRfc3986 = (filename) => {
  const encodedUri = encodeURIComponent(filename);
  // replace all '!', single quotes, '(', ')', and '*' with their hexadecimal values (UTF-16)
  return encodedUri.replace(/[!'()*]/g, (matchedCharacter) => {
    return '%' + matchedCharacter.charCodeAt(0).toString(16);
  });
};
/**
 * Generates a string used to link generated code with the original source, to be placed at the end of the generated
 * code.
 * @param url the url of the source map
 * @returns a linker string, of the format {@link JS_SOURCE_MAPPING_URL_LINKER}=<url>
 */
const getSourceMappingUrlLinker = (url) => {
  return `${JS_SOURCE_MAPPING_URL_LINKER}${encodeToRfc3986(url)}`;
};
/**
 * Generates a string used to link generated code with the original source, to be placed at the end of the generated
 * code as an inline source map.
 * @param sourceMapContents the sourceMapContents of the source map
 * @returns a linker string, of the format {@link JS_SOURCE_MAPPING_URL_LINKER}<dataUriPrefixAndMime><sourceMapContents>
 */
const getInlineSourceMappingUrlLinker = (sourceMapContents) => {
  const mapBase64 = Buffer.from(sourceMapContents, 'utf8').toString('base64');
  // do not RFC-3986 encode an already valid base64 string. the sourcemaps will not resolve correctly when there is an
  // allowed base64 character is encoded (because it is a disallowed RFC-3986 character)
  return `${JS_SOURCE_MAPPING_URL_LINKER}data:application/json;charset=utf-8;base64,${mapBase64}`;
};
/**
 * Generates a string used to link generated code with the original source, to be placed at the end of the generated
 * code. This function prepends a newline to the string.
 * @param url the url of the source map
 * @returns a linker string, of the format {@link JS_SOURCE_MAPPING_URL_LINKER}=<url>.map, prepended with a newline
 */
const getSourceMappingUrlForEndOfFile = (url) => {
  return `\n${getSourceMappingUrlLinker(url)}.map`;
};

let basename;
let dirname;
let extname$1;
let isAbsolute$1;
let join;
let normalize$1;
let parse$7;
let relative$1;
let resolve$1;
let sep;
let delimiter;
let posix$1;
let win32$1;
const path$5 = {};
const setPlatformPath = (platformPath) => {
  if (!platformPath) {
    platformPath = pathBrowserify;
  }
  Object.assign(path$5, platformPath);
  const normalizeOrg = path$5.normalize;
  const joinOrg = path$5.join;
  const relativeOrg = path$5.relative;
  const resolveOrg = path$5.resolve;
  normalize$1 = path$5.normalize = (...args) => normalizePath$1(normalizeOrg.apply(path$5, args));
  join = path$5.join = (...args) => normalizePath$1(joinOrg.apply(path$5, args));
  relative$1 = path$5.relative = (...args) => normalizePath$1(relativeOrg.apply(path$5, args));
  resolve$1 = path$5.resolve = (...args) => normalizePath$1(resolveOrg.apply(path$5, args));
  basename = path$5.basename;
  dirname = path$5.dirname;
  extname$1 = path$5.extname;
  isAbsolute$1 = path$5.isAbsolute;
  parse$7 = path$5.parse;
  sep = path$5.sep;
  delimiter = path$5.delimiter;
  posix$1 = path$5.posix;
  if (path$5.win32) {
    win32$1 = path$5.win32;
  }
  else {
    win32$1 = { ...posix$1 };
    win32$1.sep = '\\';
  }
};
setPlatformPath(IS_NODE_ENV ? requireFunc('path') : pathBrowserify);

const path$6 = {
  __proto__: null,
  get basename () { return basename; },
  get dirname () { return dirname; },
  get extname () { return extname$1; },
  get isAbsolute () { return isAbsolute$1; },
  get join () { return join; },
  get normalize () { return normalize$1; },
  get parse () { return parse$7; },
  get relative () { return relative$1; },
  get resolve () { return resolve$1; },
  get sep () { return sep; },
  get delimiter () { return delimiter; },
  get posix () { return posix$1; },
  get win32 () { return win32$1; },
  path: path$5,
  setPlatformPath: setPlatformPath,
  'default': path$5
};

var commonjsGlobal$1 = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function createCommonjsModule$1(fn, basedir, module) {
	return module = {
		path: basedir,
		exports: {},
		require: function (path, base) {
			return commonjsRequire$1();
		}
	}, fn(module, module.exports), module.exports;
}

function getAugmentedNamespace$1(n) {
	if (n.__esModule) return n;
	var a = Object.defineProperty({}, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

function commonjsRequire$1 () {
	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
}

// for now just expose the builtin process global from node.js
var process_1 = commonjsGlobal$1.process;

const process$3 = /*#__PURE__*/Object.assign(/*#__PURE__*/Object.create(null), process_1, {
  'default': process_1
});

const EOL = '\n';
const platform = () => OS_PLATFORM;
const os$2 = {
  EOL,
  platform,
};

const os$3 = {
  __proto__: null,
  EOL: EOL,
  platform: platform,
  'default': os$2
};

const buildEvents = () => {
  const evCallbacks = [];
  const off = (callback) => {
    const index = evCallbacks.findIndex((ev) => ev.callback === callback);
    if (index > -1) {
      evCallbacks.splice(index, 1);
      return true;
    }
    return false;
  };
  const on = (arg0, arg1) => {
    if (typeof arg0 === 'function') {
      const eventName = null;
      const callback = arg0;
      evCallbacks.push({
        eventName,
        callback,
      });
      return () => off(callback);
    }
    else if (typeof arg0 === 'string' && typeof arg1 === 'function') {
      const eventName = arg0.toLowerCase().trim();
      const callback = arg1;
      evCallbacks.push({
        eventName,
        callback,
      });
      return () => off(callback);
    }
    return () => false;
  };
  const emit = (eventName, data) => {
    const normalizedEventName = eventName.toLowerCase().trim();
    const callbacks = evCallbacks.slice();
    for (const ev of callbacks) {
      if (ev.eventName == null) {
        try {
          ev.callback(eventName, data);
        }
        catch (e) {
          console.error(e);
        }
      }
      else if (ev.eventName === normalizedEventName) {
        try {
          ev.callback(data);
        }
        catch (e) {
          console.error(e);
        }
      }
    }
  };
  const unsubscribeAll = () => {
    evCallbacks.length = 0;
  };
  return {
    emit,
    on,
    unsubscribeAll,
  };
};

/**
 * Creates an instance of a logger
 * @returns the new logger instance
 */
const createLogger = () => {
  let useColors = IS_BROWSER_ENV;
  let level = 'info';
  return {
    enableColors: (uc) => (useColors = uc),
    getLevel: () => level,
    setLevel: (l) => (level = l),
    emoji: (e) => e,
    info: console.log.bind(console),
    warn: console.warn.bind(console),
    error: console.error.bind(console),
    debug: console.debug.bind(console),
    red: (msg) => msg,
    green: (msg) => msg,
    yellow: (msg) => msg,
    blue: (msg) => msg,
    magenta: (msg) => msg,
    cyan: (msg) => msg,
    gray: (msg) => msg,
    bold: (msg) => msg,
    dim: (msg) => msg,
    bgRed: (msg) => msg,
    createTimeSpan: (_startMsg, _debug = false) => ({
      duration: () => 0,
      finish: () => 0,
    }),
    printDiagnostics(diagnostics) {
      diagnostics.forEach((diagnostic) => logDiagnostic(diagnostic, useColors));
    },
  };
};
const logDiagnostic = (diagnostic, useColors) => {
  let color = BLUE;
  let prefix = 'Build';
  let msg = '';
  if (diagnostic.level === 'error') {
    color = RED;
    prefix = 'Error';
  }
  else if (diagnostic.level === 'warn') {
    color = YELLOW;
    prefix = 'Warning';
  }
  if (diagnostic.header) {
    prefix = diagnostic.header;
  }
  const filePath = diagnostic.relFilePath || diagnostic.absFilePath;
  if (filePath) {
    msg += filePath;
    if (typeof diagnostic.lineNumber === 'number' && diagnostic.lineNumber > 0) {
      msg += ', line ' + diagnostic.lineNumber;
      if (typeof diagnostic.columnNumber === 'number' && diagnostic.columnNumber > 0) {
        msg += ', column ' + diagnostic.columnNumber;
      }
    }
    msg += '\n';
  }
  msg += diagnostic.messageText;
  if (diagnostic.lines && diagnostic.lines.length > 0) {
    diagnostic.lines.forEach((l) => {
      msg += '\n' + l.lineNumber + ':  ' + l.text;
    });
    msg += '\n';
  }
  if (useColors) {
    const styledPrefix = [
      '%c' + prefix,
      `background: ${color}; color: white; padding: 2px 3px; border-radius: 2px; font-size: 0.8em;`,
    ];
    console.log(...styledPrefix, msg);
  }
  else if (diagnostic.level === 'error') {
    console.error(msg);
  }
  else if (diagnostic.level === 'warn') {
    console.warn(msg);
  }
  else {
    console.log(msg);
  }
};
const YELLOW = `#f39c12`;
const RED = `#c0392b`;
const BLUE = `#3498db`;

const createWebWorkerMainController = (sys, maxConcurrentWorkers) => {
  let msgIds = 0;
  let isDestroyed = false;
  let isQueued = false;
  let workerIds = 0;
  let workerBlob;
  const tasks = new Map();
  const queuedSendMsgs = [];
  const workers = [];
  const maxWorkers = Math.max(Math.min(maxConcurrentWorkers, sys.hardwareConcurrency), 2) - 1;
  const tick = Promise.resolve();
  const onMsgsFromWorker = (worker, ev) => {
    if (!isDestroyed) {
      const msgsFromWorker = ev.data;
      if (Array.isArray(msgsFromWorker)) {
        for (const msgFromWorker of msgsFromWorker) {
          if (msgFromWorker) {
            const task = tasks.get(msgFromWorker.stencilId);
            if (task) {
              tasks.delete(msgFromWorker.stencilId);
              if (msgFromWorker.stencilRtnError) {
                task.reject(msgFromWorker.stencilRtnError);
              }
              else {
                task.resolve(msgFromWorker.stencilRtnValue);
              }
              worker.activeTasks--;
              if (worker.activeTasks < 0 || worker.activeTasks > 50) {
                worker.activeTasks = 0;
              }
            }
            else if (msgFromWorker.stencilRtnError) {
              console.error(msgFromWorker.stencilRtnError);
            }
          }
        }
      }
    }
  };
  const onWorkerError = (e) => console.error(e);
  const createWorkerMain = () => {
    let worker = null;
    const workerUrl = sys.getCompilerExecutingPath();
    const workerOpts = {
      name: `stencil.worker.${workerIds++}`,
    };
    try {
      // first try directly starting the worker with the URL
      worker = new Worker(workerUrl, workerOpts);
    }
    catch (e) {
      // probably a cross-origin issue, try using a Blob instead
      if (workerBlob == null) {
        workerBlob = new Blob([`importScripts('${workerUrl}');`], { type: 'application/javascript' });
      }
      worker = new Worker(URL.createObjectURL(workerBlob), workerOpts);
    }
    const workerChild = {
      worker,
      activeTasks: 0,
      sendQueue: [],
    };
    worker.onerror = onWorkerError;
    worker.onmessage = (ev) => onMsgsFromWorker(workerChild, ev);
    return workerChild;
  };
  const sendMsgsToWorkers = (w) => {
    if (w.sendQueue.length > 0) {
      w.worker.postMessage(w.sendQueue);
      w.sendQueue.length = 0;
    }
  };
  const queueMsgToWorker = (msg) => {
    let theChosenOne;
    if (workers.length > 0) {
      theChosenOne = workers[0];
      if (maxWorkers > 1) {
        for (const worker of workers) {
          if (worker.activeTasks < theChosenOne.activeTasks) {
            theChosenOne = worker;
          }
        }
        if (theChosenOne.activeTasks > 0 && workers.length < maxWorkers) {
          theChosenOne = createWorkerMain();
          workers.push(theChosenOne);
        }
      }
    }
    else {
      theChosenOne = createWorkerMain();
      workers.push(theChosenOne);
    }
    theChosenOne.activeTasks++;
    theChosenOne.sendQueue.push(msg);
  };
  const flushSendQueue = () => {
    isQueued = false;
    queuedSendMsgs.forEach(queueMsgToWorker);
    queuedSendMsgs.length = 0;
    workers.forEach(sendMsgsToWorkers);
  };
  const send = (...args) => new Promise((resolve, reject) => {
    if (isDestroyed) {
      reject(TASK_CANCELED_MSG);
    }
    else {
      const msg = {
        stencilId: msgIds++,
        args,
      };
      queuedSendMsgs.push(msg);
      tasks.set(msg.stencilId, {
        resolve,
        reject,
      });
      if (!isQueued) {
        isQueued = true;
        tick.then(flushSendQueue);
      }
    }
  });
  const destroy = () => {
    isDestroyed = true;
    tasks.forEach((t) => t.reject(TASK_CANCELED_MSG));
    tasks.clear();
    workers.forEach((w) => w.worker.terminate());
    workers.length = 0;
  };
  const handler = (name) => {
    return function (...args) {
      return send(name, ...args);
    };
  };
  return {
    send,
    destroy,
    handler,
    maxWorkers,
  };
};

const COMMON_DIR_MODULE_EXTS = ['.tsx', '.ts', '.mjs', '.js', '.jsx', '.json', '.md'];
const COMMON_DIR_FILENAMES = ['package.json', 'index.js', 'index.mjs'];
/**
 * Determine if a stringified file path is a TypeScript declaration file based on the extension at the end of the path.
 * @param p the path to evaluate
 * @returns `true` if the path ends in `.d.ts` (case-sensitive), `false` otherwise.
 */
const isDtsFile = (p) => p.endsWith('.d.ts');
/**
 * Determine if a stringified file path is a TypeScript file based on the extension at the end of the path. This
 * function does _not_ consider type declaration files (`.d.ts` files) to be TypeScript files.
 * @param p the path to evaluate
 * @returns `true` if the path ends in `.ts` (case-sensitive) but does _not_ end in `.d.ts`, `false` otherwise.
 */
const isTsFile = (p) => !isDtsFile(p) && p.endsWith('.ts');
/**
 * Determine if a stringified file path is a TSX file based on the extension at the end of the path
 * @param p the path to evaluate
 * @returns `true` if the path ends in `.tsx` (case-sensitive), `false` otherwise.
 */
const isTsxFile = (p) => p.endsWith('.tsx');
/**
 * Determine if a stringified file path is a JSX file based on the extension at the end of the path
 * @param p the path to evaluate
 * @returns `true` if the path ends in `.jsx` (case-sensitive), `false` otherwise.
 */
const isJsxFile = (p) => p.endsWith('.jsx');
/**
 * Determine if a stringified file path is a JavaScript file based on the extension at the end of the path
 * @param p the path to evaluate
 * @returns `true` if the path ends in `.js` (case-sensitive), `false` otherwise.
 */
const isJsFile = (p) => p.endsWith('.js');
const isJsonFile = (p) => p.endsWith('.json');
const getCommonDirName = (dirPath, fileName) => dirPath + '/' + fileName;
const isCommonDirModuleFile = (p) => COMMON_DIR_MODULE_EXTS.some((ext) => p.endsWith(ext));
const setPackageVersion = (pkgVersions, pkgName, pkgVersion) => {
  pkgVersions.set(pkgName, pkgVersion);
};
const setPackageVersionByContent = (pkgVersions, pkgContent) => {
  try {
    const pkg = JSON.parse(pkgContent);
    if (pkg.name && pkg.version) {
      setPackageVersion(pkgVersions, pkg.name, pkg.version);
    }
  }
  catch (e) { }
};
const isLocalModule = (p) => p.startsWith('.') || p.startsWith('/');
const isStencilCoreImport = (p) => p.startsWith('@stencil/core');
const shouldFetchModule = (p) => IS_FETCH_ENV && IS_BROWSER_ENV && isNodeModulePath(p);
const isNodeModulePath = (p) => normalizePath$1(p).split('/').includes('node_modules');
const getModuleId = (orgImport) => {
  if (orgImport.startsWith('~')) {
    orgImport = orgImport.substring(1);
  }
  const splt = orgImport.split('/');
  const m = {
    moduleId: null,
    filePath: null,
    scope: null,
    scopeSubModuleId: null,
  };
  if (orgImport.startsWith('@') && splt.length > 1) {
    m.moduleId = splt.slice(0, 2).join('/');
    m.filePath = splt.slice(2).join('/');
    m.scope = splt[0];
    m.scopeSubModuleId = splt[1];
  }
  else {
    m.moduleId = splt[0];
    m.filePath = splt.slice(1).join('/');
  }
  return m;
};
const getPackageDirPath = (p, moduleId) => {
  const parts = normalizePath$1(p).split('/');
  const m = getModuleId(moduleId);
  for (let i = parts.length - 1; i >= 1; i--) {
    if (parts[i - 1] === 'node_modules') {
      if (m.scope) {
        if (parts[i] === m.scope && parts[i + 1] === m.scopeSubModuleId) {
          return parts.slice(0, i + 2).join('/');
        }
      }
      else if (parts[i] === m.moduleId) {
        return parts.slice(0, i + 1).join('/');
      }
    }
  }
  return null;
};

/**
 * A fetch wrapper which dispatches to `sys.fetch` if present, and otherwise
 * uses `global.fetch`.
 *
 * @param sys a compiler system object
 * @param input a `RequestInfo` object
 * @param init an optional `RequestInit` object
 * @returns a Promise wrapping a response
 */
const httpFetch = (sys, input, init) => {
  if (sys && isFunction(sys.fetch)) {
    return sys.fetch(input, init);
  }
  return fetch(input, init);
};
const packageVersions = new Map();
const known404Urls = new Set();
/**
 * Get the URL for a Stencil module given the path to the compiler
 *
 * @param compilerExe the path to the compiler executable
 * @param path the path to the module or file in question
 * @returns a URL for the file of interest
 */
const getStencilModuleUrl = (compilerExe, path) => {
  path = normalizePath$1(path);
  let parts = path.split('/');
  const nmIndex = parts.lastIndexOf('node_modules');
  if (nmIndex > -1 && nmIndex < parts.length - 1) {
    parts = parts.slice(nmIndex + 1);
    if (parts[0].startsWith('@')) {
      parts = parts.slice(2);
    }
    else {
      parts = parts.slice(1);
    }
    path = parts.join('/');
  }
  const stencilRootUrl = new URL('../', compilerExe).href;
  return new URL('./' + path, stencilRootUrl).href;
};
const getCommonDirUrl = (sys, pkgVersions, dirPath, fileName) => getNodeModuleFetchUrl(sys, pkgVersions, dirPath) + '/' + fileName;
const getNodeModuleFetchUrl = (sys, pkgVersions, filePath) => {
  // /node_modules/lodash/package.json
  filePath = normalizePath$1(filePath);
  // ["node_modules", "lodash", "package.json"]
  let pathParts = filePath.split('/').filter((p) => p.length);
  const nmIndex = pathParts.lastIndexOf('node_modules');
  if (nmIndex > -1 && nmIndex < pathParts.length - 1) {
    pathParts = pathParts.slice(nmIndex + 1);
  }
  let moduleId = pathParts.shift();
  if (moduleId.startsWith('@')) {
    moduleId += '/' + pathParts.shift();
  }
  const path = pathParts.join('/');
  if (moduleId === '@stencil/core') {
    const compilerExe = sys.getCompilerExecutingPath();
    return getStencilModuleUrl(compilerExe, path);
  }
  return sys.getRemoteModuleUrl({
    moduleId,
    version: pkgVersions.get(moduleId),
    path,
  });
};
const skipFilePathFetch = (filePath) => {
  if (isTsFile(filePath) || isTsxFile(filePath)) {
    // don't bother trying to resolve  node_module packages w/ typescript files
    // they should already be .js files
    return true;
  }
  const pathParts = filePath.split('/');
  const secondToLast = pathParts[pathParts.length - 2];
  const lastPart = pathParts[pathParts.length - 1];
  if (secondToLast === 'node_modules' && isCommonDirModuleFile(lastPart)) {
    // /node_modules/index.js
    // /node_modules/lodash.js
    // we just already know this is bogus, so don't bother
    return true;
  }
  return false;
};
const skipUrlFetch = (url) => 
// files we just already know not to try to resolve request
knownUrlSkips.some((knownSkip) => url.endsWith(knownSkip));
const knownUrlSkips = [
  '/@stencil/core/internal.js',
  '/@stencil/core/internal.json',
  '/@stencil/core/internal.mjs',
  '/@stencil/core/internal/stencil-core.js/index.json',
  '/@stencil/core/internal/stencil-core.js.json',
  '/@stencil/core/internal/stencil-core.js/package.json',
  '/@stencil/core.js',
  '/@stencil/core.json',
  '/@stencil/core.mjs',
  '/@stencil/core.css',
  '/@stencil/core/index.js',
  '/@stencil/core/index.json',
  '/@stencil/core/index.mjs',
  '/@stencil/core/index.css',
  '/@stencil/package.json',
];

const writeFetchSuccessSync = (sys, inMemoryFs, url, filePath, content, pkgVersions) => {
  if (url.endsWith('package.json')) {
    setPackageVersionByContent(pkgVersions, content);
  }
  let dir = dirname(filePath);
  while (dir !== '/' && dir !== '') {
    if (inMemoryFs) {
      inMemoryFs.clearFileCache(dir);
      inMemoryFs.sys.createDirSync(dir);
    }
    else {
      sys.createDirSync(dir);
    }
    dir = dirname(dir);
  }
  if (inMemoryFs) {
    inMemoryFs.clearFileCache(filePath);
    inMemoryFs.sys.writeFileSync(filePath, content);
  }
  else {
    sys.writeFileSync(filePath, content);
  }
};
const writeFetchSuccessAsync = async (sys, inMemoryFs, url, filePath, content, pkgVersions) => {
  if (url.endsWith('package.json')) {
    setPackageVersionByContent(pkgVersions, content);
  }
  let dir = dirname(filePath);
  while (dir !== '/' && dir !== '') {
    if (inMemoryFs) {
      inMemoryFs.clearFileCache(dir);
      await inMemoryFs.sys.createDir(dir);
    }
    else {
      await sys.createDir(dir);
    }
    dir = dirname(dir);
  }
  if (inMemoryFs) {
    inMemoryFs.clearFileCache(filePath);
    await inMemoryFs.sys.writeFile(filePath, content);
  }
  else {
    await sys.writeFile(filePath, content);
  }
};

const fetchModuleAsync = async (sys, inMemoryFs, pkgVersions, url, filePath) => {
  if (skipFilePathFetch(filePath) || known404Urls.has(url) || skipUrlFetch(url)) {
    return undefined;
  }
  try {
    const rsp = await httpFetch(sys, url);
    if (rsp) {
      if (rsp.ok) {
        const content = await rsp.clone().text();
        await writeFetchSuccessAsync(sys, inMemoryFs, url, filePath, content, pkgVersions);
        return content;
      }
      if (rsp.status === 404) {
        known404Urls.add(url);
      }
    }
  }
  catch (e) {
    console.error(e);
  }
  return undefined;
};

const inherits$3 = (ctor, superCtor) => {
  if (superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true,
      },
    });
  }
};
const inspect = (...args) => args.forEach((arg) => console.log(arg));
const promisify = (fn) => {
  if (typeof fn[promisify.custom] === 'function') {
    // https://nodejs.org/api/util.html#util_custom_promisified_functions
    return function (...args) {
      return fn[promisify.custom].apply(this, args);
    };
  }
  return function (...args) {
    return new Promise((resolve, reject) => {
      args.push((err, result) => {
        if (err != null) {
          reject(err);
        }
        else {
          resolve(result);
        }
      });
      fn.apply(this, args);
    });
  };
};
promisify.custom = Symbol('promisify.custom');
const require$$0$1 = {
  inherits: inherits$3,
  inspect,
  promisify,
};

const util$4 = {
  __proto__: null,
  inherits: inherits$3,
  inspect: inspect,
  promisify: promisify,
  'default': require$$0$1
};

class FsError extends Error {
  constructor(syscall, path, code = 'ENOENT', errno = -2) {
    super(`ENOENT: no such file or directory, ${syscall} '${path}'`);
    this.syscall = syscall;
    this.path = path;
    this.code = code;
    this.errno = errno;
  }
}
const fs$3 = {
  __sys: {},
};
const exists$1 = (fs$3.exists = (p, cb) => {
  fs$3.__sys
    .access(p)
    .then(cb)
    .catch(() => cb(false));
});
// https://nodejs.org/api/util.html#util_custom_promisified_functions
exists$1[promisify.custom] = (p) => fs$3.__sys.access(p);
const existsSync = (fs$3.existsSync = (p) => {
  // https://nodejs.org/api/fs.html#fs_fs_existssync_path
  return fs$3.__sys.accessSync(p);
});
const mkdir = (fs$3.mkdir = (p, opts, cb) => {
  cb = typeof cb === 'function' ? cb : typeof opts === 'function' ? opts : null;
  opts = typeof opts === 'function' ? undefined : opts;
  fs$3.__sys
    .createDir(p, opts)
    .then((results) => {
    if (cb) {
      if (results.error) {
        cb(new FsError('mkdir', p));
      }
      else {
        cb(null);
      }
    }
  })
    .catch((e) => {
    cb && cb(e);
  });
});
const mkdirSync = (fs$3.mkdirSync = (p, opts) => {
  const results = fs$3.__sys.createDirSync(p, opts);
  if (results.error) {
    throw new FsError('mkdir', p);
  }
});
const readdirSync = (fs$3.readdirSync = (p) => {
  // sys.readdirSync includes full paths
  // but if fs.readdirSync was called, the expected
  // nodejs results are of just the basename for each dir item
  const dirItems = fs$3.__sys.readDirSync(p);
  return dirItems.map((dirItem) => basename(dirItem));
});
const readFile$2 = (fs$3.readFile = async (p, opts, cb) => {
  const encoding = typeof opts === 'object' ? opts.encoding : typeof opts === 'string' ? opts : 'utf-8';
  cb = typeof cb === 'function' ? cb : typeof opts === 'function' ? opts : null;
  fs$3.__sys
    .readFile(p, encoding)
    .then((data) => {
    if (cb) {
      if (typeof data === 'string') {
        cb(null, data);
      }
      else {
        cb(new FsError('open', p), data);
      }
    }
  })
    .catch((e) => {
    cb && cb(e);
  });
});
const readFileSync = (fs$3.readFileSync = (p, opts) => {
  const encoding = typeof opts === 'object' ? opts.encoding : typeof opts === 'string' ? opts : 'utf-8';
  const data = fs$3.__sys.readFileSync(p, encoding);
  if (typeof data !== 'string') {
    throw new FsError('open', p);
  }
  return data;
});
const realpath$3 = (fs$3.realpath = (p, opts, cb) => {
  cb = typeof cb === 'function' ? cb : typeof opts === 'function' ? opts : null;
  fs$3.__sys
    .realpath(p)
    .then((results) => {
    cb && cb(results.error, results.path);
  })
    .catch((e) => {
    cb && cb(e);
  });
});
const realpathSync$2 = (fs$3.realpathSync = (p) => {
  const results = fs$3.__sys.realpathSync(p);
  if (results.error) {
    throw results.error;
  }
  return normalizePath$1(results.path);
});
const statSync = (fs$3.statSync = (p) => {
  const fsStats = fs$3.__sys.statSync(p);
  if (fsStats.error) {
    throw new FsError('statSync', p);
  }
  return {
    isDirectory: () => fsStats.isDirectory,
    isFile: () => fsStats.isFile,
    isSymbolicLink: () => fsStats.isSymbolicLink,
    size: fsStats.size,
    mtimeMs: fsStats.mtimeMs,
  };
});
const lstatSync = (fs$3.lstatSync = statSync);
const stat$1 = (fs$3.stat = (p, opts, cb) => {
  cb = typeof cb === 'function' ? cb : typeof opts === 'function' ? opts : null;
  fs$3.__sys
    .stat(p)
    .then((fsStats) => {
    if (cb) {
      if (fsStats.error) {
        cb(new FsError('stat', p));
      }
      else {
        cb({
          isDirectory: () => fsStats.isDirectory,
          isFile: () => fsStats.isFile,
          isSymbolicLink: () => fsStats.isSymbolicLink,
          size: fsStats.size,
          mtimeMs: fsStats.mtimeMs,
        });
      }
    }
  })
    .catch((e) => {
    cb && cb(e);
  });
});
const watch = (fs$3.watch = () => {
  throw new Error(`fs.watch() not implemented`);
});
const writeFile$1 = (fs$3.writeFile = (p, data, opts, cb) => {
  cb = typeof cb === 'function' ? cb : typeof opts === 'function' ? opts : null;
  fs$3.__sys
    .writeFile(p, data)
    .then((writeResults) => {
    if (cb) {
      if (writeResults.error) {
        cb(new FsError('writeFile', p));
      }
      else {
        cb(null);
      }
    }
  })
    .catch((e) => {
    cb && cb(e);
  });
});

const fs$4 = {
  __proto__: null,
  exists: exists$1,
  existsSync: existsSync,
  mkdir: mkdir,
  mkdirSync: mkdirSync,
  readdirSync: readdirSync,
  readFile: readFile$2,
  readFileSync: readFileSync,
  realpath: realpath$3,
  realpathSync: realpathSync$2,
  statSync: statSync,
  lstatSync: lstatSync,
  stat: stat$1,
  watch: watch,
  writeFile: writeFile$1,
  'default': fs$3
};

var caller = function () {
  // see https://code.google.com/p/v8/wiki/JavaScriptStackTraceApi
  var origPrepareStackTrace = Error.prepareStackTrace;
  Error.prepareStackTrace = function (_, stack) { return stack; };
  var stack = (new Error()).stack;
  Error.prepareStackTrace = origPrepareStackTrace;
  return stack[2].getFileName();
};

var pathParse = createCommonjsModule$1(function (module) {

var isWindows = process.platform === 'win32';

// Regex to split a windows path into into [dir, root, basename, name, ext]
var splitWindowsRe =
  /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;

var win32 = {};

function win32SplitPath(filename) {
  return splitWindowsRe.exec(filename).slice(1);
}

win32.parse = function(pathString) {
  if (typeof pathString !== 'string') {
  throw new TypeError(
    "Parameter 'pathString' must be a string, not " + typeof pathString
  );
  }
  var allParts = win32SplitPath(pathString);
  if (!allParts || allParts.length !== 5) {
  throw new TypeError("Invalid path '" + pathString + "'");
  }
  return {
  root: allParts[1],
  dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
  base: allParts[2],
  ext: allParts[4],
  name: allParts[3]
  };
};



// Split a filename into [dir, root, basename, name, ext], unix version
// 'root' is just a slash, or nothing.
var splitPathRe =
  /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
var posix = {};


function posixSplitPath(filename) {
  return splitPathRe.exec(filename).slice(1);
}


posix.parse = function(pathString) {
  if (typeof pathString !== 'string') {
  throw new TypeError(
    "Parameter 'pathString' must be a string, not " + typeof pathString
  );
  }
  var allParts = posixSplitPath(pathString);
  if (!allParts || allParts.length !== 5) {
  throw new TypeError("Invalid path '" + pathString + "'");
  }
  
  return {
  root: allParts[1],
  dir: allParts[0].slice(0, -1),
  base: allParts[2],
  ext: allParts[4],
  name: allParts[3],
  };
};


if (isWindows)
  module.exports = win32.parse;
else /* posix */
  module.exports = posix.parse;

module.exports.posix = posix.parse;
module.exports.win32 = win32.parse;
});

const path$4 = /*@__PURE__*/getAugmentedNamespace$1(path$6);

var parse$6 = path$4.parse || pathParse;

var getNodeModulesDirs = function getNodeModulesDirs(absoluteStart, modules) {
  var prefix = '/';
  if ((/^([A-Za-z]:)/).test(absoluteStart)) {
    prefix = '';
  } else if ((/^\\\\/).test(absoluteStart)) {
    prefix = '\\\\';
  }

  var paths = [absoluteStart];
  var parsed = parse$6(absoluteStart);
  while (parsed.dir !== paths[paths.length - 1]) {
    paths.push(parsed.dir);
    parsed = parse$6(parsed.dir);
  }

  return paths.reduce(function (dirs, aPath) {
    return dirs.concat(modules.map(function (moduleDir) {
      return path$4.resolve(prefix, aPath, moduleDir);
    }));
  }, []);
};

var nodeModulesPaths = function nodeModulesPaths(start, opts, request) {
  var modules = opts && opts.moduleDirectory
    ? [].concat(opts.moduleDirectory)
    : ['node_modules'];

  if (opts && typeof opts.paths === 'function') {
    return opts.paths(
      request,
      start,
      function () { return getNodeModulesDirs(start, modules); },
      opts
    );
  }

  var dirs = getNodeModulesDirs(start, modules);
  return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
};

var normalizeOptions = function (x, opts) {
  /**
   * This file is purposefully a passthrough. It's expected that third-party
   * environments will override it at runtime in order to inject special logic
   * into `resolve` (by manipulating the options). One such example is the PnP
   * code path in Yarn.
   */

  return opts || {};
};

/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var slice$1 = Array.prototype.slice;
var toStr = Object.prototype.toString;
var funcType = '[object Function]';

var implementation = function bind(that) {
  var target = this;
  if (typeof target !== 'function' || toStr.call(target) !== funcType) {
    throw new TypeError(ERROR_MESSAGE + target);
  }
  var args = slice$1.call(arguments, 1);

  var bound;
  var binder = function () {
    if (this instanceof bound) {
      var result = target.apply(
        this,
        args.concat(slice$1.call(arguments))
      );
      if (Object(result) === result) {
        return result;
      }
      return this;
    } else {
      return target.apply(
        that,
        args.concat(slice$1.call(arguments))
      );
    }
  };

  var boundLength = Math.max(0, target.length - args.length);
  var boundArgs = [];
  for (var i = 0; i < boundLength; i++) {
    boundArgs.push('$' + i);
  }

  bound = Function('binder', 'return function (' + boundArgs.join(',') + '){ return binder.apply(this,arguments); }')(binder);

  if (target.prototype) {
    var Empty = function Empty() {};
    Empty.prototype = target.prototype;
    bound.prototype = new Empty();
    Empty.prototype = null;
  }

  return bound;
};

var functionBind = Function.prototype.bind || implementation;

var src = functionBind.call(Function.call, Object.prototype.hasOwnProperty);

const assert$2 = true;
const async_hooks$1 = ">= 8";
const buffer_ieee754$1 = "< 0.9.7";
const buffer$1 = true;
const child_process$1 = true;
const cluster$1 = true;
const console$2 = true;
const constants$2 = true;
const crypto$2 = true;
const _debug_agent$1 = ">= 1 && < 8";
const _debugger$1 = "< 8";
const dgram$1 = true;
const diagnostics_channel$1 = ">= 15.1";
const dns$1 = true;
const domain$1 = ">= 0.7.12";
const events$2 = true;
const freelist$1 = "< 6";
const fs$2 = true;
const _http_agent$1 = ">= 0.11.1";
const _http_client$1 = ">= 0.11.1";
const _http_common$1 = ">= 0.11.1";
const _http_incoming$1 = ">= 0.11.1";
const _http_outgoing$1 = ">= 0.11.1";
const _http_server$1 = ">= 0.11.1";
const http$1 = true;
const http2$1 = ">= 8.8";
const https$1 = true;
const inspector$1 = ">= 8.0.0";
const _linklist$1 = "< 8";
const module$2 = true;
const net$1 = true;
const os$1 = true;
const path$3 = true;
const perf_hooks$1 = ">= 8.5";
const process$2 = ">= 1";
const punycode$1 = true;
const querystring$1 = true;
const readline$1 = true;
const repl$1 = true;
const smalloc$1 = ">= 0.11.5 && < 3";
const _stream_duplex$1 = ">= 0.9.4";
const _stream_transform$1 = ">= 0.9.4";
const _stream_wrap$1 = ">= 1.4.1";
const _stream_passthrough$1 = ">= 0.9.4";
const _stream_readable$1 = ">= 0.9.4";
const _stream_writable$1 = ">= 0.9.4";
const stream$1 = true;
const string_decoder$1 = true;
const sys$1 = [
	">= 0.6 && < 0.7",
	">= 0.8"
];
const timers$2 = true;
const _tls_common$1 = ">= 0.11.13";
const _tls_legacy$1 = ">= 0.11.3 && < 10";
const _tls_wrap$1 = ">= 0.11.3";
const tls$1 = true;
const trace_events$1 = ">= 10";
const tty$1 = true;
const url$1 = true;
const util$3 = true;
const v8$1 = ">= 1";
const vm$1 = true;
const wasi$1 = ">= 13.4 && < 13.5";
const worker_threads$1 = ">= 11.7";
const zlib$1 = true;
const data$2 = {
	assert: assert$2,
	"assert/strict": ">= 15",
	async_hooks: async_hooks$1,
	buffer_ieee754: buffer_ieee754$1,
	buffer: buffer$1,
	child_process: child_process$1,
	cluster: cluster$1,
	console: console$2,
	constants: constants$2,
	crypto: crypto$2,
	_debug_agent: _debug_agent$1,
	_debugger: _debugger$1,
	dgram: dgram$1,
	diagnostics_channel: diagnostics_channel$1,
	dns: dns$1,
	"dns/promises": ">= 15",
	domain: domain$1,
	events: events$2,
	freelist: freelist$1,
	fs: fs$2,
	"fs/promises": [
	">= 10 && < 10.1",
	">= 14"
],
	_http_agent: _http_agent$1,
	_http_client: _http_client$1,
	_http_common: _http_common$1,
	_http_incoming: _http_incoming$1,
	_http_outgoing: _http_outgoing$1,
	_http_server: _http_server$1,
	http: http$1,
	http2: http2$1,
	https: https$1,
	inspector: inspector$1,
	_linklist: _linklist$1,
	module: module$2,
	net: net$1,
	"node-inspect/lib/_inspect": ">= 7.6.0 && < 12",
	"node-inspect/lib/internal/inspect_client": ">= 7.6.0 && < 12",
	"node-inspect/lib/internal/inspect_repl": ">= 7.6.0 && < 12",
	os: os$1,
	path: path$3,
	"path/posix": ">= 15.3",
	"path/win32": ">= 15.3",
	perf_hooks: perf_hooks$1,
	process: process$2,
	punycode: punycode$1,
	querystring: querystring$1,
	readline: readline$1,
	repl: repl$1,
	smalloc: smalloc$1,
	_stream_duplex: _stream_duplex$1,
	_stream_transform: _stream_transform$1,
	_stream_wrap: _stream_wrap$1,
	_stream_passthrough: _stream_passthrough$1,
	_stream_readable: _stream_readable$1,
	_stream_writable: _stream_writable$1,
	stream: stream$1,
	"stream/promises": ">= 15",
	string_decoder: string_decoder$1,
	sys: sys$1,
	timers: timers$2,
	"timers/promises": ">= 15",
	_tls_common: _tls_common$1,
	_tls_legacy: _tls_legacy$1,
	_tls_wrap: _tls_wrap$1,
	tls: tls$1,
	trace_events: trace_events$1,
	tty: tty$1,
	url: url$1,
	util: util$3,
	"util/types": ">= 15.3",
	"v8/tools/arguments": ">= 10 && < 12",
	"v8/tools/codemap": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/consarray": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/csvparser": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/logreader": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/profile_view": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/splaytree": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	v8: v8$1,
	vm: vm$1,
	wasi: wasi$1,
	worker_threads: worker_threads$1,
	zlib: zlib$1
};

function specifierIncluded$1(current, specifier) {
	var nodeParts = current.split('.');
	var parts = specifier.split(' ');
	var op = parts.length > 1 ? parts[0] : '=';
	var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split('.');

	for (var i = 0; i < 3; ++i) {
		var cur = parseInt(nodeParts[i] || 0, 10);
		var ver = parseInt(versionParts[i] || 0, 10);
		if (cur === ver) {
			continue; // eslint-disable-line no-restricted-syntax, no-continue
		}
		if (op === '<') {
			return cur < ver;
		}
		if (op === '>=') {
			return cur >= ver;
		}
		return false;
	}
	return op === '>=';
}

function matchesRange$1(current, range) {
	var specifiers = range.split(/ ?&& ?/);
	if (specifiers.length === 0) {
		return false;
	}
	for (var i = 0; i < specifiers.length; ++i) {
		if (!specifierIncluded$1(current, specifiers[i])) {
			return false;
		}
	}
	return true;
}

function versionIncluded$1(nodeVersion, specifierValue) {
	if (typeof specifierValue === 'boolean') {
		return specifierValue;
	}

	var current = typeof nodeVersion === 'undefined'
		? process.versions && process.versions.node && process.versions.node
		: nodeVersion;

	if (typeof current !== 'string') {
		throw new TypeError(typeof nodeVersion === 'undefined' ? 'Unable to determine current node version' : 'If provided, a valid node version is required');
	}

	if (specifierValue && typeof specifierValue === 'object') {
		for (var i = 0; i < specifierValue.length; ++i) {
			if (matchesRange$1(current, specifierValue[i])) {
				return true;
			}
		}
		return false;
	}
	return matchesRange$1(current, specifierValue);
}



var isCoreModule = function isCore(x, nodeVersion) {
	return src(data$2, x) && versionIncluded$1(nodeVersion, data$2[x]);
};

const fs$1 = /*@__PURE__*/getAugmentedNamespace$1(fs$4);

var realpathFS$1 = fs$1.realpath && typeof fs$1.realpath.native === 'function' ? fs$1.realpath.native : fs$1.realpath;

var defaultIsFile$1 = function isFile(file, cb) {
  fs$1.stat(file, function (err, stat) {
    if (!err) {
      return cb(null, stat.isFile() || stat.isFIFO());
    }
    if (err.code === 'ENOENT' || err.code === 'ENOTDIR') return cb(null, false);
    return cb(err);
  });
};

var defaultIsDir$1 = function isDirectory(dir, cb) {
  fs$1.stat(dir, function (err, stat) {
    if (!err) {
      return cb(null, stat.isDirectory());
    }
    if (err.code === 'ENOENT' || err.code === 'ENOTDIR') return cb(null, false);
    return cb(err);
  });
};

var defaultRealpath = function realpath(x, cb) {
  realpathFS$1(x, function (realpathErr, realPath) {
    if (realpathErr && realpathErr.code !== 'ENOENT') cb(realpathErr);
    else cb(null, realpathErr ? x : realPath);
  });
};

var maybeRealpath = function maybeRealpath(realpath, x, opts, cb) {
  if (opts && opts.preserveSymlinks === false) {
    realpath(x, cb);
  } else {
    cb(null, x);
  }
};

var defaultReadPackage = function defaultReadPackage(readFile, pkgfile, cb) {
  readFile(pkgfile, function (readFileErr, body) {
    if (readFileErr) cb(readFileErr);
    else {
      try {
        var pkg = JSON.parse(body);
        cb(null, pkg);
      } catch (jsonErr) {
        cb(null);
      }
    }
  });
};

var getPackageCandidates$1 = function getPackageCandidates(x, start, opts) {
  var dirs = nodeModulesPaths(start, opts, x);
  for (var i = 0; i < dirs.length; i++) {
    dirs[i] = path$4.join(dirs[i], x);
  }
  return dirs;
};

var async = function resolve(x, options, callback) {
  var cb = callback;
  var opts = options;
  if (typeof options === 'function') {
    cb = opts;
    opts = {};
  }
  if (typeof x !== 'string') {
    var err = new TypeError('Path must be a string.');
    return process.nextTick(function () {
      cb(err);
    });
  }

  opts = normalizeOptions(x, opts);

  var isFile = opts.isFile || defaultIsFile$1;
  var isDirectory = opts.isDirectory || defaultIsDir$1;
  var readFile = opts.readFile || fs$1.readFile;
  var realpath = opts.realpath || defaultRealpath;
  var readPackage = opts.readPackage || defaultReadPackage;
  if (opts.readFile && opts.readPackage) {
    var conflictErr = new TypeError('`readFile` and `readPackage` are mutually exclusive.');
    return process.nextTick(function () {
      cb(conflictErr);
    });
  }
  var packageIterator = opts.packageIterator;

  var extensions = opts.extensions || ['.js'];
  var includeCoreModules = opts.includeCoreModules !== false;
  var basedir = opts.basedir || path$4.dirname(caller());
  var parent = opts.filename || basedir;

  opts.paths = opts.paths || [];

  // ensure that `basedir` is an absolute path at this point, resolving against the process' current working directory
  var absoluteStart = path$4.resolve(basedir);

  maybeRealpath(
    realpath,
    absoluteStart,
    opts,
    function (err, realStart) {
      if (err) cb(err);
      else init(realStart);
    }
  );

  var res;
  function init(basedir) {
    if ((/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/).test(x)) {
      res = path$4.resolve(basedir, x);
      if (x === '.' || x === '..' || x.slice(-1) === '/') res += '/';
      if ((/\/$/).test(x) && res === basedir) {
        loadAsDirectory(res, opts.package, onfile);
      } else loadAsFile(res, opts.package, onfile);
    } else if (includeCoreModules && isCoreModule(x)) {
      return cb(null, x);
    } else loadNodeModules(x, basedir, function (err, n, pkg) {
      if (err) cb(err);
      else if (n) {
        return maybeRealpath(realpath, n, opts, function (err, realN) {
          if (err) {
            cb(err);
          } else {
            cb(null, realN, pkg);
          }
        });
      } else {
        var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
        moduleError.code = 'MODULE_NOT_FOUND';
        cb(moduleError);
      }
    });
  }

  function onfile(err, m, pkg) {
    if (err) cb(err);
    else if (m) cb(null, m, pkg);
    else loadAsDirectory(res, function (err, d, pkg) {
      if (err) cb(err);
      else if (d) {
        maybeRealpath(realpath, d, opts, function (err, realD) {
          if (err) {
            cb(err);
          } else {
            cb(null, realD, pkg);
          }
        });
      } else {
        var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
        moduleError.code = 'MODULE_NOT_FOUND';
        cb(moduleError);
      }
    });
  }

  function loadAsFile(x, thePackage, callback) {
    var loadAsFilePackage = thePackage;
    var cb = callback;
    if (typeof loadAsFilePackage === 'function') {
      cb = loadAsFilePackage;
      loadAsFilePackage = undefined;
    }

    var exts = [''].concat(extensions);
    load(exts, x, loadAsFilePackage);

    function load(exts, x, loadPackage) {
      if (exts.length === 0) return cb(null, undefined, loadPackage);
      var file = x + exts[0];

      var pkg = loadPackage;
      if (pkg) onpkg(null, pkg);
      else loadpkg(path$4.dirname(file), onpkg);

      function onpkg(err, pkg_, dir) {
        pkg = pkg_;
        if (err) return cb(err);
        if (dir && pkg && opts.pathFilter) {
          var rfile = path$4.relative(dir, file);
          var rel = rfile.slice(0, rfile.length - exts[0].length);
          var r = opts.pathFilter(pkg, x, rel);
          if (r) return load(
            [''].concat(extensions.slice()),
            path$4.resolve(dir, r),
            pkg
          );
        }
        isFile(file, onex);
      }
      function onex(err, ex) {
        if (err) return cb(err);
        if (ex) return cb(null, file, pkg);
        load(exts.slice(1), x, pkg);
      }
    }
  }

  function loadpkg(dir, cb) {
    if (dir === '' || dir === '/') return cb(null);
    if (process.platform === 'win32' && (/^\w:[/\\]*$/).test(dir)) {
      return cb(null);
    }
    if ((/[/\\]node_modules[/\\]*$/).test(dir)) return cb(null);

    maybeRealpath(realpath, dir, opts, function (unwrapErr, pkgdir) {
      if (unwrapErr) return loadpkg(path$4.dirname(dir), cb);
      var pkgfile = path$4.join(pkgdir, 'package.json');
      isFile(pkgfile, function (err, ex) {
        // on err, ex is false
        if (!ex) return loadpkg(path$4.dirname(dir), cb);

        readPackage(readFile, pkgfile, function (err, pkgParam) {
          if (err) cb(err);

          var pkg = pkgParam;

          if (pkg && opts.packageFilter) {
            pkg = opts.packageFilter(pkg, pkgfile);
          }
          cb(null, pkg, dir);
        });
      });
    });
  }

  function loadAsDirectory(x, loadAsDirectoryPackage, callback) {
    var cb = callback;
    var fpkg = loadAsDirectoryPackage;
    if (typeof fpkg === 'function') {
      cb = fpkg;
      fpkg = opts.package;
    }

    maybeRealpath(realpath, x, opts, function (unwrapErr, pkgdir) {
      if (unwrapErr) return cb(unwrapErr);
      var pkgfile = path$4.join(pkgdir, 'package.json');
      isFile(pkgfile, function (err, ex) {
        if (err) return cb(err);
        if (!ex) return loadAsFile(path$4.join(x, 'index'), fpkg, cb);

        readPackage(readFile, pkgfile, function (err, pkgParam) {
          if (err) return cb(err);

          var pkg = pkgParam;

          if (pkg && opts.packageFilter) {
            pkg = opts.packageFilter(pkg, pkgfile);
          }

          if (pkg && pkg.main) {
            if (typeof pkg.main !== 'string') {
              var mainError = new TypeError('package “' + pkg.name + '” `main` must be a string');
              mainError.code = 'INVALID_PACKAGE_MAIN';
              return cb(mainError);
            }
            if (pkg.main === '.' || pkg.main === './') {
              pkg.main = 'index';
            }
            loadAsFile(path$4.resolve(x, pkg.main), pkg, function (err, m, pkg) {
              if (err) return cb(err);
              if (m) return cb(null, m, pkg);
              if (!pkg) return loadAsFile(path$4.join(x, 'index'), pkg, cb);

              var dir = path$4.resolve(x, pkg.main);
              loadAsDirectory(dir, pkg, function (err, n, pkg) {
                if (err) return cb(err);
                if (n) return cb(null, n, pkg);
                loadAsFile(path$4.join(x, 'index'), pkg, cb);
              });
            });
            return;
          }

          loadAsFile(path$4.join(x, '/index'), pkg, cb);
        });
      });
    });
  }

  function processDirs(cb, dirs) {
    if (dirs.length === 0) return cb(null, undefined);
    var dir = dirs[0];

    isDirectory(path$4.dirname(dir), isdir);

    function isdir(err, isdir) {
      if (err) return cb(err);
      if (!isdir) return processDirs(cb, dirs.slice(1));
      loadAsFile(dir, opts.package, onfile);
    }

    function onfile(err, m, pkg) {
      if (err) return cb(err);
      if (m) return cb(null, m, pkg);
      loadAsDirectory(dir, opts.package, ondir);
    }

    function ondir(err, n, pkg) {
      if (err) return cb(err);
      if (n) return cb(null, n, pkg);
      processDirs(cb, dirs.slice(1));
    }
  }
  function loadNodeModules(x, start, cb) {
    var thunk = function () { return getPackageCandidates$1(x, start, opts); };
    processDirs(
      cb,
      packageIterator ? packageIterator(x, start, thunk, opts) : thunk()
    );
  }
};

const assert$1 = true;
const async_hooks = ">= 8";
const buffer_ieee754 = "< 0.9.7";
const buffer = true;
const child_process = true;
const cluster = true;
const console$1 = true;
const constants$1 = true;
const crypto$1 = true;
const _debug_agent = ">= 1 && < 8";
const _debugger = "< 8";
const dgram = true;
const diagnostics_channel = ">= 15.1";
const dns = true;
const domain = ">= 0.7.12";
const events$1 = true;
const freelist = "< 6";
const fs = true;
const _http_agent = ">= 0.11.1";
const _http_client = ">= 0.11.1";
const _http_common = ">= 0.11.1";
const _http_incoming = ">= 0.11.1";
const _http_outgoing = ">= 0.11.1";
const _http_server = ">= 0.11.1";
const http = true;
const http2 = ">= 8.8";
const https = true;
const inspector = ">= 8.0.0";
const _linklist = "< 8";
const module$1 = true;
const net = true;
const os = true;
const path$2 = true;
const perf_hooks = ">= 8.5";
const process$1 = ">= 1";
const punycode = true;
const querystring = true;
const readline = true;
const repl = true;
const smalloc = ">= 0.11.5 && < 3";
const _stream_duplex = ">= 0.9.4";
const _stream_transform = ">= 0.9.4";
const _stream_wrap = ">= 1.4.1";
const _stream_passthrough = ">= 0.9.4";
const _stream_readable = ">= 0.9.4";
const _stream_writable = ">= 0.9.4";
const stream = true;
const string_decoder = true;
const sys = [
	">= 0.6 && < 0.7",
	">= 0.8"
];
const timers$1 = true;
const _tls_common = ">= 0.11.13";
const _tls_legacy = ">= 0.11.3 && < 10";
const _tls_wrap = ">= 0.11.3";
const tls = true;
const trace_events = ">= 10";
const tty = true;
const url = true;
const util$2 = true;
const v8 = ">= 1";
const vm = true;
const wasi = ">= 13.4 && < 13.5";
const worker_threads = ">= 11.7";
const zlib = true;
const data$1 = {
	assert: assert$1,
	"assert/strict": ">= 15",
	async_hooks: async_hooks,
	buffer_ieee754: buffer_ieee754,
	buffer: buffer,
	child_process: child_process,
	cluster: cluster,
	console: console$1,
	constants: constants$1,
	crypto: crypto$1,
	_debug_agent: _debug_agent,
	_debugger: _debugger,
	dgram: dgram,
	diagnostics_channel: diagnostics_channel,
	dns: dns,
	"dns/promises": ">= 15",
	domain: domain,
	events: events$1,
	freelist: freelist,
	fs: fs,
	"fs/promises": [
	">= 10 && < 10.1",
	">= 14"
],
	_http_agent: _http_agent,
	_http_client: _http_client,
	_http_common: _http_common,
	_http_incoming: _http_incoming,
	_http_outgoing: _http_outgoing,
	_http_server: _http_server,
	http: http,
	http2: http2,
	https: https,
	inspector: inspector,
	_linklist: _linklist,
	module: module$1,
	net: net,
	"node-inspect/lib/_inspect": ">= 7.6.0 && < 12",
	"node-inspect/lib/internal/inspect_client": ">= 7.6.0 && < 12",
	"node-inspect/lib/internal/inspect_repl": ">= 7.6.0 && < 12",
	os: os,
	path: path$2,
	"path/posix": ">= 15.3",
	"path/win32": ">= 15.3",
	perf_hooks: perf_hooks,
	process: process$1,
	punycode: punycode,
	querystring: querystring,
	readline: readline,
	repl: repl,
	smalloc: smalloc,
	_stream_duplex: _stream_duplex,
	_stream_transform: _stream_transform,
	_stream_wrap: _stream_wrap,
	_stream_passthrough: _stream_passthrough,
	_stream_readable: _stream_readable,
	_stream_writable: _stream_writable,
	stream: stream,
	"stream/promises": ">= 15",
	string_decoder: string_decoder,
	sys: sys,
	timers: timers$1,
	"timers/promises": ">= 15",
	_tls_common: _tls_common,
	_tls_legacy: _tls_legacy,
	_tls_wrap: _tls_wrap,
	tls: tls,
	trace_events: trace_events,
	tty: tty,
	url: url,
	util: util$2,
	"util/types": ">= 15.3",
	"v8/tools/arguments": ">= 10 && < 12",
	"v8/tools/codemap": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/consarray": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/csvparser": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/logreader": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/profile_view": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	"v8/tools/splaytree": [
	">= 4.4.0 && < 5",
	">= 5.2.0 && < 12"
],
	v8: v8,
	vm: vm,
	wasi: wasi,
	worker_threads: worker_threads,
	zlib: zlib
};

var current = (process.versions && process.versions.node && process.versions.node.split('.')) || [];

function specifierIncluded(specifier) {
  var parts = specifier.split(' ');
  var op = parts.length > 1 ? parts[0] : '=';
  var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split('.');

  for (var i = 0; i < 3; ++i) {
    var cur = parseInt(current[i] || 0, 10);
    var ver = parseInt(versionParts[i] || 0, 10);
    if (cur === ver) {
      continue; // eslint-disable-line no-restricted-syntax, no-continue
    }
    if (op === '<') {
      return cur < ver;
    } else if (op === '>=') {
      return cur >= ver;
    } else {
      return false;
    }
  }
  return op === '>=';
}

function matchesRange(range) {
  var specifiers = range.split(/ ?&& ?/);
  if (specifiers.length === 0) { return false; }
  for (var i = 0; i < specifiers.length; ++i) {
    if (!specifierIncluded(specifiers[i])) { return false; }
  }
  return true;
}

function versionIncluded(specifierValue) {
  if (typeof specifierValue === 'boolean') { return specifierValue; }
  if (specifierValue && typeof specifierValue === 'object') {
    for (var i = 0; i < specifierValue.length; ++i) {
      if (matchesRange(specifierValue[i])) { return true; }
    }
    return false;
  }
  return matchesRange(specifierValue);
}



var core = {};
for (var mod in data$1) { // eslint-disable-line no-restricted-syntax
  if (Object.prototype.hasOwnProperty.call(data$1, mod)) {
    core[mod] = versionIncluded(data$1[mod]);
  }
}
var core_1 = core;

var isCore = function isCore(x) {
  return isCoreModule(x);
};

var realpathFS = fs$1.realpathSync && typeof fs$1.realpathSync.native === 'function' ? fs$1.realpathSync.native : fs$1.realpathSync;

var defaultIsFile = function isFile(file) {
  try {
    var stat = fs$1.statSync(file);
  } catch (e) {
    if (e && (e.code === 'ENOENT' || e.code === 'ENOTDIR')) return false;
    throw e;
  }
  return stat.isFile() || stat.isFIFO();
};

var defaultIsDir = function isDirectory(dir) {
  try {
    var stat = fs$1.statSync(dir);
  } catch (e) {
    if (e && (e.code === 'ENOENT' || e.code === 'ENOTDIR')) return false;
    throw e;
  }
  return stat.isDirectory();
};

var defaultRealpathSync = function realpathSync(x) {
  try {
    return realpathFS(x);
  } catch (realpathErr) {
    if (realpathErr.code !== 'ENOENT') {
      throw realpathErr;
    }
  }
  return x;
};

var maybeRealpathSync = function maybeRealpathSync(realpathSync, x, opts) {
  if (opts && opts.preserveSymlinks === false) {
    return realpathSync(x);
  }
  return x;
};

var defaultReadPackageSync = function defaultReadPackageSync(readFileSync, pkgfile) {
  var body = readFileSync(pkgfile);
  try {
    var pkg = JSON.parse(body);
    return pkg;
  } catch (jsonErr) {}
};

var getPackageCandidates = function getPackageCandidates(x, start, opts) {
  var dirs = nodeModulesPaths(start, opts, x);
  for (var i = 0; i < dirs.length; i++) {
    dirs[i] = path$4.join(dirs[i], x);
  }
  return dirs;
};

var sync$1 = function resolveSync(x, options) {
  if (typeof x !== 'string') {
    throw new TypeError('Path must be a string.');
  }
  var opts = normalizeOptions(x, options);

  var isFile = opts.isFile || defaultIsFile;
  var readFileSync = opts.readFileSync || fs$1.readFileSync;
  var isDirectory = opts.isDirectory || defaultIsDir;
  var realpathSync = opts.realpathSync || defaultRealpathSync;
  var readPackageSync = opts.readPackageSync || defaultReadPackageSync;
  if (opts.readFileSync && opts.readPackageSync) {
    throw new TypeError('`readFileSync` and `readPackageSync` are mutually exclusive.');
  }
  var packageIterator = opts.packageIterator;

  var extensions = opts.extensions || ['.js'];
  var includeCoreModules = opts.includeCoreModules !== false;
  var basedir = opts.basedir || path$4.dirname(caller());
  var parent = opts.filename || basedir;

  opts.paths = opts.paths || [];

  // ensure that `basedir` is an absolute path at this point, resolving against the process' current working directory
  var absoluteStart = maybeRealpathSync(realpathSync, path$4.resolve(basedir), opts);

  if ((/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/).test(x)) {
    var res = path$4.resolve(absoluteStart, x);
    if (x === '.' || x === '..' || x.slice(-1) === '/') res += '/';
    var m = loadAsFileSync(res) || loadAsDirectorySync(res);
    if (m) return maybeRealpathSync(realpathSync, m, opts);
  } else if (includeCoreModules && isCoreModule(x)) {
    return x;
  } else {
    var n = loadNodeModulesSync(x, absoluteStart);
    if (n) return maybeRealpathSync(realpathSync, n, opts);
  }

  var err = new Error("Cannot find module '" + x + "' from '" + parent + "'");
  err.code = 'MODULE_NOT_FOUND';
  throw err;

  function loadAsFileSync(x) {
    var pkg = loadpkg(path$4.dirname(x));

    if (pkg && pkg.dir && pkg.pkg && opts.pathFilter) {
      var rfile = path$4.relative(pkg.dir, x);
      var r = opts.pathFilter(pkg.pkg, x, rfile);
      if (r) {
        x = path$4.resolve(pkg.dir, r); // eslint-disable-line no-param-reassign
      }
    }

    if (isFile(x)) {
      return x;
    }

    for (var i = 0; i < extensions.length; i++) {
      var file = x + extensions[i];
      if (isFile(file)) {
        return file;
      }
    }
  }

  function loadpkg(dir) {
    if (dir === '' || dir === '/') return;
    if (process.platform === 'win32' && (/^\w:[/\\]*$/).test(dir)) {
      return;
    }
    if ((/[/\\]node_modules[/\\]*$/).test(dir)) return;

    var pkgfile = path$4.join(maybeRealpathSync(realpathSync, dir, opts), 'package.json');

    if (!isFile(pkgfile)) {
      return loadpkg(path$4.dirname(dir));
    }

    var pkg = readPackageSync(readFileSync, pkgfile);

    if (pkg && opts.packageFilter) {
      // v2 will pass pkgfile
      pkg = opts.packageFilter(pkg, /*pkgfile,*/ dir); // eslint-disable-line spaced-comment
    }

    return { pkg: pkg, dir: dir };
  }

  function loadAsDirectorySync(x) {
    var pkgfile = path$4.join(maybeRealpathSync(realpathSync, x, opts), '/package.json');
    if (isFile(pkgfile)) {
      try {
        var pkg = readPackageSync(readFileSync, pkgfile);
      } catch (e) {}

      if (pkg && opts.packageFilter) {
        // v2 will pass pkgfile
        pkg = opts.packageFilter(pkg, /*pkgfile,*/ x); // eslint-disable-line spaced-comment
      }

      if (pkg && pkg.main) {
        if (typeof pkg.main !== 'string') {
          var mainError = new TypeError('package “' + pkg.name + '” `main` must be a string');
          mainError.code = 'INVALID_PACKAGE_MAIN';
          throw mainError;
        }
        if (pkg.main === '.' || pkg.main === './') {
          pkg.main = 'index';
        }
        try {
          var m = loadAsFileSync(path$4.resolve(x, pkg.main));
          if (m) return m;
          var n = loadAsDirectorySync(path$4.resolve(x, pkg.main));
          if (n) return n;
        } catch (e) {}
      }
    }

    return loadAsFileSync(path$4.join(x, '/index'));
  }

  function loadNodeModulesSync(x, start) {
    var thunk = function () { return getPackageCandidates(x, start, opts); };
    var dirs = packageIterator ? packageIterator(x, start, thunk, opts) : thunk();

    for (var i = 0; i < dirs.length; i++) {
      var dir = dirs[i];
      if (isDirectory(path$4.dirname(dir))) {
        var m = loadAsFileSync(dir);
        if (m) return m;
        var n = loadAsDirectorySync(dir);
        if (n) return n;
      }
    }
  }
};

async.core = core_1;
async.isCore = isCore;
async.sync = sync$1;

var resolve = async;

const resolveModuleIdAsync = (sys, inMemoryFs, opts) => {
  const resolverOpts = createCustomResolverAsync(sys, inMemoryFs, opts.exts);
  resolverOpts.basedir = dirname(normalizeFsPath(opts.containingFile));
  if (opts.packageFilter) {
    resolverOpts.packageFilter = opts.packageFilter;
  }
  else if (opts.packageFilter !== null) {
    resolverOpts.packageFilter = (pkg) => {
      if (!isString$1(pkg.main) || pkg.main === '') {
        pkg.main = 'package.json';
      }
      return pkg;
    };
  }
  return new Promise((resolvePromise, rejectPromise) => {
    resolve(opts.moduleId, resolverOpts, (err, resolveId, pkgData) => {
      if (err) {
        rejectPromise(err);
      }
      else {
        resolveId = normalizePath$1(resolveId);
        const results = {
          moduleId: opts.moduleId,
          resolveId,
          pkgData,
          pkgDirPath: getPackageDirPath(resolveId, opts.moduleId),
        };
        resolvePromise(results);
      }
    });
  });
};
const createCustomResolverAsync = (sys, inMemoryFs, exts) => {
  return {
    async isFile(filePath, cb) {
      const fsFilePath = normalizeFsPath(filePath);
      const stat = await inMemoryFs.stat(fsFilePath);
      if (stat.isFile) {
        cb(null, true);
        return;
      }
      if (shouldFetchModule(fsFilePath)) {
        const endsWithExt = exts.some((ext) => fsFilePath.endsWith(ext));
        if (endsWithExt) {
          const url = getNodeModuleFetchUrl(sys, packageVersions, fsFilePath);
          const content = await fetchModuleAsync(sys, inMemoryFs, packageVersions, url, fsFilePath);
          const checkFileExists = typeof content === 'string';
          cb(null, checkFileExists);
          return;
        }
      }
      cb(null, false);
    },
    async isDirectory(dirPath, cb) {
      const fsDirPath = normalizeFsPath(dirPath);
      const stat = await inMemoryFs.stat(fsDirPath);
      if (stat.isDirectory) {
        cb(null, true);
        return;
      }
      if (shouldFetchModule(fsDirPath)) {
        if (basename(fsDirPath) === 'node_modules') {
          // just the /node_modules directory
          inMemoryFs.sys.createDirSync(fsDirPath);
          inMemoryFs.clearFileCache(fsDirPath);
          cb(null, true);
          return;
        }
        if (isCommonDirModuleFile(fsDirPath)) {
          // don't bother seeing if it's a directory if it has a common file extension
          cb(null, false);
          return;
        }
        for (const fileName of COMMON_DIR_FILENAMES) {
          const url = getCommonDirUrl(sys, packageVersions, fsDirPath, fileName);
          const filePath = getCommonDirName(fsDirPath, fileName);
          const content = await fetchModuleAsync(sys, inMemoryFs, packageVersions, url, filePath);
          if (isString$1(content)) {
            cb(null, true);
            return;
          }
        }
      }
      cb(null, false);
    },
    async readFile(p, cb) {
      const fsFilePath = normalizeFsPath(p);
      const data = await inMemoryFs.readFile(fsFilePath);
      if (isString$1(data)) {
        return cb(null, data);
      }
      return cb(`readFile not found: ${p}`);
    },
    async realpath(p, cb) {
      const fsFilePath = normalizeFsPath(p);
      const results = await sys.realpath(fsFilePath);
      if (results.error && results.error.code !== 'ENOENT') {
        cb(results.error);
      }
      else {
        cb(null, results.error ? fsFilePath : results.path);
      }
    },
    extensions: exts,
  };
};

const buildId = '20220912171136';
const minfyJsId = 'terser5.6.1_7';
const optimizeCssId = 'autoprefixer10.2.5_postcss8.2.13_7';
const parse5Version = '6.0.1';
const rollupVersion = '2.42.3';
const sizzleVersion = '2.42.3';
const terserVersion = '5.6.1';
const typescriptVersion = '4.7.4';
const vermoji = '🔥';
const version$3 = '2.18.0';
const versions = {
  stencil: version$3,
  parse5: parse5Version,
  rollup: rollupVersion,
  sizzle: sizzleVersion,
  terser: terserVersion,
  typescript: typescriptVersion,
};

const createSystem = (c) => {
  const logger = c && c.logger ? c.logger : createLogger();
  const items = new Map();
  const destroys = new Set();
  const addDestory = (cb) => destroys.add(cb);
  const removeDestory = (cb) => destroys.delete(cb);
  const events = buildEvents();
  const hardwareConcurrency = (IS_BROWSER_ENV && navigator.hardwareConcurrency) || 1;
  const destroy = async () => {
    const waits = [];
    destroys.forEach((cb) => {
      try {
        const rtn = cb();
        if (rtn && rtn.then) {
          waits.push(rtn);
        }
      }
      catch (e) {
        logger.error(`stencil sys destroy: ${e}`);
      }
    });
    await Promise.all(waits);
    destroys.clear();
  };
  const normalize = (p) => {
    if (p === '/' || p === '') {
      return '/';
    }
    const dir = dirname(p);
    const base = basename(p);
    if (dir.endsWith('/')) {
      return normalizePath$1(`${dir}${base}`);
    }
    return normalizePath$1(`${dir}/${base}`);
  };
  const accessSync = (p) => {
    const item = items.get(normalize(p));
    return !!(item && (item.isDirectory || (item.isFile && typeof item.data === 'string')));
  };
  const access = async (p) => accessSync(p);
  const copyFile = async (src, dest) => {
    writeFileSync(dest, readFileSync(src));
    return true;
  };
  const isTTY = () => {
    var _a;
    return !!((_a = process$3 === null || process$3 === void 0 ? void 0 : process_1.stdout) === null || _a === void 0 ? void 0 : _a.isTTY);
  };
  const homeDir = () => {
    return undefined();
  };
  const createDirSync = (p, opts) => {
    p = normalize(p);
    const results = {
      basename: basename(p),
      dirname: dirname(p),
      path: p,
      newDirs: [],
      error: null,
    };
    createDirRecursiveSync(p, opts, results);
    return results;
  };
  const createDirRecursiveSync = (p, opts, results) => {
    const parentDir = dirname(p);
    if (opts && opts.recursive && !isRootPath(parentDir)) {
      createDirRecursiveSync(parentDir, opts, results);
    }
    const item = items.get(p);
    if (!item) {
      items.set(p, {
        basename: basename(p),
        dirname: parentDir,
        isDirectory: true,
        isFile: false,
        watcherCallbacks: null,
        data: undefined,
      });
      results.newDirs.push(p);
      emitDirectoryWatch(p, new Set());
    }
    else {
      item.isDirectory = true;
      item.isFile = false;
    }
  };
  const createDir = async (p, opts) => createDirSync(p, opts);
  const encodeToBase64 = (str) => btoa(unescape(encodeURIComponent(str)));
  const getCurrentDirectory = () => '/';
  const getCompilerExecutingPath = () => {
    if (IS_WEB_WORKER_ENV) {
      return location.href;
    }
    return sys.getRemoteModuleUrl({ moduleId: '@stencil/core', path: 'compiler/stencil.min.js' });
  };
  const isSymbolicLink = async (_p) => false;
  const readDirSync = (p) => {
    p = normalize(p);
    const dirItems = [];
    const dir = items.get(p);
    if (dir && dir.isDirectory) {
      items.forEach((item, itemPath) => {
        if (itemPath !== '/' && (item.isDirectory || (item.isFile && typeof item.data === 'string'))) {
          if (p.endsWith('/') && `${p}${item.basename}` === itemPath) {
            dirItems.push(itemPath);
          }
          else if (`${p}/${item.basename}` === itemPath) {
            dirItems.push(itemPath);
          }
        }
      });
    }
    return dirItems.sort();
  };
  const readDir = async (p) => readDirSync(p);
  const readFileSync = (p) => {
    p = normalize(p);
    const item = items.get(p);
    if (item && item.isFile) {
      return item.data;
    }
    return undefined;
  };
  const readFile = async (p) => readFileSync(p);
  const realpathSync = (p) => {
    const results = {
      path: normalize(p),
      error: null,
    };
    return results;
  };
  const realpath = async (p) => realpathSync(p);
  const rename = async (oldPath, newPath) => {
    oldPath = normalizePath$1(oldPath);
    newPath = normalizePath$1(newPath);
    const results = {
      oldPath,
      newPath,
      renamed: [],
      oldDirs: [],
      oldFiles: [],
      newDirs: [],
      newFiles: [],
      isFile: false,
      isDirectory: false,
      error: null,
    };
    const stats = statSync(oldPath);
    if (!stats.error) {
      if (stats.isFile) {
        results.isFile = true;
      }
      else if (stats.isDirectory) {
        results.isDirectory = true;
      }
      renameNewRecursiveSync(oldPath, newPath, results);
      if (!results.error) {
        if (results.isDirectory) {
          const rmdirResults = removeDirSync(oldPath, { recursive: true });
          if (rmdirResults.error) {
            results.error = rmdirResults.error;
          }
          else {
            results.oldDirs.push(...rmdirResults.removedDirs);
            results.oldFiles.push(...rmdirResults.removedFiles);
          }
        }
        else if (results.isFile) {
          const removeFileResults = removeFileSync(oldPath);
          if (removeFileResults.error) {
            results.error = removeFileResults.error;
          }
          else {
            results.oldFiles.push(oldPath);
          }
        }
      }
    }
    else {
      results.error = `${oldPath} does not exist`;
    }
    return results;
  };
  const renameNewRecursiveSync = (oldPath, newPath, results) => {
    const itemStat = statSync(oldPath);
    if (!itemStat.error && !results.error) {
      if (itemStat.isFile) {
        const newFileParentDir = dirname(newPath);
        const createDirResults = createDirSync(newFileParentDir, { recursive: true });
        const fileContent = items.get(oldPath).data;
        const writeResults = writeFileSync(newPath, fileContent);
        results.newDirs.push(...createDirResults.newDirs);
        results.renamed.push({
          oldPath,
          newPath,
          isDirectory: false,
          isFile: true,
        });
        if (writeResults.error) {
          results.error = writeResults.error;
        }
        else {
          results.newFiles.push(newPath);
        }
      }
      else if (itemStat.isDirectory) {
        const oldDirItemChildPaths = readDirSync(oldPath);
        const createDirResults = createDirSync(newPath, { recursive: true });
        results.newDirs.push(...createDirResults.newDirs);
        results.renamed.push({
          oldPath,
          newPath,
          isDirectory: true,
          isFile: false,
        });
        for (const oldDirItemChildPath of oldDirItemChildPaths) {
          const newDirItemChildPath = oldDirItemChildPath.replace(oldPath, newPath);
          renameNewRecursiveSync(oldDirItemChildPath, newDirItemChildPath, results);
        }
      }
    }
  };
  const resolvePath = (p) => normalize(p);
  const removeDirSync = (p, opts = {}) => {
    const results = {
      basename: basename(p),
      dirname: dirname(p),
      path: p,
      removedDirs: [],
      removedFiles: [],
      error: null,
    };
    remoreDirSyncRecursive(p, opts, results);
    return results;
  };
  const remoreDirSyncRecursive = (p, opts, results) => {
    if (!results.error) {
      p = normalize(p);
      const dirItemPaths = readDirSync(p);
      if (opts && opts.recursive) {
        for (const dirItemPath of dirItemPaths) {
          const item = items.get(dirItemPath);
          if (item) {
            if (item.isDirectory) {
              remoreDirSyncRecursive(dirItemPath, opts, results);
            }
            else if (item.isFile) {
              const removeFileResults = removeFileSync(dirItemPath);
              if (removeFileResults.error) {
                results.error = removeFileResults.error;
              }
              else {
                results.removedFiles.push(dirItemPath);
              }
            }
          }
        }
      }
      else {
        if (dirItemPaths.length > 0) {
          results.error = `cannot delete directory that contains files/subdirectories`;
          return;
        }
      }
      items.delete(p);
      emitDirectoryWatch(p, new Set());
      results.removedDirs.push(p);
    }
  };
  const removeDir = async (p, opts = {}) => removeDirSync(p, opts);
  const statSync = (p) => {
    p = normalize(p);
    const item = items.get(p);
    if (item && (item.isDirectory || (item.isFile && typeof item.data === 'string'))) {
      return {
        isDirectory: item.isDirectory,
        isFile: item.isFile,
        isSymbolicLink: false,
        size: item.isFile && item.data ? item.data.length : 0,
        error: null,
      };
    }
    return {
      isDirectory: false,
      isFile: false,
      isSymbolicLink: false,
      size: 0,
      error: `ENOENT: no such file or directory, statSync '${p}'`,
    };
  };
  const stat = async (p) => statSync(p);
  const removeFileSync = (p) => {
    p = normalize(p);
    const results = {
      basename: basename(p),
      dirname: dirname(p),
      path: p,
      error: null,
    };
    const item = items.get(p);
    if (item) {
      if (item.watcherCallbacks) {
        for (const watcherCallback of item.watcherCallbacks) {
          watcherCallback(p, 'fileDelete');
        }
      }
      items.delete(p);
      emitDirectoryWatch(p, new Set());
    }
    return results;
  };
  const removeFile = async (p) => removeFileSync(p);
  const watchDirectory = (p, dirWatcherCallback) => {
    p = normalize(p);
    const item = items.get(p);
    const close = () => {
      const closeItem = items.get(p);
      if (closeItem && closeItem.watcherCallbacks) {
        const index = closeItem.watcherCallbacks.indexOf(dirWatcherCallback);
        if (index > -1) {
          closeItem.watcherCallbacks.splice(index, 1);
        }
      }
    };
    addDestory(close);
    if (item) {
      item.isDirectory = true;
      item.isFile = false;
      item.watcherCallbacks = item.watcherCallbacks || [];
      item.watcherCallbacks.push(dirWatcherCallback);
    }
    else {
      items.set(p, {
        basename: basename(p),
        dirname: dirname(p),
        isDirectory: true,
        isFile: false,
        watcherCallbacks: [dirWatcherCallback],
        data: undefined,
      });
    }
    return {
      close() {
        removeDestory(close);
        close();
      },
    };
  };
  const watchFile = (p, fileWatcherCallback) => {
    p = normalize(p);
    const item = items.get(p);
    const close = () => {
      const closeItem = items.get(p);
      if (closeItem && closeItem.watcherCallbacks) {
        const index = closeItem.watcherCallbacks.indexOf(fileWatcherCallback);
        if (index > -1) {
          closeItem.watcherCallbacks.splice(index, 1);
        }
      }
    };
    addDestory(close);
    if (item) {
      item.isDirectory = false;
      item.isFile = true;
      item.watcherCallbacks = item.watcherCallbacks || [];
      item.watcherCallbacks.push(fileWatcherCallback);
    }
    else {
      items.set(p, {
        basename: basename(p),
        dirname: dirname(p),
        isDirectory: false,
        isFile: true,
        watcherCallbacks: [fileWatcherCallback],
        data: undefined,
      });
    }
    return {
      close() {
        removeDestory(close);
        close();
      },
    };
  };
  const emitDirectoryWatch = (p, emitted) => {
    const parentDir = normalize(dirname(p));
    const dirItem = items.get(parentDir);
    if (dirItem && dirItem.isDirectory && dirItem.watcherCallbacks) {
      for (const watcherCallback of dirItem.watcherCallbacks) {
        watcherCallback(p, null);
      }
    }
    if (!emitted.has(parentDir)) {
      emitted.add(parentDir);
      emitDirectoryWatch(parentDir, emitted);
    }
  };
  const writeFileSync = (p, data) => {
    p = normalize(p);
    const results = {
      path: p,
      error: null,
    };
    const item = items.get(p);
    if (item) {
      const hasChanged = item.data !== data;
      item.data = data;
      if (hasChanged && item.watcherCallbacks) {
        for (const watcherCallback of item.watcherCallbacks) {
          watcherCallback(p, 'fileUpdate');
        }
      }
    }
    else {
      items.set(p, {
        basename: basename(p),
        dirname: dirname(p),
        isDirectory: false,
        isFile: true,
        watcherCallbacks: null,
        data,
      });
      emitDirectoryWatch(p, new Set());
    }
    return results;
  };
  /**
   * `self` is the global namespace object used within a web worker.
   * `window` is the browser's global namespace object (I reorganized this to check the reference on that second)
   * `global` is Node's global namespace object. https://nodejs.org/api/globals.html#globals_global
   *
   * loading in this order should allow workers, which are most common, then browser,
   * then Node to grab the reference to fetch correctly.
   */
  const fetch = typeof self !== 'undefined'
    ? self === null || self === void 0 ? void 0 : self.fetch
    : typeof window !== 'undefined'
      ? window === null || window === void 0 ? void 0 : window.fetch
      : typeof global !== 'undefined'
        ? global === null || global === void 0 ? void 0 : global.fetch
        : undefined;
  const writeFile = async (p, data) => writeFileSync(p, data);
  const tmpDirSync = () => '/.tmp';
  const tick = Promise.resolve();
  const nextTick = (cb) => tick.then(cb);
  const generateContentHash = async (content, hashLength) => {
    const arrayBuffer = await crypto.subtle.digest('SHA-256', new TextEncoder().encode(content));
    const hashArray = Array.from(new Uint8Array(arrayBuffer)); // convert buffer to byte array
    let hashHex = hashArray.map((b) => b.toString(16).padStart(2, '0')).join(''); // convert bytes to hex string
    if (typeof hashLength === 'number') {
      hashHex = hashHex.slice(0, hashLength);
    }
    return hashHex;
  };
  const copy = async (copyTasks, srcDir) => {
    const results = {
      diagnostics: [],
      dirPaths: [],
      filePaths: [],
    };
    logger.info('todo, copy task', copyTasks.length, srcDir);
    return results;
  };
  const getEnvironmentVar = (key) => {
    return process$3 === null || process$3 === void 0 ? void 0 : process_1.env[key];
  };
  const getLocalModulePath = (opts) => join(opts.rootDir, 'node_modules', opts.moduleId, opts.path);
  const getRemoteModuleUrl = (opts) => {
    const npmBaseUrl = 'https://cdn.jsdelivr.net/npm/';
    const path = `${opts.moduleId}${opts.version ? '@' + opts.version : ''}/${opts.path}`;
    return new URL(path, npmBaseUrl).href;
  };
  const fileWatchTimeout = 32;
  createDirSync('/');
  const sys = {
    name: 'in-memory',
    version: version$3,
    events,
    access,
    accessSync,
    addDestory,
    copyFile,
    createDir,
    createDirSync,
    homeDir,
    isTTY,
    getEnvironmentVar,
    destroy,
    encodeToBase64,
    exit: async (exitCode) => logger.warn(`exit ${exitCode}`),
    getCurrentDirectory,
    getCompilerExecutingPath,
    getLocalModulePath,
    getRemoteModuleUrl,
    hardwareConcurrency,
    isSymbolicLink,
    nextTick,
    normalizePath: normalize,
    platformPath: pathBrowserify,
    readDir,
    readDirSync,
    readFile,
    readFileSync,
    realpath,
    realpathSync,
    removeDestory,
    rename,
    fetch,
    resolvePath,
    removeDir,
    removeDirSync,
    stat,
    statSync,
    tmpDirSync,
    removeFile,
    removeFileSync,
    watchDirectory,
    watchFile,
    watchTimeout: fileWatchTimeout,
    writeFile,
    writeFileSync,
    generateContentHash,
    createWorkerController: HAS_WEB_WORKER
      ? (maxConcurrentWorkers) => createWebWorkerMainController(sys, maxConcurrentWorkers)
      : null,
    details: {
      cpuModel: '',
      freemem: () => 0,
      platform: '',
      release: '',
      totalmem: 0,
    },
    copy,
  };
  sys.resolveModuleId = (opts) => resolveModuleIdAsync(sys, null, opts);
  return sys;
};

let cssProcessor;
/**
 * Autoprefix a CSS string, adding vendor prefixes to make sure that what
 * is written in the CSS will render correctly in our range of supported browsers.
 * This function uses PostCSS in compbination with the Autoprefix plugin to
 * automatically add vendor prefixes based on a list of browsers which we want
 * to support.
 *
 * @param cssText the text to be prefixed
 * @param opts an optional param with options for Autoprefixer
 * @returns a Promise wrapping some prefixed CSS as well as diagnostics
 */
const autoprefixCss = async (cssText, opts) => {
  const output = {
    output: cssText,
    diagnostics: [],
  };
  if (!IS_NODE_ENV) {
    return output;
  }
  try {
    const autoprefixerOpts = opts != null && typeof opts === 'object' ? opts : DEFAULT_AUTOPREFIX_OPTIONS;
    const processor = getProcessor(autoprefixerOpts);
    const result = await processor.process(cssText, { map: null });
    result.warnings().forEach((warning) => {
      output.diagnostics.push({
        header: `Autoprefix CSS: ${warning.plugin}`,
        messageText: warning.text,
        level: 'warn',
        type: 'css',
      });
    });
    output.output = result.css;
  }
  catch (e) {
    const diagnostic = {
      header: `Autoprefix CSS`,
      messageText: `CSS Error` + e,
      level: `error`,
      type: `css`,
    };
    if (typeof e.name === 'string') {
      diagnostic.header = e.name;
    }
    if (typeof e.reason === 'string') {
      diagnostic.messageText = e.reason;
    }
    if (typeof e.source === 'string' && typeof e.line === 'number') {
      const lines = e.source.replace(/\r/g, '\n').split('\n');
      if (lines.length > 0) {
        const addLine = (lineNumber) => {
          const line = lines[lineNumber];
          if (typeof line === 'string') {
            const printLine = {
              lineIndex: -1,
              lineNumber: -1,
              text: line,
              errorCharStart: -1,
              errorLength: -1,
            };
            diagnostic.lines = diagnostic.lines || [];
            diagnostic.lines.push(printLine);
          }
        };
        addLine(e.line - 3);
        addLine(e.line - 2);
        addLine(e.line - 1);
        addLine(e.line);
        addLine(e.line + 1);
        addLine(e.line + 2);
        addLine(e.line + 3);
      }
    }
    output.diagnostics.push(diagnostic);
  }
  return output;
};
/**
 * Get the processor for PostCSS and the Autoprefixer plugin
 *
 * @param autoprefixerOpts Options for Autoprefixer
 * @returns postCSS with the Autoprefixer plugin applied
 */
const getProcessor = (autoprefixerOpts) => {
  const { postcss, autoprefixer } = requireFunc('../sys/node/autoprefixer.js');
  if (!cssProcessor) {
    cssProcessor = postcss([autoprefixer(autoprefixerOpts)]);
  }
  return cssProcessor;
};
/**
 * Default options for the Autoprefixer PostCSS plugin. See the documentation:
 * https://github.com/postcss/autoprefixer#options for a complete list.
 *
 * This default option set will:
 *
 * - override the default browser list (`overrideBrowserslist`)
 * - turn off the visual cascade (`cascade`)
 * - disable auto-removing outdated prefixes (`remove`)
 * - set `flexbox` to `"no-2009"`, which limits prefixing for flexbox to the
 *   final and IE 10 versions of the specification
 */
const DEFAULT_AUTOPREFIX_OPTIONS = {
  overrideBrowserslist: ['last 2 versions', 'iOS >= 9', 'Android >= 4.4', 'Explorer >= 11', 'ExplorerMobile >= 11'],
  cascade: false,
  remove: false,
  flexbox: 'no-2009',
};

const parseCss = (css, filePath) => {
  let lineno = 1;
  let column = 1;
  const diagnostics = [];
  const updatePosition = (str) => {
    const lines = str.match(/\n/g);
    if (lines)
      lineno += lines.length;
    const i = str.lastIndexOf('\n');
    column = ~i ? str.length - i : column + str.length;
  };
  const position = () => {
    const start = { line: lineno, column: column };
    return (node) => {
      node.position = new ParsePosition(start);
      whitespace();
      return node;
    };
  };
  const error = (msg) => {
    const srcLines = css.split('\n');
    const d = {
      level: 'error',
      type: 'css',
      language: 'css',
      header: 'CSS Parse',
      messageText: msg,
      absFilePath: filePath,
      lines: [
        {
          lineIndex: lineno - 1,
          lineNumber: lineno,
          errorCharStart: column,
          text: css[lineno - 1],
        },
      ],
    };
    if (lineno > 1) {
      const previousLine = {
        lineIndex: lineno - 1,
        lineNumber: lineno - 1,
        text: css[lineno - 2],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.unshift(previousLine);
    }
    if (lineno + 2 < srcLines.length) {
      const nextLine = {
        lineIndex: lineno,
        lineNumber: lineno + 1,
        text: srcLines[lineno],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.push(nextLine);
    }
    diagnostics.push(d);
    return null;
  };
  const stylesheet = () => {
    const rulesList = rules();
    return {
      type: 14 /* CssNodeType.StyleSheet */,
      stylesheet: {
        source: filePath,
        rules: rulesList,
      },
    };
  };
  const open = () => match(/^{\s*/);
  const close = () => match(/^}/);
  const match = (re) => {
    const m = re.exec(css);
    if (!m)
      return;
    const str = m[0];
    updatePosition(str);
    css = css.slice(str.length);
    return m;
  };
  const rules = () => {
    let node;
    const rules = [];
    whitespace();
    comments(rules);
    while (css.length && css.charAt(0) !== '}' && (node = atrule() || rule())) {
      if (node !== false) {
        rules.push(node);
        comments(rules);
      }
    }
    return rules;
  };
  /**
   * Parse whitespace.
   */
  const whitespace = () => match(/^\s*/);
  const comments = (rules) => {
    let c;
    rules = rules || [];
    while ((c = comment())) {
      if (c !== false) {
        rules.push(c);
      }
    }
    return rules;
  };
  const comment = () => {
    const pos = position();
    if ('/' !== css.charAt(0) || '*' !== css.charAt(1))
      return null;
    let i = 2;
    while ('' !== css.charAt(i) && ('*' !== css.charAt(i) || '/' !== css.charAt(i + 1)))
      ++i;
    i += 2;
    if ('' === css.charAt(i - 1)) {
      return error('End of comment missing');
    }
    const comment = css.slice(2, i - 2);
    column += 2;
    updatePosition(comment);
    css = css.slice(i);
    column += 2;
    return pos({
      type: 1 /* CssNodeType.Comment */,
      comment,
    });
  };
  const selector = () => {
    const m = match(/^([^{]+)/);
    if (!m)
      return null;
    return trim(m[0])
      .replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*\/+/g, '')
      .replace(/"(?:\\"|[^"])*"|'(?:\\'|[^'])*'/g, function (m) {
      return m.replace(/,/g, '\u200C');
    })
      .split(/\s*(?![^(]*\)),\s*/)
      .map(function (s) {
      return s.replace(/\u200C/g, ',');
    });
  };
  const declaration = () => {
    const pos = position();
    // prop
    let prop = match(/^(\*?[-#\/\*\\\w]+(\[[0-9a-z_-]+\])?)\s*/);
    if (!prop)
      return null;
    prop = trim(prop[0]);
    // :
    if (!match(/^:\s*/))
      return error(`property missing ':'`);
    // val
    const val = match(/^((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^\)]*?\)|[^};])+)/);
    const ret = pos({
      type: 4 /* CssNodeType.Declaration */,
      property: prop.replace(commentre, ''),
      value: val ? trim(val[0]).replace(commentre, '') : '',
    });
    match(/^[;\s]*/);
    return ret;
  };
  const declarations = () => {
    const decls = [];
    if (!open())
      return error(`missing '{'`);
    comments(decls);
    // declarations
    let decl;
    while ((decl = declaration())) {
      if (decl !== false) {
        decls.push(decl);
        comments(decls);
      }
    }
    if (!close())
      return error(`missing '}'`);
    return decls;
  };
  const keyframe = () => {
    let m;
    const values = [];
    const pos = position();
    while ((m = match(/^((\d+\.\d+|\.\d+|\d+)%?|[a-z]+)\s*/))) {
      values.push(m[1]);
      match(/^,\s*/);
    }
    if (!values.length)
      return null;
    return pos({
      type: 9 /* CssNodeType.KeyFrame */,
      values,
      declarations: declarations(),
    });
  };
  const atkeyframes = () => {
    const pos = position();
    let m = match(/^@([-\w]+)?keyframes\s*/);
    if (!m)
      return null;
    const vendor = m[1];
    // identifier
    m = match(/^([-\w]+)\s*/);
    if (!m)
      return error(`@keyframes missing name`);
    const name = m[1];
    if (!open())
      return error(`@keyframes missing '{'`);
    let frame;
    let frames = comments();
    while ((frame = keyframe())) {
      frames.push(frame);
      frames = frames.concat(comments());
    }
    if (!close())
      return error(`@keyframes missing '}'`);
    return pos({
      type: 8 /* CssNodeType.KeyFrames */,
      name: name,
      vendor: vendor,
      keyframes: frames,
    });
  };
  const atsupports = () => {
    const pos = position();
    const m = match(/^@supports *([^{]+)/);
    if (!m)
      return null;
    const supports = trim(m[1]);
    if (!open())
      return error(`@supports missing '{'`);
    const style = comments().concat(rules());
    if (!close())
      return error(`@supports missing '}'`);
    return pos({
      type: 15 /* CssNodeType.Supports */,
      supports: supports,
      rules: style,
    });
  };
  const athost = () => {
    const pos = position();
    const m = match(/^@host\s*/);
    if (!m)
      return null;
    if (!open())
      return error(`@host missing '{'`);
    const style = comments().concat(rules());
    if (!close())
      return error(`@host missing '}'`);
    return pos({
      type: 6 /* CssNodeType.Host */,
      rules: style,
    });
  };
  const atmedia = () => {
    const pos = position();
    const m = match(/^@media *([^{]+)/);
    if (!m)
      return null;
    const media = trim(m[1]);
    if (!open())
      return error(`@media missing '{'`);
    const style = comments().concat(rules());
    if (!close())
      return error(`@media missing '}'`);
    return pos({
      type: 10 /* CssNodeType.Media */,
      media: media,
      rules: style,
    });
  };
  const atcustommedia = () => {
    const pos = position();
    const m = match(/^@custom-media\s+(--[^\s]+)\s*([^{;]+);/);
    if (!m)
      return null;
    return pos({
      type: 2 /* CssNodeType.CustomMedia */,
      name: trim(m[1]),
      media: trim(m[2]),
    });
  };
  const atpage = () => {
    const pos = position();
    const m = match(/^@page */);
    if (!m)
      return null;
    const sel = selector() || [];
    if (!open())
      return error(`@page missing '{'`);
    let decls = comments();
    let decl;
    while ((decl = declaration())) {
      decls.push(decl);
      decls = decls.concat(comments());
    }
    if (!close())
      return error(`@page missing '}'`);
    return pos({
      type: 12 /* CssNodeType.Page */,
      selectors: sel,
      declarations: decls,
    });
  };
  const atdocument = () => {
    const pos = position();
    const m = match(/^@([-\w]+)?document *([^{]+)/);
    if (!m)
      return null;
    const vendor = trim(m[1]);
    const doc = trim(m[2]);
    if (!open())
      return error(`@document missing '{'`);
    const style = comments().concat(rules());
    if (!close())
      return error(`@document missing '}'`);
    return pos({
      type: 3 /* CssNodeType.Document */,
      document: doc,
      vendor: vendor,
      rules: style,
    });
  };
  const atfontface = () => {
    const pos = position();
    const m = match(/^@font-face\s*/);
    if (!m)
      return null;
    if (!open())
      return error(`@font-face missing '{'`);
    let decls = comments();
    let decl;
    while ((decl = declaration())) {
      decls.push(decl);
      decls = decls.concat(comments());
    }
    if (!close())
      return error(`@font-face missing '}'`);
    return pos({
      type: 5 /* CssNodeType.FontFace */,
      declarations: decls,
    });
  };
  const compileAtrule = (nodeName, nodeType) => {
    const re = new RegExp('^@' + nodeName + '\\s*([^;]+);');
    return () => {
      const pos = position();
      const m = match(re);
      if (!m)
        return null;
      const node = {
        type: nodeType,
      };
      node[nodeName] = m[1].trim();
      return pos(node);
    };
  };
  const atimport = compileAtrule('import', 7 /* CssNodeType.Import */);
  const atcharset = compileAtrule('charset', 0 /* CssNodeType.Charset */);
  const atnamespace = compileAtrule('namespace', 11 /* CssNodeType.Namespace */);
  const atrule = () => {
    if (css[0] !== '@')
      return null;
    return (atkeyframes() ||
      atmedia() ||
      atcustommedia() ||
      atsupports() ||
      atimport() ||
      atcharset() ||
      atnamespace() ||
      atdocument() ||
      atpage() ||
      athost() ||
      atfontface());
  };
  const rule = () => {
    const pos = position();
    const sel = selector();
    if (!sel)
      return error('selector missing');
    comments();
    return pos({
      type: 13 /* CssNodeType.Rule */,
      selectors: sel,
      declarations: declarations(),
    });
  };
  class ParsePosition {
    constructor(start) {
      this.start = start;
      this.end = { line: lineno, column: column };
      this.source = filePath;
    }
  }
  ParsePosition.prototype.content = css;
  return {
    diagnostics,
    ...addParent(stylesheet()),
  };
};
const trim = (str) => (str ? str.trim() : '');
/**
 * Adds non-enumerable parent node reference to each node.
 */
const addParent = (obj, parent) => {
  const isNode = obj && typeof obj.type === 'string';
  const childParent = isNode ? obj : parent;
  for (const k in obj) {
    const value = obj[k];
    if (Array.isArray(value)) {
      value.forEach(function (v) {
        addParent(v, childParent);
      });
    }
    else if (value && typeof value === 'object') {
      addParent(value, childParent);
    }
  }
  if (isNode) {
    Object.defineProperty(obj, 'parent', {
      configurable: true,
      writable: true,
      enumerable: false,
      value: parent || null,
    });
  }
  return obj;
};
// http://www.w3.org/TR/CSS21/grammar.html
// https://github.com/visionmedia/css-parse/pull/49#issuecomment-30088027
const commentre = /\/\*[^*]*\*+([^/*][^*]*\*+)*\//g;

const getCssSelectors = (sel) => {
  // reusing global SELECTORS since this is a synchronous operation
  SELECTORS.all.length =
    SELECTORS.tags.length =
      SELECTORS.classNames.length =
        SELECTORS.ids.length =
          SELECTORS.attrs.length =
            0;
  sel = sel
    .replace(/\./g, ' .')
    .replace(/\#/g, ' #')
    .replace(/\[/g, ' [')
    .replace(/\>/g, ' > ')
    .replace(/\+/g, ' + ')
    .replace(/\~/g, ' ~ ')
    .replace(/\*/g, ' * ')
    .replace(/\:not\((.*?)\)/g, ' ');
  const items = sel.split(' ');
  for (let i = 0, l = items.length; i < l; i++) {
    items[i] = items[i].split(':')[0];
    if (items[i].length === 0)
      continue;
    if (items[i].charAt(0) === '.') {
      SELECTORS.classNames.push(items[i].slice(1));
    }
    else if (items[i].charAt(0) === '#') {
      SELECTORS.ids.push(items[i].slice(1));
    }
    else if (items[i].charAt(0) === '[') {
      items[i] = items[i].slice(1).split('=')[0].split(']')[0].trim();
      SELECTORS.attrs.push(items[i].toLowerCase());
    }
    else if (/[a-z]/g.test(items[i].charAt(0))) {
      SELECTORS.tags.push(items[i].toLowerCase());
    }
  }
  SELECTORS.classNames = SELECTORS.classNames.sort((a, b) => {
    if (a.length < b.length)
      return -1;
    if (a.length > b.length)
      return 1;
    return 0;
  });
  return SELECTORS;
};
const SELECTORS = {
  all: [],
  tags: [],
  classNames: [],
  ids: [],
  attrs: [],
};

const serializeCss = (stylesheet, serializeOpts) => {
  const usedSelectors = serializeOpts.usedSelectors || null;
  const opts = {
    usedSelectors: usedSelectors || null,
    hasUsedAttrs: !!usedSelectors && usedSelectors.attrs.size > 0,
    hasUsedClassNames: !!usedSelectors && usedSelectors.classNames.size > 0,
    hasUsedIds: !!usedSelectors && usedSelectors.ids.size > 0,
    hasUsedTags: !!usedSelectors && usedSelectors.tags.size > 0,
  };
  const rules = stylesheet.rules;
  if (!rules) {
    return '';
  }
  const rulesLen = rules.length;
  const out = [];
  for (let i = 0; i < rulesLen; i++) {
    out.push(serializeCssVisitNode(opts, rules[i], i, rulesLen));
  }
  return out.join('');
};
const serializeCssVisitNode = (opts, node, index, len) => {
  const nodeType = node.type;
  if (nodeType === 4 /* CssNodeType.Declaration */) {
    return serializeCssDeclaration(node, index, len);
  }
  if (nodeType === 13 /* CssNodeType.Rule */) {
    return serializeCssRule(opts, node);
  }
  if (nodeType === 1 /* CssNodeType.Comment */) {
    if (node.comment[0] === '!') {
      return `/*${node.comment}*/`;
    }
    else {
      return '';
    }
  }
  if (nodeType === 10 /* CssNodeType.Media */) {
    return serializeCssMedia(opts, node);
  }
  if (nodeType === 8 /* CssNodeType.KeyFrames */) {
    return serializeCssKeyframes(opts, node);
  }
  if (nodeType === 9 /* CssNodeType.KeyFrame */) {
    return serializeCssKeyframe(opts, node);
  }
  if (nodeType === 5 /* CssNodeType.FontFace */) {
    return serializeCssFontFace(opts, node);
  }
  if (nodeType === 15 /* CssNodeType.Supports */) {
    return serializeCssSupports(opts, node);
  }
  if (nodeType === 7 /* CssNodeType.Import */) {
    return '@import ' + node.import + ';';
  }
  if (nodeType === 0 /* CssNodeType.Charset */) {
    return '@charset ' + node.charset + ';';
  }
  if (nodeType === 12 /* CssNodeType.Page */) {
    return serializeCssPage(opts, node);
  }
  if (nodeType === 6 /* CssNodeType.Host */) {
    return '@host{' + serializeCssMapVisit(opts, node.rules) + '}';
  }
  if (nodeType === 2 /* CssNodeType.CustomMedia */) {
    return '@custom-media ' + node.name + ' ' + node.media + ';';
  }
  if (nodeType === 3 /* CssNodeType.Document */) {
    return serializeCssDocument(opts, node);
  }
  if (nodeType === 11 /* CssNodeType.Namespace */) {
    return '@namespace ' + node.namespace + ';';
  }
  return '';
};
const serializeCssRule = (opts, node) => {
  const decls = node.declarations;
  const usedSelectors = opts.usedSelectors;
  const selectors = node.selectors.slice();
  if (decls == null || decls.length === 0) {
    return '';
  }
  if (usedSelectors) {
    let i;
    let j;
    let include = true;
    for (i = selectors.length - 1; i >= 0; i--) {
      const sel = getCssSelectors(selectors[i]);
      include = true;
      // classes
      let jlen = sel.classNames.length;
      if (jlen > 0 && opts.hasUsedClassNames) {
        for (j = 0; j < jlen; j++) {
          if (!usedSelectors.classNames.has(sel.classNames[j])) {
            include = false;
            break;
          }
        }
      }
      // tags
      if (include && opts.hasUsedTags) {
        jlen = sel.tags.length;
        if (jlen > 0) {
          for (j = 0; j < jlen; j++) {
            if (!usedSelectors.tags.has(sel.tags[j])) {
              include = false;
              break;
            }
          }
        }
      }
      // attrs
      if (include && opts.hasUsedAttrs) {
        jlen = sel.attrs.length;
        if (jlen > 0) {
          for (j = 0; j < jlen; j++) {
            if (!usedSelectors.attrs.has(sel.attrs[j])) {
              include = false;
              break;
            }
          }
        }
      }
      // ids
      if (include && opts.hasUsedIds) {
        jlen = sel.ids.length;
        if (jlen > 0) {
          for (j = 0; j < jlen; j++) {
            if (!usedSelectors.ids.has(sel.ids[j])) {
              include = false;
              break;
            }
          }
        }
      }
      if (!include) {
        selectors.splice(i, 1);
      }
    }
  }
  if (selectors.length === 0) {
    return '';
  }
  const cleanedSelectors = [];
  let cleanedSelector = '';
  for (const selector of node.selectors) {
    cleanedSelector = removeSelectorWhitespace(selector);
    if (!cleanedSelectors.includes(cleanedSelector)) {
      cleanedSelectors.push(cleanedSelector);
    }
  }
  return `${cleanedSelectors}{${serializeCssMapVisit(opts, decls)}}`;
};
const serializeCssDeclaration = (node, index, len) => {
  if (node.value === '') {
    return '';
  }
  if (len - 1 === index) {
    return node.property + ':' + node.value;
  }
  return node.property + ':' + node.value + ';';
};
const serializeCssMedia = (opts, node) => {
  const mediaCss = serializeCssMapVisit(opts, node.rules);
  if (mediaCss === '') {
    return '';
  }
  return '@media ' + removeMediaWhitespace(node.media) + '{' + mediaCss + '}';
};
const serializeCssKeyframes = (opts, node) => {
  const keyframesCss = serializeCssMapVisit(opts, node.keyframes);
  if (keyframesCss === '') {
    return '';
  }
  return '@' + (node.vendor || '') + 'keyframes ' + node.name + '{' + keyframesCss + '}';
};
const serializeCssKeyframe = (opts, node) => {
  return node.values.join(',') + '{' + serializeCssMapVisit(opts, node.declarations) + '}';
};
const serializeCssFontFace = (opts, node) => {
  const fontCss = serializeCssMapVisit(opts, node.declarations);
  if (fontCss === '') {
    return '';
  }
  return '@font-face{' + fontCss + '}';
};
const serializeCssSupports = (opts, node) => {
  const supportsCss = serializeCssMapVisit(opts, node.rules);
  if (supportsCss === '') {
    return '';
  }
  return '@supports ' + node.supports + '{' + supportsCss + '}';
};
const serializeCssPage = (opts, node) => {
  const sel = node.selectors.join(', ');
  return '@page ' + sel + '{' + serializeCssMapVisit(opts, node.declarations) + '}';
};
const serializeCssDocument = (opts, node) => {
  const documentCss = serializeCssMapVisit(opts, node.rules);
  const doc = '@' + (node.vendor || '') + 'document ' + node.document;
  if (documentCss === '') {
    return '';
  }
  return doc + '{' + documentCss + '}';
};
const serializeCssMapVisit = (opts, nodes) => {
  let rtn = '';
  if (nodes) {
    for (let i = 0, len = nodes.length; i < len; i++) {
      rtn += serializeCssVisitNode(opts, nodes[i], i, len);
    }
  }
  return rtn;
};
const removeSelectorWhitespace = (selector) => {
  let rtn = '';
  let char = '';
  let inAttr = false;
  selector = selector.trim();
  for (let i = 0, l = selector.length; i < l; i++) {
    char = selector[i];
    if (char === '[' && rtn[rtn.length - 1] !== '\\') {
      inAttr = true;
    }
    else if (char === ']' && rtn[rtn.length - 1] !== '\\') {
      inAttr = false;
    }
    if (!inAttr && CSS_WS_REG.test(char)) {
      if (CSS_NEXT_CHAR_REG.test(selector[i + 1])) {
        continue;
      }
      if (CSS_PREV_CHAR_REG.test(rtn[rtn.length - 1])) {
        continue;
      }
      rtn += ' ';
    }
    else {
      rtn += char;
    }
  }
  return rtn;
};
const removeMediaWhitespace = (media) => {
  let rtn = '';
  let char = '';
  media = media.trim();
  for (let i = 0, l = media.length; i < l; i++) {
    char = media[i];
    if (CSS_WS_REG.test(char)) {
      if (CSS_WS_REG.test(rtn[rtn.length - 1])) {
        continue;
      }
      rtn += ' ';
    }
    else {
      rtn += char;
    }
  }
  return rtn;
};
const CSS_WS_REG = /\s/;
const CSS_NEXT_CHAR_REG = /[>\(\)\~\,\+\s]/;
const CSS_PREV_CHAR_REG = /[>\(\~\,\+]/;

const minifyCss = async (input) => {
  const parseResults = parseCss(input.css);
  if (hasError(parseResults.diagnostics)) {
    return input.css;
  }
  if (isFunction(input.resolveUrl) && parseResults.stylesheet && Array.isArray(parseResults.stylesheet.rules)) {
    await resolveStylesheetUrl(parseResults.stylesheet.rules, input.resolveUrl);
  }
  return serializeCss(parseResults.stylesheet, {});
};
const resolveStylesheetUrl = async (nodes, resolveUrl, resolved) => {
  for (const node of nodes) {
    if (node.type === 4 /* CssNodeType.Declaration */ && isString$1(node.value) && node.value.includes('url(')) {
      const urlSplt = node.value.split(',').map((n) => n.trim());
      for (let i = 0; i < urlSplt.length; i++) {
        const r = /url\((.*?)\)/.exec(urlSplt[i]);
        if (r) {
          try {
            const orgUrl = r[1].replace(/(\'|\")/g, '');
            const newUrl = await resolveUrl(orgUrl);
            urlSplt[i] = urlSplt[i].replace(orgUrl, newUrl);
          }
          catch (e) { }
        }
      }
      node.value = urlSplt.join(',');
    }
    if (Array.isArray(node.declarations)) {
      await resolveStylesheetUrl(node.declarations, resolveUrl);
    }
    if (Array.isArray(node.rules)) {
      await resolveStylesheetUrl(node.rules, resolveUrl);
    }
    if (Array.isArray(node.keyframes)) {
      await resolveStylesheetUrl(node.keyframes, resolveUrl);
    }
  }
};

/**
 * Optimize a CSS file, optionally running an autoprefixer and a minifier
 * depending on the options set on the input options argument.
 *
 * @param inputOpts input CSS options
 * @returns a promise wrapping the optimized output
 */
const optimizeCss$1 = async (inputOpts) => {
  let result = {
    output: inputOpts.input,
    diagnostics: [],
  };
  if (inputOpts.autoprefixer !== false && inputOpts.autoprefixer !== null) {
    result = await autoprefixCss(inputOpts.input, inputOpts.autoprefixer);
    if (hasError(result.diagnostics)) {
      return result;
    }
  }
  if (inputOpts.minify !== false) {
    result.output = await minifyCss({
      css: result.output,
      resolveUrl: inputOpts.resolveUrl,
    });
  }
  return result;
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

/**
 * Encode an integer in the range of 0 to 63 to a single base 64 digit.
 */
var encode$4 = function (number) {
  if (0 <= number && number < intToCharMap.length) {
  return intToCharMap[number];
  }
  throw new TypeError("Must be between 0 and 63: " + number);
};

/**
 * Decode a single base 64 character code digit to an integer. Returns -1 on
 * failure.
 */
var decode$2 = function (charCode) {
  var bigA = 65;   // 'A'
  var bigZ = 90;   // 'Z'

  var littleA = 97;  // 'a'
  var littleZ = 122; // 'z'

  var zero = 48;   // '0'
  var nine = 57;   // '9'

  var plus = 43;   // '+'
  var slash = 47;  // '/'

  var littleOffset = 26;
  var numberOffset = 52;

  // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
  if (bigA <= charCode && charCode <= bigZ) {
  return (charCode - bigA);
  }

  // 26 - 51: abcdefghijklmnopqrstuvwxyz
  if (littleA <= charCode && charCode <= littleZ) {
  return (charCode - littleA + littleOffset);
  }

  // 52 - 61: 0123456789
  if (zero <= charCode && charCode <= nine) {
  return (charCode - zero + numberOffset);
  }

  // 62: +
  if (charCode == plus) {
  return 62;
  }

  // 63: /
  if (charCode == slash) {
  return 63;
  }

  // Invalid base64 digit.
  return -1;
};

var base64 = {
	encode: encode$4,
	decode: decode$2
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 *
 * Based on the Base 64 VLQ implementation in Closure Compiler:
 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
 *
 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *  * Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *  copyright notice, this list of conditions and the following
 *  disclaimer in the documentation and/or other materials provided
 *  with the distribution.
 *  * Neither the name of Google Inc. nor the names of its
 *  contributors may be used to endorse or promote products derived
 *  from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



// A single base 64 digit can contain 6 bits of data. For the base 64 variable
// length quantities we use in the source map spec, the first bit is the sign,
// the next four bits are the actual value, and the 6th bit is the
// continuation bit. The continuation bit tells us whether there are more
// digits in this value following this digit.
//
//   Continuation
//   |  Sign
//   |  |
//   V  V
//   101011

var VLQ_BASE_SHIFT = 5;

// binary: 100000
var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

// binary: 011111
var VLQ_BASE_MASK = VLQ_BASE - 1;

// binary: 100000
var VLQ_CONTINUATION_BIT = VLQ_BASE;

/**
 * Converts from a two-complement value to a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
 */
function toVLQSigned(aValue) {
  return aValue < 0
  ? ((-aValue) << 1) + 1
  : (aValue << 1) + 0;
}

/**
 * Converts to a two-complement value from a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
 */
function fromVLQSigned(aValue) {
  var isNegative = (aValue & 1) === 1;
  var shifted = aValue >> 1;
  return isNegative
  ? -shifted
  : shifted;
}

/**
 * Returns the base 64 VLQ encoded value.
 */
var encode$3 = function base64VLQ_encode(aValue) {
  var encoded = "";
  var digit;

  var vlq = toVLQSigned(aValue);

  do {
  digit = vlq & VLQ_BASE_MASK;
  vlq >>>= VLQ_BASE_SHIFT;
  if (vlq > 0) {
    // There are still more digits in this value, so we must make sure the
    // continuation bit is marked.
    digit |= VLQ_CONTINUATION_BIT;
  }
  encoded += base64.encode(digit);
  } while (vlq > 0);

  return encoded;
};

/**
 * Decodes the next base 64 VLQ value from the given string and returns the
 * value and the rest of the string via the out parameter.
 */
var decode$1 = function base64VLQ_decode(aStr, aIndex, aOutParam) {
  var strLen = aStr.length;
  var result = 0;
  var shift = 0;
  var continuation, digit;

  do {
  if (aIndex >= strLen) {
    throw new Error("Expected more digits in base 64 VLQ value.");
  }

  digit = base64.decode(aStr.charCodeAt(aIndex++));
  if (digit === -1) {
    throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
  }

  continuation = !!(digit & VLQ_CONTINUATION_BIT);
  digit &= VLQ_BASE_MASK;
  result = result + (digit << shift);
  shift += VLQ_BASE_SHIFT;
  } while (continuation);

  aOutParam.value = fromVLQSigned(result);
  aOutParam.rest = aIndex;
};

var base64Vlq = {
	encode: encode$3,
	decode: decode$1
};

var util$1 = createCommonjsModule$1(function (module, exports) {
/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

/**
 * This is a helper function for getting values from parameter/options
 * objects.
 *
 * @param args The object we are extracting values from
 * @param name The name of the property we are getting.
 * @param defaultValue An optional value to return if the property is missing
 * from the object. If this is not specified and the property is missing, an
 * error will be thrown.
 */
function getArg(aArgs, aName, aDefaultValue) {
  if (aName in aArgs) {
  return aArgs[aName];
  } else if (arguments.length === 3) {
  return aDefaultValue;
  } else {
  throw new Error('"' + aName + '" is a required argument.');
  }
}
exports.getArg = getArg;

var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
var dataUrlRegexp = /^data:.+\,.+$/;

function urlParse(aUrl) {
  var match = aUrl.match(urlRegexp);
  if (!match) {
  return null;
  }
  return {
  scheme: match[1],
  auth: match[2],
  host: match[3],
  port: match[4],
  path: match[5]
  };
}
exports.urlParse = urlParse;

function urlGenerate(aParsedUrl) {
  var url = '';
  if (aParsedUrl.scheme) {
  url += aParsedUrl.scheme + ':';
  }
  url += '//';
  if (aParsedUrl.auth) {
  url += aParsedUrl.auth + '@';
  }
  if (aParsedUrl.host) {
  url += aParsedUrl.host;
  }
  if (aParsedUrl.port) {
  url += ":" + aParsedUrl.port;
  }
  if (aParsedUrl.path) {
  url += aParsedUrl.path;
  }
  return url;
}
exports.urlGenerate = urlGenerate;

/**
 * Normalizes a path, or the path portion of a URL:
 *
 * - Replaces consecutive slashes with one slash.
 * - Removes unnecessary '.' parts.
 * - Removes unnecessary '<dir>/..' parts.
 *
 * Based on code in the Node.js 'path' core module.
 *
 * @param aPath The path or url to normalize.
 */
function normalize(aPath) {
  var path = aPath;
  var url = urlParse(aPath);
  if (url) {
  if (!url.path) {
    return aPath;
  }
  path = url.path;
  }
  var isAbsolute = exports.isAbsolute(path);

  var parts = path.split(/\/+/);
  for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
  part = parts[i];
  if (part === '.') {
    parts.splice(i, 1);
  } else if (part === '..') {
    up++;
  } else if (up > 0) {
    if (part === '') {
    // The first part is blank if the path is absolute. Trying to go
    // above the root is a no-op. Therefore we can remove all '..' parts
    // directly after the root.
    parts.splice(i + 1, up);
    up = 0;
    } else {
    parts.splice(i, 2);
    up--;
    }
  }
  }
  path = parts.join('/');

  if (path === '') {
  path = isAbsolute ? '/' : '.';
  }

  if (url) {
  url.path = path;
  return urlGenerate(url);
  }
  return path;
}
exports.normalize = normalize;

/**
 * Joins two paths/URLs.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be joined with the root.
 *
 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
 *   first.
 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
 *   is updated with the result and aRoot is returned. Otherwise the result
 *   is returned.
 *   - If aPath is absolute, the result is aPath.
 *   - Otherwise the two paths are joined with a slash.
 * - Joining for example 'http://' and 'www.example.com' is also supported.
 */
function join(aRoot, aPath) {
  if (aRoot === "") {
  aRoot = ".";
  }
  if (aPath === "") {
  aPath = ".";
  }
  var aPathUrl = urlParse(aPath);
  var aRootUrl = urlParse(aRoot);
  if (aRootUrl) {
  aRoot = aRootUrl.path || '/';
  }

  // `join(foo, '//www.example.org')`
  if (aPathUrl && !aPathUrl.scheme) {
  if (aRootUrl) {
    aPathUrl.scheme = aRootUrl.scheme;
  }
  return urlGenerate(aPathUrl);
  }

  if (aPathUrl || aPath.match(dataUrlRegexp)) {
  return aPath;
  }

  // `join('http://', 'www.example.com')`
  if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
  aRootUrl.host = aPath;
  return urlGenerate(aRootUrl);
  }

  var joined = aPath.charAt(0) === '/'
  ? aPath
  : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

  if (aRootUrl) {
  aRootUrl.path = joined;
  return urlGenerate(aRootUrl);
  }
  return joined;
}
exports.join = join;

exports.isAbsolute = function (aPath) {
  return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
};

/**
 * Make a path relative to a URL or another path.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be made relative to aRoot.
 */
function relative(aRoot, aPath) {
  if (aRoot === "") {
  aRoot = ".";
  }

  aRoot = aRoot.replace(/\/$/, '');

  // It is possible for the path to be above the root. In this case, simply
  // checking whether the root is a prefix of the path won't work. Instead, we
  // need to remove components from the root one by one, until either we find
  // a prefix that fits, or we run out of components to remove.
  var level = 0;
  while (aPath.indexOf(aRoot + '/') !== 0) {
  var index = aRoot.lastIndexOf("/");
  if (index < 0) {
    return aPath;
  }

  // If the only part of the root that is left is the scheme (i.e. http://,
  // file:///, etc.), one or more slashes (/), or simply nothing at all, we
  // have exhausted all components, so the path is not relative to the root.
  aRoot = aRoot.slice(0, index);
  if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
    return aPath;
  }

  ++level;
  }

  // Make sure we add a "../" for each component we removed from the root.
  return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
}
exports.relative = relative;

var supportsNullProto = (function () {
  var obj = Object.create(null);
  return !('__proto__' in obj);
}());

function identity (s) {
  return s;
}

/**
 * Because behavior goes wacky when you set `__proto__` on objects, we
 * have to prefix all the strings in our set with an arbitrary character.
 *
 * See https://github.com/mozilla/source-map/pull/31 and
 * https://github.com/mozilla/source-map/issues/30
 *
 * @param String aStr
 */
function toSetString(aStr) {
  if (isProtoString(aStr)) {
  return '$' + aStr;
  }

  return aStr;
}
exports.toSetString = supportsNullProto ? identity : toSetString;

function fromSetString(aStr) {
  if (isProtoString(aStr)) {
  return aStr.slice(1);
  }

  return aStr;
}
exports.fromSetString = supportsNullProto ? identity : fromSetString;

function isProtoString(s) {
  if (!s) {
  return false;
  }

  var length = s.length;

  if (length < 9 /* "__proto__".length */) {
  return false;
  }

  if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
    s.charCodeAt(length - 2) !== 95  /* '_' */ ||
    s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
    s.charCodeAt(length - 4) !== 116 /* 't' */ ||
    s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
    s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
    s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
    s.charCodeAt(length - 8) !== 95  /* '_' */ ||
    s.charCodeAt(length - 9) !== 95  /* '_' */) {
  return false;
  }

  for (var i = length - 10; i >= 0; i--) {
  if (s.charCodeAt(i) !== 36 /* '$' */) {
    return false;
  }
  }

  return true;
}

/**
 * Comparator between two mappings where the original positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same original source/line/column, but different generated
 * line and column the same. Useful when searching for a mapping with a
 * stubbed out mapping.
 */
function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
  var cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0 || onlyCompareOriginal) {
  return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
  return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByOriginalPositions = compareByOriginalPositions;

/**
 * Comparator between two mappings with deflated source and name indices where
 * the generated positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same generated line and column, but different
 * source/name/original line and column the same. Useful when searching for a
 * mapping with a stubbed out mapping.
 */
function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0 || onlyCompareGenerated) {
  return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
  return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

function strcmp(aStr1, aStr2) {
  if (aStr1 === aStr2) {
  return 0;
  }

  if (aStr1 === null) {
  return 1; // aStr2 !== null
  }

  if (aStr2 === null) {
  return -1; // aStr1 !== null
  }

  if (aStr1 > aStr2) {
  return 1;
  }

  return -1;
}

/**
 * Comparator between two mappings with inflated source and name strings where
 * the generated positions are compared.
 */
function compareByGeneratedPositionsInflated(mappingA, mappingB) {
  var cmp = mappingA.generatedLine - mappingB.generatedLine;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.generatedColumn - mappingB.generatedColumn;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = strcmp(mappingA.source, mappingB.source);
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalLine - mappingB.originalLine;
  if (cmp !== 0) {
  return cmp;
  }

  cmp = mappingA.originalColumn - mappingB.originalColumn;
  if (cmp !== 0) {
  return cmp;
  }

  return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

/**
 * Strip any JSON XSSI avoidance prefix from the string (as documented
 * in the source maps specification), and then parse the string as
 * JSON.
 */
function parseSourceMapInput(str) {
  return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
}
exports.parseSourceMapInput = parseSourceMapInput;

/**
 * Compute the URL of a source given the the source root, the source's
 * URL, and the source map's URL.
 */
function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
  sourceURL = sourceURL || '';

  if (sourceRoot) {
  // This follows what Chrome does.
  if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
    sourceRoot += '/';
  }
  // The spec says:
  //   Line 4: An optional source root, useful for relocating source
  //   files on a server or removing repeated values in the
  //   “sources” entry.  This value is prepended to the individual
  //   entries in the “source” field.
  sourceURL = sourceRoot + sourceURL;
  }

  // Historically, SourceMapConsumer did not take the sourceMapURL as
  // a parameter.  This mode is still somewhat supported, which is why
  // this code block is conditional.  However, it's preferable to pass
  // the source map URL to SourceMapConsumer, so that this function
  // can implement the source URL resolution algorithm as outlined in
  // the spec.  This block is basically the equivalent of:
  //  new URL(sourceURL, sourceMapURL).toString()
  // ... except it avoids using URL, which wasn't available in the
  // older releases of node still supported by this library.
  //
  // The spec says:
  //   If the sources are not absolute URLs after prepending of the
  //   “sourceRoot”, the sources are resolved relative to the
  //   SourceMap (like resolving script src in a html document).
  if (sourceMapURL) {
  var parsed = urlParse(sourceMapURL);
  if (!parsed) {
    throw new Error("sourceMapURL could not be parsed");
  }
  if (parsed.path) {
    // Strip the last path component, but keep the "/".
    var index = parsed.path.lastIndexOf('/');
    if (index >= 0) {
    parsed.path = parsed.path.substring(0, index + 1);
    }
  }
  sourceURL = join(urlGenerate(parsed), sourceURL);
  }

  return normalize(sourceURL);
}
exports.computeSourceURL = computeSourceURL;
});

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */


var has$1 = Object.prototype.hasOwnProperty;
var hasNativeMap = typeof Map !== "undefined";

/**
 * A data structure which is a combination of an array and a set. Adding a new
 * member is O(1), testing for membership is O(1), and finding the index of an
 * element is O(1). Removing elements from the set is not supported. Only
 * strings are supported for membership.
 */
function ArraySet$2() {
  this._array = [];
  this._set = hasNativeMap ? new Map() : Object.create(null);
}

/**
 * Static method for creating ArraySet instances from an existing array.
 */
ArraySet$2.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
  var set = new ArraySet$2();
  for (var i = 0, len = aArray.length; i < len; i++) {
  set.add(aArray[i], aAllowDuplicates);
  }
  return set;
};

/**
 * Return how many unique items are in this ArraySet. If duplicates have been
 * added, than those do not count towards the size.
 *
 * @returns Number
 */
ArraySet$2.prototype.size = function ArraySet_size() {
  return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
};

/**
 * Add the given string to this set.
 *
 * @param String aStr
 */
ArraySet$2.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
  var sStr = hasNativeMap ? aStr : util$1.toSetString(aStr);
  var isDuplicate = hasNativeMap ? this.has(aStr) : has$1.call(this._set, sStr);
  var idx = this._array.length;
  if (!isDuplicate || aAllowDuplicates) {
  this._array.push(aStr);
  }
  if (!isDuplicate) {
  if (hasNativeMap) {
    this._set.set(aStr, idx);
  } else {
    this._set[sStr] = idx;
  }
  }
};

/**
 * Is the given string a member of this set?
 *
 * @param String aStr
 */
ArraySet$2.prototype.has = function ArraySet_has(aStr) {
  if (hasNativeMap) {
  return this._set.has(aStr);
  } else {
  var sStr = util$1.toSetString(aStr);
  return has$1.call(this._set, sStr);
  }
};

/**
 * What is the index of the given string in the array?
 *
 * @param String aStr
 */
ArraySet$2.prototype.indexOf = function ArraySet_indexOf(aStr) {
  if (hasNativeMap) {
  var idx = this._set.get(aStr);
  if (idx >= 0) {
    return idx;
  }
  } else {
  var sStr = util$1.toSetString(aStr);
  if (has$1.call(this._set, sStr)) {
    return this._set[sStr];
  }
  }

  throw new Error('"' + aStr + '" is not in the set.');
};

/**
 * What is the element at the given index?
 *
 * @param Number aIdx
 */
ArraySet$2.prototype.at = function ArraySet_at(aIdx) {
  if (aIdx >= 0 && aIdx < this._array.length) {
  return this._array[aIdx];
  }
  throw new Error('No element indexed by ' + aIdx);
};

/**
 * Returns the array representation of this set (which has the proper indices
 * indicated by indexOf). Note that this is a copy of the internal array used
 * for storing the members so that no one can mess with internal state.
 */
ArraySet$2.prototype.toArray = function ArraySet_toArray() {
  return this._array.slice();
};

var ArraySet_1 = ArraySet$2;

var arraySet = {
	ArraySet: ArraySet_1
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2014 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */



/**
 * Determine whether mappingB is after mappingA with respect to generated
 * position.
 */
function generatedPositionAfter(mappingA, mappingB) {
  // Optimized for most common case
  var lineA = mappingA.generatedLine;
  var lineB = mappingB.generatedLine;
  var columnA = mappingA.generatedColumn;
  var columnB = mappingB.generatedColumn;
  return lineB > lineA || lineB == lineA && columnB >= columnA ||
     util$1.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
}

/**
 * A data structure to provide a sorted view of accumulated mappings in a
 * performance conscious manner. It trades a neglibable overhead in general
 * case for a large speedup in case of mappings being added in order.
 */
function MappingList$1() {
  this._array = [];
  this._sorted = true;
  // Serves as infimum
  this._last = {generatedLine: -1, generatedColumn: 0};
}

/**
 * Iterate through internal items. This method takes the same arguments that
 * `Array.prototype.forEach` takes.
 *
 * NOTE: The order of the mappings is NOT guaranteed.
 */
MappingList$1.prototype.unsortedForEach =
  function MappingList_forEach(aCallback, aThisArg) {
  this._array.forEach(aCallback, aThisArg);
  };

/**
 * Add the given source mapping.
 *
 * @param Object aMapping
 */
MappingList$1.prototype.add = function MappingList_add(aMapping) {
  if (generatedPositionAfter(this._last, aMapping)) {
  this._last = aMapping;
  this._array.push(aMapping);
  } else {
  this._sorted = false;
  this._array.push(aMapping);
  }
};

/**
 * Returns the flat, sorted array of mappings. The mappings are sorted by
 * generated position.
 *
 * WARNING: This method returns internal data without copying, for
 * performance. The return value must NOT be mutated, and should be treated as
 * an immutable borrow. If you want to take ownership, you must make your own
 * copy.
 */
MappingList$1.prototype.toArray = function MappingList_toArray() {
  if (!this._sorted) {
  this._array.sort(util$1.compareByGeneratedPositionsInflated);
  this._sorted = true;
  }
  return this._array;
};

var MappingList_1 = MappingList$1;

var mappingList = {
	MappingList: MappingList_1
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */



var ArraySet$1 = arraySet.ArraySet;
var MappingList = mappingList.MappingList;

/**
 * An instance of the SourceMapGenerator represents a source map which is
 * being built incrementally. You may pass an object with the following
 * properties:
 *
 *   - file: The filename of the generated source.
 *   - sourceRoot: A root for all relative URLs in this source map.
 */
function SourceMapGenerator$3(aArgs) {
  if (!aArgs) {
  aArgs = {};
  }
  this._file = util$1.getArg(aArgs, 'file', null);
  this._sourceRoot = util$1.getArg(aArgs, 'sourceRoot', null);
  this._skipValidation = util$1.getArg(aArgs, 'skipValidation', false);
  this._sources = new ArraySet$1();
  this._names = new ArraySet$1();
  this._mappings = new MappingList();
  this._sourcesContents = null;
}

SourceMapGenerator$3.prototype._version = 3;

/**
 * Creates a new SourceMapGenerator based on a SourceMapConsumer
 *
 * @param aSourceMapConsumer The SourceMap.
 */
SourceMapGenerator$3.fromSourceMap =
  function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
  var sourceRoot = aSourceMapConsumer.sourceRoot;
  var generator = new SourceMapGenerator$3({
    file: aSourceMapConsumer.file,
    sourceRoot: sourceRoot
  });
  aSourceMapConsumer.eachMapping(function (mapping) {
    var newMapping = {
    generated: {
      line: mapping.generatedLine,
      column: mapping.generatedColumn
    }
    };

    if (mapping.source != null) {
    newMapping.source = mapping.source;
    if (sourceRoot != null) {
      newMapping.source = util$1.relative(sourceRoot, newMapping.source);
    }

    newMapping.original = {
      line: mapping.originalLine,
      column: mapping.originalColumn
    };

    if (mapping.name != null) {
      newMapping.name = mapping.name;
    }
    }

    generator.addMapping(newMapping);
  });
  aSourceMapConsumer.sources.forEach(function (sourceFile) {
    var sourceRelative = sourceFile;
    if (sourceRoot !== null) {
    sourceRelative = util$1.relative(sourceRoot, sourceFile);
    }

    if (!generator._sources.has(sourceRelative)) {
    generator._sources.add(sourceRelative);
    }

    var content = aSourceMapConsumer.sourceContentFor(sourceFile);
    if (content != null) {
    generator.setSourceContent(sourceFile, content);
    }
  });
  return generator;
  };

/**
 * Add a single mapping from original source line and column to the generated
 * source's line and column for this source map being created. The mapping
 * object should have the following properties:
 *
 *   - generated: An object with the generated line and column positions.
 *   - original: An object with the original line and column positions.
 *   - source: The original source file (relative to the sourceRoot).
 *   - name: An optional original token name for this mapping.
 */
SourceMapGenerator$3.prototype.addMapping =
  function SourceMapGenerator_addMapping(aArgs) {
  var generated = util$1.getArg(aArgs, 'generated');
  var original = util$1.getArg(aArgs, 'original', null);
  var source = util$1.getArg(aArgs, 'source', null);
  var name = util$1.getArg(aArgs, 'name', null);

  if (!this._skipValidation) {
    this._validateMapping(generated, original, source, name);
  }

  if (source != null) {
    source = String(source);
    if (!this._sources.has(source)) {
    this._sources.add(source);
    }
  }

  if (name != null) {
    name = String(name);
    if (!this._names.has(name)) {
    this._names.add(name);
    }
  }

  this._mappings.add({
    generatedLine: generated.line,
    generatedColumn: generated.column,
    originalLine: original != null && original.line,
    originalColumn: original != null && original.column,
    source: source,
    name: name
  });
  };

/**
 * Set the source content for a source file.
 */
SourceMapGenerator$3.prototype.setSourceContent =
  function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
  var source = aSourceFile;
  if (this._sourceRoot != null) {
    source = util$1.relative(this._sourceRoot, source);
  }

  if (aSourceContent != null) {
    // Add the source content to the _sourcesContents map.
    // Create a new _sourcesContents map if the property is null.
    if (!this._sourcesContents) {
    this._sourcesContents = Object.create(null);
    }
    this._sourcesContents[util$1.toSetString(source)] = aSourceContent;
  } else if (this._sourcesContents) {
    // Remove the source file from the _sourcesContents map.
    // If the _sourcesContents map is empty, set the property to null.
    delete this._sourcesContents[util$1.toSetString(source)];
    if (Object.keys(this._sourcesContents).length === 0) {
    this._sourcesContents = null;
    }
  }
  };

/**
 * Applies the mappings of a sub-source-map for a specific source file to the
 * source map being generated. Each mapping to the supplied source file is
 * rewritten using the supplied source map. Note: The resolution for the
 * resulting mappings is the minimium of this map and the supplied map.
 *
 * @param aSourceMapConsumer The source map to be applied.
 * @param aSourceFile Optional. The filename of the source file.
 *    If omitted, SourceMapConsumer's file property will be used.
 * @param aSourceMapPath Optional. The dirname of the path to the source map
 *    to be applied. If relative, it is relative to the SourceMapConsumer.
 *    This parameter is needed when the two source maps aren't in the same
 *    directory, and the source map to be applied contains relative source
 *    paths. If so, those relative source paths need to be rewritten
 *    relative to the SourceMapGenerator.
 */
SourceMapGenerator$3.prototype.applySourceMap =
  function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
  var sourceFile = aSourceFile;
  // If aSourceFile is omitted, we will use the file property of the SourceMap
  if (aSourceFile == null) {
    if (aSourceMapConsumer.file == null) {
    throw new Error(
      'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
      'or the source map\'s "file" property. Both were omitted.'
    );
    }
    sourceFile = aSourceMapConsumer.file;
  }
  var sourceRoot = this._sourceRoot;
  // Make "sourceFile" relative if an absolute Url is passed.
  if (sourceRoot != null) {
    sourceFile = util$1.relative(sourceRoot, sourceFile);
  }
  // Applying the SourceMap can add and remove items from the sources and
  // the names array.
  var newSources = new ArraySet$1();
  var newNames = new ArraySet$1();

  // Find mappings for the "sourceFile"
  this._mappings.unsortedForEach(function (mapping) {
    if (mapping.source === sourceFile && mapping.originalLine != null) {
    // Check if it can be mapped by the source map, then update the mapping.
    var original = aSourceMapConsumer.originalPositionFor({
      line: mapping.originalLine,
      column: mapping.originalColumn
    });
    if (original.source != null) {
      // Copy mapping
      mapping.source = original.source;
      if (aSourceMapPath != null) {
      mapping.source = util$1.join(aSourceMapPath, mapping.source);
      }
      if (sourceRoot != null) {
      mapping.source = util$1.relative(sourceRoot, mapping.source);
      }
      mapping.originalLine = original.line;
      mapping.originalColumn = original.column;
      if (original.name != null) {
      mapping.name = original.name;
      }
    }
    }

    var source = mapping.source;
    if (source != null && !newSources.has(source)) {
    newSources.add(source);
    }

    var name = mapping.name;
    if (name != null && !newNames.has(name)) {
    newNames.add(name);
    }

  }, this);
  this._sources = newSources;
  this._names = newNames;

  // Copy sourcesContents of applied map.
  aSourceMapConsumer.sources.forEach(function (sourceFile) {
    var content = aSourceMapConsumer.sourceContentFor(sourceFile);
    if (content != null) {
    if (aSourceMapPath != null) {
      sourceFile = util$1.join(aSourceMapPath, sourceFile);
    }
    if (sourceRoot != null) {
      sourceFile = util$1.relative(sourceRoot, sourceFile);
    }
    this.setSourceContent(sourceFile, content);
    }
  }, this);
  };

/**
 * A mapping can have one of the three levels of data:
 *
 *   1. Just the generated position.
 *   2. The Generated position, original position, and original source.
 *   3. Generated and original position, original source, as well as a name
 *    token.
 *
 * To maintain consistency, we validate that any new mapping being added falls
 * in to one of these categories.
 */
SourceMapGenerator$3.prototype._validateMapping =
  function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
                        aName) {
  // When aOriginal is truthy but has empty values for .line and .column,
  // it is most likely a programmer error. In this case we throw a very
  // specific error message to try to guide them the right way.
  // For example: https://github.com/Polymer/polymer-bundler/pull/519
  if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
    throw new Error(
      'original.line and original.column are not numbers -- you probably meant to omit ' +
      'the original mapping entirely and only map the generated position. If so, pass ' +
      'null for the original mapping instead of an object with empty or null values.'
    );
  }

  if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
    && aGenerated.line > 0 && aGenerated.column >= 0
    && !aOriginal && !aSource && !aName) {
    // Case 1.
    return;
  }
  else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
       && aOriginal && 'line' in aOriginal && 'column' in aOriginal
       && aGenerated.line > 0 && aGenerated.column >= 0
       && aOriginal.line > 0 && aOriginal.column >= 0
       && aSource) {
    // Cases 2 and 3.
    return;
  }
  else {
    throw new Error('Invalid mapping: ' + JSON.stringify({
    generated: aGenerated,
    source: aSource,
    original: aOriginal,
    name: aName
    }));
  }
  };

/**
 * Serialize the accumulated mappings in to the stream of base 64 VLQs
 * specified by the source map format.
 */
SourceMapGenerator$3.prototype._serializeMappings =
  function SourceMapGenerator_serializeMappings() {
  var previousGeneratedColumn = 0;
  var previousGeneratedLine = 1;
  var previousOriginalColumn = 0;
  var previousOriginalLine = 0;
  var previousName = 0;
  var previousSource = 0;
  var result = '';
  var next;
  var mapping;
  var nameIdx;
  var sourceIdx;

  var mappings = this._mappings.toArray();
  for (var i = 0, len = mappings.length; i < len; i++) {
    mapping = mappings[i];
    next = '';

    if (mapping.generatedLine !== previousGeneratedLine) {
    previousGeneratedColumn = 0;
    while (mapping.generatedLine !== previousGeneratedLine) {
      next += ';';
      previousGeneratedLine++;
    }
    }
    else {
    if (i > 0) {
      if (!util$1.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
      continue;
      }
      next += ',';
    }
    }

    next += base64Vlq.encode(mapping.generatedColumn
                 - previousGeneratedColumn);
    previousGeneratedColumn = mapping.generatedColumn;

    if (mapping.source != null) {
    sourceIdx = this._sources.indexOf(mapping.source);
    next += base64Vlq.encode(sourceIdx - previousSource);
    previousSource = sourceIdx;

    // lines are stored 0-based in SourceMap spec version 3
    next += base64Vlq.encode(mapping.originalLine - 1
                   - previousOriginalLine);
    previousOriginalLine = mapping.originalLine - 1;

    next += base64Vlq.encode(mapping.originalColumn
                   - previousOriginalColumn);
    previousOriginalColumn = mapping.originalColumn;

    if (mapping.name != null) {
      nameIdx = this._names.indexOf(mapping.name);
      next += base64Vlq.encode(nameIdx - previousName);
      previousName = nameIdx;
    }
    }

    result += next;
  }

  return result;
  };

SourceMapGenerator$3.prototype._generateSourcesContent =
  function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
  return aSources.map(function (source) {
    if (!this._sourcesContents) {
    return null;
    }
    if (aSourceRoot != null) {
    source = util$1.relative(aSourceRoot, source);
    }
    var key = util$1.toSetString(source);
    return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
    ? this._sourcesContents[key]
    : null;
  }, this);
  };

/**
 * Externalize the source map.
 */
SourceMapGenerator$3.prototype.toJSON =
  function SourceMapGenerator_toJSON() {
  var map = {
    version: this._version,
    sources: this._sources.toArray(),
    names: this._names.toArray(),
    mappings: this._serializeMappings()
  };
  if (this._file != null) {
    map.file = this._file;
  }
  if (this._sourceRoot != null) {
    map.sourceRoot = this._sourceRoot;
  }
  if (this._sourcesContents) {
    map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
  }

  return map;
  };

/**
 * Render the source map being generated to a string.
 */
SourceMapGenerator$3.prototype.toString =
  function SourceMapGenerator_toString() {
  return JSON.stringify(this.toJSON());
  };

var SourceMapGenerator_1 = SourceMapGenerator$3;

var sourceMapGenerator = {
	SourceMapGenerator: SourceMapGenerator_1
};

var binarySearch = createCommonjsModule$1(function (module, exports) {
/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

exports.GREATEST_LOWER_BOUND = 1;
exports.LEAST_UPPER_BOUND = 2;

/**
 * Recursive implementation of binary search.
 *
 * @param aLow Indices here and lower do not contain the needle.
 * @param aHigh Indices here and higher do not contain the needle.
 * @param aNeedle The element being searched for.
 * @param aHaystack The non-empty array being searched.
 * @param aCompare Function which takes two elements and returns -1, 0, or 1.
 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
 *   'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
 *   closest element that is smaller than or greater than the one we are
 *   searching for, respectively, if the exact element cannot be found.
 */
function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
  // This function terminates when one of the following is true:
  //
  //   1. We find the exact element we are looking for.
  //
  //   2. We did not find the exact element, but we can return the index of
  //    the next-closest element.
  //
  //   3. We did not find the exact element, and there is no next-closest
  //    element than the one we are searching for, so we return -1.
  var mid = Math.floor((aHigh - aLow) / 2) + aLow;
  var cmp = aCompare(aNeedle, aHaystack[mid], true);
  if (cmp === 0) {
  // Found the element we are looking for.
  return mid;
  }
  else if (cmp > 0) {
  // Our needle is greater than aHaystack[mid].
  if (aHigh - mid > 1) {
    // The element is in the upper half.
    return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
  }

  // The exact needle element was not found in this haystack. Determine if
  // we are in termination case (3) or (2) and return the appropriate thing.
  if (aBias == exports.LEAST_UPPER_BOUND) {
    return aHigh < aHaystack.length ? aHigh : -1;
  } else {
    return mid;
  }
  }
  else {
  // Our needle is less than aHaystack[mid].
  if (mid - aLow > 1) {
    // The element is in the lower half.
    return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
  }

  // we are in termination case (3) or (2) and return the appropriate thing.
  if (aBias == exports.LEAST_UPPER_BOUND) {
    return mid;
  } else {
    return aLow < 0 ? -1 : aLow;
  }
  }
}

/**
 * This is an implementation of binary search which will always try and return
 * the index of the closest element if there is no exact hit. This is because
 * mappings between original and generated line/col pairs are single points,
 * and there is an implicit region between each of them, so a miss just means
 * that you aren't on the very start of a region.
 *
 * @param aNeedle The element you are looking for.
 * @param aHaystack The array that is being searched.
 * @param aCompare A function which takes the needle and an element in the
 *   array and returns -1, 0, or 1 depending on whether the needle is less
 *   than, equal to, or greater than the element, respectively.
 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
 *   'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
 *   closest element that is smaller than or greater than the one we are
 *   searching for, respectively, if the exact element cannot be found.
 *   Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
 */
exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
  if (aHaystack.length === 0) {
  return -1;
  }

  var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
                aCompare, aBias || exports.GREATEST_LOWER_BOUND);
  if (index < 0) {
  return -1;
  }

  // We have found either the exact element, or the next-closest element than
  // the one we are searching for. However, there may be more than one such
  // element. Make sure we always return the smallest of these.
  while (index - 1 >= 0) {
  if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
    break;
  }
  --index;
  }

  return index;
};
});

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

// It turns out that some (most?) JavaScript engines don't self-host
// `Array.prototype.sort`. This makes sense because C++ will likely remain
// faster than JS when doing raw CPU-intensive sorting. However, when using a
// custom comparator function, calling back and forth between the VM's C++ and
// JIT'd JS is rather slow *and* loses JIT type information, resulting in
// worse generated code for the comparator function than would be optimal. In
// fact, when sorting with a comparator, these costs outweigh the benefits of
// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
// a ~3500ms mean speed-up in `bench/bench.html`.

/**
 * Swap the elements indexed by `x` and `y` in the array `ary`.
 *
 * @param {Array} ary
 *    The array.
 * @param {Number} x
 *    The index of the first item.
 * @param {Number} y
 *    The index of the second item.
 */
function swap(ary, x, y) {
  var temp = ary[x];
  ary[x] = ary[y];
  ary[y] = temp;
}

/**
 * Returns a random integer within the range `low .. high` inclusive.
 *
 * @param {Number} low
 *    The lower bound on the range.
 * @param {Number} high
 *    The upper bound on the range.
 */
function randomIntInRange(low, high) {
  return Math.round(low + (Math.random() * (high - low)));
}

/**
 * The Quick Sort algorithm.
 *
 * @param {Array} ary
 *    An array to sort.
 * @param {function} comparator
 *    Function to use to compare two items.
 * @param {Number} p
 *    Start index of the array
 * @param {Number} r
 *    End index of the array
 */
function doQuickSort(ary, comparator, p, r) {
  // If our lower bound is less than our upper bound, we (1) partition the
  // array into two pieces and (2) recurse on each half. If it is not, this is
  // the empty array and our base case.

  if (p < r) {
  // (1) Partitioning.
  //
  // The partitioning chooses a pivot between `p` and `r` and moves all
  // elements that are less than or equal to the pivot to the before it, and
  // all the elements that are greater than it after it. The effect is that
  // once partition is done, the pivot is in the exact place it will be when
  // the array is put in sorted order, and it will not need to be moved
  // again. This runs in O(n) time.

  // Always choose a random pivot so that an input array which is reverse
  // sorted does not cause O(n^2) running time.
  var pivotIndex = randomIntInRange(p, r);
  var i = p - 1;

  swap(ary, pivotIndex, r);
  var pivot = ary[r];

  // Immediately after `j` is incremented in this loop, the following hold
  // true:
  //
  //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
  //
  //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
  for (var j = p; j < r; j++) {
    if (comparator(ary[j], pivot) <= 0) {
    i += 1;
    swap(ary, i, j);
    }
  }

  swap(ary, i + 1, j);
  var q = i + 1;

  // (2) Recurse on each half.

  doQuickSort(ary, comparator, p, q - 1);
  doQuickSort(ary, comparator, q + 1, r);
  }
}

/**
 * Sort the given array in-place with the given comparator function.
 *
 * @param {Array} ary
 *    An array to sort.
 * @param {function} comparator
 *    Function to use to compare two items.
 */
var quickSort_1 = function (ary, comparator) {
  doQuickSort(ary, comparator, 0, ary.length - 1);
};

var quickSort$1 = {
	quickSort: quickSort_1
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */



var ArraySet = arraySet.ArraySet;

var quickSort = quickSort$1.quickSort;

function SourceMapConsumer$2(aSourceMap, aSourceMapURL) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
  sourceMap = util$1.parseSourceMapInput(aSourceMap);
  }

  return sourceMap.sections != null
  ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
  : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
}

SourceMapConsumer$2.fromSourceMap = function(aSourceMap, aSourceMapURL) {
  return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
};

/**
 * The version of the source mapping spec that we are consuming.
 */
SourceMapConsumer$2.prototype._version = 3;

// `__generatedMappings` and `__originalMappings` are arrays that hold the
// parsed mapping coordinates from the source map's "mappings" attribute. They
// are lazily instantiated, accessed via the `_generatedMappings` and
// `_originalMappings` getters respectively, and we only parse the mappings
// and create these arrays once queried for a source location. We jump through
// these hoops because there can be many thousands of mappings, and parsing
// them is expensive, so we only want to do it if we must.
//
// Each object in the arrays is of the form:
//
//   {
//     generatedLine: The line number in the generated code,
//     generatedColumn: The column number in the generated code,
//     source: The path to the original source file that generated this
//         chunk of code,
//     originalLine: The line number in the original source that
//           corresponds to this chunk of generated code,
//     originalColumn: The column number in the original source that
//             corresponds to this chunk of generated code,
//     name: The name of the original symbol which generated this chunk of
//       code.
//   }
//
// All properties except for `generatedLine` and `generatedColumn` can be
// `null`.
//
// `_generatedMappings` is ordered by the generated positions.
//
// `_originalMappings` is ordered by the original positions.

SourceMapConsumer$2.prototype.__generatedMappings = null;
Object.defineProperty(SourceMapConsumer$2.prototype, '_generatedMappings', {
  configurable: true,
  enumerable: true,
  get: function () {
  if (!this.__generatedMappings) {
    this._parseMappings(this._mappings, this.sourceRoot);
  }

  return this.__generatedMappings;
  }
});

SourceMapConsumer$2.prototype.__originalMappings = null;
Object.defineProperty(SourceMapConsumer$2.prototype, '_originalMappings', {
  configurable: true,
  enumerable: true,
  get: function () {
  if (!this.__originalMappings) {
    this._parseMappings(this._mappings, this.sourceRoot);
  }

  return this.__originalMappings;
  }
});

SourceMapConsumer$2.prototype._charIsMappingSeparator =
  function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
  var c = aStr.charAt(index);
  return c === ";" || c === ",";
  };

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
SourceMapConsumer$2.prototype._parseMappings =
  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
  throw new Error("Subclasses must implement _parseMappings");
  };

SourceMapConsumer$2.GENERATED_ORDER = 1;
SourceMapConsumer$2.ORIGINAL_ORDER = 2;

SourceMapConsumer$2.GREATEST_LOWER_BOUND = 1;
SourceMapConsumer$2.LEAST_UPPER_BOUND = 2;

/**
 * Iterate over each mapping between an original source/line/column and a
 * generated line/column in this source map.
 *
 * @param Function aCallback
 *    The function that is called with each mapping.
 * @param Object aContext
 *    Optional. If specified, this object will be the value of `this` every
 *    time that `aCallback` is called.
 * @param aOrder
 *    Either `SourceMapConsumer.GENERATED_ORDER` or
 *    `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
 *    iterate over the mappings sorted by the generated file's line/column
 *    order or the original's source/line/column order, respectively. Defaults to
 *    `SourceMapConsumer.GENERATED_ORDER`.
 */
SourceMapConsumer$2.prototype.eachMapping =
  function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
  var context = aContext || null;
  var order = aOrder || SourceMapConsumer$2.GENERATED_ORDER;

  var mappings;
  switch (order) {
  case SourceMapConsumer$2.GENERATED_ORDER:
    mappings = this._generatedMappings;
    break;
  case SourceMapConsumer$2.ORIGINAL_ORDER:
    mappings = this._originalMappings;
    break;
  default:
    throw new Error("Unknown order of iteration.");
  }

  var sourceRoot = this.sourceRoot;
  mappings.map(function (mapping) {
    var source = mapping.source === null ? null : this._sources.at(mapping.source);
    source = util$1.computeSourceURL(sourceRoot, source, this._sourceMapURL);
    return {
    source: source,
    generatedLine: mapping.generatedLine,
    generatedColumn: mapping.generatedColumn,
    originalLine: mapping.originalLine,
    originalColumn: mapping.originalColumn,
    name: mapping.name === null ? null : this._names.at(mapping.name)
    };
  }, this).forEach(aCallback, context);
  };

/**
 * Returns all generated line and column information for the original source,
 * line, and column provided. If no column is provided, returns all mappings
 * corresponding to a either the line we are searching for or the next
 * closest line that has any mappings. Otherwise, returns all mappings
 * corresponding to the given line and either the column we are searching for
 * or the next closest column that has any offsets.
 *
 * The only argument is an object with the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number is 1-based.
 *   - column: Optional. the column number in the original source.
 *  The column number is 0-based.
 *
 * and an array of objects is returned, each with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *  line number is 1-based.
 *   - column: The column number in the generated source, or null.
 *  The column number is 0-based.
 */
SourceMapConsumer$2.prototype.allGeneratedPositionsFor =
  function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
  var line = util$1.getArg(aArgs, 'line');

  // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
  // returns the index of the closest mapping less than the needle. By
  // setting needle.originalColumn to 0, we thus find the last mapping for
  // the given line, provided such a mapping exists.
  var needle = {
    source: util$1.getArg(aArgs, 'source'),
    originalLine: line,
    originalColumn: util$1.getArg(aArgs, 'column', 0)
  };

  needle.source = this._findSourceIndex(needle.source);
  if (needle.source < 0) {
    return [];
  }

  var mappings = [];

  var index = this._findMapping(needle,
                  this._originalMappings,
                  "originalLine",
                  "originalColumn",
                  util$1.compareByOriginalPositions,
                  binarySearch.LEAST_UPPER_BOUND);
  if (index >= 0) {
    var mapping = this._originalMappings[index];

    if (aArgs.column === undefined) {
    var originalLine = mapping.originalLine;

    // Iterate until either we run out of mappings, or we run into
    // a mapping for a different line than the one we found. Since
    // mappings are sorted, this is guaranteed to find all mappings for
    // the line we found.
    while (mapping && mapping.originalLine === originalLine) {
      mappings.push({
      line: util$1.getArg(mapping, 'generatedLine', null),
      column: util$1.getArg(mapping, 'generatedColumn', null),
      lastColumn: util$1.getArg(mapping, 'lastGeneratedColumn', null)
      });

      mapping = this._originalMappings[++index];
    }
    } else {
    var originalColumn = mapping.originalColumn;

    // Iterate until either we run out of mappings, or we run into
    // a mapping for a different line than the one we were searching for.
    // Since mappings are sorted, this is guaranteed to find all mappings for
    // the line we are searching for.
    while (mapping &&
         mapping.originalLine === line &&
         mapping.originalColumn == originalColumn) {
      mappings.push({
      line: util$1.getArg(mapping, 'generatedLine', null),
      column: util$1.getArg(mapping, 'generatedColumn', null),
      lastColumn: util$1.getArg(mapping, 'lastGeneratedColumn', null)
      });

      mapping = this._originalMappings[++index];
    }
    }
  }

  return mappings;
  };

var SourceMapConsumer_1 = SourceMapConsumer$2;

/**
 * A BasicSourceMapConsumer instance represents a parsed source map which we can
 * query for information about the original file positions by giving it a file
 * position in the generated source.
 *
 * The first parameter is the raw source map (either as a JSON string, or
 * already parsed to an object). According to the spec, source maps have the
 * following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - sources: An array of URLs to the original source files.
 *   - names: An array of identifiers which can be referrenced by individual mappings.
 *   - sourceRoot: Optional. The URL root from which all sources are relative.
 *   - sourcesContent: Optional. An array of contents of the original source files.
 *   - mappings: A string of base64 VLQs which contain the actual mappings.
 *   - file: Optional. The generated file this source map is associated with.
 *
 * Here is an example source map, taken from the source map spec[0]:
 *
 *   {
 *     version : 3,
 *     file: "out.js",
 *     sourceRoot : "",
 *     sources: ["foo.js", "bar.js"],
 *     names: ["src", "maps", "are", "fun"],
 *     mappings: "AA,AB;;ABCDE;"
 *   }
 *
 * The second parameter, if given, is a string whose value is the URL
 * at which the source map was found.  This URL is used to compute the
 * sources array.
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
 */
function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
  sourceMap = util$1.parseSourceMapInput(aSourceMap);
  }

  var version = util$1.getArg(sourceMap, 'version');
  var sources = util$1.getArg(sourceMap, 'sources');
  // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
  // requires the array) to play nice here.
  var names = util$1.getArg(sourceMap, 'names', []);
  var sourceRoot = util$1.getArg(sourceMap, 'sourceRoot', null);
  var sourcesContent = util$1.getArg(sourceMap, 'sourcesContent', null);
  var mappings = util$1.getArg(sourceMap, 'mappings');
  var file = util$1.getArg(sourceMap, 'file', null);

  // Once again, Sass deviates from the spec and supplies the version as a
  // string rather than a number, so we use loose equality checking here.
  if (version != this._version) {
  throw new Error('Unsupported version: ' + version);
  }

  if (sourceRoot) {
  sourceRoot = util$1.normalize(sourceRoot);
  }

  sources = sources
  .map(String)
  // Some source maps produce relative source paths like "./foo.js" instead of
  // "foo.js".  Normalize these first so that future comparisons will succeed.
  // See bugzil.la/1090768.
  .map(util$1.normalize)
  // Always ensure that absolute sources are internally stored relative to
  // the source root, if the source root is absolute. Not doing this would
  // be particularly problematic when the source root is a prefix of the
  // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
  .map(function (source) {
    return sourceRoot && util$1.isAbsolute(sourceRoot) && util$1.isAbsolute(source)
    ? util$1.relative(sourceRoot, source)
    : source;
  });

  // Pass `true` below to allow duplicate names and sources. While source maps
  // are intended to be compressed and deduplicated, the TypeScript compiler
  // sometimes generates source maps with duplicates in them. See Github issue
  // #72 and bugzil.la/889492.
  this._names = ArraySet.fromArray(names.map(String), true);
  this._sources = ArraySet.fromArray(sources, true);

  this._absoluteSources = this._sources.toArray().map(function (s) {
  return util$1.computeSourceURL(sourceRoot, s, aSourceMapURL);
  });

  this.sourceRoot = sourceRoot;
  this.sourcesContent = sourcesContent;
  this._mappings = mappings;
  this._sourceMapURL = aSourceMapURL;
  this.file = file;
}

BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer$2.prototype);
BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer$2;

/**
 * Utility function to find the index of a source.  Returns -1 if not
 * found.
 */
BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
  var relativeSource = aSource;
  if (this.sourceRoot != null) {
  relativeSource = util$1.relative(this.sourceRoot, relativeSource);
  }

  if (this._sources.has(relativeSource)) {
  return this._sources.indexOf(relativeSource);
  }

  // Maybe aSource is an absolute URL as returned by |sources|.  In
  // this case we can't simply undo the transform.
  var i;
  for (i = 0; i < this._absoluteSources.length; ++i) {
  if (this._absoluteSources[i] == aSource) {
    return i;
  }
  }

  return -1;
};

/**
 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
 *
 * @param SourceMapGenerator aSourceMap
 *    The source map that will be consumed.
 * @param String aSourceMapURL
 *    The URL at which the source map can be found (optional)
 * @returns BasicSourceMapConsumer
 */
BasicSourceMapConsumer.fromSourceMap =
  function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
  var smc = Object.create(BasicSourceMapConsumer.prototype);

  var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
  var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
  smc.sourceRoot = aSourceMap._sourceRoot;
  smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
                              smc.sourceRoot);
  smc.file = aSourceMap._file;
  smc._sourceMapURL = aSourceMapURL;
  smc._absoluteSources = smc._sources.toArray().map(function (s) {
    return util$1.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
  });

  // Because we are modifying the entries (by converting string sources and
  // names to indices into the sources and names ArraySets), we have to make
  // a copy of the entry or else bad things happen. Shared mutable state
  // strikes again! See github issue #191.

  var generatedMappings = aSourceMap._mappings.toArray().slice();
  var destGeneratedMappings = smc.__generatedMappings = [];
  var destOriginalMappings = smc.__originalMappings = [];

  for (var i = 0, length = generatedMappings.length; i < length; i++) {
    var srcMapping = generatedMappings[i];
    var destMapping = new Mapping;
    destMapping.generatedLine = srcMapping.generatedLine;
    destMapping.generatedColumn = srcMapping.generatedColumn;

    if (srcMapping.source) {
    destMapping.source = sources.indexOf(srcMapping.source);
    destMapping.originalLine = srcMapping.originalLine;
    destMapping.originalColumn = srcMapping.originalColumn;

    if (srcMapping.name) {
      destMapping.name = names.indexOf(srcMapping.name);
    }

    destOriginalMappings.push(destMapping);
    }

    destGeneratedMappings.push(destMapping);
  }

  quickSort(smc.__originalMappings, util$1.compareByOriginalPositions);

  return smc;
  };

/**
 * The version of the source mapping spec that we are consuming.
 */
BasicSourceMapConsumer.prototype._version = 3;

/**
 * The list of original sources.
 */
Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
  get: function () {
  return this._absoluteSources.slice();
  }
});

/**
 * Provide the JIT with a nice shape / hidden class.
 */
function Mapping() {
  this.generatedLine = 0;
  this.generatedColumn = 0;
  this.source = null;
  this.originalLine = null;
  this.originalColumn = null;
  this.name = null;
}

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
BasicSourceMapConsumer.prototype._parseMappings =
  function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
  var generatedLine = 1;
  var previousGeneratedColumn = 0;
  var previousOriginalLine = 0;
  var previousOriginalColumn = 0;
  var previousSource = 0;
  var previousName = 0;
  var length = aStr.length;
  var index = 0;
  var cachedSegments = {};
  var temp = {};
  var originalMappings = [];
  var generatedMappings = [];
  var mapping, str, segment, end, value;

  while (index < length) {
    if (aStr.charAt(index) === ';') {
    generatedLine++;
    index++;
    previousGeneratedColumn = 0;
    }
    else if (aStr.charAt(index) === ',') {
    index++;
    }
    else {
    mapping = new Mapping();
    mapping.generatedLine = generatedLine;

    // Because each offset is encoded relative to the previous one,
    // many segments often have the same encoding. We can exploit this
    // fact by caching the parsed variable length fields of each segment,
    // allowing us to avoid a second parse if we encounter the same
    // segment again.
    for (end = index; end < length; end++) {
      if (this._charIsMappingSeparator(aStr, end)) {
      break;
      }
    }
    str = aStr.slice(index, end);

    segment = cachedSegments[str];
    if (segment) {
      index += str.length;
    } else {
      segment = [];
      while (index < end) {
      base64Vlq.decode(aStr, index, temp);
      value = temp.value;
      index = temp.rest;
      segment.push(value);
      }

      if (segment.length === 2) {
      throw new Error('Found a source, but no line and column');
      }

      if (segment.length === 3) {
      throw new Error('Found a source and line, but no column');
      }

      cachedSegments[str] = segment;
    }

    // Generated column.
    mapping.generatedColumn = previousGeneratedColumn + segment[0];
    previousGeneratedColumn = mapping.generatedColumn;

    if (segment.length > 1) {
      // Original source.
      mapping.source = previousSource + segment[1];
      previousSource += segment[1];

      // Original line.
      mapping.originalLine = previousOriginalLine + segment[2];
      previousOriginalLine = mapping.originalLine;
      // Lines are stored 0-based
      mapping.originalLine += 1;

      // Original column.
      mapping.originalColumn = previousOriginalColumn + segment[3];
      previousOriginalColumn = mapping.originalColumn;

      if (segment.length > 4) {
      // Original name.
      mapping.name = previousName + segment[4];
      previousName += segment[4];
      }
    }

    generatedMappings.push(mapping);
    if (typeof mapping.originalLine === 'number') {
      originalMappings.push(mapping);
    }
    }
  }

  quickSort(generatedMappings, util$1.compareByGeneratedPositionsDeflated);
  this.__generatedMappings = generatedMappings;

  quickSort(originalMappings, util$1.compareByOriginalPositions);
  this.__originalMappings = originalMappings;
  };

/**
 * Find the mapping that best matches the hypothetical "needle" mapping that
 * we are searching for in the given "haystack" of mappings.
 */
BasicSourceMapConsumer.prototype._findMapping =
  function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
                     aColumnName, aComparator, aBias) {
  // To return the position we are searching for, we must first find the
  // mapping for the given position and then return the opposite position it
  // points to. Because the mappings are sorted, we can use binary search to
  // find the best mapping.

  if (aNeedle[aLineName] <= 0) {
    throw new TypeError('Line must be greater than or equal to 1, got '
              + aNeedle[aLineName]);
  }
  if (aNeedle[aColumnName] < 0) {
    throw new TypeError('Column must be greater than or equal to 0, got '
              + aNeedle[aColumnName]);
  }

  return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
  };

/**
 * Compute the last column for each generated mapping. The last column is
 * inclusive.
 */
BasicSourceMapConsumer.prototype.computeColumnSpans =
  function SourceMapConsumer_computeColumnSpans() {
  for (var index = 0; index < this._generatedMappings.length; ++index) {
    var mapping = this._generatedMappings[index];

    // Mappings do not contain a field for the last generated columnt. We
    // can come up with an optimistic estimate, however, by assuming that
    // mappings are contiguous (i.e. given two consecutive mappings, the
    // first mapping ends where the second one starts).
    if (index + 1 < this._generatedMappings.length) {
    var nextMapping = this._generatedMappings[index + 1];

    if (mapping.generatedLine === nextMapping.generatedLine) {
      mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
      continue;
    }
    }

    // The last mapping for each line spans the entire line.
    mapping.lastGeneratedColumn = Infinity;
  }
  };

/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.  The line number
 *   is 1-based.
 *   - column: The column number in the generated source.  The column
 *   number is 0-based.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *   'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *   closest element that is smaller than or greater than the one we are
 *   searching for, respectively, if the exact element cannot be found.
 *   Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.  The
 *   line number is 1-based.
 *   - column: The column number in the original source, or null.  The
 *   column number is 0-based.
 *   - name: The original identifier, or null.
 */
BasicSourceMapConsumer.prototype.originalPositionFor =
  function SourceMapConsumer_originalPositionFor(aArgs) {
  var needle = {
    generatedLine: util$1.getArg(aArgs, 'line'),
    generatedColumn: util$1.getArg(aArgs, 'column')
  };

  var index = this._findMapping(
    needle,
    this._generatedMappings,
    "generatedLine",
    "generatedColumn",
    util$1.compareByGeneratedPositionsDeflated,
    util$1.getArg(aArgs, 'bias', SourceMapConsumer$2.GREATEST_LOWER_BOUND)
  );

  if (index >= 0) {
    var mapping = this._generatedMappings[index];

    if (mapping.generatedLine === needle.generatedLine) {
    var source = util$1.getArg(mapping, 'source', null);
    if (source !== null) {
      source = this._sources.at(source);
      source = util$1.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
    }
    var name = util$1.getArg(mapping, 'name', null);
    if (name !== null) {
      name = this._names.at(name);
    }
    return {
      source: source,
      line: util$1.getArg(mapping, 'originalLine', null),
      column: util$1.getArg(mapping, 'originalColumn', null),
      name: name
    };
    }
  }

  return {
    source: null,
    line: null,
    column: null,
    name: null
  };
  };

/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */
BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
  function BasicSourceMapConsumer_hasContentsOfAllSources() {
  if (!this.sourcesContent) {
    return false;
  }
  return this.sourcesContent.length >= this._sources.size() &&
    !this.sourcesContent.some(function (sc) { return sc == null; });
  };

/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */
BasicSourceMapConsumer.prototype.sourceContentFor =
  function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
  if (!this.sourcesContent) {
    return null;
  }

  var index = this._findSourceIndex(aSource);
  if (index >= 0) {
    return this.sourcesContent[index];
  }

  var relativeSource = aSource;
  if (this.sourceRoot != null) {
    relativeSource = util$1.relative(this.sourceRoot, relativeSource);
  }

  var url;
  if (this.sourceRoot != null
    && (url = util$1.urlParse(this.sourceRoot))) {
    // XXX: file:// URIs and absolute paths lead to unexpected behavior for
    // many users. We can help them out when they expect file:// URIs to
    // behave like it would if they were running a local HTTP server. See
    // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
    var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
    if (url.scheme == "file"
      && this._sources.has(fileUriAbsPath)) {
    return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
    }

    if ((!url.path || url.path == "/")
      && this._sources.has("/" + relativeSource)) {
    return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
    }
  }

  // This function is used recursively from
  // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
  // don't want to throw if we can't find the source - we just want to
  // return null, so we provide a flag to exit gracefully.
  if (nullOnMissing) {
    return null;
  }
  else {
    throw new Error('"' + relativeSource + '" is not in the SourceMap.');
  }
  };

/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number
 *   is 1-based.
 *   - column: The column number in the original source.  The column
 *   number is 0-based.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *   'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *   closest element that is smaller than or greater than the one we are
 *   searching for, respectively, if the exact element cannot be found.
 *   Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *   line number is 1-based.
 *   - column: The column number in the generated source, or null.
 *   The column number is 0-based.
 */
BasicSourceMapConsumer.prototype.generatedPositionFor =
  function SourceMapConsumer_generatedPositionFor(aArgs) {
  var source = util$1.getArg(aArgs, 'source');
  source = this._findSourceIndex(source);
  if (source < 0) {
    return {
    line: null,
    column: null,
    lastColumn: null
    };
  }

  var needle = {
    source: source,
    originalLine: util$1.getArg(aArgs, 'line'),
    originalColumn: util$1.getArg(aArgs, 'column')
  };

  var index = this._findMapping(
    needle,
    this._originalMappings,
    "originalLine",
    "originalColumn",
    util$1.compareByOriginalPositions,
    util$1.getArg(aArgs, 'bias', SourceMapConsumer$2.GREATEST_LOWER_BOUND)
  );

  if (index >= 0) {
    var mapping = this._originalMappings[index];

    if (mapping.source === needle.source) {
    return {
      line: util$1.getArg(mapping, 'generatedLine', null),
      column: util$1.getArg(mapping, 'generatedColumn', null),
      lastColumn: util$1.getArg(mapping, 'lastGeneratedColumn', null)
    };
    }
  }

  return {
    line: null,
    column: null,
    lastColumn: null
  };
  };

var BasicSourceMapConsumer_1 = BasicSourceMapConsumer;

/**
 * An IndexedSourceMapConsumer instance represents a parsed source map which
 * we can query for information. It differs from BasicSourceMapConsumer in
 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
 * input.
 *
 * The first parameter is a raw source map (either as a JSON string, or already
 * parsed to an object). According to the spec for indexed source maps, they
 * have the following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - file: Optional. The generated file this source map is associated with.
 *   - sections: A list of section definitions.
 *
 * Each value under the "sections" field has two fields:
 *   - offset: The offset into the original specified at which this section
 *     begins to apply, defined as an object with a "line" and "column"
 *     field.
 *   - map: A source map definition. This source map could also be indexed,
 *     but doesn't have to be.
 *
 * Instead of the "map" field, it's also possible to have a "url" field
 * specifying a URL to retrieve a source map from, but that's currently
 * unsupported.
 *
 * Here's an example source map, taken from the source map spec[0], but
 * modified to omit a section which uses the "url" field.
 *
 *  {
 *  version : 3,
 *  file: "app.js",
 *  sections: [{
 *    offset: {line:100, column:10},
 *    map: {
 *    version : 3,
 *    file: "section.js",
 *    sources: ["foo.js", "bar.js"],
 *    names: ["src", "maps", "are", "fun"],
 *    mappings: "AAAA,E;;ABCDE;"
 *    }
 *  }],
 *  }
 *
 * The second parameter, if given, is a string whose value is the URL
 * at which the source map was found.  This URL is used to compute the
 * sources array.
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
 */
function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
  var sourceMap = aSourceMap;
  if (typeof aSourceMap === 'string') {
  sourceMap = util$1.parseSourceMapInput(aSourceMap);
  }

  var version = util$1.getArg(sourceMap, 'version');
  var sections = util$1.getArg(sourceMap, 'sections');

  if (version != this._version) {
  throw new Error('Unsupported version: ' + version);
  }

  this._sources = new ArraySet();
  this._names = new ArraySet();

  var lastOffset = {
  line: -1,
  column: 0
  };
  this._sections = sections.map(function (s) {
  if (s.url) {
    // The url field will require support for asynchronicity.
    // See https://github.com/mozilla/source-map/issues/16
    throw new Error('Support for url field in sections not implemented.');
  }
  var offset = util$1.getArg(s, 'offset');
  var offsetLine = util$1.getArg(offset, 'line');
  var offsetColumn = util$1.getArg(offset, 'column');

  if (offsetLine < lastOffset.line ||
    (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
    throw new Error('Section offsets must be ordered and non-overlapping.');
  }
  lastOffset = offset;

  return {
    generatedOffset: {
    // The offset fields are 0-based, but we use 1-based indices when
    // encoding/decoding from VLQ.
    generatedLine: offsetLine + 1,
    generatedColumn: offsetColumn + 1
    },
    consumer: new SourceMapConsumer$2(util$1.getArg(s, 'map'), aSourceMapURL)
  }
  });
}

IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer$2.prototype);
IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer$2;

/**
 * The version of the source mapping spec that we are consuming.
 */
IndexedSourceMapConsumer.prototype._version = 3;

/**
 * The list of original sources.
 */
Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
  get: function () {
  var sources = [];
  for (var i = 0; i < this._sections.length; i++) {
    for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
    sources.push(this._sections[i].consumer.sources[j]);
    }
  }
  return sources;
  }
});

/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.  The line number
 *   is 1-based.
 *   - column: The column number in the generated source.  The column
 *   number is 0-based.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.  The
 *   line number is 1-based.
 *   - column: The column number in the original source, or null.  The
 *   column number is 0-based.
 *   - name: The original identifier, or null.
 */
IndexedSourceMapConsumer.prototype.originalPositionFor =
  function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
  var needle = {
    generatedLine: util$1.getArg(aArgs, 'line'),
    generatedColumn: util$1.getArg(aArgs, 'column')
  };

  // Find the section containing the generated position we're trying to map
  // to an original position.
  var sectionIndex = binarySearch.search(needle, this._sections,
    function(needle, section) {
    var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
    if (cmp) {
      return cmp;
    }

    return (needle.generatedColumn -
        section.generatedOffset.generatedColumn);
    });
  var section = this._sections[sectionIndex];

  if (!section) {
    return {
    source: null,
    line: null,
    column: null,
    name: null
    };
  }

  return section.consumer.originalPositionFor({
    line: needle.generatedLine -
    (section.generatedOffset.generatedLine - 1),
    column: needle.generatedColumn -
    (section.generatedOffset.generatedLine === needle.generatedLine
     ? section.generatedOffset.generatedColumn - 1
     : 0),
    bias: aArgs.bias
  });
  };

/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */
IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
  function IndexedSourceMapConsumer_hasContentsOfAllSources() {
  return this._sections.every(function (s) {
    return s.consumer.hasContentsOfAllSources();
  });
  };

/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */
IndexedSourceMapConsumer.prototype.sourceContentFor =
  function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
  for (var i = 0; i < this._sections.length; i++) {
    var section = this._sections[i];

    var content = section.consumer.sourceContentFor(aSource, true);
    if (content) {
    return content;
    }
  }
  if (nullOnMissing) {
    return null;
  }
  else {
    throw new Error('"' + aSource + '" is not in the SourceMap.');
  }
  };

/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number
 *   is 1-based.
 *   - column: The column number in the original source.  The column
 *   number is 0-based.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *   line number is 1-based. 
 *   - column: The column number in the generated source, or null.
 *   The column number is 0-based.
 */
IndexedSourceMapConsumer.prototype.generatedPositionFor =
  function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
  for (var i = 0; i < this._sections.length; i++) {
    var section = this._sections[i];

    // Only consider this section if the requested source is in the list of
    // sources of the consumer.
    if (section.consumer._findSourceIndex(util$1.getArg(aArgs, 'source')) === -1) {
    continue;
    }
    var generatedPosition = section.consumer.generatedPositionFor(aArgs);
    if (generatedPosition) {
    var ret = {
      line: generatedPosition.line +
      (section.generatedOffset.generatedLine - 1),
      column: generatedPosition.column +
      (section.generatedOffset.generatedLine === generatedPosition.line
       ? section.generatedOffset.generatedColumn - 1
       : 0)
    };
    return ret;
    }
  }

  return {
    line: null,
    column: null
  };
  };

/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */
IndexedSourceMapConsumer.prototype._parseMappings =
  function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
  this.__generatedMappings = [];
  this.__originalMappings = [];
  for (var i = 0; i < this._sections.length; i++) {
    var section = this._sections[i];
    var sectionMappings = section.consumer._generatedMappings;
    for (var j = 0; j < sectionMappings.length; j++) {
    var mapping = sectionMappings[j];

    var source = section.consumer._sources.at(mapping.source);
    source = util$1.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
    this._sources.add(source);
    source = this._sources.indexOf(source);

    var name = null;
    if (mapping.name) {
      name = section.consumer._names.at(mapping.name);
      this._names.add(name);
      name = this._names.indexOf(name);
    }

    // The mappings coming from the consumer for the section have
    // generated positions relative to the start of the section, so we
    // need to offset them to be relative to the start of the concatenated
    // generated file.
    var adjustedMapping = {
      source: source,
      generatedLine: mapping.generatedLine +
      (section.generatedOffset.generatedLine - 1),
      generatedColumn: mapping.generatedColumn +
      (section.generatedOffset.generatedLine === mapping.generatedLine
      ? section.generatedOffset.generatedColumn - 1
      : 0),
      originalLine: mapping.originalLine,
      originalColumn: mapping.originalColumn,
      name: name
    };

    this.__generatedMappings.push(adjustedMapping);
    if (typeof adjustedMapping.originalLine === 'number') {
      this.__originalMappings.push(adjustedMapping);
    }
    }
  }

  quickSort(this.__generatedMappings, util$1.compareByGeneratedPositionsDeflated);
  quickSort(this.__originalMappings, util$1.compareByOriginalPositions);
  };

var IndexedSourceMapConsumer_1 = IndexedSourceMapConsumer;

var sourceMapConsumer = {
	SourceMapConsumer: SourceMapConsumer_1,
	BasicSourceMapConsumer: BasicSourceMapConsumer_1,
	IndexedSourceMapConsumer: IndexedSourceMapConsumer_1
};

/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */

var SourceMapGenerator$2 = sourceMapGenerator.SourceMapGenerator;


// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
// operating systems these days (capturing the result).
var REGEX_NEWLINE = /(\r?\n)/;

// Newline character code for charCodeAt() comparisons
var NEWLINE_CODE = 10;

// Private symbol for identifying `SourceNode`s when multiple versions of
// the source-map library are loaded. This MUST NOT CHANGE across
// versions!
var isSourceNode = "$$$isSourceNode$$$";

/**
 * SourceNodes provide a way to abstract over interpolating/concatenating
 * snippets of generated JavaScript source code while maintaining the line and
 * column information associated with the original source code.
 *
 * @param aLine The original line number.
 * @param aColumn The original column number.
 * @param aSource The original source's filename.
 * @param aChunks Optional. An array of strings which are snippets of
 *    generated JS, or other SourceNodes.
 * @param aName The original identifier.
 */
function SourceNode$1(aLine, aColumn, aSource, aChunks, aName) {
  this.children = [];
  this.sourceContents = {};
  this.line = aLine == null ? null : aLine;
  this.column = aColumn == null ? null : aColumn;
  this.source = aSource == null ? null : aSource;
  this.name = aName == null ? null : aName;
  this[isSourceNode] = true;
  if (aChunks != null) this.add(aChunks);
}

/**
 * Creates a SourceNode from generated code and a SourceMapConsumer.
 *
 * @param aGeneratedCode The generated code
 * @param aSourceMapConsumer The SourceMap for the generated code
 * @param aRelativePath Optional. The path that relative sources in the
 *    SourceMapConsumer should be relative to.
 */
SourceNode$1.fromStringWithSourceMap =
  function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
  // The SourceNode we want to fill with the generated code
  // and the SourceMap
  var node = new SourceNode$1();

  // All even indices of this array are one line of the generated code,
  // while all odd indices are the newlines between two adjacent lines
  // (since `REGEX_NEWLINE` captures its match).
  // Processed fragments are accessed by calling `shiftNextLine`.
  var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
  var remainingLinesIndex = 0;
  var shiftNextLine = function() {
    var lineContents = getNextLine();
    // The last line of a file might not have a newline.
    var newLine = getNextLine() || "";
    return lineContents + newLine;

    function getNextLine() {
    return remainingLinesIndex < remainingLines.length ?
      remainingLines[remainingLinesIndex++] : undefined;
    }
  };

  // We need to remember the position of "remainingLines"
  var lastGeneratedLine = 1, lastGeneratedColumn = 0;

  // The generate SourceNodes we need a code range.
  // To extract it current and last mapping is used.
  // Here we store the last mapping.
  var lastMapping = null;

  aSourceMapConsumer.eachMapping(function (mapping) {
    if (lastMapping !== null) {
    // We add the code from "lastMapping" to "mapping":
    // First check if there is a new line in between.
    if (lastGeneratedLine < mapping.generatedLine) {
      // Associate first line with "lastMapping"
      addMappingWithCode(lastMapping, shiftNextLine());
      lastGeneratedLine++;
      lastGeneratedColumn = 0;
      // The remaining code is added without mapping
    } else {
      // There is no new line in between.
      // Associate the code between "lastGeneratedColumn" and
      // "mapping.generatedColumn" with "lastMapping"
      var nextLine = remainingLines[remainingLinesIndex] || '';
      var code = nextLine.substr(0, mapping.generatedColumn -
                    lastGeneratedColumn);
      remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
                        lastGeneratedColumn);
      lastGeneratedColumn = mapping.generatedColumn;
      addMappingWithCode(lastMapping, code);
      // No more remaining code, continue
      lastMapping = mapping;
      return;
    }
    }
    // We add the generated code until the first mapping
    // to the SourceNode without any mapping.
    // Each line is added as separate string.
    while (lastGeneratedLine < mapping.generatedLine) {
    node.add(shiftNextLine());
    lastGeneratedLine++;
    }
    if (lastGeneratedColumn < mapping.generatedColumn) {
    var nextLine = remainingLines[remainingLinesIndex] || '';
    node.add(nextLine.substr(0, mapping.generatedColumn));
    remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
    lastGeneratedColumn = mapping.generatedColumn;
    }
    lastMapping = mapping;
  }, this);
  // We have processed all mappings.
  if (remainingLinesIndex < remainingLines.length) {
    if (lastMapping) {
    // Associate the remaining code in the current line with "lastMapping"
    addMappingWithCode(lastMapping, shiftNextLine());
    }
    // and add the remaining lines without any mapping
    node.add(remainingLines.splice(remainingLinesIndex).join(""));
  }

  // Copy sourcesContent into SourceNode
  aSourceMapConsumer.sources.forEach(function (sourceFile) {
    var content = aSourceMapConsumer.sourceContentFor(sourceFile);
    if (content != null) {
    if (aRelativePath != null) {
      sourceFile = util$1.join(aRelativePath, sourceFile);
    }
    node.setSourceContent(sourceFile, content);
    }
  });

  return node;

  function addMappingWithCode(mapping, code) {
    if (mapping === null || mapping.source === undefined) {
    node.add(code);
    } else {
    var source = aRelativePath
      ? util$1.join(aRelativePath, mapping.source)
      : mapping.source;
    node.add(new SourceNode$1(mapping.originalLine,
                mapping.originalColumn,
                source,
                code,
                mapping.name));
    }
  }
  };

/**
 * Add a chunk of generated JS to this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *    SourceNode, or an array where each member is one of those things.
 */
SourceNode$1.prototype.add = function SourceNode_add(aChunk) {
  if (Array.isArray(aChunk)) {
  aChunk.forEach(function (chunk) {
    this.add(chunk);
  }, this);
  }
  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
  if (aChunk) {
    this.children.push(aChunk);
  }
  }
  else {
  throw new TypeError(
    "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
  );
  }
  return this;
};

/**
 * Add a chunk of generated JS to the beginning of this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *    SourceNode, or an array where each member is one of those things.
 */
SourceNode$1.prototype.prepend = function SourceNode_prepend(aChunk) {
  if (Array.isArray(aChunk)) {
  for (var i = aChunk.length-1; i >= 0; i--) {
    this.prepend(aChunk[i]);
  }
  }
  else if (aChunk[isSourceNode] || typeof aChunk === "string") {
  this.children.unshift(aChunk);
  }
  else {
  throw new TypeError(
    "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
  );
  }
  return this;
};

/**
 * Walk over the tree of JS snippets in this node and its children. The
 * walking function is called once for each snippet of JS and is passed that
 * snippet and the its original associated source's line/column location.
 *
 * @param aFn The traversal function.
 */
SourceNode$1.prototype.walk = function SourceNode_walk(aFn) {
  var chunk;
  for (var i = 0, len = this.children.length; i < len; i++) {
  chunk = this.children[i];
  if (chunk[isSourceNode]) {
    chunk.walk(aFn);
  }
  else {
    if (chunk !== '') {
    aFn(chunk, { source: this.source,
           line: this.line,
           column: this.column,
           name: this.name });
    }
  }
  }
};

/**
 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
 * each of `this.children`.
 *
 * @param aSep The separator.
 */
SourceNode$1.prototype.join = function SourceNode_join(aSep) {
  var newChildren;
  var i;
  var len = this.children.length;
  if (len > 0) {
  newChildren = [];
  for (i = 0; i < len-1; i++) {
    newChildren.push(this.children[i]);
    newChildren.push(aSep);
  }
  newChildren.push(this.children[i]);
  this.children = newChildren;
  }
  return this;
};

/**
 * Call String.prototype.replace on the very right-most source snippet. Useful
 * for trimming whitespace from the end of a source node, etc.
 *
 * @param aPattern The pattern to replace.
 * @param aReplacement The thing to replace the pattern with.
 */
SourceNode$1.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
  var lastChild = this.children[this.children.length - 1];
  if (lastChild[isSourceNode]) {
  lastChild.replaceRight(aPattern, aReplacement);
  }
  else if (typeof lastChild === 'string') {
  this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
  }
  else {
  this.children.push(''.replace(aPattern, aReplacement));
  }
  return this;
};

/**
 * Set the source content for a source file. This will be added to the SourceMapGenerator
 * in the sourcesContent field.
 *
 * @param aSourceFile The filename of the source file
 * @param aSourceContent The content of the source file
 */
SourceNode$1.prototype.setSourceContent =
  function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
  this.sourceContents[util$1.toSetString(aSourceFile)] = aSourceContent;
  };

/**
 * Walk over the tree of SourceNodes. The walking function is called for each
 * source file content and is passed the filename and source content.
 *
 * @param aFn The traversal function.
 */
SourceNode$1.prototype.walkSourceContents =
  function SourceNode_walkSourceContents(aFn) {
  for (var i = 0, len = this.children.length; i < len; i++) {
    if (this.children[i][isSourceNode]) {
    this.children[i].walkSourceContents(aFn);
    }
  }

  var sources = Object.keys(this.sourceContents);
  for (var i = 0, len = sources.length; i < len; i++) {
    aFn(util$1.fromSetString(sources[i]), this.sourceContents[sources[i]]);
  }
  };

/**
 * Return the string representation of this source node. Walks over the tree
 * and concatenates all the various snippets together to one string.
 */
SourceNode$1.prototype.toString = function SourceNode_toString() {
  var str = "";
  this.walk(function (chunk) {
  str += chunk;
  });
  return str;
};

/**
 * Returns the string representation of this source node along with a source
 * map.
 */
SourceNode$1.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
  var generated = {
  code: "",
  line: 1,
  column: 0
  };
  var map = new SourceMapGenerator$2(aArgs);
  var sourceMappingActive = false;
  var lastOriginalSource = null;
  var lastOriginalLine = null;
  var lastOriginalColumn = null;
  var lastOriginalName = null;
  this.walk(function (chunk, original) {
  generated.code += chunk;
  if (original.source !== null
    && original.line !== null
    && original.column !== null) {
    if(lastOriginalSource !== original.source
     || lastOriginalLine !== original.line
     || lastOriginalColumn !== original.column
     || lastOriginalName !== original.name) {
    map.addMapping({
      source: original.source,
      original: {
      line: original.line,
      column: original.column
      },
      generated: {
      line: generated.line,
      column: generated.column
      },
      name: original.name
    });
    }
    lastOriginalSource = original.source;
    lastOriginalLine = original.line;
    lastOriginalColumn = original.column;
    lastOriginalName = original.name;
    sourceMappingActive = true;
  } else if (sourceMappingActive) {
    map.addMapping({
    generated: {
      line: generated.line,
      column: generated.column
    }
    });
    lastOriginalSource = null;
    sourceMappingActive = false;
  }
  for (var idx = 0, length = chunk.length; idx < length; idx++) {
    if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
    generated.line++;
    generated.column = 0;
    // Mappings end at eol
    if (idx + 1 === length) {
      lastOriginalSource = null;
      sourceMappingActive = false;
    } else if (sourceMappingActive) {
      map.addMapping({
      source: original.source,
      original: {
        line: original.line,
        column: original.column
      },
      generated: {
        line: generated.line,
        column: generated.column
      },
      name: original.name
      });
    }
    } else {
    generated.column++;
    }
  }
  });
  this.walkSourceContents(function (sourceFile, sourceContent) {
  map.setSourceContent(sourceFile, sourceContent);
  });

  return { code: generated.code, map: map };
};

var SourceNode_1 = SourceNode$1;

var sourceNode = {
	SourceNode: SourceNode_1
};

/*
 * Copyright 2009-2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE.txt or:
 * http://opensource.org/licenses/BSD-3-Clause
 */
var SourceMapGenerator$1 = sourceMapGenerator.SourceMapGenerator;
var SourceMapConsumer$1 = sourceMapConsumer.SourceMapConsumer;
var SourceNode = sourceNode.SourceNode;

var sourceMap = {
	SourceMapGenerator: SourceMapGenerator$1,
	SourceMapConsumer: SourceMapConsumer$1,
	SourceNode: SourceNode
};

// Terser 5.6.1
function characters(e){return e.split("")}function member(e,t){return t.includes(e)}class DefaultsError extends Error{constructor(e,t){super(),this.name="DefaultsError",this.message=e,this.defs=t;}}function defaults$1(e,t,n){!0===e&&(e={}),null!=e&&"object"==typeof e&&(e=Object.assign({},e));const o=e||{};if(n)for(const e in o)if(HOP(o,e)&&!HOP(t,e))throw new DefaultsError("`"+e+"` is not a supported option",t);for(const n in t)if(HOP(t,n))if(e&&HOP(e,n))if("ecma"===n){let t=0|e[n];t>5&&t<2015&&(t+=2009),o[n]=t;}else o[n]=e&&HOP(e,n)?e[n]:t[n];else o[n]=t[n];return o}function noop(){}function return_false(){return !1}function return_true(){return !0}function return_this(){return this}function return_null(){return null}var MAP=function(){function e(e,r,a){var s,u=[],l=[];function _(){var _=r(e[s],s),c=_ instanceof i;return c&&(_=_.v),_ instanceof n?(_=_.v)instanceof o?l.push.apply(l,a?_.v.slice().reverse():_.v):l.push(_):_!==t&&(_ instanceof o?u.push.apply(u,a?_.v.slice().reverse():_.v):u.push(_)),c}if(Array.isArray(e))if(a){for(s=e.length;--s>=0&&!_(););u.reverse(),l.reverse();}else for(s=0;s<e.length&&!_();++s);else for(s in e)if(HOP(e,s)&&_())break;return l.concat(u)}e.at_top=function(e){return new n(e)},e.splice=function(e){return new o(e)},e.last=function(e){return new i(e)};var t=e.skip={};function n(e){this.v=e;}function o(e){this.v=e;}function i(e){this.v=e;}return e}();function make_node(e,t,n){return n||(n={}),t&&(n.start||(n.start=t.start),n.end||(n.end=t.end)),new e(n)}function push_uniq(e,t){e.includes(t)||e.push(t);}function string_template(e,t){return e.replace(/{(.+?)}/g,(function(e,n){return t&&t[n]}))}function remove$1(e,t){for(var n=e.length;--n>=0;)e[n]===t&&e.splice(n,1);}function mergeSort(e,t){return e.length<2?e.slice():function e(n){if(n.length<=1)return n;var o=Math.floor(n.length/2),i=n.slice(0,o),r=n.slice(o);return function(e,n){for(var o=[],i=0,r=0,a=0;i<e.length&&r<n.length;)t(e[i],n[r])<=0?o[a++]=e[i++]:o[a++]=n[r++];return i<e.length&&o.push.apply(o,e.slice(i)),r<n.length&&o.push.apply(o,n.slice(r)),o}(i=e(i),r=e(r))}(e)}function makePredicate(e){return Array.isArray(e)||(e=e.split(" ")),new Set(e)}function map_add(e,t,n){e.has(t)?e.get(t).push(n):e.set(t,[n]);}function map_from_object(e){var t=new Map;for(var n in e)HOP(e,n)&&"$"===n.charAt(0)&&t.set(n.substr(1),e[n]);return t}function map_to_object(e){var t=Object.create(null);return e.forEach((function(e,n){t["$"+n]=e;})),t}function HOP(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function keep_name(e,t){return !0===e||e instanceof RegExp&&e.test(t)}var lineTerminatorEscape={"\0":"0","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"};function regexp_source_fix(e){return e.replace(/[\0\n\r\u2028\u2029]/g,(function(t,n){return ("\\"!=e[n-1]||"\\"==e[n-2]&&!/(?:^|[^\\])(?:\\{2})*$/.test(e.slice(0,n-1))?"\\":"")+lineTerminatorEscape[t]}))}function sort_regexp_flags(e){const t=new Set(e.split(""));let n="";for(const e of "gimuy")t.has(e)&&(n+=e,t.delete(e));return t.size&&t.forEach((e=>{n+=e;})),n}function has_annotation(e,t){return e._annotations&t}function set_annotation(e,t){e._annotations|=t;}var LATEST_RAW="",LATEST_TEMPLATE_END=!0,KEYWORDS="break case catch class const continue debugger default delete do else export extends finally for function if in instanceof let new return switch throw try typeof var void while with",KEYWORDS_ATOM="false null true",RESERVED_WORDS="enum implements import interface package private protected public static super this "+KEYWORDS_ATOM+" "+KEYWORDS,KEYWORDS_BEFORE_EXPRESSION="return new delete throw else case yield await";KEYWORDS=makePredicate(KEYWORDS),RESERVED_WORDS=makePredicate(RESERVED_WORDS),KEYWORDS_BEFORE_EXPRESSION=makePredicate(KEYWORDS_BEFORE_EXPRESSION),KEYWORDS_ATOM=makePredicate(KEYWORDS_ATOM);var OPERATOR_CHARS=makePredicate(characters("+-*&%=<>!?|~^")),RE_NUM_LITERAL=/[0-9a-f]/i,RE_HEX_NUMBER=/^0x[0-9a-f]+$/i,RE_OCT_NUMBER=/^0[0-7]+$/,RE_ES6_OCT_NUMBER=/^0o[0-7]+$/i,RE_BIN_NUMBER=/^0b[01]+$/i,RE_DEC_NUMBER=/^\d*\.?\d*(?:e[+-]?\d*(?:\d\.?|\.?\d)\d*)?$/i,RE_BIG_INT=/^(0[xob])?[0-9a-f]+n$/i,OPERATORS=makePredicate(["in","instanceof","typeof","new","void","delete","++","--","+","-","!","~","&","|","^","*","**","/","%",">>","<<",">>>","<",">","<=",">=","==","===","!=","!==","?","=","+=","-=","||=","&&=","??=","/=","*=","**=","%=",">>=","<<=",">>>=","|=","^=","&=","&&","??","||"]),WHITESPACE_CHARS=makePredicate(characters("  \n\r\t\f\v​           \u2028\u2029  　\ufeff")),NEWLINE_CHARS=makePredicate(characters("\n\r\u2028\u2029")),PUNC_AFTER_EXPRESSION=makePredicate(characters(";]),:")),PUNC_BEFORE_EXPRESSION=makePredicate(characters("[{(,;:")),PUNC_CHARS=makePredicate(characters("[]{}(),;:")),UNICODE={ID_Start:/[$A-Z_a-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]/,ID_Continue:/(?:[$0-9A-Z_a-z\xAA\xB5\xB7\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u08A0-\u08B4\u08E3-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0AF9\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D57\u0D5F-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1369-\u1371\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1CD0-\u1CD2\u1CD4-\u1CF6\u1CF8\u1CF9\u1D00-\u1DF5\u1DFC-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200C\u200D\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C4\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA8FD\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDCA-\uDDCC\uDDD0-\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE37\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDDD8-\uDDDD\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF39]|\uD806[\uDCA0-\uDCE9\uDCFF\uDEC0-\uDEF8]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF])+/};function get_full_char(e,t){if(is_surrogate_pair_head(e.charCodeAt(t))){if(is_surrogate_pair_tail(e.charCodeAt(t+1)))return e.charAt(t)+e.charAt(t+1)}else if(is_surrogate_pair_tail(e.charCodeAt(t))&&is_surrogate_pair_head(e.charCodeAt(t-1)))return e.charAt(t-1)+e.charAt(t);return e.charAt(t)}function get_full_char_code(e,t){return is_surrogate_pair_head(e.charCodeAt(t))?65536+(e.charCodeAt(t)-55296<<10)+e.charCodeAt(t+1)-56320:e.charCodeAt(t)}function get_full_char_length(e){for(var t=0,n=0;n<e.length;n++)is_surrogate_pair_head(e.charCodeAt(n))&&is_surrogate_pair_tail(e.charCodeAt(n+1))&&(t++,n++);return e.length-t}function from_char_code(e){return e>65535?(e-=65536,String.fromCharCode(55296+(e>>10))+String.fromCharCode(e%1024+56320)):String.fromCharCode(e)}function is_surrogate_pair_head(e){return e>=55296&&e<=56319}function is_surrogate_pair_tail(e){return e>=56320&&e<=57343}function is_digit(e){return e>=48&&e<=57}function is_identifier_start(e){return UNICODE.ID_Start.test(e)}function is_identifier_char(e){return UNICODE.ID_Continue.test(e)}const BASIC_IDENT=/^[a-z_$][a-z0-9_$]*$/i;function is_basic_identifier_string(e){return BASIC_IDENT.test(e)}function is_identifier_string(e,t){if(BASIC_IDENT.test(e))return !0;if(!t&&/[\ud800-\udfff]/.test(e))return !1;var n=UNICODE.ID_Start.exec(e);return !(!n||0!==n.index||(e=e.slice(n[0].length))&&(!(n=UNICODE.ID_Continue.exec(e))||n[0].length!==e.length))}function parse_js_number(e,t=!0){if(!t&&e.includes("e"))return NaN;if(RE_HEX_NUMBER.test(e))return parseInt(e.substr(2),16);if(RE_OCT_NUMBER.test(e))return parseInt(e.substr(1),8);if(RE_ES6_OCT_NUMBER.test(e))return parseInt(e.substr(2),8);if(RE_BIN_NUMBER.test(e))return parseInt(e.substr(2),2);if(RE_DEC_NUMBER.test(e))return parseFloat(e);var n=parseFloat(e);return n==e?n:void 0}class JS_Parse_Error extends Error{constructor(e,t,n,o,i){super(),this.name="SyntaxError",this.message=e,this.filename=t,this.line=n,this.col=o,this.pos=i;}}function js_error(e,t,n,o,i){throw new JS_Parse_Error(e,t,n,o,i)}function is_token(e,t,n){return e.type==t&&(null==n||e.value==n)}var EX_EOF={};function tokenizer$1(e,t,n,o){var i={text:e,filename:t,pos:0,tokpos:0,line:1,tokline:0,col:0,tokcol:0,newline_before:!1,regex_allowed:!1,brace_counter:0,template_braces:[],comments_before:[],directives:{},directive_stack:[]};function r(){return get_full_char(i.text,i.pos)}function a(){if(46!==i.text.charCodeAt(i.pos+1))return !1;const e=i.text.charCodeAt(i.pos+2);return e<48||e>57}function s(e,t){var n=get_full_char(i.text,i.pos++);if(e&&!n)throw EX_EOF;return NEWLINE_CHARS.has(n)?(i.newline_before=i.newline_before||!t,++i.line,i.col=0,"\r"==n&&"\n"==r()&&(++i.pos,n="\n")):(n.length>1&&(++i.pos,++i.col),++i.col),n}function u(e){for(;e--;)s();}function l(e){return i.text.substr(i.pos,e.length)==e}function _(e,t){var n=i.text.indexOf(e,i.pos);if(t&&-1==n)throw EX_EOF;return n}function c(){i.tokline=i.line,i.tokcol=i.col,i.tokpos=i.pos;}var f=!1,p=null;function d(e,n,o){i.regex_allowed="operator"==e&&!UNARY_POSTFIX.has(n)||"keyword"==e&&KEYWORDS_BEFORE_EXPRESSION.has(n)||"punc"==e&&PUNC_BEFORE_EXPRESSION.has(n)||"arrow"==e,"punc"!=e||"."!=n&&"?."!=n?o||(f=!1):f=!0;const r=i.tokline,a=i.tokcol,s=i.tokpos,u=i.newline_before,l=t;let _=[],c=[];o||(_=i.comments_before,c=i.comments_before=[]),i.newline_before=!1;const d=new AST_Token(e,n,r,a,s,u,_,c,l);return o||(p=d),d}function S(){for(;WHITESPACE_CHARS.has(r());)s();}function m(e){js_error(e,t,i.tokline,i.tokcol,i.tokpos);}function A(e){var t=!1,n=!1,o=!1,i="."==e,a=!1,u=!1,l=function(e){for(var t,n="",o=0;(t=r())&&e(t,o++);)n+=s();return n}((function(r,s){if(a)return !1;switch(r.charCodeAt(0)){case 95:return u=!0;case 98:case 66:return o=!0;case 111:case 79:case 120:case 88:return !o&&(o=!0);case 101:case 69:return !!o||!t&&(t=n=!0);case 45:return n||0==s&&!e;case 43:return n;case n=!1,46:return !(i||o||t)&&(i=!0)}return "n"===r?(a=!0,!0):RE_NUM_LITERAL.test(r)}));if(e&&(l=e+l),LATEST_RAW=l,RE_OCT_NUMBER.test(l)&&F.has_directive("use strict")&&m("Legacy octal literals are not allowed in strict mode"),u&&(l.endsWith("_")?m("Numeric separators are not allowed at the end of numeric literals"):l.includes("__")&&m("Only one underscore is allowed as numeric separator"),l=l.replace(/_/g,"")),l.endsWith("n")){const e=l.slice(0,-1),t=parse_js_number(e,RE_HEX_NUMBER.test(e));if(!i&&RE_BIG_INT.test(l)&&!isNaN(t))return d("big_int",e);m("Invalid or unexpected token");}var _=parse_js_number(l);if(!isNaN(_))return d("num",_);m("Invalid syntax: "+l);}function T(e){return e>="0"&&e<="7"}function h(e,t,n){var o=s(!0,e);switch(o.charCodeAt(0)){case 110:return "\n";case 114:return "\r";case 116:return "\t";case 98:return "\b";case 118:return "\v";case 102:return "\f";case 120:return String.fromCharCode(E(2,t));case 117:if("{"==r()){for(s(!0),"}"===r()&&m("Expecting hex-character between {}");"0"==r();)s(!0);var a,u=_("}",!0)-i.pos;return (u>6||(a=E(u,t))>1114111)&&m("Unicode reference out of bounds"),s(!0),from_char_code(a)}return String.fromCharCode(E(4,t));case 10:return "";case 13:if("\n"==r())return s(!0,e),""}return T(o)?(n&&t&&("0"===o&&!T(r())||m("Octal escape sequences are not allowed in template strings")),function(e,t){var n=r();return n>="0"&&n<="7"&&(e+=s(!0))[0]<="3"&&(n=r())>="0"&&n<="7"&&(e+=s(!0)),"0"===e?"\0":(e.length>0&&F.has_directive("use strict")&&t&&m("Legacy octal escape sequences are not allowed in strict mode"),String.fromCharCode(parseInt(e,8)))}(o,t)):o}function E(e,t){for(var n=0;e>0;--e){if(!t&&isNaN(parseInt(r(),16)))return parseInt(n,16)||"";var o=s(!0);isNaN(parseInt(o,16))&&m("Invalid hex-character pattern in string"),n+=o;}return parseInt(n,16)}var g=O("Unterminated string constant",(function(){const e=i.pos;for(var t=s(),n=[];;){var o=s(!0,!0);if("\\"==o)o=h(!0,!0);else if("\r"==o||"\n"==o)m("Unterminated string constant");else if(o==t)break;n.push(o);}var r=d("string",n.join(""));return LATEST_RAW=i.text.slice(e,i.pos),r.quote=t,r})),D=O("Unterminated template",(function(e){e&&i.template_braces.push(i.brace_counter);var t,n,o="",a="";for(s(!0,!0);"`"!=(t=s(!0,!0));){if("\r"==t)"\n"==r()&&++i.pos,t="\n";else if("$"==t&&"{"==r())return s(!0,!0),i.brace_counter++,n=d(e?"template_head":"template_substitution",o),LATEST_RAW=a,LATEST_TEMPLATE_END=!1,n;if(a+=t,"\\"==t){var u=i.pos;t=h(!0,!(p&&("name"===p.type||"punc"===p.type&&(")"===p.value||"]"===p.value))),!0),a+=i.text.substr(u,i.pos-u);}o+=t;}return i.template_braces.pop(),n=d(e?"template_head":"template_substitution",o),LATEST_RAW=a,LATEST_TEMPLATE_END=!0,n}));function b(e){var t,n=i.regex_allowed,o=function(){for(var e=i.text,t=i.pos,n=i.text.length;t<n;++t){var o=e[t];if(NEWLINE_CHARS.has(o))return t}return -1}();return -1==o?(t=i.text.substr(i.pos),i.pos=i.text.length):(t=i.text.substring(i.pos,o),i.pos=o),i.col=i.tokcol+(i.pos-i.tokpos),i.comments_before.push(d(e,t,!0)),i.regex_allowed=n,F}var y=O("Unterminated multiline comment",(function(){var e=i.regex_allowed,t=_("*/",!0),n=i.text.substring(i.pos,t).replace(/\r\n|\r|\u2028|\u2029/g,"\n");return u(get_full_char_length(n)+2),i.comments_before.push(d("comment2",n,!0)),i.newline_before=i.newline_before||n.includes("\n"),i.regex_allowed=e,F})),v=O("Unterminated identifier name",(function(){var e,t=[],n=!1,o=function(){return n=!0,s(),"u"!==r()&&m("Expecting UnicodeEscapeSequence -- uXXXX or u{XXXX}"),h(!1,!0)};if("\\"===(e=r()))is_identifier_start(e=o())||m("First identifier char is an invalid identifier char");else {if(!is_identifier_start(e))return "";s();}for(t.push(e);null!=(e=r());){if("\\"===(e=r()))is_identifier_char(e=o())||m("Invalid escaped identifier char");else {if(!is_identifier_char(e))break;s();}t.push(e);}const i=t.join("");return RESERVED_WORDS.has(i)&&n&&m("Escaped characters are not allowed in keywords"),i})),C=O("Unterminated regular expression",(function(e){for(var t,n=!1,o=!1;t=s(!0);)if(NEWLINE_CHARS.has(t))m("Unexpected line terminator");else if(n)e+="\\"+t,n=!1;else if("["==t)o=!0,e+=t;else if("]"==t&&o)o=!1,e+=t;else {if("/"==t&&!o)break;"\\"==t?n=!0:e+=t;}return d("regexp","/"+e+"/"+v())}));function R(e){return d("operator",function e(t){if(!r())return t;var n=t+r();return OPERATORS.has(n)?(s(),e(n)):t}(e||s()))}function k(){switch(s(),r()){case"/":return s(),b("comment1");case"*":return s(),y()}return i.regex_allowed?C(""):R("/")}function O(e,t){return function(n){try{return t(n)}catch(t){if(t!==EX_EOF)throw t;m(e);}}}function F(e){if(null!=e)return C(e);for(o&&0==i.pos&&l("#!")&&(c(),u(2),b("comment5"));;){if(S(),c(),n){if(l("\x3c!--")){u(4),b("comment3");continue}if(l("--\x3e")&&i.newline_before){u(3),b("comment4");continue}}var t=r();if(!t)return d("eof");var _=t.charCodeAt(0);switch(_){case 34:case 39:return g();case 46:return s(),is_digit(r().charCodeAt(0))?A("."):"."===r()?(s(),s(),d("expand","...")):d("punc",".");case 47:var p=k();if(p===F)continue;return p;case 61:return s(),">"===r()?(s(),d("arrow","=>")):R("=");case 63:if(!a())break;return s(),s(),d("punc","?.");case 96:return D(!0);case 123:i.brace_counter++;break;case 125:if(i.brace_counter--,i.template_braces.length>0&&i.template_braces[i.template_braces.length-1]===i.brace_counter)return D(!1)}if(is_digit(_))return A();if(PUNC_CHARS.has(t))return d("punc",s());if(OPERATOR_CHARS.has(t))return R();if(92==_||is_identifier_start(t))return T=v(),f?d("name",T):KEYWORDS_ATOM.has(T)?d("atom",T):KEYWORDS.has(T)?OPERATORS.has(T)?d("operator",T):d("keyword",T):d("name",T);if(35==_)return s(),d("privatename",v());break}var T;m("Unexpected character '"+t+"'");}return F.next=s,F.peek=r,F.context=function(e){return e&&(i=e),i},F.add_directive=function(e){i.directive_stack[i.directive_stack.length-1].push(e),void 0===i.directives[e]?i.directives[e]=1:i.directives[e]++;},F.push_directives_stack=function(){i.directive_stack.push([]);},F.pop_directives_stack=function(){for(var e=i.directive_stack[i.directive_stack.length-1],t=0;t<e.length;t++)i.directives[e[t]]--;i.directive_stack.pop();},F.has_directive=function(e){return i.directives[e]>0},F}var UNARY_PREFIX=makePredicate(["typeof","void","delete","--","++","!","~","-","+"]),UNARY_POSTFIX=makePredicate(["--","++"]),ASSIGNMENT=makePredicate(["=","+=","-=","??=","&&=","||=","/=","*=","**=","%=",">>=","<<=",">>>=","|=","^=","&="]),LOGICAL_ASSIGNMENT=makePredicate(["??=","&&=","||="]),PRECEDENCE=function(e,t){for(var n=0;n<e.length;++n)for(var o=e[n],i=0;i<o.length;++i)t[o[i]]=n+1;return t}([["||"],["??"],["&&"],["|"],["^"],["&"],["==","===","!=","!=="],["<",">","<=",">=","in","instanceof"],[">>","<<",">>>"],["+","-"],["*","/","%"],["**"]],{}),ATOMIC_START_TOKEN=makePredicate(["atom","num","big_int","string","regexp","name"]);function parse$5(e,t){const n=new WeakMap;t=defaults$1(t,{bare_returns:!1,ecma:null,expression:!1,filename:null,html5_comments:!0,module:!1,shebang:!0,strict:!1,toplevel:null},!0);var o={input:"string"==typeof e?tokenizer$1(e,t.filename,t.html5_comments,t.shebang):e,token:null,prev:null,peeked:null,in_function:0,in_async:-1,in_generator:-1,in_directives:!0,in_loop:0,labels:[]};function i(e,t){return is_token(o.token,e,t)}function r(){return o.peeked||(o.peeked=o.input())}function a(){return o.prev=o.token,o.peeked||r(),o.token=o.peeked,o.peeked=null,o.in_directives=o.in_directives&&("string"==o.token.type||i("punc",";")),o.token}function s(){return o.prev}function u(e,t,n,i){var r=o.input.context();js_error(e,r.filename,null!=t?t:r.tokline,null!=n?n:r.tokcol,null!=i?i:r.tokpos);}function l(e,t){u(t,e.line,e.col);}function _(e){null==e&&(e=o.token),l(e,"Unexpected token: "+e.type+" ("+e.value+")");}function c(e,t){if(i(e,t))return a();l(o.token,"Unexpected token "+o.token.type+" «"+o.token.value+"», expected "+e+" «"+t+"»");}function f(e){return c("punc",e)}function p(e){return e.nlb||!e.comments_before.every((e=>!e.nlb))}function d(){return !t.strict&&(i("eof")||i("punc","}")||p(o.token))}function S(){return o.in_generator===o.in_function}function m(){return o.in_async===o.in_function||0===o.in_function&&o.input.has_directive("use strict")}function A(e){i("punc",";")?a():e||d()||_();}function T(){f("(");var e=Se(!0);return f(")"),e}function h(e){return function(...t){const n=o.token,i=e(...t);return i.start=n,i.end=s(),i}}function E(){(i("operator","/")||i("operator","/="))&&(o.peeked=null,o.token=o.input(o.token.value.substr(1)));}o.token=a();var g=h((function e(n,S,h){switch(E(),o.token.type){case"string":if(o.in_directives){var g=r();!LATEST_RAW.includes("\\")&&(is_token(g,"punc",";")||is_token(g,"punc","}")||p(g)||is_token(g,"eof"))?o.input.add_directive(o.token.value):o.in_directives=!1;}var k=o.in_directives,F=b();return k&&F.body instanceof AST_String?new AST_Directive(F.body):F;case"template_head":case"num":case"big_int":case"regexp":case"operator":case"atom":return b();case"name":if("async"==o.token.value&&is_token(r(),"keyword","function"))return a(),a(),S&&u("functions are not allowed as the body of a loop"),O(AST_Defun,!1,!0,n);if("import"==o.token.value&&!is_token(r(),"punc","(")&&!is_token(r(),"punc",".")){a();var M=function(){var e,t,n=s();i("name")&&(e=re(AST_SymbolImport)),i("punc",",")&&a(),((t=J(!0))||e)&&c("name","from");var r=o.token;return "string"!==r.type&&_(),a(),new AST_Import({start:n,imported_name:e,imported_names:t,module_name:new AST_String({start:r,value:r.value,quote:r.quote,end:r}),end:o.token})}();return A(),M}return is_token(r(),"punc",":")?D():b();case"punc":switch(o.token.value){case"{":return new AST_BlockStatement({start:o.token,body:w(),end:s()});case"[":case"(":return b();case";":return o.in_directives=!1,a(),new AST_EmptyStatement;default:_();}case"keyword":switch(o.token.value){case"break":return a(),y(AST_Break);case"continue":return a(),y(AST_Continue);case"debugger":return a(),A(),new AST_Debugger;case"do":a();var I=me(e);c("keyword","while");var B=T();return A(!0),new AST_Do({body:I,condition:B});case"while":return a(),new AST_While({condition:T(),body:me((function(){return e(!1,!0)}))});case"for":return a(),function(){var e="`for await` invalid in this context",t=o.token;"name"==t.type&&"await"==t.value?(m()||l(t,e),a()):t=!1,f("(");var n=null;if(i("punc",";"))t&&l(t,e);else {n=i("keyword","var")?(a(),L(!0)):i("keyword","let")?(a(),V(!0)):i("keyword","const")?(a(),U(!0)):Se(!0,!0);var r=i("operator","in"),s=i("name","of");if(t&&!s&&l(t,e),r||s)return n instanceof AST_Definitions?n.definitions.length>1&&l(n.start,"Only one variable declaration allowed in for..in loop"):fe(n)||(n=pe(n))instanceof AST_Destructuring||l(n.start,"Invalid left-hand side in for..in loop"),a(),r?R(n):C(n,!!t)}return v(n)}();case"class":return a(),S&&u("classes are not allowed as the body of a loop"),h&&u("classes are not allowed as the body of an if"),j(AST_DefClass);case"function":return a(),S&&u("functions are not allowed as the body of a loop"),O(AST_Defun,!1,!1,n);case"if":return a(),x();case"return":0!=o.in_function||t.bare_returns||u("'return' outside of function"),a();var K=null;return i("punc",";")?a():d()||(K=Se(!0),A()),new AST_Return({value:K});case"switch":return a(),new AST_Switch({expression:T(),body:me(P)});case"throw":return a(),p(o.token)&&u("Illegal newline after 'throw'"),K=Se(!0),A(),new AST_Throw({value:K});case"try":return a(),function(){var e=w(),t=null,n=null;if(i("keyword","catch")){var r=o.token;if(a(),i("punc","{"))var l=null;else f("("),l=N(void 0,AST_SymbolCatch),f(")");t=new AST_Catch({start:r,argname:l,body:w(),end:s()});}return i("keyword","finally")&&(r=o.token,a(),n=new AST_Finally({start:r,body:w(),end:s()})),t||n||u("Missing catch/finally blocks"),new AST_Try({body:e,bcatch:t,bfinally:n})}();case"var":return a(),M=L(),A(),M;case"let":return a(),M=V(),A(),M;case"const":return a(),M=U(),A(),M;case"with":return o.input.has_directive("use strict")&&u("Strict mode may not include a with statement"),a(),new AST_With({expression:T(),body:e()});case"export":if(!is_token(r(),"punc","("))return a(),M=ee(),i("punc",";")&&A(),M}}_();}));function D(){var e=re(AST_Label);"await"===e.name&&o.in_async===o.in_function&&l(o.prev,"await cannot be used as label inside async function"),o.labels.some((t=>t.name===e.name))&&u("Label "+e.name+" defined twice"),f(":"),o.labels.push(e);var t=g();return o.labels.pop(),t instanceof AST_IterationStatement||e.references.forEach((function(t){t instanceof AST_Continue&&(t=t.label.start,u("Continue label `"+e.name+"` refers to non-IterationStatement.",t.line,t.col,t.pos));})),new AST_LabeledStatement({body:t,label:e})}function b(e){return new AST_SimpleStatement({body:(e=Se(!0),A(),e)})}function y(e){var t,n=null;d()||(n=re(AST_LabelRef,!0)),null!=n?((t=o.labels.find((e=>e.name===n.name)))||u("Undefined label "+n.name),n.thedef=t):0==o.in_loop&&u(e.TYPE+" not inside a loop or switch"),A();var i=new e({label:n});return t&&t.references.push(i),i}function v(e){f(";");var t=i("punc",";")?null:Se(!0);f(";");var n=i("punc",")")?null:Se(!0);return f(")"),new AST_For({init:e,condition:t,step:n,body:me((function(){return g(!1,!0)}))})}function C(e,t){var n=e instanceof AST_Definitions?e.definitions[0].name:null,o=Se(!0);return f(")"),new AST_ForOf({await:t,init:e,name:n,object:o,body:me((function(){return g(!1,!0)}))})}function R(e){var t=Se(!0);return f(")"),new AST_ForIn({init:e,object:t,body:me((function(){return g(!1,!0)}))})}var k=function(e,t,n){p(o.token)&&u("Unexpected newline before arrow (=>)"),c("arrow","=>");var r=I(i("punc","{"),!1,n),a=r instanceof Array&&r.length?r[r.length-1].end:r instanceof Array?e:r.end;return new AST_Arrow({start:e,end:a,async:n,argnames:t,body:r})},O=function(e,t,n,o){var r=e===AST_Defun,u=i("operator","*");u&&a();var l=i("name")?re(r?AST_SymbolDefun:AST_SymbolLambda):null;r&&!l&&(o?e=AST_Function:_()),!l||e===AST_Accessor||l instanceof AST_SymbolDeclaration||_(s());var c=[],f=I(!0,u||t,n,l,c);return new e({start:c.start,end:f.end,is_generator:u,async:n,name:l,argnames:c,body:f})};function F(e,t){var n=new Set,o=!1,i=!1,r=!1,a=!!t,s={add_parameter:function(t){if(n.has(t.value))!1===o&&(o=t),s.check_strict();else if(n.add(t.value),e)switch(t.value){case"arguments":case"eval":case"yield":a&&l(t,"Unexpected "+t.value+" identifier as parameter inside strict mode");break;default:RESERVED_WORDS.has(t.value)&&_();}},mark_default_assignment:function(e){!1===i&&(i=e);},mark_spread:function(e){!1===r&&(r=e);},mark_strict_mode:function(){a=!0;},is_strict:function(){return !1!==i||!1!==r||a},check_strict:function(){s.is_strict()&&!1!==o&&l(o,"Parameter "+o.value+" was used already");}};return s}function N(e,t){var n,r=!1;return void 0===e&&(e=F(!0,o.input.has_directive("use strict"))),i("expand","...")&&(r=o.token,e.mark_spread(o.token),a()),n=M(e,t),i("operator","=")&&!1===r&&(e.mark_default_assignment(o.token),a(),n=new AST_DefaultAssign({start:n.start,left:n,operator:"=",right:Se(!1),end:o.token})),!1!==r&&(i("punc",")")||_(),n=new AST_Expansion({start:r,expression:n,end:r})),e.check_strict(),n}function M(e,t){var n,l=[],c=!0,p=!1,d=o.token;if(void 0===e&&(e=F(!1,o.input.has_directive("use strict"))),t=void 0===t?AST_SymbolFunarg:t,i("punc","[")){for(a();!i("punc","]");){if(c?c=!1:f(","),i("expand","...")&&(p=!0,n=o.token,e.mark_spread(o.token),a()),i("punc"))switch(o.token.value){case",":l.push(new AST_Hole({start:o.token,end:o.token}));continue;case"]":break;case"[":case"{":l.push(M(e,t));break;default:_();}else i("name")?(e.add_parameter(o.token),l.push(re(t))):u("Invalid function parameter");i("operator","=")&&!1===p&&(e.mark_default_assignment(o.token),a(),l[l.length-1]=new AST_DefaultAssign({start:l[l.length-1].start,left:l[l.length-1],operator:"=",right:Se(!1),end:o.token})),p&&(i("punc","]")||u("Rest element must be last element"),l[l.length-1]=new AST_Expansion({start:n,expression:l[l.length-1],end:n}));}return f("]"),e.check_strict(),new AST_Destructuring({start:d,names:l,is_array:!0,end:s()})}if(i("punc","{")){for(a();!i("punc","}");){if(c?c=!1:f(","),i("expand","...")&&(p=!0,n=o.token,e.mark_spread(o.token),a()),i("name")&&(is_token(r(),"punc")||is_token(r(),"operator"))&&[",","}","="].includes(r().value)){e.add_parameter(o.token);var S=s(),m=re(t);p?l.push(new AST_Expansion({start:n,expression:m,end:m.end})):l.push(new AST_ObjectKeyVal({start:S,key:m.name,value:m,end:m.end}));}else {if(i("punc","}"))continue;var A=o.token,T=te();null===T?_(s()):"name"!==s().type||i("punc",":")?(f(":"),l.push(new AST_ObjectKeyVal({start:A,quote:A.quote,key:T,value:M(e,t),end:s()}))):l.push(new AST_ObjectKeyVal({start:s(),key:T,value:new t({start:s(),name:T,end:s()}),end:s()}));}p?i("punc","}")||u("Rest element must be last element"):i("operator","=")&&(e.mark_default_assignment(o.token),a(),l[l.length-1].value=new AST_DefaultAssign({start:l[l.length-1].value.start,left:l[l.length-1].value,operator:"=",right:Se(!1),end:o.token}));}return f("}"),e.check_strict(),new AST_Destructuring({start:d,names:l,is_array:!1,end:s()})}if(i("name"))return e.add_parameter(o.token),re(t);u("Invalid function parameter");}function I(e,t,n,r,s){var u=o.in_loop,l=o.labels,_=o.in_generator,c=o.in_async;if(++o.in_function,t&&(o.in_generator=o.in_function),n&&(o.in_async=o.in_function),s&&function(e){var t=F(!0,o.input.has_directive("use strict"));for(f("(");!i("punc",")");){var n=N(t);if(e.push(n),i("punc",")")||f(","),n instanceof AST_Expansion)break}a();}(s),e&&(o.in_directives=!0),o.in_loop=0,o.labels=[],e){o.input.push_directives_stack();var p=w();r&&ie(r),s&&s.forEach(ie),o.input.pop_directives_stack();}else p=[new AST_Return({start:o.token,value:Se(!1),end:o.token})];return --o.in_function,o.in_loop=u,o.labels=l,o.in_generator=_,o.in_async=c,p}function x(){var e=T(),t=g(!1,!1,!0),n=null;return i("keyword","else")&&(a(),n=g(!1,!1,!0)),new AST_If({condition:e,body:t,alternative:n})}function w(){f("{");for(var e=[];!i("punc","}");)i("eof")&&_(),e.push(g());return a(),e}function P(){f("{");for(var e,t=[],n=null,r=null;!i("punc","}");)i("eof")&&_(),i("keyword","case")?(r&&(r.end=s()),n=[],r=new AST_Case({start:(e=o.token,a(),e),expression:Se(!0),body:n}),t.push(r),f(":")):i("keyword","default")?(r&&(r.end=s()),n=[],r=new AST_Default({start:(e=o.token,a(),f(":"),e),body:n}),t.push(r)):(n||_(),n.push(g()));return r&&(r.end=s()),a(),t}function B(e,t){for(var n,r=[];;){var l="var"===t?AST_SymbolVar:"const"===t?AST_SymbolConst:"let"===t?AST_SymbolLet:null;if(i("punc","{")||i("punc","[")?n=new AST_VarDef({start:o.token,name:M(void 0,l),value:i("operator","=")?(c("operator","="),Se(!1,e)):null,end:s()}):"import"==(n=new AST_VarDef({start:o.token,name:re(l),value:i("operator","=")?(a(),Se(!1,e)):e||"const"!==t?null:u("Missing initializer in const declaration"),end:s()})).name.name&&u("Unexpected token: import"),r.push(n),!i("punc",","))break;a();}return r}var L=function(e){return new AST_Var({start:s(),definitions:B(e,"var"),end:s()})},V=function(e){return new AST_Let({start:s(),definitions:B(e,"let"),end:s()})},U=function(e){return new AST_Const({start:s(),definitions:B(e,"const"),end:s()})};function K(){var e,t=o.token;switch(t.type){case"name":e=oe(AST_SymbolRef);break;case"num":e=new AST_Number({start:t,end:t,value:t.value,raw:LATEST_RAW});break;case"big_int":e=new AST_BigInt({start:t,end:t,value:t.value});break;case"string":e=new AST_String({start:t,end:t,value:t.value,quote:t.quote});break;case"regexp":const[n,o,i]=t.value.match(/^\/(.*)\/(\w*)$/);e=new AST_RegExp({start:t,end:t,value:{source:o,flags:i}});break;case"atom":switch(t.value){case"false":e=new AST_False({start:t,end:t});break;case"true":e=new AST_True({start:t,end:t});break;case"null":e=new AST_Null({start:t,end:t});}}return a(),e}function G(e,t){var n=function(e,t){return t?new AST_DefaultAssign({start:e.start,left:e,operator:"=",right:t,end:t.end}):e};return e instanceof AST_Object?n(new AST_Destructuring({start:e.start,end:e.end,is_array:!1,names:e.properties.map((e=>G(e)))}),t):e instanceof AST_ObjectKeyVal?(e.value=G(e.value),n(e,t)):e instanceof AST_Hole?e:e instanceof AST_Destructuring?(e.names=e.names.map((e=>G(e))),n(e,t)):e instanceof AST_SymbolRef?n(new AST_SymbolFunarg({name:e.name,start:e.start,end:e.end}),t):e instanceof AST_Expansion?(e.expression=G(e.expression),n(e,t)):e instanceof AST_Array?n(new AST_Destructuring({start:e.start,end:e.end,is_array:!0,names:e.elements.map((e=>G(e)))}),t):e instanceof AST_Assign?n(G(e.left,e.right),t):e instanceof AST_DefaultAssign?(e.left=G(e.left),e):void u("Invalid function parameter",e.start.line,e.start.col)}var H=function(e,t){if(i("operator","new"))return function(e){var t=o.token;if(c("operator","new"),i("punc","."))return a(),c("name","target"),se(new AST_NewTarget({start:t,end:s()}),e);var n,r=H(!1);i("punc","(")?(a(),n=z(")",!0)):n=[];var u=new AST_New({start:t,expression:r,args:n,end:s()});return ae(u),se(u,e)}(e);if(i("operator","import"))return function(){var e=o.token;return c("operator","import"),c("punc","."),c("name","meta"),se(new AST_ImportMeta({start:e,end:s()}),!1)}();var u,l=o.token,p=i("name","async")&&"["!=(u=r()).value&&"arrow"!=u.type&&K();if(i("punc")){switch(o.token.value){case"(":if(p&&!e)break;var d=function(e,t){var n,r,u,l=[];for(f("(");!i("punc",")");)n&&_(n),i("expand","...")?(n=o.token,t&&(r=o.token),a(),l.push(new AST_Expansion({start:s(),expression:Se(),end:o.token}))):l.push(Se()),i("punc",")")||(f(","),i("punc",")")&&(u=s(),t&&(r=u)));return f(")"),e&&i("arrow","=>")?n&&u&&_(u):r&&_(r),l}(t,!p);if(t&&i("arrow","=>"))return k(l,d.map((e=>G(e))),!!p);var S=p?new AST_Call({expression:p,args:d}):1==d.length?d[0]:new AST_Sequence({expressions:d});if(S.start){const e=l.comments_before.length;if(n.set(l,e),S.start.comments_before.unshift(...l.comments_before),l.comments_before=S.start.comments_before,0==e&&l.comments_before.length>0){var m=l.comments_before[0];m.nlb||(m.nlb=l.nlb,l.nlb=!1);}l.comments_after=S.start.comments_after;}S.start=l;var A=s();return S.end&&(A.comments_before=S.end.comments_before,S.end.comments_after.push(...A.comments_after),A.comments_after=S.end.comments_after),S.end=A,S instanceof AST_Call&&ae(S),se(S,e);case"[":return se(W(),e);case"{":return se(Y(),e)}p||_();}if(t&&i("name")&&is_token(r(),"arrow")){var T=new AST_SymbolFunarg({name:o.token.value,start:l,end:l});return a(),k(l,[T],!!p)}if(i("keyword","function")){a();var h=O(AST_Function,!1,!!p);return h.start=l,h.end=s(),se(h,e)}if(p)return se(p,e);if(i("keyword","class")){a();var E=j(AST_ClassExpression);return E.start=l,E.end=s(),se(E,e)}return i("template_head")?se(X(),e):ATOMIC_START_TOKEN.has(o.token.type)?se(K(),e):void _()};function X(){var e=[],t=o.token;for(e.push(new AST_TemplateSegment({start:o.token,raw:LATEST_RAW,value:o.token.value,end:o.token}));!LATEST_TEMPLATE_END;)a(),E(),e.push(Se(!0)),e.push(new AST_TemplateSegment({start:o.token,raw:LATEST_RAW,value:o.token.value,end:o.token}));return a(),new AST_TemplateString({start:t,segments:e,end:o.token})}function z(e,t,n){for(var r=!0,u=[];!i("punc",e)&&(r?r=!1:f(","),!t||!i("punc",e));)i("punc",",")&&n?u.push(new AST_Hole({start:o.token,end:o.token})):i("expand","...")?(a(),u.push(new AST_Expansion({start:s(),expression:Se(),end:o.token}))):u.push(Se(!1));return a(),u}var W=h((function(){return f("["),new AST_Array({elements:z("]",!t.strict,!0)})})),q=h(((e,t)=>O(AST_Accessor,e,t))),Y=h((function(){var e=o.token,n=!0,r=[];for(f("{");!i("punc","}")&&(n?n=!1:f(","),t.strict||!i("punc","}"));)if("expand"!=(e=o.token).type){var u,l=te();if(i("punc",":"))null===l?_(s()):(a(),u=Se(!1));else {var c=$(l,e);if(c){r.push(c);continue}u=new AST_SymbolRef({start:s(),name:l,end:s()});}i("operator","=")&&(a(),u=new AST_Assign({start:e,left:u,operator:"=",right:Se(!1),logical:!1,end:s()})),r.push(new AST_ObjectKeyVal({start:e,quote:e.quote,key:l instanceof AST_Node?l:""+l,value:u,end:s()}));}else a(),r.push(new AST_Expansion({start:e,expression:Se(!1),end:s()}));return a(),new AST_Object({properties:r})}));function j(e){var t,n,r,u,l=[];for(o.input.push_directives_stack(),o.input.add_directive("use strict"),"name"==o.token.type&&"extends"!=o.token.value&&(r=re(e===AST_DefClass?AST_SymbolDefClass:AST_SymbolClass)),e!==AST_DefClass||r||_(),"extends"==o.token.value&&(a(),u=Se(!0)),f("{");i("punc",";");)a();for(;!i("punc","}");)for(t=o.token,(n=$(te(),t,!0))||_(),l.push(n);i("punc",";");)a();return o.input.pop_directives_stack(),a(),new e({start:t,name:r,extends:u,properties:l,end:s()})}function $(e,t,n){var r=function(e,t){return "string"==typeof e||"number"==typeof e?new AST_SymbolMethod({start:t,name:""+e,end:s()}):(null===e&&_(),e)},u="privatename"==t.type,l=!1,c=!1,f=!1,p=t;if(n&&"static"===e&&!i("punc","(")&&(c=!0,u="privatename"==(p=o.token).type,e=te()),"async"!==e||i("punc","(")||i("punc",",")||i("punc","}")||i("operator","=")||(l=!0,u="privatename"==(p=o.token).type,e=te()),null===e&&(f=!0,u="privatename"==(p=o.token).type,null===(e=te())&&_()),i("punc","("))return e=r(e,t),new(u?AST_PrivateMethod:AST_ConciseMethod)({start:t,static:c,is_generator:f,async:l,key:e,quote:e instanceof AST_SymbolMethod?p.quote:void 0,value:q(f,l),end:s()});const d=o.token;if(("get"===e||"set"===e)&&"privatename"===d.type)return a(),new("get"===e?AST_PrivateGetter:AST_PrivateSetter)({start:t,static:c,key:r(d.value,t),value:q(),end:s()});if("get"==e){if(!i("punc")||i("punc","["))return e=r(te(),t),new AST_ObjectGetter({start:t,static:c,key:e,quote:e instanceof AST_SymbolMethod?d.quote:void 0,value:q(),end:s()})}else if("set"==e&&(!i("punc")||i("punc","[")))return e=r(te(),t),new AST_ObjectSetter({start:t,static:c,key:e,quote:e instanceof AST_SymbolMethod?d.quote:void 0,value:q(),end:s()});if(n){const n=(e=>"string"==typeof e||"number"==typeof e?new AST_SymbolClassProperty({start:p,end:p,name:""+e}):(null===e&&_(),e))(e),o=n instanceof AST_SymbolClassProperty?p.quote:void 0,r=u?AST_ClassPrivateProperty:AST_ClassProperty;if(i("operator","="))return a(),new r({start:t,static:c,quote:o,key:n,value:Se(!1),end:s()});if(i("name")||i("privatename")||i("operator","*")||i("punc",";")||i("punc","}"))return new r({start:t,static:c,quote:o,key:n,end:s()})}}function Z(e){function t(e){return new e({name:te(),start:s(),end:s()})}var n,r,u=e?AST_SymbolImportForeign:AST_SymbolExportForeign,l=e?AST_SymbolImport:AST_SymbolExport,_=o.token;return e?n=t(u):r=t(l),i("name","as")?(a(),e?r=t(l):n=t(u)):e?r=new l(n):n=new u(r),new AST_NameMapping({start:_,foreign_name:n,name:r,end:s()})}function Q(e,t){var n,i=e?AST_SymbolImportForeign:AST_SymbolExportForeign,r=e?AST_SymbolImport:AST_SymbolExport,a=o.token,u=s();return t=t||new r({name:"*",start:a,end:u}),n=new i({name:"*",start:a,end:u}),new AST_NameMapping({start:a,foreign_name:n,name:t,end:u})}function J(e){var t;if(i("punc","{")){for(a(),t=[];!i("punc","}");)t.push(Z(e)),i("punc",",")&&a();a();}else if(i("operator","*")){var n;a(),e&&i("name","as")&&(a(),n=re(e?AST_SymbolImport:AST_SymbolExportForeign)),t=[Q(e,n)];}return t}function ee(){var e,t,n,u,l,c=o.token;if(i("keyword","default"))e=!0,a();else if(t=J(!1)){if(i("name","from")){a();var f=o.token;return "string"!==f.type&&_(),a(),new AST_Export({start:c,is_default:e,exported_names:t,module_name:new AST_String({start:f,value:f.value,quote:f.quote,end:f}),end:s()})}return new AST_Export({start:c,is_default:e,exported_names:t,end:s()})}return i("punc","{")||e&&(i("keyword","class")||i("keyword","function"))&&is_token(r(),"punc")?(u=Se(!1),A()):(n=g(e))instanceof AST_Definitions&&e?_(n.start):n instanceof AST_Definitions||n instanceof AST_Lambda||n instanceof AST_DefClass?l=n:n instanceof AST_SimpleStatement?u=n.body:_(n.start),new AST_Export({start:c,is_default:e,exported_value:u,exported_definition:l,end:s()})}function te(){var e=o.token;switch(e.type){case"punc":if("["===e.value){a();var t=Se(!1);return f("]"),t}_(e);case"operator":if("*"===e.value)return a(),null;["delete","in","instanceof","new","typeof","void"].includes(e.value)||_(e);case"name":case"privatename":case"string":case"num":case"big_int":case"keyword":case"atom":return a(),e.value;default:_(e);}}function ne(){var e=o.token;return "name"!=e.type&&"privatename"!=e.type&&_(),a(),e.value}function oe(e){var t=o.token.value;return new("this"==t?AST_This:"super"==t?AST_Super:e)({name:String(t),start:o.token,end:o.token})}function ie(e){var t=e.name;S()&&"yield"==t&&l(e.start,"Yield cannot be used as identifier inside generators"),o.input.has_directive("use strict")&&("yield"==t&&l(e.start,"Unexpected yield identifier inside strict mode"),e instanceof AST_SymbolDeclaration&&("arguments"==t||"eval"==t)&&l(e.start,"Unexpected "+t+" in strict mode"));}function re(e,t){if(!i("name"))return t||u("Name expected"),null;var n=oe(e);return ie(n),a(),n}function ae(e){var t=e.start,o=t.comments_before;const i=n.get(t);for(var r=null!=i?i:o.length;--r>=0;){var a=o[r];if(/[@#]__/.test(a.value)){if(/[@#]__PURE__/.test(a.value)){set_annotation(e,_PURE);break}if(/[@#]__INLINE__/.test(a.value)){set_annotation(e,_INLINE);break}if(/[@#]__NOINLINE__/.test(a.value)){set_annotation(e,_NOINLINE);break}}}}var se=function(e,t,n){var o=e.start;if(i("punc",".")){a();const r=i("privatename")?AST_DotHash:AST_Dot;return se(new r({start:o,expression:e,optional:!1,property:ne(),end:s()}),t,n)}if(i("punc","[")){a();var r=Se(!0);return f("]"),se(new AST_Sub({start:o,expression:e,optional:!1,property:r,end:s()}),t,n)}if(t&&i("punc","(")){a();var u=new AST_Call({start:o,expression:e,optional:!1,args:ue(),end:s()});return ae(u),se(u,!0,n)}if(i("punc","?.")){let n;if(a(),t&&i("punc","(")){a();const t=new AST_Call({start:o,optional:!0,expression:e,args:ue(),end:s()});ae(t),n=se(t,!0,!0);}else if(i("name")||i("privatename")){const r=i("privatename")?AST_DotHash:AST_Dot;n=se(new r({start:o,expression:e,optional:!0,property:ne(),end:s()}),t,!0);}else if(i("punc","[")){a();const i=Se(!0);f("]"),n=se(new AST_Sub({start:o,expression:e,optional:!0,property:i,end:s()}),t,!0);}return n||_(),n instanceof AST_Chain?n:new AST_Chain({start:o,expression:n,end:s()})}return i("template_head")?(n&&_(),se(new AST_PrefixedTemplateString({start:o,prefix:e,template_string:X(),end:s()}),t)):e};function ue(){for(var e=[];!i("punc",")");)i("expand","...")?(a(),e.push(new AST_Expansion({start:s(),expression:Se(!1),end:s()}))):e.push(Se(!1)),i("punc",")")||f(",");return a(),e}var le=function(e,t){var n=o.token;if("name"==n.type&&"await"==n.value&&m())return a(),m()||u("Unexpected await expression outside async function",o.prev.line,o.prev.col,o.prev.pos),new AST_Await({start:s(),end:o.token,expression:le(!0)});if(i("operator")&&UNARY_PREFIX.has(n.value)){a(),E();var r=_e(AST_UnaryPrefix,n,le(e));return r.start=n,r.end=s(),r}for(var l=H(e,t);i("operator")&&UNARY_POSTFIX.has(o.token.value)&&!p(o.token);)l instanceof AST_Arrow&&_(),(l=_e(AST_UnaryPostfix,o.token,l)).start=n,l.end=o.token,a();return l};function _e(e,t,n){var i=t.value;switch(i){case"++":case"--":fe(n)||u("Invalid use of "+i+" operator",t.line,t.col,t.pos);break;case"delete":n instanceof AST_SymbolRef&&o.input.has_directive("use strict")&&u("Calling delete on expression not allowed in strict mode",n.start.line,n.start.col,n.start.pos);}return new e({operator:i,expression:n})}var ce=function(e,t,n){var r=i("operator")?o.token.value:null;"in"==r&&n&&(r=null),"**"==r&&e instanceof AST_UnaryPrefix&&!is_token(e.start,"punc","(")&&"--"!==e.operator&&"++"!==e.operator&&_(e.start);var s=null!=r?PRECEDENCE[r]:null;if(null!=s&&(s>t||"**"===r&&t===s)){a();var u=ce(le(!0),s,n);return ce(new AST_Binary({start:e.start,left:e,operator:r,right:u,end:u.end}),t,n)}return e};function fe(e){return e instanceof AST_PropAccess||e instanceof AST_SymbolRef}function pe(e){if(e instanceof AST_Object)e=new AST_Destructuring({start:e.start,names:e.properties.map(pe),is_array:!1,end:e.end});else if(e instanceof AST_Array){for(var t=[],n=0;n<e.elements.length;n++)e.elements[n]instanceof AST_Expansion&&(n+1!==e.elements.length&&l(e.elements[n].start,"Spread must the be last element in destructuring array"),e.elements[n].expression=pe(e.elements[n].expression)),t.push(pe(e.elements[n]));e=new AST_Destructuring({start:e.start,names:t,is_array:!0,end:e.end});}else e instanceof AST_ObjectProperty?e.value=pe(e.value):e instanceof AST_Assign&&(e=new AST_DefaultAssign({start:e.start,left:e.left,operator:"=",right:e.right,end:e.end}));return e}var de=function(e){E();var t=o.token;if("name"==t.type&&"yield"==t.value){if(S())return a(),function(){S()||u("Unexpected yield expression outside generator function",o.prev.line,o.prev.col,o.prev.pos);var e=o.token,t=!1,n=!0;return d()||i("punc")&&PUNC_AFTER_EXPRESSION.has(o.token.value)?n=!1:i("operator","*")&&(t=!0,a()),new AST_Yield({start:e,is_star:t,expression:n?Se():null,end:s()})}();o.input.has_directive("use strict")&&l(o.token,"Unexpected yield identifier inside strict mode");}var n=function(e){var t=o.token,n=function(e){return ce(le(!0,!0),0,e)}(e);if(i("operator","?")){a();var r=Se(!1);return f(":"),new AST_Conditional({start:t,condition:n,consequent:r,alternative:Se(!1,e),end:s()})}return n}(e),r=o.token.value;if(i("operator")&&ASSIGNMENT.has(r)){if(fe(n)||(n=pe(n))instanceof AST_Destructuring)return a(),new AST_Assign({start:t,left:n,operator:r,right:de(e),logical:LOGICAL_ASSIGNMENT.has(r),end:s()});u("Invalid assignment");}return n},Se=function(e,t){for(var n=o.token,s=[];s.push(de(t)),e&&i("punc",",");)a(),e=!0;return 1==s.length?s[0]:new AST_Sequence({start:n,expressions:s,end:r()})};function me(e){++o.in_loop;var t=e();return --o.in_loop,t}return t.expression?Se(!0):function(){var e=o.token,n=[];for(o.input.push_directives_stack(),t.module&&o.input.add_directive("use strict");!i("eof");)n.push(g());o.input.pop_directives_stack();var r=s(),a=t.toplevel;return a?(a.body=a.body.concat(n),a.end=r):a=new AST_Toplevel({start:e,body:n,end:r}),a}()}function DEFNODE(e,t,n,o=AST_Node){var i=t=t?t.split(/\s+/):[];o&&o.PROPS&&(t=t.concat(o.PROPS));for(var r="return function AST_"+e+"(props){ if (props) { ",a=t.length;--a>=0;)r+="this."+t[a]+" = props."+t[a]+";";const s=o&&Object.create(o.prototype);(s&&s.initialize||n&&n.initialize)&&(r+="this.initialize();"),r+="}",r+="this.flags = 0;",r+="}";var u=new Function(r)();if(s&&(u.prototype=s,u.BASE=o),o&&o.SUBCLASSES.push(u),u.prototype.CTOR=u,u.prototype.constructor=u,u.PROPS=t||null,u.SELF_PROPS=i,u.SUBCLASSES=[],e&&(u.prototype.TYPE=u.TYPE=e),n)for(a in n)HOP(n,a)&&("$"===a[0]?u[a.substr(1)]=n[a]:u.prototype[a]=n[a]);return u.DEFMETHOD=function(e,t){this.prototype[e]=t;},u}const has_tok_flag=(e,t)=>Boolean(e.flags&t),set_tok_flag=(e,t,n)=>{n?e.flags|=t:e.flags&=~t;};class AST_Token{constructor(e,t,n,o,i,r,a,s,u){this.flags=r?1:0,this.type=e,this.value=t,this.line=n,this.col=o,this.pos=i,this.comments_before=a,this.comments_after=s,this.file=u,Object.seal(this);}get nlb(){return has_tok_flag(this,1)}set nlb(e){set_tok_flag(this,1,e);}get quote(){return has_tok_flag(this,4)?has_tok_flag(this,2)?"'":'"':""}set quote(e){set_tok_flag(this,2,"'"===e),set_tok_flag(this,4,!!e);}}var AST_Node=DEFNODE("Node","start end",{_clone:function(e){if(e){var t=this.clone();return t.transform(new TreeTransformer((function(e){if(e!==t)return e.clone(!0)})))}return new this.CTOR(this)},clone:function(e){return this._clone(e)},$documentation:"Base class of all AST nodes",$propdoc:{start:"[AST_Token] The first token of this node",end:"[AST_Token] The last token of this node"},_walk:function(e){return e._visit(this)},walk:function(e){return this._walk(e)},_children_backwards:()=>{}},null),AST_Statement=DEFNODE("Statement",null,{$documentation:"Base class of all statements"}),AST_Debugger=DEFNODE("Debugger",null,{$documentation:"Represents a debugger statement"},AST_Statement),AST_Directive=DEFNODE("Directive","value quote",{$documentation:'Represents a directive, like "use strict";',$propdoc:{value:"[string] The value of this directive as a plain string (it's not an AST_String!)",quote:"[string] the original quote character"}},AST_Statement),AST_SimpleStatement=DEFNODE("SimpleStatement","body",{$documentation:"A statement consisting of an expression, i.e. a = 1 + 2",$propdoc:{body:"[AST_Node] an expression node (should not be instanceof AST_Statement)"},_walk:function(e){return e._visit(this,(function(){this.body._walk(e);}))},_children_backwards(e){e(this.body);}},AST_Statement);function walk_body(e,t){const n=e.body;for(var o=0,i=n.length;o<i;o++)n[o]._walk(t);}function clone_block_scope(e){var t=this._clone(e);return this.block_scope&&(t.block_scope=this.block_scope.clone()),t}var AST_Block=DEFNODE("Block","body block_scope",{$documentation:"A body of statements (usually braced)",$propdoc:{body:"[AST_Statement*] an array of statements",block_scope:"[AST_Scope] the block scope"},_walk:function(e){return e._visit(this,(function(){walk_body(this,e);}))},_children_backwards(e){let t=this.body.length;for(;t--;)e(this.body[t]);},clone:clone_block_scope},AST_Statement),AST_BlockStatement=DEFNODE("BlockStatement",null,{$documentation:"A block statement"},AST_Block),AST_EmptyStatement=DEFNODE("EmptyStatement",null,{$documentation:"The empty statement (empty block or simply a semicolon)"},AST_Statement),AST_StatementWithBody=DEFNODE("StatementWithBody","body",{$documentation:"Base class for all statements that contain one nested body: `For`, `ForIn`, `Do`, `While`, `With`",$propdoc:{body:"[AST_Statement] the body; this should always be present, even if it's an AST_EmptyStatement"}},AST_Statement),AST_LabeledStatement=DEFNODE("LabeledStatement","label",{$documentation:"Statement with a label",$propdoc:{label:"[AST_Label] a label definition"},_walk:function(e){return e._visit(this,(function(){this.label._walk(e),this.body._walk(e);}))},_children_backwards(e){e(this.body),e(this.label);},clone:function(e){var t=this._clone(e);if(e){var n=t.label,o=this.label;t.walk(new TreeWalker((function(e){e instanceof AST_LoopControl&&e.label&&e.label.thedef===o&&(e.label.thedef=n,n.references.push(e));})));}return t}},AST_StatementWithBody),AST_IterationStatement=DEFNODE("IterationStatement","block_scope",{$documentation:"Internal class.  All loops inherit from it.",$propdoc:{block_scope:"[AST_Scope] the block scope for this iteration statement."},clone:clone_block_scope},AST_StatementWithBody),AST_DWLoop=DEFNODE("DWLoop","condition",{$documentation:"Base class for do/while statements",$propdoc:{condition:"[AST_Node] the loop condition.  Should not be instanceof AST_Statement"}},AST_IterationStatement),AST_Do=DEFNODE("Do",null,{$documentation:"A `do` statement",_walk:function(e){return e._visit(this,(function(){this.body._walk(e),this.condition._walk(e);}))},_children_backwards(e){e(this.condition),e(this.body);}},AST_DWLoop),AST_While=DEFNODE("While",null,{$documentation:"A `while` statement",_walk:function(e){return e._visit(this,(function(){this.condition._walk(e),this.body._walk(e);}))},_children_backwards(e){e(this.body),e(this.condition);}},AST_DWLoop),AST_For=DEFNODE("For","init condition step",{$documentation:"A `for` statement",$propdoc:{init:"[AST_Node?] the `for` initialization code, or null if empty",condition:"[AST_Node?] the `for` termination clause, or null if empty",step:"[AST_Node?] the `for` update clause, or null if empty"},_walk:function(e){return e._visit(this,(function(){this.init&&this.init._walk(e),this.condition&&this.condition._walk(e),this.step&&this.step._walk(e),this.body._walk(e);}))},_children_backwards(e){e(this.body),this.step&&e(this.step),this.condition&&e(this.condition),this.init&&e(this.init);}},AST_IterationStatement),AST_ForIn=DEFNODE("ForIn","init object",{$documentation:"A `for ... in` statement",$propdoc:{init:"[AST_Node] the `for/in` initialization code",object:"[AST_Node] the object that we're looping through"},_walk:function(e){return e._visit(this,(function(){this.init._walk(e),this.object._walk(e),this.body._walk(e);}))},_children_backwards(e){e(this.body),this.object&&e(this.object),this.init&&e(this.init);}},AST_IterationStatement),AST_ForOf=DEFNODE("ForOf","await",{$documentation:"A `for ... of` statement"},AST_ForIn),AST_With=DEFNODE("With","expression",{$documentation:"A `with` statement",$propdoc:{expression:"[AST_Node] the `with` expression"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e),this.body._walk(e);}))},_children_backwards(e){e(this.body),e(this.expression);}},AST_StatementWithBody),AST_Scope=DEFNODE("Scope","variables functions uses_with uses_eval parent_scope enclosed cname",{$documentation:"Base class for all statements introducing a lexical scope",$propdoc:{variables:"[Map/S] a map of name -> SymbolDef for all variables/functions defined in this scope",functions:"[Map/S] like `variables`, but only lists function declarations",uses_with:"[boolean/S] tells whether this scope uses the `with` statement",uses_eval:"[boolean/S] tells whether this scope contains a direct call to the global `eval`",parent_scope:"[AST_Scope?/S] link to the parent scope",enclosed:"[SymbolDef*/S] a list of all symbol definitions that are accessed from this scope or any subscopes",cname:"[integer/S] current index for mangling variables (used internally by the mangler)"},get_defun_scope:function(){for(var e=this;e.is_block_scope();)e=e.parent_scope;return e},clone:function(e,t){var n=this._clone(e);return e&&this.variables&&t&&!this._block_scope?n.figure_out_scope({},{toplevel:t,parent_scope:this.parent_scope}):(this.variables&&(n.variables=new Map(this.variables)),this.functions&&(n.functions=new Map(this.functions)),this.enclosed&&(n.enclosed=this.enclosed.slice()),this._block_scope&&(n._block_scope=this._block_scope)),n},pinned:function(){return this.uses_eval||this.uses_with}},AST_Block),AST_Toplevel=DEFNODE("Toplevel","globals",{$documentation:"The toplevel scope",$propdoc:{globals:"[Map/S] a map of name -> SymbolDef for all undeclared names"},wrap_commonjs:function(e){var t=this.body,n="(function(exports){'$ORIG';})(typeof "+e+"=='undefined'?("+e+"={}):"+e+");";return (n=parse$5(n)).transform(new TreeTransformer((function(e){if(e instanceof AST_Directive&&"$ORIG"==e.value)return MAP.splice(t)})))},wrap_enclose:function(e){"string"!=typeof e&&(e="");var t=e.indexOf(":");t<0&&(t=e.length);var n=this.body;return parse$5(["(function(",e.slice(0,t),'){"$ORIG"})(',e.slice(t+1),")"].join("")).transform(new TreeTransformer((function(e){if(e instanceof AST_Directive&&"$ORIG"==e.value)return MAP.splice(n)})))}},AST_Scope),AST_Expansion=DEFNODE("Expansion","expression",{$documentation:"An expandible argument, such as ...rest, a splat, such as [1,2,...all], or an expansion in a variable declaration, such as var [first, ...rest] = list",$propdoc:{expression:"[AST_Node] the thing to be expanded"},_walk:function(e){return e._visit(this,(function(){this.expression.walk(e);}))},_children_backwards(e){e(this.expression);}}),AST_Lambda=DEFNODE("Lambda","name argnames uses_arguments is_generator async",{$documentation:"Base class for functions",$propdoc:{name:"[AST_SymbolDeclaration?] the name of this function",argnames:"[AST_SymbolFunarg|AST_Destructuring|AST_Expansion|AST_DefaultAssign*] array of function arguments, destructurings, or expanding arguments",uses_arguments:"[boolean/S] tells whether this function accesses the arguments array",is_generator:"[boolean] is this a generator method",async:"[boolean] is this method async"},args_as_names:function(){for(var e=[],t=0;t<this.argnames.length;t++)this.argnames[t]instanceof AST_Destructuring?e.push(...this.argnames[t].all_symbols()):e.push(this.argnames[t]);return e},_walk:function(e){return e._visit(this,(function(){this.name&&this.name._walk(e);for(var t=this.argnames,n=0,o=t.length;n<o;n++)t[n]._walk(e);walk_body(this,e);}))},_children_backwards(e){let t=this.body.length;for(;t--;)e(this.body[t]);for(t=this.argnames.length;t--;)e(this.argnames[t]);this.name&&e(this.name);},is_braceless(){return this.body[0]instanceof AST_Return&&this.body[0].value}},AST_Scope),AST_Accessor=DEFNODE("Accessor",null,{$documentation:"A setter/getter function.  The `name` property is always null."},AST_Lambda),AST_Function=DEFNODE("Function",null,{$documentation:"A function expression"},AST_Lambda),AST_Arrow=DEFNODE("Arrow",null,{$documentation:"An ES6 Arrow function ((a) => b)"},AST_Lambda),AST_Defun=DEFNODE("Defun",null,{$documentation:"A function definition"},AST_Lambda),AST_Destructuring=DEFNODE("Destructuring","names is_array",{$documentation:"A destructuring of several names. Used in destructuring assignment and with destructuring function argument names",$propdoc:{names:"[AST_Node*] Array of properties or elements",is_array:"[Boolean] Whether the destructuring represents an object or array"},_walk:function(e){return e._visit(this,(function(){this.names.forEach((function(t){t._walk(e);}));}))},_children_backwards(e){let t=this.names.length;for(;t--;)e(this.names[t]);},all_symbols:function(){var e=[];return this.walk(new TreeWalker((function(t){t instanceof AST_Symbol&&e.push(t);}))),e}}),AST_PrefixedTemplateString=DEFNODE("PrefixedTemplateString","template_string prefix",{$documentation:"A templatestring with a prefix, such as String.raw`foobarbaz`",$propdoc:{template_string:"[AST_TemplateString] The template string",prefix:"[AST_Node] The prefix, which will get called."},_walk:function(e){return e._visit(this,(function(){this.prefix._walk(e),this.template_string._walk(e);}))},_children_backwards(e){e(this.template_string),e(this.prefix);}}),AST_TemplateString=DEFNODE("TemplateString","segments",{$documentation:"A template string literal",$propdoc:{segments:"[AST_Node*] One or more segments, starting with AST_TemplateSegment. AST_Node may follow AST_TemplateSegment, but each AST_Node must be followed by AST_TemplateSegment."},_walk:function(e){return e._visit(this,(function(){this.segments.forEach((function(t){t._walk(e);}));}))},_children_backwards(e){let t=this.segments.length;for(;t--;)e(this.segments[t]);}}),AST_TemplateSegment=DEFNODE("TemplateSegment","value raw",{$documentation:"A segment of a template string literal",$propdoc:{value:"Content of the segment",raw:"Raw source of the segment"}}),AST_Jump=DEFNODE("Jump",null,{$documentation:"Base class for “jumps” (for now that's `return`, `throw`, `break` and `continue`)"},AST_Statement),AST_Exit=DEFNODE("Exit","value",{$documentation:"Base class for “exits” (`return` and `throw`)",$propdoc:{value:"[AST_Node?] the value returned or thrown by this statement; could be null for AST_Return"},_walk:function(e){return e._visit(this,this.value&&function(){this.value._walk(e);})},_children_backwards(e){this.value&&e(this.value);}},AST_Jump),AST_Return=DEFNODE("Return",null,{$documentation:"A `return` statement"},AST_Exit),AST_Throw=DEFNODE("Throw",null,{$documentation:"A `throw` statement"},AST_Exit),AST_LoopControl=DEFNODE("LoopControl","label",{$documentation:"Base class for loop control statements (`break` and `continue`)",$propdoc:{label:"[AST_LabelRef?] the label, or null if none"},_walk:function(e){return e._visit(this,this.label&&function(){this.label._walk(e);})},_children_backwards(e){this.label&&e(this.label);}},AST_Jump),AST_Break=DEFNODE("Break",null,{$documentation:"A `break` statement"},AST_LoopControl),AST_Continue=DEFNODE("Continue",null,{$documentation:"A `continue` statement"},AST_LoopControl),AST_Await=DEFNODE("Await","expression",{$documentation:"An `await` statement",$propdoc:{expression:"[AST_Node] the mandatory expression being awaited"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e);}))},_children_backwards(e){e(this.expression);}}),AST_Yield=DEFNODE("Yield","expression is_star",{$documentation:"A `yield` statement",$propdoc:{expression:"[AST_Node?] the value returned or thrown by this statement; could be null (representing undefined) but only when is_star is set to false",is_star:"[Boolean] Whether this is a yield or yield* statement"},_walk:function(e){return e._visit(this,this.expression&&function(){this.expression._walk(e);})},_children_backwards(e){this.expression&&e(this.expression);}}),AST_If=DEFNODE("If","condition alternative",{$documentation:"A `if` statement",$propdoc:{condition:"[AST_Node] the `if` condition",alternative:"[AST_Statement?] the `else` part, or null if not present"},_walk:function(e){return e._visit(this,(function(){this.condition._walk(e),this.body._walk(e),this.alternative&&this.alternative._walk(e);}))},_children_backwards(e){this.alternative&&e(this.alternative),e(this.body),e(this.condition);}},AST_StatementWithBody),AST_Switch=DEFNODE("Switch","expression",{$documentation:"A `switch` statement",$propdoc:{expression:"[AST_Node] the `switch` “discriminant”"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e),walk_body(this,e);}))},_children_backwards(e){let t=this.body.length;for(;t--;)e(this.body[t]);e(this.expression);}},AST_Block),AST_SwitchBranch=DEFNODE("SwitchBranch",null,{$documentation:"Base class for `switch` branches"},AST_Block),AST_Default=DEFNODE("Default",null,{$documentation:"A `default` switch branch"},AST_SwitchBranch),AST_Case=DEFNODE("Case","expression",{$documentation:"A `case` switch branch",$propdoc:{expression:"[AST_Node] the `case` expression"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e),walk_body(this,e);}))},_children_backwards(e){let t=this.body.length;for(;t--;)e(this.body[t]);e(this.expression);}},AST_SwitchBranch),AST_Try=DEFNODE("Try","bcatch bfinally",{$documentation:"A `try` statement",$propdoc:{bcatch:"[AST_Catch?] the catch block, or null if not present",bfinally:"[AST_Finally?] the finally block, or null if not present"},_walk:function(e){return e._visit(this,(function(){walk_body(this,e),this.bcatch&&this.bcatch._walk(e),this.bfinally&&this.bfinally._walk(e);}))},_children_backwards(e){this.bfinally&&e(this.bfinally),this.bcatch&&e(this.bcatch);let t=this.body.length;for(;t--;)e(this.body[t]);}},AST_Block),AST_Catch=DEFNODE("Catch","argname",{$documentation:"A `catch` node; only makes sense as part of a `try` statement",$propdoc:{argname:"[AST_SymbolCatch|AST_Destructuring|AST_Expansion|AST_DefaultAssign] symbol for the exception"},_walk:function(e){return e._visit(this,(function(){this.argname&&this.argname._walk(e),walk_body(this,e);}))},_children_backwards(e){let t=this.body.length;for(;t--;)e(this.body[t]);this.argname&&e(this.argname);}},AST_Block),AST_Finally=DEFNODE("Finally",null,{$documentation:"A `finally` node; only makes sense as part of a `try` statement"},AST_Block),AST_Definitions=DEFNODE("Definitions","definitions",{$documentation:"Base class for `var` or `const` nodes (variable declarations/initializations)",$propdoc:{definitions:"[AST_VarDef*] array of variable definitions"},_walk:function(e){return e._visit(this,(function(){for(var t=this.definitions,n=0,o=t.length;n<o;n++)t[n]._walk(e);}))},_children_backwards(e){let t=this.definitions.length;for(;t--;)e(this.definitions[t]);}},AST_Statement),AST_Var=DEFNODE("Var",null,{$documentation:"A `var` statement"},AST_Definitions),AST_Let=DEFNODE("Let",null,{$documentation:"A `let` statement"},AST_Definitions),AST_Const=DEFNODE("Const",null,{$documentation:"A `const` statement"},AST_Definitions),AST_VarDef=DEFNODE("VarDef","name value",{$documentation:"A variable declaration; only appears in a AST_Definitions node",$propdoc:{name:"[AST_Destructuring|AST_SymbolConst|AST_SymbolLet|AST_SymbolVar] name of the variable",value:"[AST_Node?] initializer, or null of there's no initializer"},_walk:function(e){return e._visit(this,(function(){this.name._walk(e),this.value&&this.value._walk(e);}))},_children_backwards(e){this.value&&e(this.value),e(this.name);}}),AST_NameMapping=DEFNODE("NameMapping","foreign_name name",{$documentation:"The part of the export/import statement that declare names from a module.",$propdoc:{foreign_name:"[AST_SymbolExportForeign|AST_SymbolImportForeign] The name being exported/imported (as specified in the module)",name:"[AST_SymbolExport|AST_SymbolImport] The name as it is visible to this module."},_walk:function(e){return e._visit(this,(function(){this.foreign_name._walk(e),this.name._walk(e);}))},_children_backwards(e){e(this.name),e(this.foreign_name);}}),AST_Import=DEFNODE("Import","imported_name imported_names module_name",{$documentation:"An `import` statement",$propdoc:{imported_name:"[AST_SymbolImport] The name of the variable holding the module's default export.",imported_names:"[AST_NameMapping*] The names of non-default imported variables",module_name:"[AST_String] String literal describing where this module came from"},_walk:function(e){return e._visit(this,(function(){this.imported_name&&this.imported_name._walk(e),this.imported_names&&this.imported_names.forEach((function(t){t._walk(e);})),this.module_name._walk(e);}))},_children_backwards(e){if(e(this.module_name),this.imported_names){let t=this.imported_names.length;for(;t--;)e(this.imported_names[t]);}this.imported_name&&e(this.imported_name);}}),AST_ImportMeta=DEFNODE("ImportMeta",null,{$documentation:"A reference to import.meta"}),AST_Export=DEFNODE("Export","exported_definition exported_value is_default exported_names module_name",{$documentation:"An `export` statement",$propdoc:{exported_definition:"[AST_Defun|AST_Definitions|AST_DefClass?] An exported definition",exported_value:"[AST_Node?] An exported value",exported_names:"[AST_NameMapping*?] List of exported names",module_name:"[AST_String?] Name of the file to load exports from",is_default:"[Boolean] Whether this is the default exported value of this module"},_walk:function(e){return e._visit(this,(function(){this.exported_definition&&this.exported_definition._walk(e),this.exported_value&&this.exported_value._walk(e),this.exported_names&&this.exported_names.forEach((function(t){t._walk(e);})),this.module_name&&this.module_name._walk(e);}))},_children_backwards(e){if(this.module_name&&e(this.module_name),this.exported_names){let t=this.exported_names.length;for(;t--;)e(this.exported_names[t]);}this.exported_value&&e(this.exported_value),this.exported_definition&&e(this.exported_definition);}},AST_Statement),AST_Call=DEFNODE("Call","expression args optional _annotations",{$documentation:"A function call expression",$propdoc:{expression:"[AST_Node] expression to invoke as function",args:"[AST_Node*] array of arguments",optional:"[boolean] whether this is an optional call (IE ?.() )",_annotations:"[number] bitfield containing information about the call"},initialize(){null==this._annotations&&(this._annotations=0);},_walk(e){return e._visit(this,(function(){for(var t=this.args,n=0,o=t.length;n<o;n++)t[n]._walk(e);this.expression._walk(e);}))},_children_backwards(e){let t=this.args.length;for(;t--;)e(this.args[t]);e(this.expression);}}),AST_New=DEFNODE("New",null,{$documentation:"An object instantiation.  Derives from a function call since it has exactly the same properties"},AST_Call),AST_Sequence=DEFNODE("Sequence","expressions",{$documentation:"A sequence expression (comma-separated expressions)",$propdoc:{expressions:"[AST_Node*] array of expressions (at least two)"},_walk:function(e){return e._visit(this,(function(){this.expressions.forEach((function(t){t._walk(e);}));}))},_children_backwards(e){let t=this.expressions.length;for(;t--;)e(this.expressions[t]);}}),AST_PropAccess=DEFNODE("PropAccess","expression property optional",{$documentation:'Base class for property access expressions, i.e. `a.foo` or `a["foo"]`',$propdoc:{expression:"[AST_Node] the “container” expression",property:"[AST_Node|string] the property to access.  For AST_Dot & AST_DotHash this is always a plain string, while for AST_Sub it's an arbitrary AST_Node",optional:"[boolean] whether this is an optional property access (IE ?.)"}}),AST_Dot=DEFNODE("Dot","quote",{$documentation:"A dotted property access expression",$propdoc:{quote:"[string] the original quote character when transformed from AST_Sub"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e);}))},_children_backwards(e){e(this.expression);}},AST_PropAccess),AST_DotHash=DEFNODE("DotHash","",{$documentation:"A dotted property access to a private property",_walk:function(e){return e._visit(this,(function(){this.expression._walk(e);}))},_children_backwards(e){e(this.expression);}},AST_PropAccess),AST_Sub=DEFNODE("Sub",null,{$documentation:'Index-style property access, i.e. `a["foo"]`',_walk:function(e){return e._visit(this,(function(){this.expression._walk(e),this.property._walk(e);}))},_children_backwards(e){e(this.property),e(this.expression);}},AST_PropAccess),AST_Chain=DEFNODE("Chain","expression",{$documentation:"A chain expression like a?.b?.(c)?.[d]",$propdoc:{expression:"[AST_Call|AST_Dot|AST_DotHash|AST_Sub] chain element."},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e);}))},_children_backwards(e){e(this.expression);}}),AST_Unary=DEFNODE("Unary","operator expression",{$documentation:"Base class for unary expressions",$propdoc:{operator:"[string] the operator",expression:"[AST_Node] expression that this unary operator applies to"},_walk:function(e){return e._visit(this,(function(){this.expression._walk(e);}))},_children_backwards(e){e(this.expression);}}),AST_UnaryPrefix=DEFNODE("UnaryPrefix",null,{$documentation:"Unary prefix expression, i.e. `typeof i` or `++i`"},AST_Unary),AST_UnaryPostfix=DEFNODE("UnaryPostfix",null,{$documentation:"Unary postfix expression, i.e. `i++`"},AST_Unary),AST_Binary=DEFNODE("Binary","operator left right",{$documentation:"Binary expression, i.e. `a + b`",$propdoc:{left:"[AST_Node] left-hand side expression",operator:"[string] the operator",right:"[AST_Node] right-hand side expression"},_walk:function(e){return e._visit(this,(function(){this.left._walk(e),this.right._walk(e);}))},_children_backwards(e){e(this.right),e(this.left);}}),AST_Conditional=DEFNODE("Conditional","condition consequent alternative",{$documentation:"Conditional expression using the ternary operator, i.e. `a ? b : c`",$propdoc:{condition:"[AST_Node]",consequent:"[AST_Node]",alternative:"[AST_Node]"},_walk:function(e){return e._visit(this,(function(){this.condition._walk(e),this.consequent._walk(e),this.alternative._walk(e);}))},_children_backwards(e){e(this.alternative),e(this.consequent),e(this.condition);}}),AST_Assign=DEFNODE("Assign","logical",{$documentation:"An assignment expression — `a = b + 5`",$propdoc:{logical:"Whether it's a logical assignment"}},AST_Binary),AST_DefaultAssign=DEFNODE("DefaultAssign",null,{$documentation:"A default assignment expression like in `(a = 3) => a`"},AST_Binary),AST_Array=DEFNODE("Array","elements",{$documentation:"An array literal",$propdoc:{elements:"[AST_Node*] array of elements"},_walk:function(e){return e._visit(this,(function(){for(var t=this.elements,n=0,o=t.length;n<o;n++)t[n]._walk(e);}))},_children_backwards(e){let t=this.elements.length;for(;t--;)e(this.elements[t]);}}),AST_Object=DEFNODE("Object","properties",{$documentation:"An object literal",$propdoc:{properties:"[AST_ObjectProperty*] array of properties"},_walk:function(e){return e._visit(this,(function(){for(var t=this.properties,n=0,o=t.length;n<o;n++)t[n]._walk(e);}))},_children_backwards(e){let t=this.properties.length;for(;t--;)e(this.properties[t]);}}),AST_ObjectProperty=DEFNODE("ObjectProperty","key value",{$documentation:"Base class for literal object properties",$propdoc:{key:"[string|AST_Node] property name. For ObjectKeyVal this is a string. For getters, setters and computed property this is an AST_Node.",value:"[AST_Node] property value.  For getters and setters this is an AST_Accessor."},_walk:function(e){return e._visit(this,(function(){this.key instanceof AST_Node&&this.key._walk(e),this.value._walk(e);}))},_children_backwards(e){e(this.value),this.key instanceof AST_Node&&e(this.key);}}),AST_ObjectKeyVal=DEFNODE("ObjectKeyVal","quote",{$documentation:"A key: value object property",$propdoc:{quote:"[string] the original quote character"},computed_key(){return this.key instanceof AST_Node}},AST_ObjectProperty),AST_PrivateSetter=DEFNODE("PrivateSetter","static",{$propdoc:{static:"[boolean] whether this is a static private setter"},$documentation:"A private setter property",computed_key:()=>!1},AST_ObjectProperty),AST_PrivateGetter=DEFNODE("PrivateGetter","static",{$propdoc:{static:"[boolean] whether this is a static private getter"},$documentation:"A private getter property",computed_key:()=>!1},AST_ObjectProperty),AST_ObjectSetter=DEFNODE("ObjectSetter","quote static",{$propdoc:{quote:"[string|undefined] the original quote character, if any",static:"[boolean] whether this is a static setter (classes only)"},$documentation:"An object setter property",computed_key(){return !(this.key instanceof AST_SymbolMethod)}},AST_ObjectProperty),AST_ObjectGetter=DEFNODE("ObjectGetter","quote static",{$propdoc:{quote:"[string|undefined] the original quote character, if any",static:"[boolean] whether this is a static getter (classes only)"},$documentation:"An object getter property",computed_key(){return !(this.key instanceof AST_SymbolMethod)}},AST_ObjectProperty),AST_ConciseMethod=DEFNODE("ConciseMethod","quote static is_generator async",{$propdoc:{quote:"[string|undefined] the original quote character, if any",static:"[boolean] is this method static (classes only)",is_generator:"[boolean] is this a generator method",async:"[boolean] is this method async"},$documentation:"An ES6 concise method inside an object or class",computed_key(){return !(this.key instanceof AST_SymbolMethod)}},AST_ObjectProperty),AST_PrivateMethod=DEFNODE("PrivateMethod","",{$documentation:"A private class method inside a class"},AST_ConciseMethod),AST_Class=DEFNODE("Class","name extends properties",{$propdoc:{name:"[AST_SymbolClass|AST_SymbolDefClass?] optional class name.",extends:"[AST_Node]? optional parent class",properties:"[AST_ObjectProperty*] array of properties"},$documentation:"An ES6 class",_walk:function(e){return e._visit(this,(function(){this.name&&this.name._walk(e),this.extends&&this.extends._walk(e),this.properties.forEach((t=>t._walk(e)));}))},_children_backwards(e){let t=this.properties.length;for(;t--;)e(this.properties[t]);this.extends&&e(this.extends),this.name&&e(this.name);}},AST_Scope),AST_ClassProperty=DEFNODE("ClassProperty","static quote",{$documentation:"A class property",$propdoc:{static:"[boolean] whether this is a static key",quote:"[string] which quote is being used"},_walk:function(e){return e._visit(this,(function(){this.key instanceof AST_Node&&this.key._walk(e),this.value instanceof AST_Node&&this.value._walk(e);}))},_children_backwards(e){this.value instanceof AST_Node&&e(this.value),this.key instanceof AST_Node&&e(this.key);},computed_key(){return !(this.key instanceof AST_SymbolClassProperty)}},AST_ObjectProperty),AST_ClassPrivateProperty=DEFNODE("ClassProperty","",{$documentation:"A class property for a private property"},AST_ClassProperty),AST_DefClass=DEFNODE("DefClass",null,{$documentation:"A class definition"},AST_Class),AST_ClassExpression=DEFNODE("ClassExpression",null,{$documentation:"A class expression."},AST_Class),AST_Symbol=DEFNODE("Symbol","scope name thedef",{$propdoc:{name:"[string] name of this symbol",scope:"[AST_Scope/S] the current scope (not necessarily the definition scope)",thedef:"[SymbolDef/S] the definition of this symbol"},$documentation:"Base class for all symbols"}),AST_NewTarget=DEFNODE("NewTarget",null,{$documentation:"A reference to new.target"}),AST_SymbolDeclaration=DEFNODE("SymbolDeclaration","init",{$documentation:"A declaration symbol (symbol in var/const, function name or argument, symbol in catch)"},AST_Symbol),AST_SymbolVar=DEFNODE("SymbolVar",null,{$documentation:"Symbol defining a variable"},AST_SymbolDeclaration),AST_SymbolBlockDeclaration=DEFNODE("SymbolBlockDeclaration",null,{$documentation:"Base class for block-scoped declaration symbols"},AST_SymbolDeclaration),AST_SymbolConst=DEFNODE("SymbolConst",null,{$documentation:"A constant declaration"},AST_SymbolBlockDeclaration),AST_SymbolLet=DEFNODE("SymbolLet",null,{$documentation:"A block-scoped `let` declaration"},AST_SymbolBlockDeclaration),AST_SymbolFunarg=DEFNODE("SymbolFunarg",null,{$documentation:"Symbol naming a function argument"},AST_SymbolVar),AST_SymbolDefun=DEFNODE("SymbolDefun",null,{$documentation:"Symbol defining a function"},AST_SymbolDeclaration),AST_SymbolMethod=DEFNODE("SymbolMethod",null,{$documentation:"Symbol in an object defining a method"},AST_Symbol),AST_SymbolClassProperty=DEFNODE("SymbolClassProperty",null,{$documentation:"Symbol for a class property"},AST_Symbol),AST_SymbolLambda=DEFNODE("SymbolLambda",null,{$documentation:"Symbol naming a function expression"},AST_SymbolDeclaration),AST_SymbolDefClass=DEFNODE("SymbolDefClass",null,{$documentation:"Symbol naming a class's name in a class declaration. Lexically scoped to its containing scope, and accessible within the class."},AST_SymbolBlockDeclaration),AST_SymbolClass=DEFNODE("SymbolClass",null,{$documentation:"Symbol naming a class's name. Lexically scoped to the class."},AST_SymbolDeclaration),AST_SymbolCatch=DEFNODE("SymbolCatch",null,{$documentation:"Symbol naming the exception in catch"},AST_SymbolBlockDeclaration),AST_SymbolImport=DEFNODE("SymbolImport",null,{$documentation:"Symbol referring to an imported name"},AST_SymbolBlockDeclaration),AST_SymbolImportForeign=DEFNODE("SymbolImportForeign",null,{$documentation:"A symbol imported from a module, but it is defined in the other module, and its real name is irrelevant for this module's purposes"},AST_Symbol),AST_Label=DEFNODE("Label","references",{$documentation:"Symbol naming a label (declaration)",$propdoc:{references:"[AST_LoopControl*] a list of nodes referring to this label"},initialize:function(){this.references=[],this.thedef=this;}},AST_Symbol),AST_SymbolRef=DEFNODE("SymbolRef",null,{$documentation:"Reference to some symbol (not definition/declaration)"},AST_Symbol),AST_SymbolExport=DEFNODE("SymbolExport",null,{$documentation:"Symbol referring to a name to export"},AST_SymbolRef),AST_SymbolExportForeign=DEFNODE("SymbolExportForeign",null,{$documentation:"A symbol exported from this module, but it is used in the other module, and its real name is irrelevant for this module's purposes"},AST_Symbol),AST_LabelRef=DEFNODE("LabelRef",null,{$documentation:"Reference to a label symbol"},AST_Symbol),AST_This=DEFNODE("This",null,{$documentation:"The `this` symbol"},AST_Symbol),AST_Super=DEFNODE("Super",null,{$documentation:"The `super` symbol"},AST_This),AST_Constant=DEFNODE("Constant",null,{$documentation:"Base class for all constants",getValue:function(){return this.value}}),AST_String=DEFNODE("String","value quote",{$documentation:"A string literal",$propdoc:{value:"[string] the contents of this string",quote:"[string] the original quote character"}},AST_Constant),AST_Number=DEFNODE("Number","value raw",{$documentation:"A number literal",$propdoc:{value:"[number] the numeric value",raw:"[string] numeric value as string"}},AST_Constant),AST_BigInt=DEFNODE("BigInt","value",{$documentation:"A big int literal",$propdoc:{value:"[string] big int value"}},AST_Constant),AST_RegExp=DEFNODE("RegExp","value",{$documentation:"A regexp literal",$propdoc:{value:"[RegExp] the actual regexp"}},AST_Constant),AST_Atom=DEFNODE("Atom",null,{$documentation:"Base class for atoms"},AST_Constant),AST_Null=DEFNODE("Null",null,{$documentation:"The `null` atom",value:null},AST_Atom),AST_NaN=DEFNODE("NaN",null,{$documentation:"The impossible value",value:NaN},AST_Atom),AST_Undefined=DEFNODE("Undefined",null,{$documentation:"The `undefined` value",value:void 0},AST_Atom),AST_Hole=DEFNODE("Hole",null,{$documentation:"A hole in an array",value:void 0},AST_Atom),AST_Infinity=DEFNODE("Infinity",null,{$documentation:"The `Infinity` value",value:1/0},AST_Atom),AST_Boolean=DEFNODE("Boolean",null,{$documentation:"Base class for booleans"},AST_Atom),AST_False=DEFNODE("False",null,{$documentation:"The `false` atom",value:!1},AST_Boolean),AST_True=DEFNODE("True",null,{$documentation:"The `true` atom",value:!0},AST_Boolean);function walk$3(e,t,n=[e]){const o=n.push.bind(n);for(;n.length;){const e=n.pop(),i=t(e,n);if(i){if(i===walk_abort)return !0}else e._children_backwards(o);}return !1}function walk_parent(e,t,n){const o=[e],i=o.push.bind(o),r=n?n.slice():[],a=[];let s;const u={parent:(e=0)=>-1===e?s:n&&e>=r.length?(e-=r.length,n[n.length-(e+1)]):r[r.length-(1+e)]};for(;o.length;){for(s=o.pop();a.length&&o.length==a[a.length-1];)r.pop(),a.pop();const e=t(s,u);if(e){if(e===walk_abort)return !0;continue}const n=o.length;s._children_backwards(i),o.length>n&&(r.push(s),a.push(n-1));}return !1}const walk_abort=Symbol("abort walk");class TreeWalker{constructor(e){this.visit=e,this.stack=[],this.directives=Object.create(null);}_visit(e,t){this.push(e);var n=this.visit(e,t?function(){t.call(e);}:noop);return !n&&t&&t.call(e),this.pop(),n}parent(e){return this.stack[this.stack.length-2-(e||0)]}push(e){e instanceof AST_Lambda?this.directives=Object.create(this.directives):e instanceof AST_Directive&&!this.directives[e.value]?this.directives[e.value]=e:e instanceof AST_Class&&(this.directives=Object.create(this.directives),this.directives["use strict"]||(this.directives["use strict"]=e)),this.stack.push(e);}pop(){var e=this.stack.pop();(e instanceof AST_Lambda||e instanceof AST_Class)&&(this.directives=Object.getPrototypeOf(this.directives));}self(){return this.stack[this.stack.length-1]}find_parent(e){for(var t=this.stack,n=t.length;--n>=0;){var o=t[n];if(o instanceof e)return o}}has_directive(e){var t=this.directives[e];if(t)return t;var n=this.stack[this.stack.length-1];if(n instanceof AST_Scope&&n.body)for(var o=0;o<n.body.length;++o){var i=n.body[o];if(!(i instanceof AST_Directive))break;if(i.value==e)return i}}loopcontrol_target(e){var t=this.stack;if(e.label){for(var n=t.length;--n>=0;)if((o=t[n])instanceof AST_LabeledStatement&&o.label.name==e.label.name)return o.body}else for(n=t.length;--n>=0;){var o;if((o=t[n])instanceof AST_IterationStatement||e instanceof AST_Break&&o instanceof AST_Switch)return o}}}class TreeTransformer extends TreeWalker{constructor(e,t){super(),this.before=e,this.after=t;}}const _PURE=1,_INLINE=2,_NOINLINE=4,ast=Object.freeze({__proto__:null,AST_Accessor,AST_Array,AST_Arrow,AST_Assign,AST_Atom,AST_Await,AST_BigInt,AST_Binary,AST_Block,AST_BlockStatement,AST_Boolean,AST_Break,AST_Call,AST_Case,AST_Catch,AST_Chain,AST_Class,AST_ClassExpression,AST_ClassPrivateProperty,AST_ClassProperty,AST_ConciseMethod,AST_Conditional,AST_Const,AST_Constant,AST_Continue,AST_Debugger,AST_Default,AST_DefaultAssign,AST_DefClass,AST_Definitions,AST_Defun,AST_Destructuring,AST_Directive,AST_Do,AST_Dot,AST_DotHash,AST_DWLoop,AST_EmptyStatement,AST_Exit,AST_Expansion,AST_Export,AST_False,AST_Finally,AST_For,AST_ForIn,AST_ForOf,AST_Function,AST_Hole,AST_If,AST_Import,AST_ImportMeta,AST_Infinity,AST_IterationStatement,AST_Jump,AST_Label,AST_LabeledStatement,AST_LabelRef,AST_Lambda,AST_Let,AST_LoopControl,AST_NameMapping,AST_NaN,AST_New,AST_NewTarget,AST_Node,AST_Null,AST_Number,AST_Object,AST_ObjectGetter,AST_ObjectKeyVal,AST_ObjectProperty,AST_ObjectSetter,AST_PrefixedTemplateString,AST_PrivateGetter,AST_PrivateMethod,AST_PrivateSetter,AST_PropAccess,AST_RegExp,AST_Return,AST_Scope,AST_Sequence,AST_SimpleStatement,AST_Statement,AST_StatementWithBody,AST_String,AST_Sub,AST_Super,AST_Switch,AST_SwitchBranch,AST_Symbol,AST_SymbolBlockDeclaration,AST_SymbolCatch,AST_SymbolClass,AST_SymbolClassProperty,AST_SymbolConst,AST_SymbolDeclaration,AST_SymbolDefClass,AST_SymbolDefun,AST_SymbolExport,AST_SymbolExportForeign,AST_SymbolFunarg,AST_SymbolImport,AST_SymbolImportForeign,AST_SymbolLambda,AST_SymbolLet,AST_SymbolMethod,AST_SymbolRef,AST_SymbolVar,AST_TemplateSegment,AST_TemplateString,AST_This,AST_Throw,AST_Token,AST_Toplevel,AST_True,AST_Try,AST_Unary,AST_UnaryPostfix,AST_UnaryPrefix,AST_Undefined,AST_Var,AST_VarDef,AST_While,AST_With,AST_Yield,TreeTransformer,TreeWalker,walk: walk$3,walk_abort,walk_body,walk_parent,_INLINE,_NOINLINE,_PURE});function def_transform(e,t){e.DEFMETHOD("transform",(function(e,n){let o;if(e.push(this),e.before&&(o=e.before(this,t,n)),void 0===o&&(o=this,t(o,e),e.after)){const t=e.after(o,n);void 0!==t&&(o=t);}return e.pop(),o}));}function do_list(e,t){return MAP(e,(function(e){return e.transform(t,!0)}))}function first_in_statement(e){let t=e.parent(-1);for(let n,o=0;n=e.parent(o);o++){if(n instanceof AST_Statement&&n.body===t)return !0;if(!(n instanceof AST_Sequence&&n.expressions[0]===t||"Call"===n.TYPE&&n.expression===t||n instanceof AST_PrefixedTemplateString&&n.prefix===t||n instanceof AST_Dot&&n.expression===t||n instanceof AST_Sub&&n.expression===t||n instanceof AST_Conditional&&n.condition===t||n instanceof AST_Binary&&n.left===t||n instanceof AST_UnaryPostfix&&n.expression===t))return !1;t=n;}}function left_is_object(e){return e instanceof AST_Object||(e instanceof AST_Sequence?left_is_object(e.expressions[0]):"Call"===e.TYPE?left_is_object(e.expression):e instanceof AST_PrefixedTemplateString?left_is_object(e.prefix):e instanceof AST_Dot||e instanceof AST_Sub?left_is_object(e.expression):e instanceof AST_Conditional?left_is_object(e.condition):e instanceof AST_Binary?left_is_object(e.left):e instanceof AST_UnaryPostfix&&left_is_object(e.expression))}def_transform(AST_Node,noop),def_transform(AST_LabeledStatement,(function(e,t){e.label=e.label.transform(t),e.body=e.body.transform(t);})),def_transform(AST_SimpleStatement,(function(e,t){e.body=e.body.transform(t);})),def_transform(AST_Block,(function(e,t){e.body=do_list(e.body,t);})),def_transform(AST_Do,(function(e,t){e.body=e.body.transform(t),e.condition=e.condition.transform(t);})),def_transform(AST_While,(function(e,t){e.condition=e.condition.transform(t),e.body=e.body.transform(t);})),def_transform(AST_For,(function(e,t){e.init&&(e.init=e.init.transform(t)),e.condition&&(e.condition=e.condition.transform(t)),e.step&&(e.step=e.step.transform(t)),e.body=e.body.transform(t);})),def_transform(AST_ForIn,(function(e,t){e.init=e.init.transform(t),e.object=e.object.transform(t),e.body=e.body.transform(t);})),def_transform(AST_With,(function(e,t){e.expression=e.expression.transform(t),e.body=e.body.transform(t);})),def_transform(AST_Exit,(function(e,t){e.value&&(e.value=e.value.transform(t));})),def_transform(AST_LoopControl,(function(e,t){e.label&&(e.label=e.label.transform(t));})),def_transform(AST_If,(function(e,t){e.condition=e.condition.transform(t),e.body=e.body.transform(t),e.alternative&&(e.alternative=e.alternative.transform(t));})),def_transform(AST_Switch,(function(e,t){e.expression=e.expression.transform(t),e.body=do_list(e.body,t);})),def_transform(AST_Case,(function(e,t){e.expression=e.expression.transform(t),e.body=do_list(e.body,t);})),def_transform(AST_Try,(function(e,t){e.body=do_list(e.body,t),e.bcatch&&(e.bcatch=e.bcatch.transform(t)),e.bfinally&&(e.bfinally=e.bfinally.transform(t));})),def_transform(AST_Catch,(function(e,t){e.argname&&(e.argname=e.argname.transform(t)),e.body=do_list(e.body,t);})),def_transform(AST_Definitions,(function(e,t){e.definitions=do_list(e.definitions,t);})),def_transform(AST_VarDef,(function(e,t){e.name=e.name.transform(t),e.value&&(e.value=e.value.transform(t));})),def_transform(AST_Destructuring,(function(e,t){e.names=do_list(e.names,t);})),def_transform(AST_Lambda,(function(e,t){e.name&&(e.name=e.name.transform(t)),e.argnames=do_list(e.argnames,t),e.body instanceof AST_Node?e.body=e.body.transform(t):e.body=do_list(e.body,t);})),def_transform(AST_Call,(function(e,t){e.expression=e.expression.transform(t),e.args=do_list(e.args,t);})),def_transform(AST_Sequence,(function(e,t){const n=do_list(e.expressions,t);e.expressions=n.length?n:[new AST_Number({value:0})];})),def_transform(AST_Dot,(function(e,t){e.expression=e.expression.transform(t);})),def_transform(AST_Sub,(function(e,t){e.expression=e.expression.transform(t),e.property=e.property.transform(t);})),def_transform(AST_Chain,(function(e,t){e.expression=e.expression.transform(t);})),def_transform(AST_Yield,(function(e,t){e.expression&&(e.expression=e.expression.transform(t));})),def_transform(AST_Await,(function(e,t){e.expression=e.expression.transform(t);})),def_transform(AST_Unary,(function(e,t){e.expression=e.expression.transform(t);})),def_transform(AST_Binary,(function(e,t){e.left=e.left.transform(t),e.right=e.right.transform(t);})),def_transform(AST_Conditional,(function(e,t){e.condition=e.condition.transform(t),e.consequent=e.consequent.transform(t),e.alternative=e.alternative.transform(t);})),def_transform(AST_Array,(function(e,t){e.elements=do_list(e.elements,t);})),def_transform(AST_Object,(function(e,t){e.properties=do_list(e.properties,t);})),def_transform(AST_ObjectProperty,(function(e,t){e.key instanceof AST_Node&&(e.key=e.key.transform(t)),e.value&&(e.value=e.value.transform(t));})),def_transform(AST_Class,(function(e,t){e.name&&(e.name=e.name.transform(t)),e.extends&&(e.extends=e.extends.transform(t)),e.properties=do_list(e.properties,t);})),def_transform(AST_Expansion,(function(e,t){e.expression=e.expression.transform(t);})),def_transform(AST_NameMapping,(function(e,t){e.foreign_name=e.foreign_name.transform(t),e.name=e.name.transform(t);})),def_transform(AST_Import,(function(e,t){e.imported_name&&(e.imported_name=e.imported_name.transform(t)),e.imported_names&&do_list(e.imported_names,t),e.module_name=e.module_name.transform(t);})),def_transform(AST_Export,(function(e,t){e.exported_definition&&(e.exported_definition=e.exported_definition.transform(t)),e.exported_value&&(e.exported_value=e.exported_value.transform(t)),e.exported_names&&do_list(e.exported_names,t),e.module_name&&(e.module_name=e.module_name.transform(t));})),def_transform(AST_TemplateString,(function(e,t){e.segments=do_list(e.segments,t);})),def_transform(AST_PrefixedTemplateString,(function(e,t){e.prefix=e.prefix.transform(t),e.template_string=e.template_string.transform(t);})),function(){var e=function(e){for(var t=!0,n=0;n<e.length;n++)t&&e[n]instanceof AST_Statement&&e[n].body instanceof AST_String?e[n]=new AST_Directive({start:e[n].start,end:e[n].end,value:e[n].body.value}):!t||e[n]instanceof AST_Statement&&e[n].body instanceof AST_String||(t=!1);return e},t={Program:function(t){return new AST_Toplevel({start:n(t),end:o(t),body:e(t.body.map(a))})},ArrayPattern:function(e){return new AST_Destructuring({start:n(e),end:o(e),names:e.elements.map((function(e){return null===e?new AST_Hole:a(e)})),is_array:!0})},ObjectPattern:function(e){return new AST_Destructuring({start:n(e),end:o(e),names:e.properties.map(a),is_array:!1})},AssignmentPattern:function(e){return new AST_DefaultAssign({start:n(e),end:o(e),left:a(e.left),operator:"=",right:a(e.right)})},SpreadElement:function(e){return new AST_Expansion({start:n(e),end:o(e),expression:a(e.argument)})},RestElement:function(e){return new AST_Expansion({start:n(e),end:o(e),expression:a(e.argument)})},TemplateElement:function(e){return new AST_TemplateSegment({start:n(e),end:o(e),value:e.value.cooked,raw:e.value.raw})},TemplateLiteral:function(e){for(var t=[],i=0;i<e.quasis.length;i++)t.push(a(e.quasis[i])),e.expressions[i]&&t.push(a(e.expressions[i]));return new AST_TemplateString({start:n(e),end:o(e),segments:t})},TaggedTemplateExpression:function(e){return new AST_PrefixedTemplateString({start:n(e),end:o(e),template_string:a(e.quasi),prefix:a(e.tag)})},FunctionDeclaration:function(t){return new AST_Defun({start:n(t),end:o(t),name:a(t.id),argnames:t.params.map(a),is_generator:t.generator,async:t.async,body:e(a(t.body).body)})},FunctionExpression:function(t){return new AST_Function({start:n(t),end:o(t),name:a(t.id),argnames:t.params.map(a),is_generator:t.generator,async:t.async,body:e(a(t.body).body)})},ArrowFunctionExpression:function(e){const t="BlockStatement"===e.body.type?a(e.body).body:[make_node(AST_Return,{},{value:a(e.body)})];return new AST_Arrow({start:n(e),end:o(e),argnames:e.params.map(a),body:t,async:e.async})},ExpressionStatement:function(e){return new AST_SimpleStatement({start:n(e),end:o(e),body:a(e.expression)})},TryStatement:function(e){var t=e.handlers||[e.handler];if(t.length>1||e.guardedHandlers&&e.guardedHandlers.length)throw new Error("Multiple catch clauses are not supported.");return new AST_Try({start:n(e),end:o(e),body:a(e.block).body,bcatch:a(t[0]),bfinally:e.finalizer?new AST_Finally(a(e.finalizer)):null})},Property:function(e){var t=e.key,i={start:n(t||e.value),end:o(e.value),key:"Identifier"==t.type?t.name:t.value,value:a(e.value)};return e.computed&&(i.key=a(e.key)),e.method?(i.is_generator=e.value.generator,i.async=e.value.async,e.computed?i.key=a(e.key):i.key=new AST_SymbolMethod({name:i.key}),new AST_ConciseMethod(i)):"init"==e.kind?("Identifier"!=t.type&&"Literal"!=t.type&&(i.key=a(t)),new AST_ObjectKeyVal(i)):("string"!=typeof i.key&&"number"!=typeof i.key||(i.key=new AST_SymbolMethod({name:i.key})),i.value=new AST_Accessor(i.value),"get"==e.kind?new AST_ObjectGetter(i):"set"==e.kind?new AST_ObjectSetter(i):"method"==e.kind?(i.async=e.value.async,i.is_generator=e.value.generator,i.quote=e.computed?'"':null,new AST_ConciseMethod(i)):void 0)},MethodDefinition:function(e){var t={start:n(e),end:o(e),key:e.computed?a(e.key):new AST_SymbolMethod({name:e.key.name||e.key.value}),value:a(e.value),static:e.static};return "get"==e.kind?new AST_ObjectGetter(t):"set"==e.kind?new AST_ObjectSetter(t):(t.is_generator=e.value.generator,t.async=e.value.async,new AST_ConciseMethod(t))},FieldDefinition:function(e){let t;if(e.computed)t=a(e.key);else {if("Identifier"!==e.key.type)throw new Error("Non-Identifier key in FieldDefinition");t=a(e.key);}return new AST_ClassProperty({start:n(e),end:o(e),key:t,value:a(e.value),static:e.static})},PropertyDefinition:function(e){let t;if(e.computed)t=a(e.key);else {if("Identifier"!==e.key.type)throw new Error("Non-Identifier key in PropertyDefinition");t=a(e.key);}return new AST_ClassProperty({start:n(e),end:o(e),key:t,value:a(e.value),static:e.static})},ArrayExpression:function(e){return new AST_Array({start:n(e),end:o(e),elements:e.elements.map((function(e){return null===e?new AST_Hole:a(e)}))})},ObjectExpression:function(e){return new AST_Object({start:n(e),end:o(e),properties:e.properties.map((function(e){return "SpreadElement"===e.type||(e.type="Property"),a(e)}))})},SequenceExpression:function(e){return new AST_Sequence({start:n(e),end:o(e),expressions:e.expressions.map(a)})},MemberExpression:function(e){return new(e.computed?AST_Sub:AST_Dot)({start:n(e),end:o(e),property:e.computed?a(e.property):e.property.name,expression:a(e.object),optional:e.optional||!1})},ChainExpression:function(e){return new AST_Chain({start:n(e),end:o(e),expression:a(e.expression)})},SwitchCase:function(e){return new(e.test?AST_Case:AST_Default)({start:n(e),end:o(e),expression:a(e.test),body:e.consequent.map(a)})},VariableDeclaration:function(e){return new("const"===e.kind?AST_Const:"let"===e.kind?AST_Let:AST_Var)({start:n(e),end:o(e),definitions:e.declarations.map(a)})},ImportDeclaration:function(e){var t=null,i=null;return e.specifiers.forEach((function(e){"ImportSpecifier"===e.type?(i||(i=[]),i.push(new AST_NameMapping({start:n(e),end:o(e),foreign_name:a(e.imported),name:a(e.local)}))):"ImportDefaultSpecifier"===e.type?t=a(e.local):"ImportNamespaceSpecifier"===e.type&&(i||(i=[]),i.push(new AST_NameMapping({start:n(e),end:o(e),foreign_name:new AST_SymbolImportForeign({name:"*"}),name:a(e.local)})));})),new AST_Import({start:n(e),end:o(e),imported_name:t,imported_names:i,module_name:a(e.source)})},ExportAllDeclaration:function(e){return new AST_Export({start:n(e),end:o(e),exported_names:[new AST_NameMapping({name:new AST_SymbolExportForeign({name:"*"}),foreign_name:new AST_SymbolExportForeign({name:"*"})})],module_name:a(e.source)})},ExportNamedDeclaration:function(e){return new AST_Export({start:n(e),end:o(e),exported_definition:a(e.declaration),exported_names:e.specifiers&&e.specifiers.length?e.specifiers.map((function(e){return new AST_NameMapping({foreign_name:a(e.exported),name:a(e.local)})})):null,module_name:a(e.source)})},ExportDefaultDeclaration:function(e){return new AST_Export({start:n(e),end:o(e),exported_value:a(e.declaration),is_default:!0})},Literal:function(e){var t=e.value,i={start:n(e),end:o(e)},r=e.regex;if(r&&r.pattern)return i.value={source:r.pattern,flags:r.flags},new AST_RegExp(i);if(r){const n=e.raw||t,o=n.match(/^\/(.*)\/(\w*)$/);if(!o)throw new Error("Invalid regex source "+n);const[r,a,s]=o;return i.value={source:a,flags:s},new AST_RegExp(i)}if(null===t)return new AST_Null(i);switch(typeof t){case"string":return i.value=t,new AST_String(i);case"number":return i.value=t,i.raw=e.raw||t.toString(),new AST_Number(i);case"boolean":return new(t?AST_True:AST_False)(i)}},MetaProperty:function(e){return "new"===e.meta.name&&"target"===e.property.name?new AST_NewTarget({start:n(e),end:o(e)}):"import"===e.meta.name&&"meta"===e.property.name?new AST_ImportMeta({start:n(e),end:o(e)}):void 0},Identifier:function(e){var t=r[r.length-2];return new("LabeledStatement"==t.type?AST_Label:"VariableDeclarator"==t.type&&t.id===e?"const"==t.kind?AST_SymbolConst:"let"==t.kind?AST_SymbolLet:AST_SymbolVar:/Import.*Specifier/.test(t.type)?t.local===e?AST_SymbolImport:AST_SymbolImportForeign:"ExportSpecifier"==t.type?t.local===e?AST_SymbolExport:AST_SymbolExportForeign:"FunctionExpression"==t.type?t.id===e?AST_SymbolLambda:AST_SymbolFunarg:"FunctionDeclaration"==t.type?t.id===e?AST_SymbolDefun:AST_SymbolFunarg:"ArrowFunctionExpression"==t.type?t.params.includes(e)?AST_SymbolFunarg:AST_SymbolRef:"ClassExpression"==t.type?t.id===e?AST_SymbolClass:AST_SymbolRef:"Property"==t.type?t.key===e&&t.computed||t.value===e?AST_SymbolRef:AST_SymbolMethod:"PropertyDefinition"==t.type||"FieldDefinition"===t.type?t.key===e&&t.computed||t.value===e?AST_SymbolRef:AST_SymbolClassProperty:"ClassDeclaration"==t.type?t.id===e?AST_SymbolDefClass:AST_SymbolRef:"MethodDefinition"==t.type?t.computed?AST_SymbolRef:AST_SymbolMethod:"CatchClause"==t.type?AST_SymbolCatch:"BreakStatement"==t.type||"ContinueStatement"==t.type?AST_LabelRef:AST_SymbolRef)({start:n(e),end:o(e),name:e.name})},BigIntLiteral:e=>new AST_BigInt({start:n(e),end:o(e),value:e.value})};function n(e){var t=e.loc,n=t&&t.start,o=e.range;return new AST_Token("","",n&&n.line||0,n&&n.column||0,o?o[0]:e.start,!1,[],[],t&&t.source)}function o(e){var t=e.loc,n=t&&t.end,o=e.range;return new AST_Token("","",n&&n.line||0,n&&n.column||0,o?o[0]:e.end,!1,[],[],t&&t.source)}function i(e,i,r){var u="function From_Moz_"+e+"(M){\n";u+="return new U2."+i.name+"({\nstart: my_start_token(M),\nend: my_end_token(M)";var _="function To_Moz_"+e+"(M){\n";_+="return {\ntype: "+JSON.stringify(e),r&&r.split(/\s*,\s*/).forEach((function(e){var t=/([a-z0-9$_]+)([=@>%])([a-z0-9$_]+)/i.exec(e);if(!t)throw new Error("Can't understand property map: "+e);var n=t[1],o=t[2],i=t[3];switch(u+=",\n"+i+": ",_+=",\n"+n+": ",o){case"@":u+="M."+n+".map(from_moz)",_+="M."+i+".map(to_moz)";break;case">":u+="from_moz(M."+n+")",_+="to_moz(M."+i+")";break;case"=":u+="M."+n,_+="M."+i;break;case"%":u+="from_moz(M."+n+").body",_+="to_moz_block(M)";break;default:throw new Error("Can't understand operator in propmap: "+e)}})),u+="\n})\n}",_+="\n}\n}",u=new Function("U2","my_start_token","my_end_token","from_moz","return("+u+")")(ast,n,o,a),_=new Function("to_moz","to_moz_block","to_moz_scope","return("+_+")")(l,c,f),t[e]=u,s(i,_);}t.UpdateExpression=t.UnaryExpression=function(e){return new(("prefix"in e?e.prefix:"UnaryExpression"==e.type)?AST_UnaryPrefix:AST_UnaryPostfix)({start:n(e),end:o(e),operator:e.operator,expression:a(e.argument)})},t.ClassDeclaration=t.ClassExpression=function(e){return new("ClassDeclaration"===e.type?AST_DefClass:AST_ClassExpression)({start:n(e),end:o(e),name:a(e.id),extends:a(e.superClass),properties:e.body.body.map(a)})},i("EmptyStatement",AST_EmptyStatement),i("BlockStatement",AST_BlockStatement,"body@body"),i("IfStatement",AST_If,"test>condition, consequent>body, alternate>alternative"),i("LabeledStatement",AST_LabeledStatement,"label>label, body>body"),i("BreakStatement",AST_Break,"label>label"),i("ContinueStatement",AST_Continue,"label>label"),i("WithStatement",AST_With,"object>expression, body>body"),i("SwitchStatement",AST_Switch,"discriminant>expression, cases@body"),i("ReturnStatement",AST_Return,"argument>value"),i("ThrowStatement",AST_Throw,"argument>value"),i("WhileStatement",AST_While,"test>condition, body>body"),i("DoWhileStatement",AST_Do,"test>condition, body>body"),i("ForStatement",AST_For,"init>init, test>condition, update>step, body>body"),i("ForInStatement",AST_ForIn,"left>init, right>object, body>body"),i("ForOfStatement",AST_ForOf,"left>init, right>object, body>body, await=await"),i("AwaitExpression",AST_Await,"argument>expression"),i("YieldExpression",AST_Yield,"argument>expression, delegate=is_star"),i("DebuggerStatement",AST_Debugger),i("VariableDeclarator",AST_VarDef,"id>name, init>value"),i("CatchClause",AST_Catch,"param>argname, body%body"),i("ThisExpression",AST_This),i("Super",AST_Super),i("BinaryExpression",AST_Binary,"operator=operator, left>left, right>right"),i("LogicalExpression",AST_Binary,"operator=operator, left>left, right>right"),i("AssignmentExpression",AST_Assign,"operator=operator, left>left, right>right"),i("ConditionalExpression",AST_Conditional,"test>condition, consequent>consequent, alternate>alternative"),i("NewExpression",AST_New,"callee>expression, arguments@args"),i("CallExpression",AST_Call,"callee>expression, optional=optional, arguments@args"),s(AST_Toplevel,(function(e){return f("Program",e)})),s(AST_Expansion,(function(e){return {type:_()?"RestElement":"SpreadElement",argument:l(e.expression)}})),s(AST_PrefixedTemplateString,(function(e){return {type:"TaggedTemplateExpression",tag:l(e.prefix),quasi:l(e.template_string)}})),s(AST_TemplateString,(function(e){for(var t=[],n=[],o=0;o<e.segments.length;o++)o%2!=0?n.push(l(e.segments[o])):t.push({type:"TemplateElement",value:{raw:e.segments[o].raw,cooked:e.segments[o].value},tail:o===e.segments.length-1});return {type:"TemplateLiteral",quasis:t,expressions:n}})),s(AST_Defun,(function(e){return {type:"FunctionDeclaration",id:l(e.name),params:e.argnames.map(l),generator:e.is_generator,async:e.async,body:f("BlockStatement",e)}})),s(AST_Function,(function(e,t){var n=void 0!==t.is_generator?t.is_generator:e.is_generator;return {type:"FunctionExpression",id:l(e.name),params:e.argnames.map(l),generator:n,async:e.async,body:f("BlockStatement",e)}})),s(AST_Arrow,(function(e){var t={type:"BlockStatement",body:e.body.map(l)};return {type:"ArrowFunctionExpression",params:e.argnames.map(l),async:e.async,body:t}})),s(AST_Destructuring,(function(e){return e.is_array?{type:"ArrayPattern",elements:e.names.map(l)}:{type:"ObjectPattern",properties:e.names.map(l)}})),s(AST_Directive,(function(e){return {type:"ExpressionStatement",expression:{type:"Literal",value:e.value,raw:e.print_to_string()},directive:e.value}})),s(AST_SimpleStatement,(function(e){return {type:"ExpressionStatement",expression:l(e.body)}})),s(AST_SwitchBranch,(function(e){return {type:"SwitchCase",test:l(e.expression),consequent:e.body.map(l)}})),s(AST_Try,(function(e){return {type:"TryStatement",block:c(e),handler:l(e.bcatch),guardedHandlers:[],finalizer:l(e.bfinally)}})),s(AST_Catch,(function(e){return {type:"CatchClause",param:l(e.argname),guard:null,body:c(e)}})),s(AST_Definitions,(function(e){return {type:"VariableDeclaration",kind:e instanceof AST_Const?"const":e instanceof AST_Let?"let":"var",declarations:e.definitions.map(l)}})),s(AST_Export,(function(e){return e.exported_names?"*"===e.exported_names[0].name.name?{type:"ExportAllDeclaration",source:l(e.module_name)}:{type:"ExportNamedDeclaration",specifiers:e.exported_names.map((function(e){return {type:"ExportSpecifier",exported:l(e.foreign_name),local:l(e.name)}})),declaration:l(e.exported_definition),source:l(e.module_name)}:{type:e.is_default?"ExportDefaultDeclaration":"ExportNamedDeclaration",declaration:l(e.exported_value||e.exported_definition)}})),s(AST_Import,(function(e){var t=[];return e.imported_name&&t.push({type:"ImportDefaultSpecifier",local:l(e.imported_name)}),e.imported_names&&"*"===e.imported_names[0].foreign_name.name?t.push({type:"ImportNamespaceSpecifier",local:l(e.imported_names[0].name)}):e.imported_names&&e.imported_names.forEach((function(e){t.push({type:"ImportSpecifier",local:l(e.name),imported:l(e.foreign_name)});})),{type:"ImportDeclaration",specifiers:t,source:l(e.module_name)}})),s(AST_ImportMeta,(function(){return {type:"MetaProperty",meta:{type:"Identifier",name:"import"},property:{type:"Identifier",name:"meta"}}})),s(AST_Sequence,(function(e){return {type:"SequenceExpression",expressions:e.expressions.map(l)}})),s(AST_DotHash,(function(e){return {type:"MemberExpression",object:l(e.expression),computed:!1,property:{type:"PrivateIdentifier",name:e.property},optional:e.optional}})),s(AST_PropAccess,(function(e){var t=e instanceof AST_Sub;return {type:"MemberExpression",object:l(e.expression),computed:t,property:t?l(e.property):{type:"Identifier",name:e.property},optional:e.optional}})),s(AST_Chain,(function(e){return {type:"ChainExpression",expression:l(e.expression)}})),s(AST_Unary,(function(e){return {type:"++"==e.operator||"--"==e.operator?"UpdateExpression":"UnaryExpression",operator:e.operator,prefix:e instanceof AST_UnaryPrefix,argument:l(e.expression)}})),s(AST_Binary,(function(e){return "="==e.operator&&_()?{type:"AssignmentPattern",left:l(e.left),right:l(e.right)}:{type:"&&"==e.operator||"||"==e.operator||"??"===e.operator?"LogicalExpression":"BinaryExpression",left:l(e.left),operator:e.operator,right:l(e.right)}})),s(AST_Array,(function(e){return {type:"ArrayExpression",elements:e.elements.map(l)}})),s(AST_Object,(function(e){return {type:"ObjectExpression",properties:e.properties.map(l)}})),s(AST_ObjectProperty,(function(e,t){var n,o=e.key instanceof AST_Node?l(e.key):{type:"Identifier",value:e.key};"number"==typeof e.key&&(o={type:"Literal",value:Number(e.key)}),"string"==typeof e.key&&(o={type:"Identifier",name:e.key});var i="string"==typeof e.key||"number"==typeof e.key,r=!i&&(!(e.key instanceof AST_Symbol)||e.key instanceof AST_SymbolRef);return e instanceof AST_ObjectKeyVal?(n="init",r=!i):e instanceof AST_ObjectGetter?n="get":e instanceof AST_ObjectSetter&&(n="set"),e instanceof AST_PrivateGetter||e instanceof AST_PrivateSetter?{type:"MethodDefinition",computed:!1,kind:e instanceof AST_PrivateGetter?"get":"set",static:e.static,key:{type:"PrivateIdentifier",name:e.key.name},value:l(e.value)}:e instanceof AST_ClassPrivateProperty?{type:"PropertyDefinition",key:{type:"PrivateIdentifier",name:e.key.name},value:l(e.value),computed:!1,static:e.static}:e instanceof AST_ClassProperty?{type:"PropertyDefinition",key:o,value:l(e.value),computed:r,static:e.static}:t instanceof AST_Class?{type:"MethodDefinition",computed:r,kind:n,static:e.static,key:l(e.key),value:l(e.value)}:{type:"Property",computed:r,kind:n,key:o,value:l(e.value)}})),s(AST_ConciseMethod,(function(e,t){if(t instanceof AST_Object)return {type:"Property",computed:!(e.key instanceof AST_Symbol)||e.key instanceof AST_SymbolRef,kind:"init",method:!0,shorthand:!1,key:l(e.key),value:l(e.value)};const n=e instanceof AST_PrivateMethod?{type:"PrivateIdentifier",name:e.key.name}:l(e.key);return {type:"MethodDefinition",kind:"constructor"===e.key?"constructor":"method",key:n,value:l(e.value),computed:!(e.key instanceof AST_Symbol)||e.key instanceof AST_SymbolRef,static:e.static}})),s(AST_Class,(function(e){return {type:e instanceof AST_ClassExpression?"ClassExpression":"ClassDeclaration",superClass:l(e.extends),id:e.name?l(e.name):null,body:{type:"ClassBody",body:e.properties.map(l)}}})),s(AST_NewTarget,(function(){return {type:"MetaProperty",meta:{type:"Identifier",name:"new"},property:{type:"Identifier",name:"target"}}})),s(AST_Symbol,(function(e,t){if(e instanceof AST_SymbolMethod&&t.quote)return {type:"Literal",value:e.name};var n=e.definition();return {type:"Identifier",name:n?n.mangled_name||n.name:e.name}})),s(AST_RegExp,(function(e){const t=e.value.source,n=e.value.flags;return {type:"Literal",value:null,raw:e.print_to_string(),regex:{pattern:t,flags:n}}})),s(AST_Constant,(function(e){return {type:"Literal",value:e.value,raw:e.raw||e.print_to_string()}})),s(AST_Atom,(function(e){return {type:"Identifier",name:String(e.value)}})),s(AST_BigInt,(e=>({type:"BigIntLiteral",value:e.value}))),AST_Boolean.DEFMETHOD("to_mozilla_ast",AST_Constant.prototype.to_mozilla_ast),AST_Null.DEFMETHOD("to_mozilla_ast",AST_Constant.prototype.to_mozilla_ast),AST_Hole.DEFMETHOD("to_mozilla_ast",(function(){return null})),AST_Block.DEFMETHOD("to_mozilla_ast",AST_BlockStatement.prototype.to_mozilla_ast),AST_Lambda.DEFMETHOD("to_mozilla_ast",AST_Function.prototype.to_mozilla_ast);var r=null;function a(e){r.push(e);var n=null!=e?t[e.type](e):null;return r.pop(),n}function s(e,t){e.DEFMETHOD("to_mozilla_ast",(function(e){return n=t(this,e),o=this.start,i=this.end,o&&i?(null!=o.pos&&null!=i.endpos&&(n.range=[o.pos,i.endpos]),o.line&&(n.loc={start:{line:o.line,column:o.col},end:i.endline?{line:i.endline,column:i.endcol}:null},o.file&&(n.loc.source=o.file)),n):n;var n,o,i;}));}AST_Node.from_mozilla_ast=function(e){var t=r;r=[];var n=a(e);return r=t,n};var u=null;function l(e){null===u&&(u=[]),u.push(e);var t=null!=e?e.to_mozilla_ast(u[u.length-2]):null;return u.pop(),0===u.length&&(u=null),t}function _(){for(var e=u.length;e--;)if(u[e]instanceof AST_Destructuring)return !0;return !1}function c(e){return {type:"BlockStatement",body:e.body.map(l)}}function f(e,t){var n=t.body.map(l);return t.body[0]instanceof AST_SimpleStatement&&t.body[0].body instanceof AST_String&&n.unshift(l(new AST_EmptyStatement(t.body[0]))),{type:e,body:n}}}();const EXPECT_DIRECTIVE=/^$|[;{][\s\n]*$/,r_annotation=/[@#]__(PURE|INLINE|NOINLINE)__/g;function is_some_comments(e){return ("comment2"===e.type||"comment1"===e.type)&&/@preserve|@lic|@cc_on|^\**!/i.test(e.value)}function OutputStream(e){var t=!e;void 0===(e=defaults$1(e,{ascii_only:!1,beautify:!1,braces:!1,comments:"some",ecma:5,ie8:!1,indent_level:4,indent_start:0,inline_script:!0,keep_numbers:!1,keep_quoted_props:!1,max_line_len:!1,preamble:null,preserve_annotations:!1,quote_keys:!1,quote_style:0,safari10:!1,semicolons:!0,shebang:!0,shorthand:void 0,source_map:null,webkit:!1,width:80,wrap_iife:!1,wrap_func_args:!0},!0)).shorthand&&(e.shorthand=e.ecma>5);var n=return_false;if(e.comments){let t=e.comments;if("string"==typeof e.comments&&/^\/.*\/[a-zA-Z]*$/.test(e.comments)){var o=e.comments.lastIndexOf("/");t=new RegExp(e.comments.substr(1,o-1),e.comments.substr(o+1));}n=t instanceof RegExp?function(e){return "comment5"!=e.type&&t.test(e.value)}:"function"==typeof t?function(e){return "comment5"!=e.type&&t(this,e)}:"some"===t?is_some_comments:return_true;}var i=0,r=0,a=1,s=0,u="";let l=new Set;var _=e.ascii_only?function(t,n){return e.ecma>=2015&&!e.safari10&&(t=t.replace(/[\ud800-\udbff][\udc00-\udfff]/g,(function(e){return "\\u{"+get_full_char_code(e,0).toString(16)+"}"}))),t.replace(/[\u0000-\u001f\u007f-\uffff]/g,(function(e){var t=e.charCodeAt(0).toString(16);if(t.length<=2&&!n){for(;t.length<2;)t="0"+t;return "\\x"+t}for(;t.length<4;)t="0"+t;return "\\u"+t}))}:function(e){return e.replace(/[\ud800-\udbff][\udc00-\udfff]|([\ud800-\udbff]|[\udc00-\udfff])/g,(function(e,t){return t?"\\u"+t.charCodeAt(0).toString(16):e}))};function c(t,n){var o=function(t,n){var o=0,i=0;function r(){return "'"+t.replace(/\x27/g,"\\'")+"'"}function a(){return '"'+t.replace(/\x22/g,'\\"')+'"'}if(t=t.replace(/[\\\b\f\n\r\v\t\x22\x27\u2028\u2029\0\ufeff]/g,(function(n,r){switch(n){case'"':return ++o,'"';case"'":return ++i,"'";case"\\":return "\\\\";case"\n":return "\\n";case"\r":return "\\r";case"\t":return "\\t";case"\b":return "\\b";case"\f":return "\\f";case"\v":return e.ie8?"\\x0B":"\\v";case"\u2028":return "\\u2028";case"\u2029":return "\\u2029";case"\ufeff":return "\\ufeff";case"\0":return /[0-9]/.test(get_full_char(t,r+1))?"\\x00":"\\0"}return n})),t=_(t),"`"===n)return "`"+t.replace(/`/g,"\\`")+"`";switch(e.quote_style){case 1:return r();case 2:return a();case 3:return "'"==n?r():a();default:return o>i?r():a()}}(t,n);return e.inline_script&&(o=(o=(o=o.replace(/<\x2f(script)([>\/\t\n\f\r ])/gi,"<\\/$1$2")).replace(/\x3c!--/g,"\\x3c!--")).replace(/--\x3e/g,"--\\x3e")),o}var f,p,d=!1,S=!1,m=!1,A=0,T=!1,h=!1,E=-1,g="",D=e.source_map&&[],b=D?function(){D.forEach((function(t){try{e.source_map.add(t.token.file,t.line,t.col,t.token.line,t.token.col,t.name||"name"!=t.token.type?t.name:t.token.value);}catch(e){}})),D=[];}:noop,y=e.max_line_len?function(){if(r>e.max_line_len&&A){var t=u.slice(0,A),n=u.slice(A);if(D){var o=n.length-r;D.forEach((function(e){e.line++,e.col+=o;}));}u=t+"\n"+n,a++,s++,r=n.length;}A&&(A=0,b());}:noop,v=makePredicate("( [ + * / - , . `");function C(t){var n=get_full_char(t=String(t),0);T&&n&&(T=!1,"\n"!==n&&(C("\n"),k())),h&&n&&(h=!1,/[\s;})]/.test(n)||R()),E=-1;var o=g.charAt(g.length-1);m&&(m=!1,(":"!==o||"}"!==n)&&(n&&";}".includes(n)||";"===o)||(e.semicolons||v.has(n)?(u+=";",r++,s++):(y(),r>0&&(u+="\n",s++,a++,r=0),/^\s+$/.test(t)&&(m=!0)),e.beautify||(S=!1))),S&&((is_identifier_char(o)&&(is_identifier_char(n)||"\\"==n)||"/"==n&&n==o||("+"==n||"-"==n)&&n==g)&&(u+=" ",r++,s++),S=!1),f&&(D.push({token:f,name:p,line:a,col:r}),f=!1,A||b()),u+=t,d="("==t[t.length-1],s+=t.length;var i=t.split(/\r?\n/),l=i.length-1;a+=l,r+=i[0].length,l>0&&(y(),r=i[l].length),g=t;}var R=e.beautify?function(){C(" ");}:function(){S=!0;},k=e.beautify?function(t){var n;e.beautify&&C((n=t?.5:0," ".repeat(e.indent_start+i-n*e.indent_level)));}:noop,O=e.beautify?function(e,t){!0===e&&(e=I());var n=i;i=e;var o=t();return i=n,o}:function(e,t){return t()},F=e.beautify?function(){if(E<0)return C("\n");"\n"!=u[E]&&(u=u.slice(0,E)+"\n"+u.slice(E),s++,a++),E++;}:e.max_line_len?function(){y(),A=u.length;}:noop,N=e.beautify?function(){C(";");}:function(){m=!0;};function M(){m=!1,C(";");}function I(){return i+e.indent_level}function x(){return A&&y(),u}function w(){let e=u.length-1;for(;e>=0;){const t=u.charCodeAt(e);if(10===t)return !0;if(32!==t)return !1;e--;}return !0}function P(t){return e.preserve_annotations||(t=t.replace(r_annotation," ")),/^\s*$/.test(t)?"":t.replace(/(<\s*\/\s*)(script)/i,"<\\/$2")}var B=[];return {get:x,toString:x,indent:k,in_directive:!1,use_asm:null,active_scope:null,indentation:function(){return i},current_width:function(){return r-i},should_break:function(){return e.width&&this.current_width()>=e.width},has_parens:function(){return d},newline:F,print:C,star:function(){C("*");},space:R,comma:function(){C(","),R();},colon:function(){C(":"),R();},last:function(){return g},semicolon:N,force_semicolon:M,to_utf8:_,print_name:function(e){C(function(e){return e=e.toString(),_(e,!0)}(e));},print_string:function(e,t,n){var o=c(e,t);!0!==n||o.includes("\\")||(EXPECT_DIRECTIVE.test(u)||M(),M()),C(o);},print_template_string_chars:function(e){var t=c(e,"`").replace(/\${/g,"\\${");return C(t.substr(1,t.length-2))},encode_string:c,next_indent:I,with_indent:O,with_block:function(e){var t;return C("{"),F(),O(I(),(function(){t=e();})),k(),C("}"),t},with_parens:function(e){C("(");var t=e();return C(")"),t},with_square:function(e){C("[");var t=e();return C("]"),t},add_mapping:D?function(e,t){f=e,p=t;}:noop,option:function(t){return e[t]},printed_comments:l,prepend_comments:t?noop:function(t){var o=t.start;if(!o)return;var i=this.printed_comments;const r=t instanceof AST_Exit&&t.value;if(o.comments_before&&i.has(o.comments_before)){if(!r)return;o.comments_before=[];}var a=o.comments_before;if(a||(a=o.comments_before=[]),i.add(a),r){var u=new TreeWalker((function(e){var t=u.parent();if(!(t instanceof AST_Exit||t instanceof AST_Binary&&t.left===e||"Call"==t.TYPE&&t.expression===e||t instanceof AST_Conditional&&t.condition===e||t instanceof AST_Dot&&t.expression===e||t instanceof AST_Sequence&&t.expressions[0]===e||t instanceof AST_Sub&&t.expression===e||t instanceof AST_UnaryPostfix))return !0;if(e.start){var n=e.start.comments_before;n&&!i.has(n)&&(i.add(n),a=a.concat(n));}}));u.push(t),t.value.walk(u);}if(0==s){a.length>0&&e.shebang&&"comment5"===a[0].type&&!i.has(a[0])&&(C("#!"+a.shift().value+"\n"),k());var l=e.preamble;l&&C(l.replace(/\r\n?|[\n\u2028\u2029]|\s*$/g,"\n"));}if(0!=(a=a.filter(n,t).filter((e=>!i.has(e)))).length){var _=w();a.forEach((function(e,t){if(i.add(e),_||(e.nlb?(C("\n"),k(),_=!0):t>0&&R()),/comment[134]/.test(e.type))(n=P(e.value))&&(C("//"+n+"\n"),k()),_=!0;else if("comment2"==e.type){var n;(n=P(e.value))&&C("/*"+n+"*/"),_=!1;}})),_||(o.nlb?(C("\n"),k()):R());}},append_comments:t||n===return_false?noop:function(e,t){var o=e.end;if(o){var i=this.printed_comments,r=o[t?"comments_before":"comments_after"];if(r&&!i.has(r)&&(e instanceof AST_Statement||r.every((e=>!/comment[134]/.test(e.type))))){i.add(r);var a=u.length;r.filter(n,e).forEach((function(e,n){if(!i.has(e))if(i.add(e),h=!1,T?(C("\n"),k(),T=!1):e.nlb&&(n>0||!w())?(C("\n"),k()):(n>0||!t)&&R(),/comment[134]/.test(e.type)){const t=P(e.value);t&&C("//"+t),T=!0;}else if("comment2"==e.type){const t=P(e.value);t&&C("/*"+t+"*/"),h=!0;}})),u.length>a&&(E=a);}}},line:function(){return a},col:function(){return r},pos:function(){return s},push_node:function(e){B.push(e);},pop_node:function(){return B.pop()},parent:function(e){return B[B.length-2-(e||0)]}}}!function(){function e(e,t){e.DEFMETHOD("_codegen",t);}function t(e,n){Array.isArray(e)?e.forEach((function(e){t(e,n);})):e.DEFMETHOD("needs_parens",n);}function n(e,t,n,o){var i=e.length-1;n.in_directive=o,e.forEach((function(e,o){!0!==n.in_directive||e instanceof AST_Directive||e instanceof AST_EmptyStatement||e instanceof AST_SimpleStatement&&e.body instanceof AST_String||(n.in_directive=!1),e instanceof AST_EmptyStatement||(n.indent(),e.print(n),o==i&&t||(n.newline(),t&&n.newline())),!0===n.in_directive&&e instanceof AST_SimpleStatement&&e.body instanceof AST_String&&(n.in_directive=!1);})),n.in_directive=!1;}function o(e,t){t.print("{"),t.with_indent(t.next_indent(),(function(){t.append_comments(e,!0);})),t.print("}");}function i(e,t,i){e.body.length>0?t.with_block((function(){n(e.body,!1,t,i);})):o(e,t);}function r(e,t,n){var o=!1;n&&(o=walk$3(e,(e=>e instanceof AST_Scope||(e instanceof AST_Binary&&"in"==e.operator?walk_abort:void 0)))),e.print(t,o);}function a(e,t,n){return n.option("quote_keys")?n.print_string(e):""+ +e==e&&e>=0?n.option("keep_numbers")?n.print(e):n.print(_(e)):(RESERVED_WORDS.has(e)?n.option("ie8"):n.option("ecma")<2015||n.option("safari10")?!is_basic_identifier_string(e):!is_identifier_string(e,!0))||t&&n.option("keep_quoted_props")?n.print_string(e,t):n.print_name(e)}AST_Node.DEFMETHOD("print",(function(e,t){var n=this,o=n._codegen;function i(){e.prepend_comments(n),n.add_source_map(e),o(n,e),e.append_comments(n);}n instanceof AST_Scope?e.active_scope=n:!e.use_asm&&n instanceof AST_Directive&&"use asm"==n.value&&(e.use_asm=e.active_scope),e.push_node(n),t||n.needs_parens(e)?e.with_parens(i):i(),e.pop_node(),n===e.use_asm&&(e.use_asm=null);})),AST_Node.DEFMETHOD("_print",AST_Node.prototype.print),AST_Node.DEFMETHOD("print_to_string",(function(e){var t=OutputStream(e);return this.print(t),t.get()})),t(AST_Node,return_false),t(AST_Function,(function(e){return !(e.has_parens()||!first_in_statement(e))||(!!(e.option("webkit")&&(t=e.parent())instanceof AST_PropAccess&&t.expression===this)||(!!(e.option("wrap_iife")&&(t=e.parent())instanceof AST_Call&&t.expression===this)||!!(e.option("wrap_func_args")&&(t=e.parent())instanceof AST_Call&&t.args.includes(this))));var t;})),t(AST_Arrow,(function(e){var t=e.parent();return !!(e.option("wrap_func_args")&&t instanceof AST_Call&&t.args.includes(this))||t instanceof AST_PropAccess&&t.expression===this})),t(AST_Object,(function(e){return !e.has_parens()&&first_in_statement(e)})),t(AST_ClassExpression,first_in_statement),t(AST_Unary,(function(e){var t=e.parent();return t instanceof AST_PropAccess&&t.expression===this||t instanceof AST_Call&&t.expression===this||t instanceof AST_Binary&&"**"===t.operator&&this instanceof AST_UnaryPrefix&&t.left===this&&"++"!==this.operator&&"--"!==this.operator})),t(AST_Await,(function(e){var t=e.parent();return t instanceof AST_PropAccess&&t.expression===this||t instanceof AST_Call&&t.expression===this||t instanceof AST_Binary&&"**"===t.operator&&t.left===this||e.option("safari10")&&t instanceof AST_UnaryPrefix})),t(AST_Sequence,(function(e){var t=e.parent();return t instanceof AST_Call||t instanceof AST_Unary||t instanceof AST_Binary||t instanceof AST_VarDef||t instanceof AST_PropAccess||t instanceof AST_Array||t instanceof AST_ObjectProperty||t instanceof AST_Conditional||t instanceof AST_Arrow||t instanceof AST_DefaultAssign||t instanceof AST_Expansion||t instanceof AST_ForOf&&this===t.object||t instanceof AST_Yield||t instanceof AST_Export})),t(AST_Binary,(function(e){var t=e.parent();if(t instanceof AST_Call&&t.expression===this)return !0;if(t instanceof AST_Unary)return !0;if(t instanceof AST_PropAccess&&t.expression===this)return !0;if(t instanceof AST_Binary){const e=t.operator,n=this.operator;if("??"===n&&("||"===e||"&&"===e))return !0;if("??"===e&&("||"===n||"&&"===n))return !0;const o=PRECEDENCE[e],i=PRECEDENCE[n];if(o>i||o==i&&(this===t.right||"**"==e))return !0}})),t(AST_Yield,(function(e){var t=e.parent();return t instanceof AST_Binary&&"="!==t.operator||t instanceof AST_Call&&t.expression===this||t instanceof AST_Conditional&&t.condition===this||t instanceof AST_Unary||t instanceof AST_PropAccess&&t.expression===this||void 0})),t(AST_PropAccess,(function(e){var t=e.parent();if(t instanceof AST_New&&t.expression===this)return walk$3(this,(e=>e instanceof AST_Scope||(e instanceof AST_Call?walk_abort:void 0)))})),t(AST_Call,(function(e){var t,n=e.parent();return !!(n instanceof AST_New&&n.expression===this||n instanceof AST_Export&&n.is_default&&this.expression instanceof AST_Function)||this.expression instanceof AST_Function&&n instanceof AST_PropAccess&&n.expression===this&&(t=e.parent(1))instanceof AST_Assign&&t.left===n})),t(AST_New,(function(e){var t=e.parent();if(0===this.args.length&&(t instanceof AST_PropAccess||t instanceof AST_Call&&t.expression===this))return !0})),t(AST_Number,(function(e){var t=e.parent();if(t instanceof AST_PropAccess&&t.expression===this){var n=this.getValue();if(n<0||/^0/.test(_(n)))return !0}})),t(AST_BigInt,(function(e){var t=e.parent();if(t instanceof AST_PropAccess&&t.expression===this&&this.getValue().startsWith("-"))return !0})),t([AST_Assign,AST_Conditional],(function(e){var t=e.parent();return t instanceof AST_Unary||t instanceof AST_Binary&&!(t instanceof AST_Assign)||t instanceof AST_Call&&t.expression===this||t instanceof AST_Conditional&&t.condition===this||t instanceof AST_PropAccess&&t.expression===this||this instanceof AST_Assign&&this.left instanceof AST_Destructuring&&!1===this.left.is_array||void 0})),e(AST_Directive,(function(e,t){t.print_string(e.value,e.quote),t.semicolon();})),e(AST_Expansion,(function(e,t){t.print("..."),e.expression.print(t);})),e(AST_Destructuring,(function(e,t){t.print(e.is_array?"[":"{");var n=e.names.length;e.names.forEach((function(e,o){o>0&&t.comma(),e.print(t),o==n-1&&e instanceof AST_Hole&&t.comma();})),t.print(e.is_array?"]":"}");})),e(AST_Debugger,(function(e,t){t.print("debugger"),t.semicolon();})),AST_StatementWithBody.DEFMETHOD("_do_print_body",(function(e){l(this.body,e);})),e(AST_Statement,(function(e,t){e.body.print(t),t.semicolon();})),e(AST_Toplevel,(function(e,t){n(e.body,!0,t,!0),t.print("");})),e(AST_LabeledStatement,(function(e,t){e.label.print(t),t.colon(),e.body.print(t);})),e(AST_SimpleStatement,(function(e,t){e.body.print(t),t.semicolon();})),e(AST_BlockStatement,(function(e,t){i(e,t);})),e(AST_EmptyStatement,(function(e,t){t.semicolon();})),e(AST_Do,(function(e,t){t.print("do"),t.space(),c(e.body,t),t.space(),t.print("while"),t.space(),t.with_parens((function(){e.condition.print(t);})),t.semicolon();})),e(AST_While,(function(e,t){t.print("while"),t.space(),t.with_parens((function(){e.condition.print(t);})),t.space(),e._do_print_body(t);})),e(AST_For,(function(e,t){t.print("for"),t.space(),t.with_parens((function(){e.init?(e.init instanceof AST_Definitions?e.init.print(t):r(e.init,t,!0),t.print(";"),t.space()):t.print(";"),e.condition?(e.condition.print(t),t.print(";"),t.space()):t.print(";"),e.step&&e.step.print(t);})),t.space(),e._do_print_body(t);})),e(AST_ForIn,(function(e,t){t.print("for"),e.await&&(t.space(),t.print("await")),t.space(),t.with_parens((function(){e.init.print(t),t.space(),t.print(e instanceof AST_ForOf?"of":"in"),t.space(),e.object.print(t);})),t.space(),e._do_print_body(t);})),e(AST_With,(function(e,t){t.print("with"),t.space(),t.with_parens((function(){e.expression.print(t);})),t.space(),e._do_print_body(t);})),AST_Lambda.DEFMETHOD("_do_print",(function(e,t){var n=this;t||(n.async&&(e.print("async"),e.space()),e.print("function"),n.is_generator&&e.star(),n.name&&e.space()),n.name instanceof AST_Symbol?n.name.print(e):t&&n.name instanceof AST_Node&&e.with_square((function(){n.name.print(e);})),e.with_parens((function(){n.argnames.forEach((function(t,n){n&&e.comma(),t.print(e);}));})),e.space(),i(n,e,!0);})),e(AST_Lambda,(function(e,t){e._do_print(t);})),e(AST_PrefixedTemplateString,(function(e,t){var n=e.prefix,o=n instanceof AST_Lambda||n instanceof AST_Binary||n instanceof AST_Conditional||n instanceof AST_Sequence||n instanceof AST_Unary||n instanceof AST_Dot&&n.expression instanceof AST_Object;o&&t.print("("),e.prefix.print(t),o&&t.print(")"),e.template_string.print(t);})),e(AST_TemplateString,(function(e,t){var n=t.parent()instanceof AST_PrefixedTemplateString;t.print("`");for(var o=0;o<e.segments.length;o++)e.segments[o]instanceof AST_TemplateSegment?n?t.print(e.segments[o].raw):t.print_template_string_chars(e.segments[o].value):(t.print("${"),e.segments[o].print(t),t.print("}"));t.print("`");})),e(AST_TemplateSegment,(function(e,t){t.print_template_string_chars(e.value);})),AST_Arrow.DEFMETHOD("_do_print",(function(e){var t=this,n=e.parent(),o=n instanceof AST_Binary&&!(n instanceof AST_Assign)||n instanceof AST_Unary||n instanceof AST_Call&&t===n.expression;o&&e.print("("),t.async&&(e.print("async"),e.space()),1===t.argnames.length&&t.argnames[0]instanceof AST_Symbol?t.argnames[0].print(e):e.with_parens((function(){t.argnames.forEach((function(t,n){n&&e.comma(),t.print(e);}));})),e.space(),e.print("=>"),e.space();const r=t.body[0];if(1===t.body.length&&r instanceof AST_Return){const t=r.value;t?left_is_object(t)?(e.print("("),t.print(e),e.print(")")):t.print(e):e.print("{}");}else i(t,e);o&&e.print(")");})),AST_Exit.DEFMETHOD("_do_print",(function(e,t){if(e.print(t),this.value){e.space();const t=this.value.start.comments_before;t&&t.length&&!e.printed_comments.has(t)?(e.print("("),this.value.print(e),e.print(")")):this.value.print(e);}e.semicolon();})),e(AST_Return,(function(e,t){e._do_print(t,"return");})),e(AST_Throw,(function(e,t){e._do_print(t,"throw");})),e(AST_Yield,(function(e,t){var n=e.is_star?"*":"";t.print("yield"+n),e.expression&&(t.space(),e.expression.print(t));})),e(AST_Await,(function(e,t){t.print("await"),t.space();var n=e.expression,o=!(n instanceof AST_Call||n instanceof AST_SymbolRef||n instanceof AST_PropAccess||n instanceof AST_Unary||n instanceof AST_Constant||n instanceof AST_Await||n instanceof AST_Object);o&&t.print("("),e.expression.print(t),o&&t.print(")");})),AST_LoopControl.DEFMETHOD("_do_print",(function(e,t){e.print(t),this.label&&(e.space(),this.label.print(e)),e.semicolon();})),e(AST_Break,(function(e,t){e._do_print(t,"break");})),e(AST_Continue,(function(e,t){e._do_print(t,"continue");})),e(AST_If,(function(e,t){t.print("if"),t.space(),t.with_parens((function(){e.condition.print(t);})),t.space(),e.alternative?(function(e,t){var n=e.body;if(t.option("braces")||t.option("ie8")&&n instanceof AST_Do)return c(n,t);if(!n)return t.force_semicolon();for(;;)if(n instanceof AST_If){if(!n.alternative)return void c(e.body,t);n=n.alternative;}else {if(!(n instanceof AST_StatementWithBody))break;n=n.body;}l(e.body,t);}(e,t),t.space(),t.print("else"),t.space(),e.alternative instanceof AST_If?e.alternative.print(t):l(e.alternative,t)):e._do_print_body(t);})),e(AST_Switch,(function(e,t){t.print("switch"),t.space(),t.with_parens((function(){e.expression.print(t);})),t.space();var n=e.body.length-1;n<0?o(e,t):t.with_block((function(){e.body.forEach((function(e,o){t.indent(!0),e.print(t),o<n&&e.body.length>0&&t.newline();}));}));})),AST_SwitchBranch.DEFMETHOD("_do_print_body",(function(e){e.newline(),this.body.forEach((function(t){e.indent(),t.print(e),e.newline();}));})),e(AST_Default,(function(e,t){t.print("default:"),e._do_print_body(t);})),e(AST_Case,(function(e,t){t.print("case"),t.space(),e.expression.print(t),t.print(":"),e._do_print_body(t);})),e(AST_Try,(function(e,t){t.print("try"),t.space(),i(e,t),e.bcatch&&(t.space(),e.bcatch.print(t)),e.bfinally&&(t.space(),e.bfinally.print(t));})),e(AST_Catch,(function(e,t){t.print("catch"),e.argname&&(t.space(),t.with_parens((function(){e.argname.print(t);}))),t.space(),i(e,t);})),e(AST_Finally,(function(e,t){t.print("finally"),t.space(),i(e,t);})),AST_Definitions.DEFMETHOD("_do_print",(function(e,t){e.print(t),e.space(),this.definitions.forEach((function(t,n){n&&e.comma(),t.print(e);}));var n=e.parent();(!(n instanceof AST_For||n instanceof AST_ForIn)||n&&n.init!==this)&&e.semicolon();})),e(AST_Let,(function(e,t){e._do_print(t,"let");})),e(AST_Var,(function(e,t){e._do_print(t,"var");})),e(AST_Const,(function(e,t){e._do_print(t,"const");})),e(AST_Import,(function(e,t){t.print("import"),t.space(),e.imported_name&&e.imported_name.print(t),e.imported_name&&e.imported_names&&(t.print(","),t.space()),e.imported_names&&(1===e.imported_names.length&&"*"===e.imported_names[0].foreign_name.name?e.imported_names[0].print(t):(t.print("{"),e.imported_names.forEach((function(n,o){t.space(),n.print(t),o<e.imported_names.length-1&&t.print(",");})),t.space(),t.print("}"))),(e.imported_name||e.imported_names)&&(t.space(),t.print("from"),t.space()),e.module_name.print(t),t.semicolon();})),e(AST_ImportMeta,(function(e,t){t.print("import.meta");})),e(AST_NameMapping,(function(e,t){var n=t.parent()instanceof AST_Import,o=e.name.definition();(o&&o.mangled_name||e.name.name)!==e.foreign_name.name?(n?t.print(e.foreign_name.name):e.name.print(t),t.space(),t.print("as"),t.space(),n?e.name.print(t):t.print(e.foreign_name.name)):e.name.print(t);})),e(AST_Export,(function(e,t){if(t.print("export"),t.space(),e.is_default&&(t.print("default"),t.space()),e.exported_names)1===e.exported_names.length&&"*"===e.exported_names[0].name.name?e.exported_names[0].print(t):(t.print("{"),e.exported_names.forEach((function(n,o){t.space(),n.print(t),o<e.exported_names.length-1&&t.print(",");})),t.space(),t.print("}"));else if(e.exported_value)e.exported_value.print(t);else if(e.exported_definition&&(e.exported_definition.print(t),e.exported_definition instanceof AST_Definitions))return;e.module_name&&(t.space(),t.print("from"),t.space(),e.module_name.print(t)),(e.exported_value&&!(e.exported_value instanceof AST_Defun||e.exported_value instanceof AST_Function||e.exported_value instanceof AST_Class)||e.module_name||e.exported_names)&&t.semicolon();})),e(AST_VarDef,(function(e,t){if(e.name.print(t),e.value){t.space(),t.print("="),t.space();var n=t.parent(1),o=n instanceof AST_For||n instanceof AST_ForIn;r(e.value,t,o);}})),e(AST_Call,(function(e,t){e.expression.print(t),e instanceof AST_New&&0===e.args.length||((e.expression instanceof AST_Call||e.expression instanceof AST_Lambda)&&t.add_mapping(e.start),e.optional&&t.print("?."),t.with_parens((function(){e.args.forEach((function(e,n){n&&t.comma(),e.print(t);}));})));})),e(AST_New,(function(e,t){t.print("new"),t.space(),AST_Call.prototype._codegen(e,t);})),AST_Sequence.DEFMETHOD("_do_print",(function(e){this.expressions.forEach((function(t,n){n>0&&(e.comma(),e.should_break()&&(e.newline(),e.indent())),t.print(e);}));})),e(AST_Sequence,(function(e,t){e._do_print(t);})),e(AST_Dot,(function(e,t){var n=e.expression;n.print(t);var o=e.property,i=RESERVED_WORDS.has(o)?t.option("ie8"):!is_identifier_string(o,t.option("ecma")>=2015||t.option("safari10"));e.optional&&t.print("?."),i?(t.print("["),t.add_mapping(e.end),t.print_string(o),t.print("]")):(n instanceof AST_Number&&n.getValue()>=0&&(/[xa-f.)]/i.test(t.last())||t.print(".")),e.optional||t.print("."),t.add_mapping(e.end),t.print_name(o));})),e(AST_DotHash,(function(e,t){e.expression.print(t);var n=e.property;e.optional&&t.print("?"),t.print(".#"),t.print_name(n);})),e(AST_Sub,(function(e,t){e.expression.print(t),e.optional&&t.print("?."),t.print("["),e.property.print(t),t.print("]");})),e(AST_Chain,(function(e,t){e.expression.print(t);})),e(AST_UnaryPrefix,(function(e,t){var n=e.operator;t.print(n),(/^[a-z]/i.test(n)||/[+-]$/.test(n)&&e.expression instanceof AST_UnaryPrefix&&/^[+-]/.test(e.expression.operator))&&t.space(),e.expression.print(t);})),e(AST_UnaryPostfix,(function(e,t){e.expression.print(t),t.print(e.operator);})),e(AST_Binary,(function(e,t){var n=e.operator;e.left.print(t),">"==n[0]&&e.left instanceof AST_UnaryPostfix&&"--"==e.left.operator?t.print(" "):t.space(),t.print(n),("<"==n||"<<"==n)&&e.right instanceof AST_UnaryPrefix&&"!"==e.right.operator&&e.right.expression instanceof AST_UnaryPrefix&&"--"==e.right.expression.operator?t.print(" "):t.space(),e.right.print(t);})),e(AST_Conditional,(function(e,t){e.condition.print(t),t.space(),t.print("?"),t.space(),e.consequent.print(t),t.space(),t.colon(),e.alternative.print(t);})),e(AST_Array,(function(e,t){t.with_square((function(){var n=e.elements,o=n.length;o>0&&t.space(),n.forEach((function(e,n){n&&t.comma(),e.print(t),n===o-1&&e instanceof AST_Hole&&t.comma();})),o>0&&t.space();}));})),e(AST_Object,(function(e,t){e.properties.length>0?t.with_block((function(){e.properties.forEach((function(e,n){n&&(t.print(","),t.newline()),t.indent(),e.print(t);})),t.newline();})):o(e,t);})),e(AST_Class,(function(e,t){if(t.print("class"),t.space(),e.name&&(e.name.print(t),t.space()),e.extends){var n=!(e.extends instanceof AST_SymbolRef||e.extends instanceof AST_PropAccess||e.extends instanceof AST_ClassExpression||e.extends instanceof AST_Function);t.print("extends"),n?t.print("("):t.space(),e.extends.print(t),n?t.print(")"):t.space();}e.properties.length>0?t.with_block((function(){e.properties.forEach((function(e,n){n&&t.newline(),t.indent(),e.print(t);})),t.newline();})):t.print("{}");})),e(AST_NewTarget,(function(e,t){t.print("new.target");})),e(AST_ObjectKeyVal,(function(e,t){function n(e){var t=e.definition();return t?t.mangled_name||t.name:e.name}var o=t.option("shorthand");o&&e.value instanceof AST_Symbol&&is_identifier_string(e.key,t.option("ecma")>=2015||t.option("safari10"))&&n(e.value)===e.key&&!RESERVED_WORDS.has(e.key)?a(e.key,e.quote,t):o&&e.value instanceof AST_DefaultAssign&&e.value.left instanceof AST_Symbol&&is_identifier_string(e.key,t.option("ecma")>=2015||t.option("safari10"))&&n(e.value.left)===e.key?(a(e.key,e.quote,t),t.space(),t.print("="),t.space(),e.value.right.print(t)):(e.key instanceof AST_Node?t.with_square((function(){e.key.print(t);})):a(e.key,e.quote,t),t.colon(),e.value.print(t));})),e(AST_ClassPrivateProperty,((e,t)=>{e.static&&(t.print("static"),t.space()),t.print("#"),a(e.key.name,e.quote,t),e.value&&(t.print("="),e.value.print(t)),t.semicolon();})),e(AST_ClassProperty,((e,t)=>{e.static&&(t.print("static"),t.space()),e.key instanceof AST_SymbolClassProperty?a(e.key.name,e.quote,t):(t.print("["),e.key.print(t),t.print("]")),e.value&&(t.print("="),e.value.print(t)),t.semicolon();})),AST_ObjectProperty.DEFMETHOD("_print_getter_setter",(function(e,t,n){var o=this;o.static&&(n.print("static"),n.space()),e&&(n.print(e),n.space()),o.key instanceof AST_SymbolMethod?(t&&n.print("#"),a(o.key.name,o.quote,n)):n.with_square((function(){o.key.print(n);})),o.value._do_print(n,!0);})),e(AST_ObjectSetter,(function(e,t){e._print_getter_setter("set",!1,t);})),e(AST_ObjectGetter,(function(e,t){e._print_getter_setter("get",!1,t);})),e(AST_PrivateSetter,(function(e,t){e._print_getter_setter("set",!0,t);})),e(AST_PrivateGetter,(function(e,t){e._print_getter_setter("get",!0,t);})),e(AST_PrivateMethod,(function(e,t){var n;e.is_generator&&e.async?n="async*":e.is_generator?n="*":e.async&&(n="async"),e._print_getter_setter(n,!0,t);})),e(AST_ConciseMethod,(function(e,t){var n;e.is_generator&&e.async?n="async*":e.is_generator?n="*":e.async&&(n="async"),e._print_getter_setter(n,!1,t);})),AST_Symbol.DEFMETHOD("_do_print",(function(e){var t=this.definition();e.print_name(t?t.mangled_name||t.name:this.name);})),e(AST_Symbol,(function(e,t){e._do_print(t);})),e(AST_Hole,noop),e(AST_This,(function(e,t){t.print("this");})),e(AST_Super,(function(e,t){t.print("super");})),e(AST_Constant,(function(e,t){t.print(e.getValue());})),e(AST_String,(function(e,t){t.print_string(e.getValue(),e.quote,t.in_directive);})),e(AST_Number,(function(e,t){(t.option("keep_numbers")||t.use_asm)&&e.raw?t.print(e.raw):t.print(_(e.getValue()));})),e(AST_BigInt,(function(e,t){t.print(e.getValue()+"n");}));const s=/(<\s*\/\s*script)/i,u=(e,t)=>t.replace("/","\\/");function l(e,t){t.option("braces")?c(e,t):!e||e instanceof AST_EmptyStatement?t.force_semicolon():e.print(t);}function _(e){var t,n,o,i=e.toString(10).replace(/^0\./,".").replace("e+","e"),r=[i];return Math.floor(e)===e&&(e<0?r.push("-0x"+(-e).toString(16).toLowerCase()):r.push("0x"+e.toString(16).toLowerCase())),(t=/^\.0+/.exec(i))?(n=t[0].length,o=i.slice(n),r.push(o+"e-"+(o.length+n-1))):(t=/0+$/.exec(i))?(n=t[0].length,r.push(i.slice(0,-n)+"e"+n)):(t=/^(\d)\.(\d+)e(-?\d+)$/.exec(i))&&r.push(t[1]+t[2]+"e"+(t[3]-t[2].length)),function(e){for(var t=e[0],n=t.length,o=1;o<e.length;++o)e[o].length<n&&(n=(t=e[o]).length);return t}(r)}function c(e,t){!e||e instanceof AST_EmptyStatement?t.print("{}"):e instanceof AST_BlockStatement?e.print(t):t.with_block((function(){t.indent(),e.print(t),t.newline();}));}function f(e,t){e.forEach((function(e){e.DEFMETHOD("add_source_map",t);}));}e(AST_RegExp,(function(e,t){let{source:n,flags:o}=e.getValue();n=regexp_source_fix(n),o=o?sort_regexp_flags(o):"",n=n.replace(s,u),t.print(t.to_utf8(`/${n}/${o}`));const i=t.parent();i instanceof AST_Binary&&/^\w/.test(i.operator)&&i.left===e&&t.print(" ");})),f([AST_Node,AST_LabeledStatement,AST_Toplevel],noop),f([AST_Array,AST_BlockStatement,AST_Catch,AST_Class,AST_Constant,AST_Debugger,AST_Definitions,AST_Directive,AST_Finally,AST_Jump,AST_Lambda,AST_New,AST_Object,AST_StatementWithBody,AST_Symbol,AST_Switch,AST_SwitchBranch,AST_TemplateString,AST_TemplateSegment,AST_Try],(function(e){e.add_mapping(this.start);})),f([AST_ObjectGetter,AST_ObjectSetter],(function(e){e.add_mapping(this.start,this.key.name);})),f([AST_ObjectProperty],(function(e){e.add_mapping(this.start,this.key);}));}();const shallow_cmp=(e,t)=>null===e&&null===t||e.TYPE===t.TYPE&&e.shallow_cmp(t),equivalent_to=(e,t)=>{if(!shallow_cmp(e,t))return !1;const n=[e],o=[t],i=n.push.bind(n),r=o.push.bind(o);for(;n.length&&o.length;){const e=n.pop(),t=o.pop();if(!shallow_cmp(e,t))return !1;if(e._children_backwards(i),t._children_backwards(r),n.length!==o.length)return !1}return 0==n.length&&0==o.length},mkshallow=e=>{const t=Object.keys(e).map((t=>{if("eq"===e[t])return `this.${t} === other.${t}`;if("exist"===e[t])return `(this.${t} == null ? other.${t} == null : this.${t} === other.${t})`;throw new Error(`mkshallow: Unexpected instruction: ${e[t]}`)})).join(" && ");return new Function("other","return "+t)},pass_through=()=>!0;AST_Node.prototype.shallow_cmp=function(){throw new Error("did not find a shallow_cmp function for "+this.constructor.name)},AST_Debugger.prototype.shallow_cmp=pass_through,AST_Directive.prototype.shallow_cmp=mkshallow({value:"eq"}),AST_SimpleStatement.prototype.shallow_cmp=pass_through,AST_Block.prototype.shallow_cmp=pass_through,AST_EmptyStatement.prototype.shallow_cmp=pass_through,AST_LabeledStatement.prototype.shallow_cmp=mkshallow({"label.name":"eq"}),AST_Do.prototype.shallow_cmp=pass_through,AST_While.prototype.shallow_cmp=pass_through,AST_For.prototype.shallow_cmp=mkshallow({init:"exist",condition:"exist",step:"exist"}),AST_ForIn.prototype.shallow_cmp=pass_through,AST_ForOf.prototype.shallow_cmp=pass_through,AST_With.prototype.shallow_cmp=pass_through,AST_Toplevel.prototype.shallow_cmp=pass_through,AST_Expansion.prototype.shallow_cmp=pass_through,AST_Lambda.prototype.shallow_cmp=mkshallow({is_generator:"eq",async:"eq"}),AST_Destructuring.prototype.shallow_cmp=mkshallow({is_array:"eq"}),AST_PrefixedTemplateString.prototype.shallow_cmp=pass_through,AST_TemplateString.prototype.shallow_cmp=pass_through,AST_TemplateSegment.prototype.shallow_cmp=mkshallow({value:"eq"}),AST_Jump.prototype.shallow_cmp=pass_through,AST_LoopControl.prototype.shallow_cmp=pass_through,AST_Await.prototype.shallow_cmp=pass_through,AST_Yield.prototype.shallow_cmp=mkshallow({is_star:"eq"}),AST_If.prototype.shallow_cmp=mkshallow({alternative:"exist"}),AST_Switch.prototype.shallow_cmp=pass_through,AST_SwitchBranch.prototype.shallow_cmp=pass_through,AST_Try.prototype.shallow_cmp=mkshallow({bcatch:"exist",bfinally:"exist"}),AST_Catch.prototype.shallow_cmp=mkshallow({argname:"exist"}),AST_Finally.prototype.shallow_cmp=pass_through,AST_Definitions.prototype.shallow_cmp=pass_through,AST_VarDef.prototype.shallow_cmp=mkshallow({value:"exist"}),AST_NameMapping.prototype.shallow_cmp=pass_through,AST_Import.prototype.shallow_cmp=mkshallow({imported_name:"exist",imported_names:"exist"}),AST_ImportMeta.prototype.shallow_cmp=pass_through,AST_Export.prototype.shallow_cmp=mkshallow({exported_definition:"exist",exported_value:"exist",exported_names:"exist",module_name:"eq",is_default:"eq"}),AST_Call.prototype.shallow_cmp=pass_through,AST_Sequence.prototype.shallow_cmp=pass_through,AST_PropAccess.prototype.shallow_cmp=pass_through,AST_Chain.prototype.shallow_cmp=pass_through,AST_Dot.prototype.shallow_cmp=mkshallow({property:"eq"}),AST_Unary.prototype.shallow_cmp=mkshallow({operator:"eq"}),AST_Binary.prototype.shallow_cmp=mkshallow({operator:"eq"}),AST_Conditional.prototype.shallow_cmp=pass_through,AST_Array.prototype.shallow_cmp=pass_through,AST_Object.prototype.shallow_cmp=pass_through,AST_ObjectProperty.prototype.shallow_cmp=pass_through,AST_ObjectKeyVal.prototype.shallow_cmp=mkshallow({key:"eq"}),AST_ObjectSetter.prototype.shallow_cmp=mkshallow({static:"eq"}),AST_ObjectGetter.prototype.shallow_cmp=mkshallow({static:"eq"}),AST_ConciseMethod.prototype.shallow_cmp=mkshallow({static:"eq",is_generator:"eq",async:"eq"}),AST_Class.prototype.shallow_cmp=mkshallow({name:"exist",extends:"exist"}),AST_ClassProperty.prototype.shallow_cmp=mkshallow({static:"eq"}),AST_Symbol.prototype.shallow_cmp=mkshallow({name:"eq"}),AST_NewTarget.prototype.shallow_cmp=pass_through,AST_This.prototype.shallow_cmp=pass_through,AST_Super.prototype.shallow_cmp=pass_through,AST_String.prototype.shallow_cmp=mkshallow({value:"eq"}),AST_Number.prototype.shallow_cmp=mkshallow({value:"eq"}),AST_BigInt.prototype.shallow_cmp=mkshallow({value:"eq"}),AST_RegExp.prototype.shallow_cmp=function(e){return this.value.flags===e.value.flags&&this.value.source===e.value.source},AST_Atom.prototype.shallow_cmp=pass_through;let function_defs=null,unmangleable_names=null;class SymbolDef{constructor(e,t,n){this.name=t.name,this.orig=[t],this.init=n,this.eliminated=0,this.assignments=0,this.scope=e,this.replaced=0,this.global=!1,this.export=0,this.mangled_name=null,this.undeclared=!1,this.id=SymbolDef.next_id++,this.chained=!1,this.direct_access=!1,this.escaped=0,this.recursive_refs=0,this.references=[],this.should_replace=void 0,this.single_use=!1,this.fixed=!1,Object.seal(this);}fixed_value(){return !this.fixed||this.fixed instanceof AST_Node?this.fixed:this.fixed()}unmangleable(e){return e||(e={}),!!(function_defs&&function_defs.has(this.id)&&keep_name(e.keep_fnames,this.orig[0].name))||this.global&&!e.toplevel||1&this.export||this.undeclared||!e.eval&&this.scope.pinned()||(this.orig[0]instanceof AST_SymbolLambda||this.orig[0]instanceof AST_SymbolDefun)&&keep_name(e.keep_fnames,this.orig[0].name)||this.orig[0]instanceof AST_SymbolMethod||(this.orig[0]instanceof AST_SymbolClass||this.orig[0]instanceof AST_SymbolDefClass)&&keep_name(e.keep_classnames,this.orig[0].name)}mangle(e){const t=e.cache&&e.cache.props;if(this.global&&t&&t.has(this.name))this.mangled_name=t.get(this.name);else if(!this.mangled_name&&!this.unmangleable(e)){var n=this.scope,o=this.orig[0];e.ie8&&o instanceof AST_SymbolLambda&&(n=n.parent_scope);const i=redefined_catch_def(this);this.mangled_name=i?i.mangled_name||i.name:n.next_mangled(e,this),this.global&&t&&t.set(this.name,this.mangled_name);}}}function redefined_catch_def(e){if(e.orig[0]instanceof AST_SymbolCatch&&e.scope.is_block_scope())return e.scope.get_defun_scope().variables.get(e.name)}function find_scopes_visible_from(e){const t=new Set;for(const n of new Set(e))!function e(n){null==n||t.has(n)||(t.add(n),e(n.parent_scope));}(n);return [...t]}function next_mangled(e,t){var n=e.enclosed;e:for(;;){var o=base54(++e.cname);if(!RESERVED_WORDS.has(o)&&!(t.reserved.has(o)||unmangleable_names&&unmangleable_names.has(o))){for(let e=n.length;--e>=0;){const i=n[e];if(o==(i.mangled_name||i.unmangleable(t)&&i.name))continue e}return o}}}SymbolDef.next_id=1,AST_Scope.DEFMETHOD("figure_out_scope",(function(e,{parent_scope:t=null,toplevel:n=this}={}){if(e=defaults$1(e,{cache:null,ie8:!1,safari10:!1}),!(n instanceof AST_Toplevel))throw new Error("Invalid toplevel scope");var o=this.parent_scope=t,i=new Map,r=null,a=null,s=[],u=new TreeWalker(((t,n)=>{if(t.is_block_scope()){const i=o;t.block_scope=o=new AST_Scope(t),o._block_scope=!0;const r=t instanceof AST_Catch?i.parent_scope:i;if(o.init_scope_vars(r),o.uses_with=i.uses_with,o.uses_eval=i.uses_eval,e.safari10&&(t instanceof AST_For||t instanceof AST_ForIn)&&s.push(o),t instanceof AST_Switch){const e=o;o=i,t.expression.walk(u),o=e;for(let e=0;e<t.body.length;e++)t.body[e].walk(u);}else n();return o=i,!0}if(t instanceof AST_Destructuring){const e=a;return a=t,n(),a=e,!0}if(t instanceof AST_Scope){t.init_scope_vars(o);var _=o,c=r,f=i;return r=o=t,i=new Map,n(),o=_,r=c,i=f,!0}if(t instanceof AST_LabeledStatement){var p=t.label;if(i.has(p.name))throw new Error(string_template("Label {name} defined twice",p));return i.set(p.name,p),n(),i.delete(p.name),!0}if(t instanceof AST_With)for(var d=o;d;d=d.parent_scope)d.uses_with=!0;else {if(t instanceof AST_Symbol&&(t.scope=o),t instanceof AST_Label&&(t.thedef=t,t.references=[]),t instanceof AST_SymbolLambda)r.def_function(t,"arguments"==t.name?void 0:r);else if(t instanceof AST_SymbolDefun)l((t.scope=r.parent_scope.get_defun_scope()).def_function(t,r),1);else if(t instanceof AST_SymbolClass)l(r.def_variable(t,r),1);else if(t instanceof AST_SymbolImport)o.def_variable(t);else if(t instanceof AST_SymbolDefClass)l((t.scope=r.parent_scope).def_function(t,r),1);else if(t instanceof AST_SymbolVar||t instanceof AST_SymbolLet||t instanceof AST_SymbolConst||t instanceof AST_SymbolCatch){if((S=t instanceof AST_SymbolBlockDeclaration?o.def_variable(t,null):r.def_variable(t,"SymbolVar"==t.TYPE?null:void 0)).orig.every((e=>e===t||(t instanceof AST_SymbolBlockDeclaration?e instanceof AST_SymbolLambda:!(e instanceof AST_SymbolLet||e instanceof AST_SymbolConst))))||js_error(`"${t.name}" is redeclared`,t.start.file,t.start.line,t.start.col,t.start.pos),t instanceof AST_SymbolFunarg||l(S,2),r!==o){t.mark_enclosed();var S=o.find_variable(t);t.thedef!==S&&(t.thedef=S,t.reference());}}else if(t instanceof AST_LabelRef){var m=i.get(t.name);if(!m)throw new Error(string_template("Undefined label {name} [{line},{col}]",{name:t.name,line:t.start.line,col:t.start.col}));t.thedef=m;}o instanceof AST_Toplevel||!(t instanceof AST_Export||t instanceof AST_Import)||js_error(`"${t.TYPE}" statement may only appear at the top level`,t.start.file,t.start.line,t.start.col,t.start.pos);}}));function l(e,t){if(a){var n=0;do{t++;}while(u.parent(n++)!==a)}var o=u.parent(t);if(e.export=o instanceof AST_Export?1:0){var i=o.exported_definition;(i instanceof AST_Defun||i instanceof AST_DefClass)&&o.is_default&&(e.export=2);}}if(this.walk(u),this instanceof AST_Toplevel&&(this.globals=new Map),u=new TreeWalker((e=>{if(e instanceof AST_LoopControl&&e.label)return e.label.thedef.references.push(e),!0;if(e instanceof AST_SymbolRef){var t,o=e.name;if("eval"==o&&u.parent()instanceof AST_Call)for(var i=e.scope;i&&!i.uses_eval;i=i.parent_scope)i.uses_eval=!0;return u.parent()instanceof AST_NameMapping&&u.parent(1).module_name||!(t=e.scope.find_variable(o))?(t=n.def_global(e),e instanceof AST_SymbolExport&&(t.export=1)):t.scope instanceof AST_Lambda&&"arguments"==o&&(t.scope.uses_arguments=!0),e.thedef=t,e.reference(),!e.scope.is_block_scope()||t.orig[0]instanceof AST_SymbolBlockDeclaration||(e.scope=e.scope.get_defun_scope()),!0}var r;if(e instanceof AST_SymbolCatch&&(r=redefined_catch_def(e.definition())))for(i=e.scope;i&&(push_uniq(i.enclosed,r),i!==r.scope);)i=i.parent_scope;})),this.walk(u),(e.ie8||e.safari10)&&walk$3(this,(e=>{if(e instanceof AST_SymbolCatch){var t=e.name,o=e.thedef.references,i=e.scope.get_defun_scope(),r=i.find_variable(t)||n.globals.get(t)||i.def_variable(e);return o.forEach((function(e){e.thedef=r,e.reference();})),e.thedef=r,e.reference(),!0}})),e.safari10)for(const e of s)e.parent_scope.variables.forEach((function(t){push_uniq(e.enclosed,t);}));})),AST_Toplevel.DEFMETHOD("def_global",(function(e){var t=this.globals,n=e.name;if(t.has(n))return t.get(n);var o=new SymbolDef(this,e);return o.undeclared=!0,o.global=!0,t.set(n,o),o})),AST_Scope.DEFMETHOD("init_scope_vars",(function(e){this.variables=new Map,this.functions=new Map,this.uses_with=!1,this.uses_eval=!1,this.parent_scope=e,this.enclosed=[],this.cname=-1;})),AST_Scope.DEFMETHOD("conflicting_def",(function(e){return this.enclosed.find((t=>t.name===e))||this.variables.has(e)||this.parent_scope&&this.parent_scope.conflicting_def(e)})),AST_Scope.DEFMETHOD("conflicting_def_shallow",(function(e){return this.enclosed.find((t=>t.name===e))||this.variables.has(e)})),AST_Scope.DEFMETHOD("add_child_scope",(function(e){if(e.parent_scope===this)return;e.parent_scope=this;const t=(()=>{const e=[];let t=this;do{e.push(t);}while(t=t.parent_scope);return e.reverse(),e})(),n=new Set(e.enclosed),o=[];for(const e of t){o.forEach((t=>push_uniq(e.enclosed,t)));for(const t of e.variables.values())n.has(t)&&(push_uniq(o,t),push_uniq(e.enclosed,t));}})),AST_Scope.DEFMETHOD("create_symbol",(function(e,{source:t,tentative_name:n,scope:o,conflict_scopes:i=[o],init:r=null}={}){let a;if(i=find_scopes_visible_from(i),n){n=a=n.replace(/(?:^[^a-z_$]|[^a-z0-9_$])/gi,"_");let e=0;for(;i.find((e=>e.conflicting_def_shallow(a)));)a=n+"$"+e++;}if(!a)throw new Error("No symbol name could be generated in create_symbol()");const s=make_node(e,t,{name:a,scope:o});return this.def_variable(s,r||null),s.mark_enclosed(),s})),AST_Node.DEFMETHOD("is_block_scope",return_false),AST_Class.DEFMETHOD("is_block_scope",return_false),AST_Lambda.DEFMETHOD("is_block_scope",return_false),AST_Toplevel.DEFMETHOD("is_block_scope",return_false),AST_SwitchBranch.DEFMETHOD("is_block_scope",return_false),AST_Block.DEFMETHOD("is_block_scope",return_true),AST_Scope.DEFMETHOD("is_block_scope",(function(){return this._block_scope||!1})),AST_IterationStatement.DEFMETHOD("is_block_scope",return_true),AST_Lambda.DEFMETHOD("init_scope_vars",(function(){AST_Scope.prototype.init_scope_vars.apply(this,arguments),this.uses_arguments=!1,this.def_variable(new AST_SymbolFunarg({name:"arguments",start:this.start,end:this.end}));})),AST_Arrow.DEFMETHOD("init_scope_vars",(function(){AST_Scope.prototype.init_scope_vars.apply(this,arguments),this.uses_arguments=!1;})),AST_Symbol.DEFMETHOD("mark_enclosed",(function(){for(var e=this.definition(),t=this.scope;t&&(push_uniq(t.enclosed,e),t!==e.scope);)t=t.parent_scope;})),AST_Symbol.DEFMETHOD("reference",(function(){this.definition().references.push(this),this.mark_enclosed();})),AST_Scope.DEFMETHOD("find_variable",(function(e){return e instanceof AST_Symbol&&(e=e.name),this.variables.get(e)||this.parent_scope&&this.parent_scope.find_variable(e)})),AST_Scope.DEFMETHOD("def_function",(function(e,t){var n=this.def_variable(e,t);return (!n.init||n.init instanceof AST_Defun)&&(n.init=t),this.functions.set(e.name,n),n})),AST_Scope.DEFMETHOD("def_variable",(function(e,t){var n=this.variables.get(e.name);return n?(n.orig.push(e),n.init&&(n.scope!==e.scope||n.init instanceof AST_Function)&&(n.init=t)):(n=new SymbolDef(this,e,t),this.variables.set(e.name,n),n.global=!this.parent_scope),e.thedef=n})),AST_Scope.DEFMETHOD("next_mangled",(function(e){return next_mangled(this,e)})),AST_Toplevel.DEFMETHOD("next_mangled",(function(e){let t;const n=this.mangled_names;do{t=next_mangled(this,e);}while(n.has(t));return t})),AST_Function.DEFMETHOD("next_mangled",(function(e,t){for(var n=t.orig[0]instanceof AST_SymbolFunarg&&this.name&&this.name.definition(),o=n?n.mangled_name||n.name:null;;){var i=next_mangled(this,e);if(!o||o!=i)return i}})),AST_Symbol.DEFMETHOD("unmangleable",(function(e){var t=this.definition();return !t||t.unmangleable(e)})),AST_Label.DEFMETHOD("unmangleable",return_false),AST_Symbol.DEFMETHOD("unreferenced",(function(){return !this.definition().references.length&&!this.scope.pinned()})),AST_Symbol.DEFMETHOD("definition",(function(){return this.thedef})),AST_Symbol.DEFMETHOD("global",(function(){return this.thedef.global})),AST_Toplevel.DEFMETHOD("_default_mangler_options",(function(e){return (e=defaults$1(e,{eval:!1,ie8:!1,keep_classnames:!1,keep_fnames:!1,module:!1,reserved:[],toplevel:!1})).module&&(e.toplevel=!0),Array.isArray(e.reserved)||e.reserved instanceof Set||(e.reserved=[]),e.reserved=new Set(e.reserved),e.reserved.add("arguments"),e})),AST_Toplevel.DEFMETHOD("mangle_names",(function(e){e=this._default_mangler_options(e);var t=-1,n=[];e.keep_fnames&&(function_defs=new Set);const o=this.mangled_names=new Set;e.cache&&(this.globals.forEach(r),e.cache.props&&e.cache.props.forEach((function(e){o.add(e);})));var i=new TreeWalker((function(o,i){if(o instanceof AST_LabeledStatement){var a=t;return i(),t=a,!0}if(o instanceof AST_Scope)o.variables.forEach(r);else if(o.is_block_scope())o.block_scope.variables.forEach(r);else if(function_defs&&o instanceof AST_VarDef&&o.value instanceof AST_Lambda&&!o.value.name&&keep_name(e.keep_fnames,o.name.name))function_defs.add(o.name.definition().id);else {if(o instanceof AST_Label){let e;do{e=base54(++t);}while(RESERVED_WORDS.has(e));return o.mangled_name=e,!0}!e.ie8&&!e.safari10&&o instanceof AST_SymbolCatch&&n.push(o.definition());}}));function r(t){!(e.reserved.has(t.name)||1&t.export)&&n.push(t);}this.walk(i),(e.keep_fnames||e.keep_classnames)&&(unmangleable_names=new Set,n.forEach((t=>{t.name.length<6&&t.unmangleable(e)&&unmangleable_names.add(t.name);}))),n.forEach((t=>{t.mangle(e);})),function_defs=null,unmangleable_names=null;})),AST_Toplevel.DEFMETHOD("find_colliding_names",(function(e){const t=e.cache&&e.cache.props,n=new Set;return e.reserved.forEach(o),this.globals.forEach(i),this.walk(new TreeWalker((function(e){e instanceof AST_Scope&&e.variables.forEach(i),e instanceof AST_SymbolCatch&&i(e.definition());}))),n;function o(e){n.add(e);}function i(n){var i=n.name;if(n.global&&t&&t.has(i))i=t.get(i);else if(!n.unmangleable(e))return;o(i);}})),AST_Toplevel.DEFMETHOD("expand_names",(function(e){base54.reset(),base54.sort(),e=this._default_mangler_options(e);var t=this.find_colliding_names(e),n=0;function o(o){if(o.global&&e.cache)return;if(o.unmangleable(e))return;if(e.reserved.has(o.name))return;const i=redefined_catch_def(o),r=o.name=i?i.name:function(){var e;do{e=base54(n++);}while(t.has(e)||RESERVED_WORDS.has(e));return e}();o.orig.forEach((function(e){e.name=r;})),o.references.forEach((function(e){e.name=r;}));}this.globals.forEach(o),this.walk(new TreeWalker((function(e){e instanceof AST_Scope&&e.variables.forEach(o),e instanceof AST_SymbolCatch&&o(e.definition());})));})),AST_Node.DEFMETHOD("tail_node",return_this),AST_Sequence.DEFMETHOD("tail_node",(function(){return this.expressions[this.expressions.length-1]})),AST_Toplevel.DEFMETHOD("compute_char_frequency",(function(e){e=this._default_mangler_options(e);try{AST_Node.prototype.print=function(n,o){this._print(n,o),this instanceof AST_Symbol&&!this.unmangleable(e)?base54.consider(this.name,-1):e.properties&&(this instanceof AST_DotHash?base54.consider("#"+this.property,-1):this instanceof AST_Dot?base54.consider(this.property,-1):this instanceof AST_Sub&&t(this.property));},base54.consider(this.print_to_string(),1);}finally{AST_Node.prototype.print=AST_Node.prototype._print;}function t(e){e instanceof AST_String?base54.consider(e.value,-1):e instanceof AST_Conditional?(t(e.consequent),t(e.alternative)):e instanceof AST_Sequence&&t(e.tail_node());}base54.sort();}));const base54=(()=>{const e="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_".split(""),t="0123456789".split("");let n,o;function i(){o=new Map,e.forEach((function(e){o.set(e,0);})),t.forEach((function(e){o.set(e,0);}));}function r(e,t){return o.get(t)-o.get(e)}function a(e){var t="",o=54;e++;do{e--,t+=n[e%o],e=Math.floor(e/o),o=64;}while(e>0);return t}return a.consider=function(e,t){for(var n=e.length;--n>=0;)o.set(e[n],o.get(e[n])+t);},a.sort=function(){n=mergeSort(e,r).concat(mergeSort(t,r));},a.reset=i,i(),a})();let mangle_options;AST_Node.prototype.size=function(e,t){mangle_options=e&&e.mangle_options;let n=0;return walk_parent(this,((e,t)=>{if(n+=e._size(t),e instanceof AST_Arrow&&e.is_braceless())return n+=e.body[0].value._size(t),!0}),t||e&&e.stack),mangle_options=void 0,n},AST_Node.prototype._size=()=>0,AST_Debugger.prototype._size=()=>8,AST_Directive.prototype._size=function(){return 2+this.value.length};const list_overhead=e=>e.length&&e.length-1;AST_Block.prototype._size=function(){return 2+list_overhead(this.body)},AST_Toplevel.prototype._size=function(){return list_overhead(this.body)},AST_EmptyStatement.prototype._size=()=>1,AST_LabeledStatement.prototype._size=()=>2,AST_Do.prototype._size=()=>9,AST_While.prototype._size=()=>7,AST_For.prototype._size=()=>8,AST_ForIn.prototype._size=()=>8,AST_With.prototype._size=()=>6,AST_Expansion.prototype._size=()=>3;const lambda_modifiers=e=>(e.is_generator?1:0)+(e.async?6:0);AST_Accessor.prototype._size=function(){return lambda_modifiers(this)+4+list_overhead(this.argnames)+list_overhead(this.body)},AST_Function.prototype._size=function(e){return 2*!!first_in_statement(e)+lambda_modifiers(this)+12+list_overhead(this.argnames)+list_overhead(this.body)},AST_Defun.prototype._size=function(){return lambda_modifiers(this)+13+list_overhead(this.argnames)+list_overhead(this.body)},AST_Arrow.prototype._size=function(){let e=2+list_overhead(this.argnames);1===this.argnames.length&&this.argnames[0]instanceof AST_Symbol||(e+=2);const t=this.is_braceless()?0:list_overhead(this.body)+2;return lambda_modifiers(this)+e+t},AST_Destructuring.prototype._size=()=>2,AST_TemplateString.prototype._size=function(){return 2+3*Math.floor(this.segments.length/2)},AST_TemplateSegment.prototype._size=function(){return this.value.length},AST_Return.prototype._size=function(){return this.value?7:6},AST_Throw.prototype._size=()=>6,AST_Break.prototype._size=function(){return this.label?6:5},AST_Continue.prototype._size=function(){return this.label?9:8},AST_If.prototype._size=()=>4,AST_Switch.prototype._size=function(){return 8+list_overhead(this.body)},AST_Case.prototype._size=function(){return 5+list_overhead(this.body)},AST_Default.prototype._size=function(){return 8+list_overhead(this.body)},AST_Try.prototype._size=function(){return 3+list_overhead(this.body)},AST_Catch.prototype._size=function(){let e=7+list_overhead(this.body);return this.argname&&(e+=2),e},AST_Finally.prototype._size=function(){return 7+list_overhead(this.body)};const def_size=(e,t)=>e+list_overhead(t.definitions);AST_Var.prototype._size=function(){return def_size(4,this)},AST_Let.prototype._size=function(){return def_size(4,this)},AST_Const.prototype._size=function(){return def_size(6,this)},AST_VarDef.prototype._size=function(){return this.value?1:0},AST_NameMapping.prototype._size=function(){return this.name?4:0},AST_Import.prototype._size=function(){let e=6;return this.imported_name&&(e+=1),(this.imported_name||this.imported_names)&&(e+=5),this.imported_names&&(e+=2+list_overhead(this.imported_names)),e},AST_ImportMeta.prototype._size=()=>11,AST_Export.prototype._size=function(){let e=7+(this.is_default?8:0);return this.exported_value&&(e+=this.exported_value._size()),this.exported_names&&(e+=2+list_overhead(this.exported_names)),this.module_name&&(e+=5),e},AST_Call.prototype._size=function(){return this.optional?4+list_overhead(this.args):2+list_overhead(this.args)},AST_New.prototype._size=function(){return 6+list_overhead(this.args)},AST_Sequence.prototype._size=function(){return list_overhead(this.expressions)},AST_Dot.prototype._size=function(){return this.optional?this.property.length+2:this.property.length+1},AST_DotHash.prototype._size=function(){return this.optional?this.property.length+3:this.property.length+2},AST_Sub.prototype._size=function(){return this.optional?4:2},AST_Unary.prototype._size=function(){return "typeof"===this.operator?7:"void"===this.operator?5:this.operator.length},AST_Binary.prototype._size=function(e){if("in"===this.operator)return 4;let t=this.operator.length;return ("+"===this.operator||"-"===this.operator)&&this.right instanceof AST_Unary&&this.right.operator===this.operator&&(t+=1),this.needs_parens(e)&&(t+=2),t},AST_Conditional.prototype._size=()=>3,AST_Array.prototype._size=function(){return 2+list_overhead(this.elements)},AST_Object.prototype._size=function(e){let t=2;return first_in_statement(e)&&(t+=2),t+list_overhead(this.properties)};const key_size=e=>"string"==typeof e?e.length:0;AST_ObjectKeyVal.prototype._size=function(){return key_size(this.key)+1};const static_size=e=>e?7:0;AST_ObjectGetter.prototype._size=function(){return 5+static_size(this.static)+key_size(this.key)},AST_ObjectSetter.prototype._size=function(){return 5+static_size(this.static)+key_size(this.key)},AST_ConciseMethod.prototype._size=function(){return static_size(this.static)+key_size(this.key)+lambda_modifiers(this)},AST_PrivateMethod.prototype._size=function(){return AST_ConciseMethod.prototype._size.call(this)+1},AST_PrivateGetter.prototype._size=AST_PrivateSetter.prototype._size=function(){return AST_ConciseMethod.prototype._size.call(this)+4},AST_Class.prototype._size=function(){return (this.name?8:7)+(this.extends?8:0)},AST_ClassProperty.prototype._size=function(){return static_size(this.static)+("string"==typeof this.key?this.key.length+2:0)+(this.value?1:0)},AST_ClassPrivateProperty.prototype._size=function(){return AST_ClassProperty.prototype._size.call(this)+1},AST_Symbol.prototype._size=function(){return !mangle_options||this.definition().unmangleable(mangle_options)?this.name.length:1},AST_SymbolClassProperty.prototype._size=function(){return this.name.length},AST_SymbolRef.prototype._size=AST_SymbolDeclaration.prototype._size=function(){const{name:e,thedef:t}=this;return t&&t.global?e.length:"arguments"===e?9:AST_Symbol.prototype._size.call(this)},AST_NewTarget.prototype._size=()=>10,AST_SymbolImportForeign.prototype._size=function(){return this.name.length},AST_SymbolExportForeign.prototype._size=function(){return this.name.length},AST_This.prototype._size=()=>4,AST_Super.prototype._size=()=>5,AST_String.prototype._size=function(){return this.value.length+2},AST_Number.prototype._size=function(){const{value:e}=this;return 0===e?1:e>0&&Math.floor(e)===e?Math.floor(Math.log10(e)+1):e.toString().length},AST_BigInt.prototype._size=function(){return this.value.length},AST_RegExp.prototype._size=function(){return this.value.toString().length},AST_Null.prototype._size=()=>4,AST_NaN.prototype._size=()=>3,AST_Undefined.prototype._size=()=>6,AST_Hole.prototype._size=()=>0,AST_Infinity.prototype._size=()=>8,AST_True.prototype._size=()=>4,AST_False.prototype._size=()=>5,AST_Await.prototype._size=()=>6,AST_Yield.prototype._size=()=>6;const TOP=1024,has_flag=(e,t)=>e.flags&t,set_flag=(e,t)=>{e.flags|=t;},clear_flag=(e,t)=>{e.flags&=~t;};class Compressor extends TreeWalker{constructor(e,{false_by_default:t=!1,mangle_options:n=!1}){super(),void 0===e.defaults||e.defaults||(t=!0),this.options=defaults$1(e,{arguments:!1,arrows:!t,booleans:!t,booleans_as_integers:!1,collapse_vars:!t,comparisons:!t,computed_props:!t,conditionals:!t,dead_code:!t,defaults:!0,directives:!t,drop_console:!1,drop_debugger:!t,ecma:5,evaluate:!t,expression:!1,global_defs:!1,hoist_funs:!1,hoist_props:!t,hoist_vars:!1,ie8:!1,if_return:!t,inline:!t,join_vars:!t,keep_classnames:!1,keep_fargs:!0,keep_fnames:!1,keep_infinity:!1,loops:!t,module:!1,negate_iife:!t,passes:1,properties:!t,pure_getters:!t&&"strict",pure_funcs:null,reduce_funcs:null,reduce_vars:!t,sequences:!t,side_effects:!t,switches:!t,top_retain:null,toplevel:!(!e||!e.top_retain),typeofs:!t,unsafe:!1,unsafe_arrows:!1,unsafe_comps:!1,unsafe_Function:!1,unsafe_math:!1,unsafe_symbols:!1,unsafe_methods:!1,unsafe_proto:!1,unsafe_regexp:!1,unsafe_undefined:!1,unused:!t,warnings:!1},!0);var o=this.options.global_defs;if("object"==typeof o)for(var i in o)"@"===i[0]&&HOP(o,i)&&(o[i.slice(1)]=parse$5(o[i],{expression:!0}));!0===this.options.inline&&(this.options.inline=3);var r=this.options.pure_funcs;this.pure_funcs="function"==typeof r?r:r?function(e){return !r.includes(e.expression.print_to_string())}:return_true;var a=this.options.top_retain;a instanceof RegExp?this.top_retain=function(e){return a.test(e.name)}:"function"==typeof a?this.top_retain=a:a&&("string"==typeof a&&(a=a.split(/,/)),this.top_retain=function(e){return a.includes(e.name)}),this.options.module&&(this.directives["use strict"]=!0,this.options.toplevel=!0);var s=this.options.toplevel;this.toplevel="string"==typeof s?{funcs:/funcs/.test(s),vars:/vars/.test(s)}:{funcs:s,vars:s};var u=this.options.sequences;this.sequences_limit=1==u?800:0|u,this.evaluated_regexps=new Map,this._toplevel=void 0,this.mangle_options=n;}option(e){return this.options[e]}exposed(e){if(e.export)return !0;if(e.global)for(var t=0,n=e.orig.length;t<n;t++)if(!this.toplevel[e.orig[t]instanceof AST_SymbolDefun?"funcs":"vars"])return !0;return !1}in_boolean_context(){if(!this.option("booleans"))return !1;for(var e,t=this.self(),n=0;e=this.parent(n);n++){if(e instanceof AST_SimpleStatement||e instanceof AST_Conditional&&e.condition===t||e instanceof AST_DWLoop&&e.condition===t||e instanceof AST_For&&e.condition===t||e instanceof AST_If&&e.condition===t||e instanceof AST_UnaryPrefix&&"!"==e.operator&&e.expression===t)return !0;if(!(e instanceof AST_Binary&&("&&"==e.operator||"||"==e.operator||"??"==e.operator)||e instanceof AST_Conditional||e.tail_node()===t))return !1;t=e;}}get_toplevel(){return this._toplevel}compress(e){e=e.resolve_defines(this),this._toplevel=e,this.option("expression")&&this._toplevel.process_expression(!0);for(var t=+this.options.passes||1,n=1/0,o=!1,i={ie8:this.option("ie8")},r=0;r<t;r++)if(this._toplevel.figure_out_scope(i),0===r&&this.option("drop_console")&&(this._toplevel=this._toplevel.drop_console()),(r>0||this.option("reduce_vars"))&&this._toplevel.reset_opt_flags(this),this._toplevel=this._toplevel.transform(this),t>1){let e=0;if(walk$3(this._toplevel,(()=>{e++;})),e<n)n=e,o=!1;else {if(o)break;o=!0;}}return this.option("expression")&&this._toplevel.process_expression(!1),e=this._toplevel,this._toplevel=void 0,e}before(e,t){if(has_flag(e,256))return e;var n=!1;e instanceof AST_Scope&&(e=(e=e.hoist_properties(this)).hoist_declarations(this),n=!0),t(e,this),t(e,this);var o=e.optimize(this);return n&&o instanceof AST_Scope&&(o.drop_unused(this),t(o,this)),o===e&&set_flag(o,256),o}}function def_optimize(e,t){e.DEFMETHOD("optimize",(function(e){var n=this;if(has_flag(n,512))return n;if(e.has_directive("use asm"))return n;var o=t(n,e);return set_flag(o,512),o}));}function read_property(e,t){if(!((t=get_value(t))instanceof AST_Node)){var n;if(e instanceof AST_Array){var o=e.elements;if("length"==t)return make_node_from_constant(o.length,e);"number"==typeof t&&t in o&&(n=o[t]);}else if(e instanceof AST_Object){t=""+t;for(var i=e.properties,r=i.length;--r>=0;){if(!(i[r]instanceof AST_ObjectKeyVal))return;n||i[r].key!==t||(n=i[r].value);}}return n instanceof AST_SymbolRef&&n.fixed_value()||n}}function is_modified(e,t,n,o,i,r){var a=t.parent(i),s=is_lhs(n,a);if(s)return s;if(!r&&a instanceof AST_Call&&a.expression===n&&!(o instanceof AST_Arrow)&&!(o instanceof AST_Class)&&!a.is_expr_pure(e)&&(!(o instanceof AST_Function)||!(a instanceof AST_New)&&o.contains_this()))return !0;if(a instanceof AST_Array)return is_modified(e,t,a,a,i+1);if(a instanceof AST_ObjectKeyVal&&n===a.value){var u=t.parent(i+1);return is_modified(e,t,u,u,i+2)}if(a instanceof AST_PropAccess&&a.expression===n){var l=read_property(o,a.property);return !r&&is_modified(e,t,a,l,i+1)}}function is_func_expr(e){return e instanceof AST_Arrow||e instanceof AST_Function}function is_lhs_read_only(e){if(e instanceof AST_This)return !0;if(e instanceof AST_SymbolRef)return e.definition().orig[0]instanceof AST_SymbolLambda;if(e instanceof AST_PropAccess){if((e=e.expression)instanceof AST_SymbolRef){if(e.is_immutable())return !1;e=e.fixed_value();}return !e||!(e instanceof AST_RegExp)&&(e instanceof AST_Constant||is_lhs_read_only(e))}return !1}function is_ref_of(e,t){if(!(e instanceof AST_SymbolRef))return !1;for(var n=e.definition().orig,o=n.length;--o>=0;)if(n[o]instanceof t)return !0}function find_scope(e){for(let t=0;;t++){const n=e.parent(t);if(n instanceof AST_Toplevel)return n;if(n instanceof AST_Lambda)return n;if(n.block_scope)return n.block_scope}}function find_variable(e,t){for(var n,o=0;(n=e.parent(o++))&&!(n instanceof AST_Scope);)if(n instanceof AST_Catch&&n.argname){n=n.argname.definition().scope;break}return n.find_variable(t)}function make_sequence(e,t){if(1==t.length)return t[0];if(0==t.length)throw new Error("trying to create a sequence with length zero!");return make_node(AST_Sequence,e,{expressions:t.reduce(merge_sequence,[])})}function make_node_from_constant(e,t){switch(typeof e){case"string":return make_node(AST_String,t,{value:e});case"number":return isNaN(e)?make_node(AST_NaN,t):isFinite(e)?1/e<0?make_node(AST_UnaryPrefix,t,{operator:"-",expression:make_node(AST_Number,t,{value:-e})}):make_node(AST_Number,t,{value:e}):e<0?make_node(AST_UnaryPrefix,t,{operator:"-",expression:make_node(AST_Infinity,t)}):make_node(AST_Infinity,t);case"boolean":return make_node(e?AST_True:AST_False,t);case"undefined":return make_node(AST_Undefined,t);default:if(null===e)return make_node(AST_Null,t,{value:null});if(e instanceof RegExp)return make_node(AST_RegExp,t,{value:{source:regexp_source_fix(e.source),flags:e.flags}});throw new Error(string_template("Can't handle constant of type: {type}",{type:typeof e}))}}function maintain_this_binding(e,t,n){return e instanceof AST_UnaryPrefix&&"delete"==e.operator||e instanceof AST_Call&&e.expression===t&&(n instanceof AST_PropAccess||n instanceof AST_SymbolRef&&"eval"==n.name)?make_sequence(t,[make_node(AST_Number,t,{value:0}),n]):n}function merge_sequence(e,t){return t instanceof AST_Sequence?e.push(...t.expressions):e.push(t),e}function as_statement_array(e){if(null===e)return [];if(e instanceof AST_BlockStatement)return e.body;if(e instanceof AST_EmptyStatement)return [];if(e instanceof AST_Statement)return [e];throw new Error("Can't convert thing to statement array")}function is_empty(e){return null===e||e instanceof AST_EmptyStatement||e instanceof AST_BlockStatement&&0==e.body.length}function can_be_evicted_from_block(e){return !(e instanceof AST_DefClass||e instanceof AST_Defun||e instanceof AST_Let||e instanceof AST_Const||e instanceof AST_Export||e instanceof AST_Import)}function loop_body(e){return e instanceof AST_IterationStatement&&e.body instanceof AST_BlockStatement?e.body:e}function is_iife_call(e){return "Call"==e.TYPE&&(e.expression instanceof AST_Function||is_iife_call(e.expression))}function is_undeclared_ref(e){return e instanceof AST_SymbolRef&&e.definition().undeclared}def_optimize(AST_Node,(function(e){return e})),AST_Toplevel.DEFMETHOD("drop_console",(function(){return this.transform(new TreeTransformer((function(e){if("Call"==e.TYPE){var t=e.expression;if(t instanceof AST_PropAccess){for(var n=t.expression;n.expression;)n=n.expression;if(is_undeclared_ref(n)&&"console"==n.name)return make_node(AST_Undefined,e)}}})))})),AST_Node.DEFMETHOD("equivalent_to",(function(e){return equivalent_to(this,e)})),AST_Scope.DEFMETHOD("process_expression",(function(e,t){var n=this,o=new TreeTransformer((function(i){if(e&&i instanceof AST_SimpleStatement)return make_node(AST_Return,i,{value:i.body});if(!e&&i instanceof AST_Return){if(t){var r=i.value&&i.value.drop_side_effect_free(t,!0);return r?make_node(AST_SimpleStatement,i,{body:r}):make_node(AST_EmptyStatement,i)}return make_node(AST_SimpleStatement,i,{body:i.value||make_node(AST_UnaryPrefix,i,{operator:"void",expression:make_node(AST_Number,i,{value:0})})})}if(i instanceof AST_Class||i instanceof AST_Lambda&&i!==n)return i;if(i instanceof AST_Block){var a=i.body.length-1;a>=0&&(i.body[a]=i.body[a].transform(o));}else i instanceof AST_If?(i.body=i.body.transform(o),i.alternative&&(i.alternative=i.alternative.transform(o))):i instanceof AST_With&&(i.body=i.body.transform(o));return i}));n.transform(o);})),function(e){function t(e,t){t.assignments=0,t.chained=!1,t.direct_access=!1,t.escaped=0,t.recursive_refs=0,t.references=[],t.single_use=void 0,t.scope.pinned()?t.fixed=!1:t.orig[0]instanceof AST_SymbolConst||!e.exposed(t)?t.fixed=t.init:t.fixed=!1;}function n(e,n,o){o.variables.forEach((function(o){t(n,o),null===o.fixed?(e.defs_to_safe_ids.set(o.id,e.safe_ids),a(e,o,!0)):o.fixed&&(e.loop_ids.set(o.id,e.in_loop),a(e,o,!0));}));}function o(e,n){n.block_scope&&n.block_scope.variables.forEach((n=>{t(e,n);}));}function i(e){e.safe_ids=Object.create(e.safe_ids);}function r(e){e.safe_ids=Object.getPrototypeOf(e.safe_ids);}function a(e,t,n){e.safe_ids[t.id]=n;}function s(e,t){if("m"==t.single_use)return !1;if(e.safe_ids[t.id]){if(null==t.fixed){var n=t.orig[0];if(n instanceof AST_SymbolFunarg||"arguments"==n.name)return !1;t.fixed=make_node(AST_Undefined,n);}return !0}return t.fixed instanceof AST_Defun}function u(e,t,n,o){if(void 0===t.fixed)return !0;let i;return null===t.fixed&&(i=e.defs_to_safe_ids.get(t.id))?(i[t.id]=!1,e.defs_to_safe_ids.delete(t.id),!0):!!HOP(e.safe_ids,t.id)&&!!s(e,t)&&!1!==t.fixed&&!(null!=t.fixed&&(!o||t.references.length>t.assignments))&&(t.fixed instanceof AST_Defun?o instanceof AST_Node&&t.fixed.parent_scope===n:t.orig.every((e=>!(e instanceof AST_SymbolConst||e instanceof AST_SymbolDefun||e instanceof AST_SymbolLambda))))}function l(e,t,n,o,i,r=0,a=1){var s=e.parent(r);if(i){if(i.is_constant())return;if(i instanceof AST_ClassExpression)return}if(s instanceof AST_Assign&&("="===s.operator||s.logical)&&o===s.right||s instanceof AST_Call&&(o!==s.expression||s instanceof AST_New)||s instanceof AST_Exit&&o===s.value&&o.scope!==t.scope||s instanceof AST_VarDef&&o===s.value||s instanceof AST_Yield&&o===s.value&&o.scope!==t.scope)return !(a>1)||i&&i.is_constant_expression(n)||(a=1),void((!t.escaped||t.escaped>a)&&(t.escaped=a));if(s instanceof AST_Array||s instanceof AST_Await||s instanceof AST_Binary&&lazy_op.has(s.operator)||s instanceof AST_Conditional&&o!==s.condition||s instanceof AST_Expansion||s instanceof AST_Sequence&&o===s.tail_node())l(e,t,n,s,s,r+1,a);else if(s instanceof AST_ObjectKeyVal&&o===s.value){var u=e.parent(r+1);l(e,t,n,u,u,r+2,a);}else if(s instanceof AST_PropAccess&&o===s.expression&&(l(e,t,n,s,i=read_property(i,s.property),r+1,a+1),i))return;r>0||s instanceof AST_Sequence&&o!==s.tail_node()||s instanceof AST_SimpleStatement||(t.direct_access=!0);}e(AST_Node,noop);const _=e=>walk$3(e,(e=>{if(e instanceof AST_Symbol){var t=e.definition();t&&(e instanceof AST_SymbolRef&&t.references.push(e),t.fixed=!1);}}));e(AST_Accessor,(function(e,t,o){return i(e),n(e,o,this),t(),r(e),!0})),e(AST_Assign,(function(e,t,n){var o=this;if(o.left instanceof AST_Destructuring)return void _(o.left);const s=()=>{if(o.logical)return o.left.walk(e),i(e),o.right.walk(e),r(e),!0};var c=o.left;if(!(c instanceof AST_SymbolRef))return s();var f=c.definition(),p=u(e,f,c.scope,o.right);if(f.assignments++,!p)return s();var d=f.fixed;if(!d&&"="!=o.operator&&!o.logical)return s();var S="="==o.operator,m=S?o.right:o;return is_modified(n,e,o,m,0)?s():(f.references.push(c),o.logical||(S||(f.chained=!0),f.fixed=S?function(){return o.right}:function(){return make_node(AST_Binary,o,{operator:o.operator.slice(0,-1),left:d instanceof AST_Node?d:d(),right:o.right})}),o.logical?(a(e,f,!1),i(e),o.right.walk(e),r(e),!0):(a(e,f,!1),o.right.walk(e),a(e,f,!0),l(e,f,c.scope,o,m,0,1),!0))})),e(AST_Binary,(function(e){if(lazy_op.has(this.operator))return this.left.walk(e),i(e),this.right.walk(e),r(e),!0})),e(AST_Block,(function(e,t,n){o(n,this);})),e(AST_Case,(function(e){return i(e),this.expression.walk(e),r(e),i(e),walk_body(this,e),r(e),!0})),e(AST_Class,(function(e,t){return clear_flag(this,16),i(e),t(),r(e),!0})),e(AST_Conditional,(function(e){return this.condition.walk(e),i(e),this.consequent.walk(e),r(e),i(e),this.alternative.walk(e),r(e),!0})),e(AST_Chain,(function(e,t){const n=e.safe_ids;return t(),e.safe_ids=n,!0})),e(AST_Call,(function(e){this.expression.walk(e),this.optional&&i(e);for(const t of this.args)t.walk(e);return !0})),e(AST_PropAccess,(function(e){if(this.optional)return this.expression.walk(e),i(e),this.property instanceof AST_Node&&this.property.walk(e),!0})),e(AST_Default,(function(e,t){return i(e),t(),r(e),!0})),e(AST_Lambda,(function(e,t,o){return clear_flag(this,16),i(e),n(e,o,this),this.uses_arguments?(t(),void r(e)):(!this.name&&(s=e.parent())instanceof AST_Call&&s.expression===this&&!s.args.some((e=>e instanceof AST_Expansion))&&this.argnames.every((e=>e instanceof AST_Symbol))&&this.argnames.forEach(((t,n)=>{if(t.definition){var o=t.definition();o.orig.length>1||(void 0!==o.fixed||this.uses_arguments&&!e.has_directive("use strict")?o.fixed=!1:(o.fixed=function(){return s.args[n]||make_node(AST_Undefined,s)},e.loop_ids.set(o.id,e.in_loop),a(e,o,!0)));}})),t(),r(e),!0);var s;})),e(AST_Do,(function(e,t,n){o(n,this);const a=e.in_loop;return e.in_loop=this,i(e),this.body.walk(e),has_break_or_continue(this)&&(r(e),i(e)),this.condition.walk(e),r(e),e.in_loop=a,!0})),e(AST_For,(function(e,t,n){o(n,this),this.init&&this.init.walk(e);const a=e.in_loop;return e.in_loop=this,i(e),this.condition&&this.condition.walk(e),this.body.walk(e),this.step&&(has_break_or_continue(this)&&(r(e),i(e)),this.step.walk(e)),r(e),e.in_loop=a,!0})),e(AST_ForIn,(function(e,t,n){o(n,this),_(this.init),this.object.walk(e);const a=e.in_loop;return e.in_loop=this,i(e),this.body.walk(e),r(e),e.in_loop=a,!0})),e(AST_If,(function(e){return this.condition.walk(e),i(e),this.body.walk(e),r(e),this.alternative&&(i(e),this.alternative.walk(e),r(e)),!0})),e(AST_LabeledStatement,(function(e){return i(e),this.body.walk(e),r(e),!0})),e(AST_SymbolCatch,(function(){this.definition().fixed=!1;})),e(AST_SymbolRef,(function(e,t,n){var o,i,r=this.definition();r.references.push(this),1==r.references.length&&!r.fixed&&r.orig[0]instanceof AST_SymbolDefun&&e.loop_ids.set(r.id,e.in_loop),void 0!==r.fixed&&s(e,r)?r.fixed&&((o=this.fixed_value())instanceof AST_Lambda&&recursive_ref(e,r)?r.recursive_refs++:o&&!n.exposed(r)&&function(e,t,n){return t.option("unused")&&!n.scope.pinned()&&n.references.length-n.recursive_refs==1&&e.loop_ids.get(n.id)===e.in_loop}(e,n,r)?r.single_use=o instanceof AST_Lambda&&!o.pinned()||o instanceof AST_Class||r.scope===this.scope&&o.is_constant_expression():r.single_use=!1,is_modified(n,e,this,o,0,!!(i=o)&&(i.is_constant()||i instanceof AST_Lambda||i instanceof AST_This))&&(r.single_use?r.single_use="m":r.fixed=!1)):r.fixed=!1,l(e,r,this.scope,this,o,0,1);})),e(AST_Toplevel,(function(e,o,i){this.globals.forEach((function(e){t(i,e);})),n(e,i,this);})),e(AST_Try,(function(e,t,n){return o(n,this),i(e),walk_body(this,e),r(e),this.bcatch&&(i(e),this.bcatch.walk(e),r(e)),this.bfinally&&this.bfinally.walk(e),!0})),e(AST_Unary,(function(e){var t=this;if("++"===t.operator||"--"===t.operator){var n=t.expression;if(n instanceof AST_SymbolRef){var o=n.definition(),i=u(e,o,n.scope,!0);if(o.assignments++,i){var r=o.fixed;if(r)return o.references.push(n),o.chained=!0,o.fixed=function(){return make_node(AST_Binary,t,{operator:t.operator.slice(0,-1),left:make_node(AST_UnaryPrefix,t,{operator:"+",expression:r instanceof AST_Node?r:r()}),right:make_node(AST_Number,t,{value:1})})},a(e,o,!0),!0}}}})),e(AST_VarDef,(function(e,t){var n=this;if(n.name instanceof AST_Destructuring)_(n.name);else {var o=n.name.definition();if(n.value){if(u(e,o,n.name.scope,n.value))return o.fixed=function(){return n.value},e.loop_ids.set(o.id,e.in_loop),a(e,o,!1),t(),a(e,o,!0),!0;o.fixed=!1;}}})),e(AST_While,(function(e,t,n){o(n,this);const a=e.in_loop;return e.in_loop=this,i(e),t(),r(e),e.in_loop=a,!0}));}((function(e,t){e.DEFMETHOD("reduce_vars",t);})),AST_Toplevel.DEFMETHOD("reset_opt_flags",(function(e){const t=this,n=e.option("reduce_vars"),o=new TreeWalker((function(i,r){if(clear_flag(i,1792),n)return e.top_retain&&i instanceof AST_Defun&&o.parent()===t&&set_flag(i,TOP),i.reduce_vars(o,r,e)}));o.safe_ids=Object.create(null),o.in_loop=null,o.loop_ids=new Map,o.defs_to_safe_ids=new Map,t.walk(o);})),AST_Symbol.DEFMETHOD("fixed_value",(function(){var e=this.thedef.fixed;return !e||e instanceof AST_Node?e:e()})),AST_SymbolRef.DEFMETHOD("is_immutable",(function(){var e=this.definition().orig;return 1==e.length&&e[0]instanceof AST_SymbolLambda}));var global_names=makePredicate("Array Boolean clearInterval clearTimeout console Date decodeURI decodeURIComponent encodeURI encodeURIComponent Error escape eval EvalError Function isFinite isNaN JSON Math Number parseFloat parseInt RangeError ReferenceError RegExp Object setInterval setTimeout String SyntaxError TypeError unescape URIError");AST_SymbolRef.DEFMETHOD("is_declared",(function(e){return !this.definition().undeclared||e.option("unsafe")&&global_names.has(this.name)}));var identifier_atom=makePredicate("Infinity NaN undefined");function is_identifier_atom(e){return e instanceof AST_Infinity||e instanceof AST_NaN||e instanceof AST_Undefined}function tighten_body(e,t){var n,o,i=t.find_parent(AST_Scope).get_defun_scope();!function(){var e=t.self(),r=0;do{if(e instanceof AST_Catch||e instanceof AST_Finally)r++;else if(e instanceof AST_IterationStatement)n=!0;else {if(e instanceof AST_Scope){i=e;break}e instanceof AST_Try&&(o=!0);}}while(e=t.parent(r++))}();var r,a=10;do{r=!1,u(e),t.option("dead_code")&&_(e,t),t.option("if_return")&&l(e,t),t.sequences_limit>0&&(f(e,t),d(e,t)),t.option("join_vars")&&m(e),t.option("collapse_vars")&&s(e,t);}while(r&&a-- >0);function s(e,t){if(i.pinned())return e;for(var a,s=[],u=e.length,l=new TreeTransformer((function(e){if(v)return e;if(!y)return e!==c[f]?e:++f<c.length?M(e):(y=!0,(S=P(e,0))===e&&(v=!0),e);var n,i=l.parent();if(e instanceof AST_Assign&&(e.logical||"="!=e.operator&&A.equivalent_to(e.left))||e instanceof AST_Await||e instanceof AST_Call&&A instanceof AST_PropAccess&&A.equivalent_to(e.expression)||e instanceof AST_Debugger||e instanceof AST_Destructuring||e instanceof AST_Expansion&&e.expression instanceof AST_Symbol&&(e.expression instanceof AST_This||e.expression.definition().references.length>1)||e instanceof AST_IterationStatement&&!(e instanceof AST_For)||e instanceof AST_LoopControl||e instanceof AST_Try||e instanceof AST_With||e instanceof AST_Yield||e instanceof AST_Export||e instanceof AST_Class||i instanceof AST_For&&e!==i.init||!g&&e instanceof AST_SymbolRef&&!e.is_declared(t)&&!pure_prop_access_globals.has(e)||e instanceof AST_SymbolRef&&i instanceof AST_Call&&has_annotation(i,_NOINLINE))return v=!0,e;if(m||h&&g||!(i instanceof AST_Binary&&lazy_op.has(i.operator)&&i.left!==e||i instanceof AST_Conditional&&i.condition!==e||i instanceof AST_If&&i.condition!==e)||(m=i),R&&!(e instanceof AST_SymbolDeclaration)&&A.equivalent_to(e)){if(m)return v=!0,e;if(is_lhs(e,i))return d&&C++,e;if(C++,d&&p instanceof AST_VarDef)return e;if(r=v=!0,p instanceof AST_UnaryPostfix)return make_node(AST_UnaryPrefix,p,p);if(p instanceof AST_VarDef){var a=p.name.definition(),s=p.value;return a.references.length-a.replaced!=1||t.exposed(a)?make_node(AST_Assign,p,{operator:"=",logical:!1,left:make_node(AST_SymbolRef,p.name,p.name),right:s}):(a.replaced++,b&&is_identifier_atom(s)?s.transform(t):maintain_this_binding(i,e,s))}return clear_flag(p,32),p}return (e instanceof AST_Call||e instanceof AST_Exit&&(E||A instanceof AST_PropAccess||H(A))||e instanceof AST_PropAccess&&(E||e.expression.may_throw_on_access(t))||e instanceof AST_SymbolRef&&(T.get(e.name)||E&&H(e))||e instanceof AST_VarDef&&e.value&&(T.has(e.name.name)||E&&H(e.name))||(n=is_lhs(e.left,e))&&(n instanceof AST_PropAccess||T.has(n.name))||D&&(o?e.has_side_effects(t):X(e)))&&(S=e,e instanceof AST_Scope&&(v=!0)),M(e)}),(function(e){v||(S===e&&(v=!0),m===e&&(m=null));})),_=new TreeTransformer((function(e){if(v)return e;if(!y){if(e!==c[f])return e;if(++f<c.length)return;return y=!0,e}return e instanceof AST_SymbolRef&&e.name==F.name?(--C||(v=!0),is_lhs(e,_.parent())?e:(F.replaced++,d.replaced--,p.value)):e instanceof AST_Default||e instanceof AST_Scope?e:void 0}));--u>=0;){0==u&&t.option("unused")&&x();var c=[];for(w(e[u]);s.length>0;){c=s.pop();var f=0,p=c[c.length-1],d=null,S=null,m=null,A=B(p);if(A&&!is_lhs_read_only(A)&&!A.has_side_effects(t)){var T=V(p),h=K(A);A instanceof AST_SymbolRef&&T.set(A.name,!1);var E=(N=p)instanceof AST_Unary?unary_side_effects.has(N.operator):L(N).has_side_effects(t),g=G(),D=p.may_throw(t),b=p.name instanceof AST_SymbolFunarg,y=b,v=!1,C=0,R=!a||!y;if(!R){for(var k=t.self().argnames.lastIndexOf(p.name)+1;!v&&k<a.length;k++)a[k].transform(l);R=!0;}for(var O=u;!v&&O<e.length;O++)e[O].transform(l);if(d){var F=p.name.definition();if(v&&F.references.length-F.replaced>C)C=!1;else {for(v=!1,f=0,y=b,O=u;!v&&O<e.length;O++)e[O].transform(_);d.single_use=!1;}}C&&!U(p)&&e.splice(u,1);}}}var N;function M(e){if(e instanceof AST_Scope)return e;if(e instanceof AST_Switch){e.expression=e.expression.transform(l);for(var t=0,n=e.body.length;!v&&t<n;t++){var o=e.body[t];if(o instanceof AST_Case){if(!y){if(o!==c[f])continue;f++;}if(o.expression=o.expression.transform(l),!g)break}}return v=!0,e}}function I(e,t,n){var o=!1,r=!(e instanceof AST_Arrow);return t.walk(new TreeWalker((function(t,a){if(o)return !0;if(t instanceof AST_SymbolRef&&(e.variables.has(t.name)||function(e,t){if(e.global)return !1;let n=e.scope;for(;n&&n!==t;){if(n.variables.has(e.name))return !0;n=n.parent_scope;}return !1}(t.definition(),e))){var s=t.definition().scope;if(s!==i)for(;s=s.parent_scope;)if(s===i)return !0;return o=!0}if((n||r)&&t instanceof AST_This)return o=!0;if(t instanceof AST_Scope&&!(t instanceof AST_Arrow)){var u=r;return r=!1,a(),r=u,!0}}))),o}function x(){var e,n=t.self();if(is_func_expr(n)&&!n.name&&!n.uses_arguments&&!n.pinned()&&(e=t.parent())instanceof AST_Call&&e.expression===n&&e.args.every((e=>!(e instanceof AST_Expansion)))){var o=t.has_directive("use strict");o&&!member(o,n.body)&&(o=!1);var i=n.argnames.length;a=e.args.slice(i);for(var r=new Set,u=i;--u>=0;){var l=n.argnames[u],_=e.args[u];const i=l.definition&&l.definition();if(!(i&&i.orig.length>1||(a.unshift(make_node(AST_VarDef,l,{name:l,value:_})),r.has(l.name))))if(r.add(l.name),l instanceof AST_Expansion){var c=e.args.slice(u);c.every((e=>!I(n,e,o)))&&s.unshift([make_node(AST_VarDef,l,{name:l.expression,value:make_node(AST_Array,e,{elements:c})})]);}else _?(_ instanceof AST_Lambda&&_.pinned()||I(n,_,o))&&(_=null):_=make_node(AST_Undefined,l).transform(t),_&&s.unshift([make_node(AST_VarDef,l,{name:l,value:_})]);}}}function w(e){if(c.push(e),e instanceof AST_Assign)e.left.has_side_effects(t)||s.push(c.slice()),w(e.right);else if(e instanceof AST_Binary)w(e.left),w(e.right);else if(e instanceof AST_Call&&!has_annotation(e,_NOINLINE))w(e.expression),e.args.forEach(w);else if(e instanceof AST_Case)w(e.expression);else if(e instanceof AST_Conditional)w(e.condition),w(e.consequent),w(e.alternative);else if(e instanceof AST_Definitions){var n=e.definitions.length,o=n-200;for(o<0&&(o=0);o<n;o++)w(e.definitions[o]);}else e instanceof AST_DWLoop?(w(e.condition),e.body instanceof AST_Block||w(e.body)):e instanceof AST_Exit?e.value&&w(e.value):e instanceof AST_For?(e.init&&w(e.init),e.condition&&w(e.condition),e.step&&w(e.step),e.body instanceof AST_Block||w(e.body)):e instanceof AST_ForIn?(w(e.object),e.body instanceof AST_Block||w(e.body)):e instanceof AST_If?(w(e.condition),e.body instanceof AST_Block||w(e.body),!e.alternative||e.alternative instanceof AST_Block||w(e.alternative)):e instanceof AST_Sequence?e.expressions.forEach(w):e instanceof AST_SimpleStatement?w(e.body):e instanceof AST_Switch?(w(e.expression),e.body.forEach(w)):e instanceof AST_Unary?"++"!=e.operator&&"--"!=e.operator||s.push(c.slice()):e instanceof AST_VarDef&&e.value&&(s.push(c.slice()),w(e.value));c.pop();}function P(e,t,n){var o=l.parent(t);return o instanceof AST_Assign?!n||o.logical||o.left instanceof AST_PropAccess||T.has(o.left.name)?e:P(o,t+1,n):o instanceof AST_Binary?!n||lazy_op.has(o.operator)&&o.left!==e?e:P(o,t+1,n):o instanceof AST_Call||o instanceof AST_Case?e:o instanceof AST_Conditional?n&&o.condition===e?P(o,t+1,n):e:o instanceof AST_Definitions?P(o,t+1,!0):o instanceof AST_Exit?n?P(o,t+1,n):e:o instanceof AST_If?n&&o.condition===e?P(o,t+1,n):e:o instanceof AST_IterationStatement?e:o instanceof AST_Sequence?P(o,t+1,o.tail_node()!==e):o instanceof AST_SimpleStatement?P(o,t+1,!0):o instanceof AST_Switch||o instanceof AST_VarDef?e:null}function B(e){if(e instanceof AST_Assign&&e.logical)return !1;if(!(e instanceof AST_VarDef&&e.name instanceof AST_SymbolDeclaration)){const t=e instanceof AST_Assign?e.left:e.expression;return !is_ref_of(t,AST_SymbolConst)&&!is_ref_of(t,AST_SymbolLet)&&t}var n=e.name.definition();if(member(e.name,n.orig)){var o=n.references.length-n.replaced;if(o)return n.orig.length-n.eliminated>1&&!(e.name instanceof AST_SymbolFunarg)||(o>1?function(e){var t=e.value;if(t instanceof AST_SymbolRef&&"arguments"!=t.name){var n=t.definition();if(!n.undeclared)return d=n}}(e):!t.exposed(n))?make_node(AST_SymbolRef,e.name,e.name):void 0}}function L(e){return e instanceof AST_Assign?e.right:e.value}function V(e){var n=new Map;if(e instanceof AST_Unary)return n;var o=new TreeWalker((function(e){for(var i=e;i instanceof AST_PropAccess;)i=i.expression;(i instanceof AST_SymbolRef||i instanceof AST_This)&&n.set(i.name,n.get(i.name)||is_modified(t,o,e,e,0));}));return L(e).walk(o),n}function U(n){if(n.name instanceof AST_SymbolFunarg){var o=t.parent(),i=t.self().argnames,r=i.indexOf(n.name);if(r<0)o.args.length=Math.min(o.args.length,i.length-1);else {var a=o.args;a[r]&&(a[r]=make_node(AST_Number,a[r],{value:0}));}return !0}var s=!1;return e[u].transform(new TreeTransformer((function(e,t,o){return s?e:e===n||e.body===n?(s=!0,e instanceof AST_VarDef?(e.value=e.name instanceof AST_SymbolConst?make_node(AST_Undefined,e.value):null,e):o?MAP.skip:null):void 0}),(function(e){if(e instanceof AST_Sequence)switch(e.expressions.length){case 0:return null;case 1:return e.expressions[0]}})))}function K(e){for(;e instanceof AST_PropAccess;)e=e.expression;return e instanceof AST_SymbolRef&&e.definition().scope===i&&!(n&&(T.has(e.name)||p instanceof AST_Unary||p instanceof AST_Assign&&!p.logical&&"="!=p.operator))}function G(){if(E)return !1;if(d)return !0;if(A instanceof AST_SymbolRef){var e=A.definition();if(e.references.length-e.replaced==(p instanceof AST_VarDef?1:2))return !0}return !1}function H(e){if(!e.definition)return !0;var t=e.definition();return !(1==t.orig.length&&t.orig[0]instanceof AST_SymbolDefun||t.scope.get_defun_scope()===i&&t.references.every((e=>{var t=e.scope.get_defun_scope();return "Scope"==t.TYPE&&(t=t.parent_scope),t===i})))}function X(e,t){if(e instanceof AST_Assign)return X(e.left,!0);if(e instanceof AST_Unary)return X(e.expression,!0);if(e instanceof AST_VarDef)return e.value&&X(e.value);if(t){if(e instanceof AST_Dot)return X(e.expression,!0);if(e instanceof AST_Sub)return X(e.expression,!0);if(e instanceof AST_SymbolRef)return e.definition().scope!==i}return !1}}function u(e){for(var t=[],n=0;n<e.length;){var o=e[n];o instanceof AST_BlockStatement&&o.body.every(can_be_evicted_from_block)?(r=!0,u(o.body),e.splice(n,1,...o.body),n+=o.body.length):o instanceof AST_EmptyStatement?(r=!0,e.splice(n,1)):o instanceof AST_Directive?t.indexOf(o.value)<0?(n++,t.push(o.value)):(r=!0,e.splice(n,1)):n++;}}function l(e,t){for(var n=t.self(),o=function(e){for(var t=0,n=e.length;--n>=0;){var o=e[n];if(o instanceof AST_If&&o.body instanceof AST_Return&&++t>1)return !0}return !1}(e),i=n instanceof AST_Lambda,a=e.length;--a>=0;){var s=e[a],u=T(a),l=e[u];if(i&&!l&&s instanceof AST_Return){if(!s.value){r=!0,e.splice(a,1);continue}if(s.value instanceof AST_UnaryPrefix&&"void"==s.value.operator){r=!0,e[a]=make_node(AST_SimpleStatement,s,{body:s.value.expression});continue}}if(s instanceof AST_If){var _;if(S(_=aborts(s.body))){_.label&&remove$1(_.label.thedef.references,_),r=!0,(s=s.clone()).condition=s.condition.negate(t);var f=A(s.body,_);s.body=make_node(AST_BlockStatement,s,{body:as_statement_array(s.alternative).concat(m())}),s.alternative=make_node(AST_BlockStatement,s,{body:f}),e[a]=s.transform(t);continue}if(S(_=aborts(s.alternative))){_.label&&remove$1(_.label.thedef.references,_),r=!0,(s=s.clone()).body=make_node(AST_BlockStatement,s.body,{body:as_statement_array(s.body).concat(m())}),f=A(s.alternative,_),s.alternative=make_node(AST_BlockStatement,s.alternative,{body:f}),e[a]=s.transform(t);continue}}if(s instanceof AST_If&&s.body instanceof AST_Return){var p=s.body.value;if(!p&&!s.alternative&&(i&&!l||l instanceof AST_Return&&!l.value)){r=!0,e[a]=make_node(AST_SimpleStatement,s.condition,{body:s.condition});continue}if(p&&!s.alternative&&l instanceof AST_Return&&l.value){r=!0,(s=s.clone()).alternative=l,e[a]=s.transform(t),e.splice(u,1);continue}if(p&&!s.alternative&&(!l&&i&&o||l instanceof AST_Return)){r=!0,(s=s.clone()).alternative=l||make_node(AST_Return,s,{value:null}),e[a]=s.transform(t),l&&e.splice(u,1);continue}var d=e[h(a)];if(t.option("sequences")&&i&&!s.alternative&&d instanceof AST_If&&d.body instanceof AST_Return&&T(u)==e.length&&l instanceof AST_SimpleStatement){r=!0,(s=s.clone()).alternative=make_node(AST_BlockStatement,l,{body:[l,make_node(AST_Return,l,{value:null})]}),e[a]=s.transform(t),e.splice(u,1);continue}}}function S(o){if(!o)return !1;for(var r=a+1,s=e.length;r<s;r++){var u=e[r];if(u instanceof AST_Const||u instanceof AST_Let)return !1}var l=o instanceof AST_LoopControl?t.loopcontrol_target(o):null;return o instanceof AST_Return&&i&&function(e){return !e||e instanceof AST_UnaryPrefix&&"void"==e.operator}(o.value)||o instanceof AST_Continue&&n===loop_body(l)||o instanceof AST_Break&&l instanceof AST_BlockStatement&&n===l}function m(){var t=e.slice(a+1);return e.length=a+1,t.filter((function(t){return !(t instanceof AST_Defun&&(e.push(t),1))}))}function A(e,t){var n=as_statement_array(e).slice(0,-1);return t.value&&n.push(make_node(AST_SimpleStatement,t.value,{body:t.value.expression})),n}function T(t){for(var n=t+1,o=e.length;n<o;n++){var i=e[n];if(!(i instanceof AST_Var&&c(i)))break}return n}function h(t){for(var n=t;--n>=0;){var o=e[n];if(!(o instanceof AST_Var&&c(o)))break}return n}}function _(e,t){for(var n,o=t.self(),i=0,a=0,s=e.length;i<s;i++){var u=e[i];if(u instanceof AST_LoopControl){var l=t.loopcontrol_target(u);u instanceof AST_Break&&!(l instanceof AST_IterationStatement)&&loop_body(l)===o||u instanceof AST_Continue&&loop_body(l)===o?u.label&&remove$1(u.label.thedef.references,u):e[a++]=u;}else e[a++]=u;if(aborts(u)){n=e.slice(i+1);break}}e.length=a,r=a!=s,n&&n.forEach((function(n){trim_unreachable_code(t,n,e);}));}function c(e){return e.definitions.every((e=>!e.value))}function f(e,t){if(!(e.length<2)){for(var n=[],o=0,i=0,a=e.length;i<a;i++){var s=e[i];if(s instanceof AST_SimpleStatement){n.length>=t.sequences_limit&&l();var u=s.body;n.length>0&&(u=u.drop_side_effect_free(t)),u&&merge_sequence(n,u);}else s instanceof AST_Definitions&&c(s)||s instanceof AST_Defun||l(),e[o++]=s;}l(),e.length=o,o!=a&&(r=!0);}function l(){if(n.length){var t=make_sequence(n[0],n);e[o++]=make_node(AST_SimpleStatement,t,{body:t}),n=[];}}}function p(e,t){if(!(e instanceof AST_BlockStatement))return e;for(var n=null,o=0,i=e.body.length;o<i;o++){var r=e.body[o];if(r instanceof AST_Var&&c(r))t.push(r);else {if(n)return !1;n=r;}}return n}function d(e,t){function n(e){i--,r=!0;var n=o.body;return make_sequence(n,[n,e]).transform(t)}for(var o,i=0,a=0;a<e.length;a++){var s=e[a];if(o&&(s instanceof AST_Exit?s.value=n(s.value||make_node(AST_Undefined,s).transform(t)):s instanceof AST_For?s.init instanceof AST_Definitions||walk$3(o.body,(e=>e instanceof AST_Scope||(e instanceof AST_Binary&&"in"===e.operator?walk_abort:void 0)))||(s.init?s.init=n(s.init):(s.init=o.body,i--,r=!0)):s instanceof AST_ForIn?s.init instanceof AST_Const||s.init instanceof AST_Let||(s.object=n(s.object)):s instanceof AST_If?s.condition=n(s.condition):(s instanceof AST_Switch||s instanceof AST_With)&&(s.expression=n(s.expression))),t.option("conditionals")&&s instanceof AST_If){var u=[],l=p(s.body,u),_=p(s.alternative,u);if(!1!==l&&!1!==_&&u.length>0){var c=u.length;u.push(make_node(AST_If,s,{condition:s.condition,body:l||make_node(AST_EmptyStatement,s.body),alternative:_})),u.unshift(i,1),[].splice.apply(e,u),a+=c,i+=c+1,o=null,r=!0;continue}}e[i++]=s,o=s instanceof AST_SimpleStatement?s:null;}e.length=i;}function S(e,n){if(e instanceof AST_Definitions){var o,r=e.definitions[e.definitions.length-1];if(r.value instanceof AST_Object&&(n instanceof AST_Assign&&!n.logical?o=[n]:n instanceof AST_Sequence&&(o=n.expressions.slice()),o)){var a=!1;do{var s=o[0];if(!(s instanceof AST_Assign))break;if("="!=s.operator)break;if(!(s.left instanceof AST_PropAccess))break;var u=s.left.expression;if(!(u instanceof AST_SymbolRef))break;if(r.name.name!=u.name)break;if(!s.right.is_constant_expression(i))break;var l=s.left.property;if(l instanceof AST_Node&&(l=l.evaluate(t)),l instanceof AST_Node)break;l=""+l;var _=t.option("ecma")<2015&&t.has_directive("use strict")?function(e){return e.key!=l&&e.key&&e.key.name!=l}:function(e){return e.key&&e.key.name!=l};if(!r.value.properties.every(_))break;var c=r.value.properties.filter((function(e){return e.key===l}))[0];c?c.value=new AST_Sequence({start:c.start,expressions:[c.value.clone(),s.right.clone()],end:c.end}):r.value.properties.push(make_node(AST_ObjectKeyVal,s,{key:l,value:s.right})),o.shift(),a=!0;}while(o.length);return a&&o}}}function m(e){for(var t,n=0,o=-1,i=e.length;n<i;n++){var a=e[n],s=e[o];if(a instanceof AST_Definitions)s&&s.TYPE==a.TYPE?(s.definitions=s.definitions.concat(a.definitions),r=!0):t&&t.TYPE==a.TYPE&&c(a)?(t.definitions=t.definitions.concat(a.definitions),r=!0):(e[++o]=a,t=a);else if(a instanceof AST_Exit)a.value=l(a.value);else if(a instanceof AST_For)(u=S(s,a.init))?(r=!0,a.init=u.length?make_sequence(a.init,u):null,e[++o]=a):s instanceof AST_Var&&(!a.init||a.init.TYPE==s.TYPE)?(a.init&&(s.definitions=s.definitions.concat(a.init.definitions)),a.init=s,e[o]=a,r=!0):t&&a.init&&t.TYPE==a.init.TYPE&&c(a.init)?(t.definitions=t.definitions.concat(a.init.definitions),a.init=null,e[++o]=a,r=!0):e[++o]=a;else if(a instanceof AST_ForIn)a.object=l(a.object);else if(a instanceof AST_If)a.condition=l(a.condition);else if(a instanceof AST_SimpleStatement){var u;if(u=S(s,a.body)){if(r=!0,!u.length)continue;a.body=make_sequence(a.body,u);}e[++o]=a;}else a instanceof AST_Switch||a instanceof AST_With?a.expression=l(a.expression):e[++o]=a;}function l(t){e[++o]=a;var n=S(s,t);return n?(r=!0,n.length?make_sequence(t,n):t instanceof AST_Sequence?t.tail_node().left:t.left):t}e.length=o+1;}}function trim_unreachable_code(e,t,n){walk$3(t,(o=>o instanceof AST_Var?(o.remove_initializers(),n.push(o),!0):o instanceof AST_Defun&&(o===t||!e.has_directive("use strict"))?(n.push(o===t?o:make_node(AST_Var,o,{definitions:[make_node(AST_VarDef,o,{name:make_node(AST_SymbolVar,o.name,o.name),value:null})]})),!0):o instanceof AST_Export||o instanceof AST_Import?(n.push(o),!0):o instanceof AST_Scope||void 0));}function get_value(e){return e instanceof AST_Constant?e.getValue():e instanceof AST_UnaryPrefix&&"void"==e.operator&&e.expression instanceof AST_Constant?void 0:e}function is_undefined(e,t){return has_flag(e,8)||e instanceof AST_Undefined||e instanceof AST_UnaryPrefix&&"void"==e.operator&&!e.expression.has_side_effects(t)}!function(e){function t(e){return /strict/.test(e.option("pure_getters"))}AST_Node.DEFMETHOD("may_throw_on_access",(function(e){return !e.option("pure_getters")||this._dot_throw(e)})),e(AST_Node,t),e(AST_Null,return_true),e(AST_Undefined,return_true),e(AST_Constant,return_false),e(AST_Array,return_false),e(AST_Object,(function(e){if(!t(e))return !1;for(var n=this.properties.length;--n>=0;)if(this.properties[n]._dot_throw(e))return !0;return !1})),e(AST_Class,return_false),e(AST_ObjectProperty,return_false),e(AST_ObjectGetter,return_true),e(AST_Expansion,(function(e){return this.expression._dot_throw(e)})),e(AST_Function,return_false),e(AST_Arrow,return_false),e(AST_UnaryPostfix,return_false),e(AST_UnaryPrefix,(function(){return "void"==this.operator})),e(AST_Binary,(function(e){return ("&&"==this.operator||"||"==this.operator||"??"==this.operator)&&(this.left._dot_throw(e)||this.right._dot_throw(e))})),e(AST_Assign,(function(e){return !!this.logical||"="==this.operator&&this.right._dot_throw(e)})),e(AST_Conditional,(function(e){return this.consequent._dot_throw(e)||this.alternative._dot_throw(e)})),e(AST_Dot,(function(e){return !(!t(e)||"prototype"==this.property&&(this.expression instanceof AST_Function||this.expression instanceof AST_Class))})),e(AST_Chain,(function(e){return this.expression._dot_throw(e)})),e(AST_Sequence,(function(e){return this.tail_node()._dot_throw(e)})),e(AST_SymbolRef,(function(e){if("arguments"===this.name)return !1;if(has_flag(this,8))return !0;if(!t(e))return !1;if(is_undeclared_ref(this)&&this.is_declared(e))return !1;if(this.is_immutable())return !1;var n=this.fixed_value();return !n||n._dot_throw(e)}));}((function(e,t){e.DEFMETHOD("_dot_throw",t);})),function(e){const t=makePredicate("! delete"),n=makePredicate("in instanceof == != === !== < <= >= >");e(AST_Node,return_false),e(AST_UnaryPrefix,(function(){return t.has(this.operator)})),e(AST_Binary,(function(){return n.has(this.operator)||lazy_op.has(this.operator)&&this.left.is_boolean()&&this.right.is_boolean()})),e(AST_Conditional,(function(){return this.consequent.is_boolean()&&this.alternative.is_boolean()})),e(AST_Assign,(function(){return "="==this.operator&&this.right.is_boolean()})),e(AST_Sequence,(function(){return this.tail_node().is_boolean()})),e(AST_True,return_true),e(AST_False,return_true);}((function(e,t){e.DEFMETHOD("is_boolean",t);})),function(e){e(AST_Node,return_false),e(AST_Number,return_true);var t=makePredicate("+ - ~ ++ --");e(AST_Unary,(function(){return t.has(this.operator)}));var n=makePredicate("- * / % & | ^ << >> >>>");e(AST_Binary,(function(e){return n.has(this.operator)||"+"==this.operator&&this.left.is_number(e)&&this.right.is_number(e)})),e(AST_Assign,(function(e){return n.has(this.operator.slice(0,-1))||"="==this.operator&&this.right.is_number(e)})),e(AST_Sequence,(function(e){return this.tail_node().is_number(e)})),e(AST_Conditional,(function(e){return this.consequent.is_number(e)&&this.alternative.is_number(e)}));}((function(e,t){e.DEFMETHOD("is_number",t);})),function(e){e(AST_Node,return_false),e(AST_String,return_true),e(AST_TemplateString,return_true),e(AST_UnaryPrefix,(function(){return "typeof"==this.operator})),e(AST_Binary,(function(e){return "+"==this.operator&&(this.left.is_string(e)||this.right.is_string(e))})),e(AST_Assign,(function(e){return ("="==this.operator||"+="==this.operator)&&this.right.is_string(e)})),e(AST_Sequence,(function(e){return this.tail_node().is_string(e)})),e(AST_Conditional,(function(e){return this.consequent.is_string(e)&&this.alternative.is_string(e)}));}((function(e,t){e.DEFMETHOD("is_string",t);}));var lazy_op=makePredicate("&& || ??"),unary_side_effects=makePredicate("delete ++ --");function is_lhs(e,t){return t instanceof AST_Unary&&unary_side_effects.has(t.operator)?t.expression:t instanceof AST_Assign&&t.left===e?e:void 0}function best_of_expression(e,t){return e.size()>t.size()?t:e}function best_of_statement(e,t){return best_of_expression(make_node(AST_SimpleStatement,e,{body:e}),make_node(AST_SimpleStatement,t,{body:t})).body}function best_of(e,t,n){return (first_in_statement(e)?best_of_statement:best_of_expression)(t,n)}function convert_to_predicate(e){const t=new Map;for(var n of Object.keys(e))t.set(n,makePredicate(e[n]));return t}!function(e){function t(e,n){if(e instanceof AST_Node)return make_node(e.CTOR,n,e);if(Array.isArray(e))return make_node(AST_Array,n,{elements:e.map((function(e){return t(e,n)}))});if(e&&"object"==typeof e){var o=[];for(var i in e)HOP(e,i)&&o.push(make_node(AST_ObjectKeyVal,n,{key:i,value:t(e[i],n)}));return make_node(AST_Object,n,{properties:o})}return make_node_from_constant(e,n)}AST_Toplevel.DEFMETHOD("resolve_defines",(function(e){return e.option("global_defs")?(this.figure_out_scope({ie8:e.option("ie8")}),this.transform(new TreeTransformer((function(t){var n=t._find_defs(e,"");if(n){for(var o,i=0,r=t;(o=this.parent(i++))&&o instanceof AST_PropAccess&&o.expression===r;)r=o;if(!is_lhs(r,o))return n}})))):this})),e(AST_Node,noop),e(AST_Chain,(function(e,t){return this.expression._find_defs(e,t)})),e(AST_Dot,(function(e,t){return this.expression._find_defs(e,"."+this.property+t)})),e(AST_SymbolDeclaration,(function(){this.global();})),e(AST_SymbolRef,(function(e,n){if(this.global()){var o=e.option("global_defs"),i=this.name+n;return HOP(o,i)?t(o[i],this):void 0}}));}((function(e,t){e.DEFMETHOD("_find_defs",t);}));var object_fns=["constructor","toString","valueOf"],native_fns=convert_to_predicate({Array:["indexOf","join","lastIndexOf","slice"].concat(object_fns),Boolean:object_fns,Function:object_fns,Number:["toExponential","toFixed","toPrecision"].concat(object_fns),Object:object_fns,RegExp:["test"].concat(object_fns),String:["charAt","charCodeAt","concat","indexOf","italics","lastIndexOf","match","replace","search","slice","split","substr","substring","toLowerCase","toUpperCase","trim"].concat(object_fns)}),static_fns=convert_to_predicate({Array:["isArray"],Math:["abs","acos","asin","atan","ceil","cos","exp","floor","log","round","sin","sqrt","tan","atan2","pow","max","min"],Number:["isFinite","isNaN"],Object:["create","getOwnPropertyDescriptor","getOwnPropertyNames","getPrototypeOf","isExtensible","isFrozen","isSealed","keys"],String:["fromCharCode"]});!function(e){AST_Node.DEFMETHOD("evaluate",(function(e){if(!e.option("evaluate"))return this;var t=this._eval(e,1);return !t||t instanceof RegExp?t:"function"==typeof t||"object"==typeof t?this:t}));var t=makePredicate("! ~ - + void");AST_Node.DEFMETHOD("is_constant",(function(){return this instanceof AST_Constant?!(this instanceof AST_RegExp):this instanceof AST_UnaryPrefix&&this.expression instanceof AST_Constant&&t.has(this.operator)})),e(AST_Statement,(function(){throw new Error(string_template("Cannot evaluate a statement [{file}:{line},{col}]",this.start))})),e(AST_Lambda,return_this),e(AST_Class,return_this),e(AST_Node,return_this),e(AST_Constant,(function(){return this.getValue()})),e(AST_BigInt,return_this),e(AST_RegExp,(function(e){let t=e.evaluated_regexps.get(this);if(void 0===t){try{t=(0,eval)(this.print_to_string());}catch(e){t=null;}e.evaluated_regexps.set(this,t);}return t||this})),e(AST_TemplateString,(function(){return 1!==this.segments.length?this:this.segments[0].value})),e(AST_Function,(function(e){if(e.option("unsafe")){var t=function(){};return t.node=this,t.toString=function(){return this.node.print_to_string()},t}return this})),e(AST_Array,(function(e,t){if(e.option("unsafe")){for(var n=[],o=0,i=this.elements.length;o<i;o++){var r=this.elements[o],a=r._eval(e,t);if(r===a)return this;n.push(a);}return n}return this})),e(AST_Object,(function(e,t){if(e.option("unsafe")){for(var n={},o=0,i=this.properties.length;o<i;o++){var r=this.properties[o];if(r instanceof AST_Expansion)return this;var a=r.key;if(a instanceof AST_Symbol)a=a.name;else if(a instanceof AST_Node&&(a=a._eval(e,t))===r.key)return this;if("function"==typeof Object.prototype[a])return this;if(!(r.value instanceof AST_Function)&&(n[a]=r.value._eval(e,t),n[a]===r.value))return this}return n}return this}));var n=makePredicate("! typeof void");e(AST_UnaryPrefix,(function(e,t){var o=this.expression;if(e.option("typeofs")&&"typeof"==this.operator&&(o instanceof AST_Lambda||o instanceof AST_SymbolRef&&o.fixed_value()instanceof AST_Lambda))return "function";if(n.has(this.operator)||t++,(o=o._eval(e,t))===this.expression)return this;switch(this.operator){case"!":return !o;case"typeof":return o instanceof RegExp?this:typeof o;case"void":return;case"~":return ~o;case"-":return -o;case"+":return +o}return this}));var o=makePredicate("&& || ?? === !==");const i=makePredicate("== != === !=="),r=e=>"object"==typeof e||"function"==typeof e||"symbol"==typeof e;e(AST_Binary,(function(e,t){o.has(this.operator)||t++;var n=this.left._eval(e,t);if(n===this.left)return this;var a,s=this.right._eval(e,t);if(s===this.right)return this;if(null!=n&&null!=s&&i.has(this.operator)&&r(n)&&r(s)&&typeof n==typeof s)return this;switch(this.operator){case"&&":a=n&&s;break;case"||":a=n||s;break;case"??":a=null!=n?n:s;break;case"|":a=n|s;break;case"&":a=n&s;break;case"^":a=n^s;break;case"+":a=n+s;break;case"*":a=n*s;break;case"**":a=Math.pow(n,s);break;case"/":a=n/s;break;case"%":a=n%s;break;case"-":a=n-s;break;case"<<":a=n<<s;break;case">>":a=n>>s;break;case">>>":a=n>>>s;break;case"==":a=n==s;break;case"===":a=n===s;break;case"!=":a=n!=s;break;case"!==":a=n!==s;break;case"<":a=n<s;break;case"<=":a=n<=s;break;case">":a=n>s;break;case">=":a=n>=s;break;default:return this}return isNaN(a)&&e.find_parent(AST_With)?this:a})),e(AST_Conditional,(function(e,t){var n=this.condition._eval(e,t);if(n===this.condition)return this;var o=n?this.consequent:this.alternative,i=o._eval(e,t);return i===o?this:i}));const a=new Set;e(AST_SymbolRef,(function(e,t){if(a.has(this))return this;var n=this.fixed_value();if(!n)return this;a.add(this);const o=n._eval(e,t);if(a.delete(this),o===n)return this;if(o&&"object"==typeof o){var i=this.definition().escaped;if(i&&t>i)return this}return o}));var s={Array,Math,Number,Object,String},u=convert_to_predicate({Math:["E","LN10","LN2","LOG2E","LOG10E","PI","SQRT1_2","SQRT2"],Number:["MAX_VALUE","MIN_VALUE","NaN","NEGATIVE_INFINITY","POSITIVE_INFINITY"]});e(AST_PropAccess,(function(e,t){if(!this.optional||null!=this.expression._eval(e,t)){if(e.option("unsafe")){var n=this.property;if(n instanceof AST_Node&&(n=n._eval(e,t))===this.property)return this;var o,i=this.expression;if(is_undeclared_ref(i)){var r,a="hasOwnProperty"===i.name&&"call"===n&&(r=e.parent()&&e.parent().args)&&r&&r[0]&&r[0].evaluate(e);if(null==(a=a instanceof AST_Dot?a.expression:a)||a.thedef&&a.thedef.undeclared)return this.clone();var l=u.get(i.name);if(!l||!l.has(n))return this;o=s[i.name];}else {if(!(o=i._eval(e,t+1))||o===i||!HOP(o,n))return this;if("function"==typeof o)switch(n){case"name":return o.node.name?o.node.name.name:"";case"length":return o.node.argnames.length;default:return this}}return o[n]}return this}})),e(AST_Chain,(function(e,t){const n=this.expression._eval(e,t);return n===this.expression?this:n})),e(AST_Call,(function(e,t){var n=this.expression;if(!this.optional||null!=this.expression._eval(e,t)){if(e.option("unsafe")&&n instanceof AST_PropAccess){var o,i=n.property;if(i instanceof AST_Node&&(i=i._eval(e,t))===n.property)return this;var r=n.expression;if(is_undeclared_ref(r)){var a="hasOwnProperty"===r.name&&"call"===i&&this.args[0]&&this.args[0].evaluate(e);if(null==(a=a instanceof AST_Dot?a.expression:a)||a.thedef&&a.thedef.undeclared)return this.clone();var u=static_fns.get(r.name);if(!u||!u.has(i))return this;o=s[r.name];}else {if((o=r._eval(e,t+1))===r||!o)return this;var l=native_fns.get(o.constructor.name);if(!l||!l.has(i))return this}for(var _=[],c=0,f=this.args.length;c<f;c++){var p=this.args[c],d=p._eval(e,t);if(p===d)return this;_.push(d);}try{return o[i].apply(o,_)}catch(e){}}return this}})),e(AST_New,return_this);}((function(e,t){e.DEFMETHOD("_eval",t);})),function(e){function t(e){return make_node(AST_UnaryPrefix,e,{operator:"!",expression:e})}function n(e,n,o){var i=t(e);if(o){var r=make_node(AST_SimpleStatement,n,{body:n});return best_of_expression(i,r)===r?n:i}return best_of_expression(i,n)}e(AST_Node,(function(){return t(this)})),e(AST_Statement,(function(){throw new Error("Cannot negate a statement")})),e(AST_Function,(function(){return t(this)})),e(AST_Arrow,(function(){return t(this)})),e(AST_UnaryPrefix,(function(){return "!"==this.operator?this.expression:t(this)})),e(AST_Sequence,(function(e){var t=this.expressions.slice();return t.push(t.pop().negate(e)),make_sequence(this,t)})),e(AST_Conditional,(function(e,t){var o=this.clone();return o.consequent=o.consequent.negate(e),o.alternative=o.alternative.negate(e),n(this,o,t)})),e(AST_Binary,(function(e,o){var i=this.clone(),r=this.operator;if(e.option("unsafe_comps"))switch(r){case"<=":return i.operator=">",i;case"<":return i.operator=">=",i;case">=":return i.operator="<",i;case">":return i.operator="<=",i}switch(r){case"==":return i.operator="!=",i;case"!=":return i.operator="==",i;case"===":return i.operator="!==",i;case"!==":return i.operator="===",i;case"&&":return i.operator="||",i.left=i.left.negate(e,o),i.right=i.right.negate(e),n(this,i,o);case"||":return i.operator="&&",i.left=i.left.negate(e,o),i.right=i.right.negate(e),n(this,i,o);case"??":return i.right=i.right.negate(e),n(this,i,o)}return t(this)}));}((function(e,t){e.DEFMETHOD("negate",(function(e,n){return t.call(this,e,n)}));}));var global_pure_fns=makePredicate("Boolean decodeURI decodeURIComponent Date encodeURI encodeURIComponent Error escape EvalError isFinite isNaN Number Object parseFloat parseInt RangeError ReferenceError String SyntaxError TypeError unescape URIError");AST_Call.DEFMETHOD("is_expr_pure",(function(e){if(e.option("unsafe")){var t=this.expression,n=this.args&&this.args[0]&&this.args[0].evaluate(e);if(t.expression&&"hasOwnProperty"===t.expression.name&&(null==n||n.thedef&&n.thedef.undeclared))return !1;if(is_undeclared_ref(t)&&global_pure_fns.has(t.name))return !0;let o;if(t instanceof AST_Dot&&is_undeclared_ref(t.expression)&&(o=static_fns.get(t.expression.name))&&o.has(t.property))return !0}return !!has_annotation(this,_PURE)||!e.pure_funcs(this)})),AST_Node.DEFMETHOD("is_call_pure",return_false),AST_Dot.DEFMETHOD("is_call_pure",(function(e){if(!e.option("unsafe"))return;const t=this.expression;let n;return t instanceof AST_Array?n=native_fns.get("Array"):t.is_boolean()?n=native_fns.get("Boolean"):t.is_number(e)?n=native_fns.get("Number"):t instanceof AST_RegExp?n=native_fns.get("RegExp"):t.is_string(e)?n=native_fns.get("String"):this.may_throw_on_access(e)||(n=native_fns.get("Object")),n&&n.has(this.property)}));const pure_prop_access_globals=new Set(["Number","String","Array","Object","Function","Promise"]);function aborts(e){return e&&e.aborts()}!function(e){function t(e,t){for(var n=e.length;--n>=0;)if(e[n].has_side_effects(t))return !0;return !1}e(AST_Node,return_true),e(AST_EmptyStatement,return_false),e(AST_Constant,return_false),e(AST_This,return_false),e(AST_Block,(function(e){return t(this.body,e)})),e(AST_Call,(function(e){return !(this.is_expr_pure(e)||this.expression.is_call_pure(e)&&!this.expression.has_side_effects(e))||t(this.args,e)})),e(AST_Switch,(function(e){return this.expression.has_side_effects(e)||t(this.body,e)})),e(AST_Case,(function(e){return this.expression.has_side_effects(e)||t(this.body,e)})),e(AST_Try,(function(e){return t(this.body,e)||this.bcatch&&this.bcatch.has_side_effects(e)||this.bfinally&&this.bfinally.has_side_effects(e)})),e(AST_If,(function(e){return this.condition.has_side_effects(e)||this.body&&this.body.has_side_effects(e)||this.alternative&&this.alternative.has_side_effects(e)})),e(AST_LabeledStatement,(function(e){return this.body.has_side_effects(e)})),e(AST_SimpleStatement,(function(e){return this.body.has_side_effects(e)})),e(AST_Lambda,return_false),e(AST_Class,(function(e){return !(!this.extends||!this.extends.has_side_effects(e))||t(this.properties,e)})),e(AST_Binary,(function(e){return this.left.has_side_effects(e)||this.right.has_side_effects(e)})),e(AST_Assign,return_true),e(AST_Conditional,(function(e){return this.condition.has_side_effects(e)||this.consequent.has_side_effects(e)||this.alternative.has_side_effects(e)})),e(AST_Unary,(function(e){return unary_side_effects.has(this.operator)||this.expression.has_side_effects(e)})),e(AST_SymbolRef,(function(e){return !this.is_declared(e)&&!pure_prop_access_globals.has(this.name)})),e(AST_SymbolClassProperty,return_false),e(AST_SymbolDeclaration,return_false),e(AST_Object,(function(e){return t(this.properties,e)})),e(AST_ObjectProperty,(function(e){return this.computed_key()&&this.key.has_side_effects(e)||this.value&&this.value.has_side_effects(e)})),e(AST_ClassProperty,(function(e){return this.computed_key()&&this.key.has_side_effects(e)||this.static&&this.value&&this.value.has_side_effects(e)})),e(AST_ConciseMethod,(function(e){return this.computed_key()&&this.key.has_side_effects(e)})),e(AST_ObjectGetter,(function(e){return this.computed_key()&&this.key.has_side_effects(e)})),e(AST_ObjectSetter,(function(e){return this.computed_key()&&this.key.has_side_effects(e)})),e(AST_Array,(function(e){return t(this.elements,e)})),e(AST_Dot,(function(e){return !this.optional&&this.expression.may_throw_on_access(e)||this.expression.has_side_effects(e)})),e(AST_Sub,(function(e){return (!this.optional||!is_nullish(this.expression))&&(!this.optional&&this.expression.may_throw_on_access(e)||this.expression.has_side_effects(e)||this.property.has_side_effects(e))})),e(AST_Chain,(function(e){return this.expression.has_side_effects(e)})),e(AST_Sequence,(function(e){return t(this.expressions,e)})),e(AST_Definitions,(function(e){return t(this.definitions,e)})),e(AST_VarDef,(function(){return this.value})),e(AST_TemplateSegment,return_false),e(AST_TemplateString,(function(e){return t(this.segments,e)}));}((function(e,t){e.DEFMETHOD("has_side_effects",t);})),function(e){function t(e,t){for(var n=e.length;--n>=0;)if(e[n].may_throw(t))return !0;return !1}e(AST_Node,return_true),e(AST_Constant,return_false),e(AST_EmptyStatement,return_false),e(AST_Lambda,return_false),e(AST_SymbolDeclaration,return_false),e(AST_This,return_false),e(AST_Class,(function(e){return !(!this.extends||!this.extends.may_throw(e))||t(this.properties,e)})),e(AST_Array,(function(e){return t(this.elements,e)})),e(AST_Assign,(function(e){return !!this.right.may_throw(e)||!(!e.has_directive("use strict")&&"="==this.operator&&this.left instanceof AST_SymbolRef)&&this.left.may_throw(e)})),e(AST_Binary,(function(e){return this.left.may_throw(e)||this.right.may_throw(e)})),e(AST_Block,(function(e){return t(this.body,e)})),e(AST_Call,(function(e){return (!this.optional||!is_nullish(this.expression))&&(!!t(this.args,e)||!this.is_expr_pure(e)&&(!!this.expression.may_throw(e)||!(this.expression instanceof AST_Lambda)||t(this.expression.body,e)))})),e(AST_Case,(function(e){return this.expression.may_throw(e)||t(this.body,e)})),e(AST_Conditional,(function(e){return this.condition.may_throw(e)||this.consequent.may_throw(e)||this.alternative.may_throw(e)})),e(AST_Definitions,(function(e){return t(this.definitions,e)})),e(AST_If,(function(e){return this.condition.may_throw(e)||this.body&&this.body.may_throw(e)||this.alternative&&this.alternative.may_throw(e)})),e(AST_LabeledStatement,(function(e){return this.body.may_throw(e)})),e(AST_Object,(function(e){return t(this.properties,e)})),e(AST_ObjectProperty,(function(e){return !!this.value&&this.value.may_throw(e)})),e(AST_ClassProperty,(function(e){return this.computed_key()&&this.key.may_throw(e)||this.static&&this.value&&this.value.may_throw(e)})),e(AST_ConciseMethod,(function(e){return this.computed_key()&&this.key.may_throw(e)})),e(AST_ObjectGetter,(function(e){return this.computed_key()&&this.key.may_throw(e)})),e(AST_ObjectSetter,(function(e){return this.computed_key()&&this.key.may_throw(e)})),e(AST_Return,(function(e){return this.value&&this.value.may_throw(e)})),e(AST_Sequence,(function(e){return t(this.expressions,e)})),e(AST_SimpleStatement,(function(e){return this.body.may_throw(e)})),e(AST_Dot,(function(e){return !this.optional&&this.expression.may_throw_on_access(e)||this.expression.may_throw(e)})),e(AST_Sub,(function(e){return (!this.optional||!is_nullish(this.expression))&&(!this.optional&&this.expression.may_throw_on_access(e)||this.expression.may_throw(e)||this.property.may_throw(e))})),e(AST_Chain,(function(e){return this.expression.may_throw(e)})),e(AST_Switch,(function(e){return this.expression.may_throw(e)||t(this.body,e)})),e(AST_SymbolRef,(function(e){return !this.is_declared(e)&&!pure_prop_access_globals.has(this.name)})),e(AST_SymbolClassProperty,return_false),e(AST_Try,(function(e){return this.bcatch?this.bcatch.may_throw(e):t(this.body,e)||this.bfinally&&this.bfinally.may_throw(e)})),e(AST_Unary,(function(e){return !("typeof"==this.operator&&this.expression instanceof AST_SymbolRef)&&this.expression.may_throw(e)})),e(AST_VarDef,(function(e){return !!this.value&&this.value.may_throw(e)}));}((function(e,t){e.DEFMETHOD("may_throw",t);})),function(e){function t(e){let t=!0;return walk$3(this,(n=>{if(n instanceof AST_SymbolRef){if(has_flag(this,16))return t=!1,walk_abort;var o=n.definition();if(member(o,this.enclosed)&&!this.variables.has(o.name)){if(e){var i=e.find_variable(n);if(o.undeclared?!i:i===o)return t="f",!0}return t=!1,walk_abort}return !0}if(n instanceof AST_This&&this instanceof AST_Arrow)return t=!1,walk_abort})),t}e(AST_Node,return_false),e(AST_Constant,return_true),e(AST_Class,(function(e){if(this.extends&&!this.extends.is_constant_expression(e))return !1;for(const t of this.properties){if(t.computed_key()&&!t.key.is_constant_expression(e))return !1;if(t.static&&t.value&&!t.value.is_constant_expression(e))return !1}return t.call(this,e)})),e(AST_Lambda,t),e(AST_Unary,(function(){return this.expression.is_constant_expression()})),e(AST_Binary,(function(){return this.left.is_constant_expression()&&this.right.is_constant_expression()})),e(AST_Array,(function(){return this.elements.every((e=>e.is_constant_expression()))})),e(AST_Object,(function(){return this.properties.every((e=>e.is_constant_expression()))})),e(AST_ObjectProperty,(function(){return !(this.key instanceof AST_Node||!this.value||!this.value.is_constant_expression())}));}((function(e,t){e.DEFMETHOD("is_constant_expression",t);})),function(e){function t(){for(var e=0;e<this.body.length;e++)if(aborts(this.body[e]))return this.body[e];return null}e(AST_Statement,return_null),e(AST_Jump,return_this),e(AST_Import,(function(){return null})),e(AST_BlockStatement,t),e(AST_SwitchBranch,t),e(AST_If,(function(){return this.alternative&&aborts(this.body)&&aborts(this.alternative)&&this}));}((function(e,t){e.DEFMETHOD("aborts",t);}));var directives=new Set(["use asm","use strict"]);function can_be_extracted_from_if_block(e){return !(e instanceof AST_Const||e instanceof AST_Let||e instanceof AST_Class)}function opt_AST_Lambda(e,t){return tighten_body(e.body,t),t.option("side_effects")&&1==e.body.length&&e.body[0]===t.has_directive("use strict")&&(e.body.length=0),e}def_optimize(AST_Directive,(function(e,t){return !t.option("directives")||directives.has(e.value)&&t.has_directive(e.value)===e?e:make_node(AST_EmptyStatement,e)})),def_optimize(AST_Debugger,(function(e,t){return t.option("drop_debugger")?make_node(AST_EmptyStatement,e):e})),def_optimize(AST_LabeledStatement,(function(e,t){return e.body instanceof AST_Break&&t.loopcontrol_target(e.body)===e.body?make_node(AST_EmptyStatement,e):0==e.label.references.length?e.body:e})),def_optimize(AST_Block,(function(e,t){return tighten_body(e.body,t),e})),def_optimize(AST_BlockStatement,(function(e,t){switch(tighten_body(e.body,t),e.body.length){case 1:if(!t.has_directive("use strict")&&t.parent()instanceof AST_If&&can_be_extracted_from_if_block(e.body[0])||can_be_evicted_from_block(e.body[0]))return e.body[0];break;case 0:return make_node(AST_EmptyStatement,e)}return e})),def_optimize(AST_Lambda,opt_AST_Lambda);const r_keep_assign=/keep_assign/;function has_break_or_continue(e,t){var n=!1,o=new TreeWalker((function(t){return !!(n||t instanceof AST_Scope)||(t instanceof AST_LoopControl&&o.loopcontrol_target(t)===e?n=!0:void 0)}));return t instanceof AST_LabeledStatement&&o.push(t),o.push(e),e.body.walk(o),n}function if_break_in_loop(e,t){var n=e.body instanceof AST_BlockStatement?e.body.body[0]:e.body;if(t.option("dead_code")&&i(n)){var o=[];return e.init instanceof AST_Statement?o.push(e.init):e.init&&o.push(make_node(AST_SimpleStatement,e.init,{body:e.init})),e.condition&&o.push(make_node(AST_SimpleStatement,e.condition,{body:e.condition})),trim_unreachable_code(t,e.body,o),make_node(AST_BlockStatement,e,{body:o})}return n instanceof AST_If&&(i(n.body)?(e.condition?e.condition=make_node(AST_Binary,e.condition,{left:e.condition,operator:"&&",right:n.condition.negate(t)}):e.condition=n.condition.negate(t),r(n.alternative)):i(n.alternative)&&(e.condition?e.condition=make_node(AST_Binary,e.condition,{left:e.condition,operator:"&&",right:n.condition}):e.condition=n.condition,r(n.body))),e;function i(e){return e instanceof AST_Break&&t.loopcontrol_target(e)===t.self()}function r(n){n=as_statement_array(n),e.body instanceof AST_BlockStatement?(e.body=e.body.clone(),e.body.body=n.concat(e.body.body.slice(1)),e.body=e.body.transform(t)):e.body=make_node(AST_BlockStatement,e.body,{body:n}).transform(t),e=if_break_in_loop(e,t);}}function retain_top_func(e,t){return t.top_retain&&e instanceof AST_Defun&&has_flag(e,TOP)&&e.name&&t.top_retain(e.name)}AST_Scope.DEFMETHOD("drop_unused",(function(e){if(!e.option("unused"))return;if(e.has_directive("use asm"))return;var t=this;if(t.pinned())return;var n=!(t instanceof AST_Toplevel)||e.toplevel.funcs,o=!(t instanceof AST_Toplevel)||e.toplevel.vars;const i=r_keep_assign.test(e.option("unused"))?return_false:function(e){return e instanceof AST_Assign&&!e.logical&&(has_flag(e,32)||"="==e.operator)?e.left:e instanceof AST_Unary&&has_flag(e,32)?e.expression:void 0};var r=new Map,a=new Map;t instanceof AST_Toplevel&&e.top_retain&&t.variables.forEach((function(t){e.top_retain(t)&&!r.has(t.id)&&r.set(t.id,t);}));var s=new Map,u=new Map,l=this,_=new TreeWalker((function(i,c){if(i instanceof AST_Lambda&&i.uses_arguments&&!_.has_directive("use strict")&&i.argnames.forEach((function(e){if(e instanceof AST_SymbolDeclaration){var t=e.definition();r.has(t.id)||r.set(t.id,t);}})),i!==t){if(i instanceof AST_Defun||i instanceof AST_DefClass){var p=i.name.definition();if((_.parent()instanceof AST_Export||!n&&l===t)&&p.global&&!r.has(p.id)&&r.set(p.id,p),i instanceof AST_DefClass){i.extends&&(i.extends.has_side_effects(e)||i.extends.may_throw(e))&&i.extends.walk(_);for(const t of i.properties)(t.has_side_effects(e)||t.may_throw(e))&&t.walk(_);}return map_add(u,p.id,i),!0}if(i instanceof AST_SymbolFunarg&&l===t&&map_add(s,i.definition().id,i),i instanceof AST_Definitions&&l===t){const t=_.parent()instanceof AST_Export;return i.definitions.forEach((function(n){if(n.name instanceof AST_SymbolVar&&map_add(s,n.name.definition().id,n),!t&&o||walk$3(n.name,(e=>{if(e instanceof AST_SymbolDeclaration){const n=e.definition();!t&&!n.global||r.has(n.id)||r.set(n.id,n);}})),n.value){if(n.name instanceof AST_Destructuring)n.walk(_);else {var i=n.name.definition();map_add(u,i.id,n.value),i.chained||n.name.fixed_value()!==n.value||a.set(i.id,n);}n.value.has_side_effects(e)&&n.value.walk(_);}})),!0}return f(i,c)}}));t.walk(_),_=new TreeWalker(f),r.forEach((function(e){var t=u.get(e.id);t&&t.forEach((function(e){e.walk(_);}));}));var c=new TreeTransformer((function(u,_,f){var p=c.parent();if(o){const e=i(u);if(e instanceof AST_SymbolRef){var d=e.definition(),S=r.has(d.id);if(u instanceof AST_Assign){if(!S||a.has(d.id)&&a.get(d.id)!==u)return maintain_this_binding(p,u,u.right.transform(c))}else if(!S)return f?MAP.skip:make_node(AST_Number,u,{value:0})}}if(l===t){if(u.name&&(u instanceof AST_ClassExpression&&!keep_name(e.option("keep_classnames"),(d=u.name.definition()).name)||u instanceof AST_Function&&!keep_name(e.option("keep_fnames"),(d=u.name.definition()).name))&&(!r.has(d.id)||d.orig.length>1)&&(u.name=null),u instanceof AST_Lambda&&!(u instanceof AST_Accessor))for(var m=!e.option("keep_fargs"),A=u.argnames,T=A.length;--T>=0;){var h=A[T];h instanceof AST_Expansion&&(h=h.expression),h instanceof AST_DefaultAssign&&(h=h.left),h instanceof AST_Destructuring||r.has(h.definition().id)?m=!1:(set_flag(h,1),m&&A.pop());}if((u instanceof AST_Defun||u instanceof AST_DefClass)&&u!==t){const t=u.name.definition();if(!(t.global&&!n||r.has(t.id))){if(t.eliminated++,u instanceof AST_DefClass){const t=u.drop_side_effect_free(e);if(t)return make_node(AST_SimpleStatement,u,{body:t})}return f?MAP.skip:make_node(AST_EmptyStatement,u)}}if(u instanceof AST_Definitions&&!(p instanceof AST_ForIn&&p.init===u)){var E=!(p instanceof AST_Toplevel||u instanceof AST_Var),g=[],D=[],b=[],y=[];switch(u.definitions.forEach((function(t){t.value&&(t.value=t.value.transform(c));var n=t.name instanceof AST_Destructuring,i=n?new SymbolDef(null,{name:"<destructure>"}):t.name.definition();if(E&&i.global)return b.push(t);if(!o&&!E||n&&(t.name.names.length||t.name.is_array||1!=e.option("pure_getters"))||r.has(i.id)){if(t.value&&a.has(i.id)&&a.get(i.id)!==t&&(t.value=t.value.drop_side_effect_free(e)),t.name instanceof AST_SymbolVar){var l=s.get(i.id);if(l.length>1&&(!t.value||i.orig.indexOf(t.name)>i.eliminated)){if(t.value){var _=make_node(AST_SymbolRef,t.name,t.name);i.references.push(_);var f=make_node(AST_Assign,t,{operator:"=",logical:!1,left:_,right:t.value});a.get(i.id)===t&&a.set(i.id,f),y.push(f.transform(c));}return remove$1(l,t),void i.eliminated++}}t.value?(y.length>0&&(b.length>0?(y.push(t.value),t.value=make_sequence(t.value,y)):g.push(make_node(AST_SimpleStatement,u,{body:make_sequence(u,y)})),y=[]),b.push(t)):D.push(t);}else if(i.orig[0]instanceof AST_SymbolCatch)(p=t.value&&t.value.drop_side_effect_free(e))&&y.push(p),t.value=null,D.push(t);else {var p;(p=t.value&&t.value.drop_side_effect_free(e))&&y.push(p),i.eliminated++;}})),(D.length>0||b.length>0)&&(u.definitions=D.concat(b),g.push(u)),y.length>0&&g.push(make_node(AST_SimpleStatement,u,{body:make_sequence(u,y)})),g.length){case 0:return f?MAP.skip:make_node(AST_EmptyStatement,u);case 1:return g[0];default:return f?MAP.splice(g):make_node(AST_BlockStatement,u,{body:g})}}if(u instanceof AST_For)return _(u,this),u.init instanceof AST_BlockStatement&&(v=u.init,u.init=v.body.pop(),v.body.push(u)),u.init instanceof AST_SimpleStatement?u.init=u.init.body:is_empty(u.init)&&(u.init=null),v?f?MAP.splice(v.body):v:u;if(u instanceof AST_LabeledStatement&&u.body instanceof AST_For){if(_(u,this),u.body instanceof AST_BlockStatement){var v=u.body;return u.body=v.body.pop(),v.body.push(u),f?MAP.splice(v.body):v}return u}if(u instanceof AST_BlockStatement)return _(u,this),f&&u.body.every(can_be_evicted_from_block)?MAP.splice(u.body):u;if(u instanceof AST_Scope){const e=l;return l=u,_(u,this),l=e,u}}}));function f(e,n){var o;const s=i(e);if(s instanceof AST_SymbolRef&&!is_ref_of(e.left,AST_SymbolBlockDeclaration)&&t.variables.get(s.name)===(o=s.definition()))return e instanceof AST_Assign&&(e.right.walk(_),o.chained||e.left.fixed_value()!==e.right||a.set(o.id,e)),!0;if(e instanceof AST_SymbolRef){if(o=e.definition(),!r.has(o.id)&&(r.set(o.id,o),o.orig[0]instanceof AST_SymbolCatch)){const e=o.scope.is_block_scope()&&o.scope.get_defun_scope().variables.get(o.name);e&&r.set(e.id,e);}return !0}if(e instanceof AST_Scope){var u=l;return l=e,n(),l=u,!0}}t.transform(c);})),AST_Scope.DEFMETHOD("hoist_declarations",(function(e){var t=this;if(e.has_directive("use asm"))return t;if(!Array.isArray(t.body))return t;var n=e.option("hoist_funs"),o=e.option("hoist_vars");if(n||o){var i=[],r=[],a=new Map,s=0,u=0;walk$3(t,(e=>e instanceof AST_Scope&&e!==t||(e instanceof AST_Var?(++u,!0):void 0))),o=o&&u>1;var l=new TreeTransformer((function(u){if(u!==t){if(u instanceof AST_Directive)return i.push(u),make_node(AST_EmptyStatement,u);if(n&&u instanceof AST_Defun&&!(l.parent()instanceof AST_Export)&&l.parent()===t)return r.push(u),make_node(AST_EmptyStatement,u);if(o&&u instanceof AST_Var&&!u.definitions.some((e=>e.name instanceof AST_Destructuring))){u.definitions.forEach((function(e){a.set(e.name.name,e),++s;}));var _=u.to_assignments(e),c=l.parent();if(c instanceof AST_ForIn&&c.init===u){if(null==_){var f=u.definitions[0].name;return make_node(AST_SymbolRef,f,f)}return _}return c instanceof AST_For&&c.init===u?_:_?make_node(AST_SimpleStatement,u,{body:_}):make_node(AST_EmptyStatement,u)}if(u instanceof AST_Scope)return u}}));if(t=t.transform(l),s>0){var _=[];const e=t instanceof AST_Lambda,n=e?t.args_as_names():null;if(a.forEach(((t,o)=>{e&&n.some((e=>e.name===t.name.name))?a.delete(o):((t=t.clone()).value=null,_.push(t),a.set(o,t));})),_.length>0){for(;0<t.body.length;){if(t.body[0]instanceof AST_SimpleStatement){var c,f,p=t.body[0].body;if(p instanceof AST_Assign&&"="==p.operator&&(c=p.left)instanceof AST_Symbol&&a.has(c.name)){if((d=a.get(c.name)).value)break;d.value=p.right,remove$1(_,d),_.push(d),t.body.splice(0,1);continue}if(p instanceof AST_Sequence&&(f=p.expressions[0])instanceof AST_Assign&&"="==f.operator&&(c=f.left)instanceof AST_Symbol&&a.has(c.name)){var d;if((d=a.get(c.name)).value)break;d.value=f.right,remove$1(_,d),_.push(d),t.body[0].body=make_sequence(p,p.expressions.slice(1));continue}}if(t.body[0]instanceof AST_EmptyStatement)t.body.splice(0,1);else {if(!(t.body[0]instanceof AST_BlockStatement))break;t.body.splice(0,1,...t.body[0].body);}}_=make_node(AST_Var,t,{definitions:_}),r.push(_);}}t.body=i.concat(r,t.body);}return t})),AST_Scope.DEFMETHOD("hoist_properties",(function(e){var t=this;if(!e.option("hoist_props")||e.has_directive("use asm"))return t;var n=t instanceof AST_Toplevel&&e.top_retain||return_false,o=new Map,i=new TreeTransformer((function(r,a){if(r instanceof AST_Definitions&&i.parent()instanceof AST_Export)return r;if(r instanceof AST_VarDef){const s=r.name;let u,l;if(s.scope===t&&1!=(u=s.definition()).escaped&&!u.assignments&&!u.direct_access&&!u.single_use&&!e.exposed(u)&&!n(u)&&(l=s.fixed_value())===r.value&&l instanceof AST_Object&&!l.properties.some((e=>e instanceof AST_Expansion||e.computed_key()))){a(r,this);const e=new Map,n=[];return l.properties.forEach((({key:o,value:a})=>{const u=find_scope(i),l=t.create_symbol(s.CTOR,{source:s,scope:u,conflict_scopes:new Set([u,...s.definition().references.map((e=>e.scope))]),tentative_name:s.name+"_"+o});e.set(String(o),l.definition()),n.push(make_node(AST_VarDef,r,{name:l,value:a}));})),o.set(u.id,e),MAP.splice(n)}}else if(r instanceof AST_PropAccess&&r.expression instanceof AST_SymbolRef){const e=o.get(r.expression.definition().id);if(e){const t=e.get(String(get_value(r.property))),n=make_node(AST_SymbolRef,r,{name:t.name,scope:r.expression.scope,thedef:t});return n.reference({}),n}}}));return t.transform(i)})),function(e){function t(e,t,n){var o=e.length;if(!o)return null;for(var i=[],r=!1,a=0;a<o;a++){var s=e[a].drop_side_effect_free(t,n);r|=s!==e[a],s&&(i.push(s),n=!1);}return r?i.length?i:null:e}e(AST_Node,return_this),e(AST_Constant,return_null),e(AST_This,return_null),e(AST_Call,(function(e,n){if(this.optional&&is_nullish(this.expression))return make_node(AST_Undefined,this);if(!this.is_expr_pure(e)){if(this.expression.is_call_pure(e)){var o=this.args.slice();return o.unshift(this.expression.expression),(o=t(o,e,n))&&make_sequence(this,o)}if(is_func_expr(this.expression)&&(!this.expression.name||!this.expression.name.definition().references.length)){var i=this.clone();return i.expression.process_expression(!1,e),i}return this}var r=t(this.args,e,n);return r&&make_sequence(this,r)})),e(AST_Accessor,return_null),e(AST_Function,return_null),e(AST_Arrow,return_null),e(AST_Class,(function(e){const t=[],n=this.extends&&this.extends.drop_side_effect_free(e);n&&t.push(n);for(const n of this.properties){const o=n.drop_side_effect_free(e);o&&t.push(o);}return t.length?make_sequence(this,t):null})),e(AST_Binary,(function(e,t){var n=this.right.drop_side_effect_free(e);if(!n)return this.left.drop_side_effect_free(e,t);if(lazy_op.has(this.operator)){if(n===this.right)return this;var o=this.clone();return o.right=n,o}var i=this.left.drop_side_effect_free(e,t);return i?make_sequence(this,[i,n]):this.right.drop_side_effect_free(e,t)})),e(AST_Assign,(function(e){if(this.logical)return this;var t=this.left;if(t.has_side_effects(e)||e.has_directive("use strict")&&t instanceof AST_PropAccess&&t.expression.is_constant())return this;for(set_flag(this,32);t instanceof AST_PropAccess;)t=t.expression;return t.is_constant_expression(e.find_parent(AST_Scope))?this.right.drop_side_effect_free(e):this})),e(AST_Conditional,(function(e){var t=this.consequent.drop_side_effect_free(e),n=this.alternative.drop_side_effect_free(e);if(t===this.consequent&&n===this.alternative)return this;if(!t)return n?make_node(AST_Binary,this,{operator:"||",left:this.condition,right:n}):this.condition.drop_side_effect_free(e);if(!n)return make_node(AST_Binary,this,{operator:"&&",left:this.condition,right:t});var o=this.clone();return o.consequent=t,o.alternative=n,o})),e(AST_Unary,(function(e,t){if(unary_side_effects.has(this.operator))return this.expression.has_side_effects(e)?clear_flag(this,32):set_flag(this,32),this;if("typeof"==this.operator&&this.expression instanceof AST_SymbolRef)return null;var n=this.expression.drop_side_effect_free(e,t);return t&&n&&is_iife_call(n)?n===this.expression&&"!"==this.operator?this:n.negate(e,t):n})),e(AST_SymbolRef,(function(e){return this.is_declared(e)||pure_prop_access_globals.has(this.name)?null:this})),e(AST_Object,(function(e,n){var o=t(this.properties,e,n);return o&&make_sequence(this,o)})),e(AST_ObjectProperty,(function(e,t){const n=this instanceof AST_ObjectKeyVal&&this.key instanceof AST_Node&&this.key.drop_side_effect_free(e,t),o=this.value&&this.value.drop_side_effect_free(e,t);return n&&o?make_sequence(this,[n,o]):n||o})),e(AST_ClassProperty,(function(e){const t=this.computed_key()&&this.key.drop_side_effect_free(e),n=this.static&&this.value&&this.value.drop_side_effect_free(e);return t&&n?make_sequence(this,[t,n]):t||n||null})),e(AST_ConciseMethod,(function(){return this.computed_key()?this.key:null})),e(AST_ObjectGetter,(function(){return this.computed_key()?this.key:null})),e(AST_ObjectSetter,(function(){return this.computed_key()?this.key:null})),e(AST_Array,(function(e,n){var o=t(this.elements,e,n);return o&&make_sequence(this,o)})),e(AST_Dot,(function(e,t){return this.optional?is_nullish(this.expression)?make_node(AST_Undefined,this):this:this.expression.may_throw_on_access(e)?this:this.expression.drop_side_effect_free(e,t)})),e(AST_Sub,(function(e,t){if(this.optional)return is_nullish(this.expression)?make_node(AST_Undefined,this):this;if(this.expression.may_throw_on_access(e))return this;var n=this.expression.drop_side_effect_free(e,t);if(!n)return this.property.drop_side_effect_free(e,t);var o=this.property.drop_side_effect_free(e);return o?make_sequence(this,[n,o]):n})),e(AST_Chain,(function(e,t){return this.expression.drop_side_effect_free(e,t)})),e(AST_Sequence,(function(e){var t=this.tail_node(),n=t.drop_side_effect_free(e);if(n===t)return this;var o=this.expressions.slice(0,-1);return n&&o.push(n),o.length?make_sequence(this,o):make_node(AST_Number,this,{value:0})})),e(AST_Expansion,(function(e,t){return this.expression.drop_side_effect_free(e,t)})),e(AST_TemplateSegment,return_null),e(AST_TemplateString,(function(e){var n=t(this.segments,e,first_in_statement);return n&&make_sequence(this,n)}));}((function(e,t){e.DEFMETHOD("drop_side_effect_free",t);})),def_optimize(AST_SimpleStatement,(function(e,t){if(t.option("side_effects")){var n=e.body,o=n.drop_side_effect_free(t,!0);if(!o)return make_node(AST_EmptyStatement,e);if(o!==n)return make_node(AST_SimpleStatement,e,{body:o})}return e})),def_optimize(AST_While,(function(e,t){return t.option("loops")?make_node(AST_For,e,e).optimize(t):e})),def_optimize(AST_Do,(function(e,t){if(!t.option("loops"))return e;var n=e.condition.tail_node().evaluate(t);if(!(n instanceof AST_Node)){if(n)return make_node(AST_For,e,{body:make_node(AST_BlockStatement,e.body,{body:[e.body,make_node(AST_SimpleStatement,e.condition,{body:e.condition})]})}).optimize(t);if(!has_break_or_continue(e,t.parent()))return make_node(AST_BlockStatement,e.body,{body:[e.body,make_node(AST_SimpleStatement,e.condition,{body:e.condition})]}).optimize(t)}return e})),def_optimize(AST_For,(function(e,t){if(!t.option("loops"))return e;if(t.option("side_effects")&&e.init&&(e.init=e.init.drop_side_effect_free(t)),e.condition){var n=e.condition.evaluate(t);if(!(n instanceof AST_Node))if(n)e.condition=null;else if(!t.option("dead_code")){var o=e.condition;e.condition=make_node_from_constant(n,e.condition),e.condition=best_of_expression(e.condition.transform(t),o);}if(t.option("dead_code")&&(n instanceof AST_Node&&(n=e.condition.tail_node().evaluate(t)),!n)){var i=[];return trim_unreachable_code(t,e.body,i),e.init instanceof AST_Statement?i.push(e.init):e.init&&i.push(make_node(AST_SimpleStatement,e.init,{body:e.init})),i.push(make_node(AST_SimpleStatement,e.condition,{body:e.condition})),make_node(AST_BlockStatement,e,{body:i}).optimize(t)}}return if_break_in_loop(e,t)})),def_optimize(AST_If,(function(e,t){if(is_empty(e.alternative)&&(e.alternative=null),!t.option("conditionals"))return e;var n=e.condition.evaluate(t);if(!(t.option("dead_code")||n instanceof AST_Node)){var o=e.condition;e.condition=make_node_from_constant(n,o),e.condition=best_of_expression(e.condition.transform(t),o);}if(t.option("dead_code")){if(n instanceof AST_Node&&(n=e.condition.tail_node().evaluate(t)),!n){var i=[];return trim_unreachable_code(t,e.body,i),i.push(make_node(AST_SimpleStatement,e.condition,{body:e.condition})),e.alternative&&i.push(e.alternative),make_node(AST_BlockStatement,e,{body:i}).optimize(t)}if(!(n instanceof AST_Node))return (i=[]).push(make_node(AST_SimpleStatement,e.condition,{body:e.condition})),i.push(e.body),e.alternative&&trim_unreachable_code(t,e.alternative,i),make_node(AST_BlockStatement,e,{body:i}).optimize(t)}var r=e.condition.negate(t),a=e.condition.size(),s=r.size(),u=s<a;if(e.alternative&&u){u=!1,e.condition=r;var l=e.body;e.body=e.alternative||make_node(AST_EmptyStatement,e),e.alternative=l;}if(is_empty(e.body)&&is_empty(e.alternative))return make_node(AST_SimpleStatement,e.condition,{body:e.condition.clone()}).optimize(t);if(e.body instanceof AST_SimpleStatement&&e.alternative instanceof AST_SimpleStatement)return make_node(AST_SimpleStatement,e,{body:make_node(AST_Conditional,e,{condition:e.condition,consequent:e.body.body,alternative:e.alternative.body})}).optimize(t);if(is_empty(e.alternative)&&e.body instanceof AST_SimpleStatement)return a===s&&!u&&e.condition instanceof AST_Binary&&"||"==e.condition.operator&&(u=!0),u?make_node(AST_SimpleStatement,e,{body:make_node(AST_Binary,e,{operator:"||",left:r,right:e.body.body})}).optimize(t):make_node(AST_SimpleStatement,e,{body:make_node(AST_Binary,e,{operator:"&&",left:e.condition,right:e.body.body})}).optimize(t);if(e.body instanceof AST_EmptyStatement&&e.alternative instanceof AST_SimpleStatement)return make_node(AST_SimpleStatement,e,{body:make_node(AST_Binary,e,{operator:"||",left:e.condition,right:e.alternative.body})}).optimize(t);if(e.body instanceof AST_Exit&&e.alternative instanceof AST_Exit&&e.body.TYPE==e.alternative.TYPE)return make_node(e.body.CTOR,e,{value:make_node(AST_Conditional,e,{condition:e.condition,consequent:e.body.value||make_node(AST_Undefined,e.body),alternative:e.alternative.value||make_node(AST_Undefined,e.alternative)}).transform(t)}).optimize(t);if(e.body instanceof AST_If&&!e.body.alternative&&!e.alternative&&(e=make_node(AST_If,e,{condition:make_node(AST_Binary,e.condition,{operator:"&&",left:e.condition,right:e.body.condition}),body:e.body.body,alternative:null})),aborts(e.body)&&e.alternative){var _=e.alternative;return e.alternative=null,make_node(AST_BlockStatement,e,{body:[e,_]}).optimize(t)}return aborts(e.alternative)?(i=e.body,e.body=e.alternative,e.condition=u?r:e.condition.negate(t),e.alternative=null,make_node(AST_BlockStatement,e,{body:[e,i]}).optimize(t)):e})),def_optimize(AST_Switch,(function(e,t){if(!t.option("switches"))return e;var n,o=e.expression.evaluate(t);if(!(o instanceof AST_Node)){var i=e.expression;e.expression=make_node_from_constant(o,i),e.expression=best_of_expression(e.expression.transform(t),i);}if(!t.option("dead_code"))return e;o instanceof AST_Node&&(o=e.expression.tail_node().evaluate(t));for(var r,a,s=[],u=[],l=0,_=e.body.length;l<_&&!a;l++){if((n=e.body[l])instanceof AST_Default)r?T(n,u[u.length-1]):r=n;else if(!(o instanceof AST_Node)){if(!((m=n.expression.evaluate(t))instanceof AST_Node)&&m!==o){T(n,u[u.length-1]);continue}if(m instanceof AST_Node&&(m=n.expression.tail_node().evaluate(t)),m===o&&(a=n,r)){var c=u.indexOf(r);u.splice(c,1),T(r,u[c-1]),r=null;}}if(aborts(n)){var f=u[u.length-1];aborts(f)&&f.body.length==n.body.length&&make_node(AST_BlockStatement,f,f).equivalent_to(make_node(AST_BlockStatement,n,n))&&(f.body=[]);}u.push(n);}for(;l<_;)T(e.body[l++],u[u.length-1]);for(u.length>0&&(u[0].body=s.concat(u[0].body)),e.body=u;n=u[u.length-1];){var p=n.body[n.body.length-1];if(p instanceof AST_Break&&t.loopcontrol_target(p)===e&&n.body.pop(),n.body.length||n instanceof AST_Case&&(r||n.expression.has_side_effects(t)))break;u.pop()===r&&(r=null);}if(0==u.length)return make_node(AST_BlockStatement,e,{body:s.concat(make_node(AST_SimpleStatement,e.expression,{body:e.expression}))}).optimize(t);if(1==u.length&&(u[0]===a||u[0]===r)){var d=!1,S=new TreeWalker((function(t){if(d||t instanceof AST_Lambda||t instanceof AST_SimpleStatement)return !0;t instanceof AST_Break&&S.loopcontrol_target(t)===e&&(d=!0);}));if(e.walk(S),!d){var m,A=u[0].body.slice();return (m=u[0].expression)&&A.unshift(make_node(AST_SimpleStatement,m,{body:m})),A.unshift(make_node(AST_SimpleStatement,e.expression,{body:e.expression})),make_node(AST_BlockStatement,e,{body:A}).optimize(t)}}return e;function T(e,n){n&&!aborts(n)?n.body=n.body.concat(e.body):trim_unreachable_code(t,e,s);}})),def_optimize(AST_Try,(function(e,t){if(tighten_body(e.body,t),e.bcatch&&e.bfinally&&e.bfinally.body.every(is_empty)&&(e.bfinally=null),t.option("dead_code")&&e.body.every(is_empty)){var n=[];return e.bcatch&&trim_unreachable_code(t,e.bcatch,n),e.bfinally&&n.push(...e.bfinally.body),make_node(AST_BlockStatement,e,{body:n}).optimize(t)}return e})),AST_Definitions.DEFMETHOD("remove_initializers",(function(){var e=[];this.definitions.forEach((function(t){t.name instanceof AST_SymbolDeclaration?(t.value=null,e.push(t)):walk$3(t.name,(n=>{n instanceof AST_SymbolDeclaration&&e.push(make_node(AST_VarDef,t,{name:n,value:null}));}));})),this.definitions=e;})),AST_Definitions.DEFMETHOD("to_assignments",(function(e){var t=e.option("reduce_vars"),n=[];for(const e of this.definitions){if(e.value){var o=make_node(AST_SymbolRef,e.name,e.name);n.push(make_node(AST_Assign,e,{operator:"=",logical:!1,left:o,right:e.value})),t&&(o.definition().fixed=!1);}else if(e.value){var i=make_node(AST_VarDef,e,{name:e.name,value:e.value}),r=make_node(AST_Var,e,{definitions:[i]});n.push(r);}const a=e.name.definition();a.eliminated++,a.replaced--;}return 0==n.length?null:make_sequence(this,n)})),def_optimize(AST_Definitions,(function(e){return 0==e.definitions.length?make_node(AST_EmptyStatement,e):e})),def_optimize(AST_VarDef,(function(e){return e.name instanceof AST_SymbolLet&&null!=e.value&&is_undefined(e.value)&&(e.value=null),e})),def_optimize(AST_Import,(function(e){return e})),def_optimize(AST_Call,(function(e,t){var n=e.expression,o=n;inline_array_like_spread(e.args);var i=e.args.every((e=>!(e instanceof AST_Expansion)));if(t.option("reduce_vars")&&o instanceof AST_SymbolRef&&!has_annotation(e,_NOINLINE)){const e=o.fixed_value();retain_top_func(e,t)||(o=e);}if(e.optional&&is_nullish(o))return make_node(AST_Undefined,e);var r=o instanceof AST_Lambda;if(r&&o.pinned())return e;if(t.option("unused")&&i&&r&&!o.uses_arguments){for(var a=0,s=0,u=0,l=e.args.length;u<l;u++){if(o.argnames[u]instanceof AST_Expansion){if(has_flag(o.argnames[u].expression,1))for(;u<l;)(d=e.args[u++].drop_side_effect_free(t))&&(e.args[a++]=d);else for(;u<l;)e.args[a++]=e.args[u++];s=a;break}var _=u>=o.argnames.length;if(_||has_flag(o.argnames[u],1)){if(d=e.args[u].drop_side_effect_free(t))e.args[a++]=d;else if(!_){e.args[a++]=make_node(AST_Number,e.args[u],{value:0});continue}}else e.args[a++]=e.args[u];s=a;}e.args.length=s;}if(t.option("unsafe"))if(is_undeclared_ref(n))switch(n.name){case"Array":if(1!=e.args.length)return make_node(AST_Array,e,{elements:e.args}).optimize(t);if(e.args[0]instanceof AST_Number&&e.args[0].value<=11){const t=[];for(let n=0;n<e.args[0].value;n++)t.push(new AST_Hole);return new AST_Array({elements:t})}break;case"Object":if(0==e.args.length)return make_node(AST_Object,e,{properties:[]});break;case"String":if(0==e.args.length)return make_node(AST_String,e,{value:""});if(e.args.length<=1)return make_node(AST_Binary,e,{left:e.args[0],operator:"+",right:make_node(AST_String,e,{value:""})}).optimize(t);break;case"Number":if(0==e.args.length)return make_node(AST_Number,e,{value:0});if(1==e.args.length&&t.option("unsafe_math"))return make_node(AST_UnaryPrefix,e,{expression:e.args[0],operator:"+"}).optimize(t);break;case"Symbol":1==e.args.length&&e.args[0]instanceof AST_String&&t.option("unsafe_symbols")&&(e.args.length=0);break;case"Boolean":if(0==e.args.length)return make_node(AST_False,e);if(1==e.args.length)return make_node(AST_UnaryPrefix,e,{expression:make_node(AST_UnaryPrefix,e,{expression:e.args[0],operator:"!"}),operator:"!"}).optimize(t);break;case"RegExp":var c=[];if(e.args.length>=1&&e.args.length<=2&&e.args.every((e=>{var n=e.evaluate(t);return c.push(n),e!==n}))){let[n,o]=c;n=regexp_source_fix(new RegExp(n).source);const i=make_node(AST_RegExp,e,{value:{source:n,flags:o}});if(i._eval(t)!==i)return i}}else if(n instanceof AST_Dot)switch(n.property){case"toString":if(0==e.args.length&&!n.expression.may_throw_on_access(t))return make_node(AST_Binary,e,{left:make_node(AST_String,e,{value:""}),operator:"+",right:n.expression}).optimize(t);break;case"join":if(n.expression instanceof AST_Array)e:{var f;if(!(e.args.length>0&&(f=e.args[0].evaluate(t))===e.args[0])){var p,d,S=[],m=[];for(u=0,l=n.expression.elements.length;u<l;u++){var A=n.expression.elements[u];if(A instanceof AST_Expansion)break e;var T=A.evaluate(t);T!==A?m.push(T):(m.length>0&&(S.push(make_node(AST_String,e,{value:m.join(f)})),m.length=0),S.push(A));}return m.length>0&&S.push(make_node(AST_String,e,{value:m.join(f)})),0==S.length?make_node(AST_String,e,{value:""}):1==S.length?S[0].is_string(t)?S[0]:make_node(AST_Binary,S[0],{operator:"+",left:make_node(AST_String,e,{value:""}),right:S[0]}):""==f?(p=S[0].is_string(t)||S[1].is_string(t)?S.shift():make_node(AST_String,e,{value:""}),S.reduce((function(e,t){return make_node(AST_Binary,t,{operator:"+",left:e,right:t})}),p).optimize(t)):((d=e.clone()).expression=d.expression.clone(),d.expression.expression=d.expression.expression.clone(),d.expression.expression.elements=S,best_of(t,e,d))}}break;case"charAt":if(n.expression.is_string(t)){var h=e.args[0],E=h?h.evaluate(t):0;if(E!==h)return make_node(AST_Sub,n,{expression:n.expression,property:make_node_from_constant(0|E,h||n)}).optimize(t)}break;case"apply":if(2==e.args.length&&e.args[1]instanceof AST_Array)return (I=e.args[1].elements.slice()).unshift(e.args[0]),make_node(AST_Call,e,{expression:make_node(AST_Dot,n,{expression:n.expression,optional:!1,property:"call"}),args:I}).optimize(t);break;case"call":var g=n.expression;if(g instanceof AST_SymbolRef&&(g=g.fixed_value()),g instanceof AST_Lambda&&!g.contains_this())return (e.args.length?make_sequence(this,[e.args[0],make_node(AST_Call,e,{expression:n.expression,args:e.args.slice(1)})]):make_node(AST_Call,e,{expression:n.expression,args:[]})).optimize(t)}if(t.option("unsafe_Function")&&is_undeclared_ref(n)&&"Function"==n.name){if(0==e.args.length)return make_node(AST_Function,e,{argnames:[],body:[]}).optimize(t);if(e.args.every((e=>e instanceof AST_String)))try{var D=parse$5(C="n(function("+e.args.slice(0,-1).map((function(e){return e.value})).join(",")+"){"+e.args[e.args.length-1].value+"})"),b={ie8:t.option("ie8")};D.figure_out_scope(b);var y,v=new Compressor(t.options,{mangle_options:t.mangle_options});(D=D.transform(v)).figure_out_scope(b),base54.reset(),D.compute_char_frequency(b),D.mangle_names(b),walk$3(D,(e=>{if(is_func_expr(e))return y=e,walk_abort}));var C=OutputStream();return AST_BlockStatement.prototype._codegen.call(y,y,C),e.args=[make_node(AST_String,e,{value:y.argnames.map((function(e){return e.print_to_string()})).join(",")}),make_node(AST_String,e.args[e.args.length-1],{value:C.get().replace(/^{|}$/g,"")})],e}catch(e){if(!(e instanceof JS_Parse_Error))throw e}}var R=r&&o.body[0],k=r&&!o.is_generator&&!o.async,O=k&&t.option("inline")&&!e.is_expr_pure(t);if(O&&R instanceof AST_Return){let n=R.value;if(!n||n.is_constant_expression()){n=n?n.clone(!0):make_node(AST_Undefined,e);const o=e.args.concat(n);return make_sequence(e,o).optimize(t)}if(1===o.argnames.length&&o.argnames[0]instanceof AST_SymbolFunarg&&e.args.length<2&&n instanceof AST_SymbolRef&&n.name===o.argnames[0].name){const n=(e.args[0]||make_node(AST_Undefined)).optimize(t);let o;return n instanceof AST_PropAccess&&(o=t.parent())instanceof AST_Call&&o.expression===e?make_sequence(e,[make_node(AST_Number,e,{value:0}),n]):n}}if(O){var F,N,M=-1;let r,a,s;if(i&&!o.uses_arguments&&!(t.parent()instanceof AST_Class)&&!(o.name&&o instanceof AST_Function)&&(a=function(e){var n=o.body,i=n.length;if(t.option("inline")<3)return 1==i&&w(e);e=null;for(var r=0;r<i;r++){var a=n[r];if(a instanceof AST_Var){if(e&&!a.definitions.every((e=>!e.value)))return !1}else {if(e)return !1;a instanceof AST_EmptyStatement||(e=a);}}return w(e)}(R))&&(n===o||has_annotation(e,_INLINE)||t.option("unused")&&1==(r=n.definition()).references.length&&!recursive_ref(t,r)&&o.is_constant_expression(n.scope))&&!has_annotation(e,_PURE|_NOINLINE)&&!o.contains_this()&&function(){var e=new Set;do{if((F=t.parent(++M)).is_block_scope()&&F.block_scope&&F.block_scope.variables.forEach((function(t){e.add(t.name);})),F instanceof AST_Catch)F.argname&&e.add(F.argname.name);else if(F instanceof AST_IterationStatement)N=[];else if(F instanceof AST_SymbolRef&&F.fixed_value()instanceof AST_Scope)return !1}while(!(F instanceof AST_Scope));var n=!(F instanceof AST_Toplevel)||t.toplevel.vars,i=t.option("inline");return !(!function(e,t){for(var n=o.body.length,i=0;i<n;i++){var r=o.body[i];if(r instanceof AST_Var){if(!t)return !1;for(var a=r.definitions.length;--a>=0;){var s=r.definitions[a].name;if(s instanceof AST_Destructuring||e.has(s.name)||identifier_atom.has(s.name)||F.conflicting_def(s.name))return !1;N&&N.push(s.definition());}}}return !0}(e,i>=3&&n)||!function(e,t){for(var n=0,i=o.argnames.length;n<i;n++){var r=o.argnames[n];if(r instanceof AST_DefaultAssign){if(has_flag(r.left,1))continue;return !1}if(r instanceof AST_Destructuring)return !1;if(r instanceof AST_Expansion){if(has_flag(r.expression,1))continue;return !1}if(!has_flag(r,1)){if(!t||e.has(r.name)||identifier_atom.has(r.name)||F.conflicting_def(r.name))return !1;N&&N.push(r.definition());}}return !0}(e,i>=2&&n)||N&&0!=N.length&&is_reachable(o,N))}()&&(s=find_scope(t))&&!scope_encloses_variables_in_this_scope(s,o)&&!function(){let e,n=0;for(;e=t.parent(n++);){if(e instanceof AST_DefaultAssign)return !0;if(e instanceof AST_Block)break}return !1}()&&!(F instanceof AST_Class))return set_flag(o,256),s.add_child_scope(o),make_sequence(e,function(n){var i=[],r=[];if(function(t,n){for(var i=o.argnames.length,r=e.args.length;--r>=i;)n.push(e.args[r]);for(r=i;--r>=0;){var a=o.argnames[r],s=e.args[r];if(has_flag(a,1)||!a.name||F.conflicting_def(a.name))s&&n.push(s);else {var u=make_node(AST_SymbolVar,a,a);a.definition().orig.push(u),!s&&N&&(s=make_node(AST_Undefined,e)),P(t,n,u,s);}}t.reverse(),n.reverse();}(i,r),function(e,t){for(var n=t.length,i=0,r=o.body.length;i<r;i++){var a=o.body[i];if(a instanceof AST_Var)for(var s=0,u=a.definitions.length;s<u;s++){var l=a.definitions[s],_=l.name;if(P(e,t,_,l.value),N&&o.argnames.every((e=>e.name!=_.name))){var c=o.variables.get(_.name),f=make_node(AST_SymbolRef,_,_);c.references.push(f),t.splice(n++,0,make_node(AST_Assign,l,{operator:"=",logical:!1,left:f,right:make_node(AST_Undefined,_)}));}}}}(i,r),r.push(n),i.length){const e=F.body.indexOf(t.parent(M-1))+1;F.body.splice(e,0,make_node(AST_Var,o,{definitions:i}));}return r.map((e=>e.clone(!0)))}(a)).optimize(t)}if(O&&has_annotation(e,_INLINE))return set_flag(o,256),(o=make_node(o.CTOR===AST_Defun?AST_Function:o.CTOR,o,o)).figure_out_scope({},{parent_scope:find_scope(t),toplevel:t.get_toplevel()}),make_node(AST_Call,e,{expression:o,args:e.args}).optimize(t);if(k&&t.option("side_effects")&&o.body.every(is_empty)){var I=e.args.concat(make_node(AST_Undefined,e));return make_sequence(e,I).optimize(t)}if(t.option("negate_iife")&&t.parent()instanceof AST_SimpleStatement&&is_iife_call(e))return e.negate(t,!0);var x=e.evaluate(t);return x!==e?(x=make_node_from_constant(x,e).optimize(t),best_of(t,x,e)):e;function w(t){return t?t instanceof AST_Return?t.value?t.value.clone(!0):make_node(AST_Undefined,e):t instanceof AST_SimpleStatement?make_node(AST_UnaryPrefix,t,{operator:"void",expression:t.body.clone(!0)}):void 0:make_node(AST_Undefined,e)}function P(t,n,o,i){var r=o.definition();F.variables.has(o.name)||(F.variables.set(o.name,r),F.enclosed.push(r),t.push(make_node(AST_VarDef,o,{name:o,value:null})));var a=make_node(AST_SymbolRef,o,o);r.references.push(a),i&&n.push(make_node(AST_Assign,e,{operator:"=",logical:!1,left:a,right:i.clone()}));}})),def_optimize(AST_New,(function(e,t){return t.option("unsafe")&&is_undeclared_ref(e.expression)&&["Object","RegExp","Function","Error","Array"].includes(e.expression.name)?make_node(AST_Call,e,e).transform(t):e})),def_optimize(AST_Sequence,(function(e,t){if(!t.option("side_effects"))return e;var n,o,i=[];n=first_in_statement(t),o=e.expressions.length-1,e.expressions.forEach((function(e,r){r<o&&(e=e.drop_side_effect_free(t,n)),e&&(merge_sequence(i,e),n=!1);}));var r=i.length-1;return function(){for(;r>0&&is_undefined(i[r],t);)r--;r<i.length-1&&(i[r]=make_node(AST_UnaryPrefix,e,{operator:"void",expression:i[r]}),i.length=r+1);}(),0==r?((e=maintain_this_binding(t.parent(),t.self(),i[0]))instanceof AST_Sequence||(e=e.optimize(t)),e):(e.expressions=i,e)})),AST_Unary.DEFMETHOD("lift_sequences",(function(e){if(e.option("sequences")&&this.expression instanceof AST_Sequence){var t=this.expression.expressions.slice(),n=this.clone();return n.expression=t.pop(),t.push(n),make_sequence(this,t).optimize(e)}return this})),def_optimize(AST_UnaryPostfix,(function(e,t){return e.lift_sequences(t)})),def_optimize(AST_UnaryPrefix,(function(e,t){var n=e.expression;if("delete"==e.operator&&!(n instanceof AST_SymbolRef||n instanceof AST_PropAccess||is_identifier_atom(n))){if(n instanceof AST_Sequence){const o=n.expressions.slice();return o.push(make_node(AST_True,e)),make_sequence(e,o).optimize(t)}return make_sequence(e,[n,make_node(AST_True,e)]).optimize(t)}var o=e.lift_sequences(t);if(o!==e)return o;if(t.option("side_effects")&&"void"==e.operator)return (n=n.drop_side_effect_free(t))?(e.expression=n,e):make_node(AST_Undefined,e).optimize(t);if(t.in_boolean_context())switch(e.operator){case"!":if(n instanceof AST_UnaryPrefix&&"!"==n.operator)return n.expression;n instanceof AST_Binary&&(e=best_of(t,e,n.negate(t,first_in_statement(t))));break;case"typeof":return (n instanceof AST_SymbolRef?make_node(AST_True,e):make_sequence(e,[n,make_node(AST_True,e)])).optimize(t)}if("-"==e.operator&&n instanceof AST_Infinity&&(n=n.transform(t)),n instanceof AST_Binary&&("+"==e.operator||"-"==e.operator)&&("*"==n.operator||"/"==n.operator||"%"==n.operator))return make_node(AST_Binary,e,{operator:n.operator,left:make_node(AST_UnaryPrefix,n.left,{operator:e.operator,expression:n.left}),right:n.right});if("-"!=e.operator||!(n instanceof AST_Number||n instanceof AST_Infinity||n instanceof AST_BigInt)){var i=e.evaluate(t);if(i!==e)return best_of(t,i=make_node_from_constant(i,e).optimize(t),e)}return e})),AST_Binary.DEFMETHOD("lift_sequences",(function(e){if(e.option("sequences")){if(this.left instanceof AST_Sequence){var t=this.left.expressions.slice();return (n=this.clone()).left=t.pop(),t.push(n),make_sequence(this,t).optimize(e)}if(this.right instanceof AST_Sequence&&!this.left.has_side_effects(e)){for(var n,o="="==this.operator&&this.left instanceof AST_SymbolRef,i=(t=this.right.expressions).length-1,r=0;r<i&&(o||!t[r].has_side_effects(e));r++);if(r==i)return t=t.slice(),(n=this.clone()).right=t.pop(),t.push(n),make_sequence(this,t).optimize(e);if(r>0)return (n=this.clone()).right=make_sequence(this.right,t.slice(r)),(t=t.slice(0,r)).push(n),make_sequence(this,t).optimize(e)}}return this}));var commutativeOperators=makePredicate("== === != !== * & | ^");function is_object(e){return e instanceof AST_Array||e instanceof AST_Lambda||e instanceof AST_Object||e instanceof AST_Class}function recursive_ref(e,t){for(var n,o=0;n=e.parent(o);o++)if(n instanceof AST_Lambda||n instanceof AST_Class){var i=n.name;if(i&&i.definition()===t)break}return n}function within_array_or_object_literal(e){for(var t,n=0;t=e.parent(n++);){if(t instanceof AST_Statement)return !1;if(t instanceof AST_Array||t instanceof AST_ObjectKeyVal||t instanceof AST_Object)return !0}return !1}function scope_encloses_variables_in_this_scope(e,t){for(const n of t.enclosed){if(t.variables.has(n.name))continue;const o=e.find_variable(n.name);if(o){if(o===n)continue;return !0}}return !1}function is_atomic(e,t){return e instanceof AST_SymbolRef||e.TYPE===t.TYPE}function is_reachable(e,t){const n=e=>{if(e instanceof AST_SymbolRef&&member(e.definition(),t))return walk_abort};return walk_parent(e,((t,o)=>{if(t instanceof AST_Scope&&t!==e){var i=o.parent();if(i instanceof AST_Call&&i.expression===t)return;return !walk$3(t,n)||walk_abort}}))}def_optimize(AST_Binary,(function(e,t){function n(){return e.left.is_constant()||e.right.is_constant()||!e.left.has_side_effects(t)&&!e.right.has_side_effects(t)}function o(t){if(n()){t&&(e.operator=t);var o=e.left;e.left=e.right,e.right=o;}}if(commutativeOperators.has(e.operator)&&e.right.is_constant()&&!e.left.is_constant()&&(e.left instanceof AST_Binary&&PRECEDENCE[e.left.operator]>=PRECEDENCE[e.operator]||o()),e=e.lift_sequences(t),t.option("comparisons"))switch(e.operator){case"===":case"!==":var i=!0;(e.left.is_string(t)&&e.right.is_string(t)||e.left.is_number(t)&&e.right.is_number(t)||e.left.is_boolean()&&e.right.is_boolean()||e.left.equivalent_to(e.right))&&(e.operator=e.operator.substr(0,2));case"==":case"!=":if(!i&&is_undefined(e.left,t))e.left=make_node(AST_Null,e.left);else if(t.option("typeofs")&&e.left instanceof AST_String&&"undefined"==e.left.value&&e.right instanceof AST_UnaryPrefix&&"typeof"==e.right.operator){var r=e.right.expression;(r instanceof AST_SymbolRef?!r.is_declared(t):r instanceof AST_PropAccess&&t.option("ie8"))||(e.right=r,e.left=make_node(AST_Undefined,e.left).optimize(t),2==e.operator.length&&(e.operator+="="));}else if(e.left instanceof AST_SymbolRef&&e.right instanceof AST_SymbolRef&&e.left.definition()===e.right.definition()&&is_object(e.left.fixed_value()))return make_node("="==e.operator[0]?AST_True:AST_False,e);break;case"&&":case"||":var a=e.left;if(a.operator==e.operator&&(a=a.right),a instanceof AST_Binary&&a.operator==("&&"==e.operator?"!==":"===")&&e.right instanceof AST_Binary&&a.operator==e.right.operator&&(is_undefined(a.left,t)&&e.right.left instanceof AST_Null||a.left instanceof AST_Null&&is_undefined(e.right.left,t))&&!a.right.has_side_effects(t)&&a.right.equivalent_to(e.right.right)){var s=make_node(AST_Binary,e,{operator:a.operator.slice(0,-1),left:make_node(AST_Null,e),right:a.right});return a!==e.left&&(s=make_node(AST_Binary,e,{operator:e.operator,left:e.left.left,right:s})),s}}if("+"==e.operator&&t.in_boolean_context()){var u=e.left.evaluate(t),l=e.right.evaluate(t);if(u&&"string"==typeof u)return make_sequence(e,[e.right,make_node(AST_True,e)]).optimize(t);if(l&&"string"==typeof l)return make_sequence(e,[e.left,make_node(AST_True,e)]).optimize(t)}if(t.option("comparisons")&&e.is_boolean()){if(!(t.parent()instanceof AST_Binary)||t.parent()instanceof AST_Assign){var _=make_node(AST_UnaryPrefix,e,{operator:"!",expression:e.negate(t,first_in_statement(t))});e=best_of(t,e,_);}if(t.option("unsafe_comps"))switch(e.operator){case"<":o(">");break;case"<=":o(">=");}}if("+"==e.operator){if(e.right instanceof AST_String&&""==e.right.getValue()&&e.left.is_string(t))return e.left;if(e.left instanceof AST_String&&""==e.left.getValue()&&e.right.is_string(t))return e.right;if(e.left instanceof AST_Binary&&"+"==e.left.operator&&e.left.left instanceof AST_String&&""==e.left.left.getValue()&&e.right.is_string(t))return e.left=e.left.right,e}if(t.option("evaluate")){switch(e.operator){case"&&":if(!(u=!!has_flag(e.left,2)||!has_flag(e.left,4)&&e.left.evaluate(t)))return maintain_this_binding(t.parent(),t.self(),e.left).optimize(t);if(!(u instanceof AST_Node))return make_sequence(e,[e.left,e.right]).optimize(t);if(l=e.right.evaluate(t)){if(!(l instanceof AST_Node)&&("&&"==(c=t.parent()).operator&&c.left===t.self()||t.in_boolean_context()))return e.left.optimize(t)}else {if(t.in_boolean_context())return make_sequence(e,[e.left,make_node(AST_False,e)]).optimize(t);set_flag(e,4);}if("||"==e.left.operator&&!(f=e.left.right.evaluate(t)))return make_node(AST_Conditional,e,{condition:e.left.left,consequent:e.right,alternative:e.left.right}).optimize(t);break;case"||":var c,f;if(!(u=!!has_flag(e.left,2)||!has_flag(e.left,4)&&e.left.evaluate(t)))return make_sequence(e,[e.left,e.right]).optimize(t);if(!(u instanceof AST_Node))return maintain_this_binding(t.parent(),t.self(),e.left).optimize(t);if(l=e.right.evaluate(t)){if(!(l instanceof AST_Node)){if(t.in_boolean_context())return make_sequence(e,[e.left,make_node(AST_True,e)]).optimize(t);set_flag(e,2);}}else if("||"==(c=t.parent()).operator&&c.left===t.self()||t.in_boolean_context())return e.left.optimize(t);if("&&"==e.left.operator&&(f=e.left.right.evaluate(t))&&!(f instanceof AST_Node))return make_node(AST_Conditional,e,{condition:e.left.left,consequent:e.left.right,alternative:e.right}).optimize(t);break;case"??":if(is_nullish(e.left))return e.right;if(!((u=e.left.evaluate(t))instanceof AST_Node))return null==u?e.right:e.left;if(t.in_boolean_context()){const n=e.right.evaluate(t);if(!(n instanceof AST_Node||n))return e.left}}var p=!0;switch(e.operator){case"+":if(e.right instanceof AST_Constant&&e.left instanceof AST_Binary&&"+"==e.left.operator&&e.left.is_string(t)){var d=(S=make_node(AST_Binary,e,{operator:"+",left:e.left.right,right:e.right})).optimize(t);S!==d&&(e=make_node(AST_Binary,e,{operator:"+",left:e.left.left,right:d}));}if(e.left instanceof AST_Binary&&"+"==e.left.operator&&e.left.is_string(t)&&e.right instanceof AST_Binary&&"+"==e.right.operator&&e.right.is_string(t)){var S,m=(S=make_node(AST_Binary,e,{operator:"+",left:e.left.right,right:e.right.left})).optimize(t);S!==m&&(e=make_node(AST_Binary,e,{operator:"+",left:make_node(AST_Binary,e.left,{operator:"+",left:e.left.left,right:m}),right:e.right.right}));}if(e.right instanceof AST_UnaryPrefix&&"-"==e.right.operator&&e.left.is_number(t)){e=make_node(AST_Binary,e,{operator:"-",left:e.left,right:e.right.expression});break}if(e.left instanceof AST_UnaryPrefix&&"-"==e.left.operator&&n()&&e.right.is_number(t)){e=make_node(AST_Binary,e,{operator:"-",left:e.right,right:e.left.expression});break}if(e.left instanceof AST_TemplateString){var A=e.left;if((d=e.right.evaluate(t))!=e.right)return A.segments[A.segments.length-1].value+=String(d),A}if(e.right instanceof AST_TemplateString&&(d=e.right,(A=e.left.evaluate(t))!=e.left))return d.segments[0].value=String(A)+d.segments[0].value,d;if(e.left instanceof AST_TemplateString&&e.right instanceof AST_TemplateString){var T=(A=e.left).segments;d=e.right,T[T.length-1].value+=d.segments[0].value;for(var h=1;h<d.segments.length;h++)T.push(d.segments[h]);return A}case"*":p=t.option("unsafe_math");case"&":case"|":case"^":if(e.left.is_number(t)&&e.right.is_number(t)&&n()&&!(e.left instanceof AST_Binary&&e.left.operator!=e.operator&&PRECEDENCE[e.left.operator]>=PRECEDENCE[e.operator])){var E=make_node(AST_Binary,e,{operator:e.operator,left:e.right,right:e.left});e=e.right instanceof AST_Constant&&!(e.left instanceof AST_Constant)?best_of(t,E,e):best_of(t,e,E);}p&&e.is_number(t)&&(e.right instanceof AST_Binary&&e.right.operator==e.operator&&(e=make_node(AST_Binary,e,{operator:e.operator,left:make_node(AST_Binary,e.left,{operator:e.operator,left:e.left,right:e.right.left,start:e.left.start,end:e.right.left.end}),right:e.right.right})),e.right instanceof AST_Constant&&e.left instanceof AST_Binary&&e.left.operator==e.operator&&(e.left.left instanceof AST_Constant?e=make_node(AST_Binary,e,{operator:e.operator,left:make_node(AST_Binary,e.left,{operator:e.operator,left:e.left.left,right:e.right,start:e.left.left.start,end:e.right.end}),right:e.left.right}):e.left.right instanceof AST_Constant&&(e=make_node(AST_Binary,e,{operator:e.operator,left:make_node(AST_Binary,e.left,{operator:e.operator,left:e.left.right,right:e.right,start:e.left.right.start,end:e.right.end}),right:e.left.left}))),e.left instanceof AST_Binary&&e.left.operator==e.operator&&e.left.right instanceof AST_Constant&&e.right instanceof AST_Binary&&e.right.operator==e.operator&&e.right.left instanceof AST_Constant&&(e=make_node(AST_Binary,e,{operator:e.operator,left:make_node(AST_Binary,e.left,{operator:e.operator,left:make_node(AST_Binary,e.left.left,{operator:e.operator,left:e.left.right,right:e.right.left,start:e.left.right.start,end:e.right.left.end}),right:e.left.left}),right:e.right.right})));}}if(e.right instanceof AST_Binary&&e.right.operator==e.operator&&(lazy_op.has(e.operator)||"+"==e.operator&&(e.right.left.is_string(t)||e.left.is_string(t)&&e.right.right.is_string(t))))return e.left=make_node(AST_Binary,e.left,{operator:e.operator,left:e.left.transform(t),right:e.right.left.transform(t)}),e.right=e.right.right.transform(t),e.transform(t);var g=e.evaluate(t);return g!==e?(g=make_node_from_constant(g,e).optimize(t),best_of(t,g,e)):e})),def_optimize(AST_SymbolExport,(function(e){return e})),def_optimize(AST_SymbolRef,(function(e,t){if(!t.option("ie8")&&is_undeclared_ref(e)&&!t.find_parent(AST_With))switch(e.name){case"undefined":return make_node(AST_Undefined,e).optimize(t);case"NaN":return make_node(AST_NaN,e).optimize(t);case"Infinity":return make_node(AST_Infinity,e).optimize(t)}const n=t.parent();if(t.option("reduce_vars")&&is_lhs(e,n)!==e){const r=e.definition(),a=find_scope(t);if(t.top_retain&&r.global&&t.top_retain(r))return r.fixed=!1,r.single_use=!1,e;let s=e.fixed_value(),u=r.single_use&&!(n instanceof AST_Call&&n.is_expr_pure(t)||has_annotation(n,_NOINLINE))&&!(n instanceof AST_Export&&s instanceof AST_Lambda&&s.name);if(u&&(s instanceof AST_Lambda||s instanceof AST_Class))if(retain_top_func(s,t))u=!1;else if(r.scope!==e.scope&&(1==r.escaped||has_flag(s,16)||within_array_or_object_literal(t)))u=!1;else if(recursive_ref(t,r))u=!1;else if((r.scope!==e.scope||r.orig[0]instanceof AST_SymbolFunarg)&&(u=s.is_constant_expression(e.scope),"f"==u)){var o=e.scope;do{(o instanceof AST_Defun||is_func_expr(o))&&set_flag(o,16);}while(o=o.parent_scope)}if(u&&s instanceof AST_Lambda&&(u=r.scope===e.scope&&!scope_encloses_variables_in_this_scope(a,s)||n instanceof AST_Call&&n.expression===e&&!scope_encloses_variables_in_this_scope(a,s)&&!(s.name&&s.name.definition().recursive_refs>0)),u&&s instanceof AST_Class&&(u=!(s.extends&&(s.extends.may_throw(t)||s.extends.has_side_effects(t))||s.properties.some((e=>e.may_throw(t)||e.has_side_effects(t))))),u&&s){if(s instanceof AST_DefClass&&(set_flag(s,256),s=make_node(AST_ClassExpression,s,s)),s instanceof AST_Defun&&(set_flag(s,256),s=make_node(AST_Function,s,s)),r.recursive_refs>0&&s.name instanceof AST_SymbolDefun){const e=s.name.definition();let t=s.variables.get(s.name.name),n=t&&t.orig[0];n instanceof AST_SymbolLambda||(n=make_node(AST_SymbolLambda,s.name,s.name),n.scope=s,s.name=n,t=s.def_function(n)),walk$3(s,(n=>{n instanceof AST_SymbolRef&&n.definition()===e&&(n.thedef=t,t.references.push(n));}));}return (s instanceof AST_Lambda||s instanceof AST_Class)&&s.parent_scope!==a&&(s=s.clone(!0,t.get_toplevel()),a.add_child_scope(s)),s.optimize(t)}if(s){let n;if(s instanceof AST_This)r.orig[0]instanceof AST_SymbolFunarg||!r.references.every((e=>r.scope===e.scope))||(n=s);else {var i=s.evaluate(t);i===s||!t.option("unsafe_regexp")&&i instanceof RegExp||(n=make_node_from_constant(i,s));}if(n){const o=e.size(t),i=n.size(t);let a=0;if(t.option("unused")&&!t.exposed(r)&&(a=(o+2+i)/(r.references.length-r.assignments)),i<=o+a)return n}}}return e})),def_optimize(AST_Undefined,(function(e,t){if(t.option("unsafe_undefined")){var n=find_variable(t,"undefined");if(n){var o=make_node(AST_SymbolRef,e,{name:"undefined",scope:n.scope,thedef:n});return set_flag(o,8),o}}var i=is_lhs(t.self(),t.parent());return i&&is_atomic(i,e)?e:make_node(AST_UnaryPrefix,e,{operator:"void",expression:make_node(AST_Number,e,{value:0})})})),def_optimize(AST_Infinity,(function(e,t){var n=is_lhs(t.self(),t.parent());return n&&is_atomic(n,e)?e:!t.option("keep_infinity")||n&&!is_atomic(n,e)||find_variable(t,"Infinity")?make_node(AST_Binary,e,{operator:"/",left:make_node(AST_Number,e,{value:1}),right:make_node(AST_Number,e,{value:0})}):e})),def_optimize(AST_NaN,(function(e,t){var n=is_lhs(t.self(),t.parent());return n&&!is_atomic(n,e)||find_variable(t,"NaN")?make_node(AST_Binary,e,{operator:"/",left:make_node(AST_Number,e,{value:0}),right:make_node(AST_Number,e,{value:0})}):e}));const ASSIGN_OPS=makePredicate("+ - / * % >> << >>> | ^ &"),ASSIGN_OPS_COMMUTATIVE=makePredicate("* | ^ &");function is_nullish(e){let t;return e instanceof AST_Null||is_undefined(e)||e instanceof AST_SymbolRef&&(t=e.definition().fixed)instanceof AST_Node&&is_nullish(t)||e instanceof AST_PropAccess&&e.optional&&is_nullish(e.expression)||e instanceof AST_Call&&e.optional&&is_nullish(e.expression)||e instanceof AST_Chain&&is_nullish(e.expression)}function is_nullish_check(e,t,n){if(t.may_throw(n))return !1;let o;if(e instanceof AST_Binary&&"=="===e.operator&&((o=is_nullish(e.left)&&e.left)||(o=is_nullish(e.right)&&e.right))&&(o===e.left?e.right:e.left).equivalent_to(t))return !0;if(e instanceof AST_Binary&&"||"===e.operator){let n,o;const i=e=>{if(!(e instanceof AST_Binary)||"==="!==e.operator&&"=="!==e.operator)return !1;let i,r=0;return e.left instanceof AST_Null&&(r++,n=e,i=e.right),e.right instanceof AST_Null&&(r++,n=e,i=e.left),is_undefined(e.left)&&(r++,o=e,i=e.right),is_undefined(e.right)&&(r++,o=e,i=e.left),1===r&&!!i.equivalent_to(t)};if(!i(e.left))return !1;if(!i(e.right))return !1;if(n&&o&&n!==o)return !0}return !1}function safe_to_flatten(e,t){return e instanceof AST_SymbolRef&&(e=e.fixed_value()),!!e&&(!(e instanceof AST_Lambda||e instanceof AST_Class)||!(e instanceof AST_Lambda&&e.contains_this())||t.parent()instanceof AST_New)}function literals_in_boolean_context(e,t){return t.in_boolean_context()?best_of(t,e,make_sequence(e,[e,make_node(AST_True,e)]).optimize(t)):e}function inline_array_like_spread(e){for(var t=0;t<e.length;t++){var n=e[t];if(n instanceof AST_Expansion){var o=n.expression;o instanceof AST_Array&&!o.elements.some((e=>e instanceof AST_Hole))&&(e.splice(t,1,...o.elements),t--);}}}function inline_object_prop_spread(e){for(var t=0;t<e.length;t++){var n=e[t];if(n instanceof AST_Expansion){const o=n.expression;o instanceof AST_Object&&o.properties.every((e=>e instanceof AST_ObjectKeyVal))?(e.splice(t,1,...o.properties),t--):o instanceof AST_Constant&&!(o instanceof AST_String)&&e.splice(t,1);}}}function lift_key(e,t){if(!t.option("computed_props"))return e;if(!(e.key instanceof AST_Constant))return e;if(e.key instanceof AST_String||e.key instanceof AST_Number){if("__proto__"===e.key.value)return e;if("constructor"==e.key.value&&t.parent()instanceof AST_Class)return e;e.key=e instanceof AST_ObjectKeyVal?e.key.value:make_node(e instanceof AST_ClassProperty?AST_SymbolClassProperty:AST_SymbolMethod,e.key,{name:e.key.value});}return e}async function SourceMap$3(e){var t;e=defaults$1(e,{file:null,root:null,orig:null,orig_line_diff:0,dest_line_diff:0});var n=new sourceMap.SourceMapGenerator({file:e.file,sourceRoot:e.root});return e.orig&&(t=await new sourceMap.SourceMapConsumer(e.orig)).sources.forEach((function(e){var o=t.sourceContentFor(e,!0);o&&n.setSourceContent(e,o);})),{add:function(o,i,r,a,s,u){if(t){var l=t.originalPositionFor({line:a,column:s});if(null===l.source)return;o=l.source,a=l.line,s=l.column,u=l.name||u;}n.addMapping({generated:{line:i+e.dest_line_diff,column:r},original:{line:a+e.orig_line_diff,column:s},source:o,name:u});},get:function(){return n},toString:function(){return n.toString()},destroy:function(){t&&t.destroy&&t.destroy();}}}def_optimize(AST_Assign,(function(e,t){if(e.logical)return e.lift_sequences(t);var n;if(t.option("dead_code")&&e.left instanceof AST_SymbolRef&&(n=e.left.definition()).scope===t.find_parent(AST_Lambda)){var o,i=0,r=e;do{if(o=r,(r=t.parent(i++))instanceof AST_Exit){if(a(i,r))break;if(is_reachable(n.scope,[n]))break;return "="==e.operator?e.right:(n.fixed=!1,make_node(AST_Binary,e,{operator:e.operator.slice(0,-1),left:e.left,right:e.right}).optimize(t))}}while(r instanceof AST_Binary&&r.right===o||r instanceof AST_Sequence&&r.tail_node()===o)}return "="==(e=e.lift_sequences(t)).operator&&e.left instanceof AST_SymbolRef&&e.right instanceof AST_Binary&&(e.right.left instanceof AST_SymbolRef&&e.right.left.name==e.left.name&&ASSIGN_OPS.has(e.right.operator)?(e.operator=e.right.operator+"=",e.right=e.right.right):e.right.right instanceof AST_SymbolRef&&e.right.right.name==e.left.name&&ASSIGN_OPS_COMMUTATIVE.has(e.right.operator)&&!e.right.left.has_side_effects(t)&&(e.operator=e.right.operator+"=",e.right=e.right.left)),e;function a(n,o){var i=e.right;e.right=make_node(AST_Null,i);var r=o.may_throw(t);e.right=i;for(var a,s=e.left.definition().scope;(a=t.parent(n++))!==s;)if(a instanceof AST_Try){if(a.bfinally)return !0;if(r&&a.bcatch)return !0}}})),def_optimize(AST_DefaultAssign,(function(e,t){if(!t.option("evaluate"))return e;var n=e.right.evaluate(t);return void 0===n?e=e.left:n!==e.right&&(n=make_node_from_constant(n,e.right),e.right=best_of_expression(n,e.right)),e})),def_optimize(AST_Conditional,(function(e,t){if(!t.option("conditionals"))return e;if(e.condition instanceof AST_Sequence){var n=e.condition.expressions.slice();return e.condition=n.pop(),n.push(e),make_sequence(e,n)}var o=e.condition.evaluate(t);if(o!==e.condition)return maintain_this_binding(t.parent(),t.self(),o?e.consequent:e.alternative);var i=o.negate(t,first_in_statement(t));best_of(t,o,i)===i&&(e=make_node(AST_Conditional,e,{condition:i,consequent:e.alternative,alternative:e.consequent}));var r,a=e.condition,s=e.consequent,u=e.alternative;if(a instanceof AST_SymbolRef&&s instanceof AST_SymbolRef&&a.definition()===s.definition())return make_node(AST_Binary,e,{operator:"||",left:a,right:u});if(s instanceof AST_Assign&&u instanceof AST_Assign&&s.operator===u.operator&&s.logical===u.logical&&s.left.equivalent_to(u.left)&&(!e.condition.has_side_effects(t)||"="==s.operator&&!s.left.has_side_effects(t)))return make_node(AST_Assign,e,{operator:s.operator,left:s.left,logical:s.logical,right:make_node(AST_Conditional,e,{condition:e.condition,consequent:s.right,alternative:u.right})});if(s instanceof AST_Call&&u.TYPE===s.TYPE&&s.args.length>0&&s.args.length==u.args.length&&s.expression.equivalent_to(u.expression)&&!e.condition.has_side_effects(t)&&!s.expression.has_side_effects(t)&&"number"==typeof(r=function(){for(var e=s.args,t=u.args,n=0,o=e.length;n<o;n++){if(e[n]instanceof AST_Expansion)return;if(!e[n].equivalent_to(t[n])){if(t[n]instanceof AST_Expansion)return;for(var i=n+1;i<o;i++){if(e[i]instanceof AST_Expansion)return;if(!e[i].equivalent_to(t[i]))return}return n}}}())){var l=s.clone();return l.args[r]=make_node(AST_Conditional,e,{condition:e.condition,consequent:s.args[r],alternative:u.args[r]}),l}if(u instanceof AST_Conditional&&s.equivalent_to(u.consequent))return make_node(AST_Conditional,e,{condition:make_node(AST_Binary,e,{operator:"||",left:a,right:u.condition}),consequent:s,alternative:u.alternative}).optimize(t);if(t.option("ecma")>=2020&&is_nullish_check(a,u,t))return make_node(AST_Binary,e,{operator:"??",left:u,right:s}).optimize(t);if(u instanceof AST_Sequence&&s.equivalent_to(u.expressions[u.expressions.length-1]))return make_sequence(e,[make_node(AST_Binary,e,{operator:"||",left:a,right:make_sequence(e,u.expressions.slice(0,-1))}),s]).optimize(t);if(u instanceof AST_Binary&&"&&"==u.operator&&s.equivalent_to(u.right))return make_node(AST_Binary,e,{operator:"&&",left:make_node(AST_Binary,e,{operator:"||",left:a,right:u.left}),right:s}).optimize(t);if(s instanceof AST_Conditional&&s.alternative.equivalent_to(u))return make_node(AST_Conditional,e,{condition:make_node(AST_Binary,e,{left:e.condition,operator:"&&",right:s.condition}),consequent:s.consequent,alternative:u});if(s.equivalent_to(u))return make_sequence(e,[e.condition,s]).optimize(t);if(s instanceof AST_Binary&&"||"==s.operator&&s.right.equivalent_to(u))return make_node(AST_Binary,e,{operator:"||",left:make_node(AST_Binary,e,{operator:"&&",left:e.condition,right:s.left}),right:u}).optimize(t);var _=t.in_boolean_context();return f(e.consequent)?p(e.alternative)?c(e.condition):make_node(AST_Binary,e,{operator:"||",left:c(e.condition),right:e.alternative}):p(e.consequent)?f(e.alternative)?c(e.condition.negate(t)):make_node(AST_Binary,e,{operator:"&&",left:c(e.condition.negate(t)),right:e.alternative}):f(e.alternative)?make_node(AST_Binary,e,{operator:"||",left:c(e.condition.negate(t)),right:e.consequent}):p(e.alternative)?make_node(AST_Binary,e,{operator:"&&",left:c(e.condition),right:e.consequent}):e;function c(e){return e.is_boolean()?e:make_node(AST_UnaryPrefix,e,{operator:"!",expression:e.negate(t)})}function f(e){return e instanceof AST_True||_&&e instanceof AST_Constant&&e.getValue()||e instanceof AST_UnaryPrefix&&"!"==e.operator&&e.expression instanceof AST_Constant&&!e.expression.getValue()}function p(e){return e instanceof AST_False||_&&e instanceof AST_Constant&&!e.getValue()||e instanceof AST_UnaryPrefix&&"!"==e.operator&&e.expression instanceof AST_Constant&&e.expression.getValue()}})),def_optimize(AST_Boolean,(function(e,t){if(t.in_boolean_context())return make_node(AST_Number,e,{value:+e.value});var n=t.parent();return t.option("booleans_as_integers")?(n instanceof AST_Binary&&("==="==n.operator||"!=="==n.operator)&&(n.operator=n.operator.replace(/=$/,"")),make_node(AST_Number,e,{value:+e.value})):t.option("booleans")?n instanceof AST_Binary&&("=="==n.operator||"!="==n.operator)?make_node(AST_Number,e,{value:+e.value}):make_node(AST_UnaryPrefix,e,{operator:"!",expression:make_node(AST_Number,e,{value:1-e.value})}):e})),AST_PropAccess.DEFMETHOD("flatten_object",(function(e,t){if(t.option("properties")){var n=t.option("unsafe_arrows")&&t.option("ecma")>=2015,o=this.expression;if(o instanceof AST_Object)for(var i=o.properties,r=i.length;--r>=0;){var a=i[r];if(""+(a instanceof AST_ConciseMethod?a.key.name:a.key)==e){if(!i.every((e=>e instanceof AST_ObjectKeyVal||n&&e instanceof AST_ConciseMethod&&!e.is_generator)))break;if(!safe_to_flatten(a.value,t))break;return make_node(AST_Sub,this,{expression:make_node(AST_Array,o,{elements:i.map((function(e){var t=e.value;t instanceof AST_Accessor&&(t=make_node(AST_Function,t,t));var n=e.key;return n instanceof AST_Node&&!(n instanceof AST_SymbolMethod)?make_sequence(e,[n,t]):t}))}),property:make_node(AST_Number,this,{value:r})})}}}})),def_optimize(AST_Sub,(function(e,t){var n,o=e.expression,i=e.property;if(t.option("properties")){var r=i.evaluate(t);if(r!==i){"string"==typeof r&&("undefined"==r?r=void 0:(g=parseFloat(r)).toString()==r&&(r=g)),i=e.property=best_of_expression(i,make_node_from_constant(r,i).transform(t));var a=""+r;if(is_basic_identifier_string(a)&&a.length<=i.size()+1)return make_node(AST_Dot,e,{expression:o,optional:e.optional,property:a,quote:i.quote}).optimize(t)}}e:if(t.option("arguments")&&o instanceof AST_SymbolRef&&"arguments"==o.name&&1==o.definition().orig.length&&(n=o.scope)instanceof AST_Lambda&&n.uses_arguments&&!(n instanceof AST_Arrow)&&i instanceof AST_Number){for(var s=i.getValue(),u=new Set,l=n.argnames,_=0;_<l.length;_++){if(!(l[_]instanceof AST_SymbolFunarg))break e;var c=l[_].name;if(u.has(c))break e;u.add(c);}var f=n.argnames[s];if(f&&t.has_directive("use strict")){var p=f.definition();(!t.option("reduce_vars")||p.assignments||p.orig.length>1)&&(f=null);}else if(!f&&!t.option("keep_fargs")&&s<n.argnames.length+5)for(;s>=n.argnames.length;)f=n.create_symbol(AST_SymbolFunarg,{source:n,scope:n,tentative_name:"argument_"+n.argnames.length}),n.argnames.push(f);if(f){var d=make_node(AST_SymbolRef,e,f);return d.reference({}),clear_flag(f,1),d}}if(is_lhs(e,t.parent()))return e;if(r!==i){var S=e.flatten_object(a,t);S&&(o=e.expression=S.expression,i=e.property=S.property);}if(t.option("properties")&&t.option("side_effects")&&i instanceof AST_Number&&o instanceof AST_Array){s=i.getValue();var m=o.elements,A=m[s];e:if(safe_to_flatten(A,t)){for(var T=!0,h=[],E=m.length;--E>s;)(g=m[E].drop_side_effect_free(t))&&(h.unshift(g),T&&g.has_side_effects(t)&&(T=!1));if(A instanceof AST_Expansion)break e;for(A=A instanceof AST_Hole?make_node(AST_Undefined,A):A,T||h.unshift(A);--E>=0;){var g;if((g=m[E])instanceof AST_Expansion)break e;(g=g.drop_side_effect_free(t))?h.unshift(g):s--;}return T?(h.push(A),make_sequence(e,h).optimize(t)):make_node(AST_Sub,e,{expression:make_node(AST_Array,o,{elements:h}),property:make_node(AST_Number,i,{value:s})})}}var D=e.evaluate(t);return D!==e?best_of(t,D=make_node_from_constant(D,e).optimize(t),e):e.optional&&is_nullish(e.expression)?make_node(AST_Undefined,e):e})),def_optimize(AST_Chain,(function(e,t){return e.expression=e.expression.optimize(t),e})),AST_Lambda.DEFMETHOD("contains_this",(function(){return walk$3(this,(e=>e instanceof AST_This?walk_abort:e!==this&&e instanceof AST_Scope&&!(e instanceof AST_Arrow)||void 0))})),def_optimize(AST_Dot,(function(e,t){const n=t.parent();if(is_lhs(e,n))return e;if(t.option("unsafe_proto")&&e.expression instanceof AST_Dot&&"prototype"==e.expression.property){var o=e.expression.expression;if(is_undeclared_ref(o))switch(o.name){case"Array":e.expression=make_node(AST_Array,e.expression,{elements:[]});break;case"Function":e.expression=make_node(AST_Function,e.expression,{argnames:[],body:[]});break;case"Number":e.expression=make_node(AST_Number,e.expression,{value:0});break;case"Object":e.expression=make_node(AST_Object,e.expression,{properties:[]});break;case"RegExp":e.expression=make_node(AST_RegExp,e.expression,{value:{source:"t",flags:""}});break;case"String":e.expression=make_node(AST_String,e.expression,{value:""});}}if(!(n instanceof AST_Call&&has_annotation(n,_NOINLINE))){const n=e.flatten_object(e.property,t);if(n)return n.optimize(t)}let i=e.evaluate(t);return i!==e?(i=make_node_from_constant(i,e).optimize(t),best_of(t,i,e)):e.optional&&is_nullish(e.expression)?make_node(AST_Undefined,e):e})),def_optimize(AST_Array,(function(e,t){var n=literals_in_boolean_context(e,t);return n!==e?n:(inline_array_like_spread(e.elements),e)})),def_optimize(AST_Object,(function(e,t){var n=literals_in_boolean_context(e,t);return n!==e?n:(inline_object_prop_spread(e.properties),e)})),def_optimize(AST_RegExp,literals_in_boolean_context),def_optimize(AST_Return,(function(e,t){return e.value&&is_undefined(e.value,t)&&(e.value=null),e})),def_optimize(AST_Arrow,opt_AST_Lambda),def_optimize(AST_Function,(function(e,t){return e=opt_AST_Lambda(e,t),!(t.option("unsafe_arrows")&&t.option("ecma")>=2015)||e.name||e.is_generator||e.uses_arguments||e.pinned()||walk$3(e,(e=>{if(e instanceof AST_This)return walk_abort}))?e:make_node(AST_Arrow,e,e).optimize(t)})),def_optimize(AST_Class,(function(e){return e})),def_optimize(AST_Yield,(function(e,t){return e.expression&&!e.is_star&&is_undefined(e.expression,t)&&(e.expression=null),e})),def_optimize(AST_TemplateString,(function(e,t){if(!t.option("evaluate")||t.parent()instanceof AST_PrefixedTemplateString)return e;for(var n=[],o=0;o<e.segments.length;o++){var i=e.segments[o];if(i instanceof AST_Node){var r=i.evaluate(t);if(r!==i&&(r+"").length<=i.size()+"${}".length){n[n.length-1].value=n[n.length-1].value+r+e.segments[++o].value;continue}if(i instanceof AST_TemplateString){var a=i.segments;n[n.length-1].value+=a[0].value;for(var s=1;s<a.length;s++)i=a[s],n.push(i);continue}}n.push(i);}if(e.segments=n,1==n.length)return make_node(AST_String,e,n[0]);if(3===n.length&&n[1]instanceof AST_Node&&(n[1].is_string(t)||n[1].is_number(t)||is_nullish(n[1])||t.option("unsafe"))){if(""===n[2].value)return make_node(AST_Binary,e,{operator:"+",left:make_node(AST_String,e,{value:n[0].value}),right:n[1]});if(""===n[0].value)return make_node(AST_Binary,e,{operator:"+",left:n[1],right:make_node(AST_String,e,{value:n[2].value})})}return e})),def_optimize(AST_PrefixedTemplateString,(function(e){return e})),def_optimize(AST_ObjectProperty,lift_key),def_optimize(AST_ConciseMethod,(function(e,t){if(lift_key(e,t),t.option("arrows")&&t.parent()instanceof AST_Object&&!e.is_generator&&!e.value.uses_arguments&&!e.value.pinned()&&1==e.value.body.length&&e.value.body[0]instanceof AST_Return&&e.value.body[0].value&&!e.value.contains_this()){var n=make_node(AST_Arrow,e.value,e.value);return n.async=e.async,n.is_generator=e.is_generator,make_node(AST_ObjectKeyVal,e,{key:e.key instanceof AST_SymbolMethod?e.key.name:e.key,value:n,quote:e.quote})}return e})),def_optimize(AST_ObjectKeyVal,(function(e,t){lift_key(e,t);var n=t.option("unsafe_methods");if(n&&t.option("ecma")>=2015&&(!(n instanceof RegExp)||n.test(e.key+""))){var o=e.key,i=e.value;if((i instanceof AST_Arrow&&Array.isArray(i.body)&&!i.contains_this()||i instanceof AST_Function)&&!i.name)return make_node(AST_ConciseMethod,e,{async:i.async,is_generator:i.is_generator,key:o instanceof AST_Node?o:make_node(AST_SymbolMethod,e,{name:o}),value:make_node(AST_Accessor,i,i),quote:e.quote})}return e})),def_optimize(AST_Destructuring,(function(e,t){if(1==t.option("pure_getters")&&t.option("unused")&&!e.is_array&&Array.isArray(e.names)&&!function(e){for(var t=[/^VarDef$/,/^(Const|Let|Var)$/,/^Export$/],n=0,o=0,i=t.length;n<i;o++){var r=e.parent(o);if(!r)return !1;if(0!==n||"Destructuring"!=r.TYPE){if(!t[n].test(r.TYPE))return !1;n++;}}return !0}(t)&&!(e.names[e.names.length-1]instanceof AST_Expansion)){for(var n=[],o=0;o<e.names.length;o++){var i=e.names[o];i instanceof AST_ObjectKeyVal&&"string"==typeof i.key&&i.value instanceof AST_SymbolDeclaration&&!r(t,i.value.definition())||n.push(i);}n.length!=e.names.length&&(e.names=n);}return e;function r(e,t){return !!t.references.length||!!t.global&&(!e.toplevel.vars||!!e.top_retain&&e.top_retain(t))}}));var domprops=["$&","$'","$*","$+","$1","$2","$3","$4","$5","$6","$7","$8","$9","$_","$`","$input","-moz-animation","-moz-animation-delay","-moz-animation-direction","-moz-animation-duration","-moz-animation-fill-mode","-moz-animation-iteration-count","-moz-animation-name","-moz-animation-play-state","-moz-animation-timing-function","-moz-appearance","-moz-backface-visibility","-moz-border-end","-moz-border-end-color","-moz-border-end-style","-moz-border-end-width","-moz-border-image","-moz-border-start","-moz-border-start-color","-moz-border-start-style","-moz-border-start-width","-moz-box-align","-moz-box-direction","-moz-box-flex","-moz-box-ordinal-group","-moz-box-orient","-moz-box-pack","-moz-box-sizing","-moz-float-edge","-moz-font-feature-settings","-moz-font-language-override","-moz-force-broken-image-icon","-moz-hyphens","-moz-image-region","-moz-margin-end","-moz-margin-start","-moz-orient","-moz-osx-font-smoothing","-moz-outline-radius","-moz-outline-radius-bottomleft","-moz-outline-radius-bottomright","-moz-outline-radius-topleft","-moz-outline-radius-topright","-moz-padding-end","-moz-padding-start","-moz-perspective","-moz-perspective-origin","-moz-tab-size","-moz-text-size-adjust","-moz-transform","-moz-transform-origin","-moz-transform-style","-moz-transition","-moz-transition-delay","-moz-transition-duration","-moz-transition-property","-moz-transition-timing-function","-moz-user-focus","-moz-user-input","-moz-user-modify","-moz-user-select","-moz-window-dragging","-webkit-align-content","-webkit-align-items","-webkit-align-self","-webkit-animation","-webkit-animation-delay","-webkit-animation-direction","-webkit-animation-duration","-webkit-animation-fill-mode","-webkit-animation-iteration-count","-webkit-animation-name","-webkit-animation-play-state","-webkit-animation-timing-function","-webkit-appearance","-webkit-backface-visibility","-webkit-background-clip","-webkit-background-origin","-webkit-background-size","-webkit-border-bottom-left-radius","-webkit-border-bottom-right-radius","-webkit-border-image","-webkit-border-radius","-webkit-border-top-left-radius","-webkit-border-top-right-radius","-webkit-box-align","-webkit-box-direction","-webkit-box-flex","-webkit-box-ordinal-group","-webkit-box-orient","-webkit-box-pack","-webkit-box-shadow","-webkit-box-sizing","-webkit-filter","-webkit-flex","-webkit-flex-basis","-webkit-flex-direction","-webkit-flex-flow","-webkit-flex-grow","-webkit-flex-shrink","-webkit-flex-wrap","-webkit-justify-content","-webkit-line-clamp","-webkit-mask","-webkit-mask-clip","-webkit-mask-composite","-webkit-mask-image","-webkit-mask-origin","-webkit-mask-position","-webkit-mask-position-x","-webkit-mask-position-y","-webkit-mask-repeat","-webkit-mask-size","-webkit-order","-webkit-perspective","-webkit-perspective-origin","-webkit-text-fill-color","-webkit-text-size-adjust","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-stroke-width","-webkit-transform","-webkit-transform-origin","-webkit-transform-style","-webkit-transition","-webkit-transition-delay","-webkit-transition-duration","-webkit-transition-property","-webkit-transition-timing-function","-webkit-user-select","0","1","10","11","12","13","14","15","16","17","18","19","2","20","3","4","5","6","7","8","9","@@iterator","ABORT_ERR","ACTIVE","ACTIVE_ATTRIBUTES","ACTIVE_TEXTURE","ACTIVE_UNIFORMS","ACTIVE_UNIFORM_BLOCKS","ADDITION","ALIASED_LINE_WIDTH_RANGE","ALIASED_POINT_SIZE_RANGE","ALLOW_KEYBOARD_INPUT","ALLPASS","ALPHA","ALPHA_BITS","ALREADY_SIGNALED","ALT_MASK","ALWAYS","ANY_SAMPLES_PASSED","ANY_SAMPLES_PASSED_CONSERVATIVE","ANY_TYPE","ANY_UNORDERED_NODE_TYPE","ARRAY_BUFFER","ARRAY_BUFFER_BINDING","ATTACHED_SHADERS","ATTRIBUTE_NODE","AT_TARGET","AbortController","AbortSignal","AbsoluteOrientationSensor","AbstractRange","Accelerometer","AddSearchProvider","AggregateError","AnalyserNode","Animation","AnimationEffect","AnimationEvent","AnimationPlaybackEvent","AnimationTimeline","AnonXMLHttpRequest","Any","ApplicationCache","ApplicationCacheErrorEvent","Array","ArrayBuffer","ArrayType","Atomics","Attr","Audio","AudioBuffer","AudioBufferSourceNode","AudioContext","AudioDestinationNode","AudioListener","AudioNode","AudioParam","AudioParamMap","AudioProcessingEvent","AudioScheduledSourceNode","AudioStreamTrack","AudioWorklet","AudioWorkletNode","AuthenticatorAssertionResponse","AuthenticatorAttestationResponse","AuthenticatorResponse","AutocompleteErrorEvent","BACK","BAD_BOUNDARYPOINTS_ERR","BAD_REQUEST","BANDPASS","BLEND","BLEND_COLOR","BLEND_DST_ALPHA","BLEND_DST_RGB","BLEND_EQUATION","BLEND_EQUATION_ALPHA","BLEND_EQUATION_RGB","BLEND_SRC_ALPHA","BLEND_SRC_RGB","BLUE_BITS","BLUR","BOOL","BOOLEAN_TYPE","BOOL_VEC2","BOOL_VEC3","BOOL_VEC4","BOTH","BROWSER_DEFAULT_WEBGL","BUBBLING_PHASE","BUFFER_SIZE","BUFFER_USAGE","BYTE","BYTES_PER_ELEMENT","BackgroundFetchManager","BackgroundFetchRecord","BackgroundFetchRegistration","BarProp","BarcodeDetector","BaseAudioContext","BaseHref","BatteryManager","BeforeInstallPromptEvent","BeforeLoadEvent","BeforeUnloadEvent","BigInt","BigInt64Array","BigUint64Array","BiquadFilterNode","Blob","BlobEvent","Bluetooth","BluetoothCharacteristicProperties","BluetoothDevice","BluetoothRemoteGATTCharacteristic","BluetoothRemoteGATTDescriptor","BluetoothRemoteGATTServer","BluetoothRemoteGATTService","BluetoothUUID","Boolean","BroadcastChannel","ByteLengthQueuingStrategy","CAPTURING_PHASE","CCW","CDATASection","CDATA_SECTION_NODE","CHANGE","CHARSET_RULE","CHECKING","CLAMP_TO_EDGE","CLICK","CLOSED","CLOSING","COLOR","COLOR_ATTACHMENT0","COLOR_ATTACHMENT1","COLOR_ATTACHMENT10","COLOR_ATTACHMENT11","COLOR_ATTACHMENT12","COLOR_ATTACHMENT13","COLOR_ATTACHMENT14","COLOR_ATTACHMENT15","COLOR_ATTACHMENT2","COLOR_ATTACHMENT3","COLOR_ATTACHMENT4","COLOR_ATTACHMENT5","COLOR_ATTACHMENT6","COLOR_ATTACHMENT7","COLOR_ATTACHMENT8","COLOR_ATTACHMENT9","COLOR_BUFFER_BIT","COLOR_CLEAR_VALUE","COLOR_WRITEMASK","COMMENT_NODE","COMPARE_REF_TO_TEXTURE","COMPILE_STATUS","COMPRESSED_RGBA_S3TC_DXT1_EXT","COMPRESSED_RGBA_S3TC_DXT3_EXT","COMPRESSED_RGBA_S3TC_DXT5_EXT","COMPRESSED_RGB_S3TC_DXT1_EXT","COMPRESSED_TEXTURE_FORMATS","CONDITION_SATISFIED","CONFIGURATION_UNSUPPORTED","CONNECTING","CONSTANT_ALPHA","CONSTANT_COLOR","CONSTRAINT_ERR","CONTEXT_LOST_WEBGL","CONTROL_MASK","COPY_READ_BUFFER","COPY_READ_BUFFER_BINDING","COPY_WRITE_BUFFER","COPY_WRITE_BUFFER_BINDING","COUNTER_STYLE_RULE","CSS","CSS2Properties","CSSAnimation","CSSCharsetRule","CSSConditionRule","CSSCounterStyleRule","CSSFontFaceRule","CSSFontFeatureValuesRule","CSSGroupingRule","CSSImageValue","CSSImportRule","CSSKeyframeRule","CSSKeyframesRule","CSSKeywordValue","CSSMathInvert","CSSMathMax","CSSMathMin","CSSMathNegate","CSSMathProduct","CSSMathSum","CSSMathValue","CSSMatrixComponent","CSSMediaRule","CSSMozDocumentRule","CSSNameSpaceRule","CSSNamespaceRule","CSSNumericArray","CSSNumericValue","CSSPageRule","CSSPerspective","CSSPositionValue","CSSPrimitiveValue","CSSRotate","CSSRule","CSSRuleList","CSSScale","CSSSkew","CSSSkewX","CSSSkewY","CSSStyleDeclaration","CSSStyleRule","CSSStyleSheet","CSSStyleValue","CSSSupportsRule","CSSTransformComponent","CSSTransformValue","CSSTransition","CSSTranslate","CSSUnitValue","CSSUnknownRule","CSSUnparsedValue","CSSValue","CSSValueList","CSSVariableReferenceValue","CSSVariablesDeclaration","CSSVariablesRule","CSSViewportRule","CSS_ATTR","CSS_CM","CSS_COUNTER","CSS_CUSTOM","CSS_DEG","CSS_DIMENSION","CSS_EMS","CSS_EXS","CSS_FILTER_BLUR","CSS_FILTER_BRIGHTNESS","CSS_FILTER_CONTRAST","CSS_FILTER_CUSTOM","CSS_FILTER_DROP_SHADOW","CSS_FILTER_GRAYSCALE","CSS_FILTER_HUE_ROTATE","CSS_FILTER_INVERT","CSS_FILTER_OPACITY","CSS_FILTER_REFERENCE","CSS_FILTER_SATURATE","CSS_FILTER_SEPIA","CSS_GRAD","CSS_HZ","CSS_IDENT","CSS_IN","CSS_INHERIT","CSS_KHZ","CSS_MATRIX","CSS_MATRIX3D","CSS_MM","CSS_MS","CSS_NUMBER","CSS_PC","CSS_PERCENTAGE","CSS_PERSPECTIVE","CSS_PRIMITIVE_VALUE","CSS_PT","CSS_PX","CSS_RAD","CSS_RECT","CSS_RGBCOLOR","CSS_ROTATE","CSS_ROTATE3D","CSS_ROTATEX","CSS_ROTATEY","CSS_ROTATEZ","CSS_S","CSS_SCALE","CSS_SCALE3D","CSS_SCALEX","CSS_SCALEY","CSS_SCALEZ","CSS_SKEW","CSS_SKEWX","CSS_SKEWY","CSS_STRING","CSS_TRANSLATE","CSS_TRANSLATE3D","CSS_TRANSLATEX","CSS_TRANSLATEY","CSS_TRANSLATEZ","CSS_UNKNOWN","CSS_URI","CSS_VALUE_LIST","CSS_VH","CSS_VMAX","CSS_VMIN","CSS_VW","CULL_FACE","CULL_FACE_MODE","CURRENT_PROGRAM","CURRENT_QUERY","CURRENT_VERTEX_ATTRIB","CUSTOM","CW","Cache","CacheStorage","CanvasCaptureMediaStream","CanvasCaptureMediaStreamTrack","CanvasGradient","CanvasPattern","CanvasRenderingContext2D","CaretPosition","ChannelMergerNode","ChannelSplitterNode","CharacterData","ClientRect","ClientRectList","Clipboard","ClipboardEvent","ClipboardItem","CloseEvent","Collator","CommandEvent","Comment","CompileError","CompositionEvent","CompressionStream","Console","ConstantSourceNode","Controllers","ConvolverNode","CountQueuingStrategy","Counter","Credential","CredentialsContainer","Crypto","CryptoKey","CustomElementRegistry","CustomEvent","DATABASE_ERR","DATA_CLONE_ERR","DATA_ERR","DBLCLICK","DECR","DECR_WRAP","DELETE_STATUS","DEPTH","DEPTH24_STENCIL8","DEPTH32F_STENCIL8","DEPTH_ATTACHMENT","DEPTH_BITS","DEPTH_BUFFER_BIT","DEPTH_CLEAR_VALUE","DEPTH_COMPONENT","DEPTH_COMPONENT16","DEPTH_COMPONENT24","DEPTH_COMPONENT32F","DEPTH_FUNC","DEPTH_RANGE","DEPTH_STENCIL","DEPTH_STENCIL_ATTACHMENT","DEPTH_TEST","DEPTH_WRITEMASK","DEVICE_INELIGIBLE","DIRECTION_DOWN","DIRECTION_LEFT","DIRECTION_RIGHT","DIRECTION_UP","DISABLED","DISPATCH_REQUEST_ERR","DITHER","DOCUMENT_FRAGMENT_NODE","DOCUMENT_NODE","DOCUMENT_POSITION_CONTAINED_BY","DOCUMENT_POSITION_CONTAINS","DOCUMENT_POSITION_DISCONNECTED","DOCUMENT_POSITION_FOLLOWING","DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC","DOCUMENT_POSITION_PRECEDING","DOCUMENT_TYPE_NODE","DOMCursor","DOMError","DOMException","DOMImplementation","DOMImplementationLS","DOMMatrix","DOMMatrixReadOnly","DOMParser","DOMPoint","DOMPointReadOnly","DOMQuad","DOMRect","DOMRectList","DOMRectReadOnly","DOMRequest","DOMSTRING_SIZE_ERR","DOMSettableTokenList","DOMStringList","DOMStringMap","DOMTokenList","DOMTransactionEvent","DOM_DELTA_LINE","DOM_DELTA_PAGE","DOM_DELTA_PIXEL","DOM_INPUT_METHOD_DROP","DOM_INPUT_METHOD_HANDWRITING","DOM_INPUT_METHOD_IME","DOM_INPUT_METHOD_KEYBOARD","DOM_INPUT_METHOD_MULTIMODAL","DOM_INPUT_METHOD_OPTION","DOM_INPUT_METHOD_PASTE","DOM_INPUT_METHOD_SCRIPT","DOM_INPUT_METHOD_UNKNOWN","DOM_INPUT_METHOD_VOICE","DOM_KEY_LOCATION_JOYSTICK","DOM_KEY_LOCATION_LEFT","DOM_KEY_LOCATION_MOBILE","DOM_KEY_LOCATION_NUMPAD","DOM_KEY_LOCATION_RIGHT","DOM_KEY_LOCATION_STANDARD","DOM_VK_0","DOM_VK_1","DOM_VK_2","DOM_VK_3","DOM_VK_4","DOM_VK_5","DOM_VK_6","DOM_VK_7","DOM_VK_8","DOM_VK_9","DOM_VK_A","DOM_VK_ACCEPT","DOM_VK_ADD","DOM_VK_ALT","DOM_VK_ALTGR","DOM_VK_AMPERSAND","DOM_VK_ASTERISK","DOM_VK_AT","DOM_VK_ATTN","DOM_VK_B","DOM_VK_BACKSPACE","DOM_VK_BACK_QUOTE","DOM_VK_BACK_SLASH","DOM_VK_BACK_SPACE","DOM_VK_C","DOM_VK_CANCEL","DOM_VK_CAPS_LOCK","DOM_VK_CIRCUMFLEX","DOM_VK_CLEAR","DOM_VK_CLOSE_BRACKET","DOM_VK_CLOSE_CURLY_BRACKET","DOM_VK_CLOSE_PAREN","DOM_VK_COLON","DOM_VK_COMMA","DOM_VK_CONTEXT_MENU","DOM_VK_CONTROL","DOM_VK_CONVERT","DOM_VK_CRSEL","DOM_VK_CTRL","DOM_VK_D","DOM_VK_DECIMAL","DOM_VK_DELETE","DOM_VK_DIVIDE","DOM_VK_DOLLAR","DOM_VK_DOUBLE_QUOTE","DOM_VK_DOWN","DOM_VK_E","DOM_VK_EISU","DOM_VK_END","DOM_VK_ENTER","DOM_VK_EQUALS","DOM_VK_EREOF","DOM_VK_ESCAPE","DOM_VK_EXCLAMATION","DOM_VK_EXECUTE","DOM_VK_EXSEL","DOM_VK_F","DOM_VK_F1","DOM_VK_F10","DOM_VK_F11","DOM_VK_F12","DOM_VK_F13","DOM_VK_F14","DOM_VK_F15","DOM_VK_F16","DOM_VK_F17","DOM_VK_F18","DOM_VK_F19","DOM_VK_F2","DOM_VK_F20","DOM_VK_F21","DOM_VK_F22","DOM_VK_F23","DOM_VK_F24","DOM_VK_F25","DOM_VK_F26","DOM_VK_F27","DOM_VK_F28","DOM_VK_F29","DOM_VK_F3","DOM_VK_F30","DOM_VK_F31","DOM_VK_F32","DOM_VK_F33","DOM_VK_F34","DOM_VK_F35","DOM_VK_F36","DOM_VK_F4","DOM_VK_F5","DOM_VK_F6","DOM_VK_F7","DOM_VK_F8","DOM_VK_F9","DOM_VK_FINAL","DOM_VK_FRONT","DOM_VK_G","DOM_VK_GREATER_THAN","DOM_VK_H","DOM_VK_HANGUL","DOM_VK_HANJA","DOM_VK_HASH","DOM_VK_HELP","DOM_VK_HK_TOGGLE","DOM_VK_HOME","DOM_VK_HYPHEN_MINUS","DOM_VK_I","DOM_VK_INSERT","DOM_VK_J","DOM_VK_JUNJA","DOM_VK_K","DOM_VK_KANA","DOM_VK_KANJI","DOM_VK_L","DOM_VK_LEFT","DOM_VK_LEFT_TAB","DOM_VK_LESS_THAN","DOM_VK_M","DOM_VK_META","DOM_VK_MODECHANGE","DOM_VK_MULTIPLY","DOM_VK_N","DOM_VK_NONCONVERT","DOM_VK_NUMPAD0","DOM_VK_NUMPAD1","DOM_VK_NUMPAD2","DOM_VK_NUMPAD3","DOM_VK_NUMPAD4","DOM_VK_NUMPAD5","DOM_VK_NUMPAD6","DOM_VK_NUMPAD7","DOM_VK_NUMPAD8","DOM_VK_NUMPAD9","DOM_VK_NUM_LOCK","DOM_VK_O","DOM_VK_OEM_1","DOM_VK_OEM_102","DOM_VK_OEM_2","DOM_VK_OEM_3","DOM_VK_OEM_4","DOM_VK_OEM_5","DOM_VK_OEM_6","DOM_VK_OEM_7","DOM_VK_OEM_8","DOM_VK_OEM_COMMA","DOM_VK_OEM_MINUS","DOM_VK_OEM_PERIOD","DOM_VK_OEM_PLUS","DOM_VK_OPEN_BRACKET","DOM_VK_OPEN_CURLY_BRACKET","DOM_VK_OPEN_PAREN","DOM_VK_P","DOM_VK_PA1","DOM_VK_PAGEDOWN","DOM_VK_PAGEUP","DOM_VK_PAGE_DOWN","DOM_VK_PAGE_UP","DOM_VK_PAUSE","DOM_VK_PERCENT","DOM_VK_PERIOD","DOM_VK_PIPE","DOM_VK_PLAY","DOM_VK_PLUS","DOM_VK_PRINT","DOM_VK_PRINTSCREEN","DOM_VK_PROCESSKEY","DOM_VK_PROPERITES","DOM_VK_Q","DOM_VK_QUESTION_MARK","DOM_VK_QUOTE","DOM_VK_R","DOM_VK_REDO","DOM_VK_RETURN","DOM_VK_RIGHT","DOM_VK_S","DOM_VK_SCROLL_LOCK","DOM_VK_SELECT","DOM_VK_SEMICOLON","DOM_VK_SEPARATOR","DOM_VK_SHIFT","DOM_VK_SLASH","DOM_VK_SLEEP","DOM_VK_SPACE","DOM_VK_SUBTRACT","DOM_VK_T","DOM_VK_TAB","DOM_VK_TILDE","DOM_VK_U","DOM_VK_UNDERSCORE","DOM_VK_UNDO","DOM_VK_UNICODE","DOM_VK_UP","DOM_VK_V","DOM_VK_VOLUME_DOWN","DOM_VK_VOLUME_MUTE","DOM_VK_VOLUME_UP","DOM_VK_W","DOM_VK_WIN","DOM_VK_WINDOW","DOM_VK_WIN_ICO_00","DOM_VK_WIN_ICO_CLEAR","DOM_VK_WIN_ICO_HELP","DOM_VK_WIN_OEM_ATTN","DOM_VK_WIN_OEM_AUTO","DOM_VK_WIN_OEM_BACKTAB","DOM_VK_WIN_OEM_CLEAR","DOM_VK_WIN_OEM_COPY","DOM_VK_WIN_OEM_CUSEL","DOM_VK_WIN_OEM_ENLW","DOM_VK_WIN_OEM_FINISH","DOM_VK_WIN_OEM_FJ_JISHO","DOM_VK_WIN_OEM_FJ_LOYA","DOM_VK_WIN_OEM_FJ_MASSHOU","DOM_VK_WIN_OEM_FJ_ROYA","DOM_VK_WIN_OEM_FJ_TOUROKU","DOM_VK_WIN_OEM_JUMP","DOM_VK_WIN_OEM_PA1","DOM_VK_WIN_OEM_PA2","DOM_VK_WIN_OEM_PA3","DOM_VK_WIN_OEM_RESET","DOM_VK_WIN_OEM_WSCTRL","DOM_VK_X","DOM_VK_XF86XK_ADD_FAVORITE","DOM_VK_XF86XK_APPLICATION_LEFT","DOM_VK_XF86XK_APPLICATION_RIGHT","DOM_VK_XF86XK_AUDIO_CYCLE_TRACK","DOM_VK_XF86XK_AUDIO_FORWARD","DOM_VK_XF86XK_AUDIO_LOWER_VOLUME","DOM_VK_XF86XK_AUDIO_MEDIA","DOM_VK_XF86XK_AUDIO_MUTE","DOM_VK_XF86XK_AUDIO_NEXT","DOM_VK_XF86XK_AUDIO_PAUSE","DOM_VK_XF86XK_AUDIO_PLAY","DOM_VK_XF86XK_AUDIO_PREV","DOM_VK_XF86XK_AUDIO_RAISE_VOLUME","DOM_VK_XF86XK_AUDIO_RANDOM_PLAY","DOM_VK_XF86XK_AUDIO_RECORD","DOM_VK_XF86XK_AUDIO_REPEAT","DOM_VK_XF86XK_AUDIO_REWIND","DOM_VK_XF86XK_AUDIO_STOP","DOM_VK_XF86XK_AWAY","DOM_VK_XF86XK_BACK","DOM_VK_XF86XK_BACK_FORWARD","DOM_VK_XF86XK_BATTERY","DOM_VK_XF86XK_BLUE","DOM_VK_XF86XK_BLUETOOTH","DOM_VK_XF86XK_BOOK","DOM_VK_XF86XK_BRIGHTNESS_ADJUST","DOM_VK_XF86XK_CALCULATOR","DOM_VK_XF86XK_CALENDAR","DOM_VK_XF86XK_CD","DOM_VK_XF86XK_CLOSE","DOM_VK_XF86XK_COMMUNITY","DOM_VK_XF86XK_CONTRAST_ADJUST","DOM_VK_XF86XK_COPY","DOM_VK_XF86XK_CUT","DOM_VK_XF86XK_CYCLE_ANGLE","DOM_VK_XF86XK_DISPLAY","DOM_VK_XF86XK_DOCUMENTS","DOM_VK_XF86XK_DOS","DOM_VK_XF86XK_EJECT","DOM_VK_XF86XK_EXCEL","DOM_VK_XF86XK_EXPLORER","DOM_VK_XF86XK_FAVORITES","DOM_VK_XF86XK_FINANCE","DOM_VK_XF86XK_FORWARD","DOM_VK_XF86XK_FRAME_BACK","DOM_VK_XF86XK_FRAME_FORWARD","DOM_VK_XF86XK_GAME","DOM_VK_XF86XK_GO","DOM_VK_XF86XK_GREEN","DOM_VK_XF86XK_HIBERNATE","DOM_VK_XF86XK_HISTORY","DOM_VK_XF86XK_HOME_PAGE","DOM_VK_XF86XK_HOT_LINKS","DOM_VK_XF86XK_I_TOUCH","DOM_VK_XF86XK_KBD_BRIGHTNESS_DOWN","DOM_VK_XF86XK_KBD_BRIGHTNESS_UP","DOM_VK_XF86XK_KBD_LIGHT_ON_OFF","DOM_VK_XF86XK_LAUNCH0","DOM_VK_XF86XK_LAUNCH1","DOM_VK_XF86XK_LAUNCH2","DOM_VK_XF86XK_LAUNCH3","DOM_VK_XF86XK_LAUNCH4","DOM_VK_XF86XK_LAUNCH5","DOM_VK_XF86XK_LAUNCH6","DOM_VK_XF86XK_LAUNCH7","DOM_VK_XF86XK_LAUNCH8","DOM_VK_XF86XK_LAUNCH9","DOM_VK_XF86XK_LAUNCH_A","DOM_VK_XF86XK_LAUNCH_B","DOM_VK_XF86XK_LAUNCH_C","DOM_VK_XF86XK_LAUNCH_D","DOM_VK_XF86XK_LAUNCH_E","DOM_VK_XF86XK_LAUNCH_F","DOM_VK_XF86XK_LIGHT_BULB","DOM_VK_XF86XK_LOG_OFF","DOM_VK_XF86XK_MAIL","DOM_VK_XF86XK_MAIL_FORWARD","DOM_VK_XF86XK_MARKET","DOM_VK_XF86XK_MEETING","DOM_VK_XF86XK_MEMO","DOM_VK_XF86XK_MENU_KB","DOM_VK_XF86XK_MENU_PB","DOM_VK_XF86XK_MESSENGER","DOM_VK_XF86XK_MON_BRIGHTNESS_DOWN","DOM_VK_XF86XK_MON_BRIGHTNESS_UP","DOM_VK_XF86XK_MUSIC","DOM_VK_XF86XK_MY_COMPUTER","DOM_VK_XF86XK_MY_SITES","DOM_VK_XF86XK_NEW","DOM_VK_XF86XK_NEWS","DOM_VK_XF86XK_OFFICE_HOME","DOM_VK_XF86XK_OPEN","DOM_VK_XF86XK_OPEN_URL","DOM_VK_XF86XK_OPTION","DOM_VK_XF86XK_PASTE","DOM_VK_XF86XK_PHONE","DOM_VK_XF86XK_PICTURES","DOM_VK_XF86XK_POWER_DOWN","DOM_VK_XF86XK_POWER_OFF","DOM_VK_XF86XK_RED","DOM_VK_XF86XK_REFRESH","DOM_VK_XF86XK_RELOAD","DOM_VK_XF86XK_REPLY","DOM_VK_XF86XK_ROCKER_DOWN","DOM_VK_XF86XK_ROCKER_ENTER","DOM_VK_XF86XK_ROCKER_UP","DOM_VK_XF86XK_ROTATE_WINDOWS","DOM_VK_XF86XK_ROTATION_KB","DOM_VK_XF86XK_ROTATION_PB","DOM_VK_XF86XK_SAVE","DOM_VK_XF86XK_SCREEN_SAVER","DOM_VK_XF86XK_SCROLL_CLICK","DOM_VK_XF86XK_SCROLL_DOWN","DOM_VK_XF86XK_SCROLL_UP","DOM_VK_XF86XK_SEARCH","DOM_VK_XF86XK_SEND","DOM_VK_XF86XK_SHOP","DOM_VK_XF86XK_SPELL","DOM_VK_XF86XK_SPLIT_SCREEN","DOM_VK_XF86XK_STANDBY","DOM_VK_XF86XK_START","DOM_VK_XF86XK_STOP","DOM_VK_XF86XK_SUBTITLE","DOM_VK_XF86XK_SUPPORT","DOM_VK_XF86XK_SUSPEND","DOM_VK_XF86XK_TASK_PANE","DOM_VK_XF86XK_TERMINAL","DOM_VK_XF86XK_TIME","DOM_VK_XF86XK_TOOLS","DOM_VK_XF86XK_TOP_MENU","DOM_VK_XF86XK_TO_DO_LIST","DOM_VK_XF86XK_TRAVEL","DOM_VK_XF86XK_USER1KB","DOM_VK_XF86XK_USER2KB","DOM_VK_XF86XK_USER_PB","DOM_VK_XF86XK_UWB","DOM_VK_XF86XK_VENDOR_HOME","DOM_VK_XF86XK_VIDEO","DOM_VK_XF86XK_VIEW","DOM_VK_XF86XK_WAKE_UP","DOM_VK_XF86XK_WEB_CAM","DOM_VK_XF86XK_WHEEL_BUTTON","DOM_VK_XF86XK_WLAN","DOM_VK_XF86XK_WORD","DOM_VK_XF86XK_WWW","DOM_VK_XF86XK_XFER","DOM_VK_XF86XK_YELLOW","DOM_VK_XF86XK_ZOOM_IN","DOM_VK_XF86XK_ZOOM_OUT","DOM_VK_Y","DOM_VK_Z","DOM_VK_ZOOM","DONE","DONT_CARE","DOWNLOADING","DRAGDROP","DRAW_BUFFER0","DRAW_BUFFER1","DRAW_BUFFER10","DRAW_BUFFER11","DRAW_BUFFER12","DRAW_BUFFER13","DRAW_BUFFER14","DRAW_BUFFER15","DRAW_BUFFER2","DRAW_BUFFER3","DRAW_BUFFER4","DRAW_BUFFER5","DRAW_BUFFER6","DRAW_BUFFER7","DRAW_BUFFER8","DRAW_BUFFER9","DRAW_FRAMEBUFFER","DRAW_FRAMEBUFFER_BINDING","DST_ALPHA","DST_COLOR","DYNAMIC_COPY","DYNAMIC_DRAW","DYNAMIC_READ","DataChannel","DataTransfer","DataTransferItem","DataTransferItemList","DataView","Date","DateTimeFormat","DecompressionStream","DelayNode","DeprecationReportBody","DesktopNotification","DesktopNotificationCenter","DeviceLightEvent","DeviceMotionEvent","DeviceMotionEventAcceleration","DeviceMotionEventRotationRate","DeviceOrientationEvent","DeviceProximityEvent","DeviceStorage","DeviceStorageChangeEvent","Directory","DisplayNames","Document","DocumentFragment","DocumentTimeline","DocumentType","DragEvent","DynamicsCompressorNode","E","ELEMENT_ARRAY_BUFFER","ELEMENT_ARRAY_BUFFER_BINDING","ELEMENT_NODE","EMPTY","ENCODING_ERR","ENDED","END_TO_END","END_TO_START","ENTITY_NODE","ENTITY_REFERENCE_NODE","EPSILON","EQUAL","EQUALPOWER","ERROR","EXPONENTIAL_DISTANCE","Element","ElementInternals","ElementQuery","EnterPictureInPictureEvent","Entity","EntityReference","Error","ErrorEvent","EvalError","Event","EventException","EventSource","EventTarget","External","FASTEST","FIDOSDK","FILTER_ACCEPT","FILTER_INTERRUPT","FILTER_REJECT","FILTER_SKIP","FINISHED_STATE","FIRST_ORDERED_NODE_TYPE","FLOAT","FLOAT_32_UNSIGNED_INT_24_8_REV","FLOAT_MAT2","FLOAT_MAT2x3","FLOAT_MAT2x4","FLOAT_MAT3","FLOAT_MAT3x2","FLOAT_MAT3x4","FLOAT_MAT4","FLOAT_MAT4x2","FLOAT_MAT4x3","FLOAT_VEC2","FLOAT_VEC3","FLOAT_VEC4","FOCUS","FONT_FACE_RULE","FONT_FEATURE_VALUES_RULE","FRAGMENT_SHADER","FRAGMENT_SHADER_DERIVATIVE_HINT","FRAGMENT_SHADER_DERIVATIVE_HINT_OES","FRAMEBUFFER","FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE","FRAMEBUFFER_ATTACHMENT_BLUE_SIZE","FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING","FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE","FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE","FRAMEBUFFER_ATTACHMENT_GREEN_SIZE","FRAMEBUFFER_ATTACHMENT_OBJECT_NAME","FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE","FRAMEBUFFER_ATTACHMENT_RED_SIZE","FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE","FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE","FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER","FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL","FRAMEBUFFER_BINDING","FRAMEBUFFER_COMPLETE","FRAMEBUFFER_DEFAULT","FRAMEBUFFER_INCOMPLETE_ATTACHMENT","FRAMEBUFFER_INCOMPLETE_DIMENSIONS","FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT","FRAMEBUFFER_INCOMPLETE_MULTISAMPLE","FRAMEBUFFER_UNSUPPORTED","FRONT","FRONT_AND_BACK","FRONT_FACE","FUNC_ADD","FUNC_REVERSE_SUBTRACT","FUNC_SUBTRACT","FeaturePolicy","FeaturePolicyViolationReportBody","FederatedCredential","Feed","FeedEntry","File","FileError","FileList","FileReader","FileSystem","FileSystemDirectoryEntry","FileSystemDirectoryReader","FileSystemEntry","FileSystemFileEntry","FinalizationRegistry","FindInPage","Float32Array","Float64Array","FocusEvent","FontFace","FontFaceSet","FontFaceSetLoadEvent","FormData","FormDataEvent","FragmentDirective","Function","GENERATE_MIPMAP_HINT","GEQUAL","GREATER","GREEN_BITS","GainNode","Gamepad","GamepadAxisMoveEvent","GamepadButton","GamepadButtonEvent","GamepadEvent","GamepadHapticActuator","GamepadPose","Geolocation","GeolocationCoordinates","GeolocationPosition","GeolocationPositionError","GestureEvent","Global","Gyroscope","HALF_FLOAT","HAVE_CURRENT_DATA","HAVE_ENOUGH_DATA","HAVE_FUTURE_DATA","HAVE_METADATA","HAVE_NOTHING","HEADERS_RECEIVED","HIDDEN","HIERARCHY_REQUEST_ERR","HIGHPASS","HIGHSHELF","HIGH_FLOAT","HIGH_INT","HORIZONTAL","HORIZONTAL_AXIS","HRTF","HTMLAllCollection","HTMLAnchorElement","HTMLAppletElement","HTMLAreaElement","HTMLAudioElement","HTMLBRElement","HTMLBaseElement","HTMLBaseFontElement","HTMLBlockquoteElement","HTMLBodyElement","HTMLButtonElement","HTMLCanvasElement","HTMLCollection","HTMLCommandElement","HTMLContentElement","HTMLDListElement","HTMLDataElement","HTMLDataListElement","HTMLDetailsElement","HTMLDialogElement","HTMLDirectoryElement","HTMLDivElement","HTMLDocument","HTMLElement","HTMLEmbedElement","HTMLFieldSetElement","HTMLFontElement","HTMLFormControlsCollection","HTMLFormElement","HTMLFrameElement","HTMLFrameSetElement","HTMLHRElement","HTMLHeadElement","HTMLHeadingElement","HTMLHtmlElement","HTMLIFrameElement","HTMLImageElement","HTMLInputElement","HTMLIsIndexElement","HTMLKeygenElement","HTMLLIElement","HTMLLabelElement","HTMLLegendElement","HTMLLinkElement","HTMLMapElement","HTMLMarqueeElement","HTMLMediaElement","HTMLMenuElement","HTMLMenuItemElement","HTMLMetaElement","HTMLMeterElement","HTMLModElement","HTMLOListElement","HTMLObjectElement","HTMLOptGroupElement","HTMLOptionElement","HTMLOptionsCollection","HTMLOutputElement","HTMLParagraphElement","HTMLParamElement","HTMLPictureElement","HTMLPreElement","HTMLProgressElement","HTMLPropertiesCollection","HTMLQuoteElement","HTMLScriptElement","HTMLSelectElement","HTMLShadowElement","HTMLSlotElement","HTMLSourceElement","HTMLSpanElement","HTMLStyleElement","HTMLTableCaptionElement","HTMLTableCellElement","HTMLTableColElement","HTMLTableElement","HTMLTableRowElement","HTMLTableSectionElement","HTMLTemplateElement","HTMLTextAreaElement","HTMLTimeElement","HTMLTitleElement","HTMLTrackElement","HTMLUListElement","HTMLUnknownElement","HTMLVideoElement","HashChangeEvent","Headers","History","Hz","ICE_CHECKING","ICE_CLOSED","ICE_COMPLETED","ICE_CONNECTED","ICE_FAILED","ICE_GATHERING","ICE_WAITING","IDBCursor","IDBCursorWithValue","IDBDatabase","IDBDatabaseException","IDBFactory","IDBFileHandle","IDBFileRequest","IDBIndex","IDBKeyRange","IDBMutableFile","IDBObjectStore","IDBOpenDBRequest","IDBRequest","IDBTransaction","IDBVersionChangeEvent","IDLE","IIRFilterNode","IMPLEMENTATION_COLOR_READ_FORMAT","IMPLEMENTATION_COLOR_READ_TYPE","IMPORT_RULE","INCR","INCR_WRAP","INDEX_SIZE_ERR","INT","INTERLEAVED_ATTRIBS","INT_2_10_10_10_REV","INT_SAMPLER_2D","INT_SAMPLER_2D_ARRAY","INT_SAMPLER_3D","INT_SAMPLER_CUBE","INT_VEC2","INT_VEC3","INT_VEC4","INUSE_ATTRIBUTE_ERR","INVALID_ACCESS_ERR","INVALID_CHARACTER_ERR","INVALID_ENUM","INVALID_EXPRESSION_ERR","INVALID_FRAMEBUFFER_OPERATION","INVALID_INDEX","INVALID_MODIFICATION_ERR","INVALID_NODE_TYPE_ERR","INVALID_OPERATION","INVALID_STATE_ERR","INVALID_VALUE","INVERSE_DISTANCE","INVERT","IceCandidate","IdleDeadline","Image","ImageBitmap","ImageBitmapRenderingContext","ImageCapture","ImageData","Infinity","InputDeviceCapabilities","InputDeviceInfo","InputEvent","InputMethodContext","InstallTrigger","InstallTriggerImpl","Instance","Int16Array","Int32Array","Int8Array","Intent","InternalError","IntersectionObserver","IntersectionObserverEntry","Intl","IsSearchProviderInstalled","Iterator","JSON","KEEP","KEYDOWN","KEYFRAMES_RULE","KEYFRAME_RULE","KEYPRESS","KEYUP","KeyEvent","Keyboard","KeyboardEvent","KeyboardLayoutMap","KeyframeEffect","LENGTHADJUST_SPACING","LENGTHADJUST_SPACINGANDGLYPHS","LENGTHADJUST_UNKNOWN","LEQUAL","LESS","LINEAR","LINEAR_DISTANCE","LINEAR_MIPMAP_LINEAR","LINEAR_MIPMAP_NEAREST","LINES","LINE_LOOP","LINE_STRIP","LINE_WIDTH","LINK_STATUS","LIVE","LN10","LN2","LOADED","LOADING","LOG10E","LOG2E","LOWPASS","LOWSHELF","LOW_FLOAT","LOW_INT","LSException","LSParserFilter","LUMINANCE","LUMINANCE_ALPHA","LargestContentfulPaint","LayoutShift","LayoutShiftAttribution","LinearAccelerationSensor","LinkError","ListFormat","LocalMediaStream","Locale","Location","Lock","LockManager","MAX","MAX_3D_TEXTURE_SIZE","MAX_ARRAY_TEXTURE_LAYERS","MAX_CLIENT_WAIT_TIMEOUT_WEBGL","MAX_COLOR_ATTACHMENTS","MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS","MAX_COMBINED_TEXTURE_IMAGE_UNITS","MAX_COMBINED_UNIFORM_BLOCKS","MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS","MAX_CUBE_MAP_TEXTURE_SIZE","MAX_DRAW_BUFFERS","MAX_ELEMENTS_INDICES","MAX_ELEMENTS_VERTICES","MAX_ELEMENT_INDEX","MAX_FRAGMENT_INPUT_COMPONENTS","MAX_FRAGMENT_UNIFORM_BLOCKS","MAX_FRAGMENT_UNIFORM_COMPONENTS","MAX_FRAGMENT_UNIFORM_VECTORS","MAX_PROGRAM_TEXEL_OFFSET","MAX_RENDERBUFFER_SIZE","MAX_SAFE_INTEGER","MAX_SAMPLES","MAX_SERVER_WAIT_TIMEOUT","MAX_TEXTURE_IMAGE_UNITS","MAX_TEXTURE_LOD_BIAS","MAX_TEXTURE_MAX_ANISOTROPY_EXT","MAX_TEXTURE_SIZE","MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS","MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS","MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS","MAX_UNIFORM_BLOCK_SIZE","MAX_UNIFORM_BUFFER_BINDINGS","MAX_VALUE","MAX_VARYING_COMPONENTS","MAX_VARYING_VECTORS","MAX_VERTEX_ATTRIBS","MAX_VERTEX_OUTPUT_COMPONENTS","MAX_VERTEX_TEXTURE_IMAGE_UNITS","MAX_VERTEX_UNIFORM_BLOCKS","MAX_VERTEX_UNIFORM_COMPONENTS","MAX_VERTEX_UNIFORM_VECTORS","MAX_VIEWPORT_DIMS","MEDIA_ERR_ABORTED","MEDIA_ERR_DECODE","MEDIA_ERR_ENCRYPTED","MEDIA_ERR_NETWORK","MEDIA_ERR_SRC_NOT_SUPPORTED","MEDIA_KEYERR_CLIENT","MEDIA_KEYERR_DOMAIN","MEDIA_KEYERR_HARDWARECHANGE","MEDIA_KEYERR_OUTPUT","MEDIA_KEYERR_SERVICE","MEDIA_KEYERR_UNKNOWN","MEDIA_RULE","MEDIUM_FLOAT","MEDIUM_INT","META_MASK","MIDIAccess","MIDIConnectionEvent","MIDIInput","MIDIInputMap","MIDIMessageEvent","MIDIOutput","MIDIOutputMap","MIDIPort","MIN","MIN_PROGRAM_TEXEL_OFFSET","MIN_SAFE_INTEGER","MIN_VALUE","MIRRORED_REPEAT","MODE_ASYNCHRONOUS","MODE_SYNCHRONOUS","MODIFICATION","MOUSEDOWN","MOUSEDRAG","MOUSEMOVE","MOUSEOUT","MOUSEOVER","MOUSEUP","MOZ_KEYFRAMES_RULE","MOZ_KEYFRAME_RULE","MOZ_SOURCE_CURSOR","MOZ_SOURCE_ERASER","MOZ_SOURCE_KEYBOARD","MOZ_SOURCE_MOUSE","MOZ_SOURCE_PEN","MOZ_SOURCE_TOUCH","MOZ_SOURCE_UNKNOWN","MSGESTURE_FLAG_BEGIN","MSGESTURE_FLAG_CANCEL","MSGESTURE_FLAG_END","MSGESTURE_FLAG_INERTIA","MSGESTURE_FLAG_NONE","MSPOINTER_TYPE_MOUSE","MSPOINTER_TYPE_PEN","MSPOINTER_TYPE_TOUCH","MS_ASYNC_CALLBACK_STATUS_ASSIGN_DELEGATE","MS_ASYNC_CALLBACK_STATUS_CANCEL","MS_ASYNC_CALLBACK_STATUS_CHOOSEANY","MS_ASYNC_CALLBACK_STATUS_ERROR","MS_ASYNC_CALLBACK_STATUS_JOIN","MS_ASYNC_OP_STATUS_CANCELED","MS_ASYNC_OP_STATUS_ERROR","MS_ASYNC_OP_STATUS_SUCCESS","MS_MANIPULATION_STATE_ACTIVE","MS_MANIPULATION_STATE_CANCELLED","MS_MANIPULATION_STATE_COMMITTED","MS_MANIPULATION_STATE_DRAGGING","MS_MANIPULATION_STATE_INERTIA","MS_MANIPULATION_STATE_PRESELECT","MS_MANIPULATION_STATE_SELECTING","MS_MANIPULATION_STATE_STOPPED","MS_MEDIA_ERR_ENCRYPTED","MS_MEDIA_KEYERR_CLIENT","MS_MEDIA_KEYERR_DOMAIN","MS_MEDIA_KEYERR_HARDWARECHANGE","MS_MEDIA_KEYERR_OUTPUT","MS_MEDIA_KEYERR_SERVICE","MS_MEDIA_KEYERR_UNKNOWN","Map","Math","MathMLElement","MediaCapabilities","MediaCapabilitiesInfo","MediaController","MediaDeviceInfo","MediaDevices","MediaElementAudioSourceNode","MediaEncryptedEvent","MediaError","MediaKeyError","MediaKeyEvent","MediaKeyMessageEvent","MediaKeyNeededEvent","MediaKeySession","MediaKeyStatusMap","MediaKeySystemAccess","MediaKeys","MediaList","MediaMetadata","MediaQueryList","MediaQueryListEvent","MediaRecorder","MediaRecorderErrorEvent","MediaSession","MediaSettingsRange","MediaSource","MediaStream","MediaStreamAudioDestinationNode","MediaStreamAudioSourceNode","MediaStreamEvent","MediaStreamTrack","MediaStreamTrackAudioSourceNode","MediaStreamTrackEvent","Memory","MessageChannel","MessageEvent","MessagePort","Methods","MimeType","MimeTypeArray","Module","MouseEvent","MouseScrollEvent","MozAnimation","MozAnimationDelay","MozAnimationDirection","MozAnimationDuration","MozAnimationFillMode","MozAnimationIterationCount","MozAnimationName","MozAnimationPlayState","MozAnimationTimingFunction","MozAppearance","MozBackfaceVisibility","MozBinding","MozBorderBottomColors","MozBorderEnd","MozBorderEndColor","MozBorderEndStyle","MozBorderEndWidth","MozBorderImage","MozBorderLeftColors","MozBorderRightColors","MozBorderStart","MozBorderStartColor","MozBorderStartStyle","MozBorderStartWidth","MozBorderTopColors","MozBoxAlign","MozBoxDirection","MozBoxFlex","MozBoxOrdinalGroup","MozBoxOrient","MozBoxPack","MozBoxSizing","MozCSSKeyframeRule","MozCSSKeyframesRule","MozColumnCount","MozColumnFill","MozColumnGap","MozColumnRule","MozColumnRuleColor","MozColumnRuleStyle","MozColumnRuleWidth","MozColumnWidth","MozColumns","MozContactChangeEvent","MozFloatEdge","MozFontFeatureSettings","MozFontLanguageOverride","MozForceBrokenImageIcon","MozHyphens","MozImageRegion","MozMarginEnd","MozMarginStart","MozMmsEvent","MozMmsMessage","MozMobileMessageThread","MozOSXFontSmoothing","MozOrient","MozOsxFontSmoothing","MozOutlineRadius","MozOutlineRadiusBottomleft","MozOutlineRadiusBottomright","MozOutlineRadiusTopleft","MozOutlineRadiusTopright","MozPaddingEnd","MozPaddingStart","MozPerspective","MozPerspectiveOrigin","MozPowerManager","MozSettingsEvent","MozSmsEvent","MozSmsMessage","MozStackSizing","MozTabSize","MozTextAlignLast","MozTextDecorationColor","MozTextDecorationLine","MozTextDecorationStyle","MozTextSizeAdjust","MozTransform","MozTransformOrigin","MozTransformStyle","MozTransition","MozTransitionDelay","MozTransitionDuration","MozTransitionProperty","MozTransitionTimingFunction","MozUserFocus","MozUserInput","MozUserModify","MozUserSelect","MozWindowDragging","MozWindowShadow","MutationEvent","MutationObserver","MutationRecord","NAMESPACE_ERR","NAMESPACE_RULE","NEAREST","NEAREST_MIPMAP_LINEAR","NEAREST_MIPMAP_NEAREST","NEGATIVE_INFINITY","NETWORK_EMPTY","NETWORK_ERR","NETWORK_IDLE","NETWORK_LOADED","NETWORK_LOADING","NETWORK_NO_SOURCE","NEVER","NEW","NEXT","NEXT_NO_DUPLICATE","NICEST","NODE_AFTER","NODE_BEFORE","NODE_BEFORE_AND_AFTER","NODE_INSIDE","NONE","NON_TRANSIENT_ERR","NOTATION_NODE","NOTCH","NOTEQUAL","NOT_ALLOWED_ERR","NOT_FOUND_ERR","NOT_READABLE_ERR","NOT_SUPPORTED_ERR","NO_DATA_ALLOWED_ERR","NO_ERR","NO_ERROR","NO_MODIFICATION_ALLOWED_ERR","NUMBER_TYPE","NUM_COMPRESSED_TEXTURE_FORMATS","NaN","NamedNodeMap","NavigationPreloadManager","Navigator","NearbyLinks","NetworkInformation","Node","NodeFilter","NodeIterator","NodeList","Notation","Notification","NotifyPaintEvent","Number","NumberFormat","OBJECT_TYPE","OBSOLETE","OK","ONE","ONE_MINUS_CONSTANT_ALPHA","ONE_MINUS_CONSTANT_COLOR","ONE_MINUS_DST_ALPHA","ONE_MINUS_DST_COLOR","ONE_MINUS_SRC_ALPHA","ONE_MINUS_SRC_COLOR","OPEN","OPENED","OPENING","ORDERED_NODE_ITERATOR_TYPE","ORDERED_NODE_SNAPSHOT_TYPE","OTHER_ERROR","OUT_OF_MEMORY","Object","OfflineAudioCompletionEvent","OfflineAudioContext","OfflineResourceList","OffscreenCanvas","OffscreenCanvasRenderingContext2D","Option","OrientationSensor","OscillatorNode","OverconstrainedError","OverflowEvent","PACK_ALIGNMENT","PACK_ROW_LENGTH","PACK_SKIP_PIXELS","PACK_SKIP_ROWS","PAGE_RULE","PARSE_ERR","PATHSEG_ARC_ABS","PATHSEG_ARC_REL","PATHSEG_CLOSEPATH","PATHSEG_CURVETO_CUBIC_ABS","PATHSEG_CURVETO_CUBIC_REL","PATHSEG_CURVETO_CUBIC_SMOOTH_ABS","PATHSEG_CURVETO_CUBIC_SMOOTH_REL","PATHSEG_CURVETO_QUADRATIC_ABS","PATHSEG_CURVETO_QUADRATIC_REL","PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS","PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL","PATHSEG_LINETO_ABS","PATHSEG_LINETO_HORIZONTAL_ABS","PATHSEG_LINETO_HORIZONTAL_REL","PATHSEG_LINETO_REL","PATHSEG_LINETO_VERTICAL_ABS","PATHSEG_LINETO_VERTICAL_REL","PATHSEG_MOVETO_ABS","PATHSEG_MOVETO_REL","PATHSEG_UNKNOWN","PATH_EXISTS_ERR","PEAKING","PERMISSION_DENIED","PERSISTENT","PI","PIXEL_PACK_BUFFER","PIXEL_PACK_BUFFER_BINDING","PIXEL_UNPACK_BUFFER","PIXEL_UNPACK_BUFFER_BINDING","PLAYING_STATE","POINTS","POLYGON_OFFSET_FACTOR","POLYGON_OFFSET_FILL","POLYGON_OFFSET_UNITS","POSITION_UNAVAILABLE","POSITIVE_INFINITY","PREV","PREV_NO_DUPLICATE","PROCESSING_INSTRUCTION_NODE","PageChangeEvent","PageTransitionEvent","PaintRequest","PaintRequestList","PannerNode","PasswordCredential","Path2D","PaymentAddress","PaymentInstruments","PaymentManager","PaymentMethodChangeEvent","PaymentRequest","PaymentRequestUpdateEvent","PaymentResponse","Performance","PerformanceElementTiming","PerformanceEntry","PerformanceEventTiming","PerformanceLongTaskTiming","PerformanceMark","PerformanceMeasure","PerformanceNavigation","PerformanceNavigationTiming","PerformanceObserver","PerformanceObserverEntryList","PerformancePaintTiming","PerformanceResourceTiming","PerformanceServerTiming","PerformanceTiming","PeriodicSyncManager","PeriodicWave","PermissionStatus","Permissions","PhotoCapabilities","PictureInPictureWindow","Plugin","PluginArray","PluralRules","PointerEvent","PopStateEvent","PopupBlockedEvent","Presentation","PresentationAvailability","PresentationConnection","PresentationConnectionAvailableEvent","PresentationConnectionCloseEvent","PresentationConnectionList","PresentationReceiver","PresentationRequest","ProcessingInstruction","ProgressEvent","Promise","PromiseRejectionEvent","PropertyNodeList","Proxy","PublicKeyCredential","PushManager","PushSubscription","PushSubscriptionOptions","Q","QUERY_RESULT","QUERY_RESULT_AVAILABLE","QUOTA_ERR","QUOTA_EXCEEDED_ERR","QueryInterface","R11F_G11F_B10F","R16F","R16I","R16UI","R32F","R32I","R32UI","R8","R8I","R8UI","R8_SNORM","RASTERIZER_DISCARD","READ_BUFFER","READ_FRAMEBUFFER","READ_FRAMEBUFFER_BINDING","READ_ONLY","READ_ONLY_ERR","READ_WRITE","RED","RED_BITS","RED_INTEGER","REMOVAL","RENDERBUFFER","RENDERBUFFER_ALPHA_SIZE","RENDERBUFFER_BINDING","RENDERBUFFER_BLUE_SIZE","RENDERBUFFER_DEPTH_SIZE","RENDERBUFFER_GREEN_SIZE","RENDERBUFFER_HEIGHT","RENDERBUFFER_INTERNAL_FORMAT","RENDERBUFFER_RED_SIZE","RENDERBUFFER_SAMPLES","RENDERBUFFER_STENCIL_SIZE","RENDERBUFFER_WIDTH","RENDERER","RENDERING_INTENT_ABSOLUTE_COLORIMETRIC","RENDERING_INTENT_AUTO","RENDERING_INTENT_PERCEPTUAL","RENDERING_INTENT_RELATIVE_COLORIMETRIC","RENDERING_INTENT_SATURATION","RENDERING_INTENT_UNKNOWN","REPEAT","REPLACE","RG","RG16F","RG16I","RG16UI","RG32F","RG32I","RG32UI","RG8","RG8I","RG8UI","RG8_SNORM","RGB","RGB10_A2","RGB10_A2UI","RGB16F","RGB16I","RGB16UI","RGB32F","RGB32I","RGB32UI","RGB565","RGB5_A1","RGB8","RGB8I","RGB8UI","RGB8_SNORM","RGB9_E5","RGBA","RGBA16F","RGBA16I","RGBA16UI","RGBA32F","RGBA32I","RGBA32UI","RGBA4","RGBA8","RGBA8I","RGBA8UI","RGBA8_SNORM","RGBA_INTEGER","RGBColor","RGB_INTEGER","RG_INTEGER","ROTATION_CLOCKWISE","ROTATION_COUNTERCLOCKWISE","RTCCertificate","RTCDTMFSender","RTCDTMFToneChangeEvent","RTCDataChannel","RTCDataChannelEvent","RTCDtlsTransport","RTCError","RTCErrorEvent","RTCIceCandidate","RTCIceTransport","RTCPeerConnection","RTCPeerConnectionIceErrorEvent","RTCPeerConnectionIceEvent","RTCRtpReceiver","RTCRtpSender","RTCRtpTransceiver","RTCSctpTransport","RTCSessionDescription","RTCStatsReport","RTCTrackEvent","RadioNodeList","Range","RangeError","RangeException","ReadableStream","ReadableStreamDefaultReader","RecordErrorEvent","Rect","ReferenceError","Reflect","RegExp","RelativeOrientationSensor","RelativeTimeFormat","RemotePlayback","Report","ReportBody","ReportingObserver","Request","ResizeObserver","ResizeObserverEntry","ResizeObserverSize","Response","RuntimeError","SAMPLER_2D","SAMPLER_2D_ARRAY","SAMPLER_2D_ARRAY_SHADOW","SAMPLER_2D_SHADOW","SAMPLER_3D","SAMPLER_BINDING","SAMPLER_CUBE","SAMPLER_CUBE_SHADOW","SAMPLES","SAMPLE_ALPHA_TO_COVERAGE","SAMPLE_BUFFERS","SAMPLE_COVERAGE","SAMPLE_COVERAGE_INVERT","SAMPLE_COVERAGE_VALUE","SAWTOOTH","SCHEDULED_STATE","SCISSOR_BOX","SCISSOR_TEST","SCROLL_PAGE_DOWN","SCROLL_PAGE_UP","SDP_ANSWER","SDP_OFFER","SDP_PRANSWER","SECURITY_ERR","SELECT","SEPARATE_ATTRIBS","SERIALIZE_ERR","SEVERITY_ERROR","SEVERITY_FATAL_ERROR","SEVERITY_WARNING","SHADER_COMPILER","SHADER_TYPE","SHADING_LANGUAGE_VERSION","SHIFT_MASK","SHORT","SHOWING","SHOW_ALL","SHOW_ATTRIBUTE","SHOW_CDATA_SECTION","SHOW_COMMENT","SHOW_DOCUMENT","SHOW_DOCUMENT_FRAGMENT","SHOW_DOCUMENT_TYPE","SHOW_ELEMENT","SHOW_ENTITY","SHOW_ENTITY_REFERENCE","SHOW_NOTATION","SHOW_PROCESSING_INSTRUCTION","SHOW_TEXT","SIGNALED","SIGNED_NORMALIZED","SINE","SOUNDFIELD","SQLException","SQRT1_2","SQRT2","SQUARE","SRC_ALPHA","SRC_ALPHA_SATURATE","SRC_COLOR","SRGB","SRGB8","SRGB8_ALPHA8","START_TO_END","START_TO_START","STATIC_COPY","STATIC_DRAW","STATIC_READ","STENCIL","STENCIL_ATTACHMENT","STENCIL_BACK_FAIL","STENCIL_BACK_FUNC","STENCIL_BACK_PASS_DEPTH_FAIL","STENCIL_BACK_PASS_DEPTH_PASS","STENCIL_BACK_REF","STENCIL_BACK_VALUE_MASK","STENCIL_BACK_WRITEMASK","STENCIL_BITS","STENCIL_BUFFER_BIT","STENCIL_CLEAR_VALUE","STENCIL_FAIL","STENCIL_FUNC","STENCIL_INDEX","STENCIL_INDEX8","STENCIL_PASS_DEPTH_FAIL","STENCIL_PASS_DEPTH_PASS","STENCIL_REF","STENCIL_TEST","STENCIL_VALUE_MASK","STENCIL_WRITEMASK","STREAM_COPY","STREAM_DRAW","STREAM_READ","STRING_TYPE","STYLE_RULE","SUBPIXEL_BITS","SUPPORTS_RULE","SVGAElement","SVGAltGlyphDefElement","SVGAltGlyphElement","SVGAltGlyphItemElement","SVGAngle","SVGAnimateColorElement","SVGAnimateElement","SVGAnimateMotionElement","SVGAnimateTransformElement","SVGAnimatedAngle","SVGAnimatedBoolean","SVGAnimatedEnumeration","SVGAnimatedInteger","SVGAnimatedLength","SVGAnimatedLengthList","SVGAnimatedNumber","SVGAnimatedNumberList","SVGAnimatedPreserveAspectRatio","SVGAnimatedRect","SVGAnimatedString","SVGAnimatedTransformList","SVGAnimationElement","SVGCircleElement","SVGClipPathElement","SVGColor","SVGComponentTransferFunctionElement","SVGCursorElement","SVGDefsElement","SVGDescElement","SVGDiscardElement","SVGDocument","SVGElement","SVGElementInstance","SVGElementInstanceList","SVGEllipseElement","SVGException","SVGFEBlendElement","SVGFEColorMatrixElement","SVGFEComponentTransferElement","SVGFECompositeElement","SVGFEConvolveMatrixElement","SVGFEDiffuseLightingElement","SVGFEDisplacementMapElement","SVGFEDistantLightElement","SVGFEDropShadowElement","SVGFEFloodElement","SVGFEFuncAElement","SVGFEFuncBElement","SVGFEFuncGElement","SVGFEFuncRElement","SVGFEGaussianBlurElement","SVGFEImageElement","SVGFEMergeElement","SVGFEMergeNodeElement","SVGFEMorphologyElement","SVGFEOffsetElement","SVGFEPointLightElement","SVGFESpecularLightingElement","SVGFESpotLightElement","SVGFETileElement","SVGFETurbulenceElement","SVGFilterElement","SVGFontElement","SVGFontFaceElement","SVGFontFaceFormatElement","SVGFontFaceNameElement","SVGFontFaceSrcElement","SVGFontFaceUriElement","SVGForeignObjectElement","SVGGElement","SVGGeometryElement","SVGGlyphElement","SVGGlyphRefElement","SVGGradientElement","SVGGraphicsElement","SVGHKernElement","SVGImageElement","SVGLength","SVGLengthList","SVGLineElement","SVGLinearGradientElement","SVGMPathElement","SVGMarkerElement","SVGMaskElement","SVGMatrix","SVGMetadataElement","SVGMissingGlyphElement","SVGNumber","SVGNumberList","SVGPaint","SVGPathElement","SVGPathSeg","SVGPathSegArcAbs","SVGPathSegArcRel","SVGPathSegClosePath","SVGPathSegCurvetoCubicAbs","SVGPathSegCurvetoCubicRel","SVGPathSegCurvetoCubicSmoothAbs","SVGPathSegCurvetoCubicSmoothRel","SVGPathSegCurvetoQuadraticAbs","SVGPathSegCurvetoQuadraticRel","SVGPathSegCurvetoQuadraticSmoothAbs","SVGPathSegCurvetoQuadraticSmoothRel","SVGPathSegLinetoAbs","SVGPathSegLinetoHorizontalAbs","SVGPathSegLinetoHorizontalRel","SVGPathSegLinetoRel","SVGPathSegLinetoVerticalAbs","SVGPathSegLinetoVerticalRel","SVGPathSegList","SVGPathSegMovetoAbs","SVGPathSegMovetoRel","SVGPatternElement","SVGPoint","SVGPointList","SVGPolygonElement","SVGPolylineElement","SVGPreserveAspectRatio","SVGRadialGradientElement","SVGRect","SVGRectElement","SVGRenderingIntent","SVGSVGElement","SVGScriptElement","SVGSetElement","SVGStopElement","SVGStringList","SVGStyleElement","SVGSwitchElement","SVGSymbolElement","SVGTRefElement","SVGTSpanElement","SVGTextContentElement","SVGTextElement","SVGTextPathElement","SVGTextPositioningElement","SVGTitleElement","SVGTransform","SVGTransformList","SVGUnitTypes","SVGUseElement","SVGVKernElement","SVGViewElement","SVGViewSpec","SVGZoomAndPan","SVGZoomEvent","SVG_ANGLETYPE_DEG","SVG_ANGLETYPE_GRAD","SVG_ANGLETYPE_RAD","SVG_ANGLETYPE_UNKNOWN","SVG_ANGLETYPE_UNSPECIFIED","SVG_CHANNEL_A","SVG_CHANNEL_B","SVG_CHANNEL_G","SVG_CHANNEL_R","SVG_CHANNEL_UNKNOWN","SVG_COLORTYPE_CURRENTCOLOR","SVG_COLORTYPE_RGBCOLOR","SVG_COLORTYPE_RGBCOLOR_ICCCOLOR","SVG_COLORTYPE_UNKNOWN","SVG_EDGEMODE_DUPLICATE","SVG_EDGEMODE_NONE","SVG_EDGEMODE_UNKNOWN","SVG_EDGEMODE_WRAP","SVG_FEBLEND_MODE_COLOR","SVG_FEBLEND_MODE_COLOR_BURN","SVG_FEBLEND_MODE_COLOR_DODGE","SVG_FEBLEND_MODE_DARKEN","SVG_FEBLEND_MODE_DIFFERENCE","SVG_FEBLEND_MODE_EXCLUSION","SVG_FEBLEND_MODE_HARD_LIGHT","SVG_FEBLEND_MODE_HUE","SVG_FEBLEND_MODE_LIGHTEN","SVG_FEBLEND_MODE_LUMINOSITY","SVG_FEBLEND_MODE_MULTIPLY","SVG_FEBLEND_MODE_NORMAL","SVG_FEBLEND_MODE_OVERLAY","SVG_FEBLEND_MODE_SATURATION","SVG_FEBLEND_MODE_SCREEN","SVG_FEBLEND_MODE_SOFT_LIGHT","SVG_FEBLEND_MODE_UNKNOWN","SVG_FECOLORMATRIX_TYPE_HUEROTATE","SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA","SVG_FECOLORMATRIX_TYPE_MATRIX","SVG_FECOLORMATRIX_TYPE_SATURATE","SVG_FECOLORMATRIX_TYPE_UNKNOWN","SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE","SVG_FECOMPONENTTRANSFER_TYPE_GAMMA","SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY","SVG_FECOMPONENTTRANSFER_TYPE_LINEAR","SVG_FECOMPONENTTRANSFER_TYPE_TABLE","SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN","SVG_FECOMPOSITE_OPERATOR_ARITHMETIC","SVG_FECOMPOSITE_OPERATOR_ATOP","SVG_FECOMPOSITE_OPERATOR_IN","SVG_FECOMPOSITE_OPERATOR_OUT","SVG_FECOMPOSITE_OPERATOR_OVER","SVG_FECOMPOSITE_OPERATOR_UNKNOWN","SVG_FECOMPOSITE_OPERATOR_XOR","SVG_INVALID_VALUE_ERR","SVG_LENGTHTYPE_CM","SVG_LENGTHTYPE_EMS","SVG_LENGTHTYPE_EXS","SVG_LENGTHTYPE_IN","SVG_LENGTHTYPE_MM","SVG_LENGTHTYPE_NUMBER","SVG_LENGTHTYPE_PC","SVG_LENGTHTYPE_PERCENTAGE","SVG_LENGTHTYPE_PT","SVG_LENGTHTYPE_PX","SVG_LENGTHTYPE_UNKNOWN","SVG_MARKERUNITS_STROKEWIDTH","SVG_MARKERUNITS_UNKNOWN","SVG_MARKERUNITS_USERSPACEONUSE","SVG_MARKER_ORIENT_ANGLE","SVG_MARKER_ORIENT_AUTO","SVG_MARKER_ORIENT_UNKNOWN","SVG_MASKTYPE_ALPHA","SVG_MASKTYPE_LUMINANCE","SVG_MATRIX_NOT_INVERTABLE","SVG_MEETORSLICE_MEET","SVG_MEETORSLICE_SLICE","SVG_MEETORSLICE_UNKNOWN","SVG_MORPHOLOGY_OPERATOR_DILATE","SVG_MORPHOLOGY_OPERATOR_ERODE","SVG_MORPHOLOGY_OPERATOR_UNKNOWN","SVG_PAINTTYPE_CURRENTCOLOR","SVG_PAINTTYPE_NONE","SVG_PAINTTYPE_RGBCOLOR","SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR","SVG_PAINTTYPE_UNKNOWN","SVG_PAINTTYPE_URI","SVG_PAINTTYPE_URI_CURRENTCOLOR","SVG_PAINTTYPE_URI_NONE","SVG_PAINTTYPE_URI_RGBCOLOR","SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR","SVG_PRESERVEASPECTRATIO_NONE","SVG_PRESERVEASPECTRATIO_UNKNOWN","SVG_PRESERVEASPECTRATIO_XMAXYMAX","SVG_PRESERVEASPECTRATIO_XMAXYMID","SVG_PRESERVEASPECTRATIO_XMAXYMIN","SVG_PRESERVEASPECTRATIO_XMIDYMAX","SVG_PRESERVEASPECTRATIO_XMIDYMID","SVG_PRESERVEASPECTRATIO_XMIDYMIN","SVG_PRESERVEASPECTRATIO_XMINYMAX","SVG_PRESERVEASPECTRATIO_XMINYMID","SVG_PRESERVEASPECTRATIO_XMINYMIN","SVG_SPREADMETHOD_PAD","SVG_SPREADMETHOD_REFLECT","SVG_SPREADMETHOD_REPEAT","SVG_SPREADMETHOD_UNKNOWN","SVG_STITCHTYPE_NOSTITCH","SVG_STITCHTYPE_STITCH","SVG_STITCHTYPE_UNKNOWN","SVG_TRANSFORM_MATRIX","SVG_TRANSFORM_ROTATE","SVG_TRANSFORM_SCALE","SVG_TRANSFORM_SKEWX","SVG_TRANSFORM_SKEWY","SVG_TRANSFORM_TRANSLATE","SVG_TRANSFORM_UNKNOWN","SVG_TURBULENCE_TYPE_FRACTALNOISE","SVG_TURBULENCE_TYPE_TURBULENCE","SVG_TURBULENCE_TYPE_UNKNOWN","SVG_UNIT_TYPE_OBJECTBOUNDINGBOX","SVG_UNIT_TYPE_UNKNOWN","SVG_UNIT_TYPE_USERSPACEONUSE","SVG_WRONG_TYPE_ERR","SVG_ZOOMANDPAN_DISABLE","SVG_ZOOMANDPAN_MAGNIFY","SVG_ZOOMANDPAN_UNKNOWN","SYNC_CONDITION","SYNC_FENCE","SYNC_FLAGS","SYNC_FLUSH_COMMANDS_BIT","SYNC_GPU_COMMANDS_COMPLETE","SYNC_STATUS","SYNTAX_ERR","SavedPages","Screen","ScreenOrientation","Script","ScriptProcessorNode","ScrollAreaEvent","SecurityPolicyViolationEvent","Selection","Sensor","SensorErrorEvent","ServiceWorker","ServiceWorkerContainer","ServiceWorkerRegistration","SessionDescription","Set","ShadowRoot","SharedArrayBuffer","SharedWorker","SimpleGestureEvent","SourceBuffer","SourceBufferList","SpeechSynthesis","SpeechSynthesisErrorEvent","SpeechSynthesisEvent","SpeechSynthesisUtterance","SpeechSynthesisVoice","StaticRange","StereoPannerNode","StopIteration","Storage","StorageEvent","StorageManager","String","StructType","StylePropertyMap","StylePropertyMapReadOnly","StyleSheet","StyleSheetList","SubmitEvent","SubtleCrypto","Symbol","SyncManager","SyntaxError","TEMPORARY","TEXTPATH_METHODTYPE_ALIGN","TEXTPATH_METHODTYPE_STRETCH","TEXTPATH_METHODTYPE_UNKNOWN","TEXTPATH_SPACINGTYPE_AUTO","TEXTPATH_SPACINGTYPE_EXACT","TEXTPATH_SPACINGTYPE_UNKNOWN","TEXTURE","TEXTURE0","TEXTURE1","TEXTURE10","TEXTURE11","TEXTURE12","TEXTURE13","TEXTURE14","TEXTURE15","TEXTURE16","TEXTURE17","TEXTURE18","TEXTURE19","TEXTURE2","TEXTURE20","TEXTURE21","TEXTURE22","TEXTURE23","TEXTURE24","TEXTURE25","TEXTURE26","TEXTURE27","TEXTURE28","TEXTURE29","TEXTURE3","TEXTURE30","TEXTURE31","TEXTURE4","TEXTURE5","TEXTURE6","TEXTURE7","TEXTURE8","TEXTURE9","TEXTURE_2D","TEXTURE_2D_ARRAY","TEXTURE_3D","TEXTURE_BASE_LEVEL","TEXTURE_BINDING_2D","TEXTURE_BINDING_2D_ARRAY","TEXTURE_BINDING_3D","TEXTURE_BINDING_CUBE_MAP","TEXTURE_COMPARE_FUNC","TEXTURE_COMPARE_MODE","TEXTURE_CUBE_MAP","TEXTURE_CUBE_MAP_NEGATIVE_X","TEXTURE_CUBE_MAP_NEGATIVE_Y","TEXTURE_CUBE_MAP_NEGATIVE_Z","TEXTURE_CUBE_MAP_POSITIVE_X","TEXTURE_CUBE_MAP_POSITIVE_Y","TEXTURE_CUBE_MAP_POSITIVE_Z","TEXTURE_IMMUTABLE_FORMAT","TEXTURE_IMMUTABLE_LEVELS","TEXTURE_MAG_FILTER","TEXTURE_MAX_ANISOTROPY_EXT","TEXTURE_MAX_LEVEL","TEXTURE_MAX_LOD","TEXTURE_MIN_FILTER","TEXTURE_MIN_LOD","TEXTURE_WRAP_R","TEXTURE_WRAP_S","TEXTURE_WRAP_T","TEXT_NODE","TIMEOUT","TIMEOUT_ERR","TIMEOUT_EXPIRED","TIMEOUT_IGNORED","TOO_LARGE_ERR","TRANSACTION_INACTIVE_ERR","TRANSFORM_FEEDBACK","TRANSFORM_FEEDBACK_ACTIVE","TRANSFORM_FEEDBACK_BINDING","TRANSFORM_FEEDBACK_BUFFER","TRANSFORM_FEEDBACK_BUFFER_BINDING","TRANSFORM_FEEDBACK_BUFFER_MODE","TRANSFORM_FEEDBACK_BUFFER_SIZE","TRANSFORM_FEEDBACK_BUFFER_START","TRANSFORM_FEEDBACK_PAUSED","TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN","TRANSFORM_FEEDBACK_VARYINGS","TRIANGLE","TRIANGLES","TRIANGLE_FAN","TRIANGLE_STRIP","TYPE_BACK_FORWARD","TYPE_ERR","TYPE_MISMATCH_ERR","TYPE_NAVIGATE","TYPE_RELOAD","TYPE_RESERVED","Table","TaskAttributionTiming","Text","TextDecoder","TextDecoderStream","TextEncoder","TextEncoderStream","TextEvent","TextMetrics","TextTrack","TextTrackCue","TextTrackCueList","TextTrackList","TimeEvent","TimeRanges","Touch","TouchEvent","TouchList","TrackEvent","TransformStream","TransitionEvent","TreeWalker","TrustedHTML","TrustedScript","TrustedScriptURL","TrustedTypePolicy","TrustedTypePolicyFactory","TypeError","TypedObject","U2F","UIEvent","UNCACHED","UNIFORM_ARRAY_STRIDE","UNIFORM_BLOCK_ACTIVE_UNIFORMS","UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES","UNIFORM_BLOCK_BINDING","UNIFORM_BLOCK_DATA_SIZE","UNIFORM_BLOCK_INDEX","UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER","UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER","UNIFORM_BUFFER","UNIFORM_BUFFER_BINDING","UNIFORM_BUFFER_OFFSET_ALIGNMENT","UNIFORM_BUFFER_SIZE","UNIFORM_BUFFER_START","UNIFORM_IS_ROW_MAJOR","UNIFORM_MATRIX_STRIDE","UNIFORM_OFFSET","UNIFORM_SIZE","UNIFORM_TYPE","UNKNOWN_ERR","UNKNOWN_RULE","UNMASKED_RENDERER_WEBGL","UNMASKED_VENDOR_WEBGL","UNORDERED_NODE_ITERATOR_TYPE","UNORDERED_NODE_SNAPSHOT_TYPE","UNPACK_ALIGNMENT","UNPACK_COLORSPACE_CONVERSION_WEBGL","UNPACK_FLIP_Y_WEBGL","UNPACK_IMAGE_HEIGHT","UNPACK_PREMULTIPLY_ALPHA_WEBGL","UNPACK_ROW_LENGTH","UNPACK_SKIP_IMAGES","UNPACK_SKIP_PIXELS","UNPACK_SKIP_ROWS","UNSCHEDULED_STATE","UNSENT","UNSIGNALED","UNSIGNED_BYTE","UNSIGNED_INT","UNSIGNED_INT_10F_11F_11F_REV","UNSIGNED_INT_24_8","UNSIGNED_INT_2_10_10_10_REV","UNSIGNED_INT_5_9_9_9_REV","UNSIGNED_INT_SAMPLER_2D","UNSIGNED_INT_SAMPLER_2D_ARRAY","UNSIGNED_INT_SAMPLER_3D","UNSIGNED_INT_SAMPLER_CUBE","UNSIGNED_INT_VEC2","UNSIGNED_INT_VEC3","UNSIGNED_INT_VEC4","UNSIGNED_NORMALIZED","UNSIGNED_SHORT","UNSIGNED_SHORT_4_4_4_4","UNSIGNED_SHORT_5_5_5_1","UNSIGNED_SHORT_5_6_5","UNSPECIFIED_EVENT_TYPE_ERR","UPDATEREADY","URIError","URL","URLSearchParams","URLUnencoded","URL_MISMATCH_ERR","USB","USBAlternateInterface","USBConfiguration","USBConnectionEvent","USBDevice","USBEndpoint","USBInTransferResult","USBInterface","USBIsochronousInTransferPacket","USBIsochronousInTransferResult","USBIsochronousOutTransferPacket","USBIsochronousOutTransferResult","USBOutTransferResult","UTC","Uint16Array","Uint32Array","Uint8Array","Uint8ClampedArray","UserActivation","UserMessageHandler","UserMessageHandlersNamespace","UserProximityEvent","VALIDATE_STATUS","VALIDATION_ERR","VARIABLES_RULE","VENDOR","VERSION","VERSION_CHANGE","VERSION_ERR","VERTEX_ARRAY_BINDING","VERTEX_ATTRIB_ARRAY_BUFFER_BINDING","VERTEX_ATTRIB_ARRAY_DIVISOR","VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE","VERTEX_ATTRIB_ARRAY_ENABLED","VERTEX_ATTRIB_ARRAY_INTEGER","VERTEX_ATTRIB_ARRAY_NORMALIZED","VERTEX_ATTRIB_ARRAY_POINTER","VERTEX_ATTRIB_ARRAY_SIZE","VERTEX_ATTRIB_ARRAY_STRIDE","VERTEX_ATTRIB_ARRAY_TYPE","VERTEX_SHADER","VERTICAL","VERTICAL_AXIS","VER_ERR","VIEWPORT","VIEWPORT_RULE","VRDisplay","VRDisplayCapabilities","VRDisplayEvent","VREyeParameters","VRFieldOfView","VRFrameData","VRPose","VRStageParameters","VTTCue","VTTRegion","ValidityState","VideoPlaybackQuality","VideoStreamTrack","VisualViewport","WAIT_FAILED","WEBKIT_FILTER_RULE","WEBKIT_KEYFRAMES_RULE","WEBKIT_KEYFRAME_RULE","WEBKIT_REGION_RULE","WRONG_DOCUMENT_ERR","WakeLock","WakeLockSentinel","WasmAnyRef","WaveShaperNode","WeakMap","WeakRef","WeakSet","WebAssembly","WebGL2RenderingContext","WebGLActiveInfo","WebGLBuffer","WebGLContextEvent","WebGLFramebuffer","WebGLProgram","WebGLQuery","WebGLRenderbuffer","WebGLRenderingContext","WebGLSampler","WebGLShader","WebGLShaderPrecisionFormat","WebGLSync","WebGLTexture","WebGLTransformFeedback","WebGLUniformLocation","WebGLVertexArray","WebGLVertexArrayObject","WebKitAnimationEvent","WebKitBlobBuilder","WebKitCSSFilterRule","WebKitCSSFilterValue","WebKitCSSKeyframeRule","WebKitCSSKeyframesRule","WebKitCSSMatrix","WebKitCSSRegionRule","WebKitCSSTransformValue","WebKitDataCue","WebKitGamepad","WebKitMediaKeyError","WebKitMediaKeyMessageEvent","WebKitMediaKeySession","WebKitMediaKeys","WebKitMediaSource","WebKitMutationObserver","WebKitNamespace","WebKitPlaybackTargetAvailabilityEvent","WebKitPoint","WebKitShadowRoot","WebKitSourceBuffer","WebKitSourceBufferList","WebKitTransitionEvent","WebSocket","WebkitAlignContent","WebkitAlignItems","WebkitAlignSelf","WebkitAnimation","WebkitAnimationDelay","WebkitAnimationDirection","WebkitAnimationDuration","WebkitAnimationFillMode","WebkitAnimationIterationCount","WebkitAnimationName","WebkitAnimationPlayState","WebkitAnimationTimingFunction","WebkitAppearance","WebkitBackfaceVisibility","WebkitBackgroundClip","WebkitBackgroundOrigin","WebkitBackgroundSize","WebkitBorderBottomLeftRadius","WebkitBorderBottomRightRadius","WebkitBorderImage","WebkitBorderRadius","WebkitBorderTopLeftRadius","WebkitBorderTopRightRadius","WebkitBoxAlign","WebkitBoxDirection","WebkitBoxFlex","WebkitBoxOrdinalGroup","WebkitBoxOrient","WebkitBoxPack","WebkitBoxShadow","WebkitBoxSizing","WebkitFilter","WebkitFlex","WebkitFlexBasis","WebkitFlexDirection","WebkitFlexFlow","WebkitFlexGrow","WebkitFlexShrink","WebkitFlexWrap","WebkitJustifyContent","WebkitLineClamp","WebkitMask","WebkitMaskClip","WebkitMaskComposite","WebkitMaskImage","WebkitMaskOrigin","WebkitMaskPosition","WebkitMaskPositionX","WebkitMaskPositionY","WebkitMaskRepeat","WebkitMaskSize","WebkitOrder","WebkitPerspective","WebkitPerspectiveOrigin","WebkitTextFillColor","WebkitTextSizeAdjust","WebkitTextStroke","WebkitTextStrokeColor","WebkitTextStrokeWidth","WebkitTransform","WebkitTransformOrigin","WebkitTransformStyle","WebkitTransition","WebkitTransitionDelay","WebkitTransitionDuration","WebkitTransitionProperty","WebkitTransitionTimingFunction","WebkitUserSelect","WheelEvent","Window","Worker","Worklet","WritableStream","WritableStreamDefaultWriter","XMLDocument","XMLHttpRequest","XMLHttpRequestEventTarget","XMLHttpRequestException","XMLHttpRequestProgressEvent","XMLHttpRequestUpload","XMLSerializer","XMLStylesheetProcessingInstruction","XPathEvaluator","XPathException","XPathExpression","XPathNSResolver","XPathResult","XRBoundedReferenceSpace","XRDOMOverlayState","XRFrame","XRHitTestResult","XRHitTestSource","XRInputSource","XRInputSourceArray","XRInputSourceEvent","XRInputSourcesChangeEvent","XRLayer","XRPose","XRRay","XRReferenceSpace","XRReferenceSpaceEvent","XRRenderState","XRRigidTransform","XRSession","XRSessionEvent","XRSpace","XRSystem","XRTransientInputHitTestResult","XRTransientInputHitTestSource","XRView","XRViewerPose","XRViewport","XRWebGLLayer","XSLTProcessor","ZERO","_XD0M_","_YD0M_","__defineGetter__","__defineSetter__","__lookupGetter__","__lookupSetter__","__opera","__proto__","_browserjsran","a","aLink","abbr","abort","aborted","abs","absolute","acceleration","accelerationIncludingGravity","accelerator","accept","acceptCharset","acceptNode","accessKey","accessKeyLabel","accuracy","acos","acosh","action","actionURL","actions","activated","active","activeCues","activeElement","activeSourceBuffers","activeSourceCount","activeTexture","activeVRDisplays","actualBoundingBoxAscent","actualBoundingBoxDescent","actualBoundingBoxLeft","actualBoundingBoxRight","add","addAll","addBehavior","addCandidate","addColorStop","addCue","addElement","addEventListener","addFilter","addFromString","addFromUri","addIceCandidate","addImport","addListener","addModule","addNamed","addPageRule","addPath","addPointer","addRange","addRegion","addRule","addSearchEngine","addSourceBuffer","addStream","addTextTrack","addTrack","addTransceiver","addWakeLockListener","added","addedNodes","additionalName","additiveSymbols","addons","address","addressLine","adoptNode","adoptedStyleSheets","adr","advance","after","album","alert","algorithm","align","align-content","align-items","align-self","alignContent","alignItems","alignSelf","alignmentBaseline","alinkColor","all","allSettled","allow","allowFullscreen","allowPaymentRequest","allowedDirections","allowedFeatures","allowedToPlay","allowsFeature","alpha","alt","altGraphKey","altHtml","altKey","altLeft","alternate","alternateSetting","alternates","altitude","altitudeAccuracy","amplitude","ancestorOrigins","anchor","anchorNode","anchorOffset","anchors","and","angle","angularAcceleration","angularVelocity","animVal","animate","animatedInstanceRoot","animatedNormalizedPathSegList","animatedPathSegList","animatedPoints","animation","animation-delay","animation-direction","animation-duration","animation-fill-mode","animation-iteration-count","animation-name","animation-play-state","animation-timing-function","animationDelay","animationDirection","animationDuration","animationFillMode","animationIterationCount","animationName","animationPlayState","animationStartTime","animationTimingFunction","animationsPaused","anniversary","antialias","anticipatedRemoval","any","app","appCodeName","appMinorVersion","appName","appNotifications","appVersion","appearance","append","appendBuffer","appendChild","appendData","appendItem","appendMedium","appendNamed","appendRule","appendStream","appendWindowEnd","appendWindowStart","applets","applicationCache","applicationServerKey","apply","applyConstraints","applyElement","arc","arcTo","archive","areas","arguments","ariaAtomic","ariaAutoComplete","ariaBusy","ariaChecked","ariaColCount","ariaColIndex","ariaColSpan","ariaCurrent","ariaDescription","ariaDisabled","ariaExpanded","ariaHasPopup","ariaHidden","ariaKeyShortcuts","ariaLabel","ariaLevel","ariaLive","ariaModal","ariaMultiLine","ariaMultiSelectable","ariaOrientation","ariaPlaceholder","ariaPosInSet","ariaPressed","ariaReadOnly","ariaRelevant","ariaRequired","ariaRoleDescription","ariaRowCount","ariaRowIndex","ariaRowSpan","ariaSelected","ariaSetSize","ariaSort","ariaValueMax","ariaValueMin","ariaValueNow","ariaValueText","arrayBuffer","artist","artwork","as","asIntN","asUintN","asin","asinh","assert","assign","assignedElements","assignedNodes","assignedSlot","async","asyncIterator","atEnd","atan","atan2","atanh","atob","attachEvent","attachInternals","attachShader","attachShadow","attachments","attack","attestationObject","attrChange","attrName","attributeFilter","attributeName","attributeNamespace","attributeOldValue","attributeStyleMap","attributes","attribution","audioBitsPerSecond","audioTracks","audioWorklet","authenticatedSignedWrites","authenticatorData","autoIncrement","autobuffer","autocapitalize","autocomplete","autocorrect","autofocus","automationRate","autoplay","availHeight","availLeft","availTop","availWidth","availability","available","aversion","ax","axes","axis","ay","azimuth","b","back","backface-visibility","backfaceVisibility","background","background-attachment","background-blend-mode","background-clip","background-color","background-image","background-origin","background-position","background-position-x","background-position-y","background-repeat","background-size","backgroundAttachment","backgroundBlendMode","backgroundClip","backgroundColor","backgroundFetch","backgroundImage","backgroundOrigin","backgroundPosition","backgroundPositionX","backgroundPositionY","backgroundRepeat","backgroundSize","badInput","badge","balance","baseFrequencyX","baseFrequencyY","baseLatency","baseLayer","baseNode","baseOffset","baseURI","baseVal","baselineShift","battery","bday","before","beginElement","beginElementAt","beginPath","beginQuery","beginTransformFeedback","behavior","behaviorCookie","behaviorPart","behaviorUrns","beta","bezierCurveTo","bgColor","bgProperties","bias","big","bigint64","biguint64","binaryType","bind","bindAttribLocation","bindBuffer","bindBufferBase","bindBufferRange","bindFramebuffer","bindRenderbuffer","bindSampler","bindTexture","bindTransformFeedback","bindVertexArray","blendColor","blendEquation","blendEquationSeparate","blendFunc","blendFuncSeparate","blink","blitFramebuffer","blob","block-size","blockDirection","blockSize","blockedURI","blue","bluetooth","blur","body","bodyUsed","bold","bookmarks","booleanValue","border","border-block","border-block-color","border-block-end","border-block-end-color","border-block-end-style","border-block-end-width","border-block-start","border-block-start-color","border-block-start-style","border-block-start-width","border-block-style","border-block-width","border-bottom","border-bottom-color","border-bottom-left-radius","border-bottom-right-radius","border-bottom-style","border-bottom-width","border-collapse","border-color","border-end-end-radius","border-end-start-radius","border-image","border-image-outset","border-image-repeat","border-image-slice","border-image-source","border-image-width","border-inline","border-inline-color","border-inline-end","border-inline-end-color","border-inline-end-style","border-inline-end-width","border-inline-start","border-inline-start-color","border-inline-start-style","border-inline-start-width","border-inline-style","border-inline-width","border-left","border-left-color","border-left-style","border-left-width","border-radius","border-right","border-right-color","border-right-style","border-right-width","border-spacing","border-start-end-radius","border-start-start-radius","border-style","border-top","border-top-color","border-top-left-radius","border-top-right-radius","border-top-style","border-top-width","border-width","borderBlock","borderBlockColor","borderBlockEnd","borderBlockEndColor","borderBlockEndStyle","borderBlockEndWidth","borderBlockStart","borderBlockStartColor","borderBlockStartStyle","borderBlockStartWidth","borderBlockStyle","borderBlockWidth","borderBottom","borderBottomColor","borderBottomLeftRadius","borderBottomRightRadius","borderBottomStyle","borderBottomWidth","borderBoxSize","borderCollapse","borderColor","borderColorDark","borderColorLight","borderEndEndRadius","borderEndStartRadius","borderImage","borderImageOutset","borderImageRepeat","borderImageSlice","borderImageSource","borderImageWidth","borderInline","borderInlineColor","borderInlineEnd","borderInlineEndColor","borderInlineEndStyle","borderInlineEndWidth","borderInlineStart","borderInlineStartColor","borderInlineStartStyle","borderInlineStartWidth","borderInlineStyle","borderInlineWidth","borderLeft","borderLeftColor","borderLeftStyle","borderLeftWidth","borderRadius","borderRight","borderRightColor","borderRightStyle","borderRightWidth","borderSpacing","borderStartEndRadius","borderStartStartRadius","borderStyle","borderTop","borderTopColor","borderTopLeftRadius","borderTopRightRadius","borderTopStyle","borderTopWidth","borderWidth","bottom","bottomMargin","bound","boundElements","boundingClientRect","boundingHeight","boundingLeft","boundingTop","boundingWidth","bounds","boundsGeometry","box-decoration-break","box-shadow","box-sizing","boxDecorationBreak","boxShadow","boxSizing","break-after","break-before","break-inside","breakAfter","breakBefore","breakInside","broadcast","browserLanguage","btoa","bubbles","buffer","bufferData","bufferDepth","bufferSize","bufferSubData","buffered","bufferedAmount","bufferedAmountLowThreshold","buildID","buildNumber","button","buttonID","buttons","byteLength","byteOffset","bytesWritten","c","cache","caches","call","caller","canBeFormatted","canBeMounted","canBeShared","canHaveChildren","canHaveHTML","canInsertDTMF","canMakePayment","canPlayType","canPresent","canTrickleIceCandidates","cancel","cancelAndHoldAtTime","cancelAnimationFrame","cancelBubble","cancelIdleCallback","cancelScheduledValues","cancelVideoFrameCallback","cancelWatchAvailability","cancelable","candidate","canonicalUUID","canvas","capabilities","caption","caption-side","captionSide","capture","captureEvents","captureStackTrace","captureStream","caret-color","caretBidiLevel","caretColor","caretPositionFromPoint","caretRangeFromPoint","cast","catch","category","cbrt","cd","ceil","cellIndex","cellPadding","cellSpacing","cells","ch","chOff","chain","challenge","changeType","changedTouches","channel","channelCount","channelCountMode","channelInterpretation","char","charAt","charCode","charCodeAt","charIndex","charLength","characterData","characterDataOldValue","characterSet","characteristic","charging","chargingTime","charset","check","checkEnclosure","checkFramebufferStatus","checkIntersection","checkValidity","checked","childElementCount","childList","childNodes","children","chrome","ciphertext","cite","city","claimInterface","claimed","classList","className","classid","clear","clearAppBadge","clearAttributes","clearBufferfi","clearBufferfv","clearBufferiv","clearBufferuiv","clearColor","clearData","clearDepth","clearHalt","clearImmediate","clearInterval","clearLiveSeekableRange","clearMarks","clearMaxGCPauseAccumulator","clearMeasures","clearParameters","clearRect","clearResourceTimings","clearShadow","clearStencil","clearTimeout","clearWatch","click","clickCount","clientDataJSON","clientHeight","clientInformation","clientLeft","clientRect","clientRects","clientTop","clientWaitSync","clientWidth","clientX","clientY","clip","clip-path","clip-rule","clipBottom","clipLeft","clipPath","clipPathUnits","clipRight","clipRule","clipTop","clipboard","clipboardData","clone","cloneContents","cloneNode","cloneRange","close","closePath","closed","closest","clz","clz32","cm","cmp","code","codeBase","codePointAt","codeType","colSpan","collapse","collapseToEnd","collapseToStart","collapsed","collect","colno","color","color-adjust","color-interpolation","color-interpolation-filters","colorAdjust","colorDepth","colorInterpolation","colorInterpolationFilters","colorMask","colorType","cols","column-count","column-fill","column-gap","column-rule","column-rule-color","column-rule-style","column-rule-width","column-span","column-width","columnCount","columnFill","columnGap","columnNumber","columnRule","columnRuleColor","columnRuleStyle","columnRuleWidth","columnSpan","columnWidth","columns","command","commit","commitPreferences","commitStyles","commonAncestorContainer","compact","compareBoundaryPoints","compareDocumentPosition","compareEndPoints","compareExchange","compareNode","comparePoint","compatMode","compatible","compile","compileShader","compileStreaming","complete","component","componentFromPoint","composed","composedPath","composite","compositionEndOffset","compositionStartOffset","compressedTexImage2D","compressedTexImage3D","compressedTexSubImage2D","compressedTexSubImage3D","computedStyleMap","concat","conditionText","coneInnerAngle","coneOuterAngle","coneOuterGain","configuration","configurationName","configurationValue","configurations","confirm","confirmComposition","confirmSiteSpecificTrackingException","confirmWebWideTrackingException","connect","connectEnd","connectShark","connectStart","connected","connection","connectionList","connectionSpeed","connectionState","connections","console","consolidate","constraint","constrictionActive","construct","constructor","contactID","contain","containerId","containerName","containerSrc","containerType","contains","containsNode","content","contentBoxSize","contentDocument","contentEditable","contentHint","contentOverflow","contentRect","contentScriptType","contentStyleType","contentType","contentWindow","context","contextMenu","contextmenu","continue","continuePrimaryKey","continuous","control","controlTransferIn","controlTransferOut","controller","controls","controlsList","convertPointFromNode","convertQuadFromNode","convertRectFromNode","convertToBlob","convertToSpecifiedUnits","cookie","cookieEnabled","coords","copyBufferSubData","copyFromChannel","copyTexImage2D","copyTexSubImage2D","copyTexSubImage3D","copyToChannel","copyWithin","correspondingElement","correspondingUseElement","corruptedVideoFrames","cos","cosh","count","countReset","counter-increment","counter-reset","counter-set","counterIncrement","counterReset","counterSet","country","cpuClass","cpuSleepAllowed","create","createAnalyser","createAnswer","createAttribute","createAttributeNS","createBiquadFilter","createBuffer","createBufferSource","createCDATASection","createCSSStyleSheet","createCaption","createChannelMerger","createChannelSplitter","createComment","createConstantSource","createContextualFragment","createControlRange","createConvolver","createDTMFSender","createDataChannel","createDelay","createDelayNode","createDocument","createDocumentFragment","createDocumentType","createDynamicsCompressor","createElement","createElementNS","createEntityReference","createEvent","createEventObject","createExpression","createFramebuffer","createFunction","createGain","createGainNode","createHTML","createHTMLDocument","createIIRFilter","createImageBitmap","createImageData","createIndex","createJavaScriptNode","createLinearGradient","createMediaElementSource","createMediaKeys","createMediaStreamDestination","createMediaStreamSource","createMediaStreamTrackSource","createMutableFile","createNSResolver","createNodeIterator","createNotification","createObjectStore","createObjectURL","createOffer","createOscillator","createPanner","createPattern","createPeriodicWave","createPolicy","createPopup","createProcessingInstruction","createProgram","createQuery","createRadialGradient","createRange","createRangeCollection","createReader","createRenderbuffer","createSVGAngle","createSVGLength","createSVGMatrix","createSVGNumber","createSVGPathSegArcAbs","createSVGPathSegArcRel","createSVGPathSegClosePath","createSVGPathSegCurvetoCubicAbs","createSVGPathSegCurvetoCubicRel","createSVGPathSegCurvetoCubicSmoothAbs","createSVGPathSegCurvetoCubicSmoothRel","createSVGPathSegCurvetoQuadraticAbs","createSVGPathSegCurvetoQuadraticRel","createSVGPathSegCurvetoQuadraticSmoothAbs","createSVGPathSegCurvetoQuadraticSmoothRel","createSVGPathSegLinetoAbs","createSVGPathSegLinetoHorizontalAbs","createSVGPathSegLinetoHorizontalRel","createSVGPathSegLinetoRel","createSVGPathSegLinetoVerticalAbs","createSVGPathSegLinetoVerticalRel","createSVGPathSegMovetoAbs","createSVGPathSegMovetoRel","createSVGPoint","createSVGRect","createSVGTransform","createSVGTransformFromMatrix","createSampler","createScript","createScriptProcessor","createScriptURL","createSession","createShader","createShadowRoot","createStereoPanner","createStyleSheet","createTBody","createTFoot","createTHead","createTextNode","createTextRange","createTexture","createTouch","createTouchList","createTransformFeedback","createTreeWalker","createVertexArray","createWaveShaper","creationTime","credentials","crossOrigin","crossOriginIsolated","crypto","csi","csp","cssFloat","cssRules","cssText","cssValueType","ctrlKey","ctrlLeft","cues","cullFace","currentDirection","currentLocalDescription","currentNode","currentPage","currentRect","currentRemoteDescription","currentScale","currentScript","currentSrc","currentState","currentStyle","currentTarget","currentTime","currentTranslate","currentView","cursor","curve","customElements","customError","cx","cy","d","data","dataFld","dataFormatAs","dataLoss","dataLossMessage","dataPageSize","dataSrc","dataTransfer","database","databases","dataset","dateTime","db","debug","debuggerEnabled","declare","decode","decodeAudioData","decodeURI","decodeURIComponent","decodedBodySize","decoding","decodingInfo","decrypt","default","defaultCharset","defaultChecked","defaultMuted","defaultPlaybackRate","defaultPolicy","defaultPrevented","defaultRequest","defaultSelected","defaultStatus","defaultURL","defaultValue","defaultView","defaultstatus","defer","define","defineMagicFunction","defineMagicVariable","defineProperties","defineProperty","deg","delay","delayTime","delegatesFocus","delete","deleteBuffer","deleteCaption","deleteCell","deleteContents","deleteData","deleteDatabase","deleteFramebuffer","deleteFromDocument","deleteIndex","deleteMedium","deleteObjectStore","deleteProgram","deleteProperty","deleteQuery","deleteRenderbuffer","deleteRow","deleteRule","deleteSampler","deleteShader","deleteSync","deleteTFoot","deleteTHead","deleteTexture","deleteTransformFeedback","deleteVertexArray","deliverChangeRecords","delivery","deliveryInfo","deliveryStatus","deliveryTimestamp","delta","deltaMode","deltaX","deltaY","deltaZ","dependentLocality","depthFar","depthFunc","depthMask","depthNear","depthRange","deref","deriveBits","deriveKey","description","deselectAll","designMode","desiredSize","destination","destinationURL","detach","detachEvent","detachShader","detail","details","detect","detune","device","deviceClass","deviceId","deviceMemory","devicePixelContentBoxSize","devicePixelRatio","deviceProtocol","deviceSubclass","deviceVersionMajor","deviceVersionMinor","deviceVersionSubminor","deviceXDPI","deviceYDPI","didTimeout","diffuseConstant","digest","dimensions","dir","dirName","direction","dirxml","disable","disablePictureInPicture","disableRemotePlayback","disableVertexAttribArray","disabled","dischargingTime","disconnect","disconnectShark","dispatchEvent","display","displayId","displayName","disposition","distanceModel","div","divisor","djsapi","djsproxy","doImport","doNotTrack","doScroll","doctype","document","documentElement","documentMode","documentURI","dolphin","dolphinGameCenter","dolphininfo","dolphinmeta","domComplete","domContentLoadedEventEnd","domContentLoadedEventStart","domInteractive","domLoading","domOverlayState","domain","domainLookupEnd","domainLookupStart","dominant-baseline","dominantBaseline","done","dopplerFactor","dotAll","downDegrees","downlink","download","downloadTotal","downloaded","dpcm","dpi","dppx","dragDrop","draggable","drawArrays","drawArraysInstanced","drawArraysInstancedANGLE","drawBuffers","drawCustomFocusRing","drawElements","drawElementsInstanced","drawElementsInstancedANGLE","drawFocusIfNeeded","drawImage","drawImageFromRect","drawRangeElements","drawSystemFocusRing","drawingBufferHeight","drawingBufferWidth","dropEffect","droppedVideoFrames","dropzone","dtmf","dump","dumpProfile","duplicate","durability","duration","dvname","dvnum","dx","dy","dynsrc","e","edgeMode","effect","effectAllowed","effectiveDirective","effectiveType","elapsedTime","element","elementFromPoint","elementTiming","elements","elementsFromPoint","elevation","ellipse","em","email","embeds","emma","empty","empty-cells","emptyCells","emptyHTML","emptyScript","emulatedPosition","enable","enableBackground","enableDelegations","enableStyleSheetsForSet","enableVertexAttribArray","enabled","enabledPlugin","encode","encodeInto","encodeURI","encodeURIComponent","encodedBodySize","encoding","encodingInfo","encrypt","enctype","end","endContainer","endElement","endElementAt","endOfStream","endOffset","endQuery","endTime","endTransformFeedback","ended","endpoint","endpointNumber","endpoints","endsWith","enterKeyHint","entities","entries","entryType","enumerate","enumerateDevices","enumerateEditable","environmentBlendMode","equals","error","errorCode","errorDetail","errorText","escape","estimate","eval","evaluate","event","eventPhase","every","ex","exception","exchange","exec","execCommand","execCommandShowHelp","execScript","exitFullscreen","exitPictureInPicture","exitPointerLock","exitPresent","exp","expand","expandEntityReferences","expando","expansion","expiration","expirationTime","expires","expiryDate","explicitOriginalTarget","expm1","exponent","exponentialRampToValueAtTime","exportKey","exports","extend","extensions","extentNode","extentOffset","external","externalResourcesRequired","extractContents","extractable","eye","f","face","factoryReset","failureReason","fallback","family","familyName","farthestViewportElement","fastSeek","fatal","featureId","featurePolicy","featureSettings","features","fenceSync","fetch","fetchStart","fftSize","fgColor","fieldOfView","file","fileCreatedDate","fileHandle","fileModifiedDate","fileName","fileSize","fileUpdatedDate","filename","files","filesystem","fill","fill-opacity","fill-rule","fillLightMode","fillOpacity","fillRect","fillRule","fillStyle","fillText","filter","filterResX","filterResY","filterUnits","filters","finally","find","findIndex","findRule","findText","finish","finished","fireEvent","firesTouchEvents","firstChild","firstElementChild","firstPage","fixed","flags","flat","flatMap","flex","flex-basis","flex-direction","flex-flow","flex-grow","flex-shrink","flex-wrap","flexBasis","flexDirection","flexFlow","flexGrow","flexShrink","flexWrap","flipX","flipY","float","float32","float64","flood-color","flood-opacity","floodColor","floodOpacity","floor","flush","focus","focusNode","focusOffset","font","font-family","font-feature-settings","font-kerning","font-language-override","font-optical-sizing","font-size","font-size-adjust","font-stretch","font-style","font-synthesis","font-variant","font-variant-alternates","font-variant-caps","font-variant-east-asian","font-variant-ligatures","font-variant-numeric","font-variant-position","font-variation-settings","font-weight","fontFamily","fontFeatureSettings","fontKerning","fontLanguageOverride","fontOpticalSizing","fontSize","fontSizeAdjust","fontSmoothingEnabled","fontStretch","fontStyle","fontSynthesis","fontVariant","fontVariantAlternates","fontVariantCaps","fontVariantEastAsian","fontVariantLigatures","fontVariantNumeric","fontVariantPosition","fontVariationSettings","fontWeight","fontcolor","fontfaces","fonts","fontsize","for","forEach","force","forceRedraw","form","formAction","formData","formEnctype","formMethod","formNoValidate","formTarget","format","formatToParts","forms","forward","forwardX","forwardY","forwardZ","foundation","fr","fragmentDirective","frame","frameBorder","frameElement","frameSpacing","framebuffer","framebufferHeight","framebufferRenderbuffer","framebufferTexture2D","framebufferTextureLayer","framebufferWidth","frames","freeSpace","freeze","frequency","frequencyBinCount","from","fromCharCode","fromCodePoint","fromElement","fromEntries","fromFloat32Array","fromFloat64Array","fromMatrix","fromPoint","fromQuad","fromRect","frontFace","fround","fullPath","fullScreen","fullscreen","fullscreenElement","fullscreenEnabled","fx","fy","gain","gamepad","gamma","gap","gatheringState","gatt","genderIdentity","generateCertificate","generateKey","generateMipmap","generateRequest","geolocation","gestureObject","get","getActiveAttrib","getActiveUniform","getActiveUniformBlockName","getActiveUniformBlockParameter","getActiveUniforms","getAdjacentText","getAll","getAllKeys","getAllResponseHeaders","getAllowlistForFeature","getAnimations","getAsFile","getAsString","getAttachedShaders","getAttribLocation","getAttribute","getAttributeNS","getAttributeNames","getAttributeNode","getAttributeNodeNS","getAttributeType","getAudioTracks","getAvailability","getBBox","getBattery","getBigInt64","getBigUint64","getBlob","getBookmark","getBoundingClientRect","getBounds","getBoxQuads","getBufferParameter","getBufferSubData","getByteFrequencyData","getByteTimeDomainData","getCSSCanvasContext","getCTM","getCandidateWindowClientRect","getCanonicalLocales","getCapabilities","getChannelData","getCharNumAtPosition","getCharacteristic","getCharacteristics","getClientExtensionResults","getClientRect","getClientRects","getCoalescedEvents","getCompositionAlternatives","getComputedStyle","getComputedTextLength","getComputedTiming","getConfiguration","getConstraints","getContext","getContextAttributes","getContributingSources","getCounterValue","getCueAsHTML","getCueById","getCurrentPosition","getCurrentTime","getData","getDatabaseNames","getDate","getDay","getDefaultComputedStyle","getDescriptor","getDescriptors","getDestinationInsertionPoints","getDevices","getDirectory","getDisplayMedia","getDistributedNodes","getEditable","getElementById","getElementsByClassName","getElementsByName","getElementsByTagName","getElementsByTagNameNS","getEnclosureList","getEndPositionOfChar","getEntries","getEntriesByName","getEntriesByType","getError","getExtension","getExtentOfChar","getEyeParameters","getFeature","getFile","getFiles","getFilesAndDirectories","getFingerprints","getFloat32","getFloat64","getFloatFrequencyData","getFloatTimeDomainData","getFloatValue","getFragDataLocation","getFrameData","getFramebufferAttachmentParameter","getFrequencyResponse","getFullYear","getGamepads","getHitTestResults","getHitTestResultsForTransientInput","getHours","getIdentityAssertion","getIds","getImageData","getIndexedParameter","getInstalledRelatedApps","getInt16","getInt32","getInt8","getInternalformatParameter","getIntersectionList","getItem","getItems","getKey","getKeyframes","getLayers","getLayoutMap","getLineDash","getLocalCandidates","getLocalParameters","getLocalStreams","getMarks","getMatchedCSSRules","getMaxGCPauseSinceClear","getMeasures","getMetadata","getMilliseconds","getMinutes","getModifierState","getMonth","getNamedItem","getNamedItemNS","getNativeFramebufferScaleFactor","getNotifications","getNotifier","getNumberOfChars","getOffsetReferenceSpace","getOutputTimestamp","getOverrideHistoryNavigationMode","getOverrideStyle","getOwnPropertyDescriptor","getOwnPropertyDescriptors","getOwnPropertyNames","getOwnPropertySymbols","getParameter","getParameters","getParent","getPathSegAtLength","getPhotoCapabilities","getPhotoSettings","getPointAtLength","getPose","getPredictedEvents","getPreference","getPreferenceDefault","getPresentationAttribute","getPreventDefault","getPrimaryService","getPrimaryServices","getProgramInfoLog","getProgramParameter","getPropertyCSSValue","getPropertyPriority","getPropertyShorthand","getPropertyType","getPropertyValue","getPrototypeOf","getQuery","getQueryParameter","getRGBColorValue","getRandomValues","getRangeAt","getReader","getReceivers","getRectValue","getRegistration","getRegistrations","getRemoteCandidates","getRemoteCertificates","getRemoteParameters","getRemoteStreams","getRenderbufferParameter","getResponseHeader","getRoot","getRootNode","getRotationOfChar","getSVGDocument","getSamplerParameter","getScreenCTM","getSeconds","getSelectedCandidatePair","getSelection","getSenders","getService","getSettings","getShaderInfoLog","getShaderParameter","getShaderPrecisionFormat","getShaderSource","getSimpleDuration","getSiteIcons","getSources","getSpeculativeParserUrls","getStartPositionOfChar","getStartTime","getState","getStats","getStatusForPolicy","getStorageUpdates","getStreamById","getStringValue","getSubStringLength","getSubscription","getSupportedConstraints","getSupportedExtensions","getSupportedFormats","getSyncParameter","getSynchronizationSources","getTags","getTargetRanges","getTexParameter","getTime","getTimezoneOffset","getTiming","getTotalLength","getTrackById","getTracks","getTransceivers","getTransform","getTransformFeedbackVarying","getTransformToElement","getTransports","getType","getTypeMapping","getUTCDate","getUTCDay","getUTCFullYear","getUTCHours","getUTCMilliseconds","getUTCMinutes","getUTCMonth","getUTCSeconds","getUint16","getUint32","getUint8","getUniform","getUniformBlockIndex","getUniformIndices","getUniformLocation","getUserMedia","getVRDisplays","getValues","getVarDate","getVariableValue","getVertexAttrib","getVertexAttribOffset","getVideoPlaybackQuality","getVideoTracks","getViewerPose","getViewport","getVoices","getWakeLockState","getWriter","getYear","givenName","global","globalAlpha","globalCompositeOperation","globalThis","glyphOrientationHorizontal","glyphOrientationVertical","glyphRef","go","grabFrame","grad","gradientTransform","gradientUnits","grammars","green","grid","grid-area","grid-auto-columns","grid-auto-flow","grid-auto-rows","grid-column","grid-column-end","grid-column-gap","grid-column-start","grid-gap","grid-row","grid-row-end","grid-row-gap","grid-row-start","grid-template","grid-template-areas","grid-template-columns","grid-template-rows","gridArea","gridAutoColumns","gridAutoFlow","gridAutoRows","gridColumn","gridColumnEnd","gridColumnGap","gridColumnStart","gridGap","gridRow","gridRowEnd","gridRowGap","gridRowStart","gridTemplate","gridTemplateAreas","gridTemplateColumns","gridTemplateRows","gripSpace","group","groupCollapsed","groupEnd","groupId","hadRecentInput","hand","handedness","hapticActuators","hardwareConcurrency","has","hasAttribute","hasAttributeNS","hasAttributes","hasBeenActive","hasChildNodes","hasComposition","hasEnrolledInstrument","hasExtension","hasExternalDisplay","hasFeature","hasFocus","hasInstance","hasLayout","hasOrientation","hasOwnProperty","hasPointerCapture","hasPosition","hasReading","hasStorageAccess","hash","head","headers","heading","height","hidden","hide","hideFocus","high","highWaterMark","hint","history","honorificPrefix","honorificSuffix","horizontalOverflow","host","hostCandidate","hostname","href","hrefTranslate","hreflang","hspace","html5TagCheckInerface","htmlFor","htmlText","httpEquiv","httpRequestStatusCode","hwTimestamp","hyphens","hypot","iccId","iceConnectionState","iceGatheringState","iceTransport","icon","iconURL","id","identifier","identity","idpLoginUrl","ignoreBOM","ignoreCase","ignoreDepthValues","image-orientation","image-rendering","imageHeight","imageOrientation","imageRendering","imageSizes","imageSmoothingEnabled","imageSmoothingQuality","imageSrcset","imageWidth","images","ime-mode","imeMode","implementation","importKey","importNode","importStylesheet","imports","impp","imul","in","in1","in2","inBandMetadataTrackDispatchType","inRange","includes","incremental","indeterminate","index","indexNames","indexOf","indexedDB","indicate","inertiaDestinationX","inertiaDestinationY","info","init","initAnimationEvent","initBeforeLoadEvent","initClipboardEvent","initCloseEvent","initCommandEvent","initCompositionEvent","initCustomEvent","initData","initDataType","initDeviceMotionEvent","initDeviceOrientationEvent","initDragEvent","initErrorEvent","initEvent","initFocusEvent","initGestureEvent","initHashChangeEvent","initKeyEvent","initKeyboardEvent","initMSManipulationEvent","initMessageEvent","initMouseEvent","initMouseScrollEvent","initMouseWheelEvent","initMutationEvent","initNSMouseEvent","initOverflowEvent","initPageEvent","initPageTransitionEvent","initPointerEvent","initPopStateEvent","initProgressEvent","initScrollAreaEvent","initSimpleGestureEvent","initStorageEvent","initTextEvent","initTimeEvent","initTouchEvent","initTransitionEvent","initUIEvent","initWebKitAnimationEvent","initWebKitTransitionEvent","initWebKitWheelEvent","initWheelEvent","initialTime","initialize","initiatorType","inline-size","inlineSize","inlineVerticalFieldOfView","inner","innerHTML","innerHeight","innerText","innerWidth","input","inputBuffer","inputEncoding","inputMethod","inputMode","inputSource","inputSources","inputType","inputs","insertAdjacentElement","insertAdjacentHTML","insertAdjacentText","insertBefore","insertCell","insertDTMF","insertData","insertItemBefore","insertNode","insertRow","insertRule","inset","inset-block","inset-block-end","inset-block-start","inset-inline","inset-inline-end","inset-inline-start","insetBlock","insetBlockEnd","insetBlockStart","insetInline","insetInlineEnd","insetInlineStart","installing","instanceRoot","instantiate","instantiateStreaming","instruments","int16","int32","int8","integrity","interactionMode","intercept","interfaceClass","interfaceName","interfaceNumber","interfaceProtocol","interfaceSubclass","interfaces","interimResults","internalSubset","interpretation","intersectionRatio","intersectionRect","intersectsNode","interval","invalidIteratorState","invalidateFramebuffer","invalidateSubFramebuffer","inverse","invertSelf","is","is2D","isActive","isAlternate","isArray","isBingCurrentSearchDefault","isBuffer","isCandidateWindowVisible","isChar","isCollapsed","isComposing","isConcatSpreadable","isConnected","isContentEditable","isContentHandlerRegistered","isContextLost","isDefaultNamespace","isDirectory","isDisabled","isEnabled","isEqual","isEqualNode","isExtensible","isExternalCTAP2SecurityKeySupported","isFile","isFinite","isFramebuffer","isFrozen","isGenerator","isHTML","isHistoryNavigation","isId","isIdentity","isInjected","isInteger","isIntersecting","isLockFree","isMap","isMultiLine","isNaN","isOpen","isPointInFill","isPointInPath","isPointInRange","isPointInStroke","isPrefAlternate","isPresenting","isPrimary","isProgram","isPropertyImplicit","isProtocolHandlerRegistered","isPrototypeOf","isQuery","isRenderbuffer","isSafeInteger","isSameNode","isSampler","isScript","isScriptURL","isSealed","isSecureContext","isSessionSupported","isShader","isSupported","isSync","isTextEdit","isTexture","isTransformFeedback","isTrusted","isTypeSupported","isUserVerifyingPlatformAuthenticatorAvailable","isVertexArray","isView","isVisible","isochronousTransferIn","isochronousTransferOut","isolation","italics","item","itemId","itemProp","itemRef","itemScope","itemType","itemValue","items","iterateNext","iterationComposite","iterator","javaEnabled","jobTitle","join","json","justify-content","justify-items","justify-self","justifyContent","justifyItems","justifySelf","k1","k2","k3","k4","kHz","keepalive","kernelMatrix","kernelUnitLengthX","kernelUnitLengthY","kerning","key","keyCode","keyFor","keyIdentifier","keyLightEnabled","keyLocation","keyPath","keyStatuses","keySystem","keyText","keyUsage","keyboard","keys","keytype","kind","knee","label","labels","lang","language","languages","largeArcFlag","lastChild","lastElementChild","lastEventId","lastIndex","lastIndexOf","lastInputTime","lastMatch","lastMessageSubject","lastMessageType","lastModified","lastModifiedDate","lastPage","lastParen","lastState","lastStyleSheetSet","latitude","layerX","layerY","layoutFlow","layoutGrid","layoutGridChar","layoutGridLine","layoutGridMode","layoutGridType","lbound","left","leftContext","leftDegrees","leftMargin","leftProjectionMatrix","leftViewMatrix","length","lengthAdjust","lengthComputable","letter-spacing","letterSpacing","level","lighting-color","lightingColor","limitingConeAngle","line","line-break","line-height","lineAlign","lineBreak","lineCap","lineDashOffset","lineHeight","lineJoin","lineNumber","lineTo","lineWidth","linearAcceleration","linearRampToValueAtTime","linearVelocity","lineno","lines","link","linkColor","linkProgram","links","list","list-style","list-style-image","list-style-position","list-style-type","listStyle","listStyleImage","listStylePosition","listStyleType","listener","load","loadEventEnd","loadEventStart","loadTime","loadTimes","loaded","loading","localDescription","localName","localService","localStorage","locale","localeCompare","location","locationbar","lock","locked","lockedFile","locks","log","log10","log1p","log2","logicalXDPI","logicalYDPI","longDesc","longitude","lookupNamespaceURI","lookupPrefix","loop","loopEnd","loopStart","looping","low","lower","lowerBound","lowerOpen","lowsrc","m11","m12","m13","m14","m21","m22","m23","m24","m31","m32","m33","m34","m41","m42","m43","m44","makeXRCompatible","manifest","manufacturer","manufacturerName","map","mapping","margin","margin-block","margin-block-end","margin-block-start","margin-bottom","margin-inline","margin-inline-end","margin-inline-start","margin-left","margin-right","margin-top","marginBlock","marginBlockEnd","marginBlockStart","marginBottom","marginHeight","marginInline","marginInlineEnd","marginInlineStart","marginLeft","marginRight","marginTop","marginWidth","mark","marker","marker-end","marker-mid","marker-offset","marker-start","markerEnd","markerHeight","markerMid","markerOffset","markerStart","markerUnits","markerWidth","marks","mask","mask-clip","mask-composite","mask-image","mask-mode","mask-origin","mask-position","mask-position-x","mask-position-y","mask-repeat","mask-size","mask-type","maskClip","maskComposite","maskContentUnits","maskImage","maskMode","maskOrigin","maskPosition","maskPositionX","maskPositionY","maskRepeat","maskSize","maskType","maskUnits","match","matchAll","matchMedia","matchMedium","matches","matrix","matrixTransform","max","max-block-size","max-height","max-inline-size","max-width","maxActions","maxAlternatives","maxBlockSize","maxChannelCount","maxChannels","maxConnectionsPerServer","maxDecibels","maxDistance","maxHeight","maxInlineSize","maxLayers","maxLength","maxMessageSize","maxPacketLifeTime","maxRetransmits","maxTouchPoints","maxValue","maxWidth","measure","measureText","media","mediaCapabilities","mediaDevices","mediaElement","mediaGroup","mediaKeys","mediaSession","mediaStream","mediaText","meetOrSlice","memory","menubar","mergeAttributes","message","messageClass","messageHandlers","messageType","metaKey","metadata","method","methodDetails","methodName","mid","mimeType","mimeTypes","min","min-block-size","min-height","min-inline-size","min-width","minBlockSize","minDecibels","minHeight","minInlineSize","minLength","minValue","minWidth","miterLimit","mix-blend-mode","mixBlendMode","mm","mode","modify","mount","move","moveBy","moveEnd","moveFirst","moveFocusDown","moveFocusLeft","moveFocusRight","moveFocusUp","moveNext","moveRow","moveStart","moveTo","moveToBookmark","moveToElementText","moveToPoint","movementX","movementY","mozAdd","mozAnimationStartTime","mozAnon","mozApps","mozAudioCaptured","mozAudioChannelType","mozAutoplayEnabled","mozCancelAnimationFrame","mozCancelFullScreen","mozCancelRequestAnimationFrame","mozCaptureStream","mozCaptureStreamUntilEnded","mozClearDataAt","mozContact","mozContacts","mozCreateFileHandle","mozCurrentTransform","mozCurrentTransformInverse","mozCursor","mozDash","mozDashOffset","mozDecodedFrames","mozExitPointerLock","mozFillRule","mozFragmentEnd","mozFrameDelay","mozFullScreen","mozFullScreenElement","mozFullScreenEnabled","mozGetAll","mozGetAllKeys","mozGetAsFile","mozGetDataAt","mozGetMetadata","mozGetUserMedia","mozHasAudio","mozHasItem","mozHidden","mozImageSmoothingEnabled","mozIndexedDB","mozInnerScreenX","mozInnerScreenY","mozInputSource","mozIsTextField","mozItem","mozItemCount","mozItems","mozLength","mozLockOrientation","mozMatchesSelector","mozMovementX","mozMovementY","mozOpaque","mozOrientation","mozPaintCount","mozPaintedFrames","mozParsedFrames","mozPay","mozPointerLockElement","mozPresentedFrames","mozPreservesPitch","mozPressure","mozPrintCallback","mozRTCIceCandidate","mozRTCPeerConnection","mozRTCSessionDescription","mozRemove","mozRequestAnimationFrame","mozRequestFullScreen","mozRequestPointerLock","mozSetDataAt","mozSetImageElement","mozSourceNode","mozSrcObject","mozSystem","mozTCPSocket","mozTextStyle","mozTypesAt","mozUnlockOrientation","mozUserCancelled","mozVisibilityState","ms","msAnimation","msAnimationDelay","msAnimationDirection","msAnimationDuration","msAnimationFillMode","msAnimationIterationCount","msAnimationName","msAnimationPlayState","msAnimationStartTime","msAnimationTimingFunction","msBackfaceVisibility","msBlockProgression","msCSSOMElementFloatMetrics","msCaching","msCachingEnabled","msCancelRequestAnimationFrame","msCapsLockWarningOff","msClearImmediate","msClose","msContentZoomChaining","msContentZoomFactor","msContentZoomLimit","msContentZoomLimitMax","msContentZoomLimitMin","msContentZoomSnap","msContentZoomSnapPoints","msContentZoomSnapType","msContentZooming","msConvertURL","msCrypto","msDoNotTrack","msElementsFromPoint","msElementsFromRect","msExitFullscreen","msExtendedCode","msFillRule","msFirstPaint","msFlex","msFlexAlign","msFlexDirection","msFlexFlow","msFlexItemAlign","msFlexLinePack","msFlexNegative","msFlexOrder","msFlexPack","msFlexPositive","msFlexPreferredSize","msFlexWrap","msFlowFrom","msFlowInto","msFontFeatureSettings","msFullscreenElement","msFullscreenEnabled","msGetInputContext","msGetRegionContent","msGetUntransformedBounds","msGraphicsTrustStatus","msGridColumn","msGridColumnAlign","msGridColumnSpan","msGridColumns","msGridRow","msGridRowAlign","msGridRowSpan","msGridRows","msHidden","msHighContrastAdjust","msHyphenateLimitChars","msHyphenateLimitLines","msHyphenateLimitZone","msHyphens","msImageSmoothingEnabled","msImeAlign","msIndexedDB","msInterpolationMode","msIsStaticHTML","msKeySystem","msKeys","msLaunchUri","msLockOrientation","msManipulationViewsEnabled","msMatchMedia","msMatchesSelector","msMaxTouchPoints","msOrientation","msOverflowStyle","msPerspective","msPerspectiveOrigin","msPlayToDisabled","msPlayToPreferredSourceUri","msPlayToPrimary","msPointerEnabled","msRegionOverflow","msReleasePointerCapture","msRequestAnimationFrame","msRequestFullscreen","msSaveBlob","msSaveOrOpenBlob","msScrollChaining","msScrollLimit","msScrollLimitXMax","msScrollLimitXMin","msScrollLimitYMax","msScrollLimitYMin","msScrollRails","msScrollSnapPointsX","msScrollSnapPointsY","msScrollSnapType","msScrollSnapX","msScrollSnapY","msScrollTranslation","msSetImmediate","msSetMediaKeys","msSetPointerCapture","msTextCombineHorizontal","msTextSizeAdjust","msToBlob","msTouchAction","msTouchSelect","msTraceAsyncCallbackCompleted","msTraceAsyncCallbackStarting","msTraceAsyncOperationCompleted","msTraceAsyncOperationStarting","msTransform","msTransformOrigin","msTransformStyle","msTransition","msTransitionDelay","msTransitionDuration","msTransitionProperty","msTransitionTimingFunction","msUnlockOrientation","msUpdateAsyncCallbackRelation","msUserSelect","msVisibilityState","msWrapFlow","msWrapMargin","msWrapThrough","msWriteProfilerMark","msZoom","msZoomTo","mt","mul","multiEntry","multiSelectionObj","multiline","multiple","multiply","multiplySelf","mutableFile","muted","n","name","nameProp","namedItem","namedRecordset","names","namespaceURI","namespaces","naturalHeight","naturalWidth","navigate","navigation","navigationMode","navigationPreload","navigationStart","navigator","near","nearestViewportElement","negative","negotiated","netscape","networkState","newScale","newTranslate","newURL","newValue","newValueSpecifiedUnits","newVersion","newhome","next","nextElementSibling","nextHopProtocol","nextNode","nextPage","nextSibling","nickname","noHref","noModule","noResize","noShade","noValidate","noWrap","node","nodeName","nodeType","nodeValue","nonce","normalize","normalizedPathSegList","notationName","notations","note","noteGrainOn","noteOff","noteOn","notify","now","numOctaves","number","numberOfChannels","numberOfInputs","numberOfItems","numberOfOutputs","numberValue","oMatchesSelector","object","object-fit","object-position","objectFit","objectPosition","objectStore","objectStoreNames","objectType","observe","of","offscreenBuffering","offset","offset-anchor","offset-distance","offset-path","offset-rotate","offsetAnchor","offsetDistance","offsetHeight","offsetLeft","offsetNode","offsetParent","offsetPath","offsetRotate","offsetTop","offsetWidth","offsetX","offsetY","ok","oldURL","oldValue","oldVersion","olderShadowRoot","onLine","onabort","onabsolutedeviceorientation","onactivate","onactive","onaddsourcebuffer","onaddstream","onaddtrack","onafterprint","onafterscriptexecute","onafterupdate","onanimationcancel","onanimationend","onanimationiteration","onanimationstart","onappinstalled","onaudioend","onaudioprocess","onaudiostart","onautocomplete","onautocompleteerror","onauxclick","onbeforeactivate","onbeforecopy","onbeforecut","onbeforedeactivate","onbeforeeditfocus","onbeforeinstallprompt","onbeforepaste","onbeforeprint","onbeforescriptexecute","onbeforeunload","onbeforeupdate","onbeforexrselect","onbegin","onblocked","onblur","onbounce","onboundary","onbufferedamountlow","oncached","oncancel","oncandidatewindowhide","oncandidatewindowshow","oncandidatewindowupdate","oncanplay","oncanplaythrough","once","oncellchange","onchange","oncharacteristicvaluechanged","onchargingchange","onchargingtimechange","onchecking","onclick","onclose","onclosing","oncompassneedscalibration","oncomplete","onconnect","onconnecting","onconnectionavailable","onconnectionstatechange","oncontextmenu","oncontrollerchange","oncontrolselect","oncopy","oncuechange","oncut","ondataavailable","ondatachannel","ondatasetchanged","ondatasetcomplete","ondblclick","ondeactivate","ondevicechange","ondevicelight","ondevicemotion","ondeviceorientation","ondeviceorientationabsolute","ondeviceproximity","ondischargingtimechange","ondisconnect","ondisplay","ondownloading","ondrag","ondragend","ondragenter","ondragexit","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onencrypted","onend","onended","onenter","onenterpictureinpicture","onerror","onerrorupdate","onexit","onfilterchange","onfinish","onfocus","onfocusin","onfocusout","onformdata","onfreeze","onfullscreenchange","onfullscreenerror","ongatheringstatechange","ongattserverdisconnected","ongesturechange","ongestureend","ongesturestart","ongotpointercapture","onhashchange","onhelp","onicecandidate","onicecandidateerror","oniceconnectionstatechange","onicegatheringstatechange","oninactive","oninput","oninputsourceschange","oninvalid","onkeydown","onkeypress","onkeystatuseschange","onkeyup","onlanguagechange","onlayoutcomplete","onleavepictureinpicture","onlevelchange","onload","onloadeddata","onloadedmetadata","onloadend","onloading","onloadingdone","onloadingerror","onloadstart","onlosecapture","onlostpointercapture","only","onmark","onmessage","onmessageerror","onmidimessage","onmousedown","onmouseenter","onmouseleave","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onmove","onmoveend","onmovestart","onmozfullscreenchange","onmozfullscreenerror","onmozorientationchange","onmozpointerlockchange","onmozpointerlockerror","onmscontentzoom","onmsfullscreenchange","onmsfullscreenerror","onmsgesturechange","onmsgesturedoubletap","onmsgestureend","onmsgesturehold","onmsgesturestart","onmsgesturetap","onmsgotpointercapture","onmsinertiastart","onmslostpointercapture","onmsmanipulationstatechanged","onmsneedkey","onmsorientationchange","onmspointercancel","onmspointerdown","onmspointerenter","onmspointerhover","onmspointerleave","onmspointermove","onmspointerout","onmspointerover","onmspointerup","onmssitemodejumplistitemremoved","onmsthumbnailclick","onmute","onnegotiationneeded","onnomatch","onnoupdate","onobsolete","onoffline","ononline","onopen","onorientationchange","onpagechange","onpagehide","onpageshow","onpaste","onpause","onpayerdetailchange","onpaymentmethodchange","onplay","onplaying","onpluginstreamstart","onpointercancel","onpointerdown","onpointerenter","onpointerleave","onpointerlockchange","onpointerlockerror","onpointermove","onpointerout","onpointerover","onpointerrawupdate","onpointerup","onpopstate","onprocessorerror","onprogress","onpropertychange","onratechange","onreading","onreadystatechange","onrejectionhandled","onrelease","onremove","onremovesourcebuffer","onremovestream","onremovetrack","onrepeat","onreset","onresize","onresizeend","onresizestart","onresourcetimingbufferfull","onresult","onresume","onrowenter","onrowexit","onrowsdelete","onrowsinserted","onscroll","onsearch","onsecuritypolicyviolation","onseeked","onseeking","onselect","onselectedcandidatepairchange","onselectend","onselectionchange","onselectstart","onshippingaddresschange","onshippingoptionchange","onshow","onsignalingstatechange","onsoundend","onsoundstart","onsourceclose","onsourceclosed","onsourceended","onsourceopen","onspeechend","onspeechstart","onsqueeze","onsqueezeend","onsqueezestart","onstalled","onstart","onstatechange","onstop","onstorage","onstoragecommit","onsubmit","onsuccess","onsuspend","onterminate","ontextinput","ontimeout","ontimeupdate","ontoggle","ontonechange","ontouchcancel","ontouchend","ontouchmove","ontouchstart","ontrack","ontransitioncancel","ontransitionend","ontransitionrun","ontransitionstart","onunhandledrejection","onunload","onunmute","onupdate","onupdateend","onupdatefound","onupdateready","onupdatestart","onupgradeneeded","onuserproximity","onversionchange","onvisibilitychange","onvoiceschanged","onvolumechange","onvrdisplayactivate","onvrdisplayconnect","onvrdisplaydeactivate","onvrdisplaydisconnect","onvrdisplaypresentchange","onwaiting","onwaitingforkey","onwarning","onwebkitanimationend","onwebkitanimationiteration","onwebkitanimationstart","onwebkitcurrentplaybacktargetiswirelesschanged","onwebkitfullscreenchange","onwebkitfullscreenerror","onwebkitkeyadded","onwebkitkeyerror","onwebkitkeymessage","onwebkitneedkey","onwebkitorientationchange","onwebkitplaybacktargetavailabilitychanged","onwebkitpointerlockchange","onwebkitpointerlockerror","onwebkitresourcetimingbufferfull","onwebkittransitionend","onwheel","onzoom","opacity","open","openCursor","openDatabase","openKeyCursor","opened","opener","opera","operationType","operator","opr","optimum","options","or","order","orderX","orderY","ordered","org","organization","orient","orientAngle","orientType","orientation","orientationX","orientationY","orientationZ","origin","originalPolicy","originalTarget","orphans","oscpu","outerHTML","outerHeight","outerText","outerWidth","outline","outline-color","outline-offset","outline-style","outline-width","outlineColor","outlineOffset","outlineStyle","outlineWidth","outputBuffer","outputLatency","outputs","overflow","overflow-anchor","overflow-block","overflow-inline","overflow-wrap","overflow-x","overflow-y","overflowAnchor","overflowBlock","overflowInline","overflowWrap","overflowX","overflowY","overrideMimeType","oversample","overscroll-behavior","overscroll-behavior-block","overscroll-behavior-inline","overscroll-behavior-x","overscroll-behavior-y","overscrollBehavior","overscrollBehaviorBlock","overscrollBehaviorInline","overscrollBehaviorX","overscrollBehaviorY","ownKeys","ownerDocument","ownerElement","ownerNode","ownerRule","ownerSVGElement","owningElement","p1","p2","p3","p4","packetSize","packets","pad","padEnd","padStart","padding","padding-block","padding-block-end","padding-block-start","padding-bottom","padding-inline","padding-inline-end","padding-inline-start","padding-left","padding-right","padding-top","paddingBlock","paddingBlockEnd","paddingBlockStart","paddingBottom","paddingInline","paddingInlineEnd","paddingInlineStart","paddingLeft","paddingRight","paddingTop","page","page-break-after","page-break-before","page-break-inside","pageBreakAfter","pageBreakBefore","pageBreakInside","pageCount","pageLeft","pageTop","pageX","pageXOffset","pageY","pageYOffset","pages","paint-order","paintOrder","paintRequests","paintType","paintWorklet","palette","pan","panningModel","parameters","parent","parentElement","parentNode","parentRule","parentStyleSheet","parentTextEdit","parentWindow","parse","parseAll","parseFloat","parseFromString","parseInt","part","participants","passive","password","pasteHTML","path","pathLength","pathSegList","pathSegType","pathSegTypeAsLetter","pathname","pattern","patternContentUnits","patternMismatch","patternTransform","patternUnits","pause","pauseAnimations","pauseOnExit","pauseProfilers","pauseTransformFeedback","paused","payerEmail","payerName","payerPhone","paymentManager","pc","peerIdentity","pending","pendingLocalDescription","pendingRemoteDescription","percent","performance","periodicSync","permission","permissionState","permissions","persist","persisted","personalbar","perspective","perspective-origin","perspectiveOrigin","phone","phoneticFamilyName","phoneticGivenName","photo","pictureInPictureElement","pictureInPictureEnabled","pictureInPictureWindow","ping","pipeThrough","pipeTo","pitch","pixelBottom","pixelDepth","pixelHeight","pixelLeft","pixelRight","pixelStorei","pixelTop","pixelUnitToMillimeterX","pixelUnitToMillimeterY","pixelWidth","place-content","place-items","place-self","placeContent","placeItems","placeSelf","placeholder","platform","platforms","play","playEffect","playState","playbackRate","playbackState","playbackTime","played","playoutDelayHint","playsInline","plugins","pluginspage","pname","pointer-events","pointerBeforeReferenceNode","pointerEnabled","pointerEvents","pointerId","pointerLockElement","pointerType","points","pointsAtX","pointsAtY","pointsAtZ","polygonOffset","pop","populateMatrix","popupWindowFeatures","popupWindowName","popupWindowURI","port","port1","port2","ports","posBottom","posHeight","posLeft","posRight","posTop","posWidth","pose","position","positionAlign","positionX","positionY","positionZ","postError","postMessage","postalCode","poster","pow","powerEfficient","powerOff","preMultiplySelf","precision","preferredStyleSheetSet","preferredStylesheetSet","prefix","preload","prepend","presentation","preserveAlpha","preserveAspectRatio","preserveAspectRatioString","pressed","pressure","prevValue","preventDefault","preventExtensions","preventSilentAccess","previousElementSibling","previousNode","previousPage","previousRect","previousScale","previousSibling","previousTranslate","primaryKey","primitiveType","primitiveUnits","principals","print","priority","privateKey","probablySupportsContext","process","processIceMessage","processingEnd","processingStart","product","productId","productName","productSub","profile","profileEnd","profiles","projectionMatrix","promise","prompt","properties","propertyIsEnumerable","propertyName","protocol","protocolLong","prototype","provider","pseudoClass","pseudoElement","pt","publicId","publicKey","published","pulse","push","pushManager","pushNotification","pushState","put","putImageData","px","quadraticCurveTo","qualifier","quaternion","query","queryCommandEnabled","queryCommandIndeterm","queryCommandState","queryCommandSupported","queryCommandText","queryCommandValue","querySelector","querySelectorAll","queueMicrotask","quote","quotes","r","r1","r2","race","rad","radiogroup","radiusX","radiusY","random","range","rangeCount","rangeMax","rangeMin","rangeOffset","rangeOverflow","rangeParent","rangeUnderflow","rate","ratio","raw","rawId","read","readAsArrayBuffer","readAsBinaryString","readAsBlob","readAsDataURL","readAsText","readBuffer","readEntries","readOnly","readPixels","readReportRequested","readText","readValue","readable","ready","readyState","reason","reboot","receivedAlert","receiver","receivers","recipient","reconnect","recordNumber","recordsAvailable","recordset","rect","red","redEyeReduction","redirect","redirectCount","redirectEnd","redirectStart","redirected","reduce","reduceRight","reduction","refDistance","refX","refY","referenceNode","referenceSpace","referrer","referrerPolicy","refresh","region","regionAnchorX","regionAnchorY","regionId","regions","register","registerContentHandler","registerElement","registerProperty","registerProtocolHandler","reject","rel","relList","relatedAddress","relatedNode","relatedPort","relatedTarget","release","releaseCapture","releaseEvents","releaseInterface","releaseLock","releasePointerCapture","releaseShaderCompiler","reliable","reliableWrite","reload","rem","remainingSpace","remote","remoteDescription","remove","removeAllRanges","removeAttribute","removeAttributeNS","removeAttributeNode","removeBehavior","removeChild","removeCue","removeEventListener","removeFilter","removeImport","removeItem","removeListener","removeNamedItem","removeNamedItemNS","removeNode","removeParameter","removeProperty","removeRange","removeRegion","removeRule","removeSiteSpecificTrackingException","removeSourceBuffer","removeStream","removeTrack","removeVariable","removeWakeLockListener","removeWebWideTrackingException","removed","removedNodes","renderHeight","renderState","renderTime","renderWidth","renderbufferStorage","renderbufferStorageMultisample","renderedBuffer","renderingMode","renotify","repeat","replace","replaceAdjacentText","replaceAll","replaceChild","replaceChildren","replaceData","replaceId","replaceItem","replaceNode","replaceState","replaceSync","replaceTrack","replaceWholeText","replaceWith","reportValidity","request","requestAnimationFrame","requestAutocomplete","requestData","requestDevice","requestFrame","requestFullscreen","requestHitTestSource","requestHitTestSourceForTransientInput","requestId","requestIdleCallback","requestMIDIAccess","requestMediaKeySystemAccess","requestPermission","requestPictureInPicture","requestPointerLock","requestPresent","requestReferenceSpace","requestSession","requestStart","requestStorageAccess","requestSubmit","requestVideoFrameCallback","requestingWindow","requireInteraction","required","requiredExtensions","requiredFeatures","reset","resetPose","resetTransform","resize","resizeBy","resizeTo","resolve","response","responseBody","responseEnd","responseReady","responseStart","responseText","responseType","responseURL","responseXML","restartIce","restore","result","resultIndex","resultType","results","resume","resumeProfilers","resumeTransformFeedback","retry","returnValue","rev","reverse","reversed","revocable","revokeObjectURL","rgbColor","right","rightContext","rightDegrees","rightMargin","rightProjectionMatrix","rightViewMatrix","role","rolloffFactor","root","rootBounds","rootElement","rootMargin","rotate","rotateAxisAngle","rotateAxisAngleSelf","rotateFromVector","rotateFromVectorSelf","rotateSelf","rotation","rotationAngle","rotationRate","round","row-gap","rowGap","rowIndex","rowSpan","rows","rtcpTransport","rtt","ruby-align","ruby-position","rubyAlign","rubyOverhang","rubyPosition","rules","runtime","runtimeStyle","rx","ry","s","safari","sample","sampleCoverage","sampleRate","samplerParameterf","samplerParameteri","sandbox","save","saveData","scale","scale3d","scale3dSelf","scaleNonUniform","scaleNonUniformSelf","scaleSelf","scheme","scissor","scope","scopeName","scoped","screen","screenBrightness","screenEnabled","screenLeft","screenPixelToMillimeterX","screenPixelToMillimeterY","screenTop","screenX","screenY","scriptURL","scripts","scroll","scroll-behavior","scroll-margin","scroll-margin-block","scroll-margin-block-end","scroll-margin-block-start","scroll-margin-bottom","scroll-margin-inline","scroll-margin-inline-end","scroll-margin-inline-start","scroll-margin-left","scroll-margin-right","scroll-margin-top","scroll-padding","scroll-padding-block","scroll-padding-block-end","scroll-padding-block-start","scroll-padding-bottom","scroll-padding-inline","scroll-padding-inline-end","scroll-padding-inline-start","scroll-padding-left","scroll-padding-right","scroll-padding-top","scroll-snap-align","scroll-snap-type","scrollAmount","scrollBehavior","scrollBy","scrollByLines","scrollByPages","scrollDelay","scrollHeight","scrollIntoView","scrollIntoViewIfNeeded","scrollLeft","scrollLeftMax","scrollMargin","scrollMarginBlock","scrollMarginBlockEnd","scrollMarginBlockStart","scrollMarginBottom","scrollMarginInline","scrollMarginInlineEnd","scrollMarginInlineStart","scrollMarginLeft","scrollMarginRight","scrollMarginTop","scrollMaxX","scrollMaxY","scrollPadding","scrollPaddingBlock","scrollPaddingBlockEnd","scrollPaddingBlockStart","scrollPaddingBottom","scrollPaddingInline","scrollPaddingInlineEnd","scrollPaddingInlineStart","scrollPaddingLeft","scrollPaddingRight","scrollPaddingTop","scrollRestoration","scrollSnapAlign","scrollSnapType","scrollTo","scrollTop","scrollTopMax","scrollWidth","scrollX","scrollY","scrollbar-color","scrollbar-width","scrollbar3dLightColor","scrollbarArrowColor","scrollbarBaseColor","scrollbarColor","scrollbarDarkShadowColor","scrollbarFaceColor","scrollbarHighlightColor","scrollbarShadowColor","scrollbarTrackColor","scrollbarWidth","scrollbars","scrolling","scrollingElement","sctp","sctpCauseCode","sdp","sdpLineNumber","sdpMLineIndex","sdpMid","seal","search","searchBox","searchBoxJavaBridge_","searchParams","sectionRowIndex","secureConnectionStart","security","seed","seekToNextFrame","seekable","seeking","select","selectAllChildren","selectAlternateInterface","selectConfiguration","selectNode","selectNodeContents","selectNodes","selectSingleNode","selectSubString","selected","selectedIndex","selectedOptions","selectedStyleSheetSet","selectedStylesheetSet","selection","selectionDirection","selectionEnd","selectionStart","selector","selectorText","self","send","sendAsBinary","sendBeacon","sender","sentAlert","sentTimestamp","separator","serialNumber","serializeToString","serverTiming","service","serviceWorker","session","sessionId","sessionStorage","set","setActionHandler","setActive","setAlpha","setAppBadge","setAttribute","setAttributeNS","setAttributeNode","setAttributeNodeNS","setBaseAndExtent","setBigInt64","setBigUint64","setBingCurrentSearchDefault","setCapture","setCodecPreferences","setColor","setCompositeOperation","setConfiguration","setCurrentTime","setCustomValidity","setData","setDate","setDragImage","setEnd","setEndAfter","setEndBefore","setEndPoint","setFillColor","setFilterRes","setFloat32","setFloat64","setFloatValue","setFormValue","setFullYear","setHeaderValue","setHours","setIdentityProvider","setImmediate","setInt16","setInt32","setInt8","setInterval","setItem","setKeyframes","setLineCap","setLineDash","setLineJoin","setLineWidth","setLiveSeekableRange","setLocalDescription","setMatrix","setMatrixValue","setMediaKeys","setMilliseconds","setMinutes","setMiterLimit","setMonth","setNamedItem","setNamedItemNS","setNonUserCodeExceptions","setOrientToAngle","setOrientToAuto","setOrientation","setOverrideHistoryNavigationMode","setPaint","setParameter","setParameters","setPeriodicWave","setPointerCapture","setPosition","setPositionState","setPreference","setProperty","setPrototypeOf","setRGBColor","setRGBColorICCColor","setRadius","setRangeText","setRemoteDescription","setRequestHeader","setResizable","setResourceTimingBufferSize","setRotate","setScale","setSeconds","setSelectionRange","setServerCertificate","setShadow","setSinkId","setSkewX","setSkewY","setStart","setStartAfter","setStartBefore","setStdDeviation","setStreams","setStringValue","setStrokeColor","setSuggestResult","setTargetAtTime","setTargetValueAtTime","setTime","setTimeout","setTransform","setTranslate","setUTCDate","setUTCFullYear","setUTCHours","setUTCMilliseconds","setUTCMinutes","setUTCMonth","setUTCSeconds","setUint16","setUint32","setUint8","setUri","setValidity","setValueAtTime","setValueCurveAtTime","setVariable","setVelocity","setVersion","setYear","settingName","settingValue","sex","shaderSource","shadowBlur","shadowColor","shadowOffsetX","shadowOffsetY","shadowRoot","shape","shape-image-threshold","shape-margin","shape-outside","shape-rendering","shapeImageThreshold","shapeMargin","shapeOutside","shapeRendering","sheet","shift","shiftKey","shiftLeft","shippingAddress","shippingOption","shippingType","show","showHelp","showModal","showModalDialog","showModelessDialog","showNotification","sidebar","sign","signal","signalingState","signature","silent","sin","singleNodeValue","sinh","sinkId","sittingToStandingTransform","size","sizeToContent","sizeX","sizeZ","sizes","skewX","skewXSelf","skewY","skewYSelf","slice","slope","slot","small","smil","smooth","smoothingTimeConstant","snapToLines","snapshotItem","snapshotLength","some","sort","sortingCode","source","sourceBuffer","sourceBuffers","sourceCapabilities","sourceFile","sourceIndex","sources","spacing","span","speak","speakAs","speaking","species","specified","specularConstant","specularExponent","speechSynthesis","speed","speedOfSound","spellcheck","splice","split","splitText","spreadMethod","sqrt","src","srcElement","srcFilter","srcObject","srcUrn","srcdoc","srclang","srcset","stack","stackTraceLimit","stacktrace","stageParameters","standalone","standby","start","startContainer","startIce","startMessages","startNotifications","startOffset","startProfiling","startRendering","startShark","startTime","startsWith","state","status","statusCode","statusMessage","statusText","statusbar","stdDeviationX","stdDeviationY","stencilFunc","stencilFuncSeparate","stencilMask","stencilMaskSeparate","stencilOp","stencilOpSeparate","step","stepDown","stepMismatch","stepUp","sticky","stitchTiles","stop","stop-color","stop-opacity","stopColor","stopImmediatePropagation","stopNotifications","stopOpacity","stopProfiling","stopPropagation","stopShark","stopped","storage","storageArea","storageName","storageStatus","store","storeSiteSpecificTrackingException","storeWebWideTrackingException","stpVersion","stream","streams","stretch","strike","string","stringValue","stringify","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","strokeDasharray","strokeDashoffset","strokeLinecap","strokeLinejoin","strokeMiterlimit","strokeOpacity","strokeRect","strokeStyle","strokeText","strokeWidth","style","styleFloat","styleMap","styleMedia","styleSheet","styleSheetSets","styleSheets","sub","subarray","subject","submit","submitFrame","submitter","subscribe","substr","substring","substringData","subtle","subtree","suffix","suffixes","summary","sup","supported","supportedContentEncodings","supportedEntryTypes","supports","supportsSession","surfaceScale","surroundContents","suspend","suspendRedraw","swapCache","swapNode","sweepFlag","symbols","sync","sysexEnabled","system","systemCode","systemId","systemLanguage","systemXDPI","systemYDPI","tBodies","tFoot","tHead","tabIndex","table","table-layout","tableLayout","tableValues","tag","tagName","tagUrn","tags","taintEnabled","takePhoto","takeRecords","tan","tangentialPressure","tanh","target","targetElement","targetRayMode","targetRaySpace","targetTouches","targetX","targetY","tcpType","tee","tel","terminate","test","texImage2D","texImage3D","texParameterf","texParameteri","texStorage2D","texStorage3D","texSubImage2D","texSubImage3D","text","text-align","text-align-last","text-anchor","text-combine-upright","text-decoration","text-decoration-color","text-decoration-line","text-decoration-skip-ink","text-decoration-style","text-decoration-thickness","text-emphasis","text-emphasis-color","text-emphasis-position","text-emphasis-style","text-indent","text-justify","text-orientation","text-overflow","text-rendering","text-shadow","text-transform","text-underline-offset","text-underline-position","textAlign","textAlignLast","textAnchor","textAutospace","textBaseline","textCombineUpright","textContent","textDecoration","textDecorationBlink","textDecorationColor","textDecorationLine","textDecorationLineThrough","textDecorationNone","textDecorationOverline","textDecorationSkipInk","textDecorationStyle","textDecorationThickness","textDecorationUnderline","textEmphasis","textEmphasisColor","textEmphasisPosition","textEmphasisStyle","textIndent","textJustify","textJustifyTrim","textKashida","textKashidaSpace","textLength","textOrientation","textOverflow","textRendering","textShadow","textTracks","textTransform","textUnderlineOffset","textUnderlinePosition","then","threadId","threshold","thresholds","tiltX","tiltY","time","timeEnd","timeLog","timeOrigin","timeRemaining","timeStamp","timecode","timeline","timelineTime","timeout","timestamp","timestampOffset","timing","title","to","toArray","toBlob","toDataURL","toDateString","toElement","toExponential","toFixed","toFloat32Array","toFloat64Array","toGMTString","toISOString","toJSON","toLocaleDateString","toLocaleFormat","toLocaleLowerCase","toLocaleString","toLocaleTimeString","toLocaleUpperCase","toLowerCase","toMatrix","toMethod","toPrecision","toPrimitive","toSdp","toSource","toStaticHTML","toString","toStringTag","toSum","toTimeString","toUTCString","toUpperCase","toggle","toggleAttribute","toggleLongPressEnabled","tone","toneBuffer","tooLong","tooShort","toolbar","top","topMargin","total","totalFrameDelay","totalVideoFrames","touch-action","touchAction","touched","touches","trace","track","trackVisibility","transaction","transactions","transceiver","transferControlToOffscreen","transferFromImageBitmap","transferImageBitmap","transferIn","transferOut","transferSize","transferToImageBitmap","transform","transform-box","transform-origin","transform-style","transformBox","transformFeedbackVaryings","transformOrigin","transformPoint","transformString","transformStyle","transformToDocument","transformToFragment","transition","transition-delay","transition-duration","transition-property","transition-timing-function","transitionDelay","transitionDuration","transitionProperty","transitionTimingFunction","translate","translateSelf","translationX","translationY","transport","trim","trimEnd","trimLeft","trimRight","trimStart","trueSpeed","trunc","truncate","trustedTypes","turn","twist","type","typeDetail","typeMismatch","typeMustMatch","types","u2f","ubound","uint16","uint32","uint8","uint8Clamped","undefined","unescape","uneval","unicode","unicode-bidi","unicodeBidi","unicodeRange","uniform1f","uniform1fv","uniform1i","uniform1iv","uniform1ui","uniform1uiv","uniform2f","uniform2fv","uniform2i","uniform2iv","uniform2ui","uniform2uiv","uniform3f","uniform3fv","uniform3i","uniform3iv","uniform3ui","uniform3uiv","uniform4f","uniform4fv","uniform4i","uniform4iv","uniform4ui","uniform4uiv","uniformBlockBinding","uniformMatrix2fv","uniformMatrix2x3fv","uniformMatrix2x4fv","uniformMatrix3fv","uniformMatrix3x2fv","uniformMatrix3x4fv","uniformMatrix4fv","uniformMatrix4x2fv","uniformMatrix4x3fv","unique","uniqueID","uniqueNumber","unit","unitType","units","unloadEventEnd","unloadEventStart","unlock","unmount","unobserve","unpause","unpauseAnimations","unreadCount","unregister","unregisterContentHandler","unregisterProtocolHandler","unscopables","unselectable","unshift","unsubscribe","unsuspendRedraw","unsuspendRedrawAll","unwatch","unwrapKey","upDegrees","upX","upY","upZ","update","updateCommands","updateIce","updateInterval","updatePlaybackRate","updateRenderState","updateSettings","updateTiming","updateViaCache","updateWith","updated","updating","upgrade","upload","uploadTotal","uploaded","upper","upperBound","upperOpen","uri","url","urn","urns","usages","usb","usbVersionMajor","usbVersionMinor","usbVersionSubminor","useCurrentView","useMap","useProgram","usedSpace","user-select","userActivation","userAgent","userChoice","userHandle","userHint","userLanguage","userSelect","userVisibleOnly","username","usernameFragment","utterance","uuid","v8BreakIterator","vAlign","vLink","valid","validate","validateProgram","validationMessage","validity","value","valueAsDate","valueAsNumber","valueAsString","valueInSpecifiedUnits","valueMissing","valueOf","valueText","valueType","values","variable","variant","variationSettings","vector-effect","vectorEffect","velocityAngular","velocityExpansion","velocityX","velocityY","vendor","vendorId","vendorSub","verify","version","vertexAttrib1f","vertexAttrib1fv","vertexAttrib2f","vertexAttrib2fv","vertexAttrib3f","vertexAttrib3fv","vertexAttrib4f","vertexAttrib4fv","vertexAttribDivisor","vertexAttribDivisorANGLE","vertexAttribI4i","vertexAttribI4iv","vertexAttribI4ui","vertexAttribI4uiv","vertexAttribIPointer","vertexAttribPointer","vertical","vertical-align","verticalAlign","verticalOverflow","vh","vibrate","vibrationActuator","videoBitsPerSecond","videoHeight","videoTracks","videoWidth","view","viewBox","viewBoxString","viewTarget","viewTargetString","viewport","viewportAnchorX","viewportAnchorY","viewportElement","views","violatedDirective","visibility","visibilityState","visible","visualViewport","vlinkColor","vmax","vmin","voice","voiceURI","volume","vrml","vspace","vw","w","wait","waitSync","waiting","wake","wakeLock","wand","warn","wasClean","wasDiscarded","watch","watchAvailability","watchPosition","webdriver","webkitAddKey","webkitAlignContent","webkitAlignItems","webkitAlignSelf","webkitAnimation","webkitAnimationDelay","webkitAnimationDirection","webkitAnimationDuration","webkitAnimationFillMode","webkitAnimationIterationCount","webkitAnimationName","webkitAnimationPlayState","webkitAnimationTimingFunction","webkitAppearance","webkitAudioContext","webkitAudioDecodedByteCount","webkitAudioPannerNode","webkitBackfaceVisibility","webkitBackground","webkitBackgroundAttachment","webkitBackgroundClip","webkitBackgroundColor","webkitBackgroundImage","webkitBackgroundOrigin","webkitBackgroundPosition","webkitBackgroundPositionX","webkitBackgroundPositionY","webkitBackgroundRepeat","webkitBackgroundSize","webkitBackingStorePixelRatio","webkitBorderBottomLeftRadius","webkitBorderBottomRightRadius","webkitBorderImage","webkitBorderImageOutset","webkitBorderImageRepeat","webkitBorderImageSlice","webkitBorderImageSource","webkitBorderImageWidth","webkitBorderRadius","webkitBorderTopLeftRadius","webkitBorderTopRightRadius","webkitBoxAlign","webkitBoxDirection","webkitBoxFlex","webkitBoxOrdinalGroup","webkitBoxOrient","webkitBoxPack","webkitBoxShadow","webkitBoxSizing","webkitCancelAnimationFrame","webkitCancelFullScreen","webkitCancelKeyRequest","webkitCancelRequestAnimationFrame","webkitClearResourceTimings","webkitClosedCaptionsVisible","webkitConvertPointFromNodeToPage","webkitConvertPointFromPageToNode","webkitCreateShadowRoot","webkitCurrentFullScreenElement","webkitCurrentPlaybackTargetIsWireless","webkitDecodedFrameCount","webkitDirectionInvertedFromDevice","webkitDisplayingFullscreen","webkitDroppedFrameCount","webkitEnterFullScreen","webkitEnterFullscreen","webkitEntries","webkitExitFullScreen","webkitExitFullscreen","webkitExitPointerLock","webkitFilter","webkitFlex","webkitFlexBasis","webkitFlexDirection","webkitFlexFlow","webkitFlexGrow","webkitFlexShrink","webkitFlexWrap","webkitFullScreenKeyboardInputAllowed","webkitFullscreenElement","webkitFullscreenEnabled","webkitGenerateKeyRequest","webkitGetAsEntry","webkitGetDatabaseNames","webkitGetEntries","webkitGetEntriesByName","webkitGetEntriesByType","webkitGetFlowByName","webkitGetGamepads","webkitGetImageDataHD","webkitGetNamedFlows","webkitGetRegionFlowRanges","webkitGetUserMedia","webkitHasClosedCaptions","webkitHidden","webkitIDBCursor","webkitIDBDatabase","webkitIDBDatabaseError","webkitIDBDatabaseException","webkitIDBFactory","webkitIDBIndex","webkitIDBKeyRange","webkitIDBObjectStore","webkitIDBRequest","webkitIDBTransaction","webkitImageSmoothingEnabled","webkitIndexedDB","webkitInitMessageEvent","webkitIsFullScreen","webkitJustifyContent","webkitKeys","webkitLineClamp","webkitLineDashOffset","webkitLockOrientation","webkitMask","webkitMaskClip","webkitMaskComposite","webkitMaskImage","webkitMaskOrigin","webkitMaskPosition","webkitMaskPositionX","webkitMaskPositionY","webkitMaskRepeat","webkitMaskSize","webkitMatchesSelector","webkitMediaStream","webkitNotifications","webkitOfflineAudioContext","webkitOrder","webkitOrientation","webkitPeerConnection00","webkitPersistentStorage","webkitPerspective","webkitPerspectiveOrigin","webkitPointerLockElement","webkitPostMessage","webkitPreservesPitch","webkitPutImageDataHD","webkitRTCPeerConnection","webkitRegionOverset","webkitRelativePath","webkitRequestAnimationFrame","webkitRequestFileSystem","webkitRequestFullScreen","webkitRequestFullscreen","webkitRequestPointerLock","webkitResolveLocalFileSystemURL","webkitSetMediaKeys","webkitSetResourceTimingBufferSize","webkitShadowRoot","webkitShowPlaybackTargetPicker","webkitSlice","webkitSpeechGrammar","webkitSpeechGrammarList","webkitSpeechRecognition","webkitSpeechRecognitionError","webkitSpeechRecognitionEvent","webkitStorageInfo","webkitSupportsFullscreen","webkitTemporaryStorage","webkitTextFillColor","webkitTextSizeAdjust","webkitTextStroke","webkitTextStrokeColor","webkitTextStrokeWidth","webkitTransform","webkitTransformOrigin","webkitTransformStyle","webkitTransition","webkitTransitionDelay","webkitTransitionDuration","webkitTransitionProperty","webkitTransitionTimingFunction","webkitURL","webkitUnlockOrientation","webkitUserSelect","webkitVideoDecodedByteCount","webkitVisibilityState","webkitWirelessVideoPlaybackDisabled","webkitdirectory","webkitdropzone","webstore","weight","whatToShow","wheelDelta","wheelDeltaX","wheelDeltaY","whenDefined","which","white-space","whiteSpace","wholeText","widows","width","will-change","willChange","willValidate","window","withCredentials","word-break","word-spacing","word-wrap","wordBreak","wordSpacing","wordWrap","workerStart","wrap","wrapKey","writable","writableAuxiliaries","write","writeText","writeValue","writeWithoutResponse","writeln","writing-mode","writingMode","x","x1","x2","xChannelSelector","xmlEncoding","xmlStandalone","xmlVersion","xmlbase","xmllang","xmlspace","xor","xr","y","y1","y2","yChannelSelector","yandex","z","z-index","zIndex","zoom","zoomAndPan","zoomRectScreen"];function find_builtins(e){domprops.forEach(o);var t={},n="object"==typeof global?global:self;function o(t){e.add(t);}["Symbol","Map","Promise","Proxy","Reflect","Set","WeakMap","WeakSet"].forEach((function(e){t[e]=n[e]||new Function;})),["null","true","false","NaN","Infinity","-Infinity","undefined"].forEach(o),[Object,Array,Function,Number,String,Boolean,Error,Math,Date,RegExp,t.Symbol,ArrayBuffer,DataView,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,eval,EvalError,Float32Array,Float64Array,Int8Array,Int16Array,Int32Array,isFinite,isNaN,JSON,t.Map,parseFloat,parseInt,t.Promise,t.Proxy,RangeError,ReferenceError,t.Reflect,t.Set,SyntaxError,TypeError,Uint8Array,Uint8ClampedArray,Uint16Array,Uint32Array,URIError,t.WeakMap,t.WeakSet].forEach((function(e){Object.getOwnPropertyNames(e).map(o),e.prototype&&Object.getOwnPropertyNames(e.prototype).map(o);}));}function reserve_quoted_keys(e,t){function n(e){push_uniq(t,e);}e.walk(new TreeWalker((function(e){e instanceof AST_ObjectKeyVal&&e.quote?n(e.key):e instanceof AST_ObjectProperty&&e.quote?n(e.key.name):e instanceof AST_Sub&&addStrings(e.property,n);})));}function addStrings(e,t){e.walk(new TreeWalker((function(e){return e instanceof AST_Sequence?addStrings(e.tail_node(),t):e instanceof AST_String?t(e.value):e instanceof AST_Conditional&&(addStrings(e.consequent,t),addStrings(e.alternative,t)),!0})));}function mangle_properties(e,t){var n=(t=defaults$1(t,{builtins:!1,cache:null,debug:!1,keep_quoted:!1,only_cache:!1,regex:null,reserved:null,undeclared:!1},!0)).reserved;Array.isArray(n)||(n=[n]);var o=new Set(n);t.builtins||find_builtins(o);var i,r=-1,a=-1,s=new Map;t.cache?(i=t.cache.props).forEach((function(e){o.add(e);})):i=new Map;var u,l=t.regex&&new RegExp(t.regex),_=!1!==t.debug;_&&(u=!0===t.debug?"":t.debug);var c=new Set,f=new Set,p=new Set,d="strict"===t.keep_quoted;return e.walk(new TreeWalker((function(e){if(e instanceof AST_ClassPrivateProperty||e instanceof AST_PrivateMethod)p.add(e.key.name);else if(e instanceof AST_DotHash)p.add(e.property);else if(e instanceof AST_ObjectKeyVal)"string"!=typeof e.key||d&&e.quote||A(e.key);else if(e instanceof AST_ObjectProperty)d&&e.key.end.quote||A(e.key.name);else if(e instanceof AST_Dot){var n=!!t.undeclared;if(!n){for(var o=e;o.expression;)o=o.expression;n=!(o.thedef&&o.thedef.undeclared);}!n||d&&e.quote||A(e.property);}else e instanceof AST_Sub?d||addStrings(e.property,A):e instanceof AST_Call&&"Object.defineProperty"==e.expression.print_to_string()?addStrings(e.args[1],A):e instanceof AST_Binary&&"in"===e.operator&&addStrings(e.left,A);}))),e.transform(new TreeTransformer((function(e){e instanceof AST_ClassPrivateProperty||e instanceof AST_PrivateMethod?e.key.name=h(e.key.name):e instanceof AST_DotHash?e.property=h(e.property):e instanceof AST_ObjectKeyVal?"string"!=typeof e.key||d&&e.quote||(e.key=T(e.key)):e instanceof AST_ObjectProperty?d&&e.key.end.quote||(e.key.name=T(e.key.name)):e instanceof AST_Dot?d&&e.quote||(e.property=T(e.property)):!t.keep_quoted&&e instanceof AST_Sub?e.property=E(e.property):e instanceof AST_Call&&"Object.defineProperty"==e.expression.print_to_string()?e.args[1]=E(e.args[1]):e instanceof AST_Binary&&"in"===e.operator&&(e.left=E(e.left));})));function S(e){return !f.has(e)&&!o.has(e)&&(t.only_cache?i.has(e):!/^-?[0-9]+(\.[0-9]+)?(e[+-][0-9]+)?$/.test(e))}function m(e){return !(l&&!l.test(e))&&!o.has(e)&&(i.has(e)||c.has(e))}function A(e){S(e)&&c.add(e),m(e)||f.add(e);}function T(e){if(!m(e))return e;var t=i.get(e);if(!t){if(_){var n="_$"+e+"$"+u+"_";S(n)&&(t=n);}if(!t)do{t=base54(++r);}while(!S(t));i.set(e,t);}return t}function h(e){let t=s.get(e);return t||(t=base54(++a),s.set(e,t)),t}function E(e){return e.transform(new TreeTransformer((function(e){if(e instanceof AST_Sequence){var t=e.expressions.length-1;e.expressions[t]=E(e.expressions[t]);}else e instanceof AST_String?e.value=T(e.value):e instanceof AST_Conditional&&(e.consequent=E(e.consequent),e.alternative=E(e.alternative));return e})))}}var to_ascii="undefined"==typeof atob?function(e){return Buffer.from(e,"base64").toString()}:atob,to_base64="undefined"==typeof btoa?function(e){return Buffer.from(e).toString("base64")}:btoa;function read_source_map(e){var t=/(?:^|[^.])\/\/# sourceMappingURL=data:application\/json(;[\w=-]*)?;base64,([+/0-9A-Za-z]*=*)\s*$/.exec(e);return t?to_ascii(t[2]):(console.warn("inline source map not found"),null)}function set_shorthand(e,t,n){t[e]&&n.forEach((function(n){t[n]&&("object"!=typeof t[n]&&(t[n]={}),e in t[n]||(t[n][e]=t[e]));}));}function init_cache(e){e&&("props"in e?e.props instanceof Map||(e.props=map_from_object(e.props)):e.props=new Map);}function cache_to_json(e){return {props:map_to_object(e.props)}}async function minify(e,t){var n,o,i=(t=defaults$1(t,{compress:{},ecma:void 0,enclose:!1,ie8:!1,keep_classnames:void 0,keep_fnames:!1,mangle:{},module:!1,nameCache:null,output:null,format:null,parse:{},rename:void 0,safari10:!1,sourceMap:!1,timings:!1,toplevel:!1,warnings:!1,wrap:!1},!0)).timings&&{start:Date.now()};if(void 0===t.keep_classnames&&(t.keep_classnames=t.keep_fnames),void 0===t.rename&&(t.rename=t.compress&&t.mangle),t.output&&t.format)throw new Error("Please only specify either output or format option, preferrably format.");if(t.format=t.format||t.output||{},set_shorthand("ecma",t,["parse","compress","format"]),set_shorthand("ie8",t,["compress","mangle","format"]),set_shorthand("keep_classnames",t,["compress","mangle"]),set_shorthand("keep_fnames",t,["compress","mangle"]),set_shorthand("module",t,["parse","compress","mangle"]),set_shorthand("safari10",t,["mangle","format"]),set_shorthand("toplevel",t,["compress","mangle"]),set_shorthand("warnings",t,["compress"]),t.mangle&&(t.mangle=defaults$1(t.mangle,{cache:t.nameCache&&(t.nameCache.vars||{}),eval:!1,ie8:!1,keep_classnames:!1,keep_fnames:!1,module:!1,properties:!1,reserved:[],safari10:!1,toplevel:!1},!0),t.mangle.properties&&("object"!=typeof t.mangle.properties&&(t.mangle.properties={}),t.mangle.properties.keep_quoted&&(n=t.mangle.properties.reserved,Array.isArray(n)||(n=[]),t.mangle.properties.reserved=n),t.nameCache&&!("cache"in t.mangle.properties)&&(t.mangle.properties.cache=t.nameCache.props||{})),init_cache(t.mangle.cache),init_cache(t.mangle.properties.cache)),t.sourceMap&&(t.sourceMap=defaults$1(t.sourceMap,{asObject:!1,content:null,filename:null,includeSources:!1,root:null,url:null},!0)),i&&(i.parse=Date.now()),e instanceof AST_Toplevel)o=e;else {for(var r in "string"==typeof e&&(e=[e]),t.parse=t.parse||{},t.parse.toplevel=null,e)if(HOP(e,r)&&(t.parse.filename=r,t.parse.toplevel=parse$5(e[r],t.parse),t.sourceMap&&"inline"==t.sourceMap.content)){if(Object.keys(e).length>1)throw new Error("inline source map only works with singular input");t.sourceMap.content=read_source_map(e[r]);}o=t.parse.toplevel;}n&&"strict"!==t.mangle.properties.keep_quoted&&reserve_quoted_keys(o,n),t.wrap&&(o=o.wrap_commonjs(t.wrap)),t.enclose&&(o=o.wrap_enclose(t.enclose)),i&&(i.rename=Date.now()),i&&(i.compress=Date.now()),t.compress&&(o=new Compressor(t.compress,{mangle_options:t.mangle}).compress(o)),i&&(i.scope=Date.now()),t.mangle&&o.figure_out_scope(t.mangle),i&&(i.mangle=Date.now()),t.mangle&&(base54.reset(),o.compute_char_frequency(t.mangle),o.mangle_names(t.mangle)),i&&(i.properties=Date.now()),t.mangle&&t.mangle.properties&&(o=mangle_properties(o,t.mangle.properties)),i&&(i.format=Date.now());var a={};if(t.format.ast&&(a.ast=o),!HOP(t.format,"code")||t.format.code){if(t.sourceMap&&(t.format.source_map=await SourceMap$3({file:t.sourceMap.filename,orig:t.sourceMap.content,root:t.sourceMap.root}),t.sourceMap.includeSources)){if(e instanceof AST_Toplevel)throw new Error("original source content unavailable");for(var r in e)HOP(e,r)&&t.format.source_map.get().setSourceContent(r,e[r]);}delete t.format.ast,delete t.format.code;var s=OutputStream(t.format);if(o.print(s),a.code=s.get(),t.sourceMap)if(t.sourceMap.asObject?a.map=t.format.source_map.get().toJSON():a.map=t.format.source_map.toString(),"inline"==t.sourceMap.url){var u="object"==typeof a.map?JSON.stringify(a.map):a.map;a.code+="\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,"+to_base64(u);}else t.sourceMap.url&&(a.code+="\n//# sourceMappingURL="+t.sourceMap.url);}return t.nameCache&&t.mangle&&(t.mangle.cache&&(t.nameCache.vars=cache_to_json(t.mangle.cache)),t.mangle.properties&&t.mangle.properties.cache&&(t.nameCache.props=cache_to_json(t.mangle.properties.cache))),t.format&&t.format.source_map&&t.format.source_map.destroy(),i&&(i.end=Date.now(),a.timings={parse:.001*(i.rename-i.parse),rename:.001*(i.compress-i.rename),compress:.001*(i.scope-i.compress),scope:.001*(i.mangle-i.scope),mangle:.001*(i.properties-i.mangle),properties:.001*(i.format-i.properties),format:.001*(i.end-i.format),total:.001*(i.end-i.start)}),a}

/**
 * Performs the minification of JavaScript source
 * @param input the JavaScript source to minify
 * @param opts the options used by the minifier
 * @returns the resulting minified JavaScript
 */
const minifyJs = async (input, opts) => {
  const results = {
    output: input,
    sourceMap: null,
    diagnostics: [],
  };
  if (opts) {
    const mangle = opts.mangle;
    if (mangle) {
      const mangleProperties = mangle.properties;
      if (mangleProperties && mangleProperties.regex) {
        mangleProperties.regex = new RegExp(mangleProperties.regex);
      }
    }
    if (opts.sourceMap) {
      /**
       * sourceMap, when used in conjunction with compress, can lead to sourcemaps that don't in every browser. despite
       * there being a sourcemap spec, each browser has it's own tricks for trying to get sourcemaps to properly map
       * minified JS back to its original form. for the most consistent results across all browsers, explicitly disable
       * compress.
       */
      opts.compress = undefined;
    }
  }
  try {
    const minifyResults = await minify(input, opts);
    results.output = minifyResults.code;
    results.sourceMap = typeof minifyResults.map === 'string' ? JSON.parse(minifyResults.map) : minifyResults.map;
    const compress = opts.compress;
    if (compress && compress.module && results.output.endsWith('};')) {
      // stripping the semicolon here _shouldn't_ be of significant consequence for the already generated sourcemap
      results.output = results.output.substring(0, results.output.length - 1);
    }
  }
  catch (e) {
    if (e instanceof Error) {
      console.log(e.stack);
    }
    loadMinifyJsDiagnostics(input, results.diagnostics, e);
  }
  return results;
};
const loadMinifyJsDiagnostics = (sourceText, diagnostics, error) => {
  const d = {
    level: 'error',
    type: 'build',
    language: 'javascript',
    header: 'Minify JS',
    code: '',
    messageText: error.message,
    absFilePath: null,
    relFilePath: null,
    lines: [],
  };
  const err = error;
  if (typeof err.line === 'number' && err.line > -1) {
    const srcLines = splitLineBreaks(sourceText);
    const errorLine = {
      lineIndex: err.line - 1,
      lineNumber: err.line,
      text: srcLines[err.line - 1],
      errorCharStart: err.col,
      errorLength: 0,
    };
    d.lineNumber = errorLine.lineNumber;
    d.columnNumber = errorLine.errorCharStart;
    const highlightLine = errorLine.text.slice(d.columnNumber);
    for (let i = 0; i < highlightLine.length; i++) {
      if (MINIFY_CHAR_BREAK.has(highlightLine.charAt(i))) {
        break;
      }
      errorLine.errorLength++;
    }
    d.lines.push(errorLine);
    if (errorLine.errorLength === 0 && errorLine.errorCharStart > 0) {
      errorLine.errorLength = 1;
      errorLine.errorCharStart--;
    }
    if (errorLine.lineIndex > 0) {
      const previousLine = {
        lineIndex: errorLine.lineIndex - 1,
        lineNumber: errorLine.lineNumber - 1,
        text: srcLines[errorLine.lineIndex - 1],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.unshift(previousLine);
    }
    if (errorLine.lineIndex + 1 < srcLines.length) {
      const nextLine = {
        lineIndex: errorLine.lineIndex + 1,
        lineNumber: errorLine.lineNumber + 1,
        text: srcLines[errorLine.lineIndex + 1],
        errorCharStart: -1,
        errorLength: -1,
      };
      d.lines.push(nextLine);
    }
  }
  diagnostics.push(d);
};
const MINIFY_CHAR_BREAK = new Set([
  ' ',
  '=',
  '.',
  ',',
  '?',
  ':',
  ';',
  '(',
  ')',
  '{',
  '}',
  '[',
  ']',
  '|',
  `'`,
  `"`,
  '`',
]);

var SourceMapConsumer = sourceMap.SourceMapConsumer;
var SourceMapGenerator = sourceMap.SourceMapGenerator;

var mergeSourceMap = merge;

/**
 * Merge old source map and new source map and return merged.
 * If old or new source map value is falsy, return another one as it is.
 *
 * @param {object|string} [oldMap] old source map object
 * @param {object|string} [newmap] new source map object
 * @return {object|undefined} merged source map object, or undefined when both old and new source map are undefined
 */
function merge(oldMap, newMap) {
  if (!oldMap) return newMap
  if (!newMap) return oldMap

  var oldMapConsumer = new SourceMapConsumer(oldMap);
  var newMapConsumer = new SourceMapConsumer(newMap);
  var mergedMapGenerator = new SourceMapGenerator();

  // iterate on new map and overwrite original position of new map with one of old map
  newMapConsumer.eachMapping(function(m) {
  // pass when `originalLine` is null.
  // It occurs in case that the node does not have origin in original code.
  if (m.originalLine == null) return

  var origPosInOldMap = oldMapConsumer.originalPositionFor({
    line: m.originalLine,
    column: m.originalColumn
  });

  if (origPosInOldMap.source == null) return

  mergedMapGenerator.addMapping({
    original: {
    line: origPosInOldMap.line,
    column: origPosInOldMap.column
    },
    generated: {
    line: m.generatedLine,
    column: m.generatedColumn
    },
    source: origPosInOldMap.source,
    name: origPosInOldMap.name
  });
  });

  var consumers = [oldMapConsumer, newMapConsumer];
  consumers.forEach(function(consumer) {
  consumer.sources.forEach(function(sourceFile) {
    mergedMapGenerator._sources.add(sourceFile);
    var sourceContent = consumer.sourceContentFor(sourceFile);
    if (sourceContent != null) {
    mergedMapGenerator.setSourceContent(sourceFile, sourceContent);
    }
  });
  });

  mergedMapGenerator._sourceRoot = oldMap.sourceRoot;
  mergedMapGenerator._file = oldMap.file;

  return JSON.parse(mergedMapGenerator.toString())
}

process.browser=!IS_NODE_ENV;const t={};var r,n$3=undefined&&undefined.__spreadArray||function(e,t,r){if(r||2===arguments.length)for(var n,i=0,a=t.length;i<a;i++)!n&&i in t||(n||(n=Array.prototype.slice.call(t,0,i)),n[i]=t[i]);return e.concat(n||Array.prototype.slice.call(t))},i$1=undefined&&undefined.__assign||function(){return (i$1=Object.assign||function(e){for(var t,r=1,n=arguments.length;r<n;r++)for(var i in t=arguments[r])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)},a=undefined&&undefined.__makeTemplateObject||function(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e},o=undefined&&undefined.__generator||function(e,t){var r,n,i,a,o={label:0,sent:function(){if(1&i[0])throw i[1];return i[1]},trys:[],ops:[]};return a={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function s(a){return function(s){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;o;)try{if(r=1,n&&(i=2&a[0]?n.return:a[0]?n.throw||((i=n.return)&&i.call(n),0):n.next)&&!(i=i.call(n,a[1])).done)return i;switch(n=0,i&&(a=[2&a[0],i.value]),a[0]){case 0:case 1:i=a;break;case 4:return o.label++,{value:a[1],done:!1};case 5:o.label++,n=a[1],a=[0];continue;case 7:a=o.ops.pop(),o.trys.pop();continue;default:if(!((i=(i=o.trys).length>0&&i[i.length-1])||6!==a[0]&&2!==a[0])){o=0;continue}if(3===a[0]&&(!i||a[1]>i[0]&&a[1]<i[3])){o.label=a[1];break}if(6===a[0]&&o.label<i[1]){o.label=i[1],i=a;break}if(i&&o.label<i[2]){o.label=i[2],o.ops.push(a);break}i[2]&&o.ops.pop(),o.trys.pop();continue}a=t.call(e,o);}catch(e){a=[6,e],n=0;}finally{r=i=0;}if(5&a[0])throw a[1];return {value:a[0]?a[1]:void 0,done:!0}}([a,s])}}},s=undefined&&undefined.__rest||function(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var i=0;for(n=Object.getOwnPropertySymbols(e);i<n.length;i++)t.indexOf(n[i])<0&&Object.prototype.propertyIsEnumerable.call(e,n[i])&&(r[n[i]]=e[n[i]]);}return r},c=undefined&&undefined.__extends||(r=function(e,t){return (r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t;}||function(e,t){for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);})(e,t)},function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function n(){this.constructor=e;}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n);});!function(e){function t(){var e={};return e.prev=e,{head:e,tail:e,size:0}}function r(e,t){return e===t||e!=e&&t!=t}function n(e){var t=e.prev;if(!t||t===e)throw new Error("Illegal state");return t}function i(e){for(;e;){var t=!e.prev;if(e=e.next,!t)return e}}function a(e,t){for(var i=e.tail;i!==e.head;i=n(i))if(r(i.key,t))return i}function o(e,t,r){var n=a(e,t);if(!n){var i=function(e,t){return {key:e,value:t,next:void 0,prev:void 0}}(t,r);return i.prev=e.tail,e.tail.next=i,e.tail=i,e.size++,i}n.value=r;}function s(e,t){for(var i=e.tail;i!==e.head;i=n(i)){if(void 0===i.prev)throw new Error("Illegal state");if(r(i.key,t)){if(i.next)i.next.prev=i.prev;else {if(e.tail!==i)throw new Error("Illegal state");e.tail=i.prev;}return i.prev.next=i.next,i.next=i.prev,i.prev=void 0,e.size--,i}}}function c(e){for(var t=e.tail;t!==e.head;){var r=n(t);t.next=e.head,t.prev=void 0,t=r;}e.head.next=void 0,e.tail=e.head,e.size=0;}function l(e,t){for(var r=e.head;r;)(r=i(r))&&t(r.value,r.key);}function u(e,t){if(e)for(var r=e.next();!r.done;r=e.next())t(r.value);}function _(e,t){return {current:e.head,selector:t}}function d(e){return e.current=i(e.current),e.current?{value:e.selector(e.current.key,e.current.value),done:!1}:{value:void 0,done:!0}}var p;(p=e.ShimCollections||(e.ShimCollections={})).createMapShim=function(e){var r=function(){function e(e,t){this._data=_(e,t);}return e.prototype.next=function(){return d(this._data)},e}();return function(){function n(r){var n=this;this._mapData=t(),u(e(r),(function(e){var t=e[0],r=e[1];return n.set(t,r)}));}return Object.defineProperty(n.prototype,"size",{get:function(){return this._mapData.size},enumerable:!1,configurable:!0}),n.prototype.get=function(e){var t;return null===(t=a(this._mapData,e))||void 0===t?void 0:t.value},n.prototype.set=function(e,t){return o(this._mapData,e,t),this},n.prototype.has=function(e){return !!a(this._mapData,e)},n.prototype.delete=function(e){return !!s(this._mapData,e)},n.prototype.clear=function(){c(this._mapData);},n.prototype.keys=function(){return new r(this._mapData,(function(e,t){return e}))},n.prototype.values=function(){return new r(this._mapData,(function(e,t){return t}))},n.prototype.entries=function(){return new r(this._mapData,(function(e,t){return [e,t]}))},n.prototype.forEach=function(e){l(this._mapData,e);},n}()},p.createSetShim=function(e){var r=function(){function e(e,t){this._data=_(e,t);}return e.prototype.next=function(){return d(this._data)},e}();return function(){function n(r){var n=this;this._mapData=t(),u(e(r),(function(e){return n.add(e)}));}return Object.defineProperty(n.prototype,"size",{get:function(){return this._mapData.size},enumerable:!1,configurable:!0}),n.prototype.add=function(e){return o(this._mapData,e,e),this},n.prototype.has=function(e){return !!a(this._mapData,e)},n.prototype.delete=function(e){return !!s(this._mapData,e)},n.prototype.clear=function(){c(this._mapData);},n.prototype.keys=function(){return new r(this._mapData,(function(e,t){return e}))},n.prototype.values=function(){return new r(this._mapData,(function(e,t){return t}))},n.prototype.entries=function(){return new r(this._mapData,(function(e,t){return [e,t]}))},n.prototype.forEach=function(e){l(this._mapData,e);},n}()};}(t),function(e){var t,r;function n(r,n,i){var a,o=null!==(a=t[n]())&&void 0!==a?a:null===e.ShimCollections||void 0===e.ShimCollections?void 0:e.ShimCollections[i](e.getIterator);if(o)return o;throw new Error("TypeScript requires an environment that provides a compatible native ".concat(r," implementation."))}e.versionMajorMinor="4.7",e.version="4.7.4",(r=e.Comparison||(e.Comparison={}))[r.LessThan=-1]="LessThan",r[r.EqualTo=0]="EqualTo",r[r.GreaterThan=1]="GreaterThan",function(e){var t="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof global?global:"undefined"!=typeof self?self:void 0;e.tryGetNativeMap=function(){var e=null==t?void 0:t.Map;return void 0!==e&&"entries"in e.prototype&&1===new e([[0,0]]).size?e:void 0},e.tryGetNativeSet=function(){var e=null==t?void 0:t.Set;return void 0!==e&&"entries"in e.prototype&&1===new e([0]).size?e:void 0};}(t||(t={})),e.Map=n("Map","tryGetNativeMap","createMapShim"),e.Set=n("Set","tryGetNativeSet","createSetShim");}(t),function(e){function t(e,t,r){if(void 0===r&&(r=I),e)for(var n=0,i=e;n<i.length;n++)if(r(i[n],t))return !0;return !1}function r(e,t){if(e){if(!t)return e.length>0;for(var r=0,n=e;r<n.length;r++)if(t(n[r]))return !0}return !1}function i(e,t){return r(t)?r(e)?n$3(n$3([],e,!0),t,!0):t:e}function a(e,t){return t}function o(e){return e.map(a)}function s(e,t){return void 0===t?e:void 0===e?[t]:(e.push(t),e)}function c(e,t){return t<0?e.length+t:t}function l(e,t,r,n){if(void 0===t||0===t.length)return e;if(void 0===e)return t.slice(r,n);r=void 0===r?0:c(t,r),n=void 0===n?t.length:c(t,n);for(var i=r;i<n&&i<t.length;i++)void 0!==t[i]&&e.push(t[i]);return e}function u(e,r,n){return !t(e,r,n)&&(e.push(r),!0)}function _(e,t,r){t.sort((function(t,n){return r(e[t],e[n])||M(t,n)}));}function d(e,t){return 0===e.length?e:e.slice().sort(t)}function p(e){var t=0;return {next:function(){return t===e.length?{value:void 0,done:!0}:(t++,{value:e[t-1],done:!1})}}}function f(e,t,r,n,i){return g(e,r(t),r,n,i)}function g(e,t,n,i,a){if(!r(e))return -1;for(var o=a||0,s=e.length-1;o<=s;){var c=o+(s-o>>1);switch(i(n(e[c],c),t)){case-1:o=c+1;break;case 0:return c;case 1:s=c-1;}}return ~o}function m(e,t,r,n,i){if(e&&e.length>0){var a=e.length;if(a>0){var o=void 0===n||n<0?0:n,s=void 0===i||o+i>a-1?a-1:o+i,c=void 0;for(arguments.length<=2?(c=e[o],o++):c=r;o<=s;)c=t(c,e[o],o),o++;return c}}return r}e.getIterator=function(t){if(t){if(k(t))return p(t);if(t instanceof e.Map)return t.entries();if(t instanceof e.Set)return t.values();throw new Error("Iteration not supported.")}},e.emptyArray=[],e.emptyMap=new e.Map,e.emptySet=new e.Set,e.length=function(e){return e?e.length:0},e.forEach=function(e,t){if(e)for(var r=0;r<e.length;r++){var n=t(e[r],r);if(n)return n}},e.forEachRight=function(e,t){if(e)for(var r=e.length-1;r>=0;r--){var n=t(e[r],r);if(n)return n}},e.firstDefined=function(e,t){if(void 0!==e)for(var r=0;r<e.length;r++){var n=t(e[r],r);if(void 0!==n)return n}},e.firstDefinedIterator=function(e,t){for(;;){var r=e.next();if(r.done)return;var n=t(r.value);if(void 0!==n)return n}},e.reduceLeftIterator=function(e,t,r){var n=r;if(e)for(var i=e.next(),a=0;!i.done;i=e.next(),a++)n=t(n,i.value,a);return n},e.zipWith=function(t,r,n){var i=[];e.Debug.assertEqual(t.length,r.length);for(var a=0;a<t.length;a++)i.push(n(t[a],r[a],a));return i},e.zipToIterator=function(t,r){e.Debug.assertEqual(t.length,r.length);var n=0;return {next:function(){return n===t.length?{value:void 0,done:!0}:(n++,{value:[t[n-1],r[n-1]],done:!1})}}},e.zipToMap=function(t,r){e.Debug.assert(t.length===r.length);for(var n=new e.Map,i=0;i<t.length;++i)n.set(t[i],r[i]);return n},e.intersperse=function(e,t){if(e.length<=1)return e;for(var r=[],n=0,i=e.length;n<i;n++)n&&r.push(t),r.push(e[n]);return r},e.every=function(e,t){if(e)for(var r=0;r<e.length;r++)if(!t(e[r],r))return !1;return !0},e.find=function(e,t){for(var r=0;r<e.length;r++){var n=e[r];if(t(n,r))return n}},e.findLast=function(e,t){for(var r=e.length-1;r>=0;r--){var n=e[r];if(t(n,r))return n}},e.findIndex=function(e,t,r){for(var n=r||0;n<e.length;n++)if(t(e[n],n))return n;return -1},e.findLastIndex=function(e,t,r){for(var n=void 0===r?e.length-1:r;n>=0;n--)if(t(e[n],n))return n;return -1},e.findMap=function(t,r){for(var n=0;n<t.length;n++){var i=r(t[n],n);if(i)return i}return e.Debug.fail()},e.contains=t,e.arraysEqual=function(e,t,r){return void 0===r&&(r=I),e.length===t.length&&e.every((function(e,n){return r(e,t[n])}))},e.indexOfAnyCharCode=function(e,r,n){for(var i=n||0;i<e.length;i++)if(t(r,e.charCodeAt(i)))return i;return -1},e.countWhere=function(e,t){var r=0;if(e)for(var n=0;n<e.length;n++)t(e[n],n)&&r++;return r},e.filter=function(e,t){if(e){for(var r=e.length,n=0;n<r&&t(e[n]);)n++;if(n<r){var i=e.slice(0,n);for(n++;n<r;){var a=e[n];t(a)&&i.push(a),n++;}return i}}return e},e.filterMutate=function(e,t){for(var r=0,n=0;n<e.length;n++)t(e[n],n,e)&&(e[r]=e[n],r++);e.length=r;},e.clear=function(e){e.length=0;},e.map=function(e,t){var r;if(e){r=[];for(var n=0;n<e.length;n++)r.push(t(e[n],n));}return r},e.mapIterator=function(e,t){return {next:function(){var r=e.next();return r.done?r:{value:t(r.value),done:!1}}}},e.sameMap=function(e,t){if(e)for(var r=0;r<e.length;r++){var n=e[r],i=t(n,r);if(n!==i){var a=e.slice(0,r);for(a.push(i),r++;r<e.length;r++)a.push(t(e[r],r));return a}}return e},e.flatten=function(e){for(var t=[],r=0,n=e;r<n.length;r++){var i=n[r];i&&(k(i)?l(t,i):t.push(i));}return t},e.flatMap=function(t,r){var n;if(t)for(var i=0;i<t.length;i++){var a=r(t[i],i);a&&(n=k(a)?l(n,a):s(n,a));}return n||e.emptyArray},e.flatMapToMutable=function(e,t){var r=[];if(e)for(var n=0;n<e.length;n++){var i=t(e[n],n);i&&(k(i)?l(r,i):r.push(i));}return r},e.flatMapIterator=function(t,r){var n=t.next();if(n.done)return e.emptyIterator;var i=a(n.value);return {next:function(){for(;;){var e=i.next();if(!e.done)return e;var r=t.next();if(r.done)return r;i=a(r.value);}}};function a(t){var n=r(t);return void 0===n?e.emptyIterator:k(n)?p(n):n}},e.sameFlatMap=function(e,t){var r;if(e)for(var n=0;n<e.length;n++){var i=e[n],a=t(i,n);(r||i!==a||k(a))&&(r||(r=e.slice(0,n)),k(a)?l(r,a):r.push(a));}return r||e},e.mapAllOrFail=function(e,t){for(var r=[],n=0;n<e.length;n++){var i=t(e[n],n);if(void 0===i)return;r.push(i);}return r},e.mapDefined=function(e,t){var r=[];if(e)for(var n=0;n<e.length;n++){var i=t(e[n],n);void 0!==i&&r.push(i);}return r},e.mapDefinedIterator=function(e,t){return {next:function(){for(;;){var r=e.next();if(r.done)return r;var n=t(r.value);if(void 0!==n)return {value:n,done:!1}}}}},e.mapDefinedEntries=function(t,r){if(t){var n=new e.Map;return t.forEach((function(e,t){var i=r(t,e);if(void 0!==i){var a=i[0],o=i[1];void 0!==a&&void 0!==o&&n.set(a,o);}})),n}},e.mapDefinedValues=function(t,r){if(t){var n=new e.Set;return t.forEach((function(e){var t=r(e);void 0!==t&&n.add(t);})),n}},e.getOrUpdate=function(e,t,r){if(e.has(t))return e.get(t);var n=r();return e.set(t,n),n},e.tryAddToSet=function(e,t){return !e.has(t)&&(e.add(t),!0)},e.emptyIterator={next:function(){return {value:void 0,done:!0}}},e.singleIterator=function(e){var t=!1;return {next:function(){var r=t;return t=!0,r?{value:void 0,done:!0}:{value:e,done:!1}}}},e.spanMap=function(e,t,r){var n;if(e){n=[];for(var i=e.length,a=void 0,o=void 0,s=0,c=0;s<i;){for(;c<i;){if(o=t(e[c],c),0===c)a=o;else if(o!==a)break;c++;}if(s<c){var l=r(e.slice(s,c),a,s,c);l&&n.push(l),s=c;}a=o,c++;}}return n},e.mapEntries=function(t,r){if(t){var n=new e.Map;return t.forEach((function(e,t){var i=r(t,e),a=i[0],o=i[1];n.set(a,o);})),n}},e.some=r,e.getRangesWhere=function(e,t,r){for(var n,i=0;i<e.length;i++)t(e[i])?n=void 0===n?i:n:void 0!==n&&(r(n,i),n=void 0);void 0!==n&&r(n,e.length);},e.concatenate=i,e.indicesOf=o,e.deduplicate=function(e,t,r){return 0===e.length?[]:1===e.length?e.slice():r?function(e,t,r){var n=o(e);_(e,n,r);for(var i=e[n[0]],a=[n[0]],s=1;s<n.length;s++){var c=n[s],l=e[c];t(i,l)||(a.push(c),i=l);}return a.sort(),a.map((function(t){return e[t]}))}(e,t,r):function(e,t){for(var r=[],n=0,i=e;n<i.length;n++)u(r,i[n],t);return r}(e,t)},e.createSortedArray=function(){return []},e.insertSorted=function(e,t,r,n){if(0!==e.length){var i=f(e,t,N,r);i<0?e.splice(~i,0,t):n&&e.splice(i,0,t);}else e.push(t);},e.sortAndDeduplicate=function(t,r,n){return function(t,r){if(0===t.length)return e.emptyArray;for(var n=t[0],i=[n],a=1;a<t.length;a++){var o=t[a];switch(r(o,n)){case!0:case 0:continue;case-1:return e.Debug.fail("Array is unsorted.")}i.push(n=o);}return i}(d(t,r),n||r||R)},e.arrayIsSorted=function(e,t){if(e.length<2)return !0;for(var r=e[0],n=0,i=e.slice(1);n<i.length;n++){var a=i[n];if(1===t(r,a))return !1;r=a;}return !0},e.arrayIsEqualTo=function(e,t,r){if(void 0===r&&(r=I),!e||!t)return e===t;if(e.length!==t.length)return !1;for(var n=0;n<e.length;n++)if(!r(e[n],t[n],n))return !1;return !0},e.compact=function(e){var t;if(e)for(var r=0;r<e.length;r++){var n=e[r];!t&&n||(t||(t=e.slice(0,r)),n&&t.push(n));}return t||e},e.relativeComplement=function(t,r,n){if(!r||!t||0===r.length||0===t.length)return r;var i=[];e:for(var a=0,o=0;o<r.length;o++){o>0&&e.Debug.assertGreaterThanOrEqual(n(r[o],r[o-1]),0);t:for(var s=a;a<t.length;a++)switch(a>s&&e.Debug.assertGreaterThanOrEqual(n(t[a],t[a-1]),0),n(r[o],t[a])){case-1:i.push(r[o]);continue e;case 0:continue e;case 1:continue t}}return i},e.sum=function(e,t){for(var r=0,n=0,i=e;n<i.length;n++)r+=i[n][t];return r},e.append=s,e.combine=function(e,t){return void 0===e?t:void 0===t?e:k(e)?k(t)?i(e,t):s(e,t):k(t)?s(t,e):[e,t]},e.addRange=l,e.pushIfUnique=u,e.appendIfUnique=function(e,t,r){return e?(u(e,t,r),e):[t]},e.sort=d,e.arrayIterator=p,e.arrayReverseIterator=function(e){var t=e.length;return {next:function(){return 0===t?{value:void 0,done:!0}:(t--,{value:e[t],done:!1})}}},e.stableSort=function(e,t){var r=o(e);return _(e,r,t),r.map((function(t){return e[t]}))},e.rangeEquals=function(e,t,r,n){for(;r<n;){if(e[r]!==t[r])return !1;r++;}return !0},e.elementAt=function(e,t){if(e&&(t=c(e,t))<e.length)return e[t]},e.firstOrUndefined=function(e){return 0===e.length?void 0:e[0]},e.first=function(t){return e.Debug.assert(0!==t.length),t[0]},e.lastOrUndefined=function(e){return 0===e.length?void 0:e[e.length-1]},e.last=function(t){return e.Debug.assert(0!==t.length),t[t.length-1]},e.singleOrUndefined=function(e){return e&&1===e.length?e[0]:void 0},e.singleOrMany=function(e){return e&&1===e.length?e[0]:e},e.replaceElement=function(e,t,r){var n=e.slice(0);return n[t]=r,n},e.binarySearch=f,e.binarySearchKey=g,e.reduceLeft=m;var y=Object.prototype.hasOwnProperty;function v(e,t){return y.call(e,t)}function h(e){var t=[];for(var r in e)y.call(e,r)&&t.push(r);return t}e.hasProperty=v,e.getProperty=function(e,t){return y.call(e,t)?e[t]:void 0},e.getOwnKeys=h,e.getAllKeys=function(e){var t=[];do{for(var r=0,n=Object.getOwnPropertyNames(e);r<n.length;r++)u(t,n[r]);}while(e=Object.getPrototypeOf(e));return t},e.getOwnValues=function(e){var t=[];for(var r in e)y.call(e,r)&&t.push(e[r]);return t};var b=Object.entries||function(e){for(var t=h(e),r=Array(t.length),n=0;n<t.length;n++)r[n]=[t[n],e[t[n]]];return r};function x(e,t){for(var r=[],n=e.next();!n.done;n=e.next())r.push(t?t(n.value):n.value);return r}function D(e,t,r){void 0===r&&(r=N);for(var n=S(),i=0,a=e;i<a.length;i++){var o=a[i];n.add(t(o),r(o));}return n}function S(){var t=new e.Map;return t.add=T,t.remove=C,t}function T(e,t){var r=this.get(e);return r?r.push(t):this.set(e,r=[t]),r}function C(e,t){var r=this.get(e);r&&(q(r,t),r.length||this.delete(e));}function k(e){return Array.isArray?Array.isArray(e):e instanceof Array}function E(e){}function N(e){return e}function F(e){return e.toLowerCase()}e.getEntries=function(e){return e?b(e):[]},e.arrayOf=function(e,t){for(var r=new Array(e),n=0;n<e;n++)r[n]=t(n);return r},e.arrayFrom=x,e.assign=function(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];for(var n=0,i=t;n<i.length;n++){var a=i[n];if(void 0!==a)for(var o in a)v(a,o)&&(e[o]=a[o]);}return e},e.equalOwnProperties=function(e,t,r){if(void 0===r&&(r=I),e===t)return !0;if(!e||!t)return !1;for(var n in e)if(y.call(e,n)){if(!y.call(t,n))return !1;if(!r(e[n],t[n]))return !1}for(var n in t)if(y.call(t,n)&&!y.call(e,n))return !1;return !0},e.arrayToMap=function(t,r,n){void 0===n&&(n=N);for(var i=new e.Map,a=0,o=t;a<o.length;a++){var s=o[a],c=r(s);void 0!==c&&i.set(c,n(s));}return i},e.arrayToNumericMap=function(e,t,r){void 0===r&&(r=N);for(var n=[],i=0,a=e;i<a.length;i++){var o=a[i];n[t(o)]=r(o);}return n},e.arrayToMultiMap=D,e.group=function(e,t,r){return void 0===r&&(r=N),x(D(e,t).values(),r)},e.clone=function(e){var t={};for(var r in e)y.call(e,r)&&(t[r]=e[r]);return t},e.extend=function(e,t){var r={};for(var n in t)y.call(t,n)&&(r[n]=t[n]);for(var n in e)y.call(e,n)&&(r[n]=e[n]);return r},e.copyProperties=function(e,t){for(var r in t)y.call(t,r)&&(e[r]=t[r]);},e.maybeBind=function(e,t){return t?t.bind(e):void 0},e.createMultiMap=S,e.createUnderscoreEscapedMultiMap=function(){return S()},e.createSet=function(r,n){var i=new e.Map,a=0;function o(){var e,t=i.values();return {next:function(){for(;;)if(e){if(!(r=e.next()).done)return {value:r.value};e=void 0;}else {var r;if((r=t.next()).done)return {value:void 0,done:!0};if(!k(r.value))return {value:r.value};e=p(r.value);}}}}return {has:function(e){var t=r(e);if(!i.has(t))return !1;var a=i.get(t);if(!k(a))return n(a,e);for(var o=0,s=a;o<s.length;o++){var c=s[o];if(n(c,e))return !0}return !1},add:function(e){var o=r(e);if(i.has(o)){var s=i.get(o);if(k(s))t(s,e,n)||(s.push(e),a++);else {var c=s;n(c,e)||(i.set(o,[c,e]),a++);}}else i.set(o,e),a++;return this},delete:function(e){var t=r(e);if(!i.has(t))return !1;var o=i.get(t);if(k(o)){for(var s=0;s<o.length;s++)if(n(o[s],e))return 1===o.length?i.delete(t):2===o.length?i.set(t,o[1-s]):V(o,s),a--,!0}else if(n(o,e))return i.delete(t),a--,!0;return !1},clear:function(){i.clear(),a=0;},get size(){return a},forEach:function(e){for(var t=0,r=x(i.values());t<r.length;t++){var n=r[t];if(k(n))for(var a=0,o=n;a<o.length;a++){var s;e(s=o[a],s);}else e(s=n,s);}},keys:function(){return o()},values:function(){return o()},entries:function(){var e=o();return {next:function(){var t=e.next();return t.done?t:{value:[t.value,t.value]}}}}}},e.isArray=k,e.toArray=function(e){return k(e)?e:[e]},e.isString=function(e){return "string"==typeof e},e.isNumber=function(e){return "number"==typeof e},e.tryCast=function(e,t){return void 0!==e&&t(e)?e:void 0},e.cast=function(t,r){return void 0!==t&&r(t)?t:e.Debug.fail("Invalid cast. The supplied value ".concat(t," did not pass the test '").concat(e.Debug.getFunctionName(r),"'."))},e.noop=E,e.returnFalse=function(){return !1},e.returnTrue=function(){return !0},e.returnUndefined=function(){},e.identity=N,e.toLowerCase=F;var A,P=/[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;function w(e){return P.test(e)?e.replace(P,F):e}function I(e,t){return e===t}function O(e,t){return e===t?0:void 0===e?-1:void 0===t?1:e<t?-1:1}function M(e,t){return O(e,t)}function L(e,t){return e===t?0:void 0===e?-1:void 0===t?1:(e=e.toUpperCase())<(t=t.toUpperCase())?-1:e>t?1:0}function R(e,t){return O(e,t)}e.toFileNameLowerCase=w,e.notImplemented=function(){throw new Error("Not implemented")},e.memoize=function(e){var t;return function(){return e&&(t=e(),e=void 0),t}},e.memoizeOne=function(t){var r=new e.Map;return function(e){var n="".concat(typeof e,":").concat(e),i=r.get(n);return void 0!==i||r.has(n)||(i=t(e),r.set(n,i)),i}},e.compose=function(e,t,r,n,i){if(i){for(var a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];return function(e){return m(a,(function(e,t){return t(e)}),e)}}return n?function(i){return n(r(t(e(i))))}:r?function(n){return r(t(e(n)))}:t?function(r){return t(e(r))}:e?function(t){return e(t)}:function(e){return e}},(A=e.AssertionLevel||(e.AssertionLevel={}))[A.None=0]="None",A[A.Normal=1]="Normal",A[A.Aggressive=2]="Aggressive",A[A.VeryAggressive=3]="VeryAggressive",e.equateValues=I,e.equateStringsCaseInsensitive=function(e,t){return e===t||void 0!==e&&void 0!==t&&e.toUpperCase()===t.toUpperCase()},e.equateStringsCaseSensitive=function(e,t){return I(e,t)},e.compareValues=M,e.compareTextSpans=function(e,t){return M(null==e?void 0:e.start,null==t?void 0:t.start)||M(null==e?void 0:e.length,null==t?void 0:t.length)},e.min=function(e,t,r){return -1===r(e,t)?e:t},e.compareStringsCaseInsensitive=L,e.compareStringsCaseSensitive=R,e.getStringComparer=function(e){return e?L:R};var B,j,J=function(){var e,t,r="object"==typeof Intl&&"function"==typeof Intl.Collator?i:"function"==typeof String.prototype.localeCompare&&"function"==typeof String.prototype.toLocaleUpperCase&&"a".localeCompare("B")<0?a:o;return function(n){return void 0===n?e||(e=r(n)):"en-US"===n?t||(t=r(n)):r(n)};function n(e,t,r){if(e===t)return 0;if(void 0===e)return -1;if(void 0===t)return 1;var n=r(e,t);return n<0?-1:n>0?1:0}function i(e){var t=new Intl.Collator(e,{usage:"sort",sensitivity:"variant"}).compare;return function(e,r){return n(e,r,t)}}function a(e){return void 0!==e?o():function(e,r){return n(e,r,t)};function t(e,t){return e.localeCompare(t)}}function o(){return function(t,r){return n(t,r,e)};function e(e,r){return t(e.toUpperCase(),r.toUpperCase())||t(e,r)}function t(e,t){return e<t?-1:e>t?1:0}}}();function z(e,t,r){for(var n=new Array(t.length+1),i=new Array(t.length+1),a=r+.01,o=0;o<=t.length;o++)n[o]=o;for(o=1;o<=e.length;o++){var s=e.charCodeAt(o-1),c=Math.ceil(o>r?o-r:1),l=Math.floor(t.length>r+o?r+o:t.length);i[0]=o;for(var u=o,_=1;_<c;_++)i[_]=a;for(_=c;_<=l;_++){var d=e[o-1].toLowerCase()===t[_-1].toLowerCase()?n[_-1]+.1:n[_-1]+2,p=s===t.charCodeAt(_-1)?n[_-1]:Math.min(n[_]+1,i[_-1]+1,d);i[_]=p,u=Math.min(u,p);}for(_=l+1;_<=t.length;_++)i[_]=a;if(u>r)return;var f=n;n=i,i=f;}var g=n[t.length];return g>r?void 0:g}function K(e,t){var r=e.length-t.length;return r>=0&&e.indexOf(t,r)===r}function U(e,t){for(var r=t;r<e.length-1;r++)e[r]=e[r+1];e.pop();}function V(e,t){e[t]=e[e.length-1],e.pop();}function q(e,t){return function(e,r){for(var n=0;n<e.length;n++)if(e[n]===t)return V(e,n),!0;return !1}(e)}function W(e,t){return 0===e.lastIndexOf(t,0)}function H(e,t){var r=e.prefix,n=e.suffix;return t.length>=r.length+n.length&&W(t,r)&&K(t,n)}function G(e,t,r,n){for(var i=0,a=e[n];i<a.length;i++){var o=a[i],s=void 0;r?(s=r.slice()).push(o):s=[o],n===e.length-1?t.push(s):G(e,t,s,n+1);}}e.getUILocale=function(){return j},e.setUILocale=function(e){j!==e&&(j=e,B=void 0);},e.compareStringsCaseSensitiveUI=function(e,t){return (B||(B=J(j)))(e,t)},e.compareProperties=function(e,t,r,n){return e===t?0:void 0===e?-1:void 0===t?1:n(e[r],t[r])},e.compareBooleans=function(e,t){return M(e?1:0,t?1:0)},e.getSpellingSuggestion=function(t,r,n){for(var i,a=Math.min(2,Math.floor(.34*t.length)),o=Math.floor(.4*t.length)+1,s=0,c=r;s<c.length;s++){var l=c[s],u=n(l);if(void 0!==u&&Math.abs(u.length-t.length)<=a){if(u===t)continue;if(u.length<3&&u.toLowerCase()!==t.toLowerCase())continue;var _=z(t,u,o-.1);if(void 0===_)continue;e.Debug.assert(_<o),o=_,i=l;}}return i},e.endsWith=K,e.removeSuffix=function(e,t){return K(e,t)?e.slice(0,e.length-t.length):e},e.tryRemoveSuffix=function(e,t){return K(e,t)?e.slice(0,e.length-t.length):void 0},e.stringContains=function(e,t){return -1!==e.indexOf(t)},e.removeMinAndVersionNumbers=function(e){for(var t=e.length,r=t-1;r>0;r--){var n=e.charCodeAt(r);if(n>=48&&n<=57)do{--r,n=e.charCodeAt(r);}while(r>0&&n>=48&&n<=57);else {if(!(r>4)||110!==n&&78!==n)break;if(--r,105!==(n=e.charCodeAt(r))&&73!==n)break;if(--r,109!==(n=e.charCodeAt(r))&&77!==n)break;--r,n=e.charCodeAt(r);}if(45!==n&&46!==n)break;t=r;}return t===e.length?e:e.slice(0,t)},e.orderedRemoveItem=function(e,t){for(var r=0;r<e.length;r++)if(e[r]===t)return U(e,r),!0;return !1},e.orderedRemoveItemAt=U,e.unorderedRemoveItemAt=V,e.unorderedRemoveItem=q,e.createGetCanonicalFileName=function(e){return e?N:w},e.patternText=function(e){var t=e.prefix,r=e.suffix;return "".concat(t,"*").concat(r)},e.matchedText=function(t,r){return e.Debug.assert(H(t,r)),r.substring(t.prefix.length,r.length-t.suffix.length)},e.findBestPatternMatch=function(e,t,r){for(var n,i=-1,a=0,o=e;a<o.length;a++){var s=o[a],c=t(s);H(c,r)&&c.prefix.length>i&&(i=c.prefix.length,n=s);}return n},e.startsWith=W,e.removePrefix=function(e,t){return W(e,t)?e.substr(t.length):e},e.tryRemovePrefix=function(e,t,r){return void 0===r&&(r=N),W(r(e),r(t))?e.substring(t.length):void 0},e.and=function(e,t){return function(r){return e(r)&&t(r)}},e.or=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return function(){for(var t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];for(var i=0,a=e;i<a.length;i++){var o=a[i];if(t=o.apply(void 0,r))return t}return t}},e.not=function(e){return function(){for(var t=[],r=0;r<arguments.length;r++)t[r]=arguments[r];return !e.apply(void 0,t)}},e.assertType=function(e){},e.singleElementArray=function(e){return void 0===e?void 0:[e]},e.enumerateInsertsAndDeletes=function(e,t,r,n,i,a){a=a||E;for(var o=0,s=0,c=e.length,l=t.length,u=!1;o<c&&s<l;){var _=e[o],d=t[s],p=r(_,d);-1===p?(n(_),o++,u=!0):1===p?(i(d),s++,u=!0):(a(d,_),o++,s++);}for(;o<c;)n(e[o++]),u=!0;for(;s<l;)i(t[s++]),u=!0;return u},e.fill=function(e,t){for(var r=Array(e),n=0;n<e;n++)r[n]=t(n);return r},e.cartesianProduct=function(e){var t=[];return G(e,t,void 0,0),t},e.padLeft=function(e,t,r){return void 0===r&&(r=" "),t<=e.length?e:r.repeat(t-e.length)+e},e.padRight=function(e,t,r){return void 0===r&&(r=" "),t<=e.length?e:e+r.repeat(t-e.length)},e.takeWhile=function(e,t){for(var r=e.length,n=0;n<r&&t(e[n]);)n++;return e.slice(0,n)},e.trimString=String.prototype.trim?function(e){return e.trim()}:function(t){return e.trimStringEnd(e.trimStringStart(t))},e.trimStringEnd=String.prototype.trimEnd?function(e){return e.trimEnd()}:function(t){for(var r=t.length-1;r>=0&&e.isWhiteSpaceLike(t.charCodeAt(r));)r--;return t.slice(0,r+1)},e.trimStringStart=String.prototype.trimStart?function(e){return e.trimStart()}:function(e){return e.replace(/^\s+/g,"")};}(t),function(e){var t;!function(e){e[e.Off=0]="Off",e[e.Error=1]="Error",e[e.Warning=2]="Warning",e[e.Info=3]="Info",e[e.Verbose=4]="Verbose";}(t=e.LogLevel||(e.LogLevel={})),function(r){var n,i,a=0;function o(){return null!=n?n:n=new e.Version(e.version)}function s(e){return r.currentLogLevel<=e}function c(e,t){r.loggingHost&&s(e)&&r.loggingHost.log(e,t);}function l(e){c(t.Info,e);}r.currentLogLevel=t.Warning,r.isDebugging=!1,r.getTypeScriptVersion=o,r.shouldLog=s,r.log=l,(i=l=r.log||(r.log={})).error=function(e){c(t.Error,e);},i.warn=function(e){c(t.Warning,e);},i.log=function(e){c(t.Info,e);},i.trace=function(e){c(t.Verbose,e);};var u={};function _(e){return a>=e}function d(t,n){return !!_(t)||(u[n]={level:t,assertion:r[n]},r[n]=e.noop,!1)}function p(e,t){var r=new Error(e?"Debug Failure. ".concat(e):"Debug Failure.");throw Error.captureStackTrace&&Error.captureStackTrace(r,t||p),r}function f(e,t,r,n){e||(t=t?"False expression: ".concat(t):"False expression.",r&&(t+="\r\nVerbose Debug Information: "+("string"==typeof r?r:r())),p(t,n||f));}function g(e,t,r){null==e&&p(t,r||g);}function m(e,t,r){for(var n=0,i=e;n<i.length;n++)g(i[n],t,r||m);}function y(e){if("function"!=typeof e)return "";if(e.hasOwnProperty("name"))return e.name;var t=Function.prototype.toString.call(e),r=/^function\s+([\w\$]+)\s*\(/.exec(t);return r?r[1]:""}function v(t,r,n){void 0===t&&(t=0);var i=function(t){var r=[];for(var n in t){var i=t[n];"number"==typeof i&&r.push([i,n]);}return e.stableSort(r,(function(t,r){return e.compareValues(t[0],r[0])}))}(r);if(0===t)return i.length>0&&0===i[0][0]?i[0][1]:"0";if(n){for(var a="",o=t,s=0,c=i;s<c.length;s++){var l=c[s],u=l[0],_=l[1];if(u>t)break;0!==u&&u&t&&(a="".concat(a).concat(a?"|":"").concat(_),o&=~u);}if(0===o)return a}else for(var d=0,p=i;d<p.length;d++){var f=p[d];if(u=f[0],_=f[1],u===t)return _}return t.toString()}function h(t){return v(t,e.SyntaxKind,!1)}function b(t){return v(t,e.NodeFlags,!0)}function x(t){return v(t,e.ModifierFlags,!0)}function D(t){return v(t,e.TransformFlags,!0)}function S(t){return v(t,e.EmitFlags,!0)}function T(t){return v(t,e.SymbolFlags,!0)}function C(t){return v(t,e.TypeFlags,!0)}function k(t){return v(t,e.SignatureFlags,!0)}function E(t){return v(t,e.ObjectFlags,!0)}function N(t){return v(t,e.FlowFlags,!0)}r.getAssertionLevel=function(){return a},r.setAssertionLevel=function(t){var n=a;if(a=t,t>n)for(var i=0,o=e.getOwnKeys(u);i<o.length;i++){var s=o[i],c=u[s];void 0!==c&&r[s]!==c.assertion&&t>=c.level&&(r[s]=c,u[s]=void 0);}},r.shouldAssert=_,r.fail=p,r.failBadSyntaxKind=function e(t,r,n){return p("".concat(r||"Unexpected node.","\r\nNode ").concat(h(t.kind)," was unexpected."),n||e)},r.assert=f,r.assertEqual=function e(t,r,n,i,a){if(t!==r){var o=n?i?"".concat(n," ").concat(i):n:"";p("Expected ".concat(t," === ").concat(r,". ").concat(o),a||e);}},r.assertLessThan=function e(t,r,n,i){t>=r&&p("Expected ".concat(t," < ").concat(r,". ").concat(n||""),i||e);},r.assertLessThanOrEqual=function e(t,r,n){t>r&&p("Expected ".concat(t," <= ").concat(r),n||e);},r.assertGreaterThanOrEqual=function e(t,r,n){t<r&&p("Expected ".concat(t," >= ").concat(r),n||e);},r.assertIsDefined=g,r.checkDefined=function e(t,r,n){return g(t,r,n||e),t},r.assertEachIsDefined=m,r.checkEachDefined=function e(t,r,n){return m(t,r,n||e),t},r.assertNever=function t(r,n,i){void 0===n&&(n="Illegal value:");var a="object"==typeof r&&e.hasProperty(r,"kind")&&e.hasProperty(r,"pos")?"SyntaxKind: "+h(r.kind):JSON.stringify(r);return p("".concat(n," ").concat(a),i||t)},r.assertEachNode=function t(r,n,i,a){d(1,"assertEachNode")&&f(void 0===n||e.every(r,n),i||"Unexpected node.",(function(){return "Node array did not pass test '".concat(y(n),"'.")}),a||t);},r.assertNode=function e(t,r,n,i){d(1,"assertNode")&&f(void 0!==t&&(void 0===r||r(t)),n||"Unexpected node.",(function(){return "Node ".concat(h(null==t?void 0:t.kind)," did not pass test '").concat(y(r),"'.")}),i||e);},r.assertNotNode=function e(t,r,n,i){d(1,"assertNotNode")&&f(void 0===t||void 0===r||!r(t),n||"Unexpected node.",(function(){return "Node ".concat(h(t.kind)," should not have passed test '").concat(y(r),"'.")}),i||e);},r.assertOptionalNode=function e(t,r,n,i){d(1,"assertOptionalNode")&&f(void 0===r||void 0===t||r(t),n||"Unexpected node.",(function(){return "Node ".concat(h(null==t?void 0:t.kind)," did not pass test '").concat(y(r),"'.")}),i||e);},r.assertOptionalToken=function e(t,r,n,i){d(1,"assertOptionalToken")&&f(void 0===r||void 0===t||t.kind===r,n||"Unexpected node.",(function(){return "Node ".concat(h(null==t?void 0:t.kind)," was not a '").concat(h(r),"' token.")}),i||e);},r.assertMissingNode=function e(t,r,n){d(1,"assertMissingNode")&&f(void 0===t,r||"Unexpected node.",(function(){return "Node ".concat(h(t.kind)," was unexpected'.")}),n||e);},r.type=function(e){},r.getFunctionName=y,r.formatSymbol=function(t){return "{ name: ".concat(e.unescapeLeadingUnderscores(t.escapedName),"; flags: ").concat(T(t.flags),"; declarations: ").concat(e.map(t.declarations,(function(e){return h(e.kind)}))," }")},r.formatEnum=v,r.formatSyntaxKind=h,r.formatSnippetKind=function(t){return v(t,e.SnippetKind,!1)},r.formatNodeFlags=b,r.formatModifierFlags=x,r.formatTransformFlags=D,r.formatEmitFlags=S,r.formatSymbolFlags=T,r.formatTypeFlags=C,r.formatSignatureFlags=k,r.formatObjectFlags=E,r.formatFlowFlags=N;var F,A,P,w=!1;function I(e){return function(){if(L(),!F)throw new Error("Debugging helpers could not be loaded.");return F}().formatControlFlowGraph(e)}function O(t){"__debugFlowFlags"in t||Object.defineProperties(t,{__tsDebuggerDisplay:{value:function(){var e=2&this.flags?"FlowStart":4&this.flags?"FlowBranchLabel":8&this.flags?"FlowLoopLabel":16&this.flags?"FlowAssignment":32&this.flags?"FlowTrueCondition":64&this.flags?"FlowFalseCondition":128&this.flags?"FlowSwitchClause":256&this.flags?"FlowArrayMutation":512&this.flags?"FlowCall":1024&this.flags?"FlowReduceLabel":1&this.flags?"FlowUnreachable":"UnknownFlow",t=-2048&this.flags;return "".concat(e).concat(t?" (".concat(N(t),")"):"")}},__debugFlowFlags:{get:function(){return v(this.flags,e.FlowFlags,!0)}},__debugToString:{value:function(){return I(this)}}});}function M(e){"__tsDebuggerDisplay"in e||Object.defineProperties(e,{__tsDebuggerDisplay:{value:function(e){return e=String(e).replace(/(?:,[\s\w\d_]+:[^,]+)+\]$/,"]"),"NodeArray ".concat(e)}}});}function L(){if(!w){var t,r;Object.defineProperties(e.objectAllocator.getSymbolConstructor().prototype,{__tsDebuggerDisplay:{value:function(){var t=33554432&this.flags?"TransientSymbol":"Symbol",r=-33554433&this.flags;return "".concat(t," '").concat(e.symbolName(this),"'").concat(r?" (".concat(T(r),")"):"")}},__debugFlags:{get:function(){return T(this.flags)}}}),Object.defineProperties(e.objectAllocator.getTypeConstructor().prototype,{__tsDebuggerDisplay:{value:function(){var t=98304&this.flags?"NullableType":384&this.flags?"LiteralType ".concat(JSON.stringify(this.value)):2048&this.flags?"LiteralType ".concat(this.value.negative?"-":"").concat(this.value.base10Value,"n"):8192&this.flags?"UniqueESSymbolType":32&this.flags?"EnumType":67359327&this.flags?"IntrinsicType ".concat(this.intrinsicName):1048576&this.flags?"UnionType":2097152&this.flags?"IntersectionType":4194304&this.flags?"IndexType":8388608&this.flags?"IndexedAccessType":16777216&this.flags?"ConditionalType":33554432&this.flags?"SubstitutionType":262144&this.flags?"TypeParameter":524288&this.flags?3&this.objectFlags?"InterfaceType":4&this.objectFlags?"TypeReference":8&this.objectFlags?"TupleType":16&this.objectFlags?"AnonymousType":32&this.objectFlags?"MappedType":1024&this.objectFlags?"ReverseMappedType":256&this.objectFlags?"EvolvingArrayType":"ObjectType":"Type",r=524288&this.flags?-1344&this.objectFlags:0;return "".concat(t).concat(this.symbol?" '".concat(e.symbolName(this.symbol),"'"):"").concat(r?" (".concat(E(r),")"):"")}},__debugFlags:{get:function(){return C(this.flags)}},__debugObjectFlags:{get:function(){return 524288&this.flags?E(this.objectFlags):""}},__debugTypeToString:{value:function(){var e=(void 0===t&&"function"==typeof WeakMap&&(t=new WeakMap),t),r=null==e?void 0:e.get(this);return void 0===r&&(r=this.checker.typeToString(this),null==e||e.set(this,r)),r}}}),Object.defineProperties(e.objectAllocator.getSignatureConstructor().prototype,{__debugFlags:{get:function(){return k(this.flags)}},__debugSignatureToString:{value:function(){var e;return null===(e=this.checker)||void 0===e?void 0:e.signatureToString(this)}}});for(var n=0,i=[e.objectAllocator.getNodeConstructor(),e.objectAllocator.getIdentifierConstructor(),e.objectAllocator.getTokenConstructor(),e.objectAllocator.getSourceFileConstructor()];n<i.length;n++){var a=i[n];a.prototype.hasOwnProperty("__debugKind")||Object.defineProperties(a.prototype,{__tsDebuggerDisplay:{value:function(){var t=e.isGeneratedIdentifier(this)?"GeneratedIdentifier":e.isIdentifier(this)?"Identifier '".concat(e.idText(this),"'"):e.isPrivateIdentifier(this)?"PrivateIdentifier '".concat(e.idText(this),"'"):e.isStringLiteral(this)?"StringLiteral ".concat(JSON.stringify(this.text.length<10?this.text:this.text.slice(10)+"...")):e.isNumericLiteral(this)?"NumericLiteral ".concat(this.text):e.isBigIntLiteral(this)?"BigIntLiteral ".concat(this.text,"n"):e.isTypeParameterDeclaration(this)?"TypeParameterDeclaration":e.isParameter(this)?"ParameterDeclaration":e.isConstructorDeclaration(this)?"ConstructorDeclaration":e.isGetAccessorDeclaration(this)?"GetAccessorDeclaration":e.isSetAccessorDeclaration(this)?"SetAccessorDeclaration":e.isCallSignatureDeclaration(this)?"CallSignatureDeclaration":e.isConstructSignatureDeclaration(this)?"ConstructSignatureDeclaration":e.isIndexSignatureDeclaration(this)?"IndexSignatureDeclaration":e.isTypePredicateNode(this)?"TypePredicateNode":e.isTypeReferenceNode(this)?"TypeReferenceNode":e.isFunctionTypeNode(this)?"FunctionTypeNode":e.isConstructorTypeNode(this)?"ConstructorTypeNode":e.isTypeQueryNode(this)?"TypeQueryNode":e.isTypeLiteralNode(this)?"TypeLiteralNode":e.isArrayTypeNode(this)?"ArrayTypeNode":e.isTupleTypeNode(this)?"TupleTypeNode":e.isOptionalTypeNode(this)?"OptionalTypeNode":e.isRestTypeNode(this)?"RestTypeNode":e.isUnionTypeNode(this)?"UnionTypeNode":e.isIntersectionTypeNode(this)?"IntersectionTypeNode":e.isConditionalTypeNode(this)?"ConditionalTypeNode":e.isInferTypeNode(this)?"InferTypeNode":e.isParenthesizedTypeNode(this)?"ParenthesizedTypeNode":e.isThisTypeNode(this)?"ThisTypeNode":e.isTypeOperatorNode(this)?"TypeOperatorNode":e.isIndexedAccessTypeNode(this)?"IndexedAccessTypeNode":e.isMappedTypeNode(this)?"MappedTypeNode":e.isLiteralTypeNode(this)?"LiteralTypeNode":e.isNamedTupleMember(this)?"NamedTupleMember":e.isImportTypeNode(this)?"ImportTypeNode":h(this.kind);return "".concat(t).concat(this.flags?" (".concat(b(this.flags),")"):"")}},__debugKind:{get:function(){return h(this.kind)}},__debugNodeFlags:{get:function(){return b(this.flags)}},__debugModifierFlags:{get:function(){return x(e.getEffectiveModifierFlagsNoCache(this))}},__debugTransformFlags:{get:function(){return D(this.transformFlags)}},__debugIsParseTreeNode:{get:function(){return e.isParseTreeNode(this)}},__debugEmitFlags:{get:function(){return S(e.getEmitFlags(this))}},__debugGetText:{value:function(t){if(e.nodeIsSynthesized(this))return "";var n=(void 0===r&&"function"==typeof WeakMap&&(r=new WeakMap),r),i=null==n?void 0:n.get(this);if(void 0===i){var a=e.getParseTreeNode(this),o=a&&e.getSourceFileOfNode(a);i=o?e.getSourceTextOfNodeFromSourceFile(o,a,t):"",null==n||n.set(this,i);}return i}}});}try{if(e.sys&&e.sys.require){var o=e.getDirectoryPath(e.resolvePath(e.sys.getExecutingFilePath())),s=e.sys.require(o,"./compiler-debug");s.error||(s.module.init(e),F=s.module);}}catch(e){}w=!0;}}function R(t,r,n,i,a){var o=r?"DeprecationError: ":"DeprecationWarning: ";return o+="'".concat(t,"' "),o+=i?"has been deprecated since v".concat(i):"is deprecated",(o+=r?" and can no longer be used.":n?" and will no longer be usable after v".concat(n,"."):".")+(a?" ".concat(e.formatStringFromArgs(a,[t],0)):"")}r.printControlFlowGraph=function(e){return console.log(I(e))},r.formatControlFlowGraph=I,r.attachFlowNodeDebugInfo=function(e){w&&("function"==typeof Object.setPrototypeOf?(A||O(A=Object.create(Object.prototype)),Object.setPrototypeOf(e,A)):O(e));},r.attachNodeArrayDebugInfo=function(e){w&&("function"==typeof Object.setPrototypeOf?(P||M(P=Object.create(Array.prototype)),Object.setPrototypeOf(e,P)):M(e));},r.enableDebugInfo=L,r.deprecate=function(t,r){return function(e,t){return function(){return e(),t.apply(this,arguments)}}(function(t,r){var n,i;void 0===r&&(r={});var a="string"==typeof r.typeScriptVersion?new e.Version(r.typeScriptVersion):null!==(n=r.typeScriptVersion)&&void 0!==n?n:o(),s="string"==typeof r.errorAfter?new e.Version(r.errorAfter):r.errorAfter,c="string"==typeof r.warnAfter?new e.Version(r.warnAfter):r.warnAfter,u="string"==typeof r.since?new e.Version(r.since):null!==(i=r.since)&&void 0!==i?i:c,_=r.error||s&&a.compareTo(s)<=0,d=!c||a.compareTo(c)>=0;return _?function(e,t,r,n){var i=R(e,!0,t,r,n);return function(){throw new TypeError(i)}}(t,s,u,r.message):d?function(e,t,r,n){var i=!1;return function(){i||(l.warn(R(e,!1,t,r,n)),i=!0);}}(t,s,u,r.message):e.noop}(y(t),r),t)};}(e.Debug||(e.Debug={}));}(t),function(e){var t=/^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i,r=/^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i,n=/^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i,i=/^(0|[1-9]\d*)$/,a=function(){function t(t,i,a,s,c){if(void 0===i&&(i=0),void 0===a&&(a=0),void 0===s&&(s=""),void 0===c&&(c=""),"string"==typeof t){var l=e.Debug.checkDefined(o(t),"Invalid version");t=l.major,i=l.minor,a=l.patch,s=l.prerelease,c=l.build;}e.Debug.assert(t>=0,"Invalid argument: major"),e.Debug.assert(i>=0,"Invalid argument: minor"),e.Debug.assert(a>=0,"Invalid argument: patch"),e.Debug.assert(!s||r.test(s),"Invalid argument: prerelease"),e.Debug.assert(!c||n.test(c),"Invalid argument: build"),this.major=t,this.minor=i,this.patch=a,this.prerelease=s?s.split("."):e.emptyArray,this.build=c?c.split("."):e.emptyArray;}return t.tryParse=function(e){var r=o(e);if(r)return new t(r.major,r.minor,r.patch,r.prerelease,r.build)},t.prototype.compareTo=function(t){return this===t?0:void 0===t?1:e.compareValues(this.major,t.major)||e.compareValues(this.minor,t.minor)||e.compareValues(this.patch,t.patch)||function(t,r){if(t===r)return 0;if(0===t.length)return 0===r.length?0:1;if(0===r.length)return -1;for(var n=Math.min(t.length,r.length),a=0;a<n;a++){var o=t[a],s=r[a];if(o!==s){var c=i.test(o),l=i.test(s);if(c||l){if(c!==l)return c?-1:1;if(u=e.compareValues(+o,+s))return u}else {var u;if(u=e.compareStringsCaseSensitive(o,s))return u}}}return e.compareValues(t.length,r.length)}(this.prerelease,t.prerelease)},t.prototype.increment=function(r){switch(r){case"major":return new t(this.major+1,0,0);case"minor":return new t(this.major,this.minor+1,0);case"patch":return new t(this.major,this.minor,this.patch+1);default:return e.Debug.assertNever(r)}},t.prototype.toString=function(){var t="".concat(this.major,".").concat(this.minor,".").concat(this.patch);return e.some(this.prerelease)&&(t+="-".concat(this.prerelease.join("."))),e.some(this.build)&&(t+="+".concat(this.build.join("."))),t},t.zero=new t(0,0,0),t}();function o(e){var i=t.exec(e);if(i){var a=i[1],o=i[2],s=void 0===o?"0":o,c=i[3],l=void 0===c?"0":c,u=i[4],_=void 0===u?"":u,d=i[5],p=void 0===d?"":d;if((!_||r.test(_))&&(!p||n.test(p)))return {major:parseInt(a,10),minor:parseInt(s,10),patch:parseInt(l,10),prerelease:_,build:p}}}e.Version=a;var s=function(){function t(t){this._alternatives=t?e.Debug.checkDefined(p(t),"Invalid range spec."):e.emptyArray;}return t.tryParse=function(e){var r=p(e);if(r){var n=new t("");return n._alternatives=r,n}},t.prototype.test=function(e){return "string"==typeof e&&(e=new a(e)),function(e,t){if(0===t.length)return !0;for(var r=0,n=t;r<n.length;r++)if(h(e,n[r]))return !0;return !1}(e,this._alternatives)},t.prototype.toString=function(){return t=this._alternatives,e.map(t,x).join(" || ")||"*";var t;},t}();e.VersionRange=s;var c=/\|\|/g,l=/\s+/g,u=/^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i,_=/^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i,d=/^(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;function p(t){for(var r=[],n=0,i=e.trimString(t).split(c);n<i.length;n++){var a=i[n];if(a){var o=[];a=e.trimString(a);var s=_.exec(a);if(s){if(!g(s[1],s[2],o))return}else for(var u=0,p=a.split(l);u<p.length;u++){var f=p[u],y=d.exec(e.trimString(f));if(!y||!m(y[1],y[2],o))return}r.push(o);}}return r}function f(e){var t=u.exec(e);if(t){var r=t[1],n=t[2],i=void 0===n?"*":n,o=t[3],s=void 0===o?"*":o,c=t[4],l=t[5];return {version:new a(y(r)?0:parseInt(r,10),y(r)||y(i)?0:parseInt(i,10),y(r)||y(i)||y(s)?0:parseInt(s,10),c,l),major:r,minor:i,patch:s}}}function g(e,t,r){var n=f(e);if(!n)return !1;var i=f(t);return !!i&&(y(n.major)||r.push(v(">=",n.version)),y(i.major)||r.push(y(i.minor)?v("<",i.version.increment("major")):y(i.patch)?v("<",i.version.increment("minor")):v("<=",i.version)),!0)}function m(e,t,r){var n=f(t);if(!n)return !1;var i=n.version,o=n.major,s=n.minor,c=n.patch;if(y(o))"<"!==e&&">"!==e||r.push(v("<",a.zero));else switch(e){case"~":r.push(v(">=",i)),r.push(v("<",i.increment(y(s)?"major":"minor")));break;case"^":r.push(v(">=",i)),r.push(v("<",i.increment(i.major>0||y(s)?"major":i.minor>0||y(c)?"minor":"patch")));break;case"<":case">=":r.push(v(e,i));break;case"<=":case">":r.push(y(s)?v("<="===e?"<":">=",i.increment("major")):y(c)?v("<="===e?"<":">=",i.increment("minor")):v(e,i));break;case"=":case void 0:y(s)||y(c)?(r.push(v(">=",i)),r.push(v("<",i.increment(y(s)?"major":"minor")))):r.push(v("=",i));break;default:return !1}return !0}function y(e){return "*"===e||"x"===e||"X"===e}function v(e,t){return {operator:e,operand:t}}function h(e,t){for(var r=0,n=t;r<n.length;r++){var i=n[r];if(!b(e,i.operator,i.operand))return !1}return !0}function b(t,r,n){var i=t.compareTo(n);switch(r){case"<":return i<0;case"<=":return i<=0;case">":return i>0;case">=":return i>=0;case"=":return 0===i;default:return e.Debug.assertNever(r)}}function x(t){return e.map(t,D).join(" ")}function D(e){return "".concat(e.operator).concat(e.operand)}}(t),function(e){function t(e,t){return "object"==typeof e&&"number"==typeof e.timeOrigin&&"function"==typeof e.mark&&"function"==typeof e.measure&&"function"==typeof e.now&&"function"==typeof t}var r=function(){if("object"==typeof performance&&"function"==typeof PerformanceObserver&&t(performance,PerformanceObserver))return {shouldWriteNativeEvents:!0,performance,PerformanceObserver}}()||function(){if("undefined"!=typeof process&&process.nextTick&&!process.browser&&"object"==typeof module&&"function"==typeof require)try{var r,n=require("perf_hooks"),i=n.performance,a=n.PerformanceObserver;if(t(i,a)){r=i;var o=new e.Version(process.versions.node);return new e.VersionRange("<12.16.3 || 13 <13.13").test(o)&&(r={get timeOrigin(){return i.timeOrigin},now:function(){return i.now()},mark:function(e){return i.mark(e)},measure:function(e,t,r){void 0===t&&(t="nodeStart"),void 0===r&&(r="__performance.measure-fix__",i.mark(r)),i.measure(e,t,r),"__performance.measure-fix__"===r&&i.clearMarks("__performance.measure-fix__");}}),{shouldWriteNativeEvents:!1,performance:r,PerformanceObserver:a}}}catch(e){}}(),n=null==r?void 0:r.performance;e.tryGetNativePerformanceHooks=function(){return r},e.timestamp=n?function(){return n.now()}:Date.now?Date.now:function(){return +new Date};}(t),function(e){!function(t){var r,n;function i(t,r,n){var i=0;return {enter:function(){1==++i&&u(r);},exit:function(){0==--i?(u(n),_(t,r,n)):i<0&&e.Debug.fail("enter/exit count does not match.");}}}t.createTimerIf=function(e,r,n,a){return e?i(r,n,a):t.nullTimer},t.createTimer=i,t.nullTimer={enter:e.noop,exit:e.noop};var a=!1,o=e.timestamp(),s=new e.Map,c=new e.Map,l=new e.Map;function u(t){var r;if(a){var i=null!==(r=c.get(t))&&void 0!==r?r:0;c.set(t,i+1),s.set(t,e.timestamp()),null==n||n.mark(t);}}function _(t,r,i){var c,u;if(a){var _=null!==(c=void 0!==i?s.get(i):void 0)&&void 0!==c?c:e.timestamp(),d=null!==(u=void 0!==r?s.get(r):void 0)&&void 0!==u?u:o,p=l.get(t)||0;l.set(t,p+(_-d)),null==n||n.measure(t,r,i);}}t.mark=u,t.measure=_,t.getCount=function(e){return c.get(e)||0},t.getDuration=function(e){return l.get(e)||0},t.forEachMeasure=function(e){l.forEach((function(t,r){return e(r,t)}));},t.isEnabled=function(){return a},t.enable=function(t){var i;return void 0===t&&(t=e.sys),a||(a=!0,r||(r=e.tryGetNativePerformanceHooks()),r&&(o=r.performance.timeOrigin,(r.shouldWriteNativeEvents||(null===(i=null==t?void 0:t.cpuProfilingEnabled)||void 0===i?void 0:i.call(t))||(null==t?void 0:t.debugMode))&&(n=r.performance))),!0},t.disable=function(){a&&(s.clear(),c.clear(),l.clear(),n=void 0,a=!1);};}(e.performance||(e.performance={}));}(t),function(e){var t,r,n={logEvent:e.noop,logErrEvent:e.noop,logPerfEvent:e.noop,logInfoEvent:e.noop,logStartCommand:e.noop,logStopCommand:e.noop,logStartUpdateProgram:e.noop,logStopUpdateProgram:e.noop,logStartUpdateGraph:e.noop,logStopUpdateGraph:e.noop,logStartResolveModule:e.noop,logStopResolveModule:e.noop,logStartParseSourceFile:e.noop,logStopParseSourceFile:e.noop,logStartReadFile:e.noop,logStopReadFile:e.noop,logStartBindFile:e.noop,logStopBindFile:e.noop,logStartScheduledOperation:e.noop,logStopScheduledOperation:e.noop};try{var i=null!==(t=process.env.TS_ETW_MODULE_PATH)&&void 0!==t?t:"./node_modules/@microsoft/typescript-etw";r=require(i);}catch(e){r=void 0;}e.perfLogger=r&&r.logEvent?r:n;}(t),function(e){var t;!function(t){var r,n,a,o,s=0,c=0,l=[],u=[];t.startTracing=function(o,_,d){if(e.Debug.assert(!e.tracing,"Tracing already started"),void 0===r)try{r=require("fs");}catch(e){throw new Error("tracing requires having fs\n(original error: ".concat(e.message||e,")"))}n=o,l.length=0,void 0===a&&(a=e.combinePaths(_,"legend.json")),r.existsSync(_)||r.mkdirSync(_,{recursive:!0});var p="build"===n?".".concat(process.pid,"-").concat(++s):"server"===n?".".concat(process.pid):"",f=e.combinePaths(_,"trace".concat(p,".json")),g=e.combinePaths(_,"types".concat(p,".json"));u.push({configFilePath:d,tracePath:f,typesPath:g}),c=r.openSync(f,"w"),e.tracing=t;var m={cat:"__metadata",ph:"M",ts:1e3*e.timestamp(),pid:1,tid:1};r.writeSync(c,"[\n"+[i$1({name:"process_name",args:{name:"tsc"}},m),i$1({name:"thread_name",args:{name:"Main"}},m),i$1(i$1({name:"TracingStartedInBrowser"},m),{cat:"disabled-by-default-devtools.timeline"})].map((function(e){return JSON.stringify(e)})).join(",\n"));},t.stopTracing=function(){e.Debug.assert(e.tracing,"Tracing is not in progress"),e.Debug.assert(!!l.length==("server"!==n)),r.writeSync(c,"\n]\n"),r.closeSync(c),e.tracing=void 0,l.length?function(t){var n,a,o,s,c,l,_,d,p,g,m,y,v,h,b,x,D,S,T,C,k,E;e.performance.mark("beginDumpTypes");var N=u[u.length-1].typesPath,F=r.openSync(N,"w"),A=new e.Map;r.writeSync(F,"[");for(var P=t.length,w=0;w<P;w++){var I=t[w],O=I.objectFlags,M=null!==(n=I.aliasSymbol)&&void 0!==n?n:I.symbol,L=void 0;if(16&O|2944&I.flags)try{L=null===(a=I.checker)||void 0===a?void 0:a.typeToString(I);}catch(e){L=void 0;}var R={};if(8388608&I.flags){var B=I;R={indexedAccessObjectType:null===(o=B.objectType)||void 0===o?void 0:o.id,indexedAccessIndexType:null===(s=B.indexType)||void 0===s?void 0:s.id};}var j={};if(4&O){var J=I;j={instantiatedType:null===(c=J.target)||void 0===c?void 0:c.id,typeArguments:null===(l=J.resolvedTypeArguments)||void 0===l?void 0:l.map((function(e){return e.id})),referenceLocation:f(J.node)};}var z={};if(16777216&I.flags){var K=I;z={conditionalCheckType:null===(_=K.checkType)||void 0===_?void 0:_.id,conditionalExtendsType:null===(d=K.extendsType)||void 0===d?void 0:d.id,conditionalTrueType:null!==(g=null===(p=K.resolvedTrueType)||void 0===p?void 0:p.id)&&void 0!==g?g:-1,conditionalFalseType:null!==(y=null===(m=K.resolvedFalseType)||void 0===m?void 0:m.id)&&void 0!==y?y:-1};}var U={};if(33554432&I.flags){var V=I;U={substitutionBaseType:null===(v=V.baseType)||void 0===v?void 0:v.id,substituteType:null===(h=V.substitute)||void 0===h?void 0:h.id};}var q={};if(1024&O){var W=I;q={reverseMappedSourceType:null===(b=W.source)||void 0===b?void 0:b.id,reverseMappedMappedType:null===(x=W.mappedType)||void 0===x?void 0:x.id,reverseMappedConstraintType:null===(D=W.constraintType)||void 0===D?void 0:D.id};}var H={};if(256&O){var G=I;H={evolvingArrayElementType:G.elementType.id,evolvingArrayFinalType:null===(S=G.finalArrayType)||void 0===S?void 0:S.id};}var Q=void 0,X=I.checker.getRecursionIdentity(I);X&&((Q=A.get(X))||(Q=A.size,A.set(X,Q)));var Y=i$1(i$1(i$1(i$1(i$1(i$1(i$1({id:I.id,intrinsicName:I.intrinsicName,symbolName:(null==M?void 0:M.escapedName)&&e.unescapeLeadingUnderscores(M.escapedName),recursionId:Q,isTuple:!!(8&O)||void 0,unionTypes:1048576&I.flags?null===(T=I.types)||void 0===T?void 0:T.map((function(e){return e.id})):void 0,intersectionTypes:2097152&I.flags?I.types.map((function(e){return e.id})):void 0,aliasTypeArguments:null===(C=I.aliasTypeArguments)||void 0===C?void 0:C.map((function(e){return e.id})),keyofType:4194304&I.flags?null===(k=I.type)||void 0===k?void 0:k.id:void 0},R),j),z),U),q),H),{destructuringPattern:f(I.pattern),firstDeclaration:f(null===(E=null==M?void 0:M.declarations)||void 0===E?void 0:E[0]),flags:e.Debug.formatTypeFlags(I.flags).split("|"),display:L});r.writeSync(F,JSON.stringify(Y)),w<P-1&&r.writeSync(F,",\n");}r.writeSync(F,"]\n"),r.closeSync(F),e.performance.mark("endDumpTypes"),e.performance.measure("Dump types","beginDumpTypes","endDumpTypes");}(l):u[u.length-1].typesPath=void 0;},t.recordType=function(e){"server"!==n&&l.push(e);},(o=t.Phase||(t.Phase={})).Parse="parse",o.Program="program",o.Bind="bind",o.Check="check",o.CheckTypes="checkTypes",o.Emit="emit",o.Session="session",t.instant=function(e,t,r){p("I",e,t,r,'"s":"g"');};var _=[];function d(e,t){var r=_[e],n=r.phase,i=r.name,a=r.args,o=r.time;r.separateBeginAndEnd?p("E",n,i,a,void 0,t):1e4-o%1e4<=t-o&&p("X",n,i,a,'"dur":'.concat(t-o),o);}function p(t,i,a,o,s,l){void 0===l&&(l=1e3*e.timestamp()),"server"===n&&"checkTypes"===i||(e.performance.mark("beginTracing"),r.writeSync(c,',\n{"pid":1,"tid":1,"ph":"'.concat(t,'","cat":"').concat(i,'","ts":').concat(l,',"name":"').concat(a,'"')),s&&r.writeSync(c,",".concat(s)),o&&r.writeSync(c,',"args":'.concat(JSON.stringify(o))),r.writeSync(c,"}"),e.performance.mark("endTracing"),e.performance.measure("Tracing","beginTracing","endTracing"));}function f(t){var r=e.getSourceFileOfNode(t);return r?{path:r.path,start:n(e.getLineAndCharacterOfPosition(r,t.pos)),end:n(e.getLineAndCharacterOfPosition(r,t.end))}:void 0;function n(e){return {line:e.line+1,character:e.character+1}}}t.push=function(t,r,n,i){void 0===i&&(i=!1),i&&p("B",t,r,n),_.push({phase:t,name:r,args:n,time:1e3*e.timestamp(),separateBeginAndEnd:i});},t.pop=function(){e.Debug.assert(_.length>0),d(_.length-1,1e3*e.timestamp()),_.length--;},t.popAll=function(){for(var t=1e3*e.timestamp(),r=_.length-1;r>=0;r--)d(r,t);_.length=0;},t.dumpLegend=function(){a&&r.writeFileSync(a,JSON.stringify(u));};}(t||(t={})),e.startTracing=t.startTracing,e.dumpTracingLegend=t.dumpLegend;}(t),function(e){var t,r,n,i,a,o,s,c,l;(l=e.SyntaxKind||(e.SyntaxKind={}))[l.Unknown=0]="Unknown",l[l.EndOfFileToken=1]="EndOfFileToken",l[l.SingleLineCommentTrivia=2]="SingleLineCommentTrivia",l[l.MultiLineCommentTrivia=3]="MultiLineCommentTrivia",l[l.NewLineTrivia=4]="NewLineTrivia",l[l.WhitespaceTrivia=5]="WhitespaceTrivia",l[l.ShebangTrivia=6]="ShebangTrivia",l[l.ConflictMarkerTrivia=7]="ConflictMarkerTrivia",l[l.NumericLiteral=8]="NumericLiteral",l[l.BigIntLiteral=9]="BigIntLiteral",l[l.StringLiteral=10]="StringLiteral",l[l.JsxText=11]="JsxText",l[l.JsxTextAllWhiteSpaces=12]="JsxTextAllWhiteSpaces",l[l.RegularExpressionLiteral=13]="RegularExpressionLiteral",l[l.NoSubstitutionTemplateLiteral=14]="NoSubstitutionTemplateLiteral",l[l.TemplateHead=15]="TemplateHead",l[l.TemplateMiddle=16]="TemplateMiddle",l[l.TemplateTail=17]="TemplateTail",l[l.OpenBraceToken=18]="OpenBraceToken",l[l.CloseBraceToken=19]="CloseBraceToken",l[l.OpenParenToken=20]="OpenParenToken",l[l.CloseParenToken=21]="CloseParenToken",l[l.OpenBracketToken=22]="OpenBracketToken",l[l.CloseBracketToken=23]="CloseBracketToken",l[l.DotToken=24]="DotToken",l[l.DotDotDotToken=25]="DotDotDotToken",l[l.SemicolonToken=26]="SemicolonToken",l[l.CommaToken=27]="CommaToken",l[l.QuestionDotToken=28]="QuestionDotToken",l[l.LessThanToken=29]="LessThanToken",l[l.LessThanSlashToken=30]="LessThanSlashToken",l[l.GreaterThanToken=31]="GreaterThanToken",l[l.LessThanEqualsToken=32]="LessThanEqualsToken",l[l.GreaterThanEqualsToken=33]="GreaterThanEqualsToken",l[l.EqualsEqualsToken=34]="EqualsEqualsToken",l[l.ExclamationEqualsToken=35]="ExclamationEqualsToken",l[l.EqualsEqualsEqualsToken=36]="EqualsEqualsEqualsToken",l[l.ExclamationEqualsEqualsToken=37]="ExclamationEqualsEqualsToken",l[l.EqualsGreaterThanToken=38]="EqualsGreaterThanToken",l[l.PlusToken=39]="PlusToken",l[l.MinusToken=40]="MinusToken",l[l.AsteriskToken=41]="AsteriskToken",l[l.AsteriskAsteriskToken=42]="AsteriskAsteriskToken",l[l.SlashToken=43]="SlashToken",l[l.PercentToken=44]="PercentToken",l[l.PlusPlusToken=45]="PlusPlusToken",l[l.MinusMinusToken=46]="MinusMinusToken",l[l.LessThanLessThanToken=47]="LessThanLessThanToken",l[l.GreaterThanGreaterThanToken=48]="GreaterThanGreaterThanToken",l[l.GreaterThanGreaterThanGreaterThanToken=49]="GreaterThanGreaterThanGreaterThanToken",l[l.AmpersandToken=50]="AmpersandToken",l[l.BarToken=51]="BarToken",l[l.CaretToken=52]="CaretToken",l[l.ExclamationToken=53]="ExclamationToken",l[l.TildeToken=54]="TildeToken",l[l.AmpersandAmpersandToken=55]="AmpersandAmpersandToken",l[l.BarBarToken=56]="BarBarToken",l[l.QuestionToken=57]="QuestionToken",l[l.ColonToken=58]="ColonToken",l[l.AtToken=59]="AtToken",l[l.QuestionQuestionToken=60]="QuestionQuestionToken",l[l.BacktickToken=61]="BacktickToken",l[l.HashToken=62]="HashToken",l[l.EqualsToken=63]="EqualsToken",l[l.PlusEqualsToken=64]="PlusEqualsToken",l[l.MinusEqualsToken=65]="MinusEqualsToken",l[l.AsteriskEqualsToken=66]="AsteriskEqualsToken",l[l.AsteriskAsteriskEqualsToken=67]="AsteriskAsteriskEqualsToken",l[l.SlashEqualsToken=68]="SlashEqualsToken",l[l.PercentEqualsToken=69]="PercentEqualsToken",l[l.LessThanLessThanEqualsToken=70]="LessThanLessThanEqualsToken",l[l.GreaterThanGreaterThanEqualsToken=71]="GreaterThanGreaterThanEqualsToken",l[l.GreaterThanGreaterThanGreaterThanEqualsToken=72]="GreaterThanGreaterThanGreaterThanEqualsToken",l[l.AmpersandEqualsToken=73]="AmpersandEqualsToken",l[l.BarEqualsToken=74]="BarEqualsToken",l[l.BarBarEqualsToken=75]="BarBarEqualsToken",l[l.AmpersandAmpersandEqualsToken=76]="AmpersandAmpersandEqualsToken",l[l.QuestionQuestionEqualsToken=77]="QuestionQuestionEqualsToken",l[l.CaretEqualsToken=78]="CaretEqualsToken",l[l.Identifier=79]="Identifier",l[l.PrivateIdentifier=80]="PrivateIdentifier",l[l.BreakKeyword=81]="BreakKeyword",l[l.CaseKeyword=82]="CaseKeyword",l[l.CatchKeyword=83]="CatchKeyword",l[l.ClassKeyword=84]="ClassKeyword",l[l.ConstKeyword=85]="ConstKeyword",l[l.ContinueKeyword=86]="ContinueKeyword",l[l.DebuggerKeyword=87]="DebuggerKeyword",l[l.DefaultKeyword=88]="DefaultKeyword",l[l.DeleteKeyword=89]="DeleteKeyword",l[l.DoKeyword=90]="DoKeyword",l[l.ElseKeyword=91]="ElseKeyword",l[l.EnumKeyword=92]="EnumKeyword",l[l.ExportKeyword=93]="ExportKeyword",l[l.ExtendsKeyword=94]="ExtendsKeyword",l[l.FalseKeyword=95]="FalseKeyword",l[l.FinallyKeyword=96]="FinallyKeyword",l[l.ForKeyword=97]="ForKeyword",l[l.FunctionKeyword=98]="FunctionKeyword",l[l.IfKeyword=99]="IfKeyword",l[l.ImportKeyword=100]="ImportKeyword",l[l.InKeyword=101]="InKeyword",l[l.InstanceOfKeyword=102]="InstanceOfKeyword",l[l.NewKeyword=103]="NewKeyword",l[l.NullKeyword=104]="NullKeyword",l[l.ReturnKeyword=105]="ReturnKeyword",l[l.SuperKeyword=106]="SuperKeyword",l[l.SwitchKeyword=107]="SwitchKeyword",l[l.ThisKeyword=108]="ThisKeyword",l[l.ThrowKeyword=109]="ThrowKeyword",l[l.TrueKeyword=110]="TrueKeyword",l[l.TryKeyword=111]="TryKeyword",l[l.TypeOfKeyword=112]="TypeOfKeyword",l[l.VarKeyword=113]="VarKeyword",l[l.VoidKeyword=114]="VoidKeyword",l[l.WhileKeyword=115]="WhileKeyword",l[l.WithKeyword=116]="WithKeyword",l[l.ImplementsKeyword=117]="ImplementsKeyword",l[l.InterfaceKeyword=118]="InterfaceKeyword",l[l.LetKeyword=119]="LetKeyword",l[l.PackageKeyword=120]="PackageKeyword",l[l.PrivateKeyword=121]="PrivateKeyword",l[l.ProtectedKeyword=122]="ProtectedKeyword",l[l.PublicKeyword=123]="PublicKeyword",l[l.StaticKeyword=124]="StaticKeyword",l[l.YieldKeyword=125]="YieldKeyword",l[l.AbstractKeyword=126]="AbstractKeyword",l[l.AsKeyword=127]="AsKeyword",l[l.AssertsKeyword=128]="AssertsKeyword",l[l.AssertKeyword=129]="AssertKeyword",l[l.AnyKeyword=130]="AnyKeyword",l[l.AsyncKeyword=131]="AsyncKeyword",l[l.AwaitKeyword=132]="AwaitKeyword",l[l.BooleanKeyword=133]="BooleanKeyword",l[l.ConstructorKeyword=134]="ConstructorKeyword",l[l.DeclareKeyword=135]="DeclareKeyword",l[l.GetKeyword=136]="GetKeyword",l[l.InferKeyword=137]="InferKeyword",l[l.IntrinsicKeyword=138]="IntrinsicKeyword",l[l.IsKeyword=139]="IsKeyword",l[l.KeyOfKeyword=140]="KeyOfKeyword",l[l.ModuleKeyword=141]="ModuleKeyword",l[l.NamespaceKeyword=142]="NamespaceKeyword",l[l.NeverKeyword=143]="NeverKeyword",l[l.OutKeyword=144]="OutKeyword",l[l.ReadonlyKeyword=145]="ReadonlyKeyword",l[l.RequireKeyword=146]="RequireKeyword",l[l.NumberKeyword=147]="NumberKeyword",l[l.ObjectKeyword=148]="ObjectKeyword",l[l.SetKeyword=149]="SetKeyword",l[l.StringKeyword=150]="StringKeyword",l[l.SymbolKeyword=151]="SymbolKeyword",l[l.TypeKeyword=152]="TypeKeyword",l[l.UndefinedKeyword=153]="UndefinedKeyword",l[l.UniqueKeyword=154]="UniqueKeyword",l[l.UnknownKeyword=155]="UnknownKeyword",l[l.FromKeyword=156]="FromKeyword",l[l.GlobalKeyword=157]="GlobalKeyword",l[l.BigIntKeyword=158]="BigIntKeyword",l[l.OverrideKeyword=159]="OverrideKeyword",l[l.OfKeyword=160]="OfKeyword",l[l.QualifiedName=161]="QualifiedName",l[l.ComputedPropertyName=162]="ComputedPropertyName",l[l.TypeParameter=163]="TypeParameter",l[l.Parameter=164]="Parameter",l[l.Decorator=165]="Decorator",l[l.PropertySignature=166]="PropertySignature",l[l.PropertyDeclaration=167]="PropertyDeclaration",l[l.MethodSignature=168]="MethodSignature",l[l.MethodDeclaration=169]="MethodDeclaration",l[l.ClassStaticBlockDeclaration=170]="ClassStaticBlockDeclaration",l[l.Constructor=171]="Constructor",l[l.GetAccessor=172]="GetAccessor",l[l.SetAccessor=173]="SetAccessor",l[l.CallSignature=174]="CallSignature",l[l.ConstructSignature=175]="ConstructSignature",l[l.IndexSignature=176]="IndexSignature",l[l.TypePredicate=177]="TypePredicate",l[l.TypeReference=178]="TypeReference",l[l.FunctionType=179]="FunctionType",l[l.ConstructorType=180]="ConstructorType",l[l.TypeQuery=181]="TypeQuery",l[l.TypeLiteral=182]="TypeLiteral",l[l.ArrayType=183]="ArrayType",l[l.TupleType=184]="TupleType",l[l.OptionalType=185]="OptionalType",l[l.RestType=186]="RestType",l[l.UnionType=187]="UnionType",l[l.IntersectionType=188]="IntersectionType",l[l.ConditionalType=189]="ConditionalType",l[l.InferType=190]="InferType",l[l.ParenthesizedType=191]="ParenthesizedType",l[l.ThisType=192]="ThisType",l[l.TypeOperator=193]="TypeOperator",l[l.IndexedAccessType=194]="IndexedAccessType",l[l.MappedType=195]="MappedType",l[l.LiteralType=196]="LiteralType",l[l.NamedTupleMember=197]="NamedTupleMember",l[l.TemplateLiteralType=198]="TemplateLiteralType",l[l.TemplateLiteralTypeSpan=199]="TemplateLiteralTypeSpan",l[l.ImportType=200]="ImportType",l[l.ObjectBindingPattern=201]="ObjectBindingPattern",l[l.ArrayBindingPattern=202]="ArrayBindingPattern",l[l.BindingElement=203]="BindingElement",l[l.ArrayLiteralExpression=204]="ArrayLiteralExpression",l[l.ObjectLiteralExpression=205]="ObjectLiteralExpression",l[l.PropertyAccessExpression=206]="PropertyAccessExpression",l[l.ElementAccessExpression=207]="ElementAccessExpression",l[l.CallExpression=208]="CallExpression",l[l.NewExpression=209]="NewExpression",l[l.TaggedTemplateExpression=210]="TaggedTemplateExpression",l[l.TypeAssertionExpression=211]="TypeAssertionExpression",l[l.ParenthesizedExpression=212]="ParenthesizedExpression",l[l.FunctionExpression=213]="FunctionExpression",l[l.ArrowFunction=214]="ArrowFunction",l[l.DeleteExpression=215]="DeleteExpression",l[l.TypeOfExpression=216]="TypeOfExpression",l[l.VoidExpression=217]="VoidExpression",l[l.AwaitExpression=218]="AwaitExpression",l[l.PrefixUnaryExpression=219]="PrefixUnaryExpression",l[l.PostfixUnaryExpression=220]="PostfixUnaryExpression",l[l.BinaryExpression=221]="BinaryExpression",l[l.ConditionalExpression=222]="ConditionalExpression",l[l.TemplateExpression=223]="TemplateExpression",l[l.YieldExpression=224]="YieldExpression",l[l.SpreadElement=225]="SpreadElement",l[l.ClassExpression=226]="ClassExpression",l[l.OmittedExpression=227]="OmittedExpression",l[l.ExpressionWithTypeArguments=228]="ExpressionWithTypeArguments",l[l.AsExpression=229]="AsExpression",l[l.NonNullExpression=230]="NonNullExpression",l[l.MetaProperty=231]="MetaProperty",l[l.SyntheticExpression=232]="SyntheticExpression",l[l.TemplateSpan=233]="TemplateSpan",l[l.SemicolonClassElement=234]="SemicolonClassElement",l[l.Block=235]="Block",l[l.EmptyStatement=236]="EmptyStatement",l[l.VariableStatement=237]="VariableStatement",l[l.ExpressionStatement=238]="ExpressionStatement",l[l.IfStatement=239]="IfStatement",l[l.DoStatement=240]="DoStatement",l[l.WhileStatement=241]="WhileStatement",l[l.ForStatement=242]="ForStatement",l[l.ForInStatement=243]="ForInStatement",l[l.ForOfStatement=244]="ForOfStatement",l[l.ContinueStatement=245]="ContinueStatement",l[l.BreakStatement=246]="BreakStatement",l[l.ReturnStatement=247]="ReturnStatement",l[l.WithStatement=248]="WithStatement",l[l.SwitchStatement=249]="SwitchStatement",l[l.LabeledStatement=250]="LabeledStatement",l[l.ThrowStatement=251]="ThrowStatement",l[l.TryStatement=252]="TryStatement",l[l.DebuggerStatement=253]="DebuggerStatement",l[l.VariableDeclaration=254]="VariableDeclaration",l[l.VariableDeclarationList=255]="VariableDeclarationList",l[l.FunctionDeclaration=256]="FunctionDeclaration",l[l.ClassDeclaration=257]="ClassDeclaration",l[l.InterfaceDeclaration=258]="InterfaceDeclaration",l[l.TypeAliasDeclaration=259]="TypeAliasDeclaration",l[l.EnumDeclaration=260]="EnumDeclaration",l[l.ModuleDeclaration=261]="ModuleDeclaration",l[l.ModuleBlock=262]="ModuleBlock",l[l.CaseBlock=263]="CaseBlock",l[l.NamespaceExportDeclaration=264]="NamespaceExportDeclaration",l[l.ImportEqualsDeclaration=265]="ImportEqualsDeclaration",l[l.ImportDeclaration=266]="ImportDeclaration",l[l.ImportClause=267]="ImportClause",l[l.NamespaceImport=268]="NamespaceImport",l[l.NamedImports=269]="NamedImports",l[l.ImportSpecifier=270]="ImportSpecifier",l[l.ExportAssignment=271]="ExportAssignment",l[l.ExportDeclaration=272]="ExportDeclaration",l[l.NamedExports=273]="NamedExports",l[l.NamespaceExport=274]="NamespaceExport",l[l.ExportSpecifier=275]="ExportSpecifier",l[l.MissingDeclaration=276]="MissingDeclaration",l[l.ExternalModuleReference=277]="ExternalModuleReference",l[l.JsxElement=278]="JsxElement",l[l.JsxSelfClosingElement=279]="JsxSelfClosingElement",l[l.JsxOpeningElement=280]="JsxOpeningElement",l[l.JsxClosingElement=281]="JsxClosingElement",l[l.JsxFragment=282]="JsxFragment",l[l.JsxOpeningFragment=283]="JsxOpeningFragment",l[l.JsxClosingFragment=284]="JsxClosingFragment",l[l.JsxAttribute=285]="JsxAttribute",l[l.JsxAttributes=286]="JsxAttributes",l[l.JsxSpreadAttribute=287]="JsxSpreadAttribute",l[l.JsxExpression=288]="JsxExpression",l[l.CaseClause=289]="CaseClause",l[l.DefaultClause=290]="DefaultClause",l[l.HeritageClause=291]="HeritageClause",l[l.CatchClause=292]="CatchClause",l[l.AssertClause=293]="AssertClause",l[l.AssertEntry=294]="AssertEntry",l[l.ImportTypeAssertionContainer=295]="ImportTypeAssertionContainer",l[l.PropertyAssignment=296]="PropertyAssignment",l[l.ShorthandPropertyAssignment=297]="ShorthandPropertyAssignment",l[l.SpreadAssignment=298]="SpreadAssignment",l[l.EnumMember=299]="EnumMember",l[l.UnparsedPrologue=300]="UnparsedPrologue",l[l.UnparsedPrepend=301]="UnparsedPrepend",l[l.UnparsedText=302]="UnparsedText",l[l.UnparsedInternalText=303]="UnparsedInternalText",l[l.UnparsedSyntheticReference=304]="UnparsedSyntheticReference",l[l.SourceFile=305]="SourceFile",l[l.Bundle=306]="Bundle",l[l.UnparsedSource=307]="UnparsedSource",l[l.InputFiles=308]="InputFiles",l[l.JSDocTypeExpression=309]="JSDocTypeExpression",l[l.JSDocNameReference=310]="JSDocNameReference",l[l.JSDocMemberName=311]="JSDocMemberName",l[l.JSDocAllType=312]="JSDocAllType",l[l.JSDocUnknownType=313]="JSDocUnknownType",l[l.JSDocNullableType=314]="JSDocNullableType",l[l.JSDocNonNullableType=315]="JSDocNonNullableType",l[l.JSDocOptionalType=316]="JSDocOptionalType",l[l.JSDocFunctionType=317]="JSDocFunctionType",l[l.JSDocVariadicType=318]="JSDocVariadicType",l[l.JSDocNamepathType=319]="JSDocNamepathType",l[l.JSDocComment=320]="JSDocComment",l[l.JSDocText=321]="JSDocText",l[l.JSDocTypeLiteral=322]="JSDocTypeLiteral",l[l.JSDocSignature=323]="JSDocSignature",l[l.JSDocLink=324]="JSDocLink",l[l.JSDocLinkCode=325]="JSDocLinkCode",l[l.JSDocLinkPlain=326]="JSDocLinkPlain",l[l.JSDocTag=327]="JSDocTag",l[l.JSDocAugmentsTag=328]="JSDocAugmentsTag",l[l.JSDocImplementsTag=329]="JSDocImplementsTag",l[l.JSDocAuthorTag=330]="JSDocAuthorTag",l[l.JSDocDeprecatedTag=331]="JSDocDeprecatedTag",l[l.JSDocClassTag=332]="JSDocClassTag",l[l.JSDocPublicTag=333]="JSDocPublicTag",l[l.JSDocPrivateTag=334]="JSDocPrivateTag",l[l.JSDocProtectedTag=335]="JSDocProtectedTag",l[l.JSDocReadonlyTag=336]="JSDocReadonlyTag",l[l.JSDocOverrideTag=337]="JSDocOverrideTag",l[l.JSDocCallbackTag=338]="JSDocCallbackTag",l[l.JSDocEnumTag=339]="JSDocEnumTag",l[l.JSDocParameterTag=340]="JSDocParameterTag",l[l.JSDocReturnTag=341]="JSDocReturnTag",l[l.JSDocThisTag=342]="JSDocThisTag",l[l.JSDocTypeTag=343]="JSDocTypeTag",l[l.JSDocTemplateTag=344]="JSDocTemplateTag",l[l.JSDocTypedefTag=345]="JSDocTypedefTag",l[l.JSDocSeeTag=346]="JSDocSeeTag",l[l.JSDocPropertyTag=347]="JSDocPropertyTag",l[l.SyntaxList=348]="SyntaxList",l[l.NotEmittedStatement=349]="NotEmittedStatement",l[l.PartiallyEmittedExpression=350]="PartiallyEmittedExpression",l[l.CommaListExpression=351]="CommaListExpression",l[l.MergeDeclarationMarker=352]="MergeDeclarationMarker",l[l.EndOfDeclarationMarker=353]="EndOfDeclarationMarker",l[l.SyntheticReferenceExpression=354]="SyntheticReferenceExpression",l[l.Count=355]="Count",l[l.FirstAssignment=63]="FirstAssignment",l[l.LastAssignment=78]="LastAssignment",l[l.FirstCompoundAssignment=64]="FirstCompoundAssignment",l[l.LastCompoundAssignment=78]="LastCompoundAssignment",l[l.FirstReservedWord=81]="FirstReservedWord",l[l.LastReservedWord=116]="LastReservedWord",l[l.FirstKeyword=81]="FirstKeyword",l[l.LastKeyword=160]="LastKeyword",l[l.FirstFutureReservedWord=117]="FirstFutureReservedWord",l[l.LastFutureReservedWord=125]="LastFutureReservedWord",l[l.FirstTypeNode=177]="FirstTypeNode",l[l.LastTypeNode=200]="LastTypeNode",l[l.FirstPunctuation=18]="FirstPunctuation",l[l.LastPunctuation=78]="LastPunctuation",l[l.FirstToken=0]="FirstToken",l[l.LastToken=160]="LastToken",l[l.FirstTriviaToken=2]="FirstTriviaToken",l[l.LastTriviaToken=7]="LastTriviaToken",l[l.FirstLiteralToken=8]="FirstLiteralToken",l[l.LastLiteralToken=14]="LastLiteralToken",l[l.FirstTemplateToken=14]="FirstTemplateToken",l[l.LastTemplateToken=17]="LastTemplateToken",l[l.FirstBinaryOperator=29]="FirstBinaryOperator",l[l.LastBinaryOperator=78]="LastBinaryOperator",l[l.FirstStatement=237]="FirstStatement",l[l.LastStatement=253]="LastStatement",l[l.FirstNode=161]="FirstNode",l[l.FirstJSDocNode=309]="FirstJSDocNode",l[l.LastJSDocNode=347]="LastJSDocNode",l[l.FirstJSDocTagNode=327]="FirstJSDocTagNode",l[l.LastJSDocTagNode=347]="LastJSDocTagNode",l[l.FirstContextualKeyword=126]="FirstContextualKeyword",l[l.LastContextualKeyword=160]="LastContextualKeyword",l[l.JSDoc=320]="JSDoc",(c=e.NodeFlags||(e.NodeFlags={}))[c.None=0]="None",c[c.Let=1]="Let",c[c.Const=2]="Const",c[c.NestedNamespace=4]="NestedNamespace",c[c.Synthesized=8]="Synthesized",c[c.Namespace=16]="Namespace",c[c.OptionalChain=32]="OptionalChain",c[c.ExportContext=64]="ExportContext",c[c.ContainsThis=128]="ContainsThis",c[c.HasImplicitReturn=256]="HasImplicitReturn",c[c.HasExplicitReturn=512]="HasExplicitReturn",c[c.GlobalAugmentation=1024]="GlobalAugmentation",c[c.HasAsyncFunctions=2048]="HasAsyncFunctions",c[c.DisallowInContext=4096]="DisallowInContext",c[c.YieldContext=8192]="YieldContext",c[c.DecoratorContext=16384]="DecoratorContext",c[c.AwaitContext=32768]="AwaitContext",c[c.DisallowConditionalTypesContext=65536]="DisallowConditionalTypesContext",c[c.ThisNodeHasError=131072]="ThisNodeHasError",c[c.JavaScriptFile=262144]="JavaScriptFile",c[c.ThisNodeOrAnySubNodesHasError=524288]="ThisNodeOrAnySubNodesHasError",c[c.HasAggregatedChildData=1048576]="HasAggregatedChildData",c[c.PossiblyContainsDynamicImport=2097152]="PossiblyContainsDynamicImport",c[c.PossiblyContainsImportMeta=4194304]="PossiblyContainsImportMeta",c[c.JSDoc=8388608]="JSDoc",c[c.Ambient=16777216]="Ambient",c[c.InWithStatement=33554432]="InWithStatement",c[c.JsonFile=67108864]="JsonFile",c[c.TypeCached=134217728]="TypeCached",c[c.Deprecated=268435456]="Deprecated",c[c.BlockScoped=3]="BlockScoped",c[c.ReachabilityCheckFlags=768]="ReachabilityCheckFlags",c[c.ReachabilityAndEmitFlags=2816]="ReachabilityAndEmitFlags",c[c.ContextFlags=50720768]="ContextFlags",c[c.TypeExcludesFlags=40960]="TypeExcludesFlags",c[c.PermanentlySetIncrementalFlags=6291456]="PermanentlySetIncrementalFlags",(s=e.ModifierFlags||(e.ModifierFlags={}))[s.None=0]="None",s[s.Export=1]="Export",s[s.Ambient=2]="Ambient",s[s.Public=4]="Public",s[s.Private=8]="Private",s[s.Protected=16]="Protected",s[s.Static=32]="Static",s[s.Readonly=64]="Readonly",s[s.Abstract=128]="Abstract",s[s.Async=256]="Async",s[s.Default=512]="Default",s[s.Const=2048]="Const",s[s.HasComputedJSDocModifiers=4096]="HasComputedJSDocModifiers",s[s.Deprecated=8192]="Deprecated",s[s.Override=16384]="Override",s[s.In=32768]="In",s[s.Out=65536]="Out",s[s.HasComputedFlags=536870912]="HasComputedFlags",s[s.AccessibilityModifier=28]="AccessibilityModifier",s[s.ParameterPropertyModifier=16476]="ParameterPropertyModifier",s[s.NonPublicAccessibilityModifier=24]="NonPublicAccessibilityModifier",s[s.TypeScriptModifier=116958]="TypeScriptModifier",s[s.ExportDefault=513]="ExportDefault",s[s.All=125951]="All",(o=e.JsxFlags||(e.JsxFlags={}))[o.None=0]="None",o[o.IntrinsicNamedElement=1]="IntrinsicNamedElement",o[o.IntrinsicIndexedElement=2]="IntrinsicIndexedElement",o[o.IntrinsicElement=3]="IntrinsicElement",(a=e.RelationComparisonResult||(e.RelationComparisonResult={}))[a.Succeeded=1]="Succeeded",a[a.Failed=2]="Failed",a[a.Reported=4]="Reported",a[a.ReportsUnmeasurable=8]="ReportsUnmeasurable",a[a.ReportsUnreliable=16]="ReportsUnreliable",a[a.ReportsMask=24]="ReportsMask",(i=e.GeneratedIdentifierFlags||(e.GeneratedIdentifierFlags={}))[i.None=0]="None",i[i.Auto=1]="Auto",i[i.Loop=2]="Loop",i[i.Unique=3]="Unique",i[i.Node=4]="Node",i[i.KindMask=7]="KindMask",i[i.ReservedInNestedScopes=8]="ReservedInNestedScopes",i[i.Optimistic=16]="Optimistic",i[i.FileLevel=32]="FileLevel",i[i.AllowNameSubstitution=64]="AllowNameSubstitution",(n=e.TokenFlags||(e.TokenFlags={}))[n.None=0]="None",n[n.PrecedingLineBreak=1]="PrecedingLineBreak",n[n.PrecedingJSDocComment=2]="PrecedingJSDocComment",n[n.Unterminated=4]="Unterminated",n[n.ExtendedUnicodeEscape=8]="ExtendedUnicodeEscape",n[n.Scientific=16]="Scientific",n[n.Octal=32]="Octal",n[n.HexSpecifier=64]="HexSpecifier",n[n.BinarySpecifier=128]="BinarySpecifier",n[n.OctalSpecifier=256]="OctalSpecifier",n[n.ContainsSeparator=512]="ContainsSeparator",n[n.UnicodeEscape=1024]="UnicodeEscape",n[n.ContainsInvalidEscape=2048]="ContainsInvalidEscape",n[n.BinaryOrOctalSpecifier=384]="BinaryOrOctalSpecifier",n[n.NumericLiteralFlags=1008]="NumericLiteralFlags",n[n.TemplateLiteralLikeFlags=2048]="TemplateLiteralLikeFlags",(r=e.FlowFlags||(e.FlowFlags={}))[r.Unreachable=1]="Unreachable",r[r.Start=2]="Start",r[r.BranchLabel=4]="BranchLabel",r[r.LoopLabel=8]="LoopLabel",r[r.Assignment=16]="Assignment",r[r.TrueCondition=32]="TrueCondition",r[r.FalseCondition=64]="FalseCondition",r[r.SwitchClause=128]="SwitchClause",r[r.ArrayMutation=256]="ArrayMutation",r[r.Call=512]="Call",r[r.ReduceLabel=1024]="ReduceLabel",r[r.Referenced=2048]="Referenced",r[r.Shared=4096]="Shared",r[r.Label=12]="Label",r[r.Condition=96]="Condition",(t=e.CommentDirectiveType||(e.CommentDirectiveType={}))[t.ExpectError=0]="ExpectError",t[t.Ignore=1]="Ignore";var u,_,d,p,f,g,m,y,v,h,b,x,D,S,T,C,k,E,N,F,A,P,w,I,O,M,L,R,B,j,J,z,K,U,V,q,W,H,G,Q,X,Y,Z,$,ee,te,re,ne,ie,ae,oe,se,ce,le,ue,_e,de,pe,fe;e.OperationCanceledException=function(){},(fe=e.FileIncludeKind||(e.FileIncludeKind={}))[fe.RootFile=0]="RootFile",fe[fe.SourceFromProjectReference=1]="SourceFromProjectReference",fe[fe.OutputFromProjectReference=2]="OutputFromProjectReference",fe[fe.Import=3]="Import",fe[fe.ReferenceFile=4]="ReferenceFile",fe[fe.TypeReferenceDirective=5]="TypeReferenceDirective",fe[fe.LibFile=6]="LibFile",fe[fe.LibReferenceDirective=7]="LibReferenceDirective",fe[fe.AutomaticTypeDirectiveFile=8]="AutomaticTypeDirectiveFile",(pe=e.FilePreprocessingDiagnosticsKind||(e.FilePreprocessingDiagnosticsKind={}))[pe.FilePreprocessingReferencedDiagnostic=0]="FilePreprocessingReferencedDiagnostic",pe[pe.FilePreprocessingFileExplainingDiagnostic=1]="FilePreprocessingFileExplainingDiagnostic",(de=e.StructureIsReused||(e.StructureIsReused={}))[de.Not=0]="Not",de[de.SafeModules=1]="SafeModules",de[de.Completely=2]="Completely",(_e=e.ExitStatus||(e.ExitStatus={}))[_e.Success=0]="Success",_e[_e.DiagnosticsPresent_OutputsSkipped=1]="DiagnosticsPresent_OutputsSkipped",_e[_e.DiagnosticsPresent_OutputsGenerated=2]="DiagnosticsPresent_OutputsGenerated",_e[_e.InvalidProject_OutputsSkipped=3]="InvalidProject_OutputsSkipped",_e[_e.ProjectReferenceCycle_OutputsSkipped=4]="ProjectReferenceCycle_OutputsSkipped",_e[_e.ProjectReferenceCycle_OutputsSkupped=4]="ProjectReferenceCycle_OutputsSkupped",(ue=e.MemberOverrideStatus||(e.MemberOverrideStatus={}))[ue.Ok=0]="Ok",ue[ue.NeedsOverride=1]="NeedsOverride",ue[ue.HasInvalidOverride=2]="HasInvalidOverride",(le=e.UnionReduction||(e.UnionReduction={}))[le.None=0]="None",le[le.Literal=1]="Literal",le[le.Subtype=2]="Subtype",(ce=e.ContextFlags||(e.ContextFlags={}))[ce.None=0]="None",ce[ce.Signature=1]="Signature",ce[ce.NoConstraints=2]="NoConstraints",ce[ce.Completions=4]="Completions",ce[ce.SkipBindingPatterns=8]="SkipBindingPatterns",(se=e.NodeBuilderFlags||(e.NodeBuilderFlags={}))[se.None=0]="None",se[se.NoTruncation=1]="NoTruncation",se[se.WriteArrayAsGenericType=2]="WriteArrayAsGenericType",se[se.GenerateNamesForShadowedTypeParams=4]="GenerateNamesForShadowedTypeParams",se[se.UseStructuralFallback=8]="UseStructuralFallback",se[se.ForbidIndexedAccessSymbolReferences=16]="ForbidIndexedAccessSymbolReferences",se[se.WriteTypeArgumentsOfSignature=32]="WriteTypeArgumentsOfSignature",se[se.UseFullyQualifiedType=64]="UseFullyQualifiedType",se[se.UseOnlyExternalAliasing=128]="UseOnlyExternalAliasing",se[se.SuppressAnyReturnType=256]="SuppressAnyReturnType",se[se.WriteTypeParametersInQualifiedName=512]="WriteTypeParametersInQualifiedName",se[se.MultilineObjectLiterals=1024]="MultilineObjectLiterals",se[se.WriteClassExpressionAsTypeLiteral=2048]="WriteClassExpressionAsTypeLiteral",se[se.UseTypeOfFunction=4096]="UseTypeOfFunction",se[se.OmitParameterModifiers=8192]="OmitParameterModifiers",se[se.UseAliasDefinedOutsideCurrentScope=16384]="UseAliasDefinedOutsideCurrentScope",se[se.UseSingleQuotesForStringLiteralType=268435456]="UseSingleQuotesForStringLiteralType",se[se.NoTypeReduction=536870912]="NoTypeReduction",se[se.AllowThisInObjectLiteral=32768]="AllowThisInObjectLiteral",se[se.AllowQualifiedNameInPlaceOfIdentifier=65536]="AllowQualifiedNameInPlaceOfIdentifier",se[se.AllowQualifedNameInPlaceOfIdentifier=65536]="AllowQualifedNameInPlaceOfIdentifier",se[se.AllowAnonymousIdentifier=131072]="AllowAnonymousIdentifier",se[se.AllowEmptyUnionOrIntersection=262144]="AllowEmptyUnionOrIntersection",se[se.AllowEmptyTuple=524288]="AllowEmptyTuple",se[se.AllowUniqueESSymbolType=1048576]="AllowUniqueESSymbolType",se[se.AllowEmptyIndexInfoType=2097152]="AllowEmptyIndexInfoType",se[se.AllowNodeModulesRelativePaths=67108864]="AllowNodeModulesRelativePaths",se[se.DoNotIncludeSymbolChain=134217728]="DoNotIncludeSymbolChain",se[se.IgnoreErrors=70221824]="IgnoreErrors",se[se.InObjectTypeLiteral=4194304]="InObjectTypeLiteral",se[se.InTypeAlias=8388608]="InTypeAlias",se[se.InInitialEntityName=16777216]="InInitialEntityName",(oe=e.TypeFormatFlags||(e.TypeFormatFlags={}))[oe.None=0]="None",oe[oe.NoTruncation=1]="NoTruncation",oe[oe.WriteArrayAsGenericType=2]="WriteArrayAsGenericType",oe[oe.UseStructuralFallback=8]="UseStructuralFallback",oe[oe.WriteTypeArgumentsOfSignature=32]="WriteTypeArgumentsOfSignature",oe[oe.UseFullyQualifiedType=64]="UseFullyQualifiedType",oe[oe.SuppressAnyReturnType=256]="SuppressAnyReturnType",oe[oe.MultilineObjectLiterals=1024]="MultilineObjectLiterals",oe[oe.WriteClassExpressionAsTypeLiteral=2048]="WriteClassExpressionAsTypeLiteral",oe[oe.UseTypeOfFunction=4096]="UseTypeOfFunction",oe[oe.OmitParameterModifiers=8192]="OmitParameterModifiers",oe[oe.UseAliasDefinedOutsideCurrentScope=16384]="UseAliasDefinedOutsideCurrentScope",oe[oe.UseSingleQuotesForStringLiteralType=268435456]="UseSingleQuotesForStringLiteralType",oe[oe.NoTypeReduction=536870912]="NoTypeReduction",oe[oe.AllowUniqueESSymbolType=1048576]="AllowUniqueESSymbolType",oe[oe.AddUndefined=131072]="AddUndefined",oe[oe.WriteArrowStyleSignature=262144]="WriteArrowStyleSignature",oe[oe.InArrayType=524288]="InArrayType",oe[oe.InElementType=2097152]="InElementType",oe[oe.InFirstTypeArgument=4194304]="InFirstTypeArgument",oe[oe.InTypeAlias=8388608]="InTypeAlias",oe[oe.WriteOwnNameForAnyLike=0]="WriteOwnNameForAnyLike",oe[oe.NodeBuilderFlagsMask=814775659]="NodeBuilderFlagsMask",(ae=e.SymbolFormatFlags||(e.SymbolFormatFlags={}))[ae.None=0]="None",ae[ae.WriteTypeParametersOrArguments=1]="WriteTypeParametersOrArguments",ae[ae.UseOnlyExternalAliasing=2]="UseOnlyExternalAliasing",ae[ae.AllowAnyNodeKind=4]="AllowAnyNodeKind",ae[ae.UseAliasDefinedOutsideCurrentScope=8]="UseAliasDefinedOutsideCurrentScope",ae[ae.DoNotIncludeSymbolChain=16]="DoNotIncludeSymbolChain",(ie=e.SymbolAccessibility||(e.SymbolAccessibility={}))[ie.Accessible=0]="Accessible",ie[ie.NotAccessible=1]="NotAccessible",ie[ie.CannotBeNamed=2]="CannotBeNamed",(ne=e.SyntheticSymbolKind||(e.SyntheticSymbolKind={}))[ne.UnionOrIntersection=0]="UnionOrIntersection",ne[ne.Spread=1]="Spread",(re=e.TypePredicateKind||(e.TypePredicateKind={}))[re.This=0]="This",re[re.Identifier=1]="Identifier",re[re.AssertsThis=2]="AssertsThis",re[re.AssertsIdentifier=3]="AssertsIdentifier",(te=e.TypeReferenceSerializationKind||(e.TypeReferenceSerializationKind={}))[te.Unknown=0]="Unknown",te[te.TypeWithConstructSignatureAndValue=1]="TypeWithConstructSignatureAndValue",te[te.VoidNullableOrNeverType=2]="VoidNullableOrNeverType",te[te.NumberLikeType=3]="NumberLikeType",te[te.BigIntLikeType=4]="BigIntLikeType",te[te.StringLikeType=5]="StringLikeType",te[te.BooleanType=6]="BooleanType",te[te.ArrayLikeType=7]="ArrayLikeType",te[te.ESSymbolType=8]="ESSymbolType",te[te.Promise=9]="Promise",te[te.TypeWithCallSignature=10]="TypeWithCallSignature",te[te.ObjectType=11]="ObjectType",(ee=e.SymbolFlags||(e.SymbolFlags={}))[ee.None=0]="None",ee[ee.FunctionScopedVariable=1]="FunctionScopedVariable",ee[ee.BlockScopedVariable=2]="BlockScopedVariable",ee[ee.Property=4]="Property",ee[ee.EnumMember=8]="EnumMember",ee[ee.Function=16]="Function",ee[ee.Class=32]="Class",ee[ee.Interface=64]="Interface",ee[ee.ConstEnum=128]="ConstEnum",ee[ee.RegularEnum=256]="RegularEnum",ee[ee.ValueModule=512]="ValueModule",ee[ee.NamespaceModule=1024]="NamespaceModule",ee[ee.TypeLiteral=2048]="TypeLiteral",ee[ee.ObjectLiteral=4096]="ObjectLiteral",ee[ee.Method=8192]="Method",ee[ee.Constructor=16384]="Constructor",ee[ee.GetAccessor=32768]="GetAccessor",ee[ee.SetAccessor=65536]="SetAccessor",ee[ee.Signature=131072]="Signature",ee[ee.TypeParameter=262144]="TypeParameter",ee[ee.TypeAlias=524288]="TypeAlias",ee[ee.ExportValue=1048576]="ExportValue",ee[ee.Alias=2097152]="Alias",ee[ee.Prototype=4194304]="Prototype",ee[ee.ExportStar=8388608]="ExportStar",ee[ee.Optional=16777216]="Optional",ee[ee.Transient=33554432]="Transient",ee[ee.Assignment=67108864]="Assignment",ee[ee.ModuleExports=134217728]="ModuleExports",ee[ee.All=67108863]="All",ee[ee.Enum=384]="Enum",ee[ee.Variable=3]="Variable",ee[ee.Value=111551]="Value",ee[ee.Type=788968]="Type",ee[ee.Namespace=1920]="Namespace",ee[ee.Module=1536]="Module",ee[ee.Accessor=98304]="Accessor",ee[ee.FunctionScopedVariableExcludes=111550]="FunctionScopedVariableExcludes",ee[ee.BlockScopedVariableExcludes=111551]="BlockScopedVariableExcludes",ee[ee.ParameterExcludes=111551]="ParameterExcludes",ee[ee.PropertyExcludes=0]="PropertyExcludes",ee[ee.EnumMemberExcludes=900095]="EnumMemberExcludes",ee[ee.FunctionExcludes=110991]="FunctionExcludes",ee[ee.ClassExcludes=899503]="ClassExcludes",ee[ee.InterfaceExcludes=788872]="InterfaceExcludes",ee[ee.RegularEnumExcludes=899327]="RegularEnumExcludes",ee[ee.ConstEnumExcludes=899967]="ConstEnumExcludes",ee[ee.ValueModuleExcludes=110735]="ValueModuleExcludes",ee[ee.NamespaceModuleExcludes=0]="NamespaceModuleExcludes",ee[ee.MethodExcludes=103359]="MethodExcludes",ee[ee.GetAccessorExcludes=46015]="GetAccessorExcludes",ee[ee.SetAccessorExcludes=78783]="SetAccessorExcludes",ee[ee.TypeParameterExcludes=526824]="TypeParameterExcludes",ee[ee.TypeAliasExcludes=788968]="TypeAliasExcludes",ee[ee.AliasExcludes=2097152]="AliasExcludes",ee[ee.ModuleMember=2623475]="ModuleMember",ee[ee.ExportHasLocal=944]="ExportHasLocal",ee[ee.BlockScoped=418]="BlockScoped",ee[ee.PropertyOrAccessor=98308]="PropertyOrAccessor",ee[ee.ClassMember=106500]="ClassMember",ee[ee.ExportSupportsDefaultModifier=112]="ExportSupportsDefaultModifier",ee[ee.ExportDoesNotSupportDefaultModifier=-113]="ExportDoesNotSupportDefaultModifier",ee[ee.Classifiable=2885600]="Classifiable",ee[ee.LateBindingContainer=6256]="LateBindingContainer",($=e.EnumKind||(e.EnumKind={}))[$.Numeric=0]="Numeric",$[$.Literal=1]="Literal",(Z=e.CheckFlags||(e.CheckFlags={}))[Z.Instantiated=1]="Instantiated",Z[Z.SyntheticProperty=2]="SyntheticProperty",Z[Z.SyntheticMethod=4]="SyntheticMethod",Z[Z.Readonly=8]="Readonly",Z[Z.ReadPartial=16]="ReadPartial",Z[Z.WritePartial=32]="WritePartial",Z[Z.HasNonUniformType=64]="HasNonUniformType",Z[Z.HasLiteralType=128]="HasLiteralType",Z[Z.ContainsPublic=256]="ContainsPublic",Z[Z.ContainsProtected=512]="ContainsProtected",Z[Z.ContainsPrivate=1024]="ContainsPrivate",Z[Z.ContainsStatic=2048]="ContainsStatic",Z[Z.Late=4096]="Late",Z[Z.ReverseMapped=8192]="ReverseMapped",Z[Z.OptionalParameter=16384]="OptionalParameter",Z[Z.RestParameter=32768]="RestParameter",Z[Z.DeferredType=65536]="DeferredType",Z[Z.HasNeverType=131072]="HasNeverType",Z[Z.Mapped=262144]="Mapped",Z[Z.StripOptional=524288]="StripOptional",Z[Z.Unresolved=1048576]="Unresolved",Z[Z.Synthetic=6]="Synthetic",Z[Z.Discriminant=192]="Discriminant",Z[Z.Partial=48]="Partial",(Y=e.InternalSymbolName||(e.InternalSymbolName={})).Call="__call",Y.Constructor="__constructor",Y.New="__new",Y.Index="__index",Y.ExportStar="__export",Y.Global="__global",Y.Missing="__missing",Y.Type="__type",Y.Object="__object",Y.JSXAttributes="__jsxAttributes",Y.Class="__class",Y.Function="__function",Y.Computed="__computed",Y.Resolving="__resolving__",Y.ExportEquals="export=",Y.Default="default",Y.This="this",(X=e.NodeCheckFlags||(e.NodeCheckFlags={}))[X.TypeChecked=1]="TypeChecked",X[X.LexicalThis=2]="LexicalThis",X[X.CaptureThis=4]="CaptureThis",X[X.CaptureNewTarget=8]="CaptureNewTarget",X[X.SuperInstance=256]="SuperInstance",X[X.SuperStatic=512]="SuperStatic",X[X.ContextChecked=1024]="ContextChecked",X[X.AsyncMethodWithSuper=2048]="AsyncMethodWithSuper",X[X.AsyncMethodWithSuperBinding=4096]="AsyncMethodWithSuperBinding",X[X.CaptureArguments=8192]="CaptureArguments",X[X.EnumValuesComputed=16384]="EnumValuesComputed",X[X.LexicalModuleMergesWithClass=32768]="LexicalModuleMergesWithClass",X[X.LoopWithCapturedBlockScopedBinding=65536]="LoopWithCapturedBlockScopedBinding",X[X.ContainsCapturedBlockScopeBinding=131072]="ContainsCapturedBlockScopeBinding",X[X.CapturedBlockScopedBinding=262144]="CapturedBlockScopedBinding",X[X.BlockScopedBindingInLoop=524288]="BlockScopedBindingInLoop",X[X.ClassWithBodyScopedClassBinding=1048576]="ClassWithBodyScopedClassBinding",X[X.BodyScopedClassBinding=2097152]="BodyScopedClassBinding",X[X.NeedsLoopOutParameter=4194304]="NeedsLoopOutParameter",X[X.AssignmentsMarked=8388608]="AssignmentsMarked",X[X.ClassWithConstructorReference=16777216]="ClassWithConstructorReference",X[X.ConstructorReferenceInClass=33554432]="ConstructorReferenceInClass",X[X.ContainsClassWithPrivateIdentifiers=67108864]="ContainsClassWithPrivateIdentifiers",X[X.ContainsSuperPropertyInStaticInitializer=134217728]="ContainsSuperPropertyInStaticInitializer",X[X.InCheckIdentifier=268435456]="InCheckIdentifier",(Q=e.TypeFlags||(e.TypeFlags={}))[Q.Any=1]="Any",Q[Q.Unknown=2]="Unknown",Q[Q.String=4]="String",Q[Q.Number=8]="Number",Q[Q.Boolean=16]="Boolean",Q[Q.Enum=32]="Enum",Q[Q.BigInt=64]="BigInt",Q[Q.StringLiteral=128]="StringLiteral",Q[Q.NumberLiteral=256]="NumberLiteral",Q[Q.BooleanLiteral=512]="BooleanLiteral",Q[Q.EnumLiteral=1024]="EnumLiteral",Q[Q.BigIntLiteral=2048]="BigIntLiteral",Q[Q.ESSymbol=4096]="ESSymbol",Q[Q.UniqueESSymbol=8192]="UniqueESSymbol",Q[Q.Void=16384]="Void",Q[Q.Undefined=32768]="Undefined",Q[Q.Null=65536]="Null",Q[Q.Never=131072]="Never",Q[Q.TypeParameter=262144]="TypeParameter",Q[Q.Object=524288]="Object",Q[Q.Union=1048576]="Union",Q[Q.Intersection=2097152]="Intersection",Q[Q.Index=4194304]="Index",Q[Q.IndexedAccess=8388608]="IndexedAccess",Q[Q.Conditional=16777216]="Conditional",Q[Q.Substitution=33554432]="Substitution",Q[Q.NonPrimitive=67108864]="NonPrimitive",Q[Q.TemplateLiteral=134217728]="TemplateLiteral",Q[Q.StringMapping=268435456]="StringMapping",Q[Q.AnyOrUnknown=3]="AnyOrUnknown",Q[Q.Nullable=98304]="Nullable",Q[Q.Literal=2944]="Literal",Q[Q.Unit=109440]="Unit",Q[Q.StringOrNumberLiteral=384]="StringOrNumberLiteral",Q[Q.StringOrNumberLiteralOrUnique=8576]="StringOrNumberLiteralOrUnique",Q[Q.DefinitelyFalsy=117632]="DefinitelyFalsy",Q[Q.PossiblyFalsy=117724]="PossiblyFalsy",Q[Q.Intrinsic=67359327]="Intrinsic",Q[Q.Primitive=131068]="Primitive",Q[Q.StringLike=402653316]="StringLike",Q[Q.NumberLike=296]="NumberLike",Q[Q.BigIntLike=2112]="BigIntLike",Q[Q.BooleanLike=528]="BooleanLike",Q[Q.EnumLike=1056]="EnumLike",Q[Q.ESSymbolLike=12288]="ESSymbolLike",Q[Q.VoidLike=49152]="VoidLike",Q[Q.DefinitelyNonNullable=470302716]="DefinitelyNonNullable",Q[Q.DisjointDomains=469892092]="DisjointDomains",Q[Q.UnionOrIntersection=3145728]="UnionOrIntersection",Q[Q.StructuredType=3670016]="StructuredType",Q[Q.TypeVariable=8650752]="TypeVariable",Q[Q.InstantiableNonPrimitive=58982400]="InstantiableNonPrimitive",Q[Q.InstantiablePrimitive=406847488]="InstantiablePrimitive",Q[Q.Instantiable=465829888]="Instantiable",Q[Q.StructuredOrInstantiable=469499904]="StructuredOrInstantiable",Q[Q.ObjectFlagsType=3899393]="ObjectFlagsType",Q[Q.Simplifiable=25165824]="Simplifiable",Q[Q.Singleton=67358815]="Singleton",Q[Q.Narrowable=536624127]="Narrowable",Q[Q.IncludesMask=205258751]="IncludesMask",Q[Q.IncludesMissingType=262144]="IncludesMissingType",Q[Q.IncludesNonWideningType=4194304]="IncludesNonWideningType",Q[Q.IncludesWildcard=8388608]="IncludesWildcard",Q[Q.IncludesEmptyObject=16777216]="IncludesEmptyObject",Q[Q.IncludesInstantiable=33554432]="IncludesInstantiable",Q[Q.NotPrimitiveUnion=36323363]="NotPrimitiveUnion",(G=e.ObjectFlags||(e.ObjectFlags={}))[G.Class=1]="Class",G[G.Interface=2]="Interface",G[G.Reference=4]="Reference",G[G.Tuple=8]="Tuple",G[G.Anonymous=16]="Anonymous",G[G.Mapped=32]="Mapped",G[G.Instantiated=64]="Instantiated",G[G.ObjectLiteral=128]="ObjectLiteral",G[G.EvolvingArray=256]="EvolvingArray",G[G.ObjectLiteralPatternWithComputedProperties=512]="ObjectLiteralPatternWithComputedProperties",G[G.ReverseMapped=1024]="ReverseMapped",G[G.JsxAttributes=2048]="JsxAttributes",G[G.JSLiteral=4096]="JSLiteral",G[G.FreshLiteral=8192]="FreshLiteral",G[G.ArrayLiteral=16384]="ArrayLiteral",G[G.PrimitiveUnion=32768]="PrimitiveUnion",G[G.ContainsWideningType=65536]="ContainsWideningType",G[G.ContainsObjectOrArrayLiteral=131072]="ContainsObjectOrArrayLiteral",G[G.NonInferrableType=262144]="NonInferrableType",G[G.CouldContainTypeVariablesComputed=524288]="CouldContainTypeVariablesComputed",G[G.CouldContainTypeVariables=1048576]="CouldContainTypeVariables",G[G.ClassOrInterface=3]="ClassOrInterface",G[G.RequiresWidening=196608]="RequiresWidening",G[G.PropagatingFlags=458752]="PropagatingFlags",G[G.ObjectTypeKindMask=1343]="ObjectTypeKindMask",G[G.ContainsSpread=2097152]="ContainsSpread",G[G.ObjectRestType=4194304]="ObjectRestType",G[G.InstantiationExpressionType=8388608]="InstantiationExpressionType",G[G.IsClassInstanceClone=16777216]="IsClassInstanceClone",G[G.IdenticalBaseTypeCalculated=33554432]="IdenticalBaseTypeCalculated",G[G.IdenticalBaseTypeExists=67108864]="IdenticalBaseTypeExists",G[G.IsGenericTypeComputed=2097152]="IsGenericTypeComputed",G[G.IsGenericObjectType=4194304]="IsGenericObjectType",G[G.IsGenericIndexType=8388608]="IsGenericIndexType",G[G.IsGenericType=12582912]="IsGenericType",G[G.ContainsIntersections=16777216]="ContainsIntersections",G[G.IsNeverIntersectionComputed=16777216]="IsNeverIntersectionComputed",G[G.IsNeverIntersection=33554432]="IsNeverIntersection",(H=e.VarianceFlags||(e.VarianceFlags={}))[H.Invariant=0]="Invariant",H[H.Covariant=1]="Covariant",H[H.Contravariant=2]="Contravariant",H[H.Bivariant=3]="Bivariant",H[H.Independent=4]="Independent",H[H.VarianceMask=7]="VarianceMask",H[H.Unmeasurable=8]="Unmeasurable",H[H.Unreliable=16]="Unreliable",H[H.AllowsStructuralFallback=24]="AllowsStructuralFallback",(W=e.ElementFlags||(e.ElementFlags={}))[W.Required=1]="Required",W[W.Optional=2]="Optional",W[W.Rest=4]="Rest",W[W.Variadic=8]="Variadic",W[W.Fixed=3]="Fixed",W[W.Variable=12]="Variable",W[W.NonRequired=14]="NonRequired",W[W.NonRest=11]="NonRest",(q=e.AccessFlags||(e.AccessFlags={}))[q.None=0]="None",q[q.IncludeUndefined=1]="IncludeUndefined",q[q.NoIndexSignatures=2]="NoIndexSignatures",q[q.Writing=4]="Writing",q[q.CacheSymbol=8]="CacheSymbol",q[q.NoTupleBoundsCheck=16]="NoTupleBoundsCheck",q[q.ExpressionPosition=32]="ExpressionPosition",q[q.ReportDeprecated=64]="ReportDeprecated",q[q.SuppressNoImplicitAnyError=128]="SuppressNoImplicitAnyError",q[q.Contextual=256]="Contextual",q[q.Persistent=1]="Persistent",(V=e.JsxReferenceKind||(e.JsxReferenceKind={}))[V.Component=0]="Component",V[V.Function=1]="Function",V[V.Mixed=2]="Mixed",(U=e.SignatureKind||(e.SignatureKind={}))[U.Call=0]="Call",U[U.Construct=1]="Construct",(K=e.SignatureFlags||(e.SignatureFlags={}))[K.None=0]="None",K[K.HasRestParameter=1]="HasRestParameter",K[K.HasLiteralTypes=2]="HasLiteralTypes",K[K.Abstract=4]="Abstract",K[K.IsInnerCallChain=8]="IsInnerCallChain",K[K.IsOuterCallChain=16]="IsOuterCallChain",K[K.IsUntypedSignatureInJSFile=32]="IsUntypedSignatureInJSFile",K[K.PropagatingFlags=39]="PropagatingFlags",K[K.CallChainFlags=24]="CallChainFlags",(z=e.IndexKind||(e.IndexKind={}))[z.String=0]="String",z[z.Number=1]="Number",(J=e.TypeMapKind||(e.TypeMapKind={}))[J.Simple=0]="Simple",J[J.Array=1]="Array",J[J.Function=2]="Function",J[J.Composite=3]="Composite",J[J.Merged=4]="Merged",(j=e.InferencePriority||(e.InferencePriority={}))[j.NakedTypeVariable=1]="NakedTypeVariable",j[j.SpeculativeTuple=2]="SpeculativeTuple",j[j.SubstituteSource=4]="SubstituteSource",j[j.HomomorphicMappedType=8]="HomomorphicMappedType",j[j.PartialHomomorphicMappedType=16]="PartialHomomorphicMappedType",j[j.MappedTypeConstraint=32]="MappedTypeConstraint",j[j.ContravariantConditional=64]="ContravariantConditional",j[j.ReturnType=128]="ReturnType",j[j.LiteralKeyof=256]="LiteralKeyof",j[j.NoConstraints=512]="NoConstraints",j[j.AlwaysStrict=1024]="AlwaysStrict",j[j.MaxValue=2048]="MaxValue",j[j.PriorityImpliesCombination=416]="PriorityImpliesCombination",j[j.Circularity=-1]="Circularity",(B=e.InferenceFlags||(e.InferenceFlags={}))[B.None=0]="None",B[B.NoDefault=1]="NoDefault",B[B.AnyDefault=2]="AnyDefault",B[B.SkippedGenericFunction=4]="SkippedGenericFunction",(R=e.Ternary||(e.Ternary={}))[R.False=0]="False",R[R.Unknown=1]="Unknown",R[R.Maybe=3]="Maybe",R[R.True=-1]="True",(L=e.AssignmentDeclarationKind||(e.AssignmentDeclarationKind={}))[L.None=0]="None",L[L.ExportsProperty=1]="ExportsProperty",L[L.ModuleExports=2]="ModuleExports",L[L.PrototypeProperty=3]="PrototypeProperty",L[L.ThisProperty=4]="ThisProperty",L[L.Property=5]="Property",L[L.Prototype=6]="Prototype",L[L.ObjectDefinePropertyValue=7]="ObjectDefinePropertyValue",L[L.ObjectDefinePropertyExports=8]="ObjectDefinePropertyExports",L[L.ObjectDefinePrototypeProperty=9]="ObjectDefinePrototypeProperty",function(e){e[e.Warning=0]="Warning",e[e.Error=1]="Error",e[e.Suggestion=2]="Suggestion",e[e.Message=3]="Message";}(u=e.DiagnosticCategory||(e.DiagnosticCategory={})),e.diagnosticCategoryName=function(e,t){void 0===t&&(t=!0);var r=u[e.category];return t?r.toLowerCase():r},(M=e.ModuleResolutionKind||(e.ModuleResolutionKind={}))[M.Classic=1]="Classic",M[M.NodeJs=2]="NodeJs",M[M.Node16=3]="Node16",M[M.NodeNext=99]="NodeNext",(O=e.ModuleDetectionKind||(e.ModuleDetectionKind={}))[O.Legacy=1]="Legacy",O[O.Auto=2]="Auto",O[O.Force=3]="Force",(I=e.WatchFileKind||(e.WatchFileKind={}))[I.FixedPollingInterval=0]="FixedPollingInterval",I[I.PriorityPollingInterval=1]="PriorityPollingInterval",I[I.DynamicPriorityPolling=2]="DynamicPriorityPolling",I[I.FixedChunkSizePolling=3]="FixedChunkSizePolling",I[I.UseFsEvents=4]="UseFsEvents",I[I.UseFsEventsOnParentDirectory=5]="UseFsEventsOnParentDirectory",(w=e.WatchDirectoryKind||(e.WatchDirectoryKind={}))[w.UseFsEvents=0]="UseFsEvents",w[w.FixedPollingInterval=1]="FixedPollingInterval",w[w.DynamicPriorityPolling=2]="DynamicPriorityPolling",w[w.FixedChunkSizePolling=3]="FixedChunkSizePolling",(P=e.PollingWatchKind||(e.PollingWatchKind={}))[P.FixedInterval=0]="FixedInterval",P[P.PriorityInterval=1]="PriorityInterval",P[P.DynamicPriority=2]="DynamicPriority",P[P.FixedChunkSize=3]="FixedChunkSize",(A=e.ModuleKind||(e.ModuleKind={}))[A.None=0]="None",A[A.CommonJS=1]="CommonJS",A[A.AMD=2]="AMD",A[A.UMD=3]="UMD",A[A.System=4]="System",A[A.ES2015=5]="ES2015",A[A.ES2020=6]="ES2020",A[A.ES2022=7]="ES2022",A[A.ESNext=99]="ESNext",A[A.Node16=100]="Node16",A[A.NodeNext=199]="NodeNext",(F=e.JsxEmit||(e.JsxEmit={}))[F.None=0]="None",F[F.Preserve=1]="Preserve",F[F.React=2]="React",F[F.ReactNative=3]="ReactNative",F[F.ReactJSX=4]="ReactJSX",F[F.ReactJSXDev=5]="ReactJSXDev",(N=e.ImportsNotUsedAsValues||(e.ImportsNotUsedAsValues={}))[N.Remove=0]="Remove",N[N.Preserve=1]="Preserve",N[N.Error=2]="Error",(E=e.NewLineKind||(e.NewLineKind={}))[E.CarriageReturnLineFeed=0]="CarriageReturnLineFeed",E[E.LineFeed=1]="LineFeed",(k=e.ScriptKind||(e.ScriptKind={}))[k.Unknown=0]="Unknown",k[k.JS=1]="JS",k[k.JSX=2]="JSX",k[k.TS=3]="TS",k[k.TSX=4]="TSX",k[k.External=5]="External",k[k.JSON=6]="JSON",k[k.Deferred=7]="Deferred",(C=e.ScriptTarget||(e.ScriptTarget={}))[C.ES3=0]="ES3",C[C.ES5=1]="ES5",C[C.ES2015=2]="ES2015",C[C.ES2016=3]="ES2016",C[C.ES2017=4]="ES2017",C[C.ES2018=5]="ES2018",C[C.ES2019=6]="ES2019",C[C.ES2020=7]="ES2020",C[C.ES2021=8]="ES2021",C[C.ES2022=9]="ES2022",C[C.ESNext=99]="ESNext",C[C.JSON=100]="JSON",C[C.Latest=99]="Latest",(T=e.LanguageVariant||(e.LanguageVariant={}))[T.Standard=0]="Standard",T[T.JSX=1]="JSX",(S=e.WatchDirectoryFlags||(e.WatchDirectoryFlags={}))[S.None=0]="None",S[S.Recursive=1]="Recursive",(D=e.CharacterCodes||(e.CharacterCodes={}))[D.nullCharacter=0]="nullCharacter",D[D.maxAsciiCharacter=127]="maxAsciiCharacter",D[D.lineFeed=10]="lineFeed",D[D.carriageReturn=13]="carriageReturn",D[D.lineSeparator=8232]="lineSeparator",D[D.paragraphSeparator=8233]="paragraphSeparator",D[D.nextLine=133]="nextLine",D[D.space=32]="space",D[D.nonBreakingSpace=160]="nonBreakingSpace",D[D.enQuad=8192]="enQuad",D[D.emQuad=8193]="emQuad",D[D.enSpace=8194]="enSpace",D[D.emSpace=8195]="emSpace",D[D.threePerEmSpace=8196]="threePerEmSpace",D[D.fourPerEmSpace=8197]="fourPerEmSpace",D[D.sixPerEmSpace=8198]="sixPerEmSpace",D[D.figureSpace=8199]="figureSpace",D[D.punctuationSpace=8200]="punctuationSpace",D[D.thinSpace=8201]="thinSpace",D[D.hairSpace=8202]="hairSpace",D[D.zeroWidthSpace=8203]="zeroWidthSpace",D[D.narrowNoBreakSpace=8239]="narrowNoBreakSpace",D[D.ideographicSpace=12288]="ideographicSpace",D[D.mathematicalSpace=8287]="mathematicalSpace",D[D.ogham=5760]="ogham",D[D._=95]="_",D[D.$=36]="$",D[D._0=48]="_0",D[D._1=49]="_1",D[D._2=50]="_2",D[D._3=51]="_3",D[D._4=52]="_4",D[D._5=53]="_5",D[D._6=54]="_6",D[D._7=55]="_7",D[D._8=56]="_8",D[D._9=57]="_9",D[D.a=97]="a",D[D.b=98]="b",D[D.c=99]="c",D[D.d=100]="d",D[D.e=101]="e",D[D.f=102]="f",D[D.g=103]="g",D[D.h=104]="h",D[D.i=105]="i",D[D.j=106]="j",D[D.k=107]="k",D[D.l=108]="l",D[D.m=109]="m",D[D.n=110]="n",D[D.o=111]="o",D[D.p=112]="p",D[D.q=113]="q",D[D.r=114]="r",D[D.s=115]="s",D[D.t=116]="t",D[D.u=117]="u",D[D.v=118]="v",D[D.w=119]="w",D[D.x=120]="x",D[D.y=121]="y",D[D.z=122]="z",D[D.A=65]="A",D[D.B=66]="B",D[D.C=67]="C",D[D.D=68]="D",D[D.E=69]="E",D[D.F=70]="F",D[D.G=71]="G",D[D.H=72]="H",D[D.I=73]="I",D[D.J=74]="J",D[D.K=75]="K",D[D.L=76]="L",D[D.M=77]="M",D[D.N=78]="N",D[D.O=79]="O",D[D.P=80]="P",D[D.Q=81]="Q",D[D.R=82]="R",D[D.S=83]="S",D[D.T=84]="T",D[D.U=85]="U",D[D.V=86]="V",D[D.W=87]="W",D[D.X=88]="X",D[D.Y=89]="Y",D[D.Z=90]="Z",D[D.ampersand=38]="ampersand",D[D.asterisk=42]="asterisk",D[D.at=64]="at",D[D.backslash=92]="backslash",D[D.backtick=96]="backtick",D[D.bar=124]="bar",D[D.caret=94]="caret",D[D.closeBrace=125]="closeBrace",D[D.closeBracket=93]="closeBracket",D[D.closeParen=41]="closeParen",D[D.colon=58]="colon",D[D.comma=44]="comma",D[D.dot=46]="dot",D[D.doubleQuote=34]="doubleQuote",D[D.equals=61]="equals",D[D.exclamation=33]="exclamation",D[D.greaterThan=62]="greaterThan",D[D.hash=35]="hash",D[D.lessThan=60]="lessThan",D[D.minus=45]="minus",D[D.openBrace=123]="openBrace",D[D.openBracket=91]="openBracket",D[D.openParen=40]="openParen",D[D.percent=37]="percent",D[D.plus=43]="plus",D[D.question=63]="question",D[D.semicolon=59]="semicolon",D[D.singleQuote=39]="singleQuote",D[D.slash=47]="slash",D[D.tilde=126]="tilde",D[D.backspace=8]="backspace",D[D.formFeed=12]="formFeed",D[D.byteOrderMark=65279]="byteOrderMark",D[D.tab=9]="tab",D[D.verticalTab=11]="verticalTab",(x=e.Extension||(e.Extension={})).Ts=".ts",x.Tsx=".tsx",x.Dts=".d.ts",x.Js=".js",x.Jsx=".jsx",x.Json=".json",x.TsBuildInfo=".tsbuildinfo",x.Mjs=".mjs",x.Mts=".mts",x.Dmts=".d.mts",x.Cjs=".cjs",x.Cts=".cts",x.Dcts=".d.cts",(b=e.TransformFlags||(e.TransformFlags={}))[b.None=0]="None",b[b.ContainsTypeScript=1]="ContainsTypeScript",b[b.ContainsJsx=2]="ContainsJsx",b[b.ContainsESNext=4]="ContainsESNext",b[b.ContainsES2022=8]="ContainsES2022",b[b.ContainsES2021=16]="ContainsES2021",b[b.ContainsES2020=32]="ContainsES2020",b[b.ContainsES2019=64]="ContainsES2019",b[b.ContainsES2018=128]="ContainsES2018",b[b.ContainsES2017=256]="ContainsES2017",b[b.ContainsES2016=512]="ContainsES2016",b[b.ContainsES2015=1024]="ContainsES2015",b[b.ContainsGenerator=2048]="ContainsGenerator",b[b.ContainsDestructuringAssignment=4096]="ContainsDestructuringAssignment",b[b.ContainsTypeScriptClassSyntax=4096]="ContainsTypeScriptClassSyntax",b[b.ContainsLexicalThis=8192]="ContainsLexicalThis",b[b.ContainsRestOrSpread=16384]="ContainsRestOrSpread",b[b.ContainsObjectRestOrSpread=32768]="ContainsObjectRestOrSpread",b[b.ContainsComputedPropertyName=65536]="ContainsComputedPropertyName",b[b.ContainsBlockScopedBinding=131072]="ContainsBlockScopedBinding",b[b.ContainsBindingPattern=262144]="ContainsBindingPattern",b[b.ContainsYield=524288]="ContainsYield",b[b.ContainsAwait=1048576]="ContainsAwait",b[b.ContainsHoistedDeclarationOrCompletion=2097152]="ContainsHoistedDeclarationOrCompletion",b[b.ContainsDynamicImport=4194304]="ContainsDynamicImport",b[b.ContainsClassFields=8388608]="ContainsClassFields",b[b.ContainsPossibleTopLevelAwait=16777216]="ContainsPossibleTopLevelAwait",b[b.ContainsLexicalSuper=33554432]="ContainsLexicalSuper",b[b.ContainsUpdateExpressionForIdentifier=67108864]="ContainsUpdateExpressionForIdentifier",b[b.HasComputedFlags=536870912]="HasComputedFlags",b[b.AssertTypeScript=1]="AssertTypeScript",b[b.AssertJsx=2]="AssertJsx",b[b.AssertESNext=4]="AssertESNext",b[b.AssertES2022=8]="AssertES2022",b[b.AssertES2021=16]="AssertES2021",b[b.AssertES2020=32]="AssertES2020",b[b.AssertES2019=64]="AssertES2019",b[b.AssertES2018=128]="AssertES2018",b[b.AssertES2017=256]="AssertES2017",b[b.AssertES2016=512]="AssertES2016",b[b.AssertES2015=1024]="AssertES2015",b[b.AssertGenerator=2048]="AssertGenerator",b[b.AssertDestructuringAssignment=4096]="AssertDestructuringAssignment",b[b.OuterExpressionExcludes=536870912]="OuterExpressionExcludes",b[b.PropertyAccessExcludes=536870912]="PropertyAccessExcludes",b[b.NodeExcludes=536870912]="NodeExcludes",b[b.ArrowFunctionExcludes=557748224]="ArrowFunctionExcludes",b[b.FunctionExcludes=591310848]="FunctionExcludes",b[b.ConstructorExcludes=591306752]="ConstructorExcludes",b[b.MethodOrAccessorExcludes=574529536]="MethodOrAccessorExcludes",b[b.PropertyExcludes=570433536]="PropertyExcludes",b[b.ClassExcludes=536940544]="ClassExcludes",b[b.ModuleExcludes=589443072]="ModuleExcludes",b[b.TypeExcludes=-2]="TypeExcludes",b[b.ObjectLiteralExcludes=536973312]="ObjectLiteralExcludes",b[b.ArrayLiteralOrCallOrNewExcludes=536887296]="ArrayLiteralOrCallOrNewExcludes",b[b.VariableDeclarationListExcludes=537165824]="VariableDeclarationListExcludes",b[b.ParameterExcludes=536870912]="ParameterExcludes",b[b.CatchClauseExcludes=536903680]="CatchClauseExcludes",b[b.BindingPatternExcludes=536887296]="BindingPatternExcludes",b[b.ContainsLexicalThisOrSuper=33562624]="ContainsLexicalThisOrSuper",b[b.PropertyNamePropagatingFlags=33562624]="PropertyNamePropagatingFlags",(h=e.SnippetKind||(e.SnippetKind={}))[h.TabStop=0]="TabStop",h[h.Placeholder=1]="Placeholder",h[h.Choice=2]="Choice",h[h.Variable=3]="Variable",(v=e.EmitFlags||(e.EmitFlags={}))[v.None=0]="None",v[v.SingleLine=1]="SingleLine",v[v.AdviseOnEmitNode=2]="AdviseOnEmitNode",v[v.NoSubstitution=4]="NoSubstitution",v[v.CapturesThis=8]="CapturesThis",v[v.NoLeadingSourceMap=16]="NoLeadingSourceMap",v[v.NoTrailingSourceMap=32]="NoTrailingSourceMap",v[v.NoSourceMap=48]="NoSourceMap",v[v.NoNestedSourceMaps=64]="NoNestedSourceMaps",v[v.NoTokenLeadingSourceMaps=128]="NoTokenLeadingSourceMaps",v[v.NoTokenTrailingSourceMaps=256]="NoTokenTrailingSourceMaps",v[v.NoTokenSourceMaps=384]="NoTokenSourceMaps",v[v.NoLeadingComments=512]="NoLeadingComments",v[v.NoTrailingComments=1024]="NoTrailingComments",v[v.NoComments=1536]="NoComments",v[v.NoNestedComments=2048]="NoNestedComments",v[v.HelperName=4096]="HelperName",v[v.ExportName=8192]="ExportName",v[v.LocalName=16384]="LocalName",v[v.InternalName=32768]="InternalName",v[v.Indented=65536]="Indented",v[v.NoIndentation=131072]="NoIndentation",v[v.AsyncFunctionBody=262144]="AsyncFunctionBody",v[v.ReuseTempVariableScope=524288]="ReuseTempVariableScope",v[v.CustomPrologue=1048576]="CustomPrologue",v[v.NoHoisting=2097152]="NoHoisting",v[v.HasEndOfDeclarationMarker=4194304]="HasEndOfDeclarationMarker",v[v.Iterator=8388608]="Iterator",v[v.NoAsciiEscaping=16777216]="NoAsciiEscaping",v[v.TypeScriptClassWrapper=33554432]="TypeScriptClassWrapper",v[v.NeverApplyImportHelper=67108864]="NeverApplyImportHelper",v[v.IgnoreSourceNewlines=134217728]="IgnoreSourceNewlines",v[v.Immutable=268435456]="Immutable",v[v.IndirectCall=536870912]="IndirectCall",(y=e.ExternalEmitHelpers||(e.ExternalEmitHelpers={}))[y.Extends=1]="Extends",y[y.Assign=2]="Assign",y[y.Rest=4]="Rest",y[y.Decorate=8]="Decorate",y[y.Metadata=16]="Metadata",y[y.Param=32]="Param",y[y.Awaiter=64]="Awaiter",y[y.Generator=128]="Generator",y[y.Values=256]="Values",y[y.Read=512]="Read",y[y.SpreadArray=1024]="SpreadArray",y[y.Await=2048]="Await",y[y.AsyncGenerator=4096]="AsyncGenerator",y[y.AsyncDelegator=8192]="AsyncDelegator",y[y.AsyncValues=16384]="AsyncValues",y[y.ExportStar=32768]="ExportStar",y[y.ImportStar=65536]="ImportStar",y[y.ImportDefault=131072]="ImportDefault",y[y.MakeTemplateObject=262144]="MakeTemplateObject",y[y.ClassPrivateFieldGet=524288]="ClassPrivateFieldGet",y[y.ClassPrivateFieldSet=1048576]="ClassPrivateFieldSet",y[y.ClassPrivateFieldIn=2097152]="ClassPrivateFieldIn",y[y.CreateBinding=4194304]="CreateBinding",y[y.FirstEmitHelper=1]="FirstEmitHelper",y[y.LastEmitHelper=4194304]="LastEmitHelper",y[y.ForOfIncludes=256]="ForOfIncludes",y[y.ForAwaitOfIncludes=16384]="ForAwaitOfIncludes",y[y.AsyncGeneratorIncludes=6144]="AsyncGeneratorIncludes",y[y.AsyncDelegatorIncludes=26624]="AsyncDelegatorIncludes",y[y.SpreadIncludes=1536]="SpreadIncludes",(m=e.EmitHint||(e.EmitHint={}))[m.SourceFile=0]="SourceFile",m[m.Expression=1]="Expression",m[m.IdentifierName=2]="IdentifierName",m[m.MappedTypeParameter=3]="MappedTypeParameter",m[m.Unspecified=4]="Unspecified",m[m.EmbeddedStatement=5]="EmbeddedStatement",m[m.JsxAttributeValue=6]="JsxAttributeValue",(g=e.OuterExpressionKinds||(e.OuterExpressionKinds={}))[g.Parentheses=1]="Parentheses",g[g.TypeAssertions=2]="TypeAssertions",g[g.NonNullAssertions=4]="NonNullAssertions",g[g.PartiallyEmittedExpressions=8]="PartiallyEmittedExpressions",g[g.Assertions=6]="Assertions",g[g.All=15]="All",g[g.ExcludeJSDocTypeAssertion=16]="ExcludeJSDocTypeAssertion",(f=e.LexicalEnvironmentFlags||(e.LexicalEnvironmentFlags={}))[f.None=0]="None",f[f.InParameters=1]="InParameters",f[f.VariablesHoistedInParameters=2]="VariablesHoistedInParameters",(p=e.BundleFileSectionKind||(e.BundleFileSectionKind={})).Prologue="prologue",p.EmitHelpers="emitHelpers",p.NoDefaultLib="no-default-lib",p.Reference="reference",p.Type="type",p.TypeResolutionModeRequire="type-require",p.TypeResolutionModeImport="type-import",p.Lib="lib",p.Prepend="prepend",p.Text="text",p.Internal="internal",(d=e.ListFormat||(e.ListFormat={}))[d.None=0]="None",d[d.SingleLine=0]="SingleLine",d[d.MultiLine=1]="MultiLine",d[d.PreserveLines=2]="PreserveLines",d[d.LinesMask=3]="LinesMask",d[d.NotDelimited=0]="NotDelimited",d[d.BarDelimited=4]="BarDelimited",d[d.AmpersandDelimited=8]="AmpersandDelimited",d[d.CommaDelimited=16]="CommaDelimited",d[d.AsteriskDelimited=32]="AsteriskDelimited",d[d.DelimitersMask=60]="DelimitersMask",d[d.AllowTrailingComma=64]="AllowTrailingComma",d[d.Indented=128]="Indented",d[d.SpaceBetweenBraces=256]="SpaceBetweenBraces",d[d.SpaceBetweenSiblings=512]="SpaceBetweenSiblings",d[d.Braces=1024]="Braces",d[d.Parenthesis=2048]="Parenthesis",d[d.AngleBrackets=4096]="AngleBrackets",d[d.SquareBrackets=8192]="SquareBrackets",d[d.BracketsMask=15360]="BracketsMask",d[d.OptionalIfUndefined=16384]="OptionalIfUndefined",d[d.OptionalIfEmpty=32768]="OptionalIfEmpty",d[d.Optional=49152]="Optional",d[d.PreferNewLine=65536]="PreferNewLine",d[d.NoTrailingNewLine=131072]="NoTrailingNewLine",d[d.NoInterveningComments=262144]="NoInterveningComments",d[d.NoSpaceIfEmpty=524288]="NoSpaceIfEmpty",d[d.SingleElement=1048576]="SingleElement",d[d.SpaceAfterList=2097152]="SpaceAfterList",d[d.Modifiers=262656]="Modifiers",d[d.HeritageClauses=512]="HeritageClauses",d[d.SingleLineTypeLiteralMembers=768]="SingleLineTypeLiteralMembers",d[d.MultiLineTypeLiteralMembers=32897]="MultiLineTypeLiteralMembers",d[d.SingleLineTupleTypeElements=528]="SingleLineTupleTypeElements",d[d.MultiLineTupleTypeElements=657]="MultiLineTupleTypeElements",d[d.UnionTypeConstituents=516]="UnionTypeConstituents",d[d.IntersectionTypeConstituents=520]="IntersectionTypeConstituents",d[d.ObjectBindingPatternElements=525136]="ObjectBindingPatternElements",d[d.ArrayBindingPatternElements=524880]="ArrayBindingPatternElements",d[d.ObjectLiteralExpressionProperties=526226]="ObjectLiteralExpressionProperties",d[d.ImportClauseEntries=526226]="ImportClauseEntries",d[d.ArrayLiteralExpressionElements=8914]="ArrayLiteralExpressionElements",d[d.CommaListElements=528]="CommaListElements",d[d.CallExpressionArguments=2576]="CallExpressionArguments",d[d.NewExpressionArguments=18960]="NewExpressionArguments",d[d.TemplateExpressionSpans=262144]="TemplateExpressionSpans",d[d.SingleLineBlockStatements=768]="SingleLineBlockStatements",d[d.MultiLineBlockStatements=129]="MultiLineBlockStatements",d[d.VariableDeclarationList=528]="VariableDeclarationList",d[d.SingleLineFunctionBodyStatements=768]="SingleLineFunctionBodyStatements",d[d.MultiLineFunctionBodyStatements=1]="MultiLineFunctionBodyStatements",d[d.ClassHeritageClauses=0]="ClassHeritageClauses",d[d.ClassMembers=129]="ClassMembers",d[d.InterfaceMembers=129]="InterfaceMembers",d[d.EnumMembers=145]="EnumMembers",d[d.CaseBlockClauses=129]="CaseBlockClauses",d[d.NamedImportsOrExportsElements=525136]="NamedImportsOrExportsElements",d[d.JsxElementOrFragmentChildren=262144]="JsxElementOrFragmentChildren",d[d.JsxElementAttributes=262656]="JsxElementAttributes",d[d.CaseOrDefaultClauseStatements=163969]="CaseOrDefaultClauseStatements",d[d.HeritageClauseTypes=528]="HeritageClauseTypes",d[d.SourceFileStatements=131073]="SourceFileStatements",d[d.Decorators=2146305]="Decorators",d[d.TypeArguments=53776]="TypeArguments",d[d.TypeParameters=53776]="TypeParameters",d[d.Parameters=2576]="Parameters",d[d.IndexSignatureParameters=8848]="IndexSignatureParameters",d[d.JSDocComment=33]="JSDocComment",(_=e.PragmaKindFlags||(e.PragmaKindFlags={}))[_.None=0]="None",_[_.TripleSlashXML=1]="TripleSlashXML",_[_.SingleLine=2]="SingleLine",_[_.MultiLine=4]="MultiLine",_[_.All=7]="All",_[_.Default=7]="Default",e.commentPragmas={reference:{args:[{name:"types",optional:!0,captureSpan:!0},{name:"lib",optional:!0,captureSpan:!0},{name:"path",optional:!0,captureSpan:!0},{name:"no-default-lib",optional:!0},{name:"resolution-mode",optional:!0}],kind:1},"amd-dependency":{args:[{name:"path"},{name:"name",optional:!0}],kind:1},"amd-module":{args:[{name:"name"}],kind:1},"ts-check":{kind:2},"ts-nocheck":{kind:2},jsx:{args:[{name:"factory"}],kind:4},jsxfrag:{args:[{name:"factory"}],kind:4},jsximportsource:{args:[{name:"factory"}],kind:4},jsxruntime:{args:[{name:"factory"}],kind:4}};}(t),function(e){function t(e){for(var t=5381,r=0;r<e.length;r++)t=(t<<5)+t+e.charCodeAt(r);return t.toString()}var r,n;function a(t,r){return t.getModifiedTime(r)||e.missingFileModifiedTime}function o(e){var t;return (t={})[n.Low]=e.Low,t[n.Medium]=e.Medium,t[n.High]=e.High,t}e.generateDjb2Hash=t,e.setStackTraceLimit=function(){Error.stackTraceLimit<100&&(Error.stackTraceLimit=100);},function(e){e[e.Created=0]="Created",e[e.Changed=1]="Changed",e[e.Deleted=2]="Deleted";}(r=e.FileWatcherEventKind||(e.FileWatcherEventKind={})),function(e){e[e.High=2e3]="High",e[e.Medium=500]="Medium",e[e.Low=250]="Low";}(n=e.PollingInterval||(e.PollingInterval={})),e.missingFileModifiedTime=new Date(0),e.getModifiedTime=a;var s={Low:32,Medium:64,High:256},c=o(s);function l(t){if(t.getEnvironmentVariable){var r=function(e,t){var r=a("TSC_WATCH_POLLINGINTERVAL");return !!r&&(n("Low"),n("Medium"),n("High"),!0);function n(e){t[e]=r[e]||t[e];}}(0,n);c=l("TSC_WATCH_POLLINGCHUNKSIZE",s)||c,e.unchangedPollThresholds=l("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS",s)||e.unchangedPollThresholds;}function a(e){var r;return n("Low"),n("Medium"),n("High"),r;function n(n){var i=function(e,r){return t.getEnvironmentVariable("".concat(e,"_").concat(r.toUpperCase()))}(e,n);i&&((r||(r={}))[n]=Number(i));}}function l(e,t){var n=a(e);return (r||n)&&o(n?i$1(i$1({},t),n):t)}}function u(e,t,r,n,i){for(var o=r,s=t.length;n&&s;++r===t.length&&(o<r&&(t.length=o),r=0,o=0),s--){var c=t[r];if(c)if(c.isClosed)t[r]=void 0;else {n--;var l=f(c,a(e,c.fileName));c.isClosed?t[r]=void 0:(null==i||i(c,r,l),t[r]&&(o<r&&(t[o]=c,t[r]=void 0),o++));}}return r}function _(t){var r=[],i=[],o=_(n.Low),s=_(n.Medium),l=_(n.High);return function(n,i,o){var s={fileName:n,callback:i,unchangedPolls:0,mtime:a(t,n)};return r.push(s),m(s,o),{close:function(){s.isClosed=!0,e.unorderedRemoveItem(r,s);}}};function _(e){var t=[];return t.pollingInterval=e,t.pollIndex=0,t.pollScheduled=!1,t}function d(t){t.pollIndex=f(t,t.pollingInterval,t.pollIndex,c[t.pollingInterval]),t.length?v(t.pollingInterval):(e.Debug.assert(0===t.pollIndex),t.pollScheduled=!1);}function p(e){f(i,n.Low,0,i.length),d(e),!e.pollScheduled&&i.length&&v(n.Low);}function f(r,a,o,s){return u(t,r,o,s,(function(t,o,s){var c;s?(t.unchangedPolls=0,r!==i&&(r[o]=void 0,c=t,i.push(c),y(n.Low))):t.unchangedPolls!==e.unchangedPollThresholds[a]?t.unchangedPolls++:r===i?(t.unchangedPolls=1,r[o]=void 0,m(t,n.Low)):a!==n.High&&(t.unchangedPolls++,r[o]=void 0,m(t,a===n.Low?n.Medium:n.High));}))}function g(e){switch(e){case n.Low:return o;case n.Medium:return s;case n.High:return l}}function m(e,t){g(t).push(e),y(t);}function y(e){g(e).pollScheduled||v(e);}function v(e){g(e).pollScheduled=t.setTimeout(e===n.Low?p:d,e,g(e));}}function d(t){var r,i=[],o=0;return function(r,n){var o={fileName:r,callback:n,mtime:a(t,r)};return i.push(o),l(),{close:function(){o.isClosed=!0,e.unorderedRemoveItem(i,o);}}};function s(){r=void 0,o=u(t,i,o,c[n.Low]),l();}function l(){i.length&&!r&&(r=t.setTimeout(s,n.High));}}function p(t,r){var n=new e.Map,i=e.createMultiMap(),a=e.createGetCanonicalFileName(r);return function(r,o,s,c){var l=a(r),u=n.get(l);return u?u.refCount++:n.set(l,{watcher:t(r,(function(t,r){return e.forEach(i.get(l),(function(e){return e(t,r)}))}),s,c),refCount:1}),i.add(l,o),{close:function(){var t=e.Debug.checkDefined(n.get(l));i.remove(l,o),t.refCount--,t.refCount||(n.delete(l),e.closeFileWatcherOf(t));}}}}function f(e,t){var r=e.mtime.getTime(),n=t.getTime();return r!==n&&(e.mtime=t,e.callback(e.fileName,g(r,n)),!0)}function g(e,t){return 0===e?r.Created:0===t?r.Deleted:r.Changed}e.unchangedPollThresholds=o(s),e.setCustomPollingValues=l,e.createDynamicPriorityPollingWatchFile=_,e.createSingleFileWatcherPerName=p,e.onWatchedFileStat=f,e.getFileWatcherEventKind=g,e.ignoredPaths=["/node_modules/.","/.git","/.#"];var m,y,v=e.noop;function h(e){return v(e)}function b(t){var r,n=t.watchDirectory,i=t.useCaseSensitiveFileNames,a=t.getCurrentDirectory,o=t.getAccessibleSortedChildDirectories,s=t.directoryExists,c=t.realpath,l=t.setTimeout,u=t.clearTimeout,_=new e.Map,d=e.createMultiMap(),p=new e.Map,f=e.getStringComparer(!i),g=e.createGetCanonicalFileName(i);return function(e,t,r,i){return r?m(e,i,t):n(e,t,r,i)};function m(t,i,a){var o=g(t),c=_.get(o);c?c.refCount++:(c={watcher:n(t,(function(e){S(e,i)||((null==i?void 0:i.synchronousWatchDirectory)?(y(o,e),x(t,o,i)):function(e,t,n,i){var a=_.get(t);a&&s(e)?function(e,t,n,i){var a=p.get(t);a?a.fileNames.push(n):p.set(t,{dirName:e,options:i,fileNames:[n]}),r&&(u(r),r=void 0),r=l(v,1e3);}(e,t,n,i):(y(t,n),b(a));}(t,o,e,i));}),!1,i),refCount:1,childWatches:e.emptyArray},_.set(o,c),x(t,o,i));var f=a&&{dirName:t,callback:a};return f&&d.add(o,f),{dirName:t,close:function(){var t=e.Debug.checkDefined(_.get(o));f&&d.remove(o,f),t.refCount--,t.refCount||(_.delete(o),e.closeFileWatcherOf(t),t.childWatches.forEach(e.closeFileWatcher));}}}function y(t,r,n){var i,a;e.isString(r)?i=r:a=r,d.forEach((function(r,o){var s;if((!a||!0!==a.get(o))&&(o===t||e.startsWith(t,o)&&t[o.length]===e.directorySeparator))if(a)if(n){var c=a.get(o);c?(s=c).push.apply(s,n):a.set(o,n.slice());}else a.set(o,!0);else r.forEach((function(e){return (0, e.callback)(i)}));}));}function v(){r=void 0,h("sysLog:: onTimerToUpdateChildWatches:: ".concat(p.size));for(var t=e.timestamp(),n=new e.Map;!r&&p.size;){var i=p.entries().next();e.Debug.assert(!i.done);var a=i.value,o=a[0],s=a[1],c=s.dirName,l=s.options,u=s.fileNames;p.delete(o);var _=x(c,o,l);y(o,n,_?void 0:u);}h("sysLog:: invokingWatchers:: Elapsed:: ".concat(e.timestamp()-t,"ms:: ").concat(p.size)),d.forEach((function(t,r){var i=n.get(r);i&&t.forEach((function(t){var r=t.callback,n=t.dirName;e.isArray(i)?i.forEach(r):r(n);}));}));var f=e.timestamp()-t;h("sysLog:: Elapsed:: ".concat(f,"ms:: onTimerToUpdateChildWatches:: ").concat(p.size," ").concat(r));}function b(t){if(t){var r=t.childWatches;t.childWatches=e.emptyArray;for(var n=0,i=r;n<i.length;n++){var a=i[n];a.close(),b(_.get(g(a.dirName)));}}}function x(t,r,n){var i,a=_.get(r);if(!a)return !1;var l=e.enumerateInsertsAndDeletes(s(t)?e.mapDefined(o(t),(function(r){var i=e.getNormalizedAbsolutePath(r,t);return S(i,n)||0!==f(i,e.normalizePath(c(i)))?void 0:i})):e.emptyArray,a.childWatches,(function(e,t){return f(e,t.dirName)}),(function(e){u(m(e,n));}),e.closeFileWatcher,u);return a.childWatches=i||e.emptyArray,l;function u(e){(i||(i=[])).push(e);}}function S(t,r){return e.some(e.ignoredPaths,(function(r){return function(t,r){return !!e.stringContains(t,r)||!i&&e.stringContains(g(t),r)}(t,r)}))||D(t,r,i,a)}}function x(e){return function(t,n){return e(n===r.Changed?"change":"rename","")}}function D(t,r,n,i){return ((null==r?void 0:r.excludeDirectories)||(null==r?void 0:r.excludeFiles))&&(e.matchesExclude(t,null==r?void 0:r.excludeFiles,n,i())||e.matchesExclude(t,null==r?void 0:r.excludeDirectories,n,i()))}function S(t,r,n,i,a){return function(o,s){if("rename"===o){var c=s?e.normalizePath(e.combinePaths(t,s)):t;s&&D(c,n,i,a)||r(c);}}}function T(t){var i,a,o,s,c=t.pollingWatchFile,l=t.getModifiedTime,u=t.setTimeout,p=t.clearTimeout,f=t.fsWatch,g=t.fileExists,m=t.useCaseSensitiveFileNames,y=t.getCurrentDirectory,v=t.fsSupportsRecursiveFsWatch,h=t.directoryExists,x=t.getAccessibleSortedChildDirectories,D=t.realpath,T=t.tscWatchFile,C=t.useNonPollingWatchers,k=t.tscWatchDirectory,E=t.defaultWatchFileKind;return {watchFile:function(t,i,a,s){s=function(t,r){if(t&&void 0!==t.watchFile)return t;switch(T){case"PriorityPollingInterval":return {watchFile:e.WatchFileKind.PriorityPollingInterval};case"DynamicPriorityPolling":return {watchFile:e.WatchFileKind.DynamicPriorityPolling};case"UseFsEvents":return A(e.WatchFileKind.UseFsEvents,e.PollingWatchKind.PriorityInterval,t);case"UseFsEventsWithFallbackDynamicPolling":return A(e.WatchFileKind.UseFsEvents,e.PollingWatchKind.DynamicPriority,t);case"UseFsEventsOnParentDirectory":r=!0;default:return r?A(e.WatchFileKind.UseFsEventsOnParentDirectory,e.PollingWatchKind.PriorityInterval,t):{watchFile:(null==E?void 0:E())||e.WatchFileKind.FixedPollingInterval}}}(s,C);var l=e.Debug.checkDefined(s.watchFile);switch(l){case e.WatchFileKind.FixedPollingInterval:return c(t,i,n.Low,void 0);case e.WatchFileKind.PriorityPollingInterval:return c(t,i,a,void 0);case e.WatchFileKind.DynamicPriorityPolling:return N()(t,i,a,void 0);case e.WatchFileKind.FixedChunkSizePolling:return F()(t,i,void 0,void 0);case e.WatchFileKind.UseFsEvents:return f(t,0,function(e,t,n){return function(i){t(e,"rename"===i?n(e)?r.Created:r.Deleted:r.Changed);}}(t,i,g),!1,a,e.getFallbackOptions(s));case e.WatchFileKind.UseFsEventsOnParentDirectory:return o||(o=function(t,i){var a=e.createMultiMap(),o=new e.Map,s=e.createGetCanonicalFileName(i);return function(i,c,l,u){var _=s(i);a.add(_,c);var d=e.getDirectoryPath(_)||".",p=o.get(d)||function(i,c,l){var u=t(i,1,(function(t,n){if(e.isString(n)){var o=e.getNormalizedAbsolutePath(n,i),c=o&&a.get(s(o));if(c)for(var l=0,u=c;l<u.length;l++)(0, u[l])(o,r.Changed);}}),!1,n.Medium,l);return u.referenceCount=0,o.set(c,u),u}(e.getDirectoryPath(i)||".",d,u);return p.referenceCount++,{close:function(){1===p.referenceCount?(p.close(),o.delete(d)):p.referenceCount--,a.remove(_,c);}}}}(f,m)),o(t,i,a,e.getFallbackOptions(s));default:e.Debug.assertNever(l);}},watchDirectory:function(t,r,i,a){return v?f(t,1,S(t,r,a,m,y),i,n.Medium,e.getFallbackOptions(a)):(s||(s=b({useCaseSensitiveFileNames:m,getCurrentDirectory:y,directoryExists:h,getAccessibleSortedChildDirectories:x,watchDirectory:P,realpath:D,setTimeout:u,clearTimeout:p})),s(t,r,i,a))}};function N(){return i||(i=_({getModifiedTime:l,setTimeout:u}))}function F(){return a||(a=d({getModifiedTime:l,setTimeout:u}))}function A(e,t,r){var n=null==r?void 0:r.fallbackPolling;return {watchFile:e,fallbackPolling:void 0===n?t:n}}function P(t,r,i,a){e.Debug.assert(!i);var o=function(t){if(t&&void 0!==t.watchDirectory)return t;switch(k){case"RecursiveDirectoryUsingFsWatchFile":return {watchDirectory:e.WatchDirectoryKind.FixedPollingInterval};case"RecursiveDirectoryUsingDynamicPriorityPolling":return {watchDirectory:e.WatchDirectoryKind.DynamicPriorityPolling};default:var r=null==t?void 0:t.fallbackPolling;return {watchDirectory:e.WatchDirectoryKind.UseFsEvents,fallbackPolling:void 0!==r?r:void 0}}}(a),s=e.Debug.checkDefined(o.watchDirectory);switch(s){case e.WatchDirectoryKind.FixedPollingInterval:return c(t,(function(){return r(t)}),n.Medium,void 0);case e.WatchDirectoryKind.DynamicPriorityPolling:return N()(t,(function(){return r(t)}),n.Medium,void 0);case e.WatchDirectoryKind.FixedChunkSizePolling:return F()(t,(function(){return r(t)}),void 0,void 0);case e.WatchDirectoryKind.UseFsEvents:return f(t,1,S(t,r,a,m,y),i,n.Medium,e.getFallbackOptions(o));default:e.Debug.assertNever(s);}}}function C(t){var r=t.writeFile;t.writeFile=function(n,i,a){return e.writeFileEnsuringDirectories(n,i,!!a,(function(e,n,i){return r.call(t,e,n,i)}),(function(e){return t.createDirectory(e)}),(function(e){return t.directoryExists(e)}))};}function k(){if("undefined"!=typeof process){var e=process.version;if(e){var t=e.indexOf(".");if(-1!==t)return parseInt(e.substring(1,t))}}}e.sysLog=h,e.setSysLog=function(e){v=e;},e.createDirectoryWatcherSupportingRecursive=b,(y=e.FileSystemEntryKind||(e.FileSystemEntryKind={}))[y.File=0]="File",y[y.Directory=1]="Directory",e.createFileWatcherCallback=x,e.createSystemWatchFunctions=T,e.patchWriteFileEnsuringDirectory=C,e.getNodeMajorVersion=k,e.sys=("undefined"!=typeof process&&process.nextTick&&!process.browser&&"undefined"!=typeof require&&(m=function(){var n,i,s=require("fs"),c=require("path"),l=require("os");try{i=require("crypto");}catch(e){i=void 0;}var u,d=!1,f=require("buffer").Buffer,g=k()>=4,y="linux"===process.platform||"darwin"===process.platform,v=l.platform(),b="win32"!==v&&"win64"!==v&&!M((u=__filename,u.replace(/\w/g,(function(e){var t=e.toUpperCase();return e===t?e.toLowerCase():t})))),D=null!==(n=s.realpathSync.native)&&void 0!==n?n:s.realpathSync,S=g&&("win32"===process.platform||"darwin"===process.platform),C=e.memoize((function(){return process.cwd()})),E=T({pollingWatchFile:p((function(e,t,n){var i;return s.watchFile(e,{persistent:!0,interval:n},a),{close:function(){return s.unwatchFile(e,a)}};function a(n,a){var o=0==+a.mtime||i===r.Deleted;if(0==+n.mtime){if(o)return;i=r.Deleted;}else if(o)i=r.Created;else {if(+n.mtime==+a.mtime)return;i=r.Changed;}t(e,i);}}),b),getModifiedTime:B,setTimeout,clearTimeout,fsWatch:function(t,n,i,a,o,c){var l,u,_;y&&(u=t.substr(t.lastIndexOf(e.directorySeparator)),_=u.slice(e.directorySeparator.length));var p=O(t,n)?g():b();return {close:function(){p.close(),p=void 0;}};function f(e){h("sysLog:: ".concat(t,":: Changing watcher to ").concat(e===g?"Present":"Missing","FileSystemEntryWatcher")),i("rename",""),p&&(p.close(),p=e());}function g(){if(void 0===l&&(l=S?{persistent:!0,recursive:!!a}:{persistent:!0}),d)return h("sysLog:: ".concat(t,":: Defaulting to fsWatchFile")),v();try{var e=s.watch(t,l,y?m:i);return e.on("error",(function(){return f(b)})),e}catch(e){return d||(d="ENOSPC"===e.code),h("sysLog:: ".concat(t,":: Changing to fsWatchFile")),v()}}function m(e,r){return "rename"!==e||r&&r!==_&&(-1===r.lastIndexOf(u)||r.lastIndexOf(u)!==r.length-u.length)||O(t,n)?i(e,r):f(b)}function v(){return N(t,x(i),o,c)}function b(){return N(t,(function(e,i){i===r.Created&&O(t,n)&&f(g);}),o,c)}},useCaseSensitiveFileNames:b,getCurrentDirectory:C,fileExists:M,fsSupportsRecursiveFsWatch:S,directoryExists:L,getAccessibleSortedChildDirectories:function(e){return I(e).directories},realpath:R,tscWatchFile:process.env.TSC_WATCHFILE,useNonPollingWatchers:process.env.TSC_NONPOLLING_WATCHER,tscWatchDirectory:process.env.TSC_WATCHDIRECTORY,defaultWatchFileKind:function(){var e,t;return null===(t=(e=m).defaultWatchFileKind)||void 0===t?void 0:t.call(e)}}),N=E.watchFile,F=E.watchDirectory,A={args:process.argv.slice(2),newLine:l.EOL,useCaseSensitiveFileNames:b,write:function(e){process.stdout.write(e);},getWidthOfTerminal:function(){return process.stdout.columns},writeOutputIsTTY:function(){return process.stdout.isTTY},readFile:function(t,r){e.perfLogger.logStartReadFile(t);var n=function(e,t){var r;try{r=s.readFileSync(e);}catch(e){return}var n=r.length;if(n>=2&&254===r[0]&&255===r[1]){n&=-2;for(var i=0;i<n;i+=2){var a=r[i];r[i]=r[i+1],r[i+1]=a;}return r.toString("utf16le",2)}return n>=2&&255===r[0]&&254===r[1]?r.toString("utf16le",2):n>=3&&239===r[0]&&187===r[1]&&191===r[2]?r.toString("utf8",3):r.toString("utf8")}(t);return e.perfLogger.logStopReadFile(),n},writeFile:function(t,r,n){var i;e.perfLogger.logEvent("WriteFile: "+t),n&&(r="\ufeff"+r);try{i=s.openSync(t,"w"),s.writeSync(i,r,void 0,"utf8");}finally{void 0!==i&&s.closeSync(i);}},watchFile:N,watchDirectory:F,resolvePath:function(e){return c.resolve(e)},fileExists:M,directoryExists:L,createDirectory:function(e){if(!A.directoryExists(e))try{s.mkdirSync(e);}catch(e){if("EEXIST"!==e.code)throw e}},getExecutingFilePath:function(){return __filename},getCurrentDirectory:C,getDirectories:function(e){return I(e).directories.slice()},getEnvironmentVariable:function(e){return process.env[e]||""},readDirectory:function(t,r,n,i,a){return e.matchFiles(t,r,n,i,b,process.cwd(),a,I,R)},getModifiedTime:B,setModifiedTime:function(e,t){try{s.utimesSync(e,t,t);}catch(e){return}},deleteFile:function(e){try{return s.unlinkSync(e)}catch(e){return}},createHash:i?j:t,createSHA256Hash:i?j:void 0,getMemoryUsage:function(){return global.gc&&global.gc(),process.memoryUsage().heapUsed},getFileSize:function(e){try{var t=P(e);if(null==t?void 0:t.isFile())return t.size}catch(e){}return 0},exit:function(t){!function(t){t();}((function(){return process.exit(t)}));},cpuProfilingEnabled:function(){return e.contains(process.execArgv,"--cpu-prof")||e.contains(process.execArgv,"--prof")},realpath:R,debugMode:!!process.env.NODE_INSPECTOR_IPC||!!process.env.VSCODE_INSPECTOR_OPTIONS||e.some(process.execArgv,(function(e){return /^--(inspect|debug)(-brk)?(=\d+)?$/i.test(e)})),tryEnableSourceMapsForHost:function(){try{require("source-map-support").install();}catch(e){}},setTimeout,clearTimeout,clearScreen:function(){process.stdout.write("c");},setBlocking:function(){process.stdout&&process.stdout._handle&&process.stdout._handle.setBlocking&&process.stdout._handle.setBlocking(!0);},bufferFrom:w,base64decode:function(e){return w(e,"base64").toString("utf8")},base64encode:function(e){return w(e).toString("base64")},require:function(t,r){try{var n=e.resolveJSModule(r,t,A);return {module:require(n),modulePath:n,error:void 0}}catch(e){return {module:void 0,modulePath:void 0,error:e}}}};return A;function P(e){return s.statSync(e,{throwIfNoEntry:!1})}function w(e,t){return f.from&&f.from!==Int8Array.from?f.from(e,t):new f(e,t)}function I(t){e.perfLogger.logEvent("ReadDir: "+(t||"."));try{for(var r=s.readdirSync(t||".",{withFileTypes:!0}),n=[],i=[],a=0,o=r;a<o.length;a++){var c=o[a],l="string"==typeof c?c:c.name;if("."!==l&&".."!==l){var u=void 0;if("string"==typeof c||c.isSymbolicLink()){var _=e.combinePaths(t,l);try{if(!(u=P(_)))continue}catch(e){continue}}else u=c;u.isFile()?n.push(l):u.isDirectory()&&i.push(l);}}return n.sort(),i.sort(),{files:n,directories:i}}catch(t){return e.emptyFileSystemEntries}}function O(e,t){var r=Error.stackTraceLimit;Error.stackTraceLimit=0;try{var n=P(e);if(!n)return !1;switch(t){case 0:return n.isFile();case 1:return n.isDirectory();default:return !1}}catch(e){return !1}finally{Error.stackTraceLimit=r;}}function M(e){return O(e,0)}function L(e){return O(e,1)}function R(e){try{return D(e)}catch(t){return e}}function B(e){var t;try{return null===(t=P(e))||void 0===t?void 0:t.mtime}catch(e){return}}function j(e){var t=i.createHash("sha256");return t.update(e),t.digest("hex")}}()),m&&C(m),m),e.setSys=function(t){e.sys=t;},e.sys&&e.sys.getEnvironmentVariable&&(l(e.sys),e.Debug.setAssertionLevel(/^development$/i.test(e.sys.getEnvironmentVariable("NODE_ENV"))?1:0)),e.sys&&e.sys.debugMode&&(e.Debug.isDebugging=!0);}(t),function(e){e.directorySeparator="/",e.altDirectorySeparator="\\";var t=/\\/g;function r(e){return 47===e||92===e}function i(e){return u(e)>0}function a(e){return 0!==u(e)}function o(e){return /^\.\.?($|[\\/])/.test(e)}function s(t,r){return t.length>r.length&&e.endsWith(t,r)}function c(e){return e.length>0&&r(e.charCodeAt(e.length-1))}function l(e){return e>=97&&e<=122||e>=65&&e<=90}function u(t){if(!t)return 0;var r=t.charCodeAt(0);if(47===r||92===r){if(t.charCodeAt(1)!==r)return 1;var n=t.indexOf(47===r?e.directorySeparator:e.altDirectorySeparator,2);return n<0?t.length:n+1}if(l(r)&&58===t.charCodeAt(1)){var i=t.charCodeAt(2);if(47===i||92===i)return 3;if(2===t.length)return 2}var a=t.indexOf("://");if(-1!==a){var o=a+"://".length,s=t.indexOf(e.directorySeparator,o);if(-1!==s){var c=t.slice(0,a),u=t.slice(o,s);if("file"===c&&(""===u||"localhost"===u)&&l(t.charCodeAt(s+1))){var _=function(e,t){var r=e.charCodeAt(t);if(58===r)return t+1;if(37===r&&51===e.charCodeAt(t+1)){var n=e.charCodeAt(t+2);if(97===n||65===n)return t+3}return -1}(t,s+2);if(-1!==_){if(47===t.charCodeAt(_))return ~(_+1);if(_===t.length)return ~_}}return ~(s+1)}return ~t.length}return 0}function _(e){var t=u(e);return t<0?~t:t}function d(t){var r=_(t=v(t));return r===t.length?t:(t=C(t)).slice(0,Math.max(r,t.lastIndexOf(e.directorySeparator)))}function p(t,r,n){if(_(t=v(t))===t.length)return "";var i=(t=C(t)).slice(Math.max(_(t),t.lastIndexOf(e.directorySeparator)+1)),a=void 0!==r&&void 0!==n?g(i,r,n):void 0;return a?i.slice(0,i.length-a.length):i}function f(t,r,n){if(e.startsWith(r,".")||(r="."+r),t.length>=r.length&&46===t.charCodeAt(t.length-r.length)){var i=t.slice(t.length-r.length);if(n(i,r))return i}}function g(t,r,n){if(r)return function(e,t,r){if("string"==typeof t)return f(e,t,r)||"";for(var n=0,i=t;n<i.length;n++){var a=f(e,i[n],r);if(a)return a}return ""}(C(t),r,n?e.equateStringsCaseInsensitive:e.equateStringsCaseSensitive);var i=p(t),a=i.lastIndexOf(".");return a>=0?i.substring(a):""}function m(t,r){return void 0===r&&(r=""),function(t,r){var i=t.substring(0,r),a=t.substring(r).split(e.directorySeparator);return a.length&&!e.lastOrUndefined(a)&&a.pop(),n$3([i],a,!0)}(t=b(r,t),_(t))}function y(t){return 0===t.length?"":(t[0]&&k(t[0]))+t.slice(1).join(e.directorySeparator)}function v(r){var n=r.indexOf("\\");return -1===n?r:(t.lastIndex=n,r.replace(t,e.directorySeparator))}function h(t){if(!e.some(t))return [];for(var r=[t[0]],n=1;n<t.length;n++){var i=t[n];if(i&&"."!==i){if(".."===i)if(r.length>1){if(".."!==r[r.length-1]){r.pop();continue}}else if(r[0])continue;r.push(i);}}return r}function b(e){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];e&&(e=v(e));for(var n=0,i=t;n<i.length;n++){var a=i[n];a&&(a=v(a),e=e&&0===_(a)?k(e)+a:a);}return e}function x(t){for(var r=[],i=1;i<arguments.length;i++)r[i-1]=arguments[i];return T(e.some(r)?b.apply(void 0,n$3([t],r,!1)):v(t))}function D(e,t){return h(m(e,t))}function S(e,t){return y(D(e,t))}function T(e){if(e=v(e),!N.test(e))return e;var t=e.replace(/\/\.\//g,"/").replace(/^\.\//,"");if(t!==e&&(e=t,!N.test(e)))return e;var r=y(h(m(e)));return r&&c(e)?k(r):r}function C(e){return c(e)?e.substr(0,e.length-1):e}function k(t){return c(t)?t:t+e.directorySeparator}function E(e){return a(e)||o(e)?e:"./"+e}e.isAnyDirectorySeparator=r,e.isUrl=function(e){return u(e)<0},e.isRootedDiskPath=i,e.isDiskPathRoot=function(e){var t=u(e);return t>0&&t===e.length},e.pathIsAbsolute=a,e.pathIsRelative=o,e.pathIsBareSpecifier=function(e){return !a(e)&&!o(e)},e.hasExtension=function(t){return e.stringContains(p(t),".")},e.fileExtensionIs=s,e.fileExtensionIsOneOf=function(e,t){for(var r=0,n=t;r<n.length;r++)if(s(e,n[r]))return !0;return !1},e.hasTrailingDirectorySeparator=c,e.getRootLength=_,e.getDirectoryPath=d,e.getBaseFileName=p,e.getAnyExtensionFromPath=g,e.getPathComponents=m,e.getPathFromPathComponents=y,e.normalizeSlashes=v,e.reducePathComponents=h,e.combinePaths=b,e.resolvePath=x,e.getNormalizedPathComponents=D,e.getNormalizedAbsolutePath=S,e.normalizePath=T,e.getNormalizedAbsolutePathWithoutRoot=function(t,r){return 0===(n=D(t,r)).length?"":n.slice(1).join(e.directorySeparator);var n;},e.toPath=function(e,t,r){return r(i(e)?T(e):S(e,t))},e.removeTrailingDirectorySeparator=C,e.ensureTrailingDirectorySeparator=k,e.ensurePathIsNonModuleName=E,e.changeAnyExtension=function(t,r,n,i){var a=void 0!==n&&void 0!==i?g(t,n,i):g(t);return a?t.slice(0,t.length-a.length)+(e.startsWith(r,".")?r:"."+r):t};var N=/(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;function F(t,r,n){if(t===r)return 0;if(void 0===t)return -1;if(void 0===r)return 1;var i=t.substring(0,_(t)),a=r.substring(0,_(r)),o=e.compareStringsCaseInsensitive(i,a);if(0!==o)return o;var s=t.substring(i.length),c=r.substring(a.length);if(!N.test(s)&&!N.test(c))return n(s,c);for(var l=h(m(t)),u=h(m(r)),d=Math.min(l.length,u.length),p=1;p<d;p++){var f=n(l[p],u[p]);if(0!==f)return f}return e.compareValues(l.length,u.length)}function A(t,r,i,a){var o,s=h(m(t)),c=h(m(r));for(o=0;o<s.length&&o<c.length;o++){var l=a(s[o]),u=a(c[o]);if(!(0===o?e.equateStringsCaseInsensitive:i)(l,u))break}if(0===o)return c;for(var _=c.slice(o),d=[];o<s.length;o++)d.push("..");return n$3(n$3([""],d,!0),_,!0)}function P(t,r,n){e.Debug.assert(_(t)>0==_(r)>0,"Paths must either both be absolute or both be relative");var i="function"==typeof n?n:e.identity;return y(A(t,r,"boolean"==typeof n&&n?e.equateStringsCaseInsensitive:e.equateStringsCaseSensitive,i))}function w(t,r,n,a,o){var s=A(x(n,t),x(n,r),e.equateStringsCaseSensitive,a),c=s[0];if(o&&i(c)){var l=c.charAt(0)===e.directorySeparator?"file://":"file:///";s[0]=l+c;}return y(s)}e.comparePathsCaseSensitive=function(t,r){return F(t,r,e.compareStringsCaseSensitive)},e.comparePathsCaseInsensitive=function(t,r){return F(t,r,e.compareStringsCaseInsensitive)},e.comparePaths=function(t,r,n,i){return "string"==typeof n?(t=b(n,t),r=b(n,r)):"boolean"==typeof n&&(i=n),F(t,r,e.getStringComparer(i))},e.containsPath=function(t,r,n,i){if("string"==typeof n?(t=b(n,t),r=b(n,r)):"boolean"==typeof n&&(i=n),void 0===t||void 0===r)return !1;if(t===r)return !0;var a=h(m(t)),o=h(m(r));if(o.length<a.length)return !1;for(var s=i?e.equateStringsCaseInsensitive:e.equateStringsCaseSensitive,c=0;c<a.length;c++)if(!(0===c?e.equateStringsCaseInsensitive:s)(a[c],o[c]))return !1;return !0},e.startsWithDirectory=function(t,r,n){var i=n(t),a=n(r);return e.startsWith(i,a+"/")||e.startsWith(i,a+"\\")},e.getPathComponentsRelativeTo=A,e.getRelativePathFromDirectory=P,e.convertToRelativePath=function(e,t,r){return i(e)?w(t,e,t,r,!1):e},e.getRelativePathFromFile=function(e,t,r){return E(P(d(e),t,r))},e.getRelativePathToDirectoryOrUrl=w,e.forEachAncestorDirectory=function(e,t){for(;;){var r=t(e);if(void 0!==r)return r;var n=d(e);if(n===e)return;e=n;}},e.isNodeModulesDirectory=function(t){return e.endsWith(t,"/node_modules")};}(t),function(e){function t(e,t,r,n,i,a,o){return {code:e,category:t,key:r,message:n,reportsUnnecessary:i,elidedInCompatabilityPyramid:a,reportsDeprecated:o}}e.Diagnostics={Unterminated_string_literal:t(1002,e.DiagnosticCategory.Error,"Unterminated_string_literal_1002","Unterminated string literal."),Identifier_expected:t(1003,e.DiagnosticCategory.Error,"Identifier_expected_1003","Identifier expected."),_0_expected:t(1005,e.DiagnosticCategory.Error,"_0_expected_1005","'{0}' expected."),A_file_cannot_have_a_reference_to_itself:t(1006,e.DiagnosticCategory.Error,"A_file_cannot_have_a_reference_to_itself_1006","A file cannot have a reference to itself."),The_parser_expected_to_find_a_1_to_match_the_0_token_here:t(1007,e.DiagnosticCategory.Error,"The_parser_expected_to_find_a_1_to_match_the_0_token_here_1007","The parser expected to find a '{1}' to match the '{0}' token here."),Trailing_comma_not_allowed:t(1009,e.DiagnosticCategory.Error,"Trailing_comma_not_allowed_1009","Trailing comma not allowed."),Asterisk_Slash_expected:t(1010,e.DiagnosticCategory.Error,"Asterisk_Slash_expected_1010","'*/' expected."),An_element_access_expression_should_take_an_argument:t(1011,e.DiagnosticCategory.Error,"An_element_access_expression_should_take_an_argument_1011","An element access expression should take an argument."),Unexpected_token:t(1012,e.DiagnosticCategory.Error,"Unexpected_token_1012","Unexpected token."),A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma:t(1013,e.DiagnosticCategory.Error,"A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013","A rest parameter or binding pattern may not have a trailing comma."),A_rest_parameter_must_be_last_in_a_parameter_list:t(1014,e.DiagnosticCategory.Error,"A_rest_parameter_must_be_last_in_a_parameter_list_1014","A rest parameter must be last in a parameter list."),Parameter_cannot_have_question_mark_and_initializer:t(1015,e.DiagnosticCategory.Error,"Parameter_cannot_have_question_mark_and_initializer_1015","Parameter cannot have question mark and initializer."),A_required_parameter_cannot_follow_an_optional_parameter:t(1016,e.DiagnosticCategory.Error,"A_required_parameter_cannot_follow_an_optional_parameter_1016","A required parameter cannot follow an optional parameter."),An_index_signature_cannot_have_a_rest_parameter:t(1017,e.DiagnosticCategory.Error,"An_index_signature_cannot_have_a_rest_parameter_1017","An index signature cannot have a rest parameter."),An_index_signature_parameter_cannot_have_an_accessibility_modifier:t(1018,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018","An index signature parameter cannot have an accessibility modifier."),An_index_signature_parameter_cannot_have_a_question_mark:t(1019,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_a_question_mark_1019","An index signature parameter cannot have a question mark."),An_index_signature_parameter_cannot_have_an_initializer:t(1020,e.DiagnosticCategory.Error,"An_index_signature_parameter_cannot_have_an_initializer_1020","An index signature parameter cannot have an initializer."),An_index_signature_must_have_a_type_annotation:t(1021,e.DiagnosticCategory.Error,"An_index_signature_must_have_a_type_annotation_1021","An index signature must have a type annotation."),An_index_signature_parameter_must_have_a_type_annotation:t(1022,e.DiagnosticCategory.Error,"An_index_signature_parameter_must_have_a_type_annotation_1022","An index signature parameter must have a type annotation."),readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature:t(1024,e.DiagnosticCategory.Error,"readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024","'readonly' modifier can only appear on a property declaration or index signature."),An_index_signature_cannot_have_a_trailing_comma:t(1025,e.DiagnosticCategory.Error,"An_index_signature_cannot_have_a_trailing_comma_1025","An index signature cannot have a trailing comma."),Accessibility_modifier_already_seen:t(1028,e.DiagnosticCategory.Error,"Accessibility_modifier_already_seen_1028","Accessibility modifier already seen."),_0_modifier_must_precede_1_modifier:t(1029,e.DiagnosticCategory.Error,"_0_modifier_must_precede_1_modifier_1029","'{0}' modifier must precede '{1}' modifier."),_0_modifier_already_seen:t(1030,e.DiagnosticCategory.Error,"_0_modifier_already_seen_1030","'{0}' modifier already seen."),_0_modifier_cannot_appear_on_class_elements_of_this_kind:t(1031,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_class_elements_of_this_kind_1031","'{0}' modifier cannot appear on class elements of this kind."),super_must_be_followed_by_an_argument_list_or_member_access:t(1034,e.DiagnosticCategory.Error,"super_must_be_followed_by_an_argument_list_or_member_access_1034","'super' must be followed by an argument list or member access."),Only_ambient_modules_can_use_quoted_names:t(1035,e.DiagnosticCategory.Error,"Only_ambient_modules_can_use_quoted_names_1035","Only ambient modules can use quoted names."),Statements_are_not_allowed_in_ambient_contexts:t(1036,e.DiagnosticCategory.Error,"Statements_are_not_allowed_in_ambient_contexts_1036","Statements are not allowed in ambient contexts."),A_declare_modifier_cannot_be_used_in_an_already_ambient_context:t(1038,e.DiagnosticCategory.Error,"A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038","A 'declare' modifier cannot be used in an already ambient context."),Initializers_are_not_allowed_in_ambient_contexts:t(1039,e.DiagnosticCategory.Error,"Initializers_are_not_allowed_in_ambient_contexts_1039","Initializers are not allowed in ambient contexts."),_0_modifier_cannot_be_used_in_an_ambient_context:t(1040,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_in_an_ambient_context_1040","'{0}' modifier cannot be used in an ambient context."),_0_modifier_cannot_be_used_here:t(1042,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_here_1042","'{0}' modifier cannot be used here."),_0_modifier_cannot_appear_on_a_module_or_namespace_element:t(1044,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044","'{0}' modifier cannot appear on a module or namespace element."),Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier:t(1046,e.DiagnosticCategory.Error,"Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046","Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),A_rest_parameter_cannot_be_optional:t(1047,e.DiagnosticCategory.Error,"A_rest_parameter_cannot_be_optional_1047","A rest parameter cannot be optional."),A_rest_parameter_cannot_have_an_initializer:t(1048,e.DiagnosticCategory.Error,"A_rest_parameter_cannot_have_an_initializer_1048","A rest parameter cannot have an initializer."),A_set_accessor_must_have_exactly_one_parameter:t(1049,e.DiagnosticCategory.Error,"A_set_accessor_must_have_exactly_one_parameter_1049","A 'set' accessor must have exactly one parameter."),A_set_accessor_cannot_have_an_optional_parameter:t(1051,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_an_optional_parameter_1051","A 'set' accessor cannot have an optional parameter."),A_set_accessor_parameter_cannot_have_an_initializer:t(1052,e.DiagnosticCategory.Error,"A_set_accessor_parameter_cannot_have_an_initializer_1052","A 'set' accessor parameter cannot have an initializer."),A_set_accessor_cannot_have_rest_parameter:t(1053,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_rest_parameter_1053","A 'set' accessor cannot have rest parameter."),A_get_accessor_cannot_have_parameters:t(1054,e.DiagnosticCategory.Error,"A_get_accessor_cannot_have_parameters_1054","A 'get' accessor cannot have parameters."),Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value:t(1055,e.DiagnosticCategory.Error,"Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055","Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher:t(1056,e.DiagnosticCategory.Error,"Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056","Accessors are only available when targeting ECMAScript 5 and higher."),The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1058,e.DiagnosticCategory.Error,"The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058","The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),A_promise_must_have_a_then_method:t(1059,e.DiagnosticCategory.Error,"A_promise_must_have_a_then_method_1059","A promise must have a 'then' method."),The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback:t(1060,e.DiagnosticCategory.Error,"The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060","The first parameter of the 'then' method of a promise must be a callback."),Enum_member_must_have_initializer:t(1061,e.DiagnosticCategory.Error,"Enum_member_must_have_initializer_1061","Enum member must have initializer."),Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method:t(1062,e.DiagnosticCategory.Error,"Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062","Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),An_export_assignment_cannot_be_used_in_a_namespace:t(1063,e.DiagnosticCategory.Error,"An_export_assignment_cannot_be_used_in_a_namespace_1063","An export assignment cannot be used in a namespace."),The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_write_Promise_0:t(1064,e.DiagnosticCategory.Error,"The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_wri_1064","The return type of an async function or method must be the global Promise<T> type. Did you mean to write 'Promise<{0}>'?"),In_ambient_enum_declarations_member_initializer_must_be_constant_expression:t(1066,e.DiagnosticCategory.Error,"In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066","In ambient enum declarations member initializer must be constant expression."),Unexpected_token_A_constructor_method_accessor_or_property_was_expected:t(1068,e.DiagnosticCategory.Error,"Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068","Unexpected token. A constructor, method, accessor, or property was expected."),Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces:t(1069,e.DiagnosticCategory.Error,"Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069","Unexpected token. A type parameter name was expected without curly braces."),_0_modifier_cannot_appear_on_a_type_member:t(1070,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_type_member_1070","'{0}' modifier cannot appear on a type member."),_0_modifier_cannot_appear_on_an_index_signature:t(1071,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_an_index_signature_1071","'{0}' modifier cannot appear on an index signature."),A_0_modifier_cannot_be_used_with_an_import_declaration:t(1079,e.DiagnosticCategory.Error,"A_0_modifier_cannot_be_used_with_an_import_declaration_1079","A '{0}' modifier cannot be used with an import declaration."),Invalid_reference_directive_syntax:t(1084,e.DiagnosticCategory.Error,"Invalid_reference_directive_syntax_1084","Invalid 'reference' directive syntax."),Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0:t(1085,e.DiagnosticCategory.Error,"Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085","Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),_0_modifier_cannot_appear_on_a_constructor_declaration:t(1089,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_constructor_declaration_1089","'{0}' modifier cannot appear on a constructor declaration."),_0_modifier_cannot_appear_on_a_parameter:t(1090,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_parameter_1090","'{0}' modifier cannot appear on a parameter."),Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement:t(1091,e.DiagnosticCategory.Error,"Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091","Only a single variable declaration is allowed in a 'for...in' statement."),Type_parameters_cannot_appear_on_a_constructor_declaration:t(1092,e.DiagnosticCategory.Error,"Type_parameters_cannot_appear_on_a_constructor_declaration_1092","Type parameters cannot appear on a constructor declaration."),Type_annotation_cannot_appear_on_a_constructor_declaration:t(1093,e.DiagnosticCategory.Error,"Type_annotation_cannot_appear_on_a_constructor_declaration_1093","Type annotation cannot appear on a constructor declaration."),An_accessor_cannot_have_type_parameters:t(1094,e.DiagnosticCategory.Error,"An_accessor_cannot_have_type_parameters_1094","An accessor cannot have type parameters."),A_set_accessor_cannot_have_a_return_type_annotation:t(1095,e.DiagnosticCategory.Error,"A_set_accessor_cannot_have_a_return_type_annotation_1095","A 'set' accessor cannot have a return type annotation."),An_index_signature_must_have_exactly_one_parameter:t(1096,e.DiagnosticCategory.Error,"An_index_signature_must_have_exactly_one_parameter_1096","An index signature must have exactly one parameter."),_0_list_cannot_be_empty:t(1097,e.DiagnosticCategory.Error,"_0_list_cannot_be_empty_1097","'{0}' list cannot be empty."),Type_parameter_list_cannot_be_empty:t(1098,e.DiagnosticCategory.Error,"Type_parameter_list_cannot_be_empty_1098","Type parameter list cannot be empty."),Type_argument_list_cannot_be_empty:t(1099,e.DiagnosticCategory.Error,"Type_argument_list_cannot_be_empty_1099","Type argument list cannot be empty."),Invalid_use_of_0_in_strict_mode:t(1100,e.DiagnosticCategory.Error,"Invalid_use_of_0_in_strict_mode_1100","Invalid use of '{0}' in strict mode."),with_statements_are_not_allowed_in_strict_mode:t(1101,e.DiagnosticCategory.Error,"with_statements_are_not_allowed_in_strict_mode_1101","'with' statements are not allowed in strict mode."),delete_cannot_be_called_on_an_identifier_in_strict_mode:t(1102,e.DiagnosticCategory.Error,"delete_cannot_be_called_on_an_identifier_in_strict_mode_1102","'delete' cannot be called on an identifier in strict mode."),for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules:t(1103,e.DiagnosticCategory.Error,"for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1103","'for await' loops are only allowed within async functions and at the top levels of modules."),A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement:t(1104,e.DiagnosticCategory.Error,"A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104","A 'continue' statement can only be used within an enclosing iteration statement."),A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement:t(1105,e.DiagnosticCategory.Error,"A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105","A 'break' statement can only be used within an enclosing iteration or switch statement."),The_left_hand_side_of_a_for_of_statement_may_not_be_async:t(1106,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_of_statement_may_not_be_async_1106","The left-hand side of a 'for...of' statement may not be 'async'."),Jump_target_cannot_cross_function_boundary:t(1107,e.DiagnosticCategory.Error,"Jump_target_cannot_cross_function_boundary_1107","Jump target cannot cross function boundary."),A_return_statement_can_only_be_used_within_a_function_body:t(1108,e.DiagnosticCategory.Error,"A_return_statement_can_only_be_used_within_a_function_body_1108","A 'return' statement can only be used within a function body."),Expression_expected:t(1109,e.DiagnosticCategory.Error,"Expression_expected_1109","Expression expected."),Type_expected:t(1110,e.DiagnosticCategory.Error,"Type_expected_1110","Type expected."),A_default_clause_cannot_appear_more_than_once_in_a_switch_statement:t(1113,e.DiagnosticCategory.Error,"A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113","A 'default' clause cannot appear more than once in a 'switch' statement."),Duplicate_label_0:t(1114,e.DiagnosticCategory.Error,"Duplicate_label_0_1114","Duplicate label '{0}'."),A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement:t(1115,e.DiagnosticCategory.Error,"A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115","A 'continue' statement can only jump to a label of an enclosing iteration statement."),A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement:t(1116,e.DiagnosticCategory.Error,"A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116","A 'break' statement can only jump to a label of an enclosing statement."),An_object_literal_cannot_have_multiple_properties_with_the_same_name:t(1117,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_multiple_properties_with_the_same_name_1117","An object literal cannot have multiple properties with the same name."),An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name:t(1118,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118","An object literal cannot have multiple get/set accessors with the same name."),An_object_literal_cannot_have_property_and_accessor_with_the_same_name:t(1119,e.DiagnosticCategory.Error,"An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119","An object literal cannot have property and accessor with the same name."),An_export_assignment_cannot_have_modifiers:t(1120,e.DiagnosticCategory.Error,"An_export_assignment_cannot_have_modifiers_1120","An export assignment cannot have modifiers."),Octal_literals_are_not_allowed_in_strict_mode:t(1121,e.DiagnosticCategory.Error,"Octal_literals_are_not_allowed_in_strict_mode_1121","Octal literals are not allowed in strict mode."),Variable_declaration_list_cannot_be_empty:t(1123,e.DiagnosticCategory.Error,"Variable_declaration_list_cannot_be_empty_1123","Variable declaration list cannot be empty."),Digit_expected:t(1124,e.DiagnosticCategory.Error,"Digit_expected_1124","Digit expected."),Hexadecimal_digit_expected:t(1125,e.DiagnosticCategory.Error,"Hexadecimal_digit_expected_1125","Hexadecimal digit expected."),Unexpected_end_of_text:t(1126,e.DiagnosticCategory.Error,"Unexpected_end_of_text_1126","Unexpected end of text."),Invalid_character:t(1127,e.DiagnosticCategory.Error,"Invalid_character_1127","Invalid character."),Declaration_or_statement_expected:t(1128,e.DiagnosticCategory.Error,"Declaration_or_statement_expected_1128","Declaration or statement expected."),Statement_expected:t(1129,e.DiagnosticCategory.Error,"Statement_expected_1129","Statement expected."),case_or_default_expected:t(1130,e.DiagnosticCategory.Error,"case_or_default_expected_1130","'case' or 'default' expected."),Property_or_signature_expected:t(1131,e.DiagnosticCategory.Error,"Property_or_signature_expected_1131","Property or signature expected."),Enum_member_expected:t(1132,e.DiagnosticCategory.Error,"Enum_member_expected_1132","Enum member expected."),Variable_declaration_expected:t(1134,e.DiagnosticCategory.Error,"Variable_declaration_expected_1134","Variable declaration expected."),Argument_expression_expected:t(1135,e.DiagnosticCategory.Error,"Argument_expression_expected_1135","Argument expression expected."),Property_assignment_expected:t(1136,e.DiagnosticCategory.Error,"Property_assignment_expected_1136","Property assignment expected."),Expression_or_comma_expected:t(1137,e.DiagnosticCategory.Error,"Expression_or_comma_expected_1137","Expression or comma expected."),Parameter_declaration_expected:t(1138,e.DiagnosticCategory.Error,"Parameter_declaration_expected_1138","Parameter declaration expected."),Type_parameter_declaration_expected:t(1139,e.DiagnosticCategory.Error,"Type_parameter_declaration_expected_1139","Type parameter declaration expected."),Type_argument_expected:t(1140,e.DiagnosticCategory.Error,"Type_argument_expected_1140","Type argument expected."),String_literal_expected:t(1141,e.DiagnosticCategory.Error,"String_literal_expected_1141","String literal expected."),Line_break_not_permitted_here:t(1142,e.DiagnosticCategory.Error,"Line_break_not_permitted_here_1142","Line break not permitted here."),or_expected:t(1144,e.DiagnosticCategory.Error,"or_expected_1144","'{' or ';' expected."),Declaration_expected:t(1146,e.DiagnosticCategory.Error,"Declaration_expected_1146","Declaration expected."),Import_declarations_in_a_namespace_cannot_reference_a_module:t(1147,e.DiagnosticCategory.Error,"Import_declarations_in_a_namespace_cannot_reference_a_module_1147","Import declarations in a namespace cannot reference a module."),Cannot_use_imports_exports_or_module_augmentations_when_module_is_none:t(1148,e.DiagnosticCategory.Error,"Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148","Cannot use imports, exports, or module augmentations when '--module' is 'none'."),File_name_0_differs_from_already_included_file_name_1_only_in_casing:t(1149,e.DiagnosticCategory.Error,"File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149","File name '{0}' differs from already included file name '{1}' only in casing."),const_declarations_must_be_initialized:t(1155,e.DiagnosticCategory.Error,"const_declarations_must_be_initialized_1155","'const' declarations must be initialized."),const_declarations_can_only_be_declared_inside_a_block:t(1156,e.DiagnosticCategory.Error,"const_declarations_can_only_be_declared_inside_a_block_1156","'const' declarations can only be declared inside a block."),let_declarations_can_only_be_declared_inside_a_block:t(1157,e.DiagnosticCategory.Error,"let_declarations_can_only_be_declared_inside_a_block_1157","'let' declarations can only be declared inside a block."),Unterminated_template_literal:t(1160,e.DiagnosticCategory.Error,"Unterminated_template_literal_1160","Unterminated template literal."),Unterminated_regular_expression_literal:t(1161,e.DiagnosticCategory.Error,"Unterminated_regular_expression_literal_1161","Unterminated regular expression literal."),An_object_member_cannot_be_declared_optional:t(1162,e.DiagnosticCategory.Error,"An_object_member_cannot_be_declared_optional_1162","An object member cannot be declared optional."),A_yield_expression_is_only_allowed_in_a_generator_body:t(1163,e.DiagnosticCategory.Error,"A_yield_expression_is_only_allowed_in_a_generator_body_1163","A 'yield' expression is only allowed in a generator body."),Computed_property_names_are_not_allowed_in_enums:t(1164,e.DiagnosticCategory.Error,"Computed_property_names_are_not_allowed_in_enums_1164","Computed property names are not allowed in enums."),A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1165,e.DiagnosticCategory.Error,"A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165","A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_symbol_type:t(1166,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_1166","A computed property name in a class property declaration must have a simple literal type or a 'unique symbol' type."),A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1168,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168","A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1169,e.DiagnosticCategory.Error,"A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169","A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type:t(1170,e.DiagnosticCategory.Error,"A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170","A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),A_comma_expression_is_not_allowed_in_a_computed_property_name:t(1171,e.DiagnosticCategory.Error,"A_comma_expression_is_not_allowed_in_a_computed_property_name_1171","A comma expression is not allowed in a computed property name."),extends_clause_already_seen:t(1172,e.DiagnosticCategory.Error,"extends_clause_already_seen_1172","'extends' clause already seen."),extends_clause_must_precede_implements_clause:t(1173,e.DiagnosticCategory.Error,"extends_clause_must_precede_implements_clause_1173","'extends' clause must precede 'implements' clause."),Classes_can_only_extend_a_single_class:t(1174,e.DiagnosticCategory.Error,"Classes_can_only_extend_a_single_class_1174","Classes can only extend a single class."),implements_clause_already_seen:t(1175,e.DiagnosticCategory.Error,"implements_clause_already_seen_1175","'implements' clause already seen."),Interface_declaration_cannot_have_implements_clause:t(1176,e.DiagnosticCategory.Error,"Interface_declaration_cannot_have_implements_clause_1176","Interface declaration cannot have 'implements' clause."),Binary_digit_expected:t(1177,e.DiagnosticCategory.Error,"Binary_digit_expected_1177","Binary digit expected."),Octal_digit_expected:t(1178,e.DiagnosticCategory.Error,"Octal_digit_expected_1178","Octal digit expected."),Unexpected_token_expected:t(1179,e.DiagnosticCategory.Error,"Unexpected_token_expected_1179","Unexpected token. '{' expected."),Property_destructuring_pattern_expected:t(1180,e.DiagnosticCategory.Error,"Property_destructuring_pattern_expected_1180","Property destructuring pattern expected."),Array_element_destructuring_pattern_expected:t(1181,e.DiagnosticCategory.Error,"Array_element_destructuring_pattern_expected_1181","Array element destructuring pattern expected."),A_destructuring_declaration_must_have_an_initializer:t(1182,e.DiagnosticCategory.Error,"A_destructuring_declaration_must_have_an_initializer_1182","A destructuring declaration must have an initializer."),An_implementation_cannot_be_declared_in_ambient_contexts:t(1183,e.DiagnosticCategory.Error,"An_implementation_cannot_be_declared_in_ambient_contexts_1183","An implementation cannot be declared in ambient contexts."),Modifiers_cannot_appear_here:t(1184,e.DiagnosticCategory.Error,"Modifiers_cannot_appear_here_1184","Modifiers cannot appear here."),Merge_conflict_marker_encountered:t(1185,e.DiagnosticCategory.Error,"Merge_conflict_marker_encountered_1185","Merge conflict marker encountered."),A_rest_element_cannot_have_an_initializer:t(1186,e.DiagnosticCategory.Error,"A_rest_element_cannot_have_an_initializer_1186","A rest element cannot have an initializer."),A_parameter_property_may_not_be_declared_using_a_binding_pattern:t(1187,e.DiagnosticCategory.Error,"A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187","A parameter property may not be declared using a binding pattern."),Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement:t(1188,e.DiagnosticCategory.Error,"Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188","Only a single variable declaration is allowed in a 'for...of' statement."),The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer:t(1189,e.DiagnosticCategory.Error,"The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189","The variable declaration of a 'for...in' statement cannot have an initializer."),The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer:t(1190,e.DiagnosticCategory.Error,"The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190","The variable declaration of a 'for...of' statement cannot have an initializer."),An_import_declaration_cannot_have_modifiers:t(1191,e.DiagnosticCategory.Error,"An_import_declaration_cannot_have_modifiers_1191","An import declaration cannot have modifiers."),Module_0_has_no_default_export:t(1192,e.DiagnosticCategory.Error,"Module_0_has_no_default_export_1192","Module '{0}' has no default export."),An_export_declaration_cannot_have_modifiers:t(1193,e.DiagnosticCategory.Error,"An_export_declaration_cannot_have_modifiers_1193","An export declaration cannot have modifiers."),Export_declarations_are_not_permitted_in_a_namespace:t(1194,e.DiagnosticCategory.Error,"Export_declarations_are_not_permitted_in_a_namespace_1194","Export declarations are not permitted in a namespace."),export_Asterisk_does_not_re_export_a_default:t(1195,e.DiagnosticCategory.Error,"export_Asterisk_does_not_re_export_a_default_1195","'export *' does not re-export a default."),Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified:t(1196,e.DiagnosticCategory.Error,"Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified_1196","Catch clause variable type annotation must be 'any' or 'unknown' if specified."),Catch_clause_variable_cannot_have_an_initializer:t(1197,e.DiagnosticCategory.Error,"Catch_clause_variable_cannot_have_an_initializer_1197","Catch clause variable cannot have an initializer."),An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive:t(1198,e.DiagnosticCategory.Error,"An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198","An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),Unterminated_Unicode_escape_sequence:t(1199,e.DiagnosticCategory.Error,"Unterminated_Unicode_escape_sequence_1199","Unterminated Unicode escape sequence."),Line_terminator_not_permitted_before_arrow:t(1200,e.DiagnosticCategory.Error,"Line_terminator_not_permitted_before_arrow_1200","Line terminator not permitted before arrow."),Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead:t(1202,e.DiagnosticCategory.Error,"Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202","Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from \"mod\"', 'import {a} from \"mod\"', 'import d from \"mod\"', or another module format instead."),Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead:t(1203,e.DiagnosticCategory.Error,"Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203","Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type:t(1205,e.DiagnosticCategory.Error,"Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205","Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),Decorators_are_not_valid_here:t(1206,e.DiagnosticCategory.Error,"Decorators_are_not_valid_here_1206","Decorators are not valid here."),Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name:t(1207,e.DiagnosticCategory.Error,"Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207","Decorators cannot be applied to multiple get/set accessors of the same name."),_0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_import_export_or_an_empty_export_statement_to_make_it_a_module:t(1208,e.DiagnosticCategory.Error,"_0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_imp_1208","'{0}' cannot be compiled under '--isolatedModules' because it is considered a global script file. Add an import, export, or an empty 'export {}' statement to make it a module."),Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of_0_For_more_information_see_https_Colon_Slash_Slashdeveloper_mozilla_org_Slashen_US_Slashdocs_SlashWeb_SlashJavaScript_SlashReference_SlashStrict_mode:t(1210,e.DiagnosticCategory.Error,"Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of__1210","Code contained in a class is evaluated in JavaScript's strict mode which does not allow this use of '{0}'. For more information, see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode."),A_class_declaration_without_the_default_modifier_must_have_a_name:t(1211,e.DiagnosticCategory.Error,"A_class_declaration_without_the_default_modifier_must_have_a_name_1211","A class declaration without the 'default' modifier must have a name."),Identifier_expected_0_is_a_reserved_word_in_strict_mode:t(1212,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212","Identifier expected. '{0}' is a reserved word in strict mode."),Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode:t(1213,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213","Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode:t(1214,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214","Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),Invalid_use_of_0_Modules_are_automatically_in_strict_mode:t(1215,e.DiagnosticCategory.Error,"Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215","Invalid use of '{0}'. Modules are automatically in strict mode."),Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules:t(1216,e.DiagnosticCategory.Error,"Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216","Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),Export_assignment_is_not_supported_when_module_flag_is_system:t(1218,e.DiagnosticCategory.Error,"Export_assignment_is_not_supported_when_module_flag_is_system_1218","Export assignment is not supported when '--module' flag is 'system'."),Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning:t(1219,e.DiagnosticCategory.Error,"Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219","Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),Generators_are_not_allowed_in_an_ambient_context:t(1221,e.DiagnosticCategory.Error,"Generators_are_not_allowed_in_an_ambient_context_1221","Generators are not allowed in an ambient context."),An_overload_signature_cannot_be_declared_as_a_generator:t(1222,e.DiagnosticCategory.Error,"An_overload_signature_cannot_be_declared_as_a_generator_1222","An overload signature cannot be declared as a generator."),_0_tag_already_specified:t(1223,e.DiagnosticCategory.Error,"_0_tag_already_specified_1223","'{0}' tag already specified."),Signature_0_must_be_a_type_predicate:t(1224,e.DiagnosticCategory.Error,"Signature_0_must_be_a_type_predicate_1224","Signature '{0}' must be a type predicate."),Cannot_find_parameter_0:t(1225,e.DiagnosticCategory.Error,"Cannot_find_parameter_0_1225","Cannot find parameter '{0}'."),Type_predicate_0_is_not_assignable_to_1:t(1226,e.DiagnosticCategory.Error,"Type_predicate_0_is_not_assignable_to_1_1226","Type predicate '{0}' is not assignable to '{1}'."),Parameter_0_is_not_in_the_same_position_as_parameter_1:t(1227,e.DiagnosticCategory.Error,"Parameter_0_is_not_in_the_same_position_as_parameter_1_1227","Parameter '{0}' is not in the same position as parameter '{1}'."),A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods:t(1228,e.DiagnosticCategory.Error,"A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228","A type predicate is only allowed in return type position for functions and methods."),A_type_predicate_cannot_reference_a_rest_parameter:t(1229,e.DiagnosticCategory.Error,"A_type_predicate_cannot_reference_a_rest_parameter_1229","A type predicate cannot reference a rest parameter."),A_type_predicate_cannot_reference_element_0_in_a_binding_pattern:t(1230,e.DiagnosticCategory.Error,"A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230","A type predicate cannot reference element '{0}' in a binding pattern."),An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration:t(1231,e.DiagnosticCategory.Error,"An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration_1231","An export assignment must be at the top level of a file or module declaration."),An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module:t(1232,e.DiagnosticCategory.Error,"An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1232","An import declaration can only be used at the top level of a namespace or module."),An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module:t(1233,e.DiagnosticCategory.Error,"An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1233","An export declaration can only be used at the top level of a namespace or module."),An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file:t(1234,e.DiagnosticCategory.Error,"An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234","An ambient module declaration is only allowed at the top level in a file."),A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module:t(1235,e.DiagnosticCategory.Error,"A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module_1235","A namespace declaration is only allowed at the top level of a namespace or module."),The_return_type_of_a_property_decorator_function_must_be_either_void_or_any:t(1236,e.DiagnosticCategory.Error,"The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236","The return type of a property decorator function must be either 'void' or 'any'."),The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any:t(1237,e.DiagnosticCategory.Error,"The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237","The return type of a parameter decorator function must be either 'void' or 'any'."),Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression:t(1238,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238","Unable to resolve signature of class decorator when called as an expression."),Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression:t(1239,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239","Unable to resolve signature of parameter decorator when called as an expression."),Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression:t(1240,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240","Unable to resolve signature of property decorator when called as an expression."),Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression:t(1241,e.DiagnosticCategory.Error,"Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241","Unable to resolve signature of method decorator when called as an expression."),abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration:t(1242,e.DiagnosticCategory.Error,"abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242","'abstract' modifier can only appear on a class, method, or property declaration."),_0_modifier_cannot_be_used_with_1_modifier:t(1243,e.DiagnosticCategory.Error,"_0_modifier_cannot_be_used_with_1_modifier_1243","'{0}' modifier cannot be used with '{1}' modifier."),Abstract_methods_can_only_appear_within_an_abstract_class:t(1244,e.DiagnosticCategory.Error,"Abstract_methods_can_only_appear_within_an_abstract_class_1244","Abstract methods can only appear within an abstract class."),Method_0_cannot_have_an_implementation_because_it_is_marked_abstract:t(1245,e.DiagnosticCategory.Error,"Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245","Method '{0}' cannot have an implementation because it is marked abstract."),An_interface_property_cannot_have_an_initializer:t(1246,e.DiagnosticCategory.Error,"An_interface_property_cannot_have_an_initializer_1246","An interface property cannot have an initializer."),A_type_literal_property_cannot_have_an_initializer:t(1247,e.DiagnosticCategory.Error,"A_type_literal_property_cannot_have_an_initializer_1247","A type literal property cannot have an initializer."),A_class_member_cannot_have_the_0_keyword:t(1248,e.DiagnosticCategory.Error,"A_class_member_cannot_have_the_0_keyword_1248","A class member cannot have the '{0}' keyword."),A_decorator_can_only_decorate_a_method_implementation_not_an_overload:t(1249,e.DiagnosticCategory.Error,"A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249","A decorator can only decorate a method implementation, not an overload."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5:t(1250,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode:t(1251,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode:t(1252,e.DiagnosticCategory.Error,"Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252","Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference:t(1254,e.DiagnosticCategory.Error,"A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254","A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),A_definite_assignment_assertion_is_not_permitted_in_this_context:t(1255,e.DiagnosticCategory.Error,"A_definite_assignment_assertion_is_not_permitted_in_this_context_1255","A definite assignment assertion '!' is not permitted in this context."),A_required_element_cannot_follow_an_optional_element:t(1257,e.DiagnosticCategory.Error,"A_required_element_cannot_follow_an_optional_element_1257","A required element cannot follow an optional element."),A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration:t(1258,e.DiagnosticCategory.Error,"A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration_1258","A default export must be at the top level of a file or module declaration."),Module_0_can_only_be_default_imported_using_the_1_flag:t(1259,e.DiagnosticCategory.Error,"Module_0_can_only_be_default_imported_using_the_1_flag_1259","Module '{0}' can only be default-imported using the '{1}' flag"),Keywords_cannot_contain_escape_characters:t(1260,e.DiagnosticCategory.Error,"Keywords_cannot_contain_escape_characters_1260","Keywords cannot contain escape characters."),Already_included_file_name_0_differs_from_file_name_1_only_in_casing:t(1261,e.DiagnosticCategory.Error,"Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261","Already included file name '{0}' differs from file name '{1}' only in casing."),Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module:t(1262,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module_1262","Identifier expected. '{0}' is a reserved word at the top-level of a module."),Declarations_with_initializers_cannot_also_have_definite_assignment_assertions:t(1263,e.DiagnosticCategory.Error,"Declarations_with_initializers_cannot_also_have_definite_assignment_assertions_1263","Declarations with initializers cannot also have definite assignment assertions."),Declarations_with_definite_assignment_assertions_must_also_have_type_annotations:t(1264,e.DiagnosticCategory.Error,"Declarations_with_definite_assignment_assertions_must_also_have_type_annotations_1264","Declarations with definite assignment assertions must also have type annotations."),A_rest_element_cannot_follow_another_rest_element:t(1265,e.DiagnosticCategory.Error,"A_rest_element_cannot_follow_another_rest_element_1265","A rest element cannot follow another rest element."),An_optional_element_cannot_follow_a_rest_element:t(1266,e.DiagnosticCategory.Error,"An_optional_element_cannot_follow_a_rest_element_1266","An optional element cannot follow a rest element."),Property_0_cannot_have_an_initializer_because_it_is_marked_abstract:t(1267,e.DiagnosticCategory.Error,"Property_0_cannot_have_an_initializer_because_it_is_marked_abstract_1267","Property '{0}' cannot have an initializer because it is marked abstract."),An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type:t(1268,e.DiagnosticCategory.Error,"An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type_1268","An index signature parameter type must be 'string', 'number', 'symbol', or a template literal type."),Cannot_use_export_import_on_a_type_or_type_only_namespace_when_the_isolatedModules_flag_is_provided:t(1269,e.DiagnosticCategory.Error,"Cannot_use_export_import_on_a_type_or_type_only_namespace_when_the_isolatedModules_flag_is_provided_1269","Cannot use 'export import' on a type or type-only namespace when the '--isolatedModules' flag is provided."),Decorator_function_return_type_0_is_not_assignable_to_type_1:t(1270,e.DiagnosticCategory.Error,"Decorator_function_return_type_0_is_not_assignable_to_type_1_1270","Decorator function return type '{0}' is not assignable to type '{1}'."),Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any:t(1271,e.DiagnosticCategory.Error,"Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any_1271","Decorator function return type is '{0}' but is expected to be 'void' or 'any'."),A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_when_isolatedModules_and_emitDecoratorMetadata_are_enabled:t(1272,e.DiagnosticCategory.Error,"A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_w_1272","A type referenced in a decorated signature must be imported with 'import type' or a namespace import when 'isolatedModules' and 'emitDecoratorMetadata' are enabled."),_0_modifier_cannot_appear_on_a_type_parameter:t(1273,e.DiagnosticCategory.Error,"_0_modifier_cannot_appear_on_a_type_parameter_1273","'{0}' modifier cannot appear on a type parameter"),_0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias:t(1274,e.DiagnosticCategory.Error,"_0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias_1274","'{0}' modifier can only appear on a type parameter of a class, interface or type alias"),with_statements_are_not_allowed_in_an_async_function_block:t(1300,e.DiagnosticCategory.Error,"with_statements_are_not_allowed_in_an_async_function_block_1300","'with' statements are not allowed in an async function block."),await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules:t(1308,e.DiagnosticCategory.Error,"await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308","'await' expressions are only allowed within async functions and at the top levels of modules."),The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level:t(1309,e.DiagnosticCategory.Error,"The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level_1309","The current file is a CommonJS module and cannot use 'await' at the top level."),Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_part_of_a_destructuring_pattern:t(1312,e.DiagnosticCategory.Error,"Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_1312","Did you mean to use a ':'? An '=' can only follow a property name when the containing object literal is part of a destructuring pattern."),The_body_of_an_if_statement_cannot_be_the_empty_statement:t(1313,e.DiagnosticCategory.Error,"The_body_of_an_if_statement_cannot_be_the_empty_statement_1313","The body of an 'if' statement cannot be the empty statement."),Global_module_exports_may_only_appear_in_module_files:t(1314,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_in_module_files_1314","Global module exports may only appear in module files."),Global_module_exports_may_only_appear_in_declaration_files:t(1315,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_in_declaration_files_1315","Global module exports may only appear in declaration files."),Global_module_exports_may_only_appear_at_top_level:t(1316,e.DiagnosticCategory.Error,"Global_module_exports_may_only_appear_at_top_level_1316","Global module exports may only appear at top level."),A_parameter_property_cannot_be_declared_using_a_rest_parameter:t(1317,e.DiagnosticCategory.Error,"A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317","A parameter property cannot be declared using a rest parameter."),An_abstract_accessor_cannot_have_an_implementation:t(1318,e.DiagnosticCategory.Error,"An_abstract_accessor_cannot_have_an_implementation_1318","An abstract accessor cannot have an implementation."),A_default_export_can_only_be_used_in_an_ECMAScript_style_module:t(1319,e.DiagnosticCategory.Error,"A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319","A default export can only be used in an ECMAScript-style module."),Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1320,e.DiagnosticCategory.Error,"Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320","Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1321,e.DiagnosticCategory.Error,"Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321","Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member:t(1322,e.DiagnosticCategory.Error,"Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322","Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd_system_umd_node16_or_nodenext:t(1323,e.DiagnosticCategory.Error,"Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd__1323","Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'es2022', 'esnext', 'commonjs', 'amd', 'system', 'umd', 'node16', or 'nodenext'."),Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nodenext:t(1324,e.DiagnosticCategory.Error,"Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nod_1324","Dynamic imports only support a second argument when the '--module' option is set to 'esnext', 'node16', or 'nodenext'."),Argument_of_dynamic_import_cannot_be_spread_element:t(1325,e.DiagnosticCategory.Error,"Argument_of_dynamic_import_cannot_be_spread_element_1325","Argument of dynamic import cannot be spread element."),This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot_have_type_arguments:t(1326,e.DiagnosticCategory.Error,"This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot__1326","This use of 'import' is invalid. 'import()' calls can be written, but they must have parentheses and cannot have type arguments."),String_literal_with_double_quotes_expected:t(1327,e.DiagnosticCategory.Error,"String_literal_with_double_quotes_expected_1327","String literal with double quotes expected."),Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal:t(1328,e.DiagnosticCategory.Error,"Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328","Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0:t(1329,e.DiagnosticCategory.Error,"_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329","'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly:t(1330,e.DiagnosticCategory.Error,"A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330","A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly:t(1331,e.DiagnosticCategory.Error,"A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331","A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),A_variable_whose_type_is_a_unique_symbol_type_must_be_const:t(1332,e.DiagnosticCategory.Error,"A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332","A variable whose type is a 'unique symbol' type must be 'const'."),unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name:t(1333,e.DiagnosticCategory.Error,"unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333","'unique symbol' types may not be used on a variable declaration with a binding name."),unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement:t(1334,e.DiagnosticCategory.Error,"unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334","'unique symbol' types are only allowed on variables in a variable statement."),unique_symbol_types_are_not_allowed_here:t(1335,e.DiagnosticCategory.Error,"unique_symbol_types_are_not_allowed_here_1335","'unique symbol' types are not allowed here."),An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_object_type_instead:t(1337,e.DiagnosticCategory.Error,"An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_o_1337","An index signature parameter type cannot be a literal type or generic type. Consider using a mapped object type instead."),infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type:t(1338,e.DiagnosticCategory.Error,"infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338","'infer' declarations are only permitted in the 'extends' clause of a conditional type."),Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here:t(1339,e.DiagnosticCategory.Error,"Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339","Module '{0}' does not refer to a value, but is used as a value here."),Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0:t(1340,e.DiagnosticCategory.Error,"Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340","Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),Type_arguments_cannot_be_used_here:t(1342,e.DiagnosticCategory.Error,"Type_arguments_cannot_be_used_here_1342","Type arguments cannot be used here."),The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system_node16_or_nodenext:t(1343,e.DiagnosticCategory.Error,"The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system__1343","The 'import.meta' meta-property is only allowed when the '--module' option is 'es2020', 'es2022', 'esnext', 'system', 'node16', or 'nodenext'."),A_label_is_not_allowed_here:t(1344,e.DiagnosticCategory.Error,"A_label_is_not_allowed_here_1344","'A label is not allowed here."),An_expression_of_type_void_cannot_be_tested_for_truthiness:t(1345,e.DiagnosticCategory.Error,"An_expression_of_type_void_cannot_be_tested_for_truthiness_1345","An expression of type 'void' cannot be tested for truthiness."),This_parameter_is_not_allowed_with_use_strict_directive:t(1346,e.DiagnosticCategory.Error,"This_parameter_is_not_allowed_with_use_strict_directive_1346","This parameter is not allowed with 'use strict' directive."),use_strict_directive_cannot_be_used_with_non_simple_parameter_list:t(1347,e.DiagnosticCategory.Error,"use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347","'use strict' directive cannot be used with non-simple parameter list."),Non_simple_parameter_declared_here:t(1348,e.DiagnosticCategory.Error,"Non_simple_parameter_declared_here_1348","Non-simple parameter declared here."),use_strict_directive_used_here:t(1349,e.DiagnosticCategory.Error,"use_strict_directive_used_here_1349","'use strict' directive used here."),Print_the_final_configuration_instead_of_building:t(1350,e.DiagnosticCategory.Message,"Print_the_final_configuration_instead_of_building_1350","Print the final configuration instead of building."),An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal:t(1351,e.DiagnosticCategory.Error,"An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351","An identifier or keyword cannot immediately follow a numeric literal."),A_bigint_literal_cannot_use_exponential_notation:t(1352,e.DiagnosticCategory.Error,"A_bigint_literal_cannot_use_exponential_notation_1352","A bigint literal cannot use exponential notation."),A_bigint_literal_must_be_an_integer:t(1353,e.DiagnosticCategory.Error,"A_bigint_literal_must_be_an_integer_1353","A bigint literal must be an integer."),readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types:t(1354,e.DiagnosticCategory.Error,"readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354","'readonly' type modifier is only permitted on array and tuple literal types."),A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals:t(1355,e.DiagnosticCategory.Error,"A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355","A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),Did_you_mean_to_mark_this_function_as_async:t(1356,e.DiagnosticCategory.Error,"Did_you_mean_to_mark_this_function_as_async_1356","Did you mean to mark this function as 'async'?"),An_enum_member_name_must_be_followed_by_a_or:t(1357,e.DiagnosticCategory.Error,"An_enum_member_name_must_be_followed_by_a_or_1357","An enum member name must be followed by a ',', '=', or '}'."),Tagged_template_expressions_are_not_permitted_in_an_optional_chain:t(1358,e.DiagnosticCategory.Error,"Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358","Tagged template expressions are not permitted in an optional chain."),Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here:t(1359,e.DiagnosticCategory.Error,"Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359","Identifier expected. '{0}' is a reserved word that cannot be used here."),_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type:t(1361,e.DiagnosticCategory.Error,"_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361","'{0}' cannot be used as a value because it was imported using 'import type'."),_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type:t(1362,e.DiagnosticCategory.Error,"_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362","'{0}' cannot be used as a value because it was exported using 'export type'."),A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both:t(1363,e.DiagnosticCategory.Error,"A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363","A type-only import can specify a default import or named bindings, but not both."),Convert_to_type_only_export:t(1364,e.DiagnosticCategory.Message,"Convert_to_type_only_export_1364","Convert to type-only export"),Convert_all_re_exported_types_to_type_only_exports:t(1365,e.DiagnosticCategory.Message,"Convert_all_re_exported_types_to_type_only_exports_1365","Convert all re-exported types to type-only exports"),Split_into_two_separate_import_declarations:t(1366,e.DiagnosticCategory.Message,"Split_into_two_separate_import_declarations_1366","Split into two separate import declarations"),Split_all_invalid_type_only_imports:t(1367,e.DiagnosticCategory.Message,"Split_all_invalid_type_only_imports_1367","Split all invalid type-only imports"),Did_you_mean_0:t(1369,e.DiagnosticCategory.Message,"Did_you_mean_0_1369","Did you mean '{0}'?"),This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set_to_error:t(1371,e.DiagnosticCategory.Error,"This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set__1371","This import is never used as a value and must use 'import type' because 'importsNotUsedAsValues' is set to 'error'."),Convert_to_type_only_import:t(1373,e.DiagnosticCategory.Message,"Convert_to_type_only_import_1373","Convert to type-only import"),Convert_all_imports_not_used_as_a_value_to_type_only_imports:t(1374,e.DiagnosticCategory.Message,"Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374","Convert all imports not used as a value to type-only imports"),await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module:t(1375,e.DiagnosticCategory.Error,"await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375","'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),_0_was_imported_here:t(1376,e.DiagnosticCategory.Message,"_0_was_imported_here_1376","'{0}' was imported here."),_0_was_exported_here:t(1377,e.DiagnosticCategory.Message,"_0_was_exported_here_1377","'{0}' was exported here."),Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher:t(1378,e.DiagnosticCategory.Error,"Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_n_1378","Top-level 'await' expressions are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type:t(1379,e.DiagnosticCategory.Error,"An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379","An import alias cannot reference a declaration that was exported using 'export type'."),An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type:t(1380,e.DiagnosticCategory.Error,"An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380","An import alias cannot reference a declaration that was imported using 'import type'."),Unexpected_token_Did_you_mean_or_rbrace:t(1381,e.DiagnosticCategory.Error,"Unexpected_token_Did_you_mean_or_rbrace_1381","Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),Unexpected_token_Did_you_mean_or_gt:t(1382,e.DiagnosticCategory.Error,"Unexpected_token_Did_you_mean_or_gt_1382","Unexpected token. Did you mean `{'>'}` or `&gt;`?"),Only_named_exports_may_use_export_type:t(1383,e.DiagnosticCategory.Error,"Only_named_exports_may_use_export_type_1383","Only named exports may use 'export type'."),Function_type_notation_must_be_parenthesized_when_used_in_a_union_type:t(1385,e.DiagnosticCategory.Error,"Function_type_notation_must_be_parenthesized_when_used_in_a_union_type_1385","Function type notation must be parenthesized when used in a union type."),Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type:t(1386,e.DiagnosticCategory.Error,"Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type_1386","Constructor type notation must be parenthesized when used in a union type."),Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type:t(1387,e.DiagnosticCategory.Error,"Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1387","Function type notation must be parenthesized when used in an intersection type."),Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type:t(1388,e.DiagnosticCategory.Error,"Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1388","Constructor type notation must be parenthesized when used in an intersection type."),_0_is_not_allowed_as_a_variable_declaration_name:t(1389,e.DiagnosticCategory.Error,"_0_is_not_allowed_as_a_variable_declaration_name_1389","'{0}' is not allowed as a variable declaration name."),_0_is_not_allowed_as_a_parameter_name:t(1390,e.DiagnosticCategory.Error,"_0_is_not_allowed_as_a_parameter_name_1390","'{0}' is not allowed as a parameter name."),An_import_alias_cannot_use_import_type:t(1392,e.DiagnosticCategory.Error,"An_import_alias_cannot_use_import_type_1392","An import alias cannot use 'import type'"),Imported_via_0_from_file_1:t(1393,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_1393","Imported via {0} from file '{1}'"),Imported_via_0_from_file_1_with_packageId_2:t(1394,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_with_packageId_2_1394","Imported via {0} from file '{1}' with packageId '{2}'"),Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions:t(1395,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions_1395","Imported via {0} from file '{1}' to import 'importHelpers' as specified in compilerOptions"),Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions:t(1396,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions_1396","Imported via {0} from file '{1}' with packageId '{2}' to import 'importHelpers' as specified in compilerOptions"),Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions:t(1397,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions_1397","Imported via {0} from file '{1}' to import 'jsx' and 'jsxs' factory functions"),Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions:t(1398,e.DiagnosticCategory.Message,"Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions_1398","Imported via {0} from file '{1}' with packageId '{2}' to import 'jsx' and 'jsxs' factory functions"),File_is_included_via_import_here:t(1399,e.DiagnosticCategory.Message,"File_is_included_via_import_here_1399","File is included via import here."),Referenced_via_0_from_file_1:t(1400,e.DiagnosticCategory.Message,"Referenced_via_0_from_file_1_1400","Referenced via '{0}' from file '{1}'"),File_is_included_via_reference_here:t(1401,e.DiagnosticCategory.Message,"File_is_included_via_reference_here_1401","File is included via reference here."),Type_library_referenced_via_0_from_file_1:t(1402,e.DiagnosticCategory.Message,"Type_library_referenced_via_0_from_file_1_1402","Type library referenced via '{0}' from file '{1}'"),Type_library_referenced_via_0_from_file_1_with_packageId_2:t(1403,e.DiagnosticCategory.Message,"Type_library_referenced_via_0_from_file_1_with_packageId_2_1403","Type library referenced via '{0}' from file '{1}' with packageId '{2}'"),File_is_included_via_type_library_reference_here:t(1404,e.DiagnosticCategory.Message,"File_is_included_via_type_library_reference_here_1404","File is included via type library reference here."),Library_referenced_via_0_from_file_1:t(1405,e.DiagnosticCategory.Message,"Library_referenced_via_0_from_file_1_1405","Library referenced via '{0}' from file '{1}'"),File_is_included_via_library_reference_here:t(1406,e.DiagnosticCategory.Message,"File_is_included_via_library_reference_here_1406","File is included via library reference here."),Matched_by_include_pattern_0_in_1:t(1407,e.DiagnosticCategory.Message,"Matched_by_include_pattern_0_in_1_1407","Matched by include pattern '{0}' in '{1}'"),File_is_matched_by_include_pattern_specified_here:t(1408,e.DiagnosticCategory.Message,"File_is_matched_by_include_pattern_specified_here_1408","File is matched by include pattern specified here."),Part_of_files_list_in_tsconfig_json:t(1409,e.DiagnosticCategory.Message,"Part_of_files_list_in_tsconfig_json_1409","Part of 'files' list in tsconfig.json"),File_is_matched_by_files_list_specified_here:t(1410,e.DiagnosticCategory.Message,"File_is_matched_by_files_list_specified_here_1410","File is matched by 'files' list specified here."),Output_from_referenced_project_0_included_because_1_specified:t(1411,e.DiagnosticCategory.Message,"Output_from_referenced_project_0_included_because_1_specified_1411","Output from referenced project '{0}' included because '{1}' specified"),Output_from_referenced_project_0_included_because_module_is_specified_as_none:t(1412,e.DiagnosticCategory.Message,"Output_from_referenced_project_0_included_because_module_is_specified_as_none_1412","Output from referenced project '{0}' included because '--module' is specified as 'none'"),File_is_output_from_referenced_project_specified_here:t(1413,e.DiagnosticCategory.Message,"File_is_output_from_referenced_project_specified_here_1413","File is output from referenced project specified here."),Source_from_referenced_project_0_included_because_1_specified:t(1414,e.DiagnosticCategory.Message,"Source_from_referenced_project_0_included_because_1_specified_1414","Source from referenced project '{0}' included because '{1}' specified"),Source_from_referenced_project_0_included_because_module_is_specified_as_none:t(1415,e.DiagnosticCategory.Message,"Source_from_referenced_project_0_included_because_module_is_specified_as_none_1415","Source from referenced project '{0}' included because '--module' is specified as 'none'"),File_is_source_from_referenced_project_specified_here:t(1416,e.DiagnosticCategory.Message,"File_is_source_from_referenced_project_specified_here_1416","File is source from referenced project specified here."),Entry_point_of_type_library_0_specified_in_compilerOptions:t(1417,e.DiagnosticCategory.Message,"Entry_point_of_type_library_0_specified_in_compilerOptions_1417","Entry point of type library '{0}' specified in compilerOptions"),Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1:t(1418,e.DiagnosticCategory.Message,"Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1_1418","Entry point of type library '{0}' specified in compilerOptions with packageId '{1}'"),File_is_entry_point_of_type_library_specified_here:t(1419,e.DiagnosticCategory.Message,"File_is_entry_point_of_type_library_specified_here_1419","File is entry point of type library specified here."),Entry_point_for_implicit_type_library_0:t(1420,e.DiagnosticCategory.Message,"Entry_point_for_implicit_type_library_0_1420","Entry point for implicit type library '{0}'"),Entry_point_for_implicit_type_library_0_with_packageId_1:t(1421,e.DiagnosticCategory.Message,"Entry_point_for_implicit_type_library_0_with_packageId_1_1421","Entry point for implicit type library '{0}' with packageId '{1}'"),Library_0_specified_in_compilerOptions:t(1422,e.DiagnosticCategory.Message,"Library_0_specified_in_compilerOptions_1422","Library '{0}' specified in compilerOptions"),File_is_library_specified_here:t(1423,e.DiagnosticCategory.Message,"File_is_library_specified_here_1423","File is library specified here."),Default_library:t(1424,e.DiagnosticCategory.Message,"Default_library_1424","Default library"),Default_library_for_target_0:t(1425,e.DiagnosticCategory.Message,"Default_library_for_target_0_1425","Default library for target '{0}'"),File_is_default_library_for_target_specified_here:t(1426,e.DiagnosticCategory.Message,"File_is_default_library_for_target_specified_here_1426","File is default library for target specified here."),Root_file_specified_for_compilation:t(1427,e.DiagnosticCategory.Message,"Root_file_specified_for_compilation_1427","Root file specified for compilation"),File_is_output_of_project_reference_source_0:t(1428,e.DiagnosticCategory.Message,"File_is_output_of_project_reference_source_0_1428","File is output of project reference source '{0}'"),File_redirects_to_file_0:t(1429,e.DiagnosticCategory.Message,"File_redirects_to_file_0_1429","File redirects to file '{0}'"),The_file_is_in_the_program_because_Colon:t(1430,e.DiagnosticCategory.Message,"The_file_is_in_the_program_because_Colon_1430","The file is in the program because:"),for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module:t(1431,e.DiagnosticCategory.Error,"for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_1431","'for await' loops are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher:t(1432,e.DiagnosticCategory.Error,"Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_nod_1432","Top-level 'for await' loops are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),Decorators_may_not_be_applied_to_this_parameters:t(1433,e.DiagnosticCategory.Error,"Decorators_may_not_be_applied_to_this_parameters_1433","Decorators may not be applied to 'this' parameters."),Unexpected_keyword_or_identifier:t(1434,e.DiagnosticCategory.Error,"Unexpected_keyword_or_identifier_1434","Unexpected keyword or identifier."),Unknown_keyword_or_identifier_Did_you_mean_0:t(1435,e.DiagnosticCategory.Error,"Unknown_keyword_or_identifier_Did_you_mean_0_1435","Unknown keyword or identifier. Did you mean '{0}'?"),Decorators_must_precede_the_name_and_all_keywords_of_property_declarations:t(1436,e.DiagnosticCategory.Error,"Decorators_must_precede_the_name_and_all_keywords_of_property_declarations_1436","Decorators must precede the name and all keywords of property declarations."),Namespace_must_be_given_a_name:t(1437,e.DiagnosticCategory.Error,"Namespace_must_be_given_a_name_1437","Namespace must be given a name."),Interface_must_be_given_a_name:t(1438,e.DiagnosticCategory.Error,"Interface_must_be_given_a_name_1438","Interface must be given a name."),Type_alias_must_be_given_a_name:t(1439,e.DiagnosticCategory.Error,"Type_alias_must_be_given_a_name_1439","Type alias must be given a name."),Variable_declaration_not_allowed_at_this_location:t(1440,e.DiagnosticCategory.Error,"Variable_declaration_not_allowed_at_this_location_1440","Variable declaration not allowed at this location."),Cannot_start_a_function_call_in_a_type_annotation:t(1441,e.DiagnosticCategory.Error,"Cannot_start_a_function_call_in_a_type_annotation_1441","Cannot start a function call in a type annotation."),Expected_for_property_initializer:t(1442,e.DiagnosticCategory.Error,"Expected_for_property_initializer_1442","Expected '=' for property initializer."),Module_declaration_names_may_only_use_or_quoted_strings:t(1443,e.DiagnosticCategory.Error,"Module_declaration_names_may_only_use_or_quoted_strings_1443","Module declaration names may only use ' or \" quoted strings."),_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled:t(1444,e.DiagnosticCategory.Error,"_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedMod_1444","'{0}' is a type and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled:t(1446,e.DiagnosticCategory.Error,"_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveVa_1446","'{0}' resolves to a type-only declaration and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),_0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isolatedModules_is_enabled:t(1448,e.DiagnosticCategory.Error,"_0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isol_1448","'{0}' resolves to a type-only declaration and must be re-exported using a type-only re-export when 'isolatedModules' is enabled."),Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed:t(1449,e.DiagnosticCategory.Message,"Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed_1449","Preserve unused imported values in the JavaScript output that would otherwise be removed."),Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments:t(1450,e.DiagnosticCategory.Message,"Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments_1450","Dynamic imports can only accept a module specifier and an optional assertion as arguments"),Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member_declaration_property_access_or_on_the_left_hand_side_of_an_in_expression:t(1451,e.DiagnosticCategory.Error,"Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member__1451","Private identifiers are only allowed in class bodies and may only be used as part of a class member declaration, property access, or on the left-hand-side of an 'in' expression"),resolution_mode_assertions_are_only_supported_when_moduleResolution_is_node16_or_nodenext:t(1452,e.DiagnosticCategory.Error,"resolution_mode_assertions_are_only_supported_when_moduleResolution_is_node16_or_nodenext_1452","'resolution-mode' assertions are only supported when `moduleResolution` is `node16` or `nodenext`."),resolution_mode_should_be_either_require_or_import:t(1453,e.DiagnosticCategory.Error,"resolution_mode_should_be_either_require_or_import_1453","`resolution-mode` should be either `require` or `import`."),resolution_mode_can_only_be_set_for_type_only_imports:t(1454,e.DiagnosticCategory.Error,"resolution_mode_can_only_be_set_for_type_only_imports_1454","`resolution-mode` can only be set for type-only imports."),resolution_mode_is_the_only_valid_key_for_type_import_assertions:t(1455,e.DiagnosticCategory.Error,"resolution_mode_is_the_only_valid_key_for_type_import_assertions_1455","`resolution-mode` is the only valid key for type import assertions."),Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require:t(1456,e.DiagnosticCategory.Error,"Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require_1456","Type import assertions should have exactly one key - `resolution-mode` - with value `import` or `require`."),The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output:t(1470,e.DiagnosticCategory.Error,"The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output_1470","The 'import.meta' meta-property is not allowed in files which will build into CommonJS output."),Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_cannot_be_imported_synchronously_Use_dynamic_import_instead:t(1471,e.DiagnosticCategory.Error,"Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_c_1471","Module '{0}' cannot be imported using this construct. The specifier only resolves to an ES module, which cannot be imported synchronously. Use dynamic import instead."),catch_or_finally_expected:t(1472,e.DiagnosticCategory.Error,"catch_or_finally_expected_1472","'catch' or 'finally' expected."),An_import_declaration_can_only_be_used_at_the_top_level_of_a_module:t(1473,e.DiagnosticCategory.Error,"An_import_declaration_can_only_be_used_at_the_top_level_of_a_module_1473","An import declaration can only be used at the top level of a module."),An_export_declaration_can_only_be_used_at_the_top_level_of_a_module:t(1474,e.DiagnosticCategory.Error,"An_export_declaration_can_only_be_used_at_the_top_level_of_a_module_1474","An export declaration can only be used at the top level of a module."),Control_what_method_is_used_to_detect_module_format_JS_files:t(1475,e.DiagnosticCategory.Message,"Control_what_method_is_used_to_detect_module_format_JS_files_1475","Control what method is used to detect module-format JS files."),auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_with_module_Colon_node16_as_modules:t(1476,e.DiagnosticCategory.Message,"auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_w_1476",'"auto": Treat files with imports, exports, import.meta, jsx (with jsx: react-jsx), or esm format (with module: node16+) as modules.'),The_types_of_0_are_incompatible_between_these_types:t(2200,e.DiagnosticCategory.Error,"The_types_of_0_are_incompatible_between_these_types_2200","The types of '{0}' are incompatible between these types."),The_types_returned_by_0_are_incompatible_between_these_types:t(2201,e.DiagnosticCategory.Error,"The_types_returned_by_0_are_incompatible_between_these_types_2201","The types returned by '{0}' are incompatible between these types."),Call_signature_return_types_0_and_1_are_incompatible:t(2202,e.DiagnosticCategory.Error,"Call_signature_return_types_0_and_1_are_incompatible_2202","Call signature return types '{0}' and '{1}' are incompatible.",void 0,!0),Construct_signature_return_types_0_and_1_are_incompatible:t(2203,e.DiagnosticCategory.Error,"Construct_signature_return_types_0_and_1_are_incompatible_2203","Construct signature return types '{0}' and '{1}' are incompatible.",void 0,!0),Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1:t(2204,e.DiagnosticCategory.Error,"Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204","Call signatures with no arguments have incompatible return types '{0}' and '{1}'.",void 0,!0),Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1:t(2205,e.DiagnosticCategory.Error,"Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205","Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.",void 0,!0),The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement:t(2206,e.DiagnosticCategory.Error,"The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement_2206","The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement."),The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement:t(2207,e.DiagnosticCategory.Error,"The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement_2207","The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement."),The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate:t(2209,e.DiagnosticCategory.Error,"The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_roo_2209","The project root is ambiguous, but is required to resolve export map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate:t(2210,e.DiagnosticCategory.Error,"The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_roo_2210","The project root is ambiguous, but is required to resolve import map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),Duplicate_identifier_0:t(2300,e.DiagnosticCategory.Error,"Duplicate_identifier_0_2300","Duplicate identifier '{0}'."),Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor:t(2301,e.DiagnosticCategory.Error,"Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301","Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),Static_members_cannot_reference_class_type_parameters:t(2302,e.DiagnosticCategory.Error,"Static_members_cannot_reference_class_type_parameters_2302","Static members cannot reference class type parameters."),Circular_definition_of_import_alias_0:t(2303,e.DiagnosticCategory.Error,"Circular_definition_of_import_alias_0_2303","Circular definition of import alias '{0}'."),Cannot_find_name_0:t(2304,e.DiagnosticCategory.Error,"Cannot_find_name_0_2304","Cannot find name '{0}'."),Module_0_has_no_exported_member_1:t(2305,e.DiagnosticCategory.Error,"Module_0_has_no_exported_member_1_2305","Module '{0}' has no exported member '{1}'."),File_0_is_not_a_module:t(2306,e.DiagnosticCategory.Error,"File_0_is_not_a_module_2306","File '{0}' is not a module."),Cannot_find_module_0_or_its_corresponding_type_declarations:t(2307,e.DiagnosticCategory.Error,"Cannot_find_module_0_or_its_corresponding_type_declarations_2307","Cannot find module '{0}' or its corresponding type declarations."),Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity:t(2308,e.DiagnosticCategory.Error,"Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308","Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements:t(2309,e.DiagnosticCategory.Error,"An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309","An export assignment cannot be used in a module with other exported elements."),Type_0_recursively_references_itself_as_a_base_type:t(2310,e.DiagnosticCategory.Error,"Type_0_recursively_references_itself_as_a_base_type_2310","Type '{0}' recursively references itself as a base type."),Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function:t(2311,e.DiagnosticCategory.Error,"Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function_2311","Cannot find name '{0}'. Did you mean to write this in an async function?"),An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members:t(2312,e.DiagnosticCategory.Error,"An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312","An interface can only extend an object type or intersection of object types with statically known members."),Type_parameter_0_has_a_circular_constraint:t(2313,e.DiagnosticCategory.Error,"Type_parameter_0_has_a_circular_constraint_2313","Type parameter '{0}' has a circular constraint."),Generic_type_0_requires_1_type_argument_s:t(2314,e.DiagnosticCategory.Error,"Generic_type_0_requires_1_type_argument_s_2314","Generic type '{0}' requires {1} type argument(s)."),Type_0_is_not_generic:t(2315,e.DiagnosticCategory.Error,"Type_0_is_not_generic_2315","Type '{0}' is not generic."),Global_type_0_must_be_a_class_or_interface_type:t(2316,e.DiagnosticCategory.Error,"Global_type_0_must_be_a_class_or_interface_type_2316","Global type '{0}' must be a class or interface type."),Global_type_0_must_have_1_type_parameter_s:t(2317,e.DiagnosticCategory.Error,"Global_type_0_must_have_1_type_parameter_s_2317","Global type '{0}' must have {1} type parameter(s)."),Cannot_find_global_type_0:t(2318,e.DiagnosticCategory.Error,"Cannot_find_global_type_0_2318","Cannot find global type '{0}'."),Named_property_0_of_types_1_and_2_are_not_identical:t(2319,e.DiagnosticCategory.Error,"Named_property_0_of_types_1_and_2_are_not_identical_2319","Named property '{0}' of types '{1}' and '{2}' are not identical."),Interface_0_cannot_simultaneously_extend_types_1_and_2:t(2320,e.DiagnosticCategory.Error,"Interface_0_cannot_simultaneously_extend_types_1_and_2_2320","Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),Excessive_stack_depth_comparing_types_0_and_1:t(2321,e.DiagnosticCategory.Error,"Excessive_stack_depth_comparing_types_0_and_1_2321","Excessive stack depth comparing types '{0}' and '{1}'."),Type_0_is_not_assignable_to_type_1:t(2322,e.DiagnosticCategory.Error,"Type_0_is_not_assignable_to_type_1_2322","Type '{0}' is not assignable to type '{1}'."),Cannot_redeclare_exported_variable_0:t(2323,e.DiagnosticCategory.Error,"Cannot_redeclare_exported_variable_0_2323","Cannot redeclare exported variable '{0}'."),Property_0_is_missing_in_type_1:t(2324,e.DiagnosticCategory.Error,"Property_0_is_missing_in_type_1_2324","Property '{0}' is missing in type '{1}'."),Property_0_is_private_in_type_1_but_not_in_type_2:t(2325,e.DiagnosticCategory.Error,"Property_0_is_private_in_type_1_but_not_in_type_2_2325","Property '{0}' is private in type '{1}' but not in type '{2}'."),Types_of_property_0_are_incompatible:t(2326,e.DiagnosticCategory.Error,"Types_of_property_0_are_incompatible_2326","Types of property '{0}' are incompatible."),Property_0_is_optional_in_type_1_but_required_in_type_2:t(2327,e.DiagnosticCategory.Error,"Property_0_is_optional_in_type_1_but_required_in_type_2_2327","Property '{0}' is optional in type '{1}' but required in type '{2}'."),Types_of_parameters_0_and_1_are_incompatible:t(2328,e.DiagnosticCategory.Error,"Types_of_parameters_0_and_1_are_incompatible_2328","Types of parameters '{0}' and '{1}' are incompatible."),Index_signature_for_type_0_is_missing_in_type_1:t(2329,e.DiagnosticCategory.Error,"Index_signature_for_type_0_is_missing_in_type_1_2329","Index signature for type '{0}' is missing in type '{1}'."),_0_and_1_index_signatures_are_incompatible:t(2330,e.DiagnosticCategory.Error,"_0_and_1_index_signatures_are_incompatible_2330","'{0}' and '{1}' index signatures are incompatible."),this_cannot_be_referenced_in_a_module_or_namespace_body:t(2331,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_module_or_namespace_body_2331","'this' cannot be referenced in a module or namespace body."),this_cannot_be_referenced_in_current_location:t(2332,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_current_location_2332","'this' cannot be referenced in current location."),this_cannot_be_referenced_in_constructor_arguments:t(2333,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_constructor_arguments_2333","'this' cannot be referenced in constructor arguments."),this_cannot_be_referenced_in_a_static_property_initializer:t(2334,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_static_property_initializer_2334","'this' cannot be referenced in a static property initializer."),super_can_only_be_referenced_in_a_derived_class:t(2335,e.DiagnosticCategory.Error,"super_can_only_be_referenced_in_a_derived_class_2335","'super' can only be referenced in a derived class."),super_cannot_be_referenced_in_constructor_arguments:t(2336,e.DiagnosticCategory.Error,"super_cannot_be_referenced_in_constructor_arguments_2336","'super' cannot be referenced in constructor arguments."),Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors:t(2337,e.DiagnosticCategory.Error,"Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337","Super calls are not permitted outside constructors or in nested functions inside constructors."),super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class:t(2338,e.DiagnosticCategory.Error,"super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338","'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),Property_0_does_not_exist_on_type_1:t(2339,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_type_1_2339","Property '{0}' does not exist on type '{1}'."),Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword:t(2340,e.DiagnosticCategory.Error,"Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340","Only public and protected methods of the base class are accessible via the 'super' keyword."),Property_0_is_private_and_only_accessible_within_class_1:t(2341,e.DiagnosticCategory.Error,"Property_0_is_private_and_only_accessible_within_class_1_2341","Property '{0}' is private and only accessible within class '{1}'."),This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0:t(2343,e.DiagnosticCategory.Error,"This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343","This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),Type_0_does_not_satisfy_the_constraint_1:t(2344,e.DiagnosticCategory.Error,"Type_0_does_not_satisfy_the_constraint_1_2344","Type '{0}' does not satisfy the constraint '{1}'."),Argument_of_type_0_is_not_assignable_to_parameter_of_type_1:t(2345,e.DiagnosticCategory.Error,"Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345","Argument of type '{0}' is not assignable to parameter of type '{1}'."),Call_target_does_not_contain_any_signatures:t(2346,e.DiagnosticCategory.Error,"Call_target_does_not_contain_any_signatures_2346","Call target does not contain any signatures."),Untyped_function_calls_may_not_accept_type_arguments:t(2347,e.DiagnosticCategory.Error,"Untyped_function_calls_may_not_accept_type_arguments_2347","Untyped function calls may not accept type arguments."),Value_of_type_0_is_not_callable_Did_you_mean_to_include_new:t(2348,e.DiagnosticCategory.Error,"Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348","Value of type '{0}' is not callable. Did you mean to include 'new'?"),This_expression_is_not_callable:t(2349,e.DiagnosticCategory.Error,"This_expression_is_not_callable_2349","This expression is not callable."),Only_a_void_function_can_be_called_with_the_new_keyword:t(2350,e.DiagnosticCategory.Error,"Only_a_void_function_can_be_called_with_the_new_keyword_2350","Only a void function can be called with the 'new' keyword."),This_expression_is_not_constructable:t(2351,e.DiagnosticCategory.Error,"This_expression_is_not_constructable_2351","This expression is not constructable."),Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first:t(2352,e.DiagnosticCategory.Error,"Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352","Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1:t(2353,e.DiagnosticCategory.Error,"Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353","Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found:t(2354,e.DiagnosticCategory.Error,"This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354","This syntax requires an imported helper but module '{0}' cannot be found."),A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value:t(2355,e.DiagnosticCategory.Error,"A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355","A function whose declared type is neither 'void' nor 'any' must return a value."),An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type:t(2356,e.DiagnosticCategory.Error,"An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356","An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access:t(2357,e.DiagnosticCategory.Error,"The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357","The operand of an increment or decrement operator must be a variable or a property access."),The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter:t(2358,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358","The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type:t(2359,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359","The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or_symbol:t(2360,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or__2360","The left-hand side of an 'in' expression must be a private identifier or of type 'any', 'string', 'number', or 'symbol'."),The_right_hand_side_of_an_in_expression_must_not_be_a_primitive:t(2361,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_in_expression_must_not_be_a_primitive_2361","The right-hand side of an 'in' expression must not be a primitive."),The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type:t(2362,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362","The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type:t(2363,e.DiagnosticCategory.Error,"The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363","The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access:t(2364,e.DiagnosticCategory.Error,"The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364","The left-hand side of an assignment expression must be a variable or a property access."),Operator_0_cannot_be_applied_to_types_1_and_2:t(2365,e.DiagnosticCategory.Error,"Operator_0_cannot_be_applied_to_types_1_and_2_2365","Operator '{0}' cannot be applied to types '{1}' and '{2}'."),Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined:t(2366,e.DiagnosticCategory.Error,"Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366","Function lacks ending return statement and return type does not include 'undefined'."),This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap:t(2367,e.DiagnosticCategory.Error,"This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367","This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),Type_parameter_name_cannot_be_0:t(2368,e.DiagnosticCategory.Error,"Type_parameter_name_cannot_be_0_2368","Type parameter name cannot be '{0}'."),A_parameter_property_is_only_allowed_in_a_constructor_implementation:t(2369,e.DiagnosticCategory.Error,"A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369","A parameter property is only allowed in a constructor implementation."),A_rest_parameter_must_be_of_an_array_type:t(2370,e.DiagnosticCategory.Error,"A_rest_parameter_must_be_of_an_array_type_2370","A rest parameter must be of an array type."),A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation:t(2371,e.DiagnosticCategory.Error,"A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371","A parameter initializer is only allowed in a function or constructor implementation."),Parameter_0_cannot_reference_itself:t(2372,e.DiagnosticCategory.Error,"Parameter_0_cannot_reference_itself_2372","Parameter '{0}' cannot reference itself."),Parameter_0_cannot_reference_identifier_1_declared_after_it:t(2373,e.DiagnosticCategory.Error,"Parameter_0_cannot_reference_identifier_1_declared_after_it_2373","Parameter '{0}' cannot reference identifier '{1}' declared after it."),Duplicate_index_signature_for_type_0:t(2374,e.DiagnosticCategory.Error,"Duplicate_index_signature_for_type_0_2374","Duplicate index signature for type '{0}'."),Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties:t(2375,e.DiagnosticCategory.Error,"Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2375","Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_class_contains_initialized_properties_parameter_properties_or_private_identifiers:t(2376,e.DiagnosticCategory.Error,"A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_2376","A 'super' call must be the first statement in the constructor to refer to 'super' or 'this' when a derived class contains initialized properties, parameter properties, or private identifiers."),Constructors_for_derived_classes_must_contain_a_super_call:t(2377,e.DiagnosticCategory.Error,"Constructors_for_derived_classes_must_contain_a_super_call_2377","Constructors for derived classes must contain a 'super' call."),A_get_accessor_must_return_a_value:t(2378,e.DiagnosticCategory.Error,"A_get_accessor_must_return_a_value_2378","A 'get' accessor must return a value."),Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties:t(2379,e.DiagnosticCategory.Error,"Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_tr_2379","Argument of type '{0}' is not assignable to parameter of type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type:t(2380,e.DiagnosticCategory.Error,"The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type_2380","The return type of a 'get' accessor must be assignable to its 'set' accessor type"),Overload_signatures_must_all_be_exported_or_non_exported:t(2383,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_exported_or_non_exported_2383","Overload signatures must all be exported or non-exported."),Overload_signatures_must_all_be_ambient_or_non_ambient:t(2384,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_ambient_or_non_ambient_2384","Overload signatures must all be ambient or non-ambient."),Overload_signatures_must_all_be_public_private_or_protected:t(2385,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_public_private_or_protected_2385","Overload signatures must all be public, private or protected."),Overload_signatures_must_all_be_optional_or_required:t(2386,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_optional_or_required_2386","Overload signatures must all be optional or required."),Function_overload_must_be_static:t(2387,e.DiagnosticCategory.Error,"Function_overload_must_be_static_2387","Function overload must be static."),Function_overload_must_not_be_static:t(2388,e.DiagnosticCategory.Error,"Function_overload_must_not_be_static_2388","Function overload must not be static."),Function_implementation_name_must_be_0:t(2389,e.DiagnosticCategory.Error,"Function_implementation_name_must_be_0_2389","Function implementation name must be '{0}'."),Constructor_implementation_is_missing:t(2390,e.DiagnosticCategory.Error,"Constructor_implementation_is_missing_2390","Constructor implementation is missing."),Function_implementation_is_missing_or_not_immediately_following_the_declaration:t(2391,e.DiagnosticCategory.Error,"Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391","Function implementation is missing or not immediately following the declaration."),Multiple_constructor_implementations_are_not_allowed:t(2392,e.DiagnosticCategory.Error,"Multiple_constructor_implementations_are_not_allowed_2392","Multiple constructor implementations are not allowed."),Duplicate_function_implementation:t(2393,e.DiagnosticCategory.Error,"Duplicate_function_implementation_2393","Duplicate function implementation."),This_overload_signature_is_not_compatible_with_its_implementation_signature:t(2394,e.DiagnosticCategory.Error,"This_overload_signature_is_not_compatible_with_its_implementation_signature_2394","This overload signature is not compatible with its implementation signature."),Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local:t(2395,e.DiagnosticCategory.Error,"Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395","Individual declarations in merged declaration '{0}' must be all exported or all local."),Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters:t(2396,e.DiagnosticCategory.Error,"Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396","Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),Declaration_name_conflicts_with_built_in_global_identifier_0:t(2397,e.DiagnosticCategory.Error,"Declaration_name_conflicts_with_built_in_global_identifier_0_2397","Declaration name conflicts with built-in global identifier '{0}'."),constructor_cannot_be_used_as_a_parameter_property_name:t(2398,e.DiagnosticCategory.Error,"constructor_cannot_be_used_as_a_parameter_property_name_2398","'constructor' cannot be used as a parameter property name."),Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference:t(2399,e.DiagnosticCategory.Error,"Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399","Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference:t(2400,e.DiagnosticCategory.Error,"Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400","Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_initialized_properties_parameter_properties_or_private_identifiers:t(2401,e.DiagnosticCategory.Error,"A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_in_2401","A 'super' call must be a root-level statement within a constructor of a derived class that contains initialized properties, parameter properties, or private identifiers."),Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference:t(2402,e.DiagnosticCategory.Error,"Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402","Expression resolves to '_super' that compiler uses to capture base class reference."),Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2:t(2403,e.DiagnosticCategory.Error,"Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403","Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation:t(2404,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404","The left-hand side of a 'for...in' statement cannot use a type annotation."),The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any:t(2405,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405","The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access:t(2406,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406","The left-hand side of a 'for...in' statement must be a variable or a property access."),The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0:t(2407,e.DiagnosticCategory.Error,"The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407","The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),Setters_cannot_return_a_value:t(2408,e.DiagnosticCategory.Error,"Setters_cannot_return_a_value_2408","Setters cannot return a value."),Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class:t(2409,e.DiagnosticCategory.Error,"Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409","Return type of constructor signature must be assignable to the instance type of the class."),The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any:t(2410,e.DiagnosticCategory.Error,"The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410","The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_type_of_the_target:t(2412,e.DiagnosticCategory.Error,"Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2412","Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the type of the target."),Property_0_of_type_1_is_not_assignable_to_2_index_type_3:t(2411,e.DiagnosticCategory.Error,"Property_0_of_type_1_is_not_assignable_to_2_index_type_3_2411","Property '{0}' of type '{1}' is not assignable to '{2}' index type '{3}'."),_0_index_type_1_is_not_assignable_to_2_index_type_3:t(2413,e.DiagnosticCategory.Error,"_0_index_type_1_is_not_assignable_to_2_index_type_3_2413","'{0}' index type '{1}' is not assignable to '{2}' index type '{3}'."),Class_name_cannot_be_0:t(2414,e.DiagnosticCategory.Error,"Class_name_cannot_be_0_2414","Class name cannot be '{0}'."),Class_0_incorrectly_extends_base_class_1:t(2415,e.DiagnosticCategory.Error,"Class_0_incorrectly_extends_base_class_1_2415","Class '{0}' incorrectly extends base class '{1}'."),Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2:t(2416,e.DiagnosticCategory.Error,"Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416","Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),Class_static_side_0_incorrectly_extends_base_class_static_side_1:t(2417,e.DiagnosticCategory.Error,"Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417","Class static side '{0}' incorrectly extends base class static side '{1}'."),Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1:t(2418,e.DiagnosticCategory.Error,"Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418","Type of computed property's value is '{0}', which is not assignable to type '{1}'."),Types_of_construct_signatures_are_incompatible:t(2419,e.DiagnosticCategory.Error,"Types_of_construct_signatures_are_incompatible_2419","Types of construct signatures are incompatible."),Class_0_incorrectly_implements_interface_1:t(2420,e.DiagnosticCategory.Error,"Class_0_incorrectly_implements_interface_1_2420","Class '{0}' incorrectly implements interface '{1}'."),A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members:t(2422,e.DiagnosticCategory.Error,"A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422","A class can only implement an object type or intersection of object types with statically known members."),Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor:t(2423,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423","Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function:t(2425,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425","Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function:t(2426,e.DiagnosticCategory.Error,"Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426","Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),Interface_name_cannot_be_0:t(2427,e.DiagnosticCategory.Error,"Interface_name_cannot_be_0_2427","Interface name cannot be '{0}'."),All_declarations_of_0_must_have_identical_type_parameters:t(2428,e.DiagnosticCategory.Error,"All_declarations_of_0_must_have_identical_type_parameters_2428","All declarations of '{0}' must have identical type parameters."),Interface_0_incorrectly_extends_interface_1:t(2430,e.DiagnosticCategory.Error,"Interface_0_incorrectly_extends_interface_1_2430","Interface '{0}' incorrectly extends interface '{1}'."),Enum_name_cannot_be_0:t(2431,e.DiagnosticCategory.Error,"Enum_name_cannot_be_0_2431","Enum name cannot be '{0}'."),In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element:t(2432,e.DiagnosticCategory.Error,"In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432","In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged:t(2433,e.DiagnosticCategory.Error,"A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433","A namespace declaration cannot be in a different file from a class or function with which it is merged."),A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged:t(2434,e.DiagnosticCategory.Error,"A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434","A namespace declaration cannot be located prior to a class or function with which it is merged."),Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces:t(2435,e.DiagnosticCategory.Error,"Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435","Ambient modules cannot be nested in other modules or namespaces."),Ambient_module_declaration_cannot_specify_relative_module_name:t(2436,e.DiagnosticCategory.Error,"Ambient_module_declaration_cannot_specify_relative_module_name_2436","Ambient module declaration cannot specify relative module name."),Module_0_is_hidden_by_a_local_declaration_with_the_same_name:t(2437,e.DiagnosticCategory.Error,"Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437","Module '{0}' is hidden by a local declaration with the same name."),Import_name_cannot_be_0:t(2438,e.DiagnosticCategory.Error,"Import_name_cannot_be_0_2438","Import name cannot be '{0}'."),Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name:t(2439,e.DiagnosticCategory.Error,"Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439","Import or export declaration in an ambient module declaration cannot reference module through relative module name."),Import_declaration_conflicts_with_local_declaration_of_0:t(2440,e.DiagnosticCategory.Error,"Import_declaration_conflicts_with_local_declaration_of_0_2440","Import declaration conflicts with local declaration of '{0}'."),Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module:t(2441,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441","Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),Types_have_separate_declarations_of_a_private_property_0:t(2442,e.DiagnosticCategory.Error,"Types_have_separate_declarations_of_a_private_property_0_2442","Types have separate declarations of a private property '{0}'."),Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2:t(2443,e.DiagnosticCategory.Error,"Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443","Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),Property_0_is_protected_in_type_1_but_public_in_type_2:t(2444,e.DiagnosticCategory.Error,"Property_0_is_protected_in_type_1_but_public_in_type_2_2444","Property '{0}' is protected in type '{1}' but public in type '{2}'."),Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses:t(2445,e.DiagnosticCategory.Error,"Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445","Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_class_2:t(2446,e.DiagnosticCategory.Error,"Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_cl_2446","Property '{0}' is protected and only accessible through an instance of class '{1}'. This is an instance of class '{2}'."),The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead:t(2447,e.DiagnosticCategory.Error,"The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447","The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),Block_scoped_variable_0_used_before_its_declaration:t(2448,e.DiagnosticCategory.Error,"Block_scoped_variable_0_used_before_its_declaration_2448","Block-scoped variable '{0}' used before its declaration."),Class_0_used_before_its_declaration:t(2449,e.DiagnosticCategory.Error,"Class_0_used_before_its_declaration_2449","Class '{0}' used before its declaration."),Enum_0_used_before_its_declaration:t(2450,e.DiagnosticCategory.Error,"Enum_0_used_before_its_declaration_2450","Enum '{0}' used before its declaration."),Cannot_redeclare_block_scoped_variable_0:t(2451,e.DiagnosticCategory.Error,"Cannot_redeclare_block_scoped_variable_0_2451","Cannot redeclare block-scoped variable '{0}'."),An_enum_member_cannot_have_a_numeric_name:t(2452,e.DiagnosticCategory.Error,"An_enum_member_cannot_have_a_numeric_name_2452","An enum member cannot have a numeric name."),Variable_0_is_used_before_being_assigned:t(2454,e.DiagnosticCategory.Error,"Variable_0_is_used_before_being_assigned_2454","Variable '{0}' is used before being assigned."),Type_alias_0_circularly_references_itself:t(2456,e.DiagnosticCategory.Error,"Type_alias_0_circularly_references_itself_2456","Type alias '{0}' circularly references itself."),Type_alias_name_cannot_be_0:t(2457,e.DiagnosticCategory.Error,"Type_alias_name_cannot_be_0_2457","Type alias name cannot be '{0}'."),An_AMD_module_cannot_have_multiple_name_assignments:t(2458,e.DiagnosticCategory.Error,"An_AMD_module_cannot_have_multiple_name_assignments_2458","An AMD module cannot have multiple name assignments."),Module_0_declares_1_locally_but_it_is_not_exported:t(2459,e.DiagnosticCategory.Error,"Module_0_declares_1_locally_but_it_is_not_exported_2459","Module '{0}' declares '{1}' locally, but it is not exported."),Module_0_declares_1_locally_but_it_is_exported_as_2:t(2460,e.DiagnosticCategory.Error,"Module_0_declares_1_locally_but_it_is_exported_as_2_2460","Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),Type_0_is_not_an_array_type:t(2461,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_2461","Type '{0}' is not an array type."),A_rest_element_must_be_last_in_a_destructuring_pattern:t(2462,e.DiagnosticCategory.Error,"A_rest_element_must_be_last_in_a_destructuring_pattern_2462","A rest element must be last in a destructuring pattern."),A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature:t(2463,e.DiagnosticCategory.Error,"A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463","A binding pattern parameter cannot be optional in an implementation signature."),A_computed_property_name_must_be_of_type_string_number_symbol_or_any:t(2464,e.DiagnosticCategory.Error,"A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464","A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),this_cannot_be_referenced_in_a_computed_property_name:t(2465,e.DiagnosticCategory.Error,"this_cannot_be_referenced_in_a_computed_property_name_2465","'this' cannot be referenced in a computed property name."),super_cannot_be_referenced_in_a_computed_property_name:t(2466,e.DiagnosticCategory.Error,"super_cannot_be_referenced_in_a_computed_property_name_2466","'super' cannot be referenced in a computed property name."),A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type:t(2467,e.DiagnosticCategory.Error,"A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467","A computed property name cannot reference a type parameter from its containing type."),Cannot_find_global_value_0:t(2468,e.DiagnosticCategory.Error,"Cannot_find_global_value_0_2468","Cannot find global value '{0}'."),The_0_operator_cannot_be_applied_to_type_symbol:t(2469,e.DiagnosticCategory.Error,"The_0_operator_cannot_be_applied_to_type_symbol_2469","The '{0}' operator cannot be applied to type 'symbol'."),Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher:t(2472,e.DiagnosticCategory.Error,"Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472","Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),Enum_declarations_must_all_be_const_or_non_const:t(2473,e.DiagnosticCategory.Error,"Enum_declarations_must_all_be_const_or_non_const_2473","Enum declarations must all be const or non-const."),const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values:t(2474,e.DiagnosticCategory.Error,"const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474","const enum member initializers can only contain literal values and other computed enum values."),const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query:t(2475,e.DiagnosticCategory.Error,"const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475","'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),A_const_enum_member_can_only_be_accessed_using_a_string_literal:t(2476,e.DiagnosticCategory.Error,"A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476","A const enum member can only be accessed using a string literal."),const_enum_member_initializer_was_evaluated_to_a_non_finite_value:t(2477,e.DiagnosticCategory.Error,"const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477","'const' enum member initializer was evaluated to a non-finite value."),const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN:t(2478,e.DiagnosticCategory.Error,"const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478","'const' enum member initializer was evaluated to disallowed value 'NaN'."),let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations:t(2480,e.DiagnosticCategory.Error,"let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480","'let' is not allowed to be used as a name in 'let' or 'const' declarations."),Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1:t(2481,e.DiagnosticCategory.Error,"Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481","Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation:t(2483,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483","The left-hand side of a 'for...of' statement cannot use a type annotation."),Export_declaration_conflicts_with_exported_declaration_of_0:t(2484,e.DiagnosticCategory.Error,"Export_declaration_conflicts_with_exported_declaration_of_0_2484","Export declaration conflicts with exported declaration of '{0}'."),The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access:t(2487,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487","The left-hand side of a 'for...of' statement must be a variable or a property access."),Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2488,e.DiagnosticCategory.Error,"Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488","Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),An_iterator_must_have_a_next_method:t(2489,e.DiagnosticCategory.Error,"An_iterator_must_have_a_next_method_2489","An iterator must have a 'next()' method."),The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property:t(2490,e.DiagnosticCategory.Error,"The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490","The type returned by the '{0}()' method of an iterator must have a 'value' property."),The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern:t(2491,e.DiagnosticCategory.Error,"The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491","The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),Cannot_redeclare_identifier_0_in_catch_clause:t(2492,e.DiagnosticCategory.Error,"Cannot_redeclare_identifier_0_in_catch_clause_2492","Cannot redeclare identifier '{0}' in catch clause."),Tuple_type_0_of_length_1_has_no_element_at_index_2:t(2493,e.DiagnosticCategory.Error,"Tuple_type_0_of_length_1_has_no_element_at_index_2_2493","Tuple type '{0}' of length '{1}' has no element at index '{2}'."),Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher:t(2494,e.DiagnosticCategory.Error,"Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494","Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),Type_0_is_not_an_array_type_or_a_string_type:t(2495,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_a_string_type_2495","Type '{0}' is not an array type or a string type."),The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression:t(2496,e.DiagnosticCategory.Error,"The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496","The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export:t(2497,e.DiagnosticCategory.Error,"This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497","This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),Module_0_uses_export_and_cannot_be_used_with_export_Asterisk:t(2498,e.DiagnosticCategory.Error,"Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498","Module '{0}' uses 'export =' and cannot be used with 'export *'."),An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments:t(2499,e.DiagnosticCategory.Error,"An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499","An interface can only extend an identifier/qualified-name with optional type arguments."),A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments:t(2500,e.DiagnosticCategory.Error,"A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500","A class can only implement an identifier/qualified-name with optional type arguments."),A_rest_element_cannot_contain_a_binding_pattern:t(2501,e.DiagnosticCategory.Error,"A_rest_element_cannot_contain_a_binding_pattern_2501","A rest element cannot contain a binding pattern."),_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation:t(2502,e.DiagnosticCategory.Error,"_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502","'{0}' is referenced directly or indirectly in its own type annotation."),Cannot_find_namespace_0:t(2503,e.DiagnosticCategory.Error,"Cannot_find_namespace_0_2503","Cannot find namespace '{0}'."),Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator:t(2504,e.DiagnosticCategory.Error,"Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504","Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),A_generator_cannot_have_a_void_type_annotation:t(2505,e.DiagnosticCategory.Error,"A_generator_cannot_have_a_void_type_annotation_2505","A generator cannot have a 'void' type annotation."),_0_is_referenced_directly_or_indirectly_in_its_own_base_expression:t(2506,e.DiagnosticCategory.Error,"_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506","'{0}' is referenced directly or indirectly in its own base expression."),Type_0_is_not_a_constructor_function_type:t(2507,e.DiagnosticCategory.Error,"Type_0_is_not_a_constructor_function_type_2507","Type '{0}' is not a constructor function type."),No_base_constructor_has_the_specified_number_of_type_arguments:t(2508,e.DiagnosticCategory.Error,"No_base_constructor_has_the_specified_number_of_type_arguments_2508","No base constructor has the specified number of type arguments."),Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members:t(2509,e.DiagnosticCategory.Error,"Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509","Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),Base_constructors_must_all_have_the_same_return_type:t(2510,e.DiagnosticCategory.Error,"Base_constructors_must_all_have_the_same_return_type_2510","Base constructors must all have the same return type."),Cannot_create_an_instance_of_an_abstract_class:t(2511,e.DiagnosticCategory.Error,"Cannot_create_an_instance_of_an_abstract_class_2511","Cannot create an instance of an abstract class."),Overload_signatures_must_all_be_abstract_or_non_abstract:t(2512,e.DiagnosticCategory.Error,"Overload_signatures_must_all_be_abstract_or_non_abstract_2512","Overload signatures must all be abstract or non-abstract."),Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression:t(2513,e.DiagnosticCategory.Error,"Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513","Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2:t(2515,e.DiagnosticCategory.Error,"Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515","Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),All_declarations_of_an_abstract_method_must_be_consecutive:t(2516,e.DiagnosticCategory.Error,"All_declarations_of_an_abstract_method_must_be_consecutive_2516","All declarations of an abstract method must be consecutive."),Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type:t(2517,e.DiagnosticCategory.Error,"Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517","Cannot assign an abstract constructor type to a non-abstract constructor type."),A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard:t(2518,e.DiagnosticCategory.Error,"A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518","A 'this'-based type guard is not compatible with a parameter-based type guard."),An_async_iterator_must_have_a_next_method:t(2519,e.DiagnosticCategory.Error,"An_async_iterator_must_have_a_next_method_2519","An async iterator must have a 'next()' method."),Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions:t(2520,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520","Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method:t(2522,e.DiagnosticCategory.Error,"The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522","The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),yield_expressions_cannot_be_used_in_a_parameter_initializer:t(2523,e.DiagnosticCategory.Error,"yield_expressions_cannot_be_used_in_a_parameter_initializer_2523","'yield' expressions cannot be used in a parameter initializer."),await_expressions_cannot_be_used_in_a_parameter_initializer:t(2524,e.DiagnosticCategory.Error,"await_expressions_cannot_be_used_in_a_parameter_initializer_2524","'await' expressions cannot be used in a parameter initializer."),Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value:t(2525,e.DiagnosticCategory.Error,"Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525","Initializer provides no value for this binding element and the binding element has no default value."),A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface:t(2526,e.DiagnosticCategory.Error,"A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526","A 'this' type is available only in a non-static member of a class or interface."),The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary:t(2527,e.DiagnosticCategory.Error,"The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527","The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),A_module_cannot_have_multiple_default_exports:t(2528,e.DiagnosticCategory.Error,"A_module_cannot_have_multiple_default_exports_2528","A module cannot have multiple default exports."),Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions:t(2529,e.DiagnosticCategory.Error,"Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529","Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),Property_0_is_incompatible_with_index_signature:t(2530,e.DiagnosticCategory.Error,"Property_0_is_incompatible_with_index_signature_2530","Property '{0}' is incompatible with index signature."),Object_is_possibly_null:t(2531,e.DiagnosticCategory.Error,"Object_is_possibly_null_2531","Object is possibly 'null'."),Object_is_possibly_undefined:t(2532,e.DiagnosticCategory.Error,"Object_is_possibly_undefined_2532","Object is possibly 'undefined'."),Object_is_possibly_null_or_undefined:t(2533,e.DiagnosticCategory.Error,"Object_is_possibly_null_or_undefined_2533","Object is possibly 'null' or 'undefined'."),A_function_returning_never_cannot_have_a_reachable_end_point:t(2534,e.DiagnosticCategory.Error,"A_function_returning_never_cannot_have_a_reachable_end_point_2534","A function returning 'never' cannot have a reachable end point."),Enum_type_0_has_members_with_initializers_that_are_not_literals:t(2535,e.DiagnosticCategory.Error,"Enum_type_0_has_members_with_initializers_that_are_not_literals_2535","Enum type '{0}' has members with initializers that are not literals."),Type_0_cannot_be_used_to_index_type_1:t(2536,e.DiagnosticCategory.Error,"Type_0_cannot_be_used_to_index_type_1_2536","Type '{0}' cannot be used to index type '{1}'."),Type_0_has_no_matching_index_signature_for_type_1:t(2537,e.DiagnosticCategory.Error,"Type_0_has_no_matching_index_signature_for_type_1_2537","Type '{0}' has no matching index signature for type '{1}'."),Type_0_cannot_be_used_as_an_index_type:t(2538,e.DiagnosticCategory.Error,"Type_0_cannot_be_used_as_an_index_type_2538","Type '{0}' cannot be used as an index type."),Cannot_assign_to_0_because_it_is_not_a_variable:t(2539,e.DiagnosticCategory.Error,"Cannot_assign_to_0_because_it_is_not_a_variable_2539","Cannot assign to '{0}' because it is not a variable."),Cannot_assign_to_0_because_it_is_a_read_only_property:t(2540,e.DiagnosticCategory.Error,"Cannot_assign_to_0_because_it_is_a_read_only_property_2540","Cannot assign to '{0}' because it is a read-only property."),Index_signature_in_type_0_only_permits_reading:t(2542,e.DiagnosticCategory.Error,"Index_signature_in_type_0_only_permits_reading_2542","Index signature in type '{0}' only permits reading."),Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference:t(2543,e.DiagnosticCategory.Error,"Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543","Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference:t(2544,e.DiagnosticCategory.Error,"Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544","Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any:t(2545,e.DiagnosticCategory.Error,"A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545","A mixin class must have a constructor with a single rest parameter of type 'any[]'."),The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property:t(2547,e.DiagnosticCategory.Error,"The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547","The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2548,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548","Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator:t(2549,e.DiagnosticCategory.Error,"Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549","Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2_or_later:t(2550,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_c_2550","Property '{0}' does not exist on type '{1}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{2}' or later."),Property_0_does_not_exist_on_type_1_Did_you_mean_2:t(2551,e.DiagnosticCategory.Error,"Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551","Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),Cannot_find_name_0_Did_you_mean_1:t(2552,e.DiagnosticCategory.Error,"Cannot_find_name_0_Did_you_mean_1_2552","Cannot find name '{0}'. Did you mean '{1}'?"),Computed_values_are_not_permitted_in_an_enum_with_string_valued_members:t(2553,e.DiagnosticCategory.Error,"Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553","Computed values are not permitted in an enum with string valued members."),Expected_0_arguments_but_got_1:t(2554,e.DiagnosticCategory.Error,"Expected_0_arguments_but_got_1_2554","Expected {0} arguments, but got {1}."),Expected_at_least_0_arguments_but_got_1:t(2555,e.DiagnosticCategory.Error,"Expected_at_least_0_arguments_but_got_1_2555","Expected at least {0} arguments, but got {1}."),A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter:t(2556,e.DiagnosticCategory.Error,"A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter_2556","A spread argument must either have a tuple type or be passed to a rest parameter."),Expected_0_type_arguments_but_got_1:t(2558,e.DiagnosticCategory.Error,"Expected_0_type_arguments_but_got_1_2558","Expected {0} type arguments, but got {1}."),Type_0_has_no_properties_in_common_with_type_1:t(2559,e.DiagnosticCategory.Error,"Type_0_has_no_properties_in_common_with_type_1_2559","Type '{0}' has no properties in common with type '{1}'."),Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it:t(2560,e.DiagnosticCategory.Error,"Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560","Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2:t(2561,e.DiagnosticCategory.Error,"Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561","Object literal may only specify 