"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatFlags = void 0;
function formatFlags(leftPadding, flag, value) {
    return flag == '_'
        ? `${leftPadding}  ${value.join(' ')}`
        : `${leftPadding}  --${flag}=${formatValue(value)}`;
}
exports.formatFlags = formatFlags;
function formatValue(value) {
    if (Array.isArray(value)) {
        return `[${value.join(',')}]`;
    }
    else if (typeof value === 'object') {
        return JSON.stringify(value);
    }
    else {
        return value;
    }
}
//# sourceMappingURL=formatting-utils.js.map