import { __extends, __awaiter, __generator, __decorate } from 'tslib';
import { InjectionToken, NgModule } from '@angular/core';
import { Storage } from '@ionic/storage';
export { Storage } from '@ionic/storage';
import { isPlatformServer } from '@angular/common';

var StorageConfigToken = new InjectionToken('STORAGE_CONFIG_TOKEN');
var NoopStorage = /** @class */ (function (_super) {
    __extends(NoopStorage, _super);
    function NoopStorage() {
        return _super.call(this) || this;
    }
    NoopStorage.prototype.create = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this];
            });
        });
    };
    NoopStorage.prototype.defineDriver = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/];
            });
        });
    };
    Object.defineProperty(NoopStorage.prototype, "driver", {
        get: function () {
            return 'noop';
        },
        enumerable: true,
        configurable: true
    });
    NoopStorage.prototype.get = function (key) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, null];
        }); });
    };
    NoopStorage.prototype.set = function (key, value) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.remove = function (key) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.clear = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.length = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, 0];
        }); });
    };
    NoopStorage.prototype.keys = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, []];
        }); });
    };
    NoopStorage.prototype.forEach = function (iteratorCallback) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.setEncryptionKey = function (key) { };
    return NoopStorage;
}(Storage));
function provideStorage(storageConfig) {
    if (isPlatformServer(this.platformId)) {
        // When running in a server context return the NoopStorage
        return new NoopStorage();
    }
    return new Storage(storageConfig);
}
var IonicStorageModule = /** @class */ (function () {
    function IonicStorageModule() {
    }
    IonicStorageModule_1 = IonicStorageModule;
    IonicStorageModule.forRoot = function (storageConfig) {
        if (storageConfig === void 0) { storageConfig = null; }
        return {
            ngModule: IonicStorageModule_1,
            providers: [
                { provide: StorageConfigToken, useValue: storageConfig },
                {
                    provide: Storage,
                    useFactory: provideStorage,
                    deps: [StorageConfigToken]
                }
            ]
        };
    };
    var IonicStorageModule_1;
    IonicStorageModule = IonicStorageModule_1 = __decorate([
        NgModule()
    ], IonicStorageModule);
    return IonicStorageModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { IonicStorageModule, StorageConfigToken, provideStorage };
//# sourceMappingURL=ionic-storage-angular.js.map
