import { __awaiter, __decorate } from 'tslib';
import { InjectionToken, NgModule } from '@angular/core';
import { Storage } from '@ionic/storage';
export { Storage } from '@ionic/storage';
import { isPlatformServer } from '@angular/common';

var IonicStorageModule_1;
const StorageConfigToken = new InjectionToken('STORAGE_CONFIG_TOKEN');
class NoopStorage extends Storage {
    constructor() {
        super();
    }
    create() {
        return __awaiter(this, void 0, void 0, function* () {
            return this;
        });
    }
    defineDriver() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    get driver() {
        return 'noop';
    }
    get(key) {
        return __awaiter(this, void 0, void 0, function* () { return null; });
    }
    set(key, value) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    remove(key) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    clear() {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    length() {
        return __awaiter(this, void 0, void 0, function* () { return 0; });
    }
    keys() {
        return __awaiter(this, void 0, void 0, function* () { return []; });
    }
    forEach(iteratorCallback) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    setEncryptionKey(key) { }
}
function provideStorage(storageConfig) {
    if (isPlatformServer(this.platformId)) {
        // When running in a server context return the NoopStorage
        return new NoopStorage();
    }
    return new Storage(storageConfig);
}
let IonicStorageModule = IonicStorageModule_1 = class IonicStorageModule {
    static forRoot(storageConfig = null) {
        return {
            ngModule: IonicStorageModule_1,
            providers: [
                { provide: StorageConfigToken, useValue: storageConfig },
                {
                    provide: Storage,
                    useFactory: provideStorage,
                    deps: [StorageConfigToken]
                }
            ]
        };
    }
};
IonicStorageModule = IonicStorageModule_1 = __decorate([
    NgModule()
], IonicStorageModule);

/**
 * Generated bundle index. Do not edit.
 */

export { IonicStorageModule, StorageConfigToken, provideStorage };
//# sourceMappingURL=ionic-storage-angular.js.map
