import { __awaiter, __decorate, __extends, __generator } from "tslib";
import { NgModule, InjectionToken } from '@angular/core';
import { Storage } from '@ionic/storage';
import { isPlatformServer } from '@angular/common';
var StorageConfigToken = new InjectionToken('STORAGE_CONFIG_TOKEN');
export { StorageConfigToken, Storage };
var NoopStorage = /** @class */ (function (_super) {
    __extends(NoopStorage, _super);
    function NoopStorage() {
        return _super.call(this) || this;
    }
    NoopStorage.prototype.create = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this];
            });
        });
    };
    NoopStorage.prototype.defineDriver = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/];
            });
        });
    };
    Object.defineProperty(NoopStorage.prototype, "driver", {
        get: function () {
            return 'noop';
        },
        enumerable: true,
        configurable: true
    });
    NoopStorage.prototype.get = function (key) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, null];
        }); });
    };
    NoopStorage.prototype.set = function (key, value) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.remove = function (key) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.clear = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.length = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, 0];
        }); });
    };
    NoopStorage.prototype.keys = function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, []];
        }); });
    };
    NoopStorage.prototype.forEach = function (iteratorCallback) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/];
        }); });
    };
    NoopStorage.prototype.setEncryptionKey = function (key) { };
    return NoopStorage;
}(Storage));
export function provideStorage(storageConfig) {
    if (isPlatformServer(this.platformId)) {
        // When running in a server context return the NoopStorage
        return new NoopStorage();
    }
    return new Storage(storageConfig);
}
var IonicStorageModule = /** @class */ (function () {
    function IonicStorageModule() {
    }
    IonicStorageModule_1 = IonicStorageModule;
    IonicStorageModule.forRoot = function (storageConfig) {
        if (storageConfig === void 0) { storageConfig = null; }
        return {
            ngModule: IonicStorageModule_1,
            providers: [
                { provide: StorageConfigToken, useValue: storageConfig },
                {
                    provide: Storage,
                    useFactory: provideStorage,
                    deps: [StorageConfigToken]
                }
            ]
        };
    };
    var IonicStorageModule_1;
    IonicStorageModule = IonicStorageModule_1 = __decorate([
        NgModule()
    ], IonicStorageModule);
    return IonicStorageModule;
}());
export { IonicStorageModule };
//# sourceMappingURL=data:application/json;base64,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