var IonicStorageModule_1;
import { __awaiter, __decorate } from "tslib";
import { NgModule, InjectionToken } from '@angular/core';
import { Storage } from '@ionic/storage';
import { isPlatformServer } from '@angular/common';
const StorageConfigToken = new InjectionToken('STORAGE_CONFIG_TOKEN');
export { StorageConfigToken, Storage };
class NoopStorage extends Storage {
    constructor() {
        super();
    }
    create() {
        return __awaiter(this, void 0, void 0, function* () {
            return this;
        });
    }
    defineDriver() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    get driver() {
        return 'noop';
    }
    get(key) {
        return __awaiter(this, void 0, void 0, function* () { return null; });
    }
    set(key, value) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    remove(key) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    clear() {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    length() {
        return __awaiter(this, void 0, void 0, function* () { return 0; });
    }
    keys() {
        return __awaiter(this, void 0, void 0, function* () { return []; });
    }
    forEach(iteratorCallback) {
        return __awaiter(this, void 0, void 0, function* () { });
    }
    setEncryptionKey(key) { }
}
export function provideStorage(storageConfig) {
    if (isPlatformServer(this.platformId)) {
        // When running in a server context return the NoopStorage
        return new NoopStorage();
    }
    return new Storage(storageConfig);
}
let IonicStorageModule = IonicStorageModule_1 = class IonicStorageModule {
    static forRoot(storageConfig = null) {
        return {
            ngModule: IonicStorageModule_1,
            providers: [
                { provide: StorageConfigToken, useValue: storageConfig },
                {
                    provide: Storage,
                    useFactory: provideStorage,
                    deps: [StorageConfigToken]
                }
            ]
        };
    }
};
IonicStorageModule = IonicStorageModule_1 = __decorate([
    NgModule()
], IonicStorageModule);
export { IonicStorageModule };
//# sourceMappingURL=data:application/json;base64,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