import { Injectable, InjectionToken, Injector, } from '@angular/core';
import { LIFECYCLE_DID_ENTER, LIFECYCLE_DID_LEAVE, LIFECYCLE_WILL_ENTER, LIFECYCLE_WILL_LEAVE, LIFECYCLE_WILL_UNLOAD, } from '@ionic/core';
import { NavParams } from '../directives/navigation/nav-params';
import { isComponentFactoryResolver } from '../util/util';
import * as i0 from "@angular/core";
export class AngularDelegate {
    constructor(zone, appRef) {
        this.zone = zone;
        this.appRef = appRef;
    }
    create(resolverOrInjector, injector, location) {
        return new AngularFrameworkDelegate(resolverOrInjector, injector, location, this.appRef, this.zone);
    }
}
/** @nocollapse */ AngularDelegate.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate, deps: [{ token: i0.NgZone }, { token: i0.ApplicationRef }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ AngularDelegate.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i0.NgZone }, { type: i0.ApplicationRef }]; } });
export class AngularFrameworkDelegate {
    constructor(resolverOrInjector, injector, location, appRef, zone) {
        this.resolverOrInjector = resolverOrInjector;
        this.injector = injector;
        this.location = location;
        this.appRef = appRef;
        this.zone = zone;
        this.elRefMap = new WeakMap();
        this.elEventsMap = new WeakMap();
    }
    attachViewToDom(container, component, params, cssClasses) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const el = attachView(this.zone, this.resolverOrInjector, this.injector, this.location, this.appRef, this.elRefMap, this.elEventsMap, container, component, params, cssClasses);
                resolve(el);
            });
        });
    }
    removeViewFromDom(_container, component) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentRef = this.elRefMap.get(component);
                if (componentRef) {
                    componentRef.destroy();
                    this.elRefMap.delete(component);
                    const unbindEvents = this.elEventsMap.get(component);
                    if (unbindEvents) {
                        unbindEvents();
                        this.elEventsMap.delete(component);
                    }
                }
                resolve();
            });
        });
    }
}
export const attachView = (zone, resolverOrInjector, injector, location, appRef, elRefMap, elEventsMap, container, component, params, cssClasses) => {
    let componentRef;
    const childInjector = Injector.create({
        providers: getProviders(params),
        parent: injector,
    });
    if (resolverOrInjector && isComponentFactoryResolver(resolverOrInjector)) {
        // Angular 13 and lower
        const factory = resolverOrInjector.resolveComponentFactory(component);
        componentRef = location
            ? location.createComponent(factory, location.length, childInjector)
            : factory.create(childInjector);
    }
    else if (location) {
        // Angular 14
        const environmentInjector = resolverOrInjector;
        componentRef = location.createComponent(component, {
            index: location.indexOf,
            injector: childInjector,
            environmentInjector,
        });
    }
    else {
        return null;
    }
    const instance = componentRef.instance;
    const hostElement = componentRef.location.nativeElement;
    if (params) {
        Object.assign(instance, params);
    }
    if (cssClasses) {
        for (const clazz of cssClasses) {
            hostElement.classList.add(clazz);
        }
    }
    const unbindEvents = bindLifecycleEvents(zone, instance, hostElement);
    container.appendChild(hostElement);
    if (!location) {
        appRef.attachView(componentRef.hostView);
    }
    componentRef.changeDetectorRef.reattach();
    elRefMap.set(hostElement, componentRef);
    elEventsMap.set(hostElement, unbindEvents);
    return hostElement;
};
const LIFECYCLES = [
    LIFECYCLE_WILL_ENTER,
    LIFECYCLE_DID_ENTER,
    LIFECYCLE_WILL_LEAVE,
    LIFECYCLE_DID_LEAVE,
    LIFECYCLE_WILL_UNLOAD,
];
export const bindLifecycleEvents = (zone, instance, element) => {
    return zone.run(() => {
        const unregisters = LIFECYCLES.filter((eventName) => typeof instance[eventName] === 'function').map((eventName) => {
            const handler = (ev) => instance[eventName](ev.detail);
            element.addEventListener(eventName, handler);
            return () => element.removeEventListener(eventName, handler);
        });
        return () => unregisters.forEach((fn) => fn());
    });
};
const NavParamsToken = new InjectionToken('NavParamsToken');
const getProviders = (params) => {
    return [
        {
            provide: NavParamsToken,
            useValue: params,
        },
        {
            provide: NavParams,
            useFactory: provideNavParamsInjectable,
            deps: [NavParamsToken],
        },
    ];
};
const provideNavParamsInjectable = (params) => {
    return new NavParams(params);
};
//# sourceMappingURL=data:application/json;base64,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