import { __decorate } from "tslib";
import { ChangeDetectionStrategy, Component, ContentChild } from '@angular/core';
import { ProxyCmp } from '../angular-component-lib/utils';
import { VirtualFooter } from './virtual-footer';
import { VirtualHeader } from './virtual-header';
import { VirtualItem } from './virtual-item';
import * as i0 from "@angular/core";
let IonVirtualScroll = class IonVirtualScroll {
    constructor(z, iterableDiffers, elementRef) {
        this.z = z;
        this.iterableDiffers = iterableDiffers;
        this.refMap = new WeakMap();
        this.el = elementRef.nativeElement;
        this.el.nodeRender = this.nodeRender.bind(this);
    }
    ngOnChanges(changes) {
        if (this.trackBy && 'items' in changes) {
            // React on virtualScroll changes only once all inputs have been initialized
            const value = changes['items'].currentValue;
            if (this.differ === undefined && value != null) {
                try {
                    this.differ = this.iterableDiffers.find(value).create(this.trackBy);
                }
                catch (e) {
                    throw new Error(`Cannot find a differ supporting object '${value}'. VirtualScroll only supports binding to Iterables such as Arrays.`);
                }
            }
        }
    }
    ngDoCheck() {
        // and if there actually are changes
        const changes = this.differ !== undefined && this.items ? this.differ.diff(this.items) : null;
        if (changes === null) {
            return;
        }
        // TODO: optimize
        this.checkRange(0);
    }
    nodeRender(el, cell, index) {
        return this.z.run(() => {
            let node;
            if (!el) {
                node = this.itmTmp.viewContainer.createEmbeddedView(this.getComponent(cell.type), { $implicit: cell.value, index }, index);
                el = getElement(node);
                this.refMap.set(el, node);
            }
            else {
                node = this.refMap.get(el);
                const ctx = node.context;
                ctx.$implicit = cell.value;
                ctx.index = cell.index;
            }
            // run sync change detections
            node.detectChanges();
            return el;
        });
    }
    getComponent(type) {
        switch (type) {
            case 'item': return this.itmTmp.templateRef;
            case 'header': return this.hdrTmp.templateRef;
            case 'footer': return this.ftrTmp.templateRef;
            default: throw new Error('template for virtual item was not provided');
        }
    }
};
/** @nocollapse */ IonVirtualScroll.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonVirtualScroll, deps: [{ token: i0.NgZone }, { token: i0.IterableDiffers }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ IonVirtualScroll.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.10", type: IonVirtualScroll, selector: "ion-virtual-scroll", inputs: { approxItemHeight: "approxItemHeight", approxHeaderHeight: "approxHeaderHeight", approxFooterHeight: "approxFooterHeight", headerFn: "headerFn", footerFn: "footerFn", items: "items", itemHeight: "itemHeight", headerHeight: "headerHeight", footerHeight: "footerHeight", trackBy: "trackBy" }, queries: [{ propertyName: "itmTmp", first: true, predicate: VirtualItem, descendants: true }, { propertyName: "hdrTmp", first: true, predicate: VirtualHeader, descendants: true }, { propertyName: "ftrTmp", first: true, predicate: VirtualFooter, descendants: true }], usesOnChanges: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush });
IonVirtualScroll = __decorate([
    ProxyCmp({
        inputs: ['approxItemHeight', 'approxHeaderHeight', 'approxFooterHeight', 'headerFn', 'footerFn', 'items', 'itemHeight', 'headerHeight', 'footerHeight'],
        methods: ['checkEnd', 'checkRange', 'positionForItem']
    })
], IonVirtualScroll);
export { IonVirtualScroll };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonVirtualScroll, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-virtual-scroll',
                    template: '<ng-content></ng-content>',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    inputs: [
                        'approxItemHeight',
                        'approxHeaderHeight',
                        'approxFooterHeight',
                        'headerFn',
                        'footerFn',
                        'items',
                        'itemHeight',
                        'headerHeight',
                        'footerHeight',
                        'trackBy'
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i0.NgZone }, { type: i0.IterableDiffers }, { type: i0.ElementRef }]; }, propDecorators: { itmTmp: [{
                type: ContentChild,
                args: [VirtualItem, { static: false }]
            }], hdrTmp: [{
                type: ContentChild,
                args: [VirtualHeader, { static: false }]
            }], ftrTmp: [{
                type: ContentChild,
                args: [VirtualFooter, { static: false }]
            }] } });
const getElement = (view) => {
    const rootNodes = view.rootNodes;
    for (let i = 0; i < rootNodes.length; i++) {
        if (rootNodes[i].nodeType === 1) {
            return rootNodes[i];
        }
    }
    throw new Error('virtual element was not created');
};
//# sourceMappingURL=data:application/json;base64,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