export const insertView = (views, view, direction) => {
    if (direction === 'root') {
        return setRoot(views, view);
    }
    else if (direction === 'forward') {
        return setForward(views, view);
    }
    else {
        return setBack(views, view);
    }
};
const setRoot = (views, view) => {
    views = views.filter((v) => v.stackId !== view.stackId);
    views.push(view);
    return views;
};
const setForward = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        views = views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        views.push(view);
    }
    return views;
};
const setBack = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        return views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        return setRoot(views, view);
    }
};
export const getUrl = (router, activatedRoute) => {
    const urlTree = router.createUrlTree(['.'], { relativeTo: activatedRoute });
    return router.serializeUrl(urlTree);
};
export const isTabSwitch = (enteringView, leavingView) => {
    if (!leavingView) {
        return true;
    }
    return enteringView.stackId !== leavingView.stackId;
};
export const computeStackId = (prefixUrl, url) => {
    if (!prefixUrl) {
        return undefined;
    }
    const segments = toSegments(url);
    for (let i = 0; i < segments.length; i++) {
        if (i >= prefixUrl.length) {
            return segments[i];
        }
        if (segments[i] !== prefixUrl[i]) {
            return undefined;
        }
    }
    return undefined;
};
export const toSegments = (path) => {
    return path
        .split('/')
        .map((s) => s.trim())
        .filter((s) => s !== '');
};
export const destroyView = (view) => {
    if (view) {
        // TODO lifecycle event
        view.ref.destroy();
        view.unlistenEvents();
    }
};
//# sourceMappingURL=data:application/json;base64,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