/**
 * @description
 * NavParams are an object that exists on a page and can contain data for that particular view.
 * Similar to how data was pass to a view in V1 with `$stateParams`, NavParams offer a much more flexible
 * option with a simple `get` method.
 *
 * @usage
 * ```ts
 * import { NavParams } from '@ionic/angular';
 *
 * export class MyClass{
 *
 *  constructor(navParams: NavParams){
 *    // userParams is an object we have in our nav-parameters
 *    navParams.get('userParams');
 *  }
 *
 * }
 * ```
 */
export class NavParams {
    constructor(data = {}) {
        this.data = data;
    }
    /**
     * Get the value of a nav-parameter for the current view
     *
     * ```ts
     * import { NavParams } from 'ionic-angular';
     *
     * export class MyClass{
     *  constructor(public navParams: NavParams){
     *    // userParams is an object we have in our nav-parameters
     *    this.navParams.get('userParams');
     *  }
     * }
     * ```
     *
     * @param param Which param you want to look up
     */
    get(param) {
        return this.data[param];
    }
}
//# sourceMappingURL=data:application/json;base64,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