import { Directive, HostListener } from '@angular/core';
import { NgControl } from '@angular/forms';
import { raf } from '../../util/util';
import * as i0 from "@angular/core";
export class ValueAccessor {
    constructor(injector, el) {
        this.injector = injector;
        this.el = el;
        this.onChange = () => {
            /**/
        };
        this.onTouched = () => {
            /**/
        };
    }
    writeValue(value) {
        /**
         * TODO for Ionic 6:
         * Change `value == null ? '' : value;`
         * to `value`. This was a fix for IE9, but IE9
         * is no longer supported; however, this change
         * is potentially a breaking change
         */
        this.el.nativeElement.value = this.lastValue = value == null ? '' : value;
        setIonicClasses(this.el);
    }
    handleChangeEvent(el, value) {
        if (el === this.el.nativeElement) {
            if (value !== this.lastValue) {
                this.lastValue = value;
                this.onChange(value);
            }
            setIonicClasses(this.el);
        }
    }
    _handleBlurEvent(el) {
        if (el === this.el.nativeElement) {
            this.onTouched();
            setIonicClasses(this.el);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.el.nativeElement.disabled = isDisabled;
    }
    ngOnDestroy() {
        if (this.statusChanges) {
            this.statusChanges.unsubscribe();
        }
    }
    ngAfterViewInit() {
        let ngControl;
        try {
            ngControl = this.injector.get(NgControl);
        }
        catch (_a) {
            /* No FormControl or ngModel binding */
        }
        if (!ngControl) {
            return;
        }
        // Listen for changes in validity, disabled, or pending states
        if (ngControl.statusChanges) {
            this.statusChanges = ngControl.statusChanges.subscribe(() => setIonicClasses(this.el));
        }
        /**
         * TODO Remove this in favor of https://github.com/angular/angular/issues/10887
         * whenever it is implemented. Currently, Ionic's form status classes
         * do not react to changes when developers manually call
         * Angular form control methods such as markAsTouched.
         * This results in Ionic's form status classes being out
         * of sync with the ng form status classes.
         * This patches the methods to manually sync
         * the classes until this feature is implemented in Angular.
         */
        const formControl = ngControl.control;
        if (formControl) {
            const methodsToPatch = ['markAsTouched', 'markAllAsTouched', 'markAsUntouched', 'markAsDirty', 'markAsPristine'];
            methodsToPatch.forEach((method) => {
                if (typeof formControl[method] !== 'undefined') {
                    const oldFn = formControl[method].bind(formControl);
                    formControl[method] = (...params) => {
                        oldFn(...params);
                        setIonicClasses(this.el);
                    };
                }
            });
        }
    }
}
/** @nocollapse */ ValueAccessor.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: ValueAccessor, deps: [{ token: i0.Injector }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ ValueAccessor.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.10", type: ValueAccessor, host: { listeners: { "ionBlur": "_handleBlurEvent($event.target)" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: ValueAccessor, decorators: [{
            type: Directive
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.ElementRef }]; }, propDecorators: { _handleBlurEvent: [{
                type: HostListener,
                args: ['ionBlur', ['$event.target']]
            }] } });
export const setIonicClasses = (element) => {
    raf(() => {
        const input = element.nativeElement;
        const hasValue = input.value != null && input.value.toString().length > 0;
        const classes = getClasses(input);
        setClasses(input, classes);
        const item = input.closest('ion-item');
        if (item) {
            if (hasValue) {
                setClasses(item, [...classes, 'item-has-value']);
            }
            else {
                setClasses(item, classes);
            }
        }
    });
};
const getClasses = (element) => {
    const classList = element.classList;
    const classes = [];
    for (let i = 0; i < classList.length; i++) {
        const item = classList.item(i);
        if (item !== null && startsWith(item, 'ng-')) {
            classes.push(`ion-${item.substring(3)}`);
        }
    }
    return classes;
};
const setClasses = (element, classes) => {
    const classList = element.classList;
    classList.remove('ion-valid', 'ion-invalid', 'ion-touched', 'ion-untouched', 'ion-dirty', 'ion-pristine');
    classList.add(...classes);
};
const startsWith = (input, search) => {
    return input.substring(0, search.length) === search;
};
//# sourceMappingURL=data:application/json;base64,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