import { setupConfig } from '@ionic/core';
import { applyPolyfills, defineCustomElements } from '@ionic/core/loader';
import { raf } from './util/util';
export const appInitialize = (config, doc, zone) => {
    return () => {
        const win = doc.defaultView;
        if (win && typeof window !== 'undefined') {
            setupConfig(Object.assign(Object.assign({}, config), { _zoneGate: (h) => zone.run(h) }));
            const aelFn = '__zone_symbol__addEventListener' in doc.body ? '__zone_symbol__addEventListener' : 'addEventListener';
            return applyPolyfills().then(() => {
                return defineCustomElements(win, {
                    exclude: ['ion-tabs', 'ion-tab'],
                    syncQueue: true,
                    raf,
                    jmp: (h) => zone.runOutsideAngular(h),
                    ael(elm, eventName, cb, opts) {
                        elm[aelFn](eventName, cb, opts);
                    },
                    rel(elm, eventName, cb, opts) {
                        elm.removeEventListener(eventName, cb, opts);
                    },
                });
            });
        }
    };
};
//# sourceMappingURL=data:application/json;base64,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