import { ChangeDetectorRef, ElementRef, EventEmitter, NgZone, TemplateRef } from '@angular/core';
import { Components } from '@ionic/core';
import * as i0 from "@angular/core";
export declare interface IonPopover extends Components.IonPopover {
    /**
     * Emitted after the popover has presented.
     */
    ionPopoverDidPresent: EventEmitter<CustomEvent>;
    /**
     * Emitted before the popover has presented.
     */
    ionPopoverWillPresent: EventEmitter<CustomEvent>;
    /**
     * Emitted after the popover has dismissed.
     */
    ionPopoverWillDismiss: EventEmitter<CustomEvent>;
    /**
     * Emitted after the popover has dismissed.
     */
    ionPopoverDidDismiss: EventEmitter<CustomEvent>;
    /**
     * Emitted after the popover has presented. Shorthand for ionPopoverWillDismiss.
     */
    didPresent: EventEmitter<CustomEvent>;
    /**
     * Emitted before the popover has presented. Shorthand for ionPopoverWillPresent.
     */
    willPresent: EventEmitter<CustomEvent>;
    /**
     * Emitted after the popover has presented. Shorthand for ionPopoverWillDismiss.
     */
    willDismiss: EventEmitter<CustomEvent>;
    /**
     * Emitted after the popover has dismissed. Shorthand for ionPopoverDidDismiss.
     */
    didDismiss: EventEmitter<CustomEvent>;
}
export declare class IonPopover {
    protected z: NgZone;
    template: TemplateRef<any>;
    isCmpOpen: boolean;
    protected el: HTMLElement;
    constructor(c: ChangeDetectorRef, r: ElementRef, z: NgZone);
    static ɵfac: i0.ɵɵFactoryDeclaration<IonPopover, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<IonPopover, "ion-popover", never, { "alignment": "alignment"; "animated": "animated"; "arrow": "arrow"; "keepContentsMounted": "keepContentsMounted"; "backdropDismiss": "backdropDismiss"; "cssClass": "cssClass"; "dismissOnSelect": "dismissOnSelect"; "enterAnimation": "enterAnimation"; "event": "event"; "isOpen": "isOpen"; "keyboardClose": "keyboardClose"; "leaveAnimation": "leaveAnimation"; "mode": "mode"; "showBackdrop": "showBackdrop"; "translucent": "translucent"; "trigger": "trigger"; "triggerAction": "triggerAction"; "reference": "reference"; "size": "size"; "side": "side"; }, {}, ["template"], never>;
}
