/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Represents an instance of an `NgModule` created by an `NgModuleFactory`.
 * Provides access to the `NgModule` instance and related objects.
 *
 * @publicApi
 */
export class NgModuleRef {
}
/**
 * @publicApi
 *
 * @deprecated
 * This class was mostly used as a part of ViewEngine-based JIT API and is no longer needed in Ivy
 * JIT mode. See [JIT API changes due to ViewEngine deprecation](guide/deprecations#jit-api-changes)
 * for additional context. Angular provides APIs that accept NgModule classes directly (such as
 * [PlatformRef.bootstrapModule](api/core/PlatformRef#bootstrapModule) and
 * [createNgModuleRef](api/core/createNgModuleRef)), consider switching to those APIs instead of
 * using factory-based ones.
 */
export class NgModuleFactory {
}
//# sourceMappingURL=data:application/json;base64,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