/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from './injection_token';
/**
 * An internal token whose presence in an injector indicates that the injector should treat itself
 * as a root scoped injector when processing requests for unknown tokens which may indicate
 * they are provided in the root scope.
 */
export const INJECTOR_SCOPE = new InjectionToken('Set Injector scope.');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NvcGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9kaS9zY29wZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxPQUFPLEVBQUMsY0FBYyxFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFHakQ7Ozs7R0FJRztBQUNILE1BQU0sQ0FBQyxNQUFNLGNBQWMsR0FBRyxJQUFJLGNBQWMsQ0FBeUIscUJBQXFCLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge0luamVjdGlvblRva2VufSBmcm9tICcuL2luamVjdGlvbl90b2tlbic7XG5cblxuLyoqXG4gKiBBbiBpbnRlcm5hbCB0b2tlbiB3aG9zZSBwcmVzZW5jZSBpbiBhbiBpbmplY3RvciBpbmRpY2F0ZXMgdGhhdCB0aGUgaW5qZWN0b3Igc2hvdWxkIHRyZWF0IGl0c2VsZlxuICogYXMgYSByb290IHNjb3BlZCBpbmplY3RvciB3aGVuIHByb2Nlc3NpbmcgcmVxdWVzdHMgZm9yIHVua25vd24gdG9rZW5zIHdoaWNoIG1heSBpbmRpY2F0ZVxuICogdGhleSBhcmUgcHJvdmlkZWQgaW4gdGhlIHJvb3Qgc2NvcGUuXG4gKi9cbmV4cG9ydCBjb25zdCBJTkpFQ1RPUl9TQ09QRSA9IG5ldyBJbmplY3Rpb25Ub2tlbjwncm9vdCd8J3BsYXRmb3JtJ3xudWxsPignU2V0IEluamVjdG9yIHNjb3BlLicpO1xuIl19