/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeParamDecorator } from '../util/decorators';
import { attachInjectFlag } from './injector_compatibility';
/**
 * Inject decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Inject = attachInjectFlag(
// Disable tslint because `DecoratorFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
makeParamDecorator('Inject', (token) => ({ token })), -1 /* Inject */);
/**
 * Optional decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Optional = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Optional'), 8 /* Optional */);
/**
 * Self decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Self = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Self'), 2 /* Self */);
/**
 * `SkipSelf` decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const SkipSelf = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('SkipSelf'), 4 /* SkipSelf */);
/**
 * Host decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Host = 
// Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
// tslint:disable-next-line: no-toplevel-property-access
attachInjectFlag(makeParamDecorator('Host'), 1 /* Host */);
//# sourceMappingURL=data:application/json;base64,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