/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { ALLOW_MULTIPLE_PLATFORMS as ɵALLOW_MULTIPLE_PLATFORMS } from './application_ref';
export { APP_ID_RANDOM_PROVIDER as ɵAPP_ID_RANDOM_PROVIDER } from './application_tokens';
export { defaultIterableDiffers as ɵdefaultIterableDiffers, defaultKeyValueDiffers as ɵdefaultKeyValueDiffers } from './change_detection/change_detection';
export { devModeEqual as ɵdevModeEqual, isListLikeIterable as ɵisListLikeIterable } from './change_detection/change_detection_util';
export { ChangeDetectorStatus as ɵChangeDetectorStatus, isDefaultChangeDetectionStrategy as ɵisDefaultChangeDetectionStrategy } from './change_detection/constants';
export { Console as ɵConsole } from './console';
export { getDebugNodeR2 as ɵgetDebugNodeR2 } from './debug/debug_node';
export { setCurrentInjector as ɵsetCurrentInjector } from './di/injector_compatibility';
export { getInjectableDef as ɵgetInjectableDef } from './di/interface/defs';
export { INJECTOR_SCOPE as ɵINJECTOR_SCOPE } from './di/scope';
export { RuntimeError as ɵRuntimeError } from './errors';
export { findLocaleData as ɵfindLocaleData, getLocaleCurrencyCode as ɵgetLocaleCurrencyCode, getLocalePluralCase as ɵgetLocalePluralCase, LocaleDataIndex as ɵLocaleDataIndex, registerLocaleData as ɵregisterLocaleData, unregisterAllLocaleData as ɵunregisterLocaleData } from './i18n/locale_data_api';
export { DEFAULT_LOCALE_ID as ɵDEFAULT_LOCALE_ID } from './i18n/localization';
export { ComponentFactory as ɵComponentFactory } from './linker/component_factory';
export { clearResolutionOfComponentResourcesQueue as ɵclearResolutionOfComponentResourcesQueue, resolveComponentResources as ɵresolveComponentResources } from './metadata/resource_loading';
export { ReflectionCapabilities as ɵReflectionCapabilities } from './reflection/reflection_capabilities';
export { allowSanitizationBypassAndThrow as ɵallowSanitizationBypassAndThrow, getSanitizationBypassType as ɵgetSanitizationBypassType, unwrapSafeValue as ɵunwrapSafeValue } from './sanitization/bypass';
export { _sanitizeHtml as ɵ_sanitizeHtml } from './sanitization/html_sanitizer';
export { _sanitizeUrl as ɵ_sanitizeUrl } from './sanitization/url_sanitizer';
export { makeDecorator as ɵmakeDecorator } from './util/decorators';
export { global as ɵglobal } from './util/global';
export { isObservable as ɵisObservable, isPromise as ɵisPromise, isSubscribable as ɵisSubscribable } from './util/lang';
export { stringify as ɵstringify } from './util/stringify';
export { NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR as ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR } from './view/provider_flags';
// TODO(alxhub): allows tests to compile, can be removed when tests have been updated.
export const ɵivyEnabled = true;
//# sourceMappingURL=data:application/json;base64,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