/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { analytics, logging } from '@angular-devkit/core';
import { AngularWorkspace } from '../utilities/config';
export interface CommandMapOptions {
    [key: string]: string;
}
/**
 * Run a command.
 * @param args Raw unparsed arguments.
 * @param logger The logger to use.
 * @param workspace Workspace information.
 * @param commands The map of supported commands.
 * @param options Additional options.
 */
export declare function runCommand(args: string[], logger: logging.Logger, workspace: AngularWorkspace | undefined, commands?: CommandMapOptions, options?: {
    analytics?: analytics.Analytics;
    currentDirectory: string;
}): Promise<number | void>;
