"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_plugins_1 = require("@expo/config-plugins");
// Android
const withAndroidIntentFilters_1 = require("./android/withAndroidIntentFilters");
const withAndroidMainActivityAttributes_1 = require("./android/withAndroidMainActivityAttributes");
// iOS
const withIosAppEntitlements_1 = require("./ios/withIosAppEntitlements");
const withIosAppInfoPlist_1 = require("./ios/withIosAppInfoPlist");
const withIosShareExtensionConfig_1 = require("./ios/withIosShareExtensionConfig");
const withIosShareExtensionXcodeTarget_1 = require("./ios/withIosShareExtensionXcodeTarget");
const withCompatibilityChecker_1 = require("./withCompatibilityChecker");
const pkg = {
    name: "expo-share-intent",
    version: "UNVERSIONED",
};
const withShareMenu = (0, config_plugins_1.createRunOncePlugin)((config, params = {}) => {
    return (0, config_plugins_1.withPlugins)(config, [
        // IOS
        ...(!params.disableIOS
            ? [
                () => (0, withIosAppInfoPlist_1.withIosAppInfoPlist)(config, params),
                () => (0, withIosAppEntitlements_1.withAppEntitlements)(config, params),
                () => (0, withIosShareExtensionConfig_1.withShareExtensionConfig)(config, params),
                () => (0, withIosShareExtensionXcodeTarget_1.withShareExtensionXcodeTarget)(config, params),
            ]
            : []),
        // Android
        ...(!params.disableAndroid
            ? [
                () => (0, withAndroidIntentFilters_1.withAndroidIntentFilters)(config, params),
                () => (0, withAndroidMainActivityAttributes_1.withAndroidMainActivityAttributes)(config, params),
            ]
            : []),
        () => (0, withCompatibilityChecker_1.withCompatibilityChecker)(config, params),
    ]);
}, pkg.name, pkg.version);
exports.default = withShareMenu;
