import { Arch } from "builder-util";
import { GitlabOptions } from "builder-util-runtime";
import { ClientRequest } from "http";
import { Lazy } from "lazy-val";
import { HttpPublisher } from "./httpPublisher";
import { PublishContext } from "./index";
type RequestProcessor = (request: ClientRequest, reject: (error: Error) => void) => void;
export declare class GitlabPublisher extends HttpPublisher {
    private readonly info;
    private readonly version;
    private readonly tag;
    readonly _release: Lazy<any>;
    private readonly token;
    private readonly host;
    private readonly baseApiPath;
    private readonly projectId;
    readonly providerName = "gitlab";
    private releaseLogFields;
    constructor(context: PublishContext, info: GitlabOptions, version: string);
    private getOrCreateRelease;
    private getExistingRelease;
    private getDefaultBranch;
    private createRelease;
    protected doUpload(fileName: string, arch: Arch, dataLength: number, requestProcessor: RequestProcessor, filePath: string): Promise<any>;
    private uploadFileAndReturnAssetPath;
    private addReleaseAssetLink;
    private uploadToProjectUpload;
    private uploadToGenericPackages;
    private buildProjectUrl;
    private resolveProjectId;
    private gitlabRequest;
    private setAuthHeaderForToken;
    private categorizeGitlabError;
    toString(): string;
}
export {};
