import { Image } from 'expo-image'
import Svg, { Circle, G, Path } from 'react-native-svg'
import iconFacebook from '@/assets/images/facebook.svg'
import iconFacebookMessenger from '@/assets/images/facebook_messenger.svg'
import iconInstagram from '@/assets/images/instagram.svg'
import iconTikTok from '@/assets/images/tiktok.png'
import iconTumblr from '@/assets/images/tumblr.png'
import iconX from '@/assets/images/x.jpg'

export const IconBluesky = (props: any) => (
  <Svg width="24" height="24" viewBox="0 0 600 530">
    <Path
      fill="#1185fe"
      d="M135.72 44.03C202.216 93.951 273.74 195.17 300 249.49c26.262-54.316 97.782-155.54 164.28-205.46C512.26 8.009 590-19.862 590 68.825c0 17.712-10.155 148.79-16.111 170.07-20.703 73.984-96.144 92.854-163.25 81.433 117.3 19.964 147.14 86.092 82.697 152.22-122.39 125.59-175.91-31.511-189.63-71.766-2.514-7.38-3.69-10.832-3.708-7.896-.017-2.936-1.193.516-3.707 7.896-13.714 40.255-67.233 197.36-189.63 71.766-64.444-66.128-34.605-132.26 82.697-152.22-67.108 11.421-142.55-7.45-163.25-81.433C20.15 217.613 9.997 86.535 9.997 68.825c0-88.687 77.742-60.816 125.72-24.795z"
    />
  </Svg>
)

export const IconFacebook = (props: any) => <Image source={iconFacebook} style={{ height: 24, width: 24 }} />

export const IconFacebookMessenger = (props: any) => (
  <Image source={iconFacebookMessenger} style={{ height: 24, width: 24 }} />
)

export const IconInstagram = (props: any) => <Image source={iconInstagram} style={{ height: 24, width: 24 }} />

export const IconLinkedIn = (props: any) => (
  <Svg width="24" height="24" viewBox="0 0 72 72">
    <G fill="none" fillRule="evenodd">
      <Path fill="#0a66c2" d="M8 72h56a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8H8a8 8 0 0 0-8 8v56a8 8 0 0 0 8 8" />
      <Path
        fill="#fff"
        d="M62 62H51.316V43.802c0-4.99-1.896-7.777-5.845-7.777-4.296 0-6.54 2.901-6.54 7.777V62H28.632V27.333H38.93v4.67s3.096-5.729 10.453-5.729c7.353 0 12.617 4.49 12.617 13.777zM16.35 22.794c-3.508 0-6.35-2.864-6.35-6.397S12.842 10 16.35 10s6.347 2.864 6.347 6.397-2.84 6.397-6.348 6.397M11.032 62h10.736V27.333H11.033z"
      />
    </G>
  </Svg>
)

export const IconReddit = (props: any) => (
  <Svg width="24" height="24" viewBox="0 0 800 800">
    <Circle cx="400" cy="400" r="400" fill="#ff4500" />
    <Path
      fill="#fff"
      d="M666.8 400c.08 5.48-.6 10.95-2.04 16.24s-3.62 10.36-6.48 15.04c-2.85 4.68-6.35 8.94-10.39 12.65s-8.58 6.83-13.49 9.27c.11 1.46.2 2.93.25 4.4a107 107 0 0 1 0 8.8c-.05 1.47-.14 2.94-.25 4.4 0 89.6-104.4 162.4-233.2 162.4S168 560.4 168 470.8c-.11-1.46-.2-2.93-.25-4.4a107 107 0 0 1 0-8.8c.05-1.47.14-2.94.25-4.4a58.44 58.44 0 0 1-31.85-37.28 58.41 58.41 0 0 1 7.8-48.42 58.35 58.35 0 0 1 41.93-25.4 58.4 58.4 0 0 1 46.52 15.5 287 287 0 0 1 35.89-20.71c12.45-6.02 25.32-11.14 38.51-15.3s26.67-7.35 40.32-9.56 27.45-3.42 41.28-3.63L418 169.6c.33-1.61.98-3.13 1.91-4.49.92-1.35 2.11-2.51 3.48-3.4 1.38-.89 2.92-1.5 4.54-1.8 1.61-.29 3.27-.26 4.87.09l98 19.6c9.89-16.99 30.65-24.27 48.98-17.19s28.81 26.43 24.71 45.65c-4.09 19.22-21.55 32.62-41.17 31.61-19.63-1.01-35.62-16.13-37.72-35.67L440 186l-26 124.8c13.66.29 27.29 1.57 40.77 3.82a284.4 284.4 0 0 1 77.8 24.86A284.4 284.4 0 0 1 568 360a58.35 58.35 0 0 1 29.4-15.21 58.36 58.36 0 0 1 32.95 3.21 58.4 58.4 0 0 1 25.91 20.61A58.4 58.4 0 0 1 666.8 400m-396.96 55.31c2.02 4.85 4.96 9.26 8.68 12.97 3.71 3.72 8.12 6.66 12.97 8.68A40 40 0 0 0 306.8 480c16.18 0 30.76-9.75 36.96-24.69 6.19-14.95 2.76-32.15-8.68-43.59s-28.64-14.87-43.59-8.68c-14.94 6.2-24.69 20.78-24.69 36.96 0 5.25 1.03 10.45 3.04 15.31m229.1 96.02c2.05-2 3.22-4.73 3.26-7.59.04-2.87-1.07-5.63-3.07-7.68s-4.73-3.22-7.59-3.26c-2.87-.04-5.63 1.07-7.94 2.8a131 131 0 0 1-19.04 11.35 131.5 131.5 0 0 1-20.68 7.99c-7.1 2.07-14.37 3.54-21.72 4.39-7.36.85-14.77 1.07-22.16.67-7.38.33-14.78.03-22.11-.89a129 129 0 0 1-21.64-4.6c-7.08-2.14-13.95-4.88-20.56-8.18s-12.93-7.16-18.89-11.53c-2.07-1.7-4.7-2.57-7.38-2.44s-5.21 1.26-7.11 3.15c-1.89 1.9-3.02 4.43-3.15 7.11s.74 5.31 2.44 7.38c7.03 5.3 14.5 9.98 22.33 14s16 7.35 24.4 9.97 17.01 4.51 25.74 5.66c8.73 1.14 17.54 1.53 26.33 1.17 8.79.36 17.6-.03 26.33-1.17A154 154 0 0 0 476.87 564c7.83-4.02 15.3-8.7 22.33-14zm-7.34-68.13c5.42.06 10.8-.99 15.81-3.07 5.01-2.09 9.54-5.17 13.32-9.06s6.72-8.51 8.66-13.58A39.9 39.9 0 0 0 532 441.6c0-16.18-9.75-30.76-24.69-36.96-14.95-6.19-32.15-2.76-43.59 8.68s-14.87 28.64-8.68 43.59c6.2 14.94 20.78 24.69 36.96 24.69z"
    />
  </Svg>
)

export const IconThreads = (props: any) => (
  <Svg viewBox="0 0 960 960" width="24" height="24" {...props}>
    <Path d="M804.6 960H155.4C69.58 960 0 890.42 0 804.6V155.4C0 69.58 69.58 0 155.4 0h649.2C890.42 0 960 69.58 960 155.4v649.2c0 85.82-69.58 155.4-155.4 155.4z" />
    <Path
      fill="#FFF"
      d="M404.63 392.13c-11.92-7.93-51.53-35.49-51.53-35.49 33.4-47.88 77.46-66.52 138.36-66.52 43.07 0 79.64 14.52 105.75 42 26.12 27.49 41.02 66.8 44.41 117.07 14.48 6.07 27.85 13.22 39.99 21.4 48.96 33 75.92 82.34 75.92 138.91 0 120.23-98.34 224.67-276.35 224.67-152.84 0-311.63-89.11-311.63-354.45 0-263.83 153.81-353.92 311.2-353.92 72.68 0 243.16 10.76 307.27 222.94l-60.12 15.63C678.33 213.2 574.4 189.14 479.11 189.14c-157.52 0-246.62 96.13-246.62 300.65 0 183.38 99.59 280.8 248.71 280.8 122.68 0 214.15-63.9 214.15-157.44 0-63.66-53.37-94.14-56.1-94.14-10.42 54.62-38.36 146.5-161.01 146.5-71.46 0-133.07-49.47-133.07-114.29 0-92.56 87.61-126.06 156.8-126.06 25.91 0 57.18 1.75 73.46 5.07 0-28.21-23.81-76.49-83.96-76.49-55.15-.01-69.14 17.92-86.84 38.39zm105.8 96.25c-90.13 0-101.79 38.51-101.79 62.7 0 38.86 46.07 51.74 70.65 51.74 45.06 0 91.35-12.52 98.63-107.31-22.85-5.14-39.88-7.13-67.49-7.13z"
    />
  </Svg>
)

export const IconTikTok = (props: any) => <Image source={iconTikTok} style={{ height: 24, width: 24 }} />

export const IconTumblr0 = (props: any) => (
  <Svg width="24" height="24" viewBox="0 0 90.2 159.3">
    <Path d="M63.6 159.3c-24 0-41.8-12.3-41.8-41.8V70.3H0V44.7C24 38.5 34 17.9 35.1 0H60v40.6h29v29.7H60v41.1c0 12.3 6.2 16.6 16.1 16.6h14.1v31.3z" />
  </Svg>
)

export const IconTumblr = (props: any) => <Image source={iconTumblr} style={{ height: 24, width: 24 }} />

export const IconTwitter = (props: any) => <Image source={iconX} style={{ height: 24, width: 24 }} />

export const IconVK = (props: any) => (
  <Svg width="24" height="24" viewBox="0 0 48 48">
    <Path
      fill="#07f"
      d="M0 23.04C0 12.179 0 6.748 3.374 3.374S12.18 0 23.04 0h1.92c10.861 0 16.292 0 19.666 3.374S48 12.18 48 23.04v1.92c0 10.861 0 16.292-3.374 19.666S35.82 48 24.96 48h-1.92c-10.861 0-16.292 0-19.666-3.374S0 35.82 0 24.96z"
    />
    <Path
      fill="#fff"
      d="M25.54 34.58c-10.94 0-17.18-7.5-17.44-19.98h5.48c.18 9.16 4.22 13.04 7.42 13.84V14.6h5.16v7.9c3.16-.34 6.48-3.94 7.6-7.9h5.16c-.86 4.88-4.46 8.48-7.02 9.96 2.56 1.2 6.66 4.34 8.22 10.02h-5.68c-1.22-3.8-4.26-6.74-8.28-7.14v7.14z"
    />
  </Svg>
)
