import { clsx, nIf } from '@/lib/utils'
import { NouText } from '../NouText'
import { ActivityIndicator, TouchableOpacity } from 'react-native'

export const NouButton = ({
  className,
  textClassName,
  variant = 'solid',
  size = '2',
  loading = false,
  children,
  onPress,
  disabled,
}: React.PropsWithChildren<{
  className?: string
  textClassName?: string
  variant?: 'solid' | 'soft' | 'outline'
  size?: '1' | '2'
  loading?: boolean
  disabled?: boolean
  onPress: () => void
}>) => {
  return (
    <TouchableOpacity
      className={clsx(
        'flex-row gap-2 justify-center rounded-full',
        size == '1' && 'py-1 px-3',
        size == '2' && 'py-2 px-6',
        variant == 'solid' && 'bg-indigo-600',
        variant == 'soft' && 'bg-indigo-200',
        variant == 'outline' && 'border border-indigo-200',
        className,
      )}
      onPress={() => (disabled ? {} : onPress())}
    >
      {nIf(loading, <ActivityIndicator color="white" />)}
      <NouText className={clsx(variant == 'soft' && 'text-indigo-600', textClassName)}>{children}</NouText>
    </TouchableOpacity>
  )
}
