GNU Kind Communications Guidelines
by Richard Stallman
Source: https://www.gnu.org/philosophy/kind-communication.en.html

The GNU Project encourages contributions from anyone who wishes to advance the development of the GNU system, regardless of gender, race, religion, cultural background, and any other demographic characteristics, as well as personal political views.

People are sometimes discouraged from participating in GNU development because of certain patterns of communication that strike them as unfriendly, unwelcoming, rejecting, or harsh. This discouragement particularly affects members of disprivileged demographics, but it is not limited to them. Therefore, we ask all contributors to make a conscious effort, in GNU Project discussions, to communicate in ways that avoid that outcome—to avoid practices that will predictably and unnecessarily risk putting some contributors off.

These guidelines suggest specific ways to accomplish that goal.

Please assume other participants are posting in good faith, even if you disagree with what they say. When people present code or text as their own work, please accept it as their work. Please do not criticize people for wrongs that you only speculate they may have done; stick to what they actually say and actually do.

Please think about how to treat other participants with respect, especially when you disagree with them. For instance, call them by the names they use, and honor their preferences about their gender identity[1].

Please do not take a harsh tone towards other participants, and especially don't make personal attacks against them. Go out of your way to show that you are criticizing a statement, not a person.

Please recognize that criticism of your statements is not a personal attack on you. If you feel that someone has attacked you, or offended your personal dignity, please don't “hit back” with another personal attack. That tends to start a vicious circle of escalating verbal aggression. A private response, politely stating your feelings as feelings, and asking for peace, may calm things down. Write it, set it aside for hours or a day, revise it to remove the anger, and only then send it.

Please avoid statements about the presumed typical desires, capabilities or actions of some demographic group. They can offend people in that group, and they are always off-topic in GNU Project discussions.

Please be especially kind to other contributors when saying they made a mistake. Programming means making lots of mistakes, and we all do so—this is why regression tests are useful. Conscientious programmers make mistakes, and then fix them. It is helpful to show contributors that being imperfect is normal, so we don't hold it against them, and that we appreciate their imperfect contributions though we hope they follow through by fixing any problems in them.

Likewise, be kind when pointing out to other contributors that they should stop using certain nonfree software. For their own sake, they ought to free themselves, but we welcome their contributions to our software packages even if they don't do that. So these reminders should be gentle and not too frequent—don't nag.

By contrast, to suggest that others use nonfree software opposes the basic principles of GNU, so it is not allowed in GNU Project discussions.

Please respond to what people actually said, not to exaggerations of their views. Your criticism will not be constructive if it is aimed at a target other than their real views.

If in a discussion someone brings up a tangent to the topic at hand, please keep the discussion on track by focusing on the current topic rather than the tangent. This is not to say that the tangent is bad, or not interesting to discuss—only that it shouldn't interfere with discussion of the issue at hand. In most cases, it is also off-topic, so those interested ought to discuss it somewhere else.

If you think the tangent is an important and pertinent issue, please bring it up as a separate discussion, with a Subject field to fit, and consider waiting for the end of the current discussion.

Rather than trying to have the last word, look for the times when there is no need to reply, perhaps because you already made the relevant point clear enough. If you know something about the game of Go, this analogy might clarify that: when the other player's move is not strong enough to require a direct response, it is advantageous to give it none and instead move elsewhere.

Please don't argue unceasingly for your preferred course of action when a decision for some other course has already been made. That tends to block the activity's progress.

If other participants complain about the way you express your ideas, please make an effort to cater to them. You can find ways to express the same points while making others more comfortable. You are more likely to persuade others if you don't arouse ire about secondary things.

Please don't raise unrelated political issues in GNU Project discussions, because they are off-topic. The only political positions that the GNU Project endorses are (1) that users should have control of their own computing (for instance, through free software) and (2) supporting basic human rights in computing. We don't require you as a contributor to agree with these two points, but you do need to accept that our decisions will be based on them.

By making an effort to follow these guidelines, we will encourage more contribution to our projects, and our discussions will be friendlier and reach conclusions more easily.

Footnote

[1] Honoring people's preferences about gender identity includes not referring to them in ways that conflict with that identity. For instance, not to use pronouns for them that conflict with it. There are several ways to avoid that; one way is to use gender-neutral pronouns, since they don't conflict with any possible gender identity. One such pronoun is singular use of “they.” Another is “ person.”
