/*

    Copyright 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024  joshua.tee@gmail.com

    This file is part of wX.

    wX is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    wX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with wX.  If not, see <http://www.gnu.org/licenses/>.

*/

package joshuatee.wx.util

import joshuatee.wx.objects.Sites

@Suppress("SpellCheckingInspection")
object WfoSites {

    fun getState(office: String): String {
        return getFullName(office).split(",")[0]
    }

    fun getFullName(office: String): String {
        val site = sites.byCode[office]
        return site?.fullName ?: ""
    }

    private val names = mapOf(
        "AFC" to "AK, Anchorage",
        "AFG" to "AK, Fairbanks",
        "AJK" to "AK, Juneau",
        "BMX" to "AL, Birmingham",
        "HUN" to "AL, Huntsville",
        "MOB" to "AL, Mobile",
        "LZK" to "AR, Little Rock",
        "FGZ" to "AZ, Flagstaff",
        "PSR" to "AZ, Phoenix",
        "TWC" to "AZ, Tucson",
        "EKA" to "CA, Eureka",
        "HNX" to "CA, Hanford",
        "LOX" to "CA, Los Angeles",
        "MTR" to "CA, San Francisco",
        "SGX" to "CA, San Diego",
        "STO" to "CA, Sacramento",
        "BOU" to "CO, Denver/Boulder",
        "GJT" to "CO, Grand Junction",
        "PUB" to "CO, Pueblo",
        "JAX" to "FL, Jacksonville",
        "KEY" to "FL, Key West",
        "MFL" to "FL, Miami",
        "MLB" to "FL, Melbourne",
        "TAE" to "FL, Tallahassee",
        "TBW" to "FL, Tampa Bay",
        "FFC" to "GA, Atlanta",
        "GUM" to "GU, Guam",
        "HFO" to "HI, Honolulu",
        "DMX" to "IA, Des Moines",
        "DVN" to "IA, Quad Cities",
        "BOI" to "ID, Boise",
        "PIH" to "ID, Pocatello",
        "ILX" to "IL, Lincoln",
        "LOT" to "IL, Chicago",
        "IND" to "IN, Indianapolis",
        "IWX" to "IN, Nrn. Indiana",
        "DDC" to "KS, Dodge City",
        "GLD" to "KS, Goodland",
        "ICT" to "KS, Wichita",
        "TOP" to "KS, Topeka",
        "JKL" to "KY, Jackson",
        "LMK" to "KY, Louisville",
        "PAH" to "KY, Paducah",
        "LCH" to "LA, Lake Charles",
        "LIX" to "LA, New Orleans",
        "SHV" to "LA, Shreveport",
        "BOX" to "MA, Boston",
        "CAR" to "ME, Caribou",
        "GYX" to "ME, Gray",
        "APX" to "MI, Gaylord",
        "DTX" to "MI, Detroit",
        "GRR" to "MI, Grand Rapids",
        "MQT" to "MI, Marquette",
        "DLH" to "MN, Duluth",
        "MPX" to "MN, Twin Cities",
        "EAX" to "MO, Kansas City",
        "LSX" to "MO, St. Louis",
        "SGF" to "MO, Springfield",
        "JAN" to "MS, Jackson",
        "BYZ" to "MT, Billings",
        "GGW" to "MT, Glasgow",
        "MSO" to "MT, Missoula",
        "TFX" to "MT, Great Falls",
        "ILM" to "NC, Wilmington",
        "MHX" to "NC, Morehead City",
        "RAH" to "NC, Raleigh",
        "BIS" to "ND, Bismarck",
        "FGF" to "ND, Grand Forks",
        "GID" to "NE, Hastings",
        "LBF" to "NE, North Platte",
        "OAX" to "NE, Omaha",
        "PHI" to "NJ, Mount Holly",
        "ABQ" to "NM, Albuquerque",
        "LKN" to "NV, Elko",
        "REV" to "NV, Reno",
        "VEF" to "NV, Las Vegas",
        "ALY" to "NY, Albany",
        "BGM" to "NY, Binghamton",
        "BUF" to "NY, Buffalo",
        "OKX" to "NY, New York City",
        "CLE" to "OH, Cleveland",
        "ILN" to "OH, Wilmington",
        "OUN" to "OK, Norman",
        "TSA" to "OK, Tulsa",
        "MFR" to "OR, Medford",
        "PDT" to "OR, Pendleton",
        "PQR" to "OR, Portland",
        "CTP" to "PA, State College",
        "PBZ" to "PA, Pittsburgh",
        "SJU" to "PR, San Juan",
        "CAE" to "SC, Columbia",
        "CHS" to "SC, Charleston",
        "GSP" to "SC, Greer",
        "ABR" to "SD, Aberdeen",
        "FSD" to "SD, Sioux Falls",
        "UNR" to "SD, Rapid City",
        "MEG" to "TN, Memphis",
        "MRX" to "TN, Morristown",
        "OHX" to "TN, Nashville",
        "AMA" to "TX, Amarillo",
        "BRO" to "TX, Brownsville",
        "CRP" to "TX, Corpus Christi",
        "EPZ" to "TX, El Paso",
        "EWX" to "TX, Austin",
        "FWD" to "TX, Dallas",
        "HGX" to "TX, Houston",
        "LUB" to "TX, Lubbock",
        "MAF" to "TX, Midland",
        "SJT" to "TX, San Angelo",
        "SLC" to "UT, Salt Lake City",
        "AKQ" to "VA, Wakefield",
        "LWX" to "VA, Sterling",
        "RNK" to "VA, Blacksburg",
        "BTV" to "VT, Burlington",
        "OTX" to "WA, Spokane",
        "SEW" to "WA, Seattle",
        "ARX" to "WI, La Crosse",
        "GRB" to "WI, Green Bay",
        "MKX" to "WI, Milwaukee",
        "RLX" to "WV, Charleston",
        "CYS" to "WY, Cheyenne",
        "RIW" to "WY, Riverton"
    )

    private val lat = mapOf(
        "ABQ" to "35.1027",
        "ABR" to "45.45583",
        "AFC" to "61.2060",
        "AFG" to "64.8396",
        "AJK" to "58.3023",
        "AKQ" to "36.98389",
        "ALY" to "42.6825",
        "AMA" to "35.23333",
        "APX" to "44.90722",
        "ARX" to "43.82278",
        "BGM" to "42.19972",
        "BIS" to "46.77083",
        "BMX" to "33.17194",
        "BOI" to "43.5994",
        "BOU" to "40.0107",
        "BOX" to "41.95583",
        "BRO" to "25.91556",
        "BTV" to "44.4686",
        "BUF" to "42.94861",
        "BYZ" to "45.7778",
        "CAE" to "33.94861",
        "CAR" to "46.85897",
        "CHS" to "32.7942",
        "CLE" to "41.41306",
        "CRP" to "27.78389",
        "CTP" to "40.7878",
        "CYS" to "41.15194",
        "DDC" to "37.76083",
        "DLH" to "46.83694",
        "DMX" to "41.73111",
        "DTX" to "42.69972",
        "DVN" to "41.61167",
        "EAX" to "38.81028",
        "EKA" to "40.7852",
        "EPZ" to "31.87306",
        "EWX" to "29.70361",
        "FFC" to "33.36333",
        "FGF" to "47.9069",
        "FGZ" to "35.19502",
        "FSD" to "43.58778",
        "FWD" to "32.6963",
        "GGW" to "48.20639",
        "GID" to "40.9114",
        "GJT" to "39.0836",
        "GLD" to "39.36694",
        "GRB" to "44.49833",
        "GRR" to "42.89389",
        "GSP" to "34.88306",
        "GUM" to "13.484",
        "GYX" to "43.89139",
        "HFO" to "21.30256",
        "HGX" to "29.47194",
        "HNX" to "36.31417",
        "HUN" to "34.6448",
        "ICT" to "37.65444",
        "ILM" to "39.2072",
        "ILN" to "39.42028",
        "ILX" to "40.15056",
        "IND" to "39.7075",
        "IWX" to "41.40861",
        "JAN" to "32.3104",
        "JAX" to "30.48444",
        "JKL" to "37.59083",
        "KEY" to "24.5627",
        "LBF" to "41.1431",
        "LCH" to "30.125",
        "LIX" to "30.33667",
        "LKN" to "40.8396",
        "LMK" to "38.1722",
        "LOT" to "41.60444",
        "LOX" to "34.206965",
        "LSX" to "38.69889",
        "LUB" to "33.5850",
        "LWX" to "38.97628",
        "LZK" to "34.83639",
        "MAF" to "31.94333",
        "MEG" to "35.1491",
        "MFL" to "25.7744",
        "MFR" to "42.3294",
        "MHX" to "34.77583",
        "MKX" to "42.96778",
        "MLB" to "28.11306",
        "MOB" to "30.67944",
        "MPX" to "44.84889",
        "MQT" to "46.53111",
        "MRX" to "36.16833",
        "MSO" to "46.8685",
        "MTR" to "37.7213",
        "OAX" to "41.32028",
        "OHX" to "36.24722",
        "OKX" to "40.86556",
        "OTX" to "47.68056",
        "OUN" to "35.4449",
        "PAH" to "37.06833",
        "PBZ" to "40.53167",
        "PDT" to "45.69056",
        "PHI" to "39.9754",
        "PIH" to "42.8947",
        "PQR" to "45.5031",
        "PSR" to "33.4050",
        "PUB" to "38.2641",
        "RAH" to "35.77399",
        "REV" to "39.5223",
        "RIW" to "43.06611",
        "RLX" to "38.31194",
        "RNK" to "37.2283",
        "SEW" to "47.4724",
        "SGF" to "37.23528",
        "SGX" to "32.7416",
        "SHV" to "32.45056",
        "SJT" to "31.37111",
        "SJU" to "18.4129",
        "SLC" to "40.7482",
        "STO" to "38.5678",
        "TAE" to "30.4293",
        "TBW" to "27.70528",
        "TFX" to "47.45972",
        "TOP" to "39.0134",
        "TSA" to "36.0961",
        "TWC" to "32.1965",
        "UNR" to "44.0734",
        "VEF" to "36.1273"
    )

    private val lon = mapOf(
        "ABQ" to "-106.6276",
        "ABR" to "-98.41306",
        "AFC" to "-149.7855",
        "AFG" to "-147.7434",
        "AJK" to "-134.4139",
        "AKQ" to "-77.0075",
        "ALY" to "-73.7899",
        "AMA" to "-101.70889",
        "APX" to "-84.71972",
        "ARX" to "-91.19111",
        "BGM" to "-75.985",
        "BIS" to "-100.76028",
        "BMX" to "-86.76972",
        "BOI" to "-116.2645",
        "BOU" to "-105.2584",
        "BOX" to "-71.1375",
        "BRO" to "-97.41861",
        "BTV" to "-73.1901",
        "BUF" to "-78.73694",
        "BYZ" to "-108.5429",
        "CAE" to "-81.11861",
        "CAR" to "-68.01895",
        "CHS" to "-79.9419",
        "CLE" to "-81.86",
        "CRP" to "-97.51083",
        "CTP" to "-77.8526",
        "CYS" to "-104.80611",
        "DDC" to "-99.96833",
        "DLH" to "-92.20972",
        "DMX" to "-93.72278",
        "DTX" to "-83.47167",
        "DVN" to "-90.58083",
        "EAX" to "-94.26417",
        "EKA" to "-124.1540",
        "EPZ" to "-106.6975",
        "EWX" to "-98.02806",
        "FFC" to "-84.56583",
        "FGF" to "-97.0602",
        "FGZ" to "-111.65310",
        "FSD" to "-96.72889",
        "FWD" to "-97.0827",
        "GGW" to "-106.62417",
        "GID" to "-98.3601",
        "GJT" to "-108.5638",
        "GLD" to "-101.7",
        "GRB" to "-88.11111",
        "GRR" to "-85.54472",
        "GSP" to "-82.22028",
        "GUM" to "144.7967",
        "GYX" to "-70.25694",
        "HFO" to "-157.84428",
        "HGX" to "-95.07889",
        "HNX" to "-119.63111",
        "HUN" to "-86.6672",
        "ICT" to "-97.4425",
        "ILM" to "-77.8719",
        "ILN" to "-83.82167",
        "ILX" to "-89.33667",
        "IND" to "-86.28028",
        "IWX" to "-85.7",
        "JAN" to "-90.1890",
        "JAX" to "-81.70194",
        "JKL" to "-83.31306",
        "KEY" to "-81.7724",
        "LBF" to "-100.7710",
        "LCH" to "-93.21583",
        "LIX" to "-89.82528",
        "LKN" to "-115.7587",
        "LMK" to "-85.7162",
        "LOT" to "-88.08472",
        "LOX" to "-119.1385678",
        "LSX" to "-90.68278",
        "LUB" to "-101.8904",
        "LWX" to "-77.48751",
        "LZK" to "-92.26194",
        "MAF" to "-102.18889",
        "MEG" to "-90.0151",
        "MFL" to "-80.1937",
        "MFR" to "-122.8524",
        "MHX" to "-76.87639",
        "MKX" to "-88.55056",
        "MLB" to "-80.65444",
        "MOB" to "-88.23972",
        "MPX" to "-93.56528",
        "MQT" to "-87.54833",
        "MRX" to "-83.40194",
        "MSO" to "-114.0090",
        "MTR" to "-122.4369",
        "OAX" to "-96.36639",
        "OHX" to "-86.5625",
        "OKX" to "-72.86444",
        "OTX" to "-117.62583",
        "OUN" to "-97.5219",
        "PAH" to "-88.77194",
        "PBZ" to "-80.21833",
        "PDT" to "-118.85278",
        "PHI" to "-75.1386",
        "PIH" to "-112.4420",
        "PQR" to "-122.6251",
        "PSR" to "-112.0325",
        "PUB" to "-104.61483",
        "RAH" to "-78.64008",
        "REV" to "-119.8127",
        "RIW" to "-108.47667",
        "RLX" to "-81.72389",
        "RNK" to "-80.4212",
        "SEW" to "-122.3141",
        "SGF" to "-93.40028",
        "SGX" to "-117.1294",
        "SHV" to "-93.84111",
        "SJT" to "-100.49222",
        "SJU" to "-66.0989",
        "SLC" to "-111.9155",
        "STO" to "-121.5007",
        "TAE" to "-84.2906",
        "TBW" to "-82.40194",
        "TFX" to "-111.38444",
        "TOP" to "-95.7071",
        "TSA" to "-95.9419",
        "TWC" to "-110.9025",
        "UNR" to "-103.2259",
        "VEF" to "-115.1712"
    )

    val sites: Sites = Sites(names, lat, lon, false)
}
