/*

Copyright 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024  joshua.tee@gmail.com

This file is part of wX.

wX is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option any later version.

wX is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with wX.  If not, see <http://www.gnu.org/licenses/>.

 */

package joshuatee.wx.util

import joshuatee.wx.R

object UtilityImageMap {

    fun mapToRid(id: Int): String = when (id) {
        R.id.CBW -> "CBW"
        R.id.GYX -> "GYX"
        R.id.CXX -> "CXX"
        R.id.BOX -> "BOX"
        R.id.ENX -> "ENX"
        R.id.BGM -> "BGM"
        R.id.BUF -> "BUF"
        R.id.TYX -> "TYX"
        R.id.OKX -> "OKX"
        R.id.DOX -> "DOX"
        R.id.DIX -> "DIX"
        R.id.PBZ -> "PBZ"
        R.id.CCX -> "CCX"
        R.id.RLX -> "RLX"
        R.id.AKQ -> "AKQ"
        R.id.FCX -> "FCX"
        R.id.LWX -> "LWX"
        R.id.MHX -> "MHX"
        R.id.RAX -> "RAX"
        R.id.LTX -> "LTX"
        R.id.CLX -> "CLX"
        R.id.CAE -> "CAE"
        R.id.GSP -> "GSP"
        R.id.FFC -> "FFC"
        R.id.VAX -> "VAX"
        R.id.JGX -> "JGX"
        R.id.EVX -> "EVX"
        R.id.JAX -> "JAX"
        R.id.BYX -> "BYX"
        R.id.MLB -> "MLB"
        R.id.AMX -> "AMX"
        R.id.TLH -> "TLH"
        R.id.TBW -> "TBW"
        R.id.BMX -> "BMX"
        R.id.EOX -> "EOX"
        R.id.HTX -> "HTX"
        R.id.MXX -> "MXX"
        R.id.MOB -> "MOB"
        R.id.DGX -> "DGX"
        R.id.GWX -> "GWX"
        R.id.MRX -> "MRX"
        R.id.NQA -> "NQA"
        R.id.OHX -> "OHX"
        R.id.HPX -> "HPX"
        R.id.JKL -> "JKL"
        R.id.LVX -> "LVX"
        R.id.PAH -> "PAH"
        R.id.ILN -> "ILN"
        R.id.CLE -> "CLE"
        R.id.DTX -> "DTX"
        R.id.APX -> "APX"
        R.id.GRR -> "GRR"
        R.id.MQT -> "MQT"
        R.id.VWX -> "VWX"
        R.id.IND -> "IND"
        R.id.IWX -> "IWX"
        R.id.LOT -> "LOT"
        R.id.ILX -> "ILX"
        R.id.GRB -> "GRB"
        R.id.ARX -> "ARX"
        R.id.MKX -> "MKX"
        R.id.DLH -> "DLH"
        R.id.MPX -> "MPX"
        R.id.DVN -> "DVN"
        R.id.DMX -> "DMX"
        R.id.EAX -> "EAX"
        R.id.SGF -> "SGF"
        R.id.LSX -> "LSX"
        R.id.SRX -> "SRX"
        R.id.LZK -> "LZK"
        R.id.POE -> "POE"
        R.id.LCH -> "LCH"
        R.id.HDC -> "HDC"
        R.id.SHV -> "SHV"
        R.id.AMA -> "AMA"
        R.id.EWX -> "EWX"
        R.id.BRO -> "BRO"
        R.id.CRP -> "CRP"
        R.id.FWS -> "FWS"
        R.id.DYX -> "DYX"
        R.id.EPZ -> "EPZ"
        R.id.GRK -> "GRK"
        R.id.HGX -> "HGX"
        R.id.DFX -> "DFX"
        R.id.LBB -> "LBB"
        R.id.MAF -> "MAF"
        R.id.SJT -> "SJT"
        R.id.FDR -> "FDR"
        R.id.TLX -> "TLX"
        R.id.INX -> "INX"
        R.id.VNX -> "VNX"
        R.id.DDC -> "DDC"
        R.id.GLD -> "GLD"
        R.id.TWX -> "TWX"
        R.id.ICT -> "ICT"
        R.id.UEX -> "UEX"
        R.id.LNX -> "LNX"
        R.id.OAX -> "OAX"
        R.id.ABR -> "ABR"
        R.id.UDX -> "UDX"
        R.id.FSD -> "FSD"
        R.id.BIS -> "BIS"
        R.id.MVX -> "MVX"
        R.id.MBX -> "MBX"
        R.id.BLX -> "BLX"
        R.id.GGW -> "GGW"
        R.id.TFX -> "TFX"
        R.id.MSX -> "MSX"
        R.id.CYS -> "CYS"
        R.id.RIW -> "RIW"
        R.id.FTG -> "FTG"
        R.id.GJX -> "GJX"
        R.id.PUX -> "PUX"
        R.id.ABX -> "ABX"
        R.id.FDX -> "FDX"
        R.id.HDX -> "HDX"
        R.id.FSX -> "FSX"
        R.id.IWA -> "IWA"
        R.id.EMX -> "EMX"
        R.id.YUX -> "YUX"
        R.id.ICX -> "ICX"
        R.id.MTX -> "MTX"
        R.id.CBX -> "CBX"
        R.id.SFX -> "SFX"
        R.id.LRX -> "LRX"
        R.id.ESX -> "ESX"
        R.id.RGX -> "RGX"
        R.id.BBX -> "BBX"
        R.id.EYX -> "EYX"
        R.id.BHX -> "BHX"
        R.id.VTX -> "VTX"
        R.id.DAX -> "DAX"
        R.id.NKX -> "NKX"
        R.id.MUX -> "MUX"
        R.id.HNX -> "HNX"
        R.id.SOX -> "SOX"
        R.id.VBX -> "VBX"
        R.id.HKI -> "HKI"
        R.id.HKM -> "HKM"
        R.id.HMO -> "HMO"
        R.id.HWA -> "HWA"
        R.id.MAX -> "MAX"
        R.id.PDT -> "PDT"
        R.id.RTX -> "RTX"
        R.id.LGX -> "LGX"
        R.id.ATX -> "ATX"
        R.id.OTX -> "OTX"
        R.id.ABC -> "ABC"
        R.id.APD -> "APD"
        R.id.AHG -> "AHG"
        R.id.AKC -> "AKC"
        R.id.AIH -> "AIH"
        R.id.AEC -> "AEC"
        R.id.ACG -> "ACG"
        R.id.GUA -> "GUA"
        R.id.JUA -> "JUA"
        else -> ""
    }

    fun mapToWfo(id: Int): String = when (id) {
        R.id.afc -> "afc"
        R.id.afg -> "afg"
        R.id.ajk -> "ajk"
        R.id.abq -> "abq"
        R.id.abr -> "abr"
        R.id.akq -> "akq"
        R.id.aly -> "aly"
        R.id.ama -> "ama"
        R.id.apx -> "apx"
        R.id.arx -> "arx"
        R.id.bgm -> "bgm"
        R.id.bis -> "bis"
        R.id.bmx -> "bmx"
        R.id.bna -> "ohx"
        R.id.boi -> "boi"
        R.id.box -> "box"
        R.id.bro -> "bro"
        R.id.btv -> "btv"
        R.id.buf -> "buf"
        R.id.byz -> "byz"
        R.id.cae -> "cae"
        R.id.car -> "car"
        R.id.chs -> "chs"
        R.id.cle -> "cle"
        R.id.crp -> "crp"
        R.id.ctp -> "ctp"
        R.id.cys -> "cys"
        R.id.ddc -> "ddc"
        R.id.bou -> "bou"
        R.id.dlh -> "dlh"
        R.id.dmx -> "dmx"
        R.id.dtx -> "dtx"
        R.id.dvn -> "dvn"
        R.id.eax -> "eax"
        R.id.eka -> "eka"
        R.id.elp -> "epz"
        R.id.ewx -> "ewx"
        R.id.eyw -> "key"
        R.id.ffc -> "ffc"
        R.id.fgf -> "fgf"
        R.id.fgz -> "fgz"
        R.id.fsd -> "fsd"
        R.id.fwd -> "fwd"
        R.id.ggw -> "ggw"
        R.id.gid -> "gid"
        R.id.gjt -> "gjt"
        R.id.gld -> "gld"
        R.id.grb -> "grb"
        R.id.grr -> "grr"
        R.id.gsp -> "gsp"
        R.id.guam -> "guam"
        R.id.gyx -> "gyx"
        R.id.hgx -> "hgx"
        R.id.hnl -> "hfo"
        R.id.hnx -> "hnx"
        R.id.hun -> "hun"
        R.id.ict -> "ict"
        R.id.ilm -> "ilm"
        R.id.iln -> "iln"
        R.id.ilx -> "ilx"
        R.id.ind -> "ind"
        R.id.iwx -> "iwx"
        R.id.jan -> "jan"
        R.id.jax -> "jax"
        R.id.jkl -> "jkl"
        R.id.lbf -> "lbf"
        R.id.lch -> "lch"
        R.id.lix -> "lix"
        R.id.lkn -> "lkn"
        R.id.lmk -> "lmk"
        R.id.lot -> "lot"
        R.id.lox -> "lox"
        R.id.lsx -> "lsx"
        R.id.lub -> "lub"
        R.id.lwx -> "lwx"
        R.id.lzk -> "lzk"
        R.id.maf -> "maf"
        R.id.meg -> "meg"
        R.id.mfl -> "mfl"
        R.id.mfr -> "mfr"
        R.id.mhx -> "mhx"
        R.id.mkx -> "mkx"
        R.id.mlb -> "mlb"
        R.id.mob -> "mob"
        R.id.mpx -> "mpx"
        R.id.mqt -> "mqt"
        R.id.mrx -> "mrx"
        R.id.mso -> "mso"
        R.id.mtr -> "mtr"
        R.id.oax -> "oax"
        R.id.okx -> "okx"
        R.id.otx -> "otx"
        R.id.oun -> "oun"
        R.id.pah -> "pah"
        R.id.pbz -> "pbz"
        R.id.pdt -> "pdt"
        R.id.phi -> "phi"
        R.id.pih -> "pih"
        R.id.pqr -> "pqr"
        R.id.psr -> "psr"
        R.id.pub -> "pub"
        R.id.rah -> "rah"
        R.id.rev -> "rev"
        R.id.riw -> "riw"
        R.id.rlx -> "rlx"
        R.id.rnk -> "rnk"
        R.id.sew -> "sew"
        R.id.sgf -> "sgf"
        R.id.sgx -> "sgx"
        R.id.shv -> "shv"
        R.id.sjt -> "sjt"
        R.id.sju -> "sju"
        R.id.slc -> "slc"
        R.id.sto -> "sto"
        R.id.tbw -> "tbw"
        R.id.tfx -> "tfx"
        R.id.tlh -> "tae"
        R.id.top -> "top"
        R.id.tsa -> "tsa"
        R.id.twc -> "twc"
        R.id.unr -> "unr"
        R.id.vef -> "vef"
        else -> ""
    }

    fun mapToSnd(id: Int): String = when (id) {
        R.id.ABQ -> "ABQ"
        R.id.ABR -> "ABR"
        R.id.ALB -> "ALB"
        R.id.AMA -> "AMA"
        R.id.APX -> "APX"
        R.id.BIS -> "BIS"
        R.id.BMX -> "BMX"
        R.id.BNA -> "BNA"
        R.id.BOI -> "BOI"
        R.id.BRO -> "BRO"
        R.id.BUF -> "BUF"
        R.id.CHH -> "CHH"
        R.id.CHS -> "CHS"
        R.id.CRP -> "CRP"
        R.id.DDC -> "DDC"
        R.id.DRT -> "DRT"
        R.id.DTX -> "DTX"
        R.id.DVN -> "DVN"
        R.id.EPZ -> "EPZ"
        R.id.FFC -> "FFC"
        R.id.FGZ -> "FGZ"
        R.id.GGW -> "GGW"
        R.id.GJT -> "GJT"
        R.id.GRB -> "GRB"
        R.id.GSO -> "GSO"
        R.id.GYX -> "GYX"
        R.id.IAD -> "IAD"
        R.id.ILN -> "ILN"
        R.id.ILX -> "ILX"
        R.id.INL -> "INL"
        R.id.JAN -> "JAN"
        R.id.JAX -> "JAX"
        R.id.KEY -> "KEY"
        R.id.LBF -> "LBF"
        R.id.LCH -> "LCH"
        R.id.LIX -> "LIX"
        R.id.LKN -> "LKN"
        R.id.LZK -> "LZK"
        R.id.MFL -> "MFL"
        R.id.MFR -> "MFR"
        R.id.MHX -> "MHX"
        R.id.MPX -> "MPX"
        R.id.NKX -> "NKX"
        R.id.OAK -> "OAK"
        R.id.OAX -> "OAX"
        R.id.OKX -> "OKX"
        R.id.OTX -> "OTX"
        R.id.OUN -> "OUN"
        R.id.PIT -> "PIT"
        R.id.RAP -> "RAP"
        R.id.REV -> "REV"
        R.id.RIW -> "RIW"
        R.id.RNK -> "RNK"
        R.id.SGF -> "SGF"
        R.id.SHV -> "SHV"
        R.id.SLC -> "SLC"
        R.id.SLE -> "SLE"
        R.id.TBW -> "TBW"
        R.id.TFX -> "TFX"
        R.id.TOP -> "TOP"
        R.id.TUS -> "TUS"
        R.id.UIL -> "UIL"
        R.id.VEF -> "VEF"
        R.id.WAL -> "WAL"
        R.id.YLW -> "YLW"
        R.id.YMO -> "YMO"
        R.id.YQI -> "YQI"
        R.id.CAR -> "CAR"
        R.id.MAF -> "MAF"
        R.id.FWD -> "FWD"
        R.id.XMR -> "XMR"
        R.id.VBG -> "VBG"
        R.id.WPL -> "WPL"
        R.id.TLH -> "TLH"
        R.id.DNR -> "DNR"
        R.id.A1Y7 -> "1Y7"
        R.id.A76526 -> "76526"
        R.id.A76458 -> "76458"
        R.id.A76405 -> "76405"
        else -> ""
    }
}
