/*

    Copyright 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024  joshua.tee@gmail.com

    This file is part of wX.

    wX is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    wX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with wX.  If not, see <http://www.gnu.org/licenses/>.

*/

package joshuatee.wx.util

import joshuatee.wx.objects.Sites

@Suppress("SpellCheckingInspection")
object SoundingSites {

    val name = mapOf(
        "1Y7" to "AZ, Yuma",
        "76225" to "MX, Chihuahua",
        "76405" to "MX, La Paz",
        "76458" to "MX, Mazatlan",
        "ABQ" to "NM, Albuquerque",
        "ABR" to "SD, Aberdeen",
        "ALB" to "NY, Albany",
        "AMA" to "TX, Amarillo",
        "APX" to "MI, Gaylord",
        "BIS" to "ND, Bismarck",
        "BMX" to "AL, Birmingham",
        "BNA" to "TN, Nashville",
        "BOI" to "ID, Boise",
        "BRO" to "TX, Brownsville",
        "BUF" to "NY, Buffalo",
        "CAR" to "ME, Caribou",
        "CHS" to "SC, Charleston",
        "CRP" to "TX, Corpus Christi",
        "DDC" to "KS, Dodge City",
        "DRT" to "TX, Del Rio",
        "DTX" to "MI, Detroit",
        "DVN" to "IA, Davenport",
        "EPZ" to "TX, El Paso",
        "FFC" to "GA, Atlanta",
        "FWD" to "TX, Dallas",
        "GGW" to "MT, Glasgow",
        "GJT" to "CO, Grand Junction",
        "GRB" to "WI, Green Bay",
        "GSO" to "NC, Greensboro",
        "GYX" to "ME, Gray",
        "IAD" to "DC, Washington",
        "ILN" to "OH, Wilmington",
        "ILX" to "IL, Lincoln",
        "INL" to "MN, International Falls",
        "JAN" to "MS, Jackson",
        "JAX" to "FL, Jacksonville",
        "KEY" to "FL, Key West",
        "LBF" to "NE, North Platte",
        "LCH" to "LA, Lake Charles",
        "LIX" to "LA, New Orleans",
        "LKN" to "NV, Elko",
        "LZK" to "AR, Little Rock",
        "MAF" to "TX, Midland",
        "MDSD" to "Dominican Republic, Santo Domingo",
        "MFL" to "FL, Miami",
        "MFR" to "OR, Medford",
        "MHX" to "NC, Morehead City",
        "MKJP" to "Jamaica, Port Royal",
        "MPX" to "MN, Twin Cities",
        "NKX" to "CA, San Diego",
        "NSTU" to "AS, Pago Pago",
        "OAK" to "CA, Oakland",
        "OAX" to "NE, Omaha",
        "OKX" to "NY, New York City",
        "OTX" to "WA, Spokane",
        "OUN" to "OK, Norman",
        "OYU" to "CAN, FIXME",
        "PABE" to "AK, Bethel",
        "PABR" to "AK, Barrow",
        "PACD" to "AK, Cold Bay",
        "PADQ" to "AK, Kodiak",
        "PAFA" to "AK, Fairbanks",
        "PAKN" to "AK, King Salmon",
        "PAMC" to "AK, McGrath",
        "PANC" to "AK, Anchorage",
        "PANT" to "AK, Annette",
        "PAOM" to "AK, Nome",
        "PAOT" to "AK, Kotzebue",
        "PASN" to "AK, St Paul Island",
        "PAYA" to "AK, Yakutat",
        "PHLI" to "HI, Lihue",
        "PHTO" to "HI, Hilo",
        "PIT" to "PA, Pittsburgh",
        "REV" to "NV, Reno",
        "RIW" to "WY, Riverton",
        "RNK" to "VA, Blacksburg",
        "SGF" to "MO, Springfield",
        "SHV" to "LA, Shreveport",
        "SLC" to "UT, Salt Lake City",
        "SLE" to "OR, Salem",
        "TBW" to "FL, Tampa Bay",
        "TFX" to "MT, Great Falls",
        "TNCC" to "Curaçao, Willemstad",
        "TOP" to "KS, Topeka",
        "TUS" to "AZ, Tucson",
        "UIL" to "WA, Quillayute",
        "UNR" to "SD, Rapid City",
        "VBG" to "CA, Vandenberg AFB",
        "VEF" to "NV, Las Vegas",
        "WAL" to "VA, Wallops Island",
        "WMW" to "CAN, QC, Maniwaki",
        "WPL" to "CAN, ON, Pickle Lake",
        "YQI" to "CAN, NS, Yarmouth",
    )

    val lat = mapOf(
        "1Y7" to "32.86",
        "76225" to "28.70",
        "76405" to "24.07",
        "76458" to "23.18",
        "ABQ" to "35.03",
        "ABR" to "45.45",
        "ALB" to "42.75",
        "AMA" to "35.23",
        "APX" to "44.90",
        "BIS" to "46.77",
        "BMX" to "33.17",
        "BNA" to "36.12",
        "BOI" to "43.57",
        "BRO" to "25.90",
        "BUF" to "42.93",
        "CAR" to "46.87",
        "CHS" to "32.90",
        "CRP" to "27.77",
        "DDC" to "37.77",
        "DRT" to "29.37",
        "DTX" to "42.68",
        "DVN" to "41.60",
        "EPZ" to "31.90",
        "FFC" to "33.36",
        "FWD" to "32.80",
        "GGW" to "48.21",
        "GJT" to "39.12",
        "GRB" to "44.48",
        "GSO" to "36.08",
        "GYX" to "43.89",
        "IAD" to "39.083667",
        "ILN" to "39.42",
        "ILX" to "40.10",
        "INL" to "48.57",
        "JAN" to "32.32",
        "JAX" to "30.43",
        "KEY" to "24.55",
        "LBF" to "41.13",
        "LCH" to "30.12",
        "LIX" to "30.337",
        "LKN" to "40.87",
        "LZK" to "34.83",
        "MAF" to "31.95",
        "MDSD" to "18.43",
        "MFL" to "25.75",
        "MFR" to "42.37",
        "MHX" to "34.70",
        "MKJP" to "17.93",
        "MPX" to "44.85",
        "NKX" to "32.73",
        "NSTU" to "14.30",
        "OAK" to "37.73",
        "OAX" to "41.32",
        "OKX" to "40.86",
        "OTX" to "47.68",
        "OUN" to "35.23",
        "OYU" to "49.68", // approx based off spc image
        "PABE" to "60.78",
        "PABR" to "71.30",
        "PACD" to "55.20",
        "PADQ" to "57.75",
        "PAFA" to "64.82",
        "PAKN" to "58.68",
        "PAMC" to "62.95",
        "PANC" to "61.17",
        "PANT" to "55.03",
        "PAOM" to "64.50",
        "PAOT" to "66.87",
        "PASN" to "57.15",
        "PAYA" to "59.52",
        "PHLI" to "21.98",
        "PHTO" to "19.72",
        "PIT" to "40.50",
        "REV" to "39.57",
        "RIW" to "43.00",
        "RNK" to "37.21",
        "SGF" to "37.14",
        "SHV" to "32.45",
        "SLC" to "40.78",
        "SLE" to "44.92",
        "TBW" to "27.70",
        "TFX" to "47.45",
        "TNCC" to "12.20",
        "TOP" to "39.07",
        "TUS" to "32.12",
        "UIL" to "47.95",
        "UNR" to "44.07",
        "VBG" to "34.72",
        "VEF" to "36.05",
        "WAL" to "37.85",
        "WMW" to "46.0",
        "WPL" to "51.47",
        "YQI" to "43.87",
    )

    val lon = mapOf(
        "1Y7" to "114.40",
        "76225" to "106.07",
        "76405" to "110.33",
        "76458" to "106.42",
        "ABQ" to "106.62",
        "ABR" to "98.41",
        "ALB" to "73.80",
        "AMA" to "101.70",
        "APX" to "84.72",
        "BIS" to "100.75",
        "BMX" to "86.77",
        "BNA" to "86.68",
        "BOI" to "116.22",
        "BRO" to "97.43",
        "BUF" to "78.73",
        "CAR" to "68.02",
        "CHS" to "80.03",
        "CRP" to "97.50",
        "DDC" to "99.97",
        "DRT" to "100.92",
        "DTX" to "83.47",
        "DVN" to "90.60",
        "EPZ" to "106.70",
        "FFC" to "84.56",
        "FWD" to "97.30",
        "GGW" to "106.63",
        "GJT" to "108.53",
        "GRB" to "88.13",
        "GSO" to "79.95",
        "GYX" to "70.25",
        "IAD" to "77.529224",
        "ILN" to "83.82",
        "ILX" to "89.30",
        "INL" to "93.38",
        "JAN" to "90.08",
        "JAX" to "81.61",
        "KEY" to "81.75",
        "LBF" to "100.68",
        "LCH" to "93.22",
        "LIX" to "89.825",
        "LKN" to "115.73",
        "LZK" to "92.25",
        "MAF" to "102.18",
        "MDSD" to "69.67",
        "MFL" to "80.38",
        "MFR" to "122.87",
        "MHX" to "76.80",
        "MKJP" to "76.78",
        "MPX" to "93.57",
        "NKX" to "117.17",
        "NSTU" to "170.70",
        "OAK" to "122.22",
        "OAX" to "96.37",
        "OKX" to "72.86",
        "OTX" to "117.63",
        "OUN" to "97.47",
        "OYU" to "83.66", // approx based off spc image
        "PABE" to "161.80",
        "PABR" to "156.78",
        "PACD" to "162.73",
        "PADQ" to "152.50",
        "PAFA" to "147.87",
        "PAKN" to "156.65",
        "PAMC" to "155.60",
        "PANC" to "150.02",
        "PANT" to "131.57",
        "PAOM" to "165.43",
        "PAOT" to "162.63",
        "PASN" to "170.22",
        "PAYA" to "139.67",
        "PHLI" to "159.35",
        "PHTO" to "155.07",
        "PIT" to "80.22",
        "REV" to "119.80",
        "RIW" to "108.50",
        "RNK" to "80.41",
        "SGF" to "93.23",
        "SHV" to "93.83",
        "SLC" to "111.97",
        "SLE" to "123.00",
        "TBW" to "82.40",
        "TFX" to "111.38",
        "TNCC" to "68.97",
        "TOP" to "95.62",
        "TUS" to "110.93",
        "UIL" to "124.55",
        "UNR" to "103.21",
        "VBG" to "120.57",
        "VEF" to "115.18",
        "WAL" to "75.48",
        "WMW" to "76.87",
        "WPL" to "90.20",
        "YQI" to "66.100",
    )

    val sites: Sites = Sites(name, lat, lon, true)
}
