/*

    Copyright 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024  joshua.tee@gmail.com

    This file is part of wX.

    wX is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    wX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with wX.  If not, see <http://www.gnu.org/licenses/>.

*/

package joshuatee.wx.spc

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Color
import android.graphics.drawable.Drawable
import joshuatee.wx.getInputStream
import joshuatee.wx.common.GlobalVariables
import joshuatee.wx.external.ExternalGifDecoder
import joshuatee.wx.util.UtilityImg
import androidx.core.graphics.drawable.toDrawable

internal object UtilitySpcCompmap {

    fun getImage(context: Context, layerString: String): Bitmap {
        val drawables = mutableListOf<Drawable>()
        val layers = layerString.split(":").dropLastWhile { it.isEmpty() }.toMutableList()
        drawables.add(Color.WHITE.toDrawable())
        if (layerString != "") {
            layers.indices.forEach {
                layers[it] = layers[it].replace("a", "")
                val gd = ExternalGifDecoder()
                gd.read(("${GlobalVariables.NWS_SPC_WEBSITE_PREFIX}/exper/compmap/" + layers[it] + ".gif").getInputStream())
                drawables.add(gd.bitmap.toDrawable(context.resources))
            }
        } else {
            val externalGifDecoder = ExternalGifDecoder()
            externalGifDecoder.read(("${GlobalVariables.NWS_SPC_WEBSITE_PREFIX}/exper/compmap/" + "basemap" + ".gif").getInputStream())
            drawables.add(externalGifDecoder.bitmap.toDrawable(context.resources))
        }
        return UtilityImg.layerDrawableToBitmap(drawables)
    }

    val labels = listOf(
        "IR satellite",
        "MAPS sea-level pressure (mb)",
        "2-meter temperature  (F)",
        "2-meter dewpoint temperature  (F)",
        "10m Wind Barbs",
        "CAPE/CINH",
        "HLCY/SHEAR",
//            "3-hr surface pressure change",
        "Boundary layer moisture (mixing ratio) convergence",
        "K-Index and Precipitable Water (inches)",
        "12-hr Total Precipitation",
        "SFC OBS MAP",
        "Lapse rates 500-850mb",
        "850 WAA/WIND",
        "700 INFO",
        "700-500 mb layer average relative humidity",
        "500 mb height and absolute vorticity (dashed) field",
        "700-500 mb Upward Vertical Velocity",
        "300mb winds",
        "DAY 1 Outlook (94O)",
        "WPC Fronts (90F)",
        "WPC 6-hr QPF (92E)"
    )

    val urlIndex = listOf(
        "16",
        "7",
        "1",
        "0",
        "8",
        "2",
        "21",
//            "3",
        "4",
        "5",
        "6",
        "9",
        "10",
        "11",
        "12",
        "13",
        "14",
        "15",
        "17",
        "18",
        "19",
        "20"
    )
}
