/*

    Copyright 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024  joshua.tee@gmail.com

    This file is part of wX.

    wX is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    wX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with wX.  If not, see <http://www.gnu.org/licenses/>.

*/

package joshuatee.wx.radar

import joshuatee.wx.external.ExternalGlobalCoordinates
import joshuatee.wx.objects.LatLon
import joshuatee.wx.util.ProjectionNumbers
import kotlin.math.*

object Projection {

    fun computeMercatorNumbers(latLon: LatLon, projectionNumbers: ProjectionNumbers): DoubleArray =
        computeMercatorNumbers(latLon.lat, latLon.lon, projectionNumbers)

    fun computeMercatorNumbers(ec: ExternalGlobalCoordinates, pn: ProjectionNumbers): DoubleArray =
        computeMercatorNumbers(ec.latitude, ec.longitude * -1.0, pn)

    fun computeMercatorNumbers(x: Double, y: Double, pn: ProjectionNumbers): DoubleArray =
        doubleArrayOf(
            (-1.0 * ((y - pn.yDbl) * pn.oneDegreeScaleFactor)) + pn.xCenter.toFloat(),
            (-1.0 * ((180.0 / PI * log(
                tan(PI / 4.0 + x * (PI / 180.0) / 2.0),
                E
            ) - 180.0 / PI * log(
                tan(PI / 4.0 + pn.xDbl * (PI / 180.0) / 2.0),
                E
            )) * pn.oneDegreeScaleFactor)) + pn.yCenter
        )

    fun computeMercatorNumbersF(x: Double, y: Double, pn: ProjectionNumbers): FloatArray =
        floatArrayOf(
            ((-1.0 * ((y - pn.yDbl) * pn.oneDegreeScaleFactor)) + pn.xCenter).toFloat(),
            ((-1.0 * ((180.0 / PI * log(
                tan(PI / 4.0 + x * (PI / 180.0) / 2.0),
                E
            ) - 180.0 / PI * log(
                tan(PI / 4.0 + pn.xDbl * (PI / 180.0) / 2.0),
                E
            )) * pn.oneDegreeScaleFactor)) + pn.yCenter).toFloat()
        )
}
