// Autogenerated from Pigeon (v21.1.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Any?

  init(code: String, message: String?, details: Any?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
      }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

/// Generated class from Pigeon that represents data sent in messages.
struct SFSafariViewControllerOptions {
  var preferredBarTintColor: Int64? = nil
  var preferredControlTintColor: Int64? = nil
  var barCollapsingEnabled: Bool? = nil
  var entersReaderIfAvailable: Bool? = nil
  var dismissButtonStyle: Int64? = nil
  var modalPresentationStyle: Int64? = nil
  var pageSheet: UISheetPresentationControllerConfiguration? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ __pigeon_list: [Any?]) -> SFSafariViewControllerOptions? {
    let preferredBarTintColor: Int64? = isNullish(__pigeon_list[0]) ? nil : (__pigeon_list[0] is Int64? ? __pigeon_list[0] as! Int64? : Int64(__pigeon_list[0] as! Int32))
    let preferredControlTintColor: Int64? = isNullish(__pigeon_list[1]) ? nil : (__pigeon_list[1] is Int64? ? __pigeon_list[1] as! Int64? : Int64(__pigeon_list[1] as! Int32))
    let barCollapsingEnabled: Bool? = nilOrValue(__pigeon_list[2])
    let entersReaderIfAvailable: Bool? = nilOrValue(__pigeon_list[3])
    let dismissButtonStyle: Int64? = isNullish(__pigeon_list[4]) ? nil : (__pigeon_list[4] is Int64? ? __pigeon_list[4] as! Int64? : Int64(__pigeon_list[4] as! Int32))
    let modalPresentationStyle: Int64? = isNullish(__pigeon_list[5]) ? nil : (__pigeon_list[5] is Int64? ? __pigeon_list[5] as! Int64? : Int64(__pigeon_list[5] as! Int32))
    let pageSheet: UISheetPresentationControllerConfiguration? = nilOrValue(__pigeon_list[6])

    return SFSafariViewControllerOptions(
      preferredBarTintColor: preferredBarTintColor,
      preferredControlTintColor: preferredControlTintColor,
      barCollapsingEnabled: barCollapsingEnabled,
      entersReaderIfAvailable: entersReaderIfAvailable,
      dismissButtonStyle: dismissButtonStyle,
      modalPresentationStyle: modalPresentationStyle,
      pageSheet: pageSheet
    )
  }
  func toList() -> [Any?] {
    return [
      preferredBarTintColor,
      preferredControlTintColor,
      barCollapsingEnabled,
      entersReaderIfAvailable,
      dismissButtonStyle,
      modalPresentationStyle,
      pageSheet,
    ]
  }
}

/// Generated class from Pigeon that represents data sent in messages.
struct UISheetPresentationControllerConfiguration {
  var detents: [String?]
  var largestUndimmedDetentIdentifier: String? = nil
  var prefersScrollingExpandsWhenScrolledToEdge: Bool? = nil
  var prefersGrabberVisible: Bool? = nil
  var prefersEdgeAttachedInCompactHeight: Bool? = nil
  var preferredCornerRadius: Double? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ __pigeon_list: [Any?]) -> UISheetPresentationControllerConfiguration? {
    let detents = __pigeon_list[0] as! [String?]
    let largestUndimmedDetentIdentifier: String? = nilOrValue(__pigeon_list[1])
    let prefersScrollingExpandsWhenScrolledToEdge: Bool? = nilOrValue(__pigeon_list[2])
    let prefersGrabberVisible: Bool? = nilOrValue(__pigeon_list[3])
    let prefersEdgeAttachedInCompactHeight: Bool? = nilOrValue(__pigeon_list[4])
    let preferredCornerRadius: Double? = nilOrValue(__pigeon_list[5])

    return UISheetPresentationControllerConfiguration(
      detents: detents,
      largestUndimmedDetentIdentifier: largestUndimmedDetentIdentifier,
      prefersScrollingExpandsWhenScrolledToEdge: prefersScrollingExpandsWhenScrolledToEdge,
      prefersGrabberVisible: prefersGrabberVisible,
      prefersEdgeAttachedInCompactHeight: prefersEdgeAttachedInCompactHeight,
      preferredCornerRadius: preferredCornerRadius
    )
  }
  func toList() -> [Any?] {
    return [
      detents,
      largestUndimmedDetentIdentifier,
      prefersScrollingExpandsWhenScrolledToEdge,
      prefersGrabberVisible,
      prefersEdgeAttachedInCompactHeight,
      preferredCornerRadius,
    ]
  }
}
private class messagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      return SFSafariViewControllerOptions.fromList(self.readValue() as! [Any?])
    case 130:
      return UISheetPresentationControllerConfiguration.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class messagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? SFSafariViewControllerOptions {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else if let value = value as? UISheetPresentationControllerConfiguration {
      super.writeByte(130)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class messagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return messagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return messagesPigeonCodecWriter(data: data)
  }
}

class messagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = messagesPigeonCodec(readerWriter: messagesPigeonCodecReaderWriter())
}


/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol CustomTabsApi {
  func launchURL(_ urlString: String, prefersDeepLink: Bool, options: SFSafariViewControllerOptions?, completion: @escaping (Result<Void, Error>) -> Void)
  func closeAllIfPossible(completion: @escaping (Result<Void, Error>) -> Void)
  func mayLaunchURLs(_ urlStrings: [String?]) throws -> String?
  func invalidateSession(_ sessionId: String) throws
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class CustomTabsApiSetup {
  static var codec: FlutterStandardMessageCodec { messagesPigeonCodec.shared }
  /// Sets up an instance of `CustomTabsApi` to handle messages through the `binaryMessenger`.
  static func setUp(binaryMessenger: FlutterBinaryMessenger, api: CustomTabsApi?, messageChannelSuffix: String = "") {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    let launchChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.launch\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      launchChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let urlStringArg = args[0] as! String
        let prefersDeepLinkArg = args[1] as! Bool
        let optionsArg: SFSafariViewControllerOptions? = nilOrValue(args[2])
        api.launchURL(urlStringArg, prefersDeepLink: prefersDeepLinkArg, options: optionsArg) { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      launchChannel.setMessageHandler(nil)
    }
    let closeAllIfPossibleChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.closeAllIfPossible\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      closeAllIfPossibleChannel.setMessageHandler { _, reply in
        api.closeAllIfPossible { result in
          switch result {
          case .success:
            reply(wrapResult(nil))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      closeAllIfPossibleChannel.setMessageHandler(nil)
    }
    let mayLaunchChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.mayLaunch\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      mayLaunchChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let urlStringsArg = args[0] as! [String?]
        do {
          let result = try api.mayLaunchURLs(urlStringsArg)
          reply(wrapResult(result))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      mayLaunchChannel.setMessageHandler(nil)
    }
    let invalidateChannel = FlutterBasicMessageChannel(name: "dev.flutter.pigeon.flutter_custom_tabs_ios.CustomTabsApi.invalidate\(channelSuffix)", binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      invalidateChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let sessionIdArg = args[0] as! String
        do {
          try api.invalidateSession(sessionIdArg)
          reply(wrapResult(nil))
        } catch {
          reply(wrapError(error))
        }
      }
    } else {
      invalidateChannel.setMessageHandler(nil)
    }
  }
}
