/*
*   it.rgp.nyagua.pafcalc.PAFCalc - Planted Aquarium Fertilizer Calculator
*   Copyright (C) 2013 Rudi Giacomini Pilon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*/

/*
 * This calculator is heavily based on flores' yanc (Yet Another Nutrient Calculator)
 * at http://calc.petalphile.com/ shared as Open Source.
 * Thanks to mr. Flores for this concept piece.
 *
 */

package it.rgp.nyagua.pafcalc.util;

import android.widget.TextView;

/**
 * Created by Rudi Giacomini Pilon on 27/11/13.
 */
public class tools {
    /**
     * Check a  text fields and return false
     * if it is empty or zero
     *
     * @param jtf  [array of Strings from text fields to check]
     * @return [false if empty or zero otherwise true]
     */
    public static boolean CheckTextFields(TextView[] jtf){
        for (TextView aJtf : jtf) {
            if (aJtf.getText().toString().isEmpty()) {//if any is empty
                return false;
            } else if (aJtf.getText().toString().equalsIgnoreCase("0")) {//if any is zero
                return false;
            }
        }
        return true;
    }

    /**
     * Clean an array of TextFields
     * @param jtf   array of text fields
     */
    public static void CleanTextFields(TextView[] jtf){
        for (TextView aJtf : jtf) {
            aJtf.setText("");//NOI18N
        }
    }


}
