/*
*   it.rgp.nyagua.pafcalc.PAFCalc - Planted Aquarium Fertilizer Calculator
*   Copyright (C) 2013 Rudi Giacomini Pilon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*/

/*
 * This calculator is heavily based on flores' yanc (Yet Another Nutrient Calculator)
 * at http://calc.petalphile.com/ shared as Open Source.
 * Thanks to mr. Flores for this concept piece.
 *
 */
package it.rgp.nyagua.pafcalc;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

public class AboutActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_about);
        TextView msgTV=(TextView)findViewById(R.id.textView);
        //get version
        Context context = getApplicationContext();
        PackageManager packageManager;
        if (context != null) packageManager = context.getPackageManager();
        else packageManager = null;
        String packageName = null;
        if (context != null) {
            packageName = context.getPackageName();
        }
        String myVersionName = "not available";
        try {
            if (packageManager != null) {
                myVersionName = packageManager.getPackageInfo(packageName, 0).versionName;
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        //get name
        String appName=getString(R.string.app_name);
        String home=getString(R.string.nyagua_pafcalc_home);

        String msg="<html> <h1 align=center>"+appName// NOI18N
                +"</h1><h3 align=center> v." + myVersionName// NOI18N
                + "</h3><h4 align=center> <a href='" + home +"'>"// NOI18N
                + home + "</a>"// NOI18N
                + "</h4><p align=center><i>"// NOI18N
                + "<br>by Rudi Giacomini Pilon - 2009-2013</i></p>" +
                "</br> </br> <p align=center>" +
                "This program is distributed under GNU GPL v.2 license, for free, as it is, " +
                "without any warranty implicit and explicit.<7br>" +
                "See on-line license at <a href='http://www.gnu.org/licenses/gpl-2.0.html'> " +
                "http://www.gnu.org/licenses/gpl-2.0.html</a>  for details." +
                "</p></html>";// NOI18N

        msgTV.setText(Html.fromHtml(msg));
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.about, menu);
         try {
             getActionBar().setDisplayHomeAsUpEnabled(true);
         } finally {
             Log.d("PAFCalc","error in getActionBar up event");
         }

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                // http://developer.android.com/design/patterns/navigation.html#up-vs-back
                //
                //NavUtils.navigateUpFromSameTask(this);
                super.onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
