<!--
 ~ SPDX-FileCopyrightText: 2015-2024 Nextcloud GmbH and Nextcloud contributors
 ~ SPDX-FileCopyrightText: 2015-2024 Stefan Niedermann <info@niedermann.it>
 ~ SPDX-License-Identifier: GPL-3.0-or-later
-->
# Nextcloud Notes for Android

An android client for [Nextcloud Notes App](https://github.com/nextcloud/notes/).

[![Android CI](https://github.com/nextcloud/notes-android/actions/workflows/android.yml/badge.svg)](https://github.com/nextcloud/notes-android/actions/workflows/android.yml)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/997fa10faefe4904b7bdf730734f151a)](https://app.codacy.com/gh/nextcloud/notes-android/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade)
[![GitHub issues](https://img.shields.io/github/issues/nextcloud/notes-android.svg)](https://github.com/nextcloud/notes-android/issues)
[![GitHub stars](https://img.shields.io/github/stars/nextcloud/notes-android.svg)](https://github.com/nextcloud/notes-android/stargazers)
[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![REUSE status](https://api.reuse.software/badge/github.com/nextcloud/notes-android)](https://api.reuse.software/info/github.com/nextcloud/notes-android)

## :arrow_forward: Access

[![Latest Release](https://img.shields.io/github/v/tag/nextcloud/notes-android?label=latest+release&sort=semver)](https://github.com/nextcloud/notes-android/tags)
[![F-Droid Release](https://img.shields.io/f-droid/v/it.niedermann.owncloud.notes)](https://f-droid.org/de/packages/it.niedermann.owncloud.notes/)

[<img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png"
      alt="Get it on Play Store"
      height="80">](https://play.google.com/store/apps/details?id=it.niedermann.owncloud.notes)
[<img src="https://f-droid.org/badge/get-it-on.png"
      alt="Get it on F-Droid"
      height="80">](https://f-droid.org/repository/browse/?fdid=it.niedermann.owncloud.notes)

## :eyes: Screenshots

| _ | _ | _ |
| :--: | :--: | :--: |
| ![Screenshot of list view](/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png) | ![Screenshot of edit mode](/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png) | ![Screenshot of preview](/fastlane/metadata/android/en-US/images/phoneScreenshots/4.png) |

## :rocket: Features

  * Multiple accounts
  * List, create, edit, share, search and delete notes
  * Share text and links as new note into the app
  * Toggling checkboxes in view mode
  * Mark notes as favorite
  * Bulk delete
  * In-note search
  * Single note widget and note list widget
  * Dark Mode
  * Render Markdown (using [Markwon](https://noties.io/Markwon))
  * Translated in many languages on [Transifex](https://app.transifex.com/nextcloud/nextcloud/android-notes/)
  * Context based formatting ([#363](https://github.com/nextcloud/notes-android/issues/363))
  * App-lock ([#354](https://github.com/nextcloud/notes-android/issues/354))

## :checkered_flag: Roadmap

  * We usually focus on [pinned issues](https://github.com/nextcloud/notes-android/issues) in our issue tracker

## :family: Join the team

  * Test the app with different devices
  * Report issues in the [issue tracker](https://github.com/nextcloud/notes-android/issues)
  * [Pick a good first issue](https://github.com/nextcloud/notes-android/labels/Good%20first%20issue) :notebook:
  * Create a [Pull Request](https://opensource.guide/how-to-contribute/#opening-a-pull-request)
  * Help translating this app on [Transifex](https://app.transifex.com/nextcloud/nextcloud/android-notes/) 🌎

## :link: Requirements

  * [Nextcloud Server](https://nextcloud.com/)
  * [Nextcloud Notes Server App](https://github.com/nextcloud/notes)
  * [Nextcloud Files Android App](https://github.com/nextcloud/android)

## :notebook: License

This project is licensed under the [GNU GENERAL PUBLIC LICENSE](/LICENSE).
