package it.niedermann.nextcloud.deck.ui.stack;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import it.niedermann.nextcloud.deck.R;
import it.niedermann.nextcloud.deck.ui.theme.DeleteAlertDialogBuilder;
import it.niedermann.nextcloud.deck.ui.theme.ThemedDialogFragment;

public class DeleteStackDialogFragment extends ThemedDialogFragment {

    private static final String KEY_ACCOUNT_ID = "account_id";
    private static final String KEY_BOARD_ID = "board_id";
    private static final String KEY_STACK_ID = "stack_id";
    private static final String KEY_NUMBER_CARDS = "number_cards";

    private DeleteStackListener deleteStackListener;
    private long accountId;
    private long boardId;
    private long stackId;
    private int numberCards;

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        if (context instanceof DeleteStackListener) {
            this.deleteStackListener = (DeleteStackListener) context;
        } else {
            throw new ClassCastException("Caller must implement " + DeleteStackListener.class.getCanonicalName());
        }

        final Bundle args = getArguments();

        if (args == null || !args.containsKey(KEY_ACCOUNT_ID) || !args.containsKey(KEY_BOARD_ID) || !args.containsKey(KEY_STACK_ID) || !args.containsKey(KEY_NUMBER_CARDS)) {
            throw new IllegalArgumentException("Please provide at least " + KEY_ACCOUNT_ID + ", " + KEY_BOARD_ID + ", " + KEY_STACK_ID + " and " + KEY_NUMBER_CARDS + " as arguments");
        }

        this.accountId = args.getLong(KEY_ACCOUNT_ID);
        this.boardId = args.getLong(KEY_BOARD_ID);
        this.stackId = args.getLong(KEY_STACK_ID);
        this.numberCards = args.getInt(KEY_NUMBER_CARDS);
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return new DeleteAlertDialogBuilder(requireContext())
                .setTitle(R.string.delete_list)
                .setMessage(getResources().getQuantityString(R.plurals.do_you_want_to_delete_the_current_list, numberCards, numberCards))
                .setPositiveButton(R.string.simple_delete, (dialog, whichButton) -> deleteStackListener.onDeleteStack(accountId, boardId, stackId))
                .setNeutralButton(android.R.string.cancel, null)
                .create();
    }

    @Override
    public void applyTheme(int color) {

    }

    public static DialogFragment newInstance(long accountId, long boardId, long stackId, int numberCards) {
        final var dialog = new DeleteStackDialogFragment();

        final var args = new Bundle();
        args.putLong(KEY_ACCOUNT_ID, accountId);
        args.putLong(KEY_BOARD_ID, boardId);
        args.putLong(KEY_STACK_ID, stackId);
        args.putInt(KEY_NUMBER_CARDS, numberCards);
        dialog.setArguments(args);

        return dialog;
    }
}
